/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;

public class BlockTokenSecretManager
extends SecretManager<BlockTokenIdentifier> {
    public static final Log LOG = LogFactory.getLog(BlockTokenSecretManager.class);
    public static final Token<BlockTokenIdentifier> DUMMY_TOKEN = new Token();
    private final boolean isMaster;
    private final long keyUpdateInterval;
    private volatile long tokenLifetime;
    private int serialNo = new SecureRandom().nextInt();
    private BlockKey currentKey;
    private BlockKey nextKey;
    private Map<Integer, BlockKey> allKeys;

    public BlockTokenSecretManager(boolean isMaster, long keyUpdateInterval, long tokenLifetime) throws IOException {
        this.isMaster = isMaster;
        this.keyUpdateInterval = keyUpdateInterval;
        this.tokenLifetime = tokenLifetime;
        this.allKeys = new HashMap<Integer, BlockKey>();
        this.generateKeys();
    }

    private synchronized void generateKeys() {
        if (!this.isMaster) {
            return;
        }
        ++this.serialNo;
        this.currentKey = new BlockKey(this.serialNo, System.currentTimeMillis() + 2L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret());
        ++this.serialNo;
        this.nextKey = new BlockKey(this.serialNo, System.currentTimeMillis() + 3L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret());
        this.allKeys.put(this.currentKey.getKeyId(), this.currentKey);
        this.allKeys.put(this.nextKey.getKeyId(), this.nextKey);
    }

    public synchronized ExportedBlockKeys exportKeys() {
        if (!this.isMaster) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Exporting access keys");
        }
        return new ExportedBlockKeys(true, this.keyUpdateInterval, this.tokenLifetime, this.currentKey, this.allKeys.values().toArray(new BlockKey[0]));
    }

    private synchronized void removeExpiredKeys() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<Integer, BlockKey>> it = this.allKeys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, BlockKey> e = it.next();
            if (e.getValue().getExpiryDate() >= now) continue;
            it.remove();
        }
    }

    public synchronized void setKeys(ExportedBlockKeys exportedKeys) throws IOException {
        if (this.isMaster || exportedKeys == null) {
            return;
        }
        LOG.info((Object)"Setting block keys");
        this.removeExpiredKeys();
        this.currentKey = exportedKeys.getCurrentKey();
        BlockKey[] receivedKeys = exportedKeys.getAllKeys();
        for (int i = 0; i < receivedKeys.length; ++i) {
            if (receivedKeys[i] == null) continue;
            this.allKeys.put(receivedKeys[i].getKeyId(), receivedKeys[i]);
        }
    }

    public synchronized void updateKeys() throws IOException {
        if (!this.isMaster) {
            return;
        }
        LOG.info((Object)"Updating block keys");
        this.removeExpiredKeys();
        this.allKeys.put(this.currentKey.getKeyId(), new BlockKey(this.currentKey.getKeyId(), System.currentTimeMillis() + this.keyUpdateInterval + this.tokenLifetime, this.currentKey.getKey()));
        this.currentKey = new BlockKey(this.nextKey.getKeyId(), System.currentTimeMillis() + 2L * this.keyUpdateInterval + this.tokenLifetime, this.nextKey.getKey());
        this.allKeys.put(this.currentKey.getKeyId(), this.currentKey);
        ++this.serialNo;
        this.nextKey = new BlockKey(this.serialNo, System.currentTimeMillis() + 3L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret());
        this.allKeys.put(this.nextKey.getKeyId(), this.nextKey);
    }

    public Token<BlockTokenIdentifier> generateToken(Block block, EnumSet<AccessMode> modes) throws IOException {
        return this.generateToken(new long[]{block.getBlockId()}, modes);
    }

    public Token<BlockTokenIdentifier> generateToken(String userId, Block block, EnumSet<AccessMode> modes) throws IOException {
        return this.generateToken(userId, new long[]{block.getBlockId()}, modes);
    }

    public Token<BlockTokenIdentifier> generateToken(long[] blockIds, EnumSet<AccessMode> modes) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String userID = ugi == null ? null : ugi.getShortUserName();
        return this.generateToken(userID, blockIds, modes);
    }

    public Token<BlockTokenIdentifier> generateToken(String userID, long[] blockIds, EnumSet<AccessMode> modes) {
        BlockTokenIdentifier id = new BlockTokenIdentifier(userID, blockIds, modes);
        return new Token<BlockTokenIdentifier>(id, this);
    }

    public void checkAccess(BlockTokenIdentifier id, String userId, Block block, AccessMode mode) throws SecretManager.InvalidToken {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking access for user=" + userId + ", block=" + block + ", access mode=" + (Object)((Object)mode) + " using " + id.toString()));
        }
        if (userId != null && !userId.equals(id.getUserId())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't belong to user " + userId);
        }
        if (!id.isBlockIncluded(block.getBlockId())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't apply to block " + block);
        }
        if (BlockTokenSecretManager.isExpired(id.getExpiryDate())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " is expired.");
        }
        if (!id.getAccessModes().contains((Object)mode)) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't have " + (Object)((Object)mode) + " permission");
        }
    }

    public void checkAccess(Token<BlockTokenIdentifier> token, String userId, Block block, AccessMode mode) throws SecretManager.InvalidToken {
        BlockTokenIdentifier id = new BlockTokenIdentifier();
        try {
            id.readFields(new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        }
        catch (IOException e) {
            throw new SecretManager.InvalidToken("Unable to de-serialize block token identifier for user=" + userId + ", block=" + block + ", access mode=" + (Object)((Object)mode));
        }
        this.checkAccess(id, userId, block, mode);
        if (!Arrays.equals(this.retrievePassword(id), token.getPassword())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't have the correct token password");
        }
    }

    private static boolean isExpired(long expiryDate) {
        return System.currentTimeMillis() > expiryDate;
    }

    static boolean isTokenExpired(Token<BlockTokenIdentifier> token) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        long expiryDate = WritableUtils.readVLong(in);
        return BlockTokenSecretManager.isExpired(expiryDate);
    }

    public void setTokenLifetime(long tokenLifetime) {
        this.tokenLifetime = tokenLifetime;
    }

    @Override
    public BlockTokenIdentifier createIdentifier() {
        return new BlockTokenIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] createPassword(BlockTokenIdentifier identifier) {
        BlockKey key = null;
        BlockTokenSecretManager blockTokenSecretManager = this;
        synchronized (blockTokenSecretManager) {
            key = this.currentKey;
        }
        if (key == null) {
            throw new IllegalStateException("currentKey hasn't been initialized.");
        }
        identifier.setExpiryDate(System.currentTimeMillis() + this.tokenLifetime);
        identifier.setKeyId(key.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generating block token for " + identifier.toString()));
        }
        return BlockTokenSecretManager.createPassword(identifier.getBytes(), key.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] retrievePassword(BlockTokenIdentifier identifier) throws SecretManager.InvalidToken {
        if (BlockTokenSecretManager.isExpired(identifier.getExpiryDate())) {
            throw new SecretManager.InvalidToken("Block token with " + identifier.toString() + " is expired.");
        }
        BlockKey key = null;
        BlockTokenSecretManager blockTokenSecretManager = this;
        synchronized (blockTokenSecretManager) {
            key = this.allKeys.get(identifier.getKeyId());
        }
        if (key == null) {
            throw new SecretManager.InvalidToken("Can't re-compute password for " + identifier.toString() + ", since the required block key (keyID=" + identifier.getKeyId() + ") doesn't exist.");
        }
        return BlockTokenSecretManager.createPassword(identifier.getBytes(), key.getKey());
    }

    public static enum AccessMode {
        READ,
        WRITE,
        COPY,
        REPLACE;

    }
}

