/*
 * Port of listen-and-print.c using libindicate-qt
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: LGPL v2.1 or LGPL v3
 */
#include <QDebug>
#include <QImage>
#include <QTime>

#include "qindicatedecode.h"

#include "qlisten-and-print.h"

void Controller::slotServerAdded(QIndicate::Listener::Server* server, const QString& type)
{
    qDebug() << __FUNCTION__ << type;
}

void Controller::slotServerRemoved(QIndicate::Listener::Server* server, const QString& type)
{
    qDebug() << __FUNCTION__ << type;
}

void Controller::slotIndicatorAdded(QIndicate::Listener::Server* server, QIndicate::Listener::Indicator* indicator)
{
    qDebug() << __FUNCTION__;
}

void Controller::slotIndicatorRemoved(QIndicate::Listener::Server* server, QIndicate::Listener::Indicator* indicator)
{
    qDebug() << __FUNCTION__;
}

void Controller::slotIndicatorModified(QIndicate::Listener::Server* server, QIndicate::Listener::Indicator* indicator, const QString& key)
{
    qDebug() << __FUNCTION__ << key;
    showProperty(server, indicator, key);
}

void Controller::showProperty(QIndicate::Listener::Server* server, QIndicate::Listener::Indicator* indicator, const QString& key)
{
    mListener->getIndicatorProperty(server, indicator, key,
        this,
        SLOT(doShowProperty(QIndicate::Listener::Server*, QIndicate::Listener::Indicator*, const QString&, const QByteArray&))
        );
}

void Controller::doShowProperty(QIndicate::Listener::Server* server, QIndicate::Listener::Indicator* indicator, const QString& key, const QByteArray& value)
{
    qDebug() << "Property" << key;
    if (key == "time") {
        qDebug() << "  " << QIndicate::Decode::dateTimeFromValue(value);
    } else if (key == "icon") {
        QImage image = QIndicate::Decode::imageFromValue(value);
        qDebug() << "  size:" << image.size() << "depth:" << image.depth();
    } else {
        qDebug() << "  " << QIndicate::Decode::stringFromValue(value);
    }
}

int main(int argc, char ** argv)
{
    QApplication app(argc, argv);

    Controller controller;

    QIndicate::Listener* listener = QIndicate::Listener::defaultInstance();
    controller.mListener = listener;

    QObject::connect(
        listener, SIGNAL(indicatorAdded(QIndicate::Listener::Server*, QIndicate::Listener::Indicator*)),
        &controller, SLOT(slotIndicatorAdded(QIndicate::Listener::Server*, QIndicate::Listener::Indicator*))
        );
    QObject::connect(
        listener, SIGNAL(indicatorRemoved(QIndicate::Listener::Server*, QIndicate::Listener::Indicator*)),
        &controller, SLOT(slotIndicatorRemoved(QIndicate::Listener::Server*, QIndicate::Listener::Indicator*))
        );
    QObject::connect(
        listener, SIGNAL(indicatorModified(QIndicate::Listener::Server*, QIndicate::Listener::Indicator*, const QString&)),
        &controller, SLOT(slotIndicatorModified(QIndicate::Listener::Server*, QIndicate::Listener::Indicator*, const QString&))
        );

    QObject::connect(
        listener, SIGNAL(serverAdded(QIndicate::Listener::Server*, const QString&)),
        &controller, SLOT(slotServerAdded(QIndicate::Listener::Server*, const QString&))
        );

    QObject::connect(
        listener, SIGNAL(serverRemoved(QIndicate::Listener::Server*, const QString&)),
        &controller, SLOT(slotServerRemoved(QIndicate::Listener::Server*, const QString&))
        );

    return app.exec();
}

#include "qlisten-and-print.moc"
