#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

static void
on_raise_callback (UnityWebappsContext *context, const gchar *file, gpointer user_data)
{
  printf("Callback! \n");
  uwa_emit_test_finished ();
}

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  unity_webapps_indicator_show_indicator (context, "Raise callback test");
  unity_webapps_context_on_raise_callback (context, on_raise_callback, NULL);
  
  printf("Activate the Callback test application (not the indicator) from your messaging menu \n");
  
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service,
                             "TestIndicatorRaiseCallback",
                             "test.ts",
                             ICON_URL,
                             NULL,
                             context_ready,
                             NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
