/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AbstractDrawing;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.QuadTree;
import org.jhotdraw.util.ReversedList;

public class QuadTreeDrawing
extends AbstractDrawing {
    private QuadTree<Figure> quadTree = new QuadTree();
    private boolean needsSorting = false;

    @Override
    public int indexOf(Figure figure) {
        return this.children.indexOf(figure);
    }

    @Override
    public void basicAdd(int n, Figure figure) {
        super.basicAdd(n, figure);
        this.quadTree.add(figure, figure.getDrawingArea());
        this.needsSorting = true;
    }

    @Override
    public Figure basicRemoveChild(int n) {
        Figure figure = this.getChild(n);
        this.quadTree.remove(figure);
        this.needsSorting = true;
        super.basicRemoveChild(n);
        return figure;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            Collection<Figure> collection = this.quadTree.findIntersects(rectangle);
            List<Figure> list = this.sort(collection);
            this.draw(graphics2D, list);
        } else {
            this.draw(graphics2D, this.children);
        }
    }

    @Override
    public List<Figure> sort(Collection<? extends Figure> collection) {
        this.ensureSorted();
        ArrayList<Figure> arrayList = new ArrayList<Figure>(collection.size());
        for (Figure figure : this.children) {
            if (!collection.contains(figure)) continue;
            arrayList.add(figure);
        }
        return arrayList;
    }

    public void draw(Graphics2D graphics2D, Collection<Figure> collection) {
        for (Figure figure : collection) {
            if (!figure.isVisible()) continue;
            figure.draw(graphics2D);
        }
    }

    public List<Figure> getChildren(Rectangle2D.Double double_) {
        return new LinkedList<Figure>(this.quadTree.findInside(double_));
    }

    @Override
    public List<Figure> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public Figure findFigureInside(Point2D.Double double_) {
        Collection<Figure> collection = this.quadTree.findContains(double_);
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (!collection.contains(figure) || !figure.contains(double_)) continue;
            return figure.findFigureInside(double_);
        }
        return null;
    }

    @Override
    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.children);
    }

    @Override
    public Figure findFigure(Point2D.Double double_) {
        Collection<Figure> collection = this.quadTree.findContains(double_);
        switch (collection.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure figure = collection.iterator().next();
                return figure.contains(double_) ? figure : null;
            }
        }
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (!collection.contains(figure) || !figure.contains(double_)) continue;
            return figure;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double double_, Figure figure) {
        Collection<Figure> collection = this.quadTree.findContains(double_);
        switch (collection.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure figure2 = collection.iterator().next();
                return figure2 == figure || !figure2.contains(double_) ? null : figure2;
            }
        }
        for (Figure figure3 : this.getFiguresFrontToBack()) {
            if (figure3 == figure || !figure3.contains(double_)) continue;
            return figure3;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double double_, Collection<? extends Figure> collection) {
        Collection<Figure> collection2 = this.quadTree.findContains(double_);
        switch (collection2.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure figure = collection2.iterator().next();
                return !collection.contains(figure) || !figure.contains(double_) ? null : figure;
            }
        }
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (collection.contains(figure) || !figure.contains(double_)) continue;
            return figure;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double double_, Figure figure) {
        boolean bl = false;
        for (Figure figure2 : this.getFiguresFrontToBack()) {
            if (bl) {
                if (!figure2.isVisible() || !figure2.contains(double_)) continue;
                return figure2;
            }
            bl = figure == figure2;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double double_, Collection<? extends Figure> collection) {
        int n = collection.size();
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (n == 0) {
                if (!figure.isVisible() || !figure.contains(double_)) continue;
                return figure;
            }
            if (!collection.contains(figure)) continue;
            --n;
        }
        return null;
    }

    @Override
    public List<Figure> findFigures(Rectangle2D.Double double_) {
        LinkedList<Figure> linkedList = new LinkedList<Figure>(this.quadTree.findIntersects(double_));
        switch (linkedList.size()) {
            case 0: 
            case 1: {
                return linkedList;
            }
        }
        return this.sort(linkedList);
    }

    @Override
    public List<Figure> findFiguresWithin(Rectangle2D.Double double_) {
        LinkedList<Figure> linkedList = new LinkedList<Figure>();
        for (Figure figure : this.children) {
            Rectangle2D.Double double_2 = figure.getBounds();
            if (figure.get(AttributeKeys.TRANSFORM) != null) {
                Rectangle2D rectangle2D = figure.get(AttributeKeys.TRANSFORM).createTransformedShape(double_2).getBounds2D();
                Rectangle2D.Double double_3 = double_2 = rectangle2D instanceof Rectangle2D.Double ? (Rectangle2D.Double)rectangle2D : new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            if (!figure.isVisible() || !Geom.contains(double_, double_2)) continue;
            linkedList.add(figure);
        }
        return linkedList;
    }

    @Override
    public void bringToFront(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public void sendToBack(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(0, figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawingArea());
        }
    }

    @Override
    public boolean contains(Figure figure) {
        return this.children.contains(figure);
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.children, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }

    protected void setAttributeOnChildren(AttributeKey attributeKey, Object object) {
    }

    @Override
    public QuadTreeDrawing clone() {
        QuadTreeDrawing quadTreeDrawing = (QuadTreeDrawing)super.clone();
        quadTreeDrawing.quadTree = new QuadTree();
        for (Figure figure : this.getChildren()) {
            this.quadTree.add(figure, figure.getDrawingArea());
        }
        return quadTreeDrawing;
    }

    @Override
    protected AbstractCompositeFigure.EventHandler createEventHandler() {
        return new QuadTreeEventHandler();
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
    }

    protected class QuadTreeEventHandler
    extends AbstractCompositeFigure.EventHandler {
        protected QuadTreeEventHandler() {
        }

        @Override
        public void figureChanged(FigureEvent figureEvent) {
            QuadTreeDrawing.this.quadTree.remove(figureEvent.getFigure());
            QuadTreeDrawing.this.quadTree.add(figureEvent.getFigure(), figureEvent.getFigure().getDrawingArea());
            QuadTreeDrawing.this.needsSorting = true;
            QuadTreeDrawing.this.invalidate();
            QuadTreeDrawing.this.fireAreaInvalidated(figureEvent.getInvalidatedArea());
        }
    }
}

