/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.gui.event.SelectionComponentDisplayer;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.util.ResourceBundleUtil;

public class ArrangeToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;

    public ArrangeToolBar() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(resourceBundleUtil.getString(this.getID() + ".toolbar"));
    }

    @Override
    public void setEditor(DrawingEditor drawingEditor) {
        DrawingEditor drawingEditor2 = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(drawingEditor);
        if (drawingEditor != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
            this.displayer.setVisibleIfCreationTool(false);
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 1: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                AbstractSelectedAction abstractSelectedAction = new BringToFrontAction(this.editor);
                JButton jButton = new JButton(abstractSelectedAction);
                this.disposables.add(abstractSelectedAction);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.setText(null);
                resourceBundleUtil.configureToolBarButton(jButton, BringToFrontAction.ID);
                jButton.putClientProperty("hideActionText", Boolean.TRUE);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 13;
                jPanel.add((Component)jButton, gridBagConstraints);
                abstractSelectedAction = new SendToBackAction(this.editor);
                jButton = new JButton(abstractSelectedAction);
                this.disposables.add(abstractSelectedAction);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                jButton.setText(null);
                resourceBundleUtil.configureToolBarButton(jButton, SendToBackAction.ID);
                jButton.putClientProperty("hideActionText", Boolean.TRUE);
                jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                gridBagConstraints.anchor = 11;
                gridBagConstraints.weighty = 1.0;
                jPanel.add((Component)jButton, gridBagConstraints);
            }
        }
        return jPanel;
    }

    private void initComponents() {
        this.setOpaque(false);
    }

    @Override
    protected String getID() {
        return "arrange";
    }
}

