#!/bin/sh
#  Author: Jamie Strandboge <jamie@ubuntu.com>
#  Copyright (C) 2015 Canonical Ltd.
#
#  This script is distributed under the terms and conditions of the GNU General
#  Public License, Version 3 or later. See http://www.gnu.org/copyleft/gpl.html
#  for details.

set -e

script=`realpath "$0"`
topdir=`dirname "$script"`
aa_dir="$topdir/../data/apparmor"
sc_dir="$topdir/../data/seccomp"

err=
for dir in "$aa_dir" "$sc_dir" ; do
    cd "$dir"
    find . \( -type f -o -type l \) -print | sed 's#^\./##' | sort | while read f ; do
        rel_f="`basename $f`"
        echo "Checking `basename $dir`/$f"

        # make sure the name is formatted correctly. Importantly, '_' should
        # never be in the name since it might conflict with snappy
        # framework-policy
        if ! echo "$rel_f" | egrep -q '^[a-zA-Z0-9-]+$' ; then
            echo "ERROR: Malformed name: '$rel_f'"
            err="yes"
        fi

        # Make sure all files have the required metadata
        for search in '# Description: ' '# Usage: (common|reserved)' ; do
            if ! egrep -q "^$search" "$f" ; then
                echo "ERROR: could not find '$search'"
                err="yes"
            fi
        done
    done
done

if [ "$err" = "yes" ]; then
    exit 1
fi
