/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ksh" locale.
 */
public class LocalizedNamesImpl_ksh extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AR",
        "EG",
        "EC",
        "AL",
        "CI",
        "DZ",
        "SV",
        "VI",
        "AS",
        "AD",
        "AI",
        "AO",
        "AG",
        "GQ",
        "ER",
        "AM",
        "AW",
        "AC",
        "AZ",
        "EE",
        "ET",
        "AU",
        "BH",
        "BS",
        "BD",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "MM",
        "BO",
        "BA",
        "BW",
        "BR",
        "IO",
        "VG",
        "BN",
        "BF",
        "BG",
        "BI",
        "BT",
        "BV",
        "DK",
        "SJ",
        "HM",
        "MP",
        "SB",
        "UM",
        "BL",
        "DG",
        "DM",
        "DO",
        "DE",
        "DJ",
        "BB",
        "IM",
        "EU",
        "FK",
        "FO",
        "PH",
        "FI",
        "FJ",
        "FR",
        "TF",
        "GF",
        "PF",
        "HT",
        "HN",
        "HK",
        "IN",
        "ID",
        "IQ",
        "IE",
        "IS",
        "IL",
        "IT",
        "GH",
        "GA",
        "GM",
        "JM",
        "YE",
        "JP",
        "GE",
        "GI",
        "GN",
        "GW",
        "GG",
        "JE",
        "JO",
        "GD",
        "GR",
        "GL",
        "GB",
        "GP",
        "GU",
        "GY",
        "GT",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "KZ",
        "QA",
        "KE",
        "KI",
        "KG",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "HR",
        "CU",
        "CK",
        "KW",
        "LA",
        "LV",
        "LS",
        "LB",
        "LY",
        "LR",
        "LI",
        "LT",
        "LU",
        "ML",
        "MH",
        "MQ",
        "MG",
        "YT",
        "MO",
        "MY",
        "MW",
        "MV",
        "MT",
        "MA",
        "MU",
        "MR",
        "MK",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "ME",
        "MZ",
        "NA",
        "NR",
        "NL",
        "AN",
        "NP",
        "NC",
        "NZ",
        "NE",
        "NG",
        "NI",
        "NU",
        "KP",
        "NF",
        "NO",
        "AX",
        "OM",
        "AT",
        "TL",
        "QO",
        "PK",
        "PS",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "IR",
        "PN",
        "PT",
        "PR",
        "PL",
        "RE",
        "RO",
        "RW",
        "RU",
        "ZM",
        "WS",
        "SM",
        "SA",
        "CL",
        "CN",
        "ES",
        "SE",
        "CH",
        "SC",
        "SN",
        "RS",
        "ZW",
        "SG",
        "SH",
        "MF",
        "SL",
        "ZA",
        "GS",
        "KR",
        "AQ",
        "SO",
        "LK",
        "SK",
        "SI",
        "SZ",
        "SD",
        "SY",
        "SR",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TK",
        "TO",
        "TG",
        "TT",
        "TA",
        "TD",
        "CZ",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "HU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "US",
        "AE",
        "VN",
        "WF",
        "EH",
        "CX",
        "BY",
        "EA",
        "CF",
        "KN",
        "LC",
        "PM",
        "ST",
        "VC",
        "CY",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Ääd");
    namesMap.put("002", "Affrika");
    namesMap.put("003", "Nood-Amärrika");
    namesMap.put("005", "Söd-Amärrika");
    namesMap.put("009", "Ozejaanije");
    namesMap.put("011", "Wäß-Affrika");
    namesMap.put("013", "Meddelammärrika");
    namesMap.put("014", "Oß-Affrika");
    namesMap.put("015", "Nood-Affrika");
    namesMap.put("017", "Meddel-Affrika");
    namesMap.put("018", "Söd-Affrika");
    namesMap.put("019", "Ammärrika");
    namesMap.put("021", "Norde vun Amärrika");
    namesMap.put("029", "Karribik");
    namesMap.put("030", "Oß-Aasije");
    namesMap.put("034", "Söd-Aasije");
    namesMap.put("035", "Söd-Oß-Aasije");
    namesMap.put("039", "Söd-Europpa");
    namesMap.put("053", "Rejjohn Austraalije");
    namesMap.put("054", "Mellaneesije");
    namesMap.put("057", "Mikroneesesche Rejohn");
    namesMap.put("061", "Polineesije");
    namesMap.put("062", "Söd-Meddel-Aasije");
    namesMap.put("142", "Aasije");
    namesMap.put("143", "Meddelaasije");
    namesMap.put("145", "Wäß-Aasije");
    namesMap.put("150", "Europpa");
    namesMap.put("151", "Oß-Europpa");
    namesMap.put("154", "Nood-Europpa");
    namesMap.put("155", "Wäß-Europpa");
    namesMap.put("172", "dä Kommenwälth");
    namesMap.put("419", "Lateinamärrika un de Karribik");
    namesMap.put("AC", "Aßension");
    namesMap.put("AE", "Vereinschte Arrabesche Emmirate");
    namesMap.put("AF", "Afjaanistahn");
    namesMap.put("AG", "Antigwa un Barbuda");
    namesMap.put("AI", "Anggwilla");
    namesMap.put("AL", "Albaanije");
    namesMap.put("AM", "Arrmeenije");
    namesMap.put("AN", "Nederlängsche Antille");
    namesMap.put("AO", "Angjoola");
    namesMap.put("AQ", "Södpol");
    namesMap.put("AR", "Ajjentiinije");
    namesMap.put("AS", "Ammerikaanesch Sammoha");
    namesMap.put("AT", "Öösterisch");
    namesMap.put("AU", "Austraalije");
    namesMap.put("AX", "Ohland-Enselle");
    namesMap.put("AZ", "Asserbaidschahn");
    namesMap.put("BA", "Boßnije");
    namesMap.put("BB", "Ensel Barbados");
    namesMap.put("BD", "Bangladesch");
    namesMap.put("BE", "Bellje");
    namesMap.put("BF", "Bukkinna-Faase");
    namesMap.put("BG", "Bulljaarije");
    namesMap.put("BH", "Bachrain");
    namesMap.put("BL", "de Zint Battälmi-Enselle");
    namesMap.put("BM", "Bermudas");
    namesMap.put("BO", "Bolliivije");
    namesMap.put("BR", "Brasilije");
    namesMap.put("BT", "Buttaan");
    namesMap.put("BV", "Buvee-Ensel");
    namesMap.put("BW", "Bozwaana");
    namesMap.put("BY", "Wießrußland");
    namesMap.put("CA", "Kannada");
    namesMap.put("CC", "Kokkos-Enselle");
    namesMap.put("CD", "Konggo-Kinshasa");
    namesMap.put("CF", "Zetraalaffrikanesche Republik");
    namesMap.put("CG", "Konggo (Brassavill)");
    namesMap.put("CH", "Schweiz");
    namesMap.put("CI", "Älfebeijn-Köß");
    namesMap.put("CK", "Kuuk-Enselle");
    namesMap.put("CL", "Schiile");
    namesMap.put("CM", "Kammeruhn");
    namesMap.put("CN", "Schiina");
    namesMap.put("CO", "Kolumbije");
    namesMap.put("CP", "Klipperton-Ensel");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kapvärdesche Enselle");
    namesMap.put("CX", "Weihnaachs-Ensel");
    namesMap.put("CY", "Züppere");
    namesMap.put("CZ", "Tschäschei");
    namesMap.put("DE", "Doütschland");
    namesMap.put("DG", "Diego-Garcia-Ensel");
    namesMap.put("DJ", "Dschibutti");
    namesMap.put("DK", "Dänemark");
    namesMap.put("DM", "Dominnika");
    namesMap.put("DO", "Dommenekaanesche Reppublik");
    namesMap.put("DZ", "Alljeerije");
    namesMap.put("EA", "Ze'uta un Meliija");
    namesMap.put("EC", "Äkwador");
    namesMap.put("EE", "Äßland");
    namesMap.put("EG", "Äjüpte");
    namesMap.put("EH", "Wäß-Sahara");
    namesMap.put("ER", "Äritreja");
    namesMap.put("ES", "Schpaanije");
    namesMap.put("ET", "Ättijoopije");
    namesMap.put("EU", "Eurppäesche Unijon");
    namesMap.put("FI", "Finnland");
    namesMap.put("FJ", "Fischei-Endelle");
    namesMap.put("FK", "Falkland-Enselle");
    namesMap.put("FM", "Mikroneesije");
    namesMap.put("FO", "Färrör-Enselle");
    namesMap.put("FR", "Frankrisch");
    namesMap.put("GA", "Jabuhn");
    namesMap.put("GB", "Jruußbrettannije");
    namesMap.put("GD", "Jrenaada");
    namesMap.put("GE", "Jeorrjije");
    namesMap.put("GF", "Franzüüsesch Jujaana");
    namesMap.put("GG", "Jöönsei");
    namesMap.put("GH", "Jaana");
    namesMap.put("GI", "Jibralltaa");
    namesMap.put("GL", "Jröhnland");
    namesMap.put("GM", "Jambija");
    namesMap.put("GN", "Jinneha");
    namesMap.put("GP", "Juadelupp");
    namesMap.put("GQ", "Äquatorial Jineeja");
    namesMap.put("GR", "Jriescheland");
    namesMap.put("GS", "Söd-Jeorjie un de södlijje Botteramms-Enselle");
    namesMap.put("GT", "Juwatemaala");
    namesMap.put("GU", "Juham");
    namesMap.put("GW", "Jinneha_Bißau");
    namesMap.put("GY", "Jujaana");
    namesMap.put("HK", "Hong-Kong");
    namesMap.put("HM", "de Heart Ensel un de McDonal-Enselle");
    namesMap.put("HR", "Krowazije");
    namesMap.put("HT", "Ha'itti");
    namesMap.put("HU", "Unjann");
    namesMap.put("IC", "Kannaresche Enselle");
    namesMap.put("ID", "Indoneesije");
    namesMap.put("IE", "Irrland");
    namesMap.put("IL", "Ißraäl");
    namesMap.put("IM", "Ensel Män");
    namesMap.put("IN", "Indije");
    namesMap.put("IO", "Brettesche Besezunge em indesche Oozejahn");
    namesMap.put("IQ", "Irak");
    namesMap.put("IR", "Persije");
    namesMap.put("IS", "Ißland");
    namesMap.put("IT", "Itaalije");
    namesMap.put("JE", "Jööseh");
    namesMap.put("JM", "Jammaika");
    namesMap.put("JO", "Jordaanija");
    namesMap.put("KE", "Keenija");
    namesMap.put("KG", "Kirrjiisije");
    namesMap.put("KH", "Kambodscha");
    namesMap.put("KM", "Kommoore");
    namesMap.put("KN", "Zimt Kitts un Nevis");
    namesMap.put("KP", "Nood-Koreja");
    namesMap.put("KR", "Söd-Koreja");
    namesMap.put("KW", "Kuweit");
    namesMap.put("KY", "Kaiman-Enselle");
    namesMap.put("KZ", "Kassakstahn");
    namesMap.put("LA", "La'os");
    namesMap.put("LB", "Libbannon");
    namesMap.put("LC", "Zint-Lutscha-Ensel");
    namesMap.put("LI", "Lischtestein");
    namesMap.put("LR", "Libeerija");
    namesMap.put("LS", "Lesooto");
    namesMap.put("LT", "Lizzaue");
    namesMap.put("LU", "Luxembursch");
    namesMap.put("LV", "Lätland");
    namesMap.put("LY", "Libbija");
    namesMap.put("MA", "Marokko");
    namesMap.put("MC", "Monakko");
    namesMap.put("MD", "Moldaavije");
    namesMap.put("ME", "Monteneejro");
    namesMap.put("MF", "Sint-Määtes-Ensel");
    namesMap.put("MG", "Maddajaska");
    namesMap.put("MH", "Machschall-Enselle");
    namesMap.put("MK", "Mazedoonije");
    namesMap.put("ML", "Maali");
    namesMap.put("MM", "Birma");
    namesMap.put("MN", "Mongjolei");
    namesMap.put("MO", "Makau");
    namesMap.put("MP", "de nöödlijje Marijanne-Enselle");
    namesMap.put("MQ", "Machtinik");
    namesMap.put("MR", "Mautitaanije");
    namesMap.put("MS", "Mongßerrat");
    namesMap.put("MU", "Maurizijus");
    namesMap.put("MV", "Mallediive");
    namesMap.put("MY", "Malaisije");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NA", "Namiibije");
    namesMap.put("NC", "Neuschottland");
    namesMap.put("NE", "Nijer");
    namesMap.put("NF", "Noofok-Ensel");
    namesMap.put("NG", "Nikaraagua");
    namesMap.put("NI", "Nikaraaguwa");
    namesMap.put("NL", "Nederläng");
    namesMap.put("NO", "Norrweeje");
    namesMap.put("NP", "Nepall");
    namesMap.put("NZ", "Neuseeland");
    namesMap.put("PA", "Pannama");
    namesMap.put("PE", "Perruh");
    namesMap.put("PF", "Franzüüsesch Pollineesije");
    namesMap.put("PG", "Papuwa Neujineeja");
    namesMap.put("PH", "Fillipiine");
    namesMap.put("PK", "Pakistahn");
    namesMap.put("PL", "Pole");
    namesMap.put("PM", "Zint Pjäär un Mikelong");
    namesMap.put("PN", "Pitkärn-Ensel");
    namesMap.put("PR", "Pochtoriko");
    namesMap.put("PS", "Palästina");
    namesMap.put("PT", "Pochtojall");
    namesMap.put("PW", "Pallau");
    namesMap.put("PY", "Parraguwai");
    namesMap.put("QA", "Kataa");
    namesMap.put("QO", "Ozejaanije ußerhallef");
    namesMap.put("RE", "Rehunjohn");
    namesMap.put("RO", "Romäänije");
    namesMap.put("RS", "Serbije");
    namesMap.put("RU", "Rußland");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudi Arraabije");
    namesMap.put("SB", "de Solomone-Enselle");
    namesMap.put("SC", "Seischälle");
    namesMap.put("SE", "Schweede");
    namesMap.put("SG", "Singjapuur");
    namesMap.put("SH", "Sint-Hellena-Ensel");
    namesMap.put("SI", "ßloveenije");
    namesMap.put("SJ", "de Enselle Svalbard un Jan Mayen");
    namesMap.put("SK", "ßlovakei");
    namesMap.put("SL", "Sjärra Lejone");
    namesMap.put("SM", "San-Marino");
    namesMap.put("SN", "Sennejall");
    namesMap.put("SO", "Somaalije");
    namesMap.put("SR", "Sürinamm");
    namesMap.put("ST", "Zint Tommeh un Printschipe");
    namesMap.put("SV", "Äl Slavadoor");
    namesMap.put("SY", "Sürije");
    namesMap.put("SZ", "ßwaasiland");
    namesMap.put("TA", "Tristan da Cunja");
    namesMap.put("TC", "Turks un Kaikos Enselle");
    namesMap.put("TD", "Tschad");
    namesMap.put("TF", "Franzüüsesche Södsee-Enselle");
    namesMap.put("TG", "Toojo");
    namesMap.put("TH", "Tailand");
    namesMap.put("TJ", "Tadschikistahn");
    namesMap.put("TL", "Oß-Timor");
    namesMap.put("TM", "Turkmenistahn");
    namesMap.put("TN", "Tuneesije");
    namesMap.put("TO", "Tongga");
    namesMap.put("TR", "Türkei");
    namesMap.put("TT", "Trinidad un Tobääjo");
    namesMap.put("TZ", "Tansanija");
    namesMap.put("UA", "Ukra'iine");
    namesMap.put("UG", "Ujanda");
    namesMap.put("UM", "De Vereineschte Schtaate vun Amärrika ier klein Enselsche ußerhallef");
    namesMap.put("US", "Vereineschte Schtaate vun Ammärrika");
    namesMap.put("UY", "Urruguwai");
    namesMap.put("UZ", "Ußbeekistahn");
    namesMap.put("VA", "Vattikahn");
    namesMap.put("VC", "Zint Vinzänz un de Jrenadines-Enselle");
    namesMap.put("VG", "Brettesche Juffer-Enselle");
    namesMap.put("VI", "Ammärrikahnesche Juffer-Enselle");
    namesMap.put("VN", "Vijätnamm");
    namesMap.put("WF", "Wallis un Futuna");
    namesMap.put("WS", "Sammoha");
    namesMap.put("YE", "Jämmen");
    namesMap.put("YT", "Majott");
    namesMap.put("ZA", "Södaffrika");
    namesMap.put("ZM", "Sambija");
    namesMap.put("ZW", "Simbabwe");
    namesMap.put("ZZ", "Jääjend onbikannt");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Ääd",
        "002": "Affrika",
        "003": "Nood-Amärrika",
        "005": "Söd-Amärrika",
        "009": "Ozejaanije",
        "011": "Wäß-Affrika",
        "013": "Meddelammärrika",
        "014": "Oß-Affrika",
        "015": "Nood-Affrika",
        "017": "Meddel-Affrika",
        "018": "Söd-Affrika",
        "019": "Ammärrika",
        "021": "Norde vun Amärrika",
        "029": "Karribik",
        "030": "Oß-Aasije",
        "034": "Söd-Aasije",
        "035": "Söd-Oß-Aasije",
        "039": "Söd-Europpa",
        "053": "Rejjohn Austraalije",
        "054": "Mellaneesije",
        "057": "Mikroneesesche Rejohn",
        "061": "Polineesije",
        "062": "Söd-Meddel-Aasije",
        "142": "Aasije",
        "143": "Meddelaasije",
        "145": "Wäß-Aasije",
        "150": "Europpa",
        "151": "Oß-Europpa",
        "154": "Nood-Europpa",
        "155": "Wäß-Europpa",
        "172": "dä Kommenwälth",
        "419": "Lateinamärrika un de Karribik",
        "AC": "Aßension",
        "AE": "Vereinschte Arrabesche Emmirate",
        "AF": "Afjaanistahn",
        "AG": "Antigwa un Barbuda",
        "AI": "Anggwilla",
        "AL": "Albaanije",
        "AM": "Arrmeenije",
        "AN": "Nederlängsche Antille",
        "AO": "Angjoola",
        "AQ": "Södpol",
        "AR": "Ajjentiinije",
        "AS": "Ammerikaanesch Sammoha",
        "AT": "Öösterisch",
        "AU": "Austraalije",
        "AX": "Ohland-Enselle",
        "AZ": "Asserbaidschahn",
        "BA": "Boßnije",
        "BB": "Ensel Barbados",
        "BD": "Bangladesch",
        "BE": "Bellje",
        "BF": "Bukkinna-Faase",
        "BG": "Bulljaarije",
        "BH": "Bachrain",
        "BL": "de Zint Battälmi-Enselle",
        "BM": "Bermudas",
        "BO": "Bolliivije",
        "BR": "Brasilije",
        "BT": "Buttaan",
        "BV": "Buvee-Ensel",
        "BW": "Bozwaana",
        "BY": "Wießrußland",
        "CA": "Kannada",
        "CC": "Kokkos-Enselle",
        "CD": "Konggo-Kinshasa",
        "CF": "Zetraalaffrikanesche Republik",
        "CG": "Konggo (Brassavill)",
        "CH": "Schweiz",
        "CI": "Älfebeijn-Köß",
        "CK": "Kuuk-Enselle",
        "CL": "Schiile",
        "CM": "Kammeruhn",
        "CN": "Schiina",
        "CO": "Kolumbije",
        "CP": "Klipperton-Ensel",
        "CR": "Kostarika",
        "CU": "Kuba",
        "CV": "Kapvärdesche Enselle",
        "CX": "Weihnaachs-Ensel",
        "CY": "Züppere",
        "CZ": "Tschäschei",
        "DE": "Doütschland",
        "DG": "Diego-Garcia-Ensel",
        "DJ": "Dschibutti",
        "DK": "Dänemark",
        "DM": "Dominnika",
        "DO": "Dommenekaanesche Reppublik",
        "DZ": "Alljeerije",
        "EA": "Ze'uta un Meliija",
        "EC": "Äkwador",
        "EE": "Äßland",
        "EG": "Äjüpte",
        "EH": "Wäß-Sahara",
        "ER": "Äritreja",
        "ES": "Schpaanije",
        "ET": "Ättijoopije",
        "EU": "Eurppäesche Unijon",
        "FI": "Finnland",
        "FJ": "Fischei-Endelle",
        "FK": "Falkland-Enselle",
        "FM": "Mikroneesije",
        "FO": "Färrör-Enselle",
        "FR": "Frankrisch",
        "GA": "Jabuhn",
        "GB": "Jruußbrettannije",
        "GD": "Jrenaada",
        "GE": "Jeorrjije",
        "GF": "Franzüüsesch Jujaana",
        "GG": "Jöönsei",
        "GH": "Jaana",
        "GI": "Jibralltaa",
        "GL": "Jröhnland",
        "GM": "Jambija",
        "GN": "Jinneha",
        "GP": "Juadelupp",
        "GQ": "Äquatorial Jineeja",
        "GR": "Jriescheland",
        "GS": "Söd-Jeorjie un de södlijje Botteramms-Enselle",
        "GT": "Juwatemaala",
        "GU": "Juham",
        "GW": "Jinneha_Bißau",
        "GY": "Jujaana",
        "HK": "Hong-Kong",
        "HM": "de Heart Ensel un de McDonal-Enselle",
        "HR": "Krowazije",
        "HT": "Ha'itti",
        "HU": "Unjann",
        "IC": "Kannaresche Enselle",
        "ID": "Indoneesije",
        "IE": "Irrland",
        "IL": "Ißraäl",
        "IM": "Ensel Män",
        "IN": "Indije",
        "IO": "Brettesche Besezunge em indesche Oozejahn",
        "IQ": "Irak",
        "IR": "Persije",
        "IS": "Ißland",
        "IT": "Itaalije",
        "JE": "Jööseh",
        "JM": "Jammaika",
        "JO": "Jordaanija",
        "KE": "Keenija",
        "KG": "Kirrjiisije",
        "KH": "Kambodscha",
        "KM": "Kommoore",
        "KN": "Zimt Kitts un Nevis",
        "KP": "Nood-Koreja",
        "KR": "Söd-Koreja",
        "KW": "Kuweit",
        "KY": "Kaiman-Enselle",
        "KZ": "Kassakstahn",
        "LA": "La'os",
        "LB": "Libbannon",
        "LC": "Zint-Lutscha-Ensel",
        "LI": "Lischtestein",
        "LR": "Libeerija",
        "LS": "Lesooto",
        "LT": "Lizzaue",
        "LU": "Luxembursch",
        "LV": "Lätland",
        "LY": "Libbija",
        "MA": "Marokko",
        "MC": "Monakko",
        "MD": "Moldaavije",
        "ME": "Monteneejro",
        "MF": "Sint-Määtes-Ensel",
        "MG": "Maddajaska",
        "MH": "Machschall-Enselle",
        "MK": "Mazedoonije",
        "ML": "Maali",
        "MM": "Birma",
        "MN": "Mongjolei",
        "MO": "Makau",
        "MP": "de nöödlijje Marijanne-Enselle",
        "MQ": "Machtinik",
        "MR": "Mautitaanije",
        "MS": "Mongßerrat",
        "MU": "Maurizijus",
        "MV": "Mallediive",
        "MY": "Malaisije",
        "MZ": "Mosambik",
        "NA": "Namiibije",
        "NC": "Neuschottland",
        "NE": "Nijer",
        "NF": "Noofok-Ensel",
        "NG": "Nikaraagua",
        "NI": "Nikaraaguwa",
        "NL": "Nederläng",
        "NO": "Norrweeje",
        "NP": "Nepall",
        "NZ": "Neuseeland",
        "PA": "Pannama",
        "PE": "Perruh",
        "PF": "Franzüüsesch Pollineesije",
        "PG": "Papuwa Neujineeja",
        "PH": "Fillipiine",
        "PK": "Pakistahn",
        "PL": "Pole",
        "PM": "Zint Pjäär un Mikelong",
        "PN": "Pitkärn-Ensel",
        "PR": "Pochtoriko",
        "PS": "Palästina",
        "PT": "Pochtojall",
        "PW": "Pallau",
        "PY": "Parraguwai",
        "QA": "Kataa",
        "QO": "Ozejaanije ußerhallef",
        "RE": "Rehunjohn",
        "RO": "Romäänije",
        "RS": "Serbije",
        "RU": "Rußland",
        "RW": "Ruanda",
        "SA": "Saudi Arraabije",
        "SB": "de Solomone-Enselle",
        "SC": "Seischälle",
        "SE": "Schweede",
        "SG": "Singjapuur",
        "SH": "Sint-Hellena-Ensel",
        "SI": "ßloveenije",
        "SJ": "de Enselle Svalbard un Jan Mayen",
        "SK": "ßlovakei",
        "SL": "Sjärra Lejone",
        "SM": "San-Marino",
        "SN": "Sennejall",
        "SO": "Somaalije",
        "SR": "Sürinamm",
        "ST": "Zint Tommeh un Printschipe",
        "SV": "Äl Slavadoor",
        "SY": "Sürije",
        "SZ": "ßwaasiland",
        "TA": "Tristan da Cunja",
        "TC": "Turks un Kaikos Enselle",
        "TD": "Tschad",
        "TF": "Franzüüsesche Södsee-Enselle",
        "TG": "Toojo",
        "TH": "Tailand",
        "TJ": "Tadschikistahn",
        "TL": "Oß-Timor",
        "TM": "Turkmenistahn",
        "TN": "Tuneesije",
        "TO": "Tongga",
        "TR": "Türkei",
        "TT": "Trinidad un Tobääjo",
        "TZ": "Tansanija",
        "UA": "Ukra'iine",
        "UG": "Ujanda",
        "UM": "De Vereineschte Schtaate vun Amärrika ier klein Enselsche ußerhallef",
        "US": "Vereineschte Schtaate vun Ammärrika",
        "UY": "Urruguwai",
        "UZ": "Ußbeekistahn",
        "VA": "Vattikahn",
        "VC": "Zint Vinzänz un de Jrenadines-Enselle",
        "VG": "Brettesche Juffer-Enselle",
        "VI": "Ammärrikahnesche Juffer-Enselle",
        "VN": "Vijätnamm",
        "WF": "Wallis un Futuna",
        "WS": "Sammoha",
        "YE": "Jämmen",
        "YT": "Majott",
        "ZA": "Södaffrika",
        "ZM": "Sambija",
        "ZW": "Simbabwe",
        "ZZ": "Jääjend onbikannt"
    };
  }-*/;
}
