#!/bin/sh

#
# GUI for GNUVD using zenity
# (c) 2004 Dirk-Jan C. Binnema <djcb@djcbsoftware.nl>
#

ZENITY='zenity'
RECODE='recode'
GNUVD='gnuvd'

word="$1"
if test -z "$word"; then
	word=`$ZENITY --entry --text 'Geef een woord' --title 'GnuVD'`
		if test -z "$word"; then
		exit 0
	fi
fi

result=`$GNUVD -k $word | $RECODE html4..UTF8`
if test -z "$result"; then
	$ZENITY --error --text "'$word' is niet gevonden" --title 'GnuVD'
	exit 1
else
	$ZENITY --info --text="$result" --title 'GnuVD'
fi
