/*
 *	for new GOGO-no-coda (1999/09)
 *	Copyright (C) 1999 shigeo
 *	special thanks to Keiichi SAKAI, URURI
 */

#include <math.h>
#include "common.h"
#include "haveunit.h"

extern void (*fht)(float *fz, int n);
void (*fft1k)(float *x_real, float *energy, float (*abx)[2], float *window, int *savebuf);
void (*fft256)(float *x_real, float *energy, float (*abx)[2], float *window, int *savebuf);

void fht_3DN(float *fz,int n);
void fht_SSE(float *fz,int n);
void fht_FPU(float *fz,int n);	/* by  */
#ifdef USE_E3DN
void fht_E3DN(float *fz,int n);
#endif

void setup_fht(int useUNIT){
#ifdef USE_E3DN
	if(useUNIT & tE3DN){
		SETUP_DSP("use:fht_E3DN\n");
		fht=fht_E3DN;
	}else
#endif
	if(useUNIT & t3DN){
		SETUP_DSP("use:fht_3DN\n");
		fht=fht_3DN;
	}else
	if(useUNIT & tSSE){
		SETUP_DSP("use:fht_SSE\n");
		fht=fht_SSE;
	}else
	{
		SETUP_DSP("use:fht_FPU\n");
		fht=fht_FPU;
	}
}

void fft1k_FPU(float *x_real, float *energy, float (*abx)[2], float *window, int *savebuf);
void fft256_FPU(float *x_real, float *energy, float (*abx)[2], float *window, int *savebuf);
void fft1k_SSE(float *x_real, float *energy, float (*abx)[2], float *window, int *savebuf);
void fft256_SSE(float *x_real, float *energy, float (*abx)[2], float *window, int *savebuf);
void fft1k_3DN(float *x_real, float *energy, float (*abx)[2], float *window, int *savebuf);
void fft256_3DN(float *x_real, float *energy, float (*abx)[2], float *window, int *savebuf);

void setup_fft(int useUNIT)
{
	if(useUNIT & t3DN){
		SETUP_DSP("use:fft1k_3DN\n");
		fft1k = fft1k_3DN;
		SETUP_DSP("use:fft256_3DN\n");
		fft256 = fft256_3DN;
	}else if(useUNIT & tSSE){
		SETUP_DSP("use:fft1k_SSE\n");
		fft1k = fft1k_SSE;
		SETUP_DSP("use:fft256_SSE\n");
		fft256 = fft256_SSE;
	}else{
		SETUP_DSP("use:fft1k_FPU\n");
		fft1k = fft1k_FPU;
		SETUP_DSP("use:fft256_FPU\n");
		fft256 = fft256_FPU;
	}
}

/*
 *	s != 0 肷
 *	s & 3 == 0 肷
 */

void fft_side_C( float in[2][1024], int s, float *ret)
{
	float energy;
	float a,b;
	int i,j;
	/* energy͂Ȃ傫Ȓl̘bȂ̂ŕ␳͏ȗĂ()v */

	energy = 0;

	for (i=s,j=1024-s;i<512;i++,j--){
		a = in[0][i] - in[1][i];
		b = in[0][j] - in[1][j];
		energy += a*a + b*b;
	}
	a = in[0][512] - in[1][512];
	*ret = energy * 0.25 + a * a * 0.5;
}

void (*fft_side)( float in[2][1024], int s, float *ret);
void fft_side_3DN( float in[2][1024], int s, float *ret );
void fft_side_SSE( float in[2][1024], int s, float *ret );
#ifdef USE_E3DN
void fft_side_E3DN( float in[2][1024], int s, float *ret );
#endif

void setup_fft_side(int useUNIT){
#ifdef USE_E3DN
  if( useUNIT & tE3DN ){
    SETUP_DSP("use:fft_side_E3DN\n");
    fft_side = fft_side_E3DN;
  }else
#endif
  if( useUNIT & t3DN ){
    SETUP_DSP("use:fft_side_3DN\n");
    fft_side = fft_side_3DN;
  }else
  if( useUNIT & tSSE ){
    SETUP_DSP("use:fft_side_SSE\n");
    fft_side = fft_side_SSE;
  }else
  {
    SETUP_DSP("use:fft_side_C\n");
    fft_side = fft_side_C;
  }
}
