/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Callback;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.ConfigHandler;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.handler.AuditHandler;
import edu.harvard.hul.ois.jhove.handler.TextHandler;
import edu.harvard.hul.ois.jhove.handler.XmlHandler;
import edu.harvard.hul.ois.jhove.module.BytestreamModule;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

public class JhoveBase {
    private static Date _date;
    private static final String _name = "JhoveBase";
    private static final String _release = "1.2";
    private static final int[] DATE;
    private static final String _rights = "Copyright 2005-2007 by the President and Fellows of Harvard College";
    private static final String BUFFER_PROPERTY = "edu.harvard.hul.ois.jhove.bufferSize";
    private static final String CONFIG_DIR = "conf";
    private static final String CONFIG_PROPERTY = "edu.harvard.hul.ois.jhove.config";
    private static final int DEFAULT_BUFFER = 131072;
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final String DEFAULT_TEMP = ".";
    private static final String ENCODING_PROPERTY = "edu.harvard.hul.ois.jhove.encoding";
    private static final String JHOVE_DIR = "jhove";
    private static final String SAX_PROPERTY = "edu.harvard.hul.ois.jhove.saxClass";
    private static final String TEMPDIR_PROPERTY = "edu.harvard.hul.ois.jhove.tempDirectory";
    private static final String MIXVSN_PROPERTY = "edu.harvard.hul.ois.jhove.mixvsn";
    protected boolean _abort;
    protected int _bufferSize;
    protected boolean _checksum;
    protected String _configFile;
    protected String _encoding;
    protected Map _extensions;
    protected List _handlerList;
    protected Map _handlerMap;
    protected String _jhoveHome;
    protected List _moduleList;
    protected Map _moduleMap;
    protected String _outputFile;
    protected String _saxClass;
    protected boolean _showRaw;
    protected boolean _signature;
    protected String _tempDir;
    protected String _mixVsn;
    protected int _sigBytes;
    protected File _saveDir;
    protected long _nByte;
    Callback _callback;
    protected URLConnection _conn;
    protected Thread _currentThread;
    protected Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove");
    protected String _logLevel;

    public JhoveBase() throws JhoveException {
        this._logger.setLevel(Level.SEVERE);
        String string = System.getProperty("java.vm.version");
        if (string.compareTo("1.4.0") < 0) {
            String string2 = "Java 1.4 or higher is required";
            this._logger.severe(string2);
            throw new JhoveException(string2);
        }
        HttpsURLConnection.setDefaultHostnameVerifier(new NaiveHostnameVerifier());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(DATE[0], DATE[1] - 1, DATE[2]);
        _date = gregorianCalendar.getTime();
        this._moduleList = new ArrayList(20);
        this._moduleMap = new TreeMap();
        this._handlerList = new ArrayList();
        this._handlerMap = new TreeMap();
        this._abort = false;
        this._bufferSize = -1;
        this._checksum = false;
        this._showRaw = false;
        this._signature = false;
        this._callback = null;
    }

    public void init(String string, String string2) throws JhoveException {
        Object object;
        Object object2;
        this._configFile = string;
        this._saxClass = string2;
        File file = null;
        String string3 = null;
        if (this._configFile != null) {
            file = new File(this._configFile);
            if (!file.exists() || !file.isFile()) {
                string3 = "Configuration file not found or not readable; use -c to specify";
                file = null;
            }
            if (file != null) {
                Object object3;
                Class<?> clazz;
                List list;
                String[] stringArray;
                int n;
                Object object4;
                Object object5;
                object2 = null;
                try {
                    if (string2 == null) {
                        object = SAXParserFactory.newInstance();
                        ((SAXParserFactory)object).setNamespaceAware(true);
                        object2 = ((SAXParserFactory)object).newSAXParser().getXMLReader();
                    } else {
                        object2 = XMLReaderFactory.createXMLReader(string2);
                    }
                }
                catch (Exception exception) {
                    throw new JhoveException("SAX parser not found: " + string2);
                }
                this._logger.info("Using SAX parser " + object2.getClass().getName());
                object = new ConfigHandler();
                object2.setContentHandler((ContentHandler)object);
                object2.setEntityResolver((EntityResolver)object);
                try {
                    object2.setFeature("http://xml.org/sax/features/validation", true);
                    object2.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
                try {
                    object5 = file.getCanonicalPath();
                    object4 = "file://";
                    if (((String)object5).charAt(0) != '/') {
                        object4 = (String)object4 + '/';
                    }
                    object4 = (String)object4 + (String)object5;
                    object2.parse((String)object4);
                }
                catch (IOException iOException) {
                    throw new JhoveException("Cannot read configuration file: " + string);
                }
                catch (SAXException sAXException) {
                    throw new JhoveException("Error parsing configuration file: " + sAXException.getMessage());
                }
                this._extensions = ((ConfigHandler)object).getExtensions();
                this._jhoveHome = ((ConfigHandler)object).getJhoveHome();
                this._encoding = ((ConfigHandler)object).getEncoding();
                if (this._encoding == null) {
                    this._encoding = JhoveBase.getFromProperties(ENCODING_PROPERTY);
                    if (this._encoding == null) {
                        this._encoding = DEFAULT_ENCODING;
                    }
                }
                this._tempDir = ((ConfigHandler)object).getTempDir();
                if (this._tempDir == null) {
                    this._tempDir = JhoveBase.getFromProperties(TEMPDIR_PROPERTY);
                    if (this._tempDir == null) {
                        this._tempDir = DEFAULT_TEMP;
                    }
                }
                this._mixVsn = ((ConfigHandler)object).getMixVsn();
                if (this._mixVsn == null) {
                    this._mixVsn = "2.0";
                }
                this._sigBytes = ((ConfigHandler)object).getSigBytes();
                if (this._logLevel == null) {
                    this._logLevel = ((ConfigHandler)object).getLogLevel();
                    if (this._logLevel != null) {
                        try {
                            this._logger.setLevel(Level.parse(this._logLevel));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                this._bufferSize = ((ConfigHandler)object).getBufferSize();
                if (this._bufferSize < 0) {
                    object5 = JhoveBase.getFromProperties(BUFFER_PROPERTY);
                    if (object5 != null) {
                        try {
                            this._bufferSize = Integer.parseInt((String)object5);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this._bufferSize < 0) {
                        this._bufferSize = 131072;
                    }
                }
                object5 = ((ConfigHandler)object).getModule();
                object4 = ((ConfigHandler)object).getModuleParams();
                int n2 = object5.size();
                for (n = 0; n < n2; ++n) {
                    stringArray = (String[])object5.get(n);
                    list = (List)object4.get(n);
                    try {
                        clazz = Class.forName(stringArray[0]);
                        object3 = (Module)clazz.newInstance();
                        object3.init(stringArray[1]);
                        object3.setDefaultParams(list);
                        this._moduleList.add(object3);
                        this._moduleMap.put(object3.getName().toLowerCase(), object3);
                        this._logger.info("Initialized " + object3.getName());
                        continue;
                    }
                    catch (Exception exception) {
                        if (string3 != null) continue;
                        string3 = "cannot instantiate module: " + stringArray[0];
                    }
                }
                object5 = ((ConfigHandler)object).getHandler();
                object4 = ((ConfigHandler)object).getHandlerParams();
                n2 = object5.size();
                for (n = 0; n < n2; ++n) {
                    stringArray = (String[])object5.get(n);
                    list = (List)object4.get(n);
                    try {
                        clazz = Class.forName(stringArray[0]);
                        object3 = (OutputHandler)clazz.newInstance();
                        object3.init(stringArray[1]);
                        object3.setDefaultParams(list);
                        this._handlerList.add(object3);
                        this._handlerMap.put(object3.getName().toLowerCase(), object3);
                        continue;
                    }
                    catch (Exception exception) {
                        if (string3 != null) continue;
                        string3 = "cannot instantiate handler: " + stringArray[0];
                    }
                }
            }
            if (string3 != null) {
                throw new JhoveException(string3);
            }
        }
        object2 = new BytestreamModule();
        object2.setDefaultParams(new ArrayList());
        this._moduleList.add(object2);
        this._moduleMap.put(object2.getName().toLowerCase(), object2);
        object = new TextHandler();
        object.setDefaultParams(new ArrayList());
        this._handlerList.add(object);
        this._handlerMap.put(object.getName().toLowerCase(), object);
        object = new XmlHandler();
        object.setDefaultParams(new ArrayList());
        this._handlerList.add(object);
        this._handlerMap.put(object.getName().toLowerCase(), object);
        object = new AuditHandler();
        object.setDefaultParams(new ArrayList());
        this._handlerList.add(object);
        this._handlerMap.put(object.getName().toLowerCase(), object);
    }

    public void setCallback(Callback callback) {
        this._callback = callback;
    }

    public void dispatch(App app, Module module, OutputHandler outputHandler, OutputHandler outputHandler2, String string, String[] stringArray) throws Exception {
        this._abort = false;
        if (outputHandler2 == null) {
            outputHandler2 = (OutputHandler)this._handlerMap.get("text");
        }
        outputHandler2.reset();
        this._outputFile = string;
        outputHandler2.setApp(app);
        outputHandler2.setBase(this);
        outputHandler2.setWriter(JhoveBase.makeWriter(this._outputFile, this._encoding));
        outputHandler2.showHeader();
        if (stringArray == null) {
            if (module != null) {
                module.applyDefaultParams();
                module.show(outputHandler2);
            } else if (outputHandler != null) {
                outputHandler2.show(outputHandler);
            } else {
                app.show(outputHandler2);
            }
        } else {
            for (int i = 0; i < stringArray.length && this.process(app, module, outputHandler2, stringArray[i]); ++i) {
            }
        }
        outputHandler2.showFooter();
    }

    public boolean process(App app, Module module, OutputHandler outputHandler, String string) throws Exception {
        RepInfo repInfo;
        Object object;
        if (this._abort) {
            return false;
        }
        File file = null;
        boolean bl = false;
        long l = -1L;
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RepInfo repInfo2 = new RepInfo(string);
        if (uRI != null && uRI.isAbsolute()) {
            Object object2;
            Object object3;
            object = null;
            try {
                object = uRI.toURL();
            }
            catch (Exception exception) {
                throw new JhoveException("cannot convert URI to URL: " + string);
            }
            Object object4 = ((URL)object).openConnection();
            this._conn = object4;
            if (object4 instanceof HttpsURLConnection) {
                try {
                    repInfo = null;
                    object3 = new TrustManager[]{new RelaxedX509TrustManager()};
                    object2 = SSLContext.getInstance("SSL");
                    ((SSLContext)object2).init(null, (TrustManager[])object3, new SecureRandom());
                    SSLSocketFactory sSLSocketFactory = ((SSLContext)object2).getSocketFactory();
                    ((HttpsURLConnection)object4).setSSLSocketFactory(sSLSocketFactory);
                    int n = ((HttpsURLConnection)object4).getResponseCode();
                    if (200 > n || n >= 300) {
                        throw new JhoveException("URL not found: " + string);
                    }
                }
                catch (Exception exception) {
                    throw new JhoveException("URL not found: " + string);
                }
            }
            l = ((URLConnection)object4).getLastModified();
            try {
                file = this.connToTempFile((URLConnection)object4, repInfo2);
                if (file == null) {
                    return false;
                }
                bl = true;
            }
            catch (IOException iOException) {
                this._conn = null;
                object3 = "cannot read URL: " + string;
                object2 = iOException.getMessage();
                if (object2 != null) {
                    object3 = (String)object3 + " (" + (String)object2 + ")";
                }
                throw new JhoveException((String)object3);
            }
            if (object4 instanceof HttpsURLConnection) {
                ((HttpsURLConnection)object4).disconnect();
            }
            this._conn = null;
        } else {
            file = new File(string);
        }
        if (file.isDirectory()) {
            object = file.listFiles();
            repInfo2 = null;
            Arrays.sort((Object[])object);
            outputHandler.startDirectory(file.getCanonicalPath());
            for (int i = 0; i < ((Object[])object).length; ++i) {
                if (this.process(app, module, outputHandler, ((File)object[i]).getCanonicalPath())) continue;
                return false;
            }
            outputHandler.endDirectory();
        } else if (!file.exists()) {
            repInfo2.setMessage(new ErrorMessage("file not found"));
            repInfo2.setWellFormed(0);
            repInfo2.show(outputHandler);
        } else if (!file.isFile() || !file.canRead()) {
            repInfo2.setMessage(new ErrorMessage("file cannot be read"));
            repInfo2.setWellFormed(0);
            repInfo2.show(outputHandler);
        } else if (outputHandler.okToProcess(string)) {
            repInfo2.setSize(file.length());
            if (l < 0L) {
                l = file.lastModified();
            }
            repInfo2.setLastModified(new Date(l));
            if (module != null) {
                if (!this.processFile(app, module, false, file, repInfo2)) {
                    return false;
                }
            } else {
                for (Object object4 : this._moduleList) {
                    repInfo = (RepInfo)repInfo2.clone();
                    if (!object4.hasFeature("edu.harvard.hul.ois.jhove.canValidate")) continue;
                    try {
                        if (!this.processFile(app, (Module)object4, false, file, repInfo)) {
                            return false;
                        }
                        if (repInfo.getWellFormed() == 1) {
                            repInfo2.copy(repInfo);
                            break;
                        }
                        repInfo2.setSigMatch(repInfo.getSigMatch());
                    }
                    catch (Exception exception) {}
                }
            }
            repInfo2.show(outputHandler);
        }
        if (file != null && bl) {
            file.delete();
        }
        return true;
    }

    public File connToTempFile(URLConnection uRLConnection, RepInfo repInfo) throws IOException {
        File file;
        try {
            file = this.newTempFile();
        }
        catch (IOException iOException) {
            throw new IOException("cannot create temp file");
        }
        BufferedOutputStream bufferedOutputStream = null;
        DataInputStream dataInputStream = null;
        bufferedOutputStream = this._bufferSize > 0 ? new BufferedOutputStream(new FileOutputStream(file), this._bufferSize) : new BufferedOutputStream(new FileOutputStream(file));
        try {
            dataInputStream = this._bufferSize > 0 ? new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream(), this._bufferSize)) : new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
        }
        catch (UnknownHostException unknownHostException) {
            file.delete();
            throw new IOException(unknownHostException.toString());
        }
        catch (IOException iOException) {
            file.delete();
            throw iOException;
        }
        catch (Exception exception) {
            file.delete();
            throw new IOException(exception.toString());
        }
        Checksummer checksummer = null;
        if (this._checksum) {
            checksummer = new Checksummer();
        }
        this._nByte = 0L;
        int n = 4000;
        try {
            while (true) {
                if (this._nByte % (long)n == 0L) {
                    Thread.yield();
                    if (this._callback != null) {
                        this._callback.callback(1, new Long(this._nByte));
                    }
                    if ((long)(n * 10) < this._nByte) {
                        n = (int)(this._nByte / 10L);
                    }
                }
                if (this._abort) {
                    dataInputStream.close();
                    ((OutputStream)bufferedOutputStream).close();
                    file.delete();
                    return null;
                }
                int n2 = dataInputStream.readUnsignedByte();
                if (checksummer != null) {
                    checksummer.update(n2);
                }
                byte by = Checksum.unsignedByteToByte(n2);
                ++this._nByte;
                ((OutputStream)bufferedOutputStream).write(by);
            }
        }
        catch (EOFException eOFException) {
            dataInputStream.close();
            ((OutputStream)bufferedOutputStream).close();
            repInfo.setSize(this._nByte);
            if (checksummer != null) {
                repInfo.setChecksum(new Checksum(checksummer.getCRC32(), ChecksumType.CRC32));
                String string = checksummer.getMD5();
                if (string != null) {
                    repInfo.setChecksum(new Checksum(string, ChecksumType.MD5));
                }
                if ((string = checksummer.getSHA1()) != null) {
                    repInfo.setChecksum(new Checksum(string, ChecksumType.SHA1));
                }
            }
            return file;
        }
    }

    public void abort() {
        this._abort = true;
        HttpsURLConnection httpsURLConnection = null;
        if (this._conn instanceof HttpsURLConnection) {
            httpsURLConnection = (HttpsURLConnection)this._conn;
        }
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (httpsURLConnection != null) {
            httpsURLConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processFile(App app, Module module, boolean bl, File file, RepInfo repInfo) throws Exception {
        if (!module.hasFeature("edu.harvard.hul.ois.jhove.canValidate")) {
            return false;
        }
        if (this._callback != null) {
            this._callback.callback(2, repInfo.getUri());
        }
        module.setApp(app);
        module.setBase(this);
        module.setVerbosity(bl ? 1 : 2);
        module.applyDefaultParams();
        if (module.isRandomAccess()) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            if (this._signature) {
                module.checkSignatures(file, randomAccessFile, repInfo);
            } else {
                module.parse(randomAccessFile, repInfo);
            }
            randomAccessFile.close();
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                if (this._signature) {
                    module.checkSignatures(file, fileInputStream, repInfo);
                } else {
                    int n = module.parse(fileInputStream, repInfo, 0);
                    while (n != 0) {
                        ((InputStream)fileInputStream).close();
                        fileInputStream = new FileInputStream(file);
                        n = module.parse(fileInputStream, repInfo, n);
                    }
                }
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return true;
    }

    public File tempFile() throws IOException {
        File file = null;
        if (this._tempDir == null) {
            file = File.createTempFile("JHOV", "");
        } else {
            File file2 = new File(this._tempDir);
            file = File.createTempFile("JHOV", "", file2);
        }
        file.deleteOnExit();
        return file;
    }

    public boolean getAbort() {
        return this._abort;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public String getConfigFile() {
        return this._configFile;
    }

    public Date getDate() {
        return _date;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public Map getExtension() {
        return this._extensions;
    }

    public String getExtension(String string) {
        return (String)this._extensions.get(string);
    }

    public OutputHandler getHandler(String string) {
        OutputHandler outputHandler = null;
        if (string != null) {
            outputHandler = (OutputHandler)this._handlerMap.get(string.toLowerCase());
        }
        return outputHandler;
    }

    public Map getHandlerMap() {
        return this._handlerMap;
    }

    public List getHandlerList() {
        return this._handlerList;
    }

    public String getJhoveHome() {
        return this._jhoveHome;
    }

    public Module getModule(String string) {
        Module module = null;
        if (string != null) {
            module = (Module)this._moduleMap.get(string.toLowerCase());
        }
        return module;
    }

    public Map getModuleMap() {
        return this._moduleMap;
    }

    public List getModuleList() {
        return this._moduleList;
    }

    public String getName() {
        return _name;
    }

    public String getOuputFile() {
        return this._outputFile;
    }

    public String getRelease() {
        return _release;
    }

    public String getRights() {
        return _rights;
    }

    public String getSaxClass() {
        return this._saxClass;
    }

    public String getTempDirectory() {
        return this._tempDir;
    }

    public int getSigBytes() {
        return this._sigBytes;
    }

    public File getSaveDirectory() {
        return this._saveDir;
    }

    public boolean getChecksumFlag() {
        return this._checksum;
    }

    public boolean getShowRawFlag() {
        return this._showRaw;
    }

    public boolean getSignatureFlag() {
        return this._signature;
    }

    public String getMixVersion() {
        return this._mixVsn;
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public void setTempDirectory(String string) {
        this._tempDir = string;
    }

    public void setLogLevel(String string) {
        this._logLevel = string;
        if (string != null) {
            try {
                this._logger.setLevel(Level.parse(this._logLevel));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setChecksumFlag(boolean bl) {
        this._checksum = bl;
    }

    public void setShowRawFlag(boolean bl) {
        this._showRaw = bl;
    }

    public void setSignatureFlag(boolean bl) {
        this._signature = bl;
    }

    public void setSaveDirectory(File file) {
        this._saveDir = file;
    }

    public void setCurrentThread(Thread thread) {
        this._currentThread = thread;
    }

    public void resetAbort() {
        this._abort = false;
    }

    public static String getConfigFileFromProperties() {
        String string = null;
        string = JhoveBase.getFromProperties(CONFIG_PROPERTY);
        if (string == null) {
            try {
                String string2 = System.getProperty("file.separator");
                string = System.getProperty("user.home") + string2 + JHOVE_DIR + string2 + CONFIG_DIR + string2 + "jhove.conf";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static String getSaxClassFromProperties() {
        String string = JhoveBase.getFromProperties(SAX_PROPERTY);
        return string;
    }

    public static String getFromProperties(String string) {
        String string2 = null;
        try {
            String string3 = System.getProperty("file.separator");
            Properties properties = new Properties();
            String string4 = System.getProperty("user.home") + string3 + JHOVE_DIR + string3 + "jhove.properties";
            FileInputStream fileInputStream = new FileInputStream(string4);
            properties.load(fileInputStream);
            fileInputStream.close();
            string2 = properties.getProperty(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    protected static PrintWriter makeWriter(String string, String string2) throws JhoveException {
        PrintWriter printWriter = null;
        OutputStreamWriter outputStreamWriter = null;
        if (string != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
                printWriter = new PrintWriter(outputStreamWriter);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new JhoveException("unsupported character encoding: " + string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JhoveException("cannot open output file: " + string);
            }
        }
        if (printWriter == null) {
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new JhoveException("unsupported character encoding: " + string2);
            }
            printWriter = new PrintWriter(outputStreamWriter);
        }
        return printWriter;
    }

    public File newTempFile() throws IOException {
        return this.tempFile();
    }

    static {
        DATE = new int[]{2007, 5, 10};
    }

    private class RelaxedX509TrustManager
    implements X509TrustManager {
        private RelaxedX509TrustManager() {
        }

        public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }

    private class NaiveHostnameVerifier
    implements HostnameVerifier {
        private NaiveHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }
}

