/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.processors.service.ServiceProcFactory;
import amazon.fws.clicommando.processors.service.ServiceScaffold;
import amazon.fws.clicommando.util.StringUtils;
import java.util.Map;

public class ServiceCommCommandProcessor
implements CommandProcessor {
    public static final String SERVICE_URL_CONFIG_TAG = "url";
    public static final String SERVICE_URL_PARAM = "ServiceUrl";

    public Command process(Command process) throws CliCommandoException {
        CommandConfig commandConfig = process.getCurrentCommandConfig();
        String procClass = commandConfig.getProcessor().getClassName();
        Map<String, String> procConfig = commandConfig.getProcessor().getConfigMap();
        if (procConfig != null && procConfig.get(SERVICE_URL_CONFIG_TAG) != null) {
            procConfig.put(SERVICE_URL_CONFIG_TAG, this.setupUrl(procConfig.get(SERVICE_URL_CONFIG_TAG), commandConfig));
        }
        ServiceScaffold scaf = ServiceProcFactory.getScaffold(procClass, procConfig);
        scaf.processParameterMap(process);
        return process;
    }

    private String setupUrl(String url, CommandConfig commandConfig) {
        String serviceUrl = commandConfig.getParameter(SERVICE_URL_PARAM).getValue();
        return StringUtils.notEmpty(serviceUrl) ? serviceUrl : url;
    }
}

