// Copyright (c) 2010, Amar Takhar <verm@aegisub.org>
//
// Permission to use, copy, modify, and distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
// $Id$

/// @file hotkey.h
/// @brief Hotkey handler
/// @ingroup hotkey menu event window

#ifndef AGI_PRE
#include <string>
#include <vector>

#include <wx/event.h>
#endif

namespace agi {
	struct Context;
	namespace hotkey { class Hotkey; }
}

namespace hotkey {

extern agi::hotkey::Hotkey *inst;

void init();
void clear();

bool check(std::string const& context, agi::Context *c, wxKeyEvent &evt);
bool check(std::string const& context, agi::Context *c, int key_code, wchar_t key_char, int modifier);
std::string keypress_to_str(int key_code, wchar_t key_char, int modifier);
std::string get_hotkey_str_first(std::string const& context, std::string const& command);
std::vector<std::string> get_hotkey_strs(std::string const& context, std::string const& command);


} // namespace hotkey
