// ----------------------------------------------------------------------------
//
//  Copyright (C) 2006-2011 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// ----------------------------------------------------------------------------


#include <math.h>
#include "xover2.h"


#define P2F 6.283185f



void Xover2::init (float fmid)
{
    float w, c, s;

    w = P2F * fmid;
    c = cosf (w);
    s = sinf (w);
    _c0 = (c < 1e-3f) ? (-0.5f * c) : ((s - 1) / c);
    _c1 = 0.5f * (1 + _c0);
}


void Xover2::process (int k, float *in, float *lp, float *hp)
{
    float d, t, x0, x1, z0, z1, z2;

    z0 = _z0;
    z1 = _z1;
    z2 = _z2;
   
    while (k--)
    {
	x1 = x0 = *in++;
        d = _c1 * (x1 - z1) + 1e-20f;
        x1 = z1 + d;
        z1 = x1 + d;      
        d = _c1 * (x1 - z2) + 1e-20f;
        x1 = z2 + d;
        z2 = x1 + d;      
        *lp++ = x1;
        t = x0 - _c0 * z0;
        x0 = z0 + _c0 * t;        
        z0 = t + 1e-20f;
	*hp++ = x0 - x1;
    }

    _z0 = z0;
    _z1 = z1;
    _z2 = z2;
}

