# Appendix - The Symbols of Anarchy

##

## [1 What is the history of the Black Flag?](append2.md#black)

## [2 Why the red-and-black flag?](append2.md#redblack)

## [3 Where does the circled A come from?](append2.md#circledA)

###

### Introduction

Anarchism has always stood deliberately for a broad, and at times vague,
political platform. The reasoning is sound; blueprints create rigid dogma and
stifle the creative spirit of revolt. Along the same lines and resulting in
the same problems, Anarchists have rejected the "disciplined" leadership that
is found in many other political groupings on the Left. The reasoning for this
is also sound; leadership based on authority is inherently hierarchical.

It seems to follow logically that since Anarchists have shied away from
anything static, that we would also shy away from the importance of symbols
and icons. Yet the fact is Anarchists have used symbolism in our revolt
against the State and Capital, the most famous of which are the circled-A, the
black flag and the red-and-black flag. This appendix tries to show the history
of these three iconic symbols and indicate why they were taken up by
anarchists to represent our ideas and movement.

Ironically enough, one of the original anarchist symbols was the **_red_**
flag. As anarchist Communard Louise Michel put it, _"Lyon, Marseille,
Narbonne, all had their own Communes, and like ours [in Paris], theirs too
were drowned in the blood of revolutionaries. That is why our flags are red.
Why are our red banners so terribly frightening to those persons who have
caused them to be stained that colour?"_ [**The Red Virgin: Memoirs of Louise
Michel**, p. 65] March 18th, 1877, saw Kropotkin participate in a protest
march in Berne which involved the anarchists _"carrying the red flag in honour
of the Paris Commune"_ for _"in Switzerland federal law prohibited public
display of the red flag."_ [Martin A. Miller, **Kropotkin**, p. 137] Anarchist
historians Nicolas Walter and Heiner Becker note that _"Kropotkin always
preferred the red flag."_ [Peter Kropotkin, **Act for Yourselves**, p. 128] On
Labour Day in 1899, Emma Goldman gave lectures to miners in Spring Valley,
Illinois, which ended in a demonstration which she headed _"carrying a large
red flag."_ [**Living My Life**, vol. 1, p. 245] According to historian
Caroline Waldron Merithew, the 300 marchers _"defied police orders to haul
down the 'red flag of anarchy.'"_ [**Anarchist Motherhood**, p. 236]

This should be unsurprising as anarchism is a form of socialism and came out
of the general socialist and labour movements. Common roots would imply common
imagery. However, as mainstream socialism developed in the nineteenth century
into either reformist social democracy or the state socialism of the
revolutionary Marxists, anarchists developed their own images of revolt based
upon those raised by working class people in struggle. As will be shown, they
come from the revolutionary anarchism most directly associated with the wider
labour and socialist movements, i.e., the dominant, mainstream social
anarchist tradition. As Nicholas Walter put it:

> _ "[The] serious study of anarchism should be based on fact rather than
fantasy, and concentrate on people and movements that actually used the word.
However old and wide the ideas of anarchism may be . . . no one called himself
an anarchist before [Proudhon in] 1840, and no movement called itself
anarchist before the 1870s . . . The actual anarchist movement was founded . .
. by the anti-authoritarian sections of the First International . . . This was
certainly the first anarchist movement, and this movement was certainly based
on a libertarian version of the concept of the class struggle."_ [**The
Anarchist Past and other essays**, pp. 60-1]

Unsurprisingly, the first anarchist symbols reflected the origins and ideas of
this class struggle movement. Both the black and red-and-black flags were
first used by revolutionary anarchists. The black flag was popularised in the
1880s by Louise Michel, a leading French communist-anarchist militant. From
Europe it spread to America when the communist-anarchists of the
**International Working People's Association** raised it in their struggle
against capitalism before being taken up by other revolutionary class struggle
anarchists across the globe. The red-and-black flag was first used by the
Italian section of the First International and this had been the first to move
from collectivist to communist-anarchism in October 1876. [Nunzio Pernicone,
**Italian Anarchism, 1864-1892**, p. 111] From there, it spread to Mexico and
was used by anarchist labour militants there before being re-invented by the
Spanish anarcho-syndicalists in the 1930s. Like anarchism itself, the
anarchist flags are a product of the social struggle against capitalism and
statism.

We would like to point out that this appendix is partly based on Jason
Wehling's 1995 essay **Anarchism and the History of the Black Flag**. Needless
to say, this appendix does not cover all anarchists symbols. For example,
recently the red-and-black flag has become complemented by the green-and-black
flag of eco-anarchism (the symbolism of the green should need no explanation).
Other libertarian popular symbols include the IWW inspired _**"Wildcat"**_
(representing, of course, the spontaneity, direct action, solidarity and
militancy of a wildcat strike), the _**"Black Rose"**_ (inspired, no doubt, by
the demand of striking IWW women workers in Lawrence, 1912, for not only
bread, but for roses too) and the ironic _**"little black bomb"**_ (among
others). Here we concentrate on the three most famous ones.

### 1 What is the history of the Black Flag?

As is well known, the black flag is the symbol of anarchism. Howard Ehrlich
has a great passage in his book **Reinventing Anarchy, Again** on why
anarchists use it. It is worth quoting at length:

> _"Why is our flag black? Black is a shade of negation. The black flag is the
negation of all flags. It is a negation of nationhood which puts the human
race against itself and denies the unity of all humankind. Black is a mood of
anger and outrage at all the hideous crimes against humanity perpetrated in
the name of allegiance to one state or another. It is anger and outrage at the
insult to human intelligence implied in the pretences, hypocrisies, and cheap
chicaneries of governments . . . Black is also a colour of mourning; the black
flag which cancels out the nation also mourns its victims the countless
millions murdered in wars, external and internal, to the greater glory and
stability of some bloody state. It mourns for those whose labour is robbed
(taxed) to pay for the slaughter and oppression of other human beings. It
mourns not only the death of the body but the crippling of the spirit under
authoritarian and hierarchic systems; it mourns the millions of brain cells
blacked out with never a chance to light up the world. It is a colour of
inconsolable grief. _

> _"But black is also beautiful. It is a colour of determination, of resolve,
of strength, a colour by which all others are clarified and defined. Black is
the mysterious surrounding of germination, of fertility, the breeding ground
of new life which always evolves, renews, refreshes, and reproduces itself in
darkness. The seed hidden in the earth, the strange journey of the sperm, the
secret growth of the embryo in the womb all these the blackness surrounds and
protects. _

> _"So black is negation, is anger, is outrage, is mourning, is beauty, is
hope, is the fostering and sheltering of new forms of human life and
relationship on and with this earth. The black flag means all these things. We
are proud to carry it, sorry we have to, and look forward to the day when such
a symbol will no longer be necessary."_ [_"Why the Black Flag?"_, Howard
Ehrlich (ed.), **Reinventing Anarchy, Again**, pp. 31-2]

Here we discuss when and why anarchists first took up the black flag as our
symbol.

There are ample accounts of the use of black flags by anarchists. Probably the
most famous was Nestor Makhno's partisans during the Russia Revolution. Under
the black banner, his army routed a dozen armies and kept a large portion of
the Ukraine free from concentrated power for a good couple of years. On the
black flag was embroidered [_"Liberty or Death"_ and _"The Land to the
Peasant, The Factories to the Workers."_ [Voline, **The Unknown Revolution**,
pp. 607-10] In 1925, the Japanese anarchists formed the **Black Youth League**
and, in 1945, when the anarchist federation reformed, their journal was named
**Kurohata** (**Black Flag**). [Peter Marshall, **Demanding the Impossible**,
pp. 525-6] In 1968, students carried black (and red) flags during the street
fighting and General Strike in France, bringing the resurgence of anarchism in
the 1960s into the view of the general public. The same year saw the Black
Flag being raised at the American **Students for a Democratic Society**
national convention. Two years later the British based magazine **Black Flag**
was started and is still going strong. At the turn of the 21st century, the
Black Flag was at the front of the so-called anti-globalisation protests.
Today, if you go to any sizeable demonstration you will usually see the Black
Flag raised by the anarchists present.

However, the anarchists' black flag originated much earlier than this. Louise
Michel, famous participant in the Paris Commune of 1871, was instrumental in
popularising the use of the Black Flag in anarchist circles. At a March 18th
public meeting in 1882 to commemorate the Paris Commune she proclaimed that
the _"red flag was no longer appropriate; [the anarchists] should raise the
black flag of misery."_ [Edith Thomas, **Louise Michel**, p. 191] The
following year she put her words into action. According to anarchist historian
George Woodcock, Michel flew the black flag on March 9, 1883, during
demonstration of the unemployed in Paris, France. An open air meeting of the
unemployed was broken up by the police and around 500 demonstrators, with
Michel at the front carrying a black flag and shouting _"Bread, work, or
lead!"_ marched off towards the Boulevard Saint-Germain. The crowd pillaged
three baker's shops before the police attacked. Michel was arrested and
sentenced to six years solitary confinement. Public pressure soon forced the
granting of an amnesty. [**Anarchism**, pp. 251-2] August the same year saw
the publication of the anarchist paper **Le Drapeau Noir** (**The Black
Flag**) in Lyon which suggests that it had become a popular symbol within
anarchist circles. [_"Sur la Symbolique anarchiste"_, **Bulletin du CIRA**,
no. 62, p. 2] However, anarchists had been using red-and-black flags a number
of years previously (see [next section](append2.md#redblack)) so Michel's
use of the colour black was not totally without precedence.

Not long after, the black flag made its way to America. Paul Avrich reports
that on November 27, 1884, it was displayed in Chicago at an anarchist
demonstration. According to Avrich, August Spies, one of the Haymarket
martyrs, _"noted that this was the first occasion on which [the black flag]
had been unfurled on American soil."_ By January the following year,
_"[s]treet parades and mass outdoor demonstrations, with red and black banners
. . . were the most dramatic form of advertisement"_ for the revolutionary
anarchist movement in America. April 1885 saw Lucy Parsons and Lizzie Holmes
at the head of a protest march _"each bearing a flag, one black, the other
red."_ [**The Haymarket Tragedy**, p. 145, pp. 81-2 and p. 147] The Black Flag
continued to be used by anarchists in America, with one being seized by police
at an anarchist organised demonstration for the unemployed in 1893 at which
Emma Goldman spoke. [**Emma Goldman: A Documentary History of the American
Years**, vol. 1, p. 144] Twenty one years later, Alexander Berkman reported on
another anarchist inspired unemployed march in New York which raised the black
flag in _"menacing defiance in the face of parasitic contentment and self-
righteous arrogance"_ of the _"exploiters and well-fed idlers."_ [_"The
Movement of the Unemployed"_, **Anarchy! An Anthology of Emma Goldman's Mother
Earth**, p. 341]

It seems that black flags did not appear in Russia until the founding of the
**Chernoe Znamia** (**_"black banner"_**) movement in 1905. With the defeat of
that year's revolution, anarchism went underground again. The Black Flag, like
anarchism in general, re-emerged during the 1917 revolution. Anarchists in
Petrograd took part in the February demonstrations which brought down Tsarism
carrying black flags with _"Down with authority and capitalism!"_ on them. As
part of their activity, anarchists organised armed detachments in most towns
and cities called _"Black Guards"_ to defend themselves against counter-
revolutionary attempts by the provisional government. As noted above, the
Makhnovists fought Bolshevik and White dictatorship under Black Flags. On a
more dreary note, February 1921 saw the end of black flags in Soviet Russia.
That month saw Peter Kropotkin's funeral take place in Moscow. Twenty thousand
people marched in his honour, carrying black banners that read: _"Where there
is authority there is no freedom."_ [Paul Avrich, **The Russian Anarchists**,
p. 44, p. 124, p. 183 and p. 227] Only two weeks after Kropotkin's funeral
march, the Kronstadt rebellion broke out and anarchism was erased from Soviet
Russia for good. With the end of Stalinism, anarchism with its Black Flag re-
emerged all across Eastern Europe, including Russia.

While the events above are fairly well known, as has been related, the exact
origin of the black flag is not. What is known is that a large number of
Anarchist groups in the early 1880s adopted titles associated with black. In
July of 1881, the Black International was founded in London. This was an
attempt to reorganise the Anarchist wing of the recently dissolved First
International. In October 1881, a meeting in Chicago lead to the
**International Working People's Association** being formed in North America.
This organisation, also known as the **Black International**, affiliated to
the London organisation. [Woodcock, **Op. Cit.**, pp. 212-4 and p. 393] These
two conferences are immediately followed by Michel's demonstration (1883) and
the black flags in Chicago (1884).

Thus it was around the early 1880s that anarchism and the Black Flag became
inseparably linked. Avrich, for example, states that in 1884, the black flag
_"was the new anarchist emblem."_ [**The Haymarket Tragedy**, p. 144] In
agreement, Murray Bookchin reports that _"in later years, the Anarchists were
to adopt the black flag"_ when speaking of the Spanish Anarchist movement in
1870. [**The Spanish Anarchists**, p. 57] Walter and Heiner also note that
_"it was adopted by the anarchist movement during the 1880s."_ [Kropotkin,
**Act for Yourselves**, p. 128]

Now the question becomes why, exactly, black was chosen. The Chicago _"Alarm"_
stated that the black flag is _"the fearful symbol of hunger, misery and
death."_ [quoted by Avrich, **Op. Cit.**, p. 144] Bookchin asserts that
anarchists were _"to adopt the black flag as a symbol of the workers misery
and as an expression of their anger and bitterness."_ [**Op. Cit.**, p. 57]
Historian Bruce C. Nelson also notes that the Black Flag was considered _"the
emblem of hunger"_ when it was unfurled in Chicago in 1884. [**Beyond the
Martyrs**, p. 141 and p. 150] While it _"was interpreted in anarchist circles
as the symbol of death, hunger and misery"_ it was _"also said to be the
'emblem of retribution'"_ and in a labour procession in Cincinnati in January
1885, _"it was further acknowledged to be the banner of working-class
intransigence, as demonstrated by the words 'No Quarter' inscribed on it."_
[Donald C. Hodges, **Sandino's Communism**, p. 21] For Berkman, it was the
_"symbol of starvation and desperate misery."_ [**Op. Cit.**, p. 341] Louise
Michel stated that the _"black flag is the flag of strikes and the flag of
those who are hungry."_ [**Op. Cit.**, p. 168]

Along these lines, Albert Meltzer maintains that the association between the
black flag and working class revolt _"originated in Rheims [France] in 1831
('Work or Death') in an unemployed demonstration."_ [**The Anarcho-Quiz
Book**, p. 49] He went on to assert that it was Michel's action in 1883 that
solidified the association. The links from revolts in France to anarchism are
even stronger. As Murray Bookchin records, in Lyon _"[i]n 1831, the silk-
weaving artisans . . . rose in armed conflict to gain a better **tarif**, or
contract, from the merchants. For a brief period they actually took control of
the city, under red and black flags -- which made their insurrection a
memorable event in the history of revolutionary symbols. Their use of the word
**mutuelisme** to denote the associative disposition of society that they
preferred made their insurrection a memorable event in the history of
anarchist thought as well, since Proudhon appears to have picked up the word
from them during his brief stay in the city in 1843-4."_ [**The Third
Revolution**, vol. 2, p. 157] Sharif Gemie confirms this, noting that a police
report sent to the Lyon prefect that said: _"The silk-weavers of the Croix-
Rousse have decided that tomorrow they will go down to Lyon, carrying a black
flag, calling for work or death."_ The revolt saw the Black Flag raised:

> _"At eleven a.m. the silk-weavers' columns descended the slops of the Croix-
Rousse. Some carried black flags, the colour of mourning and a reminder of
their economic distress. Others pushed loaves of bread on the bayonets of
their guns and held them aloft. The symbolic force of this action was
reinforced by a repeatedly-shouted slogan: 'bread or lead!': in other words,
if they were not given bread which they could afford, then they were prepared
to face bullets. At some point during the rebellion, a more eloquent
expression was devised: '**Vivre en travaillant ou mourir en combattant**!' --
'Live working or die by fighting!'. Some witnesses report seeing this painted
on a black flag."_ [Sharif Gemie, **French Revolutions, 1815-1914**, pp.
52-53]

Kropotkin himself states that its use continued in the French labour movement
after this uprising. He notes that the Paris Workers _"raised in June [1848]
their black flag of 'Bread or Labour'"_ [**Act for Yourselves**, p. 100] Black
flags were also hung from windows in Paris on the 1st of March, 1871, in
defiance of the Prussians marching through the city after their victory in the
Franco-Prussian War. [Stewart Edwards, **The Communards of Paris, 1871**, p.
25]

The use of the black flag by anarchists, therefore, is an expression of their
roots and activity in the labour movement in Europe, particularly in France.
The anarchist adoption of the Black Flag by the movement in the 1880s reflects
its use as _"the traditional symbol of hunger, poverty and despair"_ and that
it was _"raised during popular risings in Europe as a sign of no surrender and
no quarter."_ [Walter and Becker, **Act for Yourselves**, p. 128] This is
confirmed by the first anarchist journal to be called **Black Flag**: _"On the
heights of the city [of Lyon] in la Croix-Rousse and Vaise, workers, pushed by
hunger, raised for the first time this sign of mourning and revenge [the black
flag], and made therefore of it the emblem of workers' demands."_ [**Le
Drapeau Noir**, no. 1, 12th August 1883] This was echoed by Louise Michel:

> _"How many wrathful people, young people, will be with us when the red and
black banners wave in the wind of anger! What a tidal wave it will be when the
red and black banners rise around the old wreck!_

> _"The red banner, which has always stood for liberty, frightens the
executioners because it is so red with our blood. The black flag, with layers
of blood upon it from those who wanted to live by working or die by fighting,
frightens those who want to live off the work of others. Those red and black
banners wave over us mourning our dead and wave over our hopes for the dawn
that is breaking."_ [**The Red Virgin: Memoirs of Louise Michel**, pp. 193-4]

The mass slaughter of Communards by the French ruling class after the fall of
the Paris Commune of 1871 could also explain the use of the Black Flag by
anarchists at this time. Black _"is the colour of mourning [at least in
Western cultures], it symbolises our mourning for dead comrades, those whose
lives were taken by war, on the battlefield (between states) or in the streets
and on the picket lines (between classes)."_ [Chico, _"letters"_, **Freedom**,
vol. 48, No. 12, p. 10] Given the 25 000 dead in the Commune, many of them
anarchists and libertarian socialists, the use of the Black Flag by anarchists
afterwards would make sense. Sandino, the Nicaraguan libertarian socialist
(whose use of the red-and-black colours we discuss [
below](append2.md#redblack)) also said that black stood for mourning (_"Red
for liberty; black for mourning; and the skull for a struggle to the death"_
[Donald C. Hodges, **Sandino's Communism**, p. 24]).

Regardless of other meanings, it is clear that anarchists took up the black
flag in the 1880s because it was, like the red flag, a recognised symbol of
working class resistance to capitalism. This is unsurprising given the nature
of anarchist politics. Just as anarchists base our ideas on actual working
class practice, we would also base our symbols on those created by that self-
activity. For example, Proudhon as well as taking the term _"mutualism"_ from
radical workers also argued that co-operative _"labour associations"_ had
_"spontaneously, without prompting and without capital been formed in Paris
and in Lyon. . . the proof of it [mutualism, the organisation of credit and
labour] . . . lies in current practice, revolutionary practice."_ [**No Gods,
No Masters**, vol. 1, pp. 59-60] He considered his ideas, in other words, to
be an expression of working class self-activity. Indeed, according to K.
Steven Vincent, there was _"close similarity between the associational ideal
of Proudhon . . . and the program of the Lyon Mutualists"_ and that there was
_"a remarkable convergence [between the ideas], and it is likely that Proudhon
was able to articulate his positive program more coherently because of the
example of the silk workers of Lyon. The socialist ideal that he championed
was already being realised, to a certain extent, by such workers."_ [**Pierre-
Joseph Proudhon and the Rise of French Republican Socialism**, p. 164] Other
anarchists have made similar arguments concerning anarchism being the
expression of tendencies within working class struggle against oppression and
exploitation and so the using of a traditional workers symbol would be a
natural expression of this aspect of anarchism.

Similarly, perhaps it is Louise Michel's comment that the Black Flag was the
_"flag of strikes"_ which could explain the naming of the **Black
International** founded in 1881 (and so the increasing use of the Black Flag
in anarchist circles in the early 1880s). Around the time of its founding
congress Kropotkin was formulating the idea that this organisation would be a
_"Strikers' International"_ (**Internationale Greviste**) -- it would be _"an
organisation of resistance, of strikes."_ [quoted by Martin A. Miller,
**Kropotkin**, p. 147] In December 1881 he discussed the revival of the
International Workers Association as a **_Strikers' International_** for to
_"be able to make the revolution, the mass of workers will have to organise
themselves. Resistance and strikes are excellent methods of organisation for
doing this."_ He stressed that the _"strike develops the sentiment of
solidarity"_ and argued that the First International _"was born of strikes; it
was fundamentally a strikers' organisation."_ [quoted by Caroline Cahm,
**Kropotkin and the Rise of Revolutionary Anarchism, 1872-1886**, p. 255 and
p. 256]

A _"Strikers International"_ would need the strikers flag and so, perhaps, the
**Black International** got its name. This, of course, fits perfectly with the
use of the Black Flag as a symbol of workers' resistance by anarchism, a
political expression of that resistance.

However, the black flag did not instantly replace the red flag as the main
anarchist symbol. The use of the red flag continued for some decades in
anarchist circles. Thus we find Kropotkin writing in the early 1880s of
_"anarchist groups . . . rais[ing] the red flag of revolution."_ As Woodcock
noted, the _"black flag was not universally accepted by anarchists at this
time. Many, like Kropotkin, still thought of themselves as socialists and of
the red flag as theirs also."_ [**Words of a Rebel**, p. 75 and p. 225] In
addition, we find the Chicago anarchists using both black and red flags all
through the 1880s. French Anarchists carried three red flags at the funeral of
Louise Michel's mother in 1885 as well as at her own funeral in January 1905.
[Louise Michel, **Op. Cit.**, p. 183 and p. 201] Anarchist in Japan, for
example, demonstrated under red flags bearing the slogans _"Anarchy"_ and
_"Anarchist Communism"_ in June, 1908. [John Crump, **Hatta Shuzo and Pure
Anarchism in Interwar Japan**, p. 25] Three years later, the Mexican
anarchists declared that they had _"hoisted the Red Flag on Mexico's fields of
action"_ as part of their _"war against Authority, war against Capital, and
war against the Church."_ They were _"fighting under the Red Flag to the
famous cry of 'Land and Liberty.'"_ [Ricardo Flores Magon, **Land and
Liberty**, p. 98 and p. 100]

So for a considerable period of time anarchists used red as well as black
flags as their symbol. The general drift away from the red flag towards the
black must be placed in the historical context. During the 1880s the socialist
movement was changing. Marxist social democracy was becoming the dominant
socialist trend, with libertarian socialism going into relative decline in
many areas. Thus the red flag was increasingly associated with the
authoritarian and statist (and increasingly reformist) side of the socialist
movement. In order to distinguish themselves from other socialists, the use of
the black flag makes perfect sense as it was it an accepted symbol of working
class revolt like the red flag.

After the Russian Revolution and its slide into dictatorship (first under
Lenin, then Stalin) anarchist use of the red flag decreased as it no longer
_"stood for liberty."_ Instead, it had become associated, at worse, with the
Communist Parties or, at best, bureaucratic, reformist and authoritarian
social democracy. This change can be seen from the Japanese movement. As noted
above, before the First World War anarchists there had happily raised the red
flag but in the 1920s they unfurled the black flag. Organised in the
**Kokushoku Seinen Renmei** (Black Youth League), they published **Kokushoku
Seinen** (Black Youth). By 1930, the anarchist theoretical magazine
**Kotushoku Sensen** (Black Battlefront) had been replaced by two journals
called **Kurohata** (Black Flag) and **Kuhusen** (Black Struggle). [John
Crump, **Op. Cit.**, pp. 69-71 and p. 88]

According to historian Candace Falk, _"[t]hough black has been associated with
anarchism in France since 1883, the colour red was the predominant symbol of
anarchism throughout this period; only after the First World War was the
colour black widely adopted."_ [**Emma Goldman: A Documentary History of the
American Years**, vol. 1, p. 208fn] As this change did not occur overnight, it
seems safe to conclude that while anarchism and the black flag had been
linked, at the latest, from the early 1880s, it did not become the definitive
anarchist symbol until the 1920s (Carlo Tresca in America was still talking of
standing _"beneath the red flag that is the immaculate flag of the anarchist
idea"_ in 1925. [quoted by Nunzio Pernicone, **Carlo Tresca: Portrait of a
Rebel**, p. 161]). Before then, anarchists used both it and the red flag as
their symbols of choice. After the Russian Revolution, anarchists would still
use red in their flags, but only when combined with black. In this way they
would not associate themselves with the tyranny of the USSR or the reformism
and statism of the mainstream socialist movement.

### 2 Why the red-and-black flag?

The red-and-black flag has been associated with anarchism for some time.
Murray Bookchin placed the creation of this flag in Spain:

> _"The presence of black flags together with red ones became a feature of
Anarchist demonstrations throughout Europe and the Americas. With the
establishment of the CNT, a single flag on which black and red were separated
diagonally, was adopted and used mainly in Spain."_ [**The Spanish
Anarchists**, p. 57]

George Woodcock also stressed the Spanish origin of the flag:

> _"The anarcho-syndicalist flag in Spain was black and red, divided
diagonally. In the days of the [First] International the anarchists, like
other socialist sects, carried the red flag, but later they tended to
substitute for it the black flag. The black-and-red flag symbolised an attempt
to unite the spirit of later anarchism with the mass appeal of the
International."_ [**Anarchism**, p. 325fn]

According to Abel Paz, anarchist historian and CNT militant in the 1930s, the
1st of May, 1931, was _"the first time in history [that] the red and black
flag flew over a CNT-FAI rally."_ This was the outcome of an important meeting
of CNT militants and anarchist groups to plan the May Day demonstrations in
Barcelona. One of the issues to be resolved was _"under what flag to march."_
One group was termed the _"Red Flag"_ anarchists (who _"put greater emphasis
on labour issues"_), the other _"Black Flag"_ anarchists (who were _"more
distant (at the time) from economic questions"_). However, with the newly
proclaimed Republic there were _"tremendous opportunities for mass
mobilisations"_ which made disagreements on how much emphasis to place on
labour issues _"meaningless."_ This allowed an accord to be reached with its
_"material expression"_ being _"making the two flags into one: the black and
red flag."_ [**Durruti in the Spanish Revolution**, p. 206]

However, the red-and-black flag was used by anarchists long before 1931,
indeed decades before the CNT was even formed. In fact, it, rather than the
black flag, may well have been the first specifically anarchist flag.

The earliest recorded use of the red-and-black colours was during the
attempted Bologna insurrection of August 1874 where participants were
_"sporting the anarchists' red and black cockade."_ [Nunzio Pernicone,
**Italian Anarchism, 1864-1892**, p. 93] In April 1877, a similar attempt at
provoking rebellion saw anarchists enter the small Italian town of Letino
_"wearing red and black cockades"_ and carrying a _"red and black banner."_
These actions helped to _"captur[e] national attention"_ and _"draw
considerable notice to the International and its socialist programme."_
[Nunzio Pernicone, **Op. Cit.**, pp. 124-5 and pp. 126-7] Significantly,
another historian notes that the insurgents in 1874 were _"decked out in the
red and black emblem of the International"_ while three years later they were
_"prominently displaying the red and black anarchist flag."_ [T. R.
Ravindranathan, **Bakunin and the Italians**, p. 208 and p. 228] Thus the
black-and-red flag, like the black flag, was a recognised symbol of the labour
movement (in this case, the Italian section of the First International) before
becoming linked to anarchism.

The red-and-black flag was used by anarchists a few years later in Mexico. At
an anarchist protest meeting on December 14th, 1879, at Columbus Park in
Mexico City _"[s]ome five thousand persons gathered replete with numerous red-
and-black flags, some of which bore the inscription 'La Social, Liga
International del Jura.' A large black banner bearing the inscription 'La
Social, Gran Liga International' covered the front of the speaker's
platform."_ The links between the Mexican and European anarchist movements
were strong, as the _"nineteenth-century Mexican urban labour-movement
maintained direct contact with the Jura branch of the . . . European-based
First International Workingmen's Association and at one stage openly
affiliated with it."_ [John M. Hart, **Anarchism and the Mexican Working
Class, 1860-1931**, p. 58 and p. 17] One year after it was founded, the
anarchist influenced **Casa del Obrero Mundial** organised Mexico's first May
Day demonstration in 1913 and _"between twenty and twenty-five thousand
workers gathered behind red and black flags"_ in Mexico City. [John Lear,
**Workers, Neighbors, and Citizens**, p. 236]

Augusto Sandino, the radical Nicaraguan national liberation fighter was so
inspired by the example of the Mexican anarcho-syndicalists that he based his
movement's flag on their red-and-black ones (the Sandinista's flag is divided
horizontally, rather than diagonally). As historian Donald C. Hodges notes,
Sandino's _"red and black flag had an anarcho-syndicalist origin, having been
introduced into Mexico by Spanish immigrants."_ Unsurprisingly, his flag was
considered a _"workers' flag symbolising their struggle for liberation."_
(Hodges refers to Sandino's _"peculiar brand of anarcho-communism"_ suggesting
that his appropriation of the flag indicated a strong libertarian theme to his
politics). [**Intellectual Foundations of the Nicaraguan Revolution**, p. 49,
p. 137 and p. 19]

This suggests that the red-and-black flag was rediscovered by the Spanish
Anarchists in 1931 rather than being invented by them. However, the CNT-FAI
seem to have been the first to bisect their flags diagonally black and red
(but other divisions, such as horizontally, were also used). In the English
speaking world, though, the use of the red-and-black flag by anarchists seems
to spring from the world-wide publicity generated by the Spanish Revolution in
1936. With CNT-FAI related information spreading across the world, the use of
the CNT inspired diagonally split red-and-black flag also spread until it
became a common anarchist and anarcho-syndicalist symbol in all countries.

For some, the red-and-black flag is associated with anarcho-syndicalism more
than anarchism. As Albert Meltzer put it, _"[t]he flag of the labour movement
(not necessarily only of socialism) is red. The CNT of Spain originated the
red-and-black of anarchosyndicalism (anarchism plus the labour movement)."_
[**Anarcho-Quiz Book**, p. 50] Donald C. Hodges makes a similar point, when he
states that _"[o]n the insignia of the Mexico's House of the World Worker [the
Mexican anarcho-syndicalist union], the red band stood for the economic
struggle of workers against the proprietary classes, and the black for their
insurrectionary struggle."_ [**Sandino's Communism**, p. 22]

This does not contradict its earliest uses in Italy and Mexico as those
anarchists took it for granted that they should work within the labour
movement to spread libertarian ideas. Therefore, it is not surprising we find
movements in Mexico and Italy using the same flags. Both were involved in the
First International and its anti-authoritarian off-spring. Both, like the Jura
Federation in Switzerland, were heavily involved in union organising and
strikes. Given the clear links and similarities between the collectivist
anarchism of the First International (the most famous advocate of which was
Bakunin) and anarcho-syndicalism, it is not surprising that they used similar
symbols. As Kropotkin argued, _"Syndicalism is nothing other than the rebirth
of the International -- federalist, worker, Latin."_ [quoted by Martin A.
Miller, **Kropotkin**, p. 176] So a rebirth of symbols would not be a co-
incidence.

Thus the red-and-black flag comes from the experience of anarchists in the
labour movement and is particularly, but not exclusively, associated with
anarcho-syndicalism. The black represents libertarian ideas and strikes (i.e.
direct action), the red represents the labour movement. Over time association
with anarcho-syndicalism has become less noted, with many non-syndicalist
anarchists happy to use the red-and-black flag (many anarcho-communists use
it, for example). It would be a good generalisation to state that social
anarchists are more inclined to use the red-and-black flag than individualist
anarchists just as social anarchists are usually more willing to align
themselves with the wider socialist and labour movements than individualists
(in modern times at least). However, both the red and black flags have their
roots in the labour movement and working class struggle which suggests that
the combination of both flags into one was a logical development. Given that
the black **and** red flags were associated with the Lyon uprising of 1831,
perhaps the development of the red-and-black flag is not too unusual.
Similarly, given that the Black Flag was the _"flag of strikes"_ (to quote
Louise Michel -- see [above](append2.md#black)) its use with the red flag of
the labour movement seems a natural development for a movement like anarchism
and anarcho-syndicalism which bases itself on direct action and the importance
of strikes in the class struggle.

So while associated with anarcho-syndicalism, the red-and-black flag has
become a standard anarchist symbol as the years have gone by, with the black
still representing anarchy and the red, social co-operation or solidarity.
Thus the red-and-black flag more than any one symbol symbolises the aim of
anarchism (_"Liberty of the individual and social co-operation of the whole
community"_ [Peter Kropotkin, **Act for Yourselves**, p. 102]) as well as its
means (_"[t]o make the revolution, the mass of workers will have to organise
themselves. Resistance and the strike are excellent means of organisation for
doing this"_ and _"the strike develops the sentiment of solidarity."_
[Kropotkin, quoted by Caroline Cahm, **Kropotkin and the Rise of Revolutionary
Anarchism: 1872-1186**, p. 255 and p. 256]).

### 3 Where does the circled-A come from?

The circled-A is, perhaps, even more famous than the Black and Red-and-Black
flags as an anarchist symbol (probably because it lends itself so well to
graffiti). According to Peter Marshall the _"circled-A"_ represents Proudhon's
maxim _"Anarchy is Order."_ [**Demanding the Impossible** p. 558] Peter
Peterson also adds that the circle is _"a symbol of unity and determination"_
which _"lends support to the off-proclaimed idea of international anarchist
solidarity."_ [_"Flag, Torch, and Fist: The Symbols of Anarchism"_,
**Freedom**, vol. 48, No. 11, pp. 8]

However, the origin of the "circled-A" as an anarchist symbol is less clear.
Many think that it started in the 1970s punk movement, but it goes back to a
much earlier period. According to Peter Marshall, _"[i]n 1964 a French group,
**Jeunesse Libertaire**, gave new impetus to Proudhon's slogan 'Anarchy is
Order' by creating the circled-A a symbol which quickly proliferated
throughout the world."_ [**Op. Cit.**, p. 445] This is not the earliest
sighting of this symbol. On November 25 1956, at its foundation in Brussels,
the **Alliance Ouvriere Anarchiste** (AOA) adopted this symbol. Going even
further, a BBC documentary on the Spanish Civil War shows an anarchist militia
member with a "circled-A" clearly on the back of his helmet. Other than this,
there is little know about the "circled-A"s origin.

Today the circled-A is one of the most successful images in the whole field of
political symbolising. Its _"incredible simplicity and directness led [it] to
become the accepted symbol of the restrengthened anarchist movement after the
revolt of 1968"_ particularly as in many, if not most, of the world's
languages the word for anarchy begins with the letter A. [Peter Peterson,
**Op. Cit.**, p. 8]

[‹ 11 What is the myth of "Natural Law"?](append1311.md "Go to previous
page" ) [up](index.md "Go to parent page" ) [Appendix : Anarchism and
Marxism ›](append3.md "Go to next page" )

