/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgIndex;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PgDiffIndexes {
    public static void createIndexes(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            String string = pgTable.getName();
            if (pgSchema == null) {
                for (PgIndex pgIndex : pgTable.getIndexes()) {
                    searchPathHelper.outputSearchPath(printWriter);
                    printWriter.println();
                    printWriter.println(pgIndex.getCreationSQL());
                }
                continue;
            }
            for (PgIndex pgIndex : PgDiffIndexes.getNewIndexes(pgSchema.getTable(string), pgTable)) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.println(pgIndex.getCreationSQL());
            }
        }
    }

    public static void dropIndexes(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgTable pgTable : pgSchema2.getTables()) {
            String string = pgTable.getName();
            PgTable pgTable2 = pgSchema == null ? null : pgSchema.getTable(string);
            for (PgIndex pgIndex : PgDiffIndexes.getDropIndexes(pgTable2, pgTable)) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.println(pgIndex.getDropSQL());
            }
        }
    }

    private static List<PgIndex> getDropIndexes(PgTable pgTable, PgTable pgTable2) {
        ArrayList<PgIndex> arrayList = new ArrayList<PgIndex>();
        if (pgTable2 != null && pgTable != null) {
            for (PgIndex pgIndex : pgTable.getIndexes()) {
                if (pgTable2.containsIndex(pgIndex.getName()) && pgTable2.getIndex(pgIndex.getName()).equals(pgIndex)) continue;
                arrayList.add(pgIndex);
            }
        }
        return arrayList;
    }

    private static List<PgIndex> getNewIndexes(PgTable pgTable, PgTable pgTable2) {
        ArrayList<PgIndex> arrayList;
        block4: {
            arrayList = new ArrayList<PgIndex>();
            if (pgTable2 == null) break block4;
            if (pgTable == null) {
                for (PgIndex pgIndex : pgTable2.getIndexes()) {
                    arrayList.add(pgIndex);
                }
            } else {
                for (PgIndex pgIndex : pgTable2.getIndexes()) {
                    if (pgTable.containsIndex(pgIndex.getName()) && pgTable.getIndex(pgIndex.getName()).equals(pgIndex)) continue;
                    arrayList.add(pgIndex);
                }
            }
        }
        return arrayList;
    }

    public static void alterComments(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgIndex pgIndex : pgSchema.getIndexes()) {
            PgIndex pgIndex2 = pgSchema2.getIndex(pgIndex.getName());
            if (pgIndex2 == null) continue;
            if (pgIndex.getComment() == null && pgIndex2.getComment() != null || pgIndex.getComment() != null && pgIndex2.getComment() != null && !pgIndex.getComment().equals(pgIndex2.getComment())) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON INDEX ");
                printWriter.print(PgDiffUtils.getQuotedName(pgIndex2.getName()));
                printWriter.print(" IS ");
                printWriter.print(pgIndex2.getComment());
                printWriter.println(';');
                continue;
            }
            if (pgIndex.getComment() == null || pgIndex2.getComment() != null) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("COMMENT ON INDEX ");
            printWriter.print(PgDiffUtils.getQuotedName(pgIndex2.getName()));
            printWriter.println(" IS NULL;");
        }
    }

    private PgDiffIndexes() {
    }
}

