/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import net.sf.jiapi.file.Field;
import net.sf.jiapi.file.attribute.AnnotationBase;
import net.sf.jiapi.file.attribute.AnnotationsAttribute;
import net.sf.jiapi.reflect.JiapiAnnotation;
import net.sf.jiapi.reflect.JiapiClass;
import net.sf.jiapi.reflect.Loader;
import net.sf.jiapi.reflect.TypeHelper;

public class JiapiField {
    private JiapiClass declaringClass;
    private Field field;

    public JiapiField(Field f) {
        this.field = f;
    }

    public String getName() {
        return this.field.getName();
    }

    public JiapiClass getType() throws ClassNotFoundException {
        Loader loader = this.getDeclaringClass().getLoader();
        JiapiClass clazz = null;
        try {
            clazz = loader.loadClass(this.getTypeName());
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(this.getTypeName());
        }
        return clazz;
    }

    public String getTypeName() {
        String descriptor = this.getDescriptor();
        String type = TypeHelper.descriptorToType(descriptor);
        return type;
    }

    String getDescriptor() {
        return this.field.getDescriptor();
    }

    public int getModifiers() {
        return this.field.getAccessFlags();
    }

    Field getField() {
        return this.field;
    }

    public JiapiClass getDeclaringClass() {
        return this.declaringClass;
    }

    public JiapiAnnotation[] getDeclaredAnnotations() {
        AnnotationsAttribute rva = (AnnotationsAttribute)this.field.getAttribute("RuntimeVisibleAnnotations");
        LinkedList annotations = new LinkedList();
        if (rva != null) {
            annotations.addAll(rva.getAnnotations());
        }
        if ((rva = (AnnotationsAttribute)this.field.getAttribute("RuntimeInvisibleAnnotations")) != null) {
            annotations.addAll(rva.getAnnotations());
        }
        JiapiAnnotation[] aa = new JiapiAnnotation[annotations.size()];
        for (int i = 0; i < aa.length; ++i) {
            AnnotationBase.Annotation a = (AnnotationBase.Annotation)annotations.get(i);
            aa[i] = new JiapiAnnotation(a);
        }
        return aa;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(Modifier.toString(this.getModifiers()));
        sb.append(' ');
        sb.append(this.getTypeName());
        sb.append(' ');
        sb.append(this.getName());
        return sb.toString();
    }

    void setDeclaringClass(JiapiClass declaringClass) {
        this.declaringClass = declaringClass;
    }
}

