dnl  Intel Pentium mpn_copyd -- copy limb vector, decrementing.
dnl
dnl  P5: 1.25 cycles/limb

dnl  Copyright 1996, 2001 Free Software Foundation, Inc.
dnl 
dnl  This file is part of the GNU MP Library.
dnl 
dnl  The GNU MP Library is free software; you can redistribute it and/or
dnl  modify it under the terms of the GNU Lesser General Public License as
dnl  published by the Free Software Foundation; either version 2.1 of the
dnl  License, or (at your option) any later version.
dnl 
dnl  The GNU MP Library is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl  Lesser General Public License for more details.
dnl 
dnl  You should have received a copy of the GNU Lesser General Public
dnl  License along with the GNU MP Library; see the file COPYING.LIB.  If
dnl  not, write to the Free Software Foundation, Inc., 59 Temple Place -
dnl  Suite 330, Boston, MA 02111-1307, USA.

include(`../config.m4')


C void mpn_copyd (mp_ptr dst, mp_srcptr src, mp_size_t size);
C
C See comments in copyi.asm.

defframe(PARAM_SIZE,12)
defframe(PARAM_SRC, 8)
defframe(PARAM_DST, 4)

PROLOGUE(mpn_copyd)
deflit(`FRAME',0)

	movl	PARAM_SRC, %eax
	movl	PARAM_SIZE, %ecx

	pushl	%esi	FRAME_pushl()
	pushl	%edi	FRAME_pushl()

	leal	-4(%eax,%ecx,4), %eax		C &src[size-1]
	movl	PARAM_DST, %edx

	subl	$7, %ecx			C size-7
	jle	L(end)

	movl	28-4(%edx,%ecx,4), %esi		C prefetch cache, dst[size-1]
	nop

L(top):
	C eax	src, decrementing
	C ebx
	C ecx	counter, limbs
	C edx	dst
	C esi	scratch
	C edi	scratch
	C ebp

	movl	28-32(%edx,%ecx,4), %esi	C prefetch dst cache line
	subl	$8, %ecx

	movl	(%eax), %esi			C read words pairwise
	movl	-4(%eax), %edi
	movl	%esi, 56(%edx,%ecx,4)		C store words pairwise
	movl	%edi, 52(%edx,%ecx,4)

	movl	-8(%eax), %esi
	movl	-12(%eax), %edi
	movl	%esi, 48(%edx,%ecx,4)
	movl	%edi, 44(%edx,%ecx,4)

	movl	-16(%eax), %esi
	movl	-20(%eax), %edi
	movl	%esi, 40(%edx,%ecx,4)
	movl	%edi, 36(%edx,%ecx,4)

	movl	-24(%eax), %esi
	movl	-28(%eax), %edi
	movl	%esi, 32(%edx,%ecx,4)
	movl	%edi, 28(%edx,%ecx,4)

	leal	-32(%eax), %eax
	jg	L(top)


L(end):
	C ecx	-7 to 0, representing respectively 0 to 7 limbs remaining
	C eax	src end
	C edx	dst, next location to store

	addl	$4, %ecx
	jle	L(no4)

	movl	(%eax), %esi
	movl	-4(%eax), %edi
	movl	%esi, 8(%edx,%ecx,4)
	movl	%edi, 4(%edx,%ecx,4)

	movl	-8(%eax), %esi
	movl	-12(%eax), %edi
	movl	%esi, (%edx,%ecx,4)
	movl	%edi, -4(%edx,%ecx,4)

	subl	$16, %eax
	subl	$4, %ecx
L(no4):

	addl	$2, %ecx
	jle	L(no2)

	movl	(%eax), %esi
	movl	-4(%eax), %edi
	movl	%esi, (%edx,%ecx,4)
	movl	%edi, -4(%edx,%ecx,4)

	subl	$8, %eax
	subl	$2, %ecx
L(no2):

	jnz	L(done)

	movl	(%eax), %ecx
	movl	%ecx, (%edx)	C risk of cache bank clash here

L(done):
	popl	%edi
	popl	%esi

	ret

EPILOGUE()
