# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to Motorola V3m phones"""

from prototypes import *
from prototypes_moto import *
from p_etsi import *
from p_moto import *
from p_motov710 import *
from p_motov3m import *

import fnmatch

# We use LSB for all integer like fields
UINT=UINTlsb
BOOL=BOOLlsb

NUMBER_TYPE_WORK=0
NUMBER_TYPE_HOME=1
NUMBER_TYPE_MAIN=2
NUMBER_TYPE_MOBILE=3
NUMBER_TYPE_FAX=4
NUMBER_TYPE_PAGER=5
NUMBER_TYPE_EMAIL=6
NUMBER_TYPE_MAILING_LIST=7
NUMBER_TYPE_MOBILE2=8
NUMBER_TYPE_EMAIL2=9
NUMBER_TYPE_WWW=11
NUMBER_TYPE_MEMO=11
NUMBER_TYPE=frozenset([NUMBER_TYPE_WORK, NUMBER_TYPE_HOME, NUMBER_TYPE_MAIN,
                       NUMBER_TYPE_MOBILE, NUMBER_TYPE_FAX, NUMBER_TYPE_PAGER])
EMAIL_TYPE=frozenset([NUMBER_TYPE_EMAIL])
WWW_TYPE=frozenset([NUMBER_TYPE_WWW])
MEMO_TYPE=frozenset([NUMBER_TYPE_MEMO])
NUMBER_TYPE_NAME={
    NUMBER_TYPE_WORK: 'office',
    NUMBER_TYPE_HOME: 'home',
    NUMBER_TYPE_MAIN: 'main',
    NUMBER_TYPE_MOBILE: 'cell',
    NUMBER_TYPE_FAX: 'fax',
    NUMBER_TYPE_PAGER: 'pager',
    }
NUMBER_TYPE_CODE={
    'office': NUMBER_TYPE_WORK,
    'home': NUMBER_TYPE_HOME,
    'main': NUMBER_TYPE_MAIN,
    'cell': NUMBER_TYPE_MOBILE,
    'fax': NUMBER_TYPE_FAX,
    'pager': NUMBER_TYPE_PAGER }

PB_TOTAL_GROUP=14
PB_GROUP_RANGE=xrange(1, PB_TOTAL_GROUP+1)
PB_GROUP_NAME_LEN=24

PB_MAX_NUMBER_LEN=32
PB_MAX_NAME_LEN=24
PB_MAX_EMAIL_LEN=48

PB_FIRST_ENTRY=2
PB_TOTAL_ENTRIES=1430
# Slot 1 is voice mail
PB_RANGE=xrange(PB_FIRST_ENTRY,PB_TOTAL_ENTRIES+1)


class read_group_req(BaseProtogenClass):
    __fields=['command', 'start_index', 'end_index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(read_group_req,self).__init__(**dict)
        if self.__class__ is read_group_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(read_group_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(read_group_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MPGR=' })
        self.__field_command.writetobuffer(buf)
        try: self.__field_start_index
        except:
            self.__field_start_index=CSVINT(**{ 'default': 1 })
        self.__field_start_index.writetobuffer(buf)
        try: self.__field_end_index
        except:
            self.__field_end_index=CSVINT(**{ 'terminator': None,               'default': PB_TOTAL_GROUP })
        self.__field_end_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MPGR=' })
        self.__field_command.readfrombuffer(buf)
        self.__field_start_index=CSVINT(**{ 'default': 1 })
        self.__field_start_index.readfrombuffer(buf)
        self.__field_end_index=CSVINT(**{ 'terminator': None,               'default': PB_TOTAL_GROUP })
        self.__field_end_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MPGR=' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None, 'default': '+MPGR=' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_start_index(self):
        try: self.__field_start_index
        except:
            self.__field_start_index=CSVINT(**{ 'default': 1 })
        return self.__field_start_index.getvalue()

    def __setfield_start_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_start_index=value
        else:
            self.__field_start_index=CSVINT(value,**{ 'default': 1 })

    def __delfield_start_index(self): del self.__field_start_index

    start_index=property(__getfield_start_index, __setfield_start_index, __delfield_start_index, None)

    def __getfield_end_index(self):
        try: self.__field_end_index
        except:
            self.__field_end_index=CSVINT(**{ 'terminator': None,               'default': PB_TOTAL_GROUP })
        return self.__field_end_index.getvalue()

    def __setfield_end_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_end_index=value
        else:
            self.__field_end_index=CSVINT(value,**{ 'terminator': None,               'default': PB_TOTAL_GROUP })

    def __delfield_end_index(self): del self.__field_end_index

    end_index=property(__getfield_end_index, __setfield_end_index, __delfield_end_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('start_index', self.__field_start_index, None)
        yield ('end_index', self.__field_end_index, None)




class calendar_req_resp(BaseProtogenClass):
    __fields=['command', 'index', 'title', 'alarm_timed', 'alarm_enabled', 'start_time', 'start_date', 'duration', 'alarm_time', 'alarm_date', 'repeat_type', 'ex_event', 'ex_event_flag']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(calendar_req_resp,self).__init__(**dict)
        if self.__class__ is calendar_req_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(calendar_req_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(calendar_req_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        if self.command=='+MDBR:':
            self.__field_title.writetobuffer(buf)
            self.__field_alarm_timed.writetobuffer(buf)
            self.__field_alarm_enabled.writetobuffer(buf)
            self.__field_start_time.writetobuffer(buf)
            self.__field_start_date.writetobuffer(buf)
            self.__field_duration.writetobuffer(buf)
            self.__field_alarm_time.writetobuffer(buf)
            self.__field_alarm_date.writetobuffer(buf)
            self.__field_repeat_type.writetobuffer(buf)
        if self.command=='+MDBRE:':
            self.__field_ex_event.writetobuffer(buf)
            self.__field_ex_event_flag.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': ord(' '),                  'default': '+MDBR:' })
        self.__field_command.readfrombuffer(buf)
        self.__field_index=CSVINT()
        self.__field_index.readfrombuffer(buf)
        if self.command=='+MDBR:':
            self.__field_title=CSVSTRING()
            self.__field_title.readfrombuffer(buf)
            self.__field_alarm_timed=CSVINT()
            self.__field_alarm_timed.readfrombuffer(buf)
            self.__field_alarm_enabled=CSVINT()
            self.__field_alarm_enabled.readfrombuffer(buf)
            self.__field_start_time=CAL_TIME()
            self.__field_start_time.readfrombuffer(buf)
            self.__field_start_date=CAL_DATE()
            self.__field_start_date.readfrombuffer(buf)
            self.__field_duration=CSVINT()
            self.__field_duration.readfrombuffer(buf)
            self.__field_alarm_time=CAL_TIME()
            self.__field_alarm_time.readfrombuffer(buf)
            self.__field_alarm_date=CAL_DATE()
            self.__field_alarm_date.readfrombuffer(buf)
            self.__field_repeat_type=CSVINT()
            self.__field_repeat_type.readfrombuffer(buf)
        if self.command=='+MDBRE:':
            self.__field_ex_event=CSVINT()
            self.__field_ex_event.readfrombuffer(buf)
            self.__field_ex_event_flag=CSVINT(**{ 'terminator': None })
            self.__field_ex_event_flag.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': ord(' '),                  'default': '+MDBR:' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_index=value
        else:
            self.__field_index=CSVINT(value,)

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_title(self):
        return self.__field_title.getvalue()

    def __setfield_title(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_title=value
        else:
            self.__field_title=CSVSTRING(value,)

    def __delfield_title(self): del self.__field_title

    title=property(__getfield_title, __setfield_title, __delfield_title, None)

    def __getfield_alarm_timed(self):
        return self.__field_alarm_timed.getvalue()

    def __setfield_alarm_timed(self, value):
        if isinstance(value,CSVINT):
            self.__field_alarm_timed=value
        else:
            self.__field_alarm_timed=CSVINT(value,)

    def __delfield_alarm_timed(self): del self.__field_alarm_timed

    alarm_timed=property(__getfield_alarm_timed, __setfield_alarm_timed, __delfield_alarm_timed, None)

    def __getfield_alarm_enabled(self):
        return self.__field_alarm_enabled.getvalue()

    def __setfield_alarm_enabled(self, value):
        if isinstance(value,CSVINT):
            self.__field_alarm_enabled=value
        else:
            self.__field_alarm_enabled=CSVINT(value,)

    def __delfield_alarm_enabled(self): del self.__field_alarm_enabled

    alarm_enabled=property(__getfield_alarm_enabled, __setfield_alarm_enabled, __delfield_alarm_enabled, None)

    def __getfield_start_time(self):
        return self.__field_start_time.getvalue()

    def __setfield_start_time(self, value):
        if isinstance(value,CAL_TIME):
            self.__field_start_time=value
        else:
            self.__field_start_time=CAL_TIME(value,)

    def __delfield_start_time(self): del self.__field_start_time

    start_time=property(__getfield_start_time, __setfield_start_time, __delfield_start_time, None)

    def __getfield_start_date(self):
        return self.__field_start_date.getvalue()

    def __setfield_start_date(self, value):
        if isinstance(value,CAL_DATE):
            self.__field_start_date=value
        else:
            self.__field_start_date=CAL_DATE(value,)

    def __delfield_start_date(self): del self.__field_start_date

    start_date=property(__getfield_start_date, __setfield_start_date, __delfield_start_date, None)

    def __getfield_duration(self):
        return self.__field_duration.getvalue()

    def __setfield_duration(self, value):
        if isinstance(value,CSVINT):
            self.__field_duration=value
        else:
            self.__field_duration=CSVINT(value,)

    def __delfield_duration(self): del self.__field_duration

    duration=property(__getfield_duration, __setfield_duration, __delfield_duration, None)

    def __getfield_alarm_time(self):
        return self.__field_alarm_time.getvalue()

    def __setfield_alarm_time(self, value):
        if isinstance(value,CAL_TIME):
            self.__field_alarm_time=value
        else:
            self.__field_alarm_time=CAL_TIME(value,)

    def __delfield_alarm_time(self): del self.__field_alarm_time

    alarm_time=property(__getfield_alarm_time, __setfield_alarm_time, __delfield_alarm_time, None)

    def __getfield_alarm_date(self):
        return self.__field_alarm_date.getvalue()

    def __setfield_alarm_date(self, value):
        if isinstance(value,CAL_DATE):
            self.__field_alarm_date=value
        else:
            self.__field_alarm_date=CAL_DATE(value,)

    def __delfield_alarm_date(self): del self.__field_alarm_date

    alarm_date=property(__getfield_alarm_date, __setfield_alarm_date, __delfield_alarm_date, None)

    def __getfield_repeat_type(self):
        return self.__field_repeat_type.getvalue()

    def __setfield_repeat_type(self, value):
        if isinstance(value,CSVINT):
            self.__field_repeat_type=value
        else:
            self.__field_repeat_type=CSVINT(value,)

    def __delfield_repeat_type(self): del self.__field_repeat_type

    repeat_type=property(__getfield_repeat_type, __setfield_repeat_type, __delfield_repeat_type, None)

    def __getfield_ex_event(self):
        return self.__field_ex_event.getvalue()

    def __setfield_ex_event(self, value):
        if isinstance(value,CSVINT):
            self.__field_ex_event=value
        else:
            self.__field_ex_event=CSVINT(value,)

    def __delfield_ex_event(self): del self.__field_ex_event

    ex_event=property(__getfield_ex_event, __setfield_ex_event, __delfield_ex_event, None)

    def __getfield_ex_event_flag(self):
        return self.__field_ex_event_flag.getvalue()

    def __setfield_ex_event_flag(self, value):
        if isinstance(value,CSVINT):
            self.__field_ex_event_flag=value
        else:
            self.__field_ex_event_flag=CSVINT(value,**{ 'terminator': None })

    def __delfield_ex_event_flag(self): del self.__field_ex_event_flag

    ex_event_flag=property(__getfield_ex_event_flag, __setfield_ex_event_flag, __delfield_ex_event_flag, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('index', self.__field_index, None)
        if self.command=='+MDBR:':
            yield ('title', self.__field_title, None)
            yield ('alarm_timed', self.__field_alarm_timed, None)
            yield ('alarm_enabled', self.__field_alarm_enabled, None)
            yield ('start_time', self.__field_start_time, None)
            yield ('start_date', self.__field_start_date, None)
            yield ('duration', self.__field_duration, None)
            yield ('alarm_time', self.__field_alarm_time, None)
            yield ('alarm_date', self.__field_alarm_date, None)
            yield ('repeat_type', self.__field_repeat_type, None)
        if self.command=='+MDBRE:':
            yield ('ex_event', self.__field_ex_event, None)
            yield ('ex_event_flag', self.__field_ex_event_flag, None)




