Test --placeGapConsistently using a naive artificial test case.

Set up
  $ mkdir -p $OUTDIR

  $ Q=$DATDIR/test-pgc/query.fasta 
  $ T=$DATDIR/test-pgc/target.fasta 

  $ cat $Q
  >m54006_151021_185942/0/0_163
  CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTGTAAGCAGTTAACCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN
  >m54006_151021_185942/0/200_363 which_is_rc_of_0_163
  NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGTTAACTGCTTACAGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG

  $ cat $T
  >target
  CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
  TGTAAGCAGTTAAAA
  CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

Test m4 output
  $ O=$OUTDIR/pgc-naive.m4
  $ $BLASR_EXE $Q $T -m 4 --out $O --bestn 1 --placeGapConsistently && echo $?
  [INFO]* (glob)
  [INFO]* (glob)
  0
  $ cat $O
  m54006_151021_185942/0/0_163/0_163 target -555 98.2609 0 0 113 163 0 0 115 115 254
  m54006_151021_185942/0/200_363 target -555 98.2609 0 50 163 163 1 0 115 115 254

Test m5 output
  $ O=$OUTDIR/pgc-naive.m5
  $ $BLASR_EXE $Q $T -m 5 --out $O --bestn 1 --placeGapConsistently && echo $?
  [INFO]* (glob)
  [INFO]* (glob)
  0
  $ cat $O
  m54006_151021_185942/0/0_163/0_163 163 0 113 +  target 115 0 115 + -555 113 0 0 2 254 CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTGTAAGCAGTT--AACCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||**|||||||||||||||||||||||||||||||||||||||||||||||||||| CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTGTAAGCAGTTAAAACCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
  m54006_151021_185942/0/200_363 163 50 163 +  target 115 0 115 - -555 113 0 0 2 254 GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGTT--AACTGCTTACAGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG ||||||||||||||||||||||||||||||||||||||||||||||||||||**||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||| GGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGTTTTAACTGCTTACAGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGGG

Test sam output
  $ O=$OUTDIR/pgc-naive.sam
  $ $BLASR_EXE $Q $T --sam --out $O --bestn 1 --placeGapConsistently && echo $?
  [INFO]* (glob)
  [INFO]* (glob)
  0
  $ cat $O |grep -v '^@'
  m54006_151021_185942/0/0_163\t0\ttarget\t1\t254\t61=2D52=50S\t*\t0\t0\tCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTGTAAGCAGTTAACCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN\t*\tRG:Z:b6de17a9\tnp:i:1\tqe:i:163\tqs:i:0\tzm:i:0\tAS:i:-555\tNM:i:2 (esc)
  m54006_151021_185942/0/200_363\t16\ttarget\t1\t254\t61=2D52=50S\t*\t0\t0\tCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTGTAAGCAGTTAACCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN\t*\tRG:Z:b6de17a9\tnp:i:1\tqe:i:163\tqs:i:0\tzm:i:0\tAS:i:-555\tNM:i:2 (esc)


Test bam output
  $ O=$OUTDIR/pgc-naive.bam
  $ $BLASR_EXE $Q $T --bam --out $O --bestn 1 --placeGapConsistently && echo $?
  [INFO]* (glob)
  WARNING, BAM output without PacBio BAM or DATASET input is not supported by PacBio.
  [INFO]* (glob)
  0
  $ $SAMTOOLS_EXE view $O
  m54006_151021_185942/0/0_163\t0\ttarget\t1\t254\t61=2D52=50S\t*\t0\t0\tCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTGTAAGCAGTTAACCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN\t*\tRG:Z:b6de17a9\tnp:i:1\tqe:i:163\tqs:i:0\tzm:i:0\tAS:i:-555\tNM:i:2 (esc)
  m54006_151021_185942/0/200_363\t16\ttarget\t1\t254\t61=2D52=50S\t*\t0\t0\tCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTGTAAGCAGTTAACCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN\t*\tRG:Z:b6de17a9\tnp:i:1\tqe:i:163\tqs:i:0\tzm:i:0\tAS:i:-555\tNM:i:2 (esc)

Test bam input
  $ Q=$DATDIR/test-pgc/query.bam 
  $ O=$OUTDIR/pgc-naive-bamin-bamout.bam
  $ $BLASR_EXE $Q $T --bam --out $O --bestn 1 --placeGapConsistently && echo $?
  [INFO]* (glob)
  [INFO]* (glob)
  0
  $ $SAMTOOLS_EXE view $O
  m54006_151021_185942/0/0_163\t0\ttarget\t1\t254\t61=2D52=50S\t*\t0\t0\tCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTGTAAGCAGTTAACCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN\t*\tcx:i:2\tnp:i:1\tqe:i:163\tqs:i:0\tzm:i:0\trq:f:0.7\tRG:Z:a3e2f6e1\tAS:i:-555\tNM:i:2 (esc)
  m54006_151021_185942/0/200_363\t16\ttarget\t1\t254\t61=2D52=50S\t*\t0\t0\tCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCTGTAAGCAGTTAACCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN\t*\tcx:i:2\tnp:i:1\tqe:i:363\tqs:i:200\tzm:i:0\trq:f:0.7\tRG:Z:a3e2f6e1\tAS:i:-555\tNM:i:2 (esc)


Test conflicting options
  $ $BLASR_EXE $Q $T --bam --out $O --bestn 1 --rbao --placeGapConsistently 1>/dev/null 2>/dev/null && echo $?
  [1]

  $ $BLASR_EXE $Q $T --bam --out $O --bestn 1 --extend --placeGapConsistently 1>/dev/null 2>/dev/null && echo $?
  [1]

  $ $BLASR_EXE $Q $T --bam --out $O --bestn 1 --affine --placeGapConsistently 1>/dev/null 2>/dev/null && echo $?
  [1]
