#include "HTMLButton.h"



HTMLButton::HTMLButton() {
  initialize();
}

HTMLButton::HTMLButton(wxWindow *parent, wxWindowID id, const wxPoint& pos, const wxSize& size, long style, const wxString& name)
    : wxHtmlWindow(parent, id, pos, size, style, name) {
    initialize();

    Bind(wxEVT_ENTER_WINDOW, &HTMLButton::handleMouseEvent, this);
    Bind(wxEVT_LEAVE_WINDOW, &HTMLButton::handleMouseEvent, this);
    Bind(wxEVT_MOTION, &HTMLButton::handleMouseEvent, this);
    Bind(wxEVT_LEFT_DOWN, &HTMLButton::handleMouseEvent, this);
    Bind(wxEVT_LEFT_UP, &HTMLButton::handleMouseEvent, this);
}

HTMLButton::~HTMLButton() {
}

void HTMLButton::initialize() {
    m_styles["default"] = "<body>";
    m_styles["hover"] = "<body>";
    m_styles["active"] = "<body>";
    m_styles["disabled"] = "<body>";
    m_style = "default";
}

void HTMLButton::setStyleHTML(const wxString& style, const wxString& html) {
    m_styles[style] = html;
    updateHtml();
}

void HTMLButton::setHTML(const wxString& html) {
    m_html = html;
    updateHtml();
}

void HTMLButton::activateStyle(const wxString& style) {
    m_disabled = (style=="disabled");
    m_style = style;
    updateHtml();
}

void HTMLButton::updateHtml() {
    SetPage(m_styles[m_style]+m_html);
    //Refresh();
    //Update();
}

void HTMLButton::handleMouseEvent(wxMouseEvent& event) {
    event.StopPropagation();
    if (m_disabled) {
        return;
    }
    if (event.Entering()) {
        activateStyle("hover");
        SetCursor(GetDefaultHTMLCursor(wxHtmlWindowInterface::HTMLCursor_Link));
        m_clickState = 0;
    } else if (event.Leaving()) {
        activateStyle("default");
        SetCursor(wxNullCursor);
        m_clickState = 0;
    } else if (event.LeftDown()) {
        m_clickState = 1;
        activateStyle("active");
    } else if (event.LeftUp()) {
        if (m_clickState == 1) {
            wxCommandEvent ev(wxEVT_BUTTON);
            GetEventHandler()->ProcessEvent(ev);
        }
        activateStyle("hover");
        m_clickState = 0;
    }
}

void HTMLButton::simClick() {
    wxCommandEvent ev(wxEVT_BUTTON);
    GetEventHandler()->AddPendingEvent(ev);
}

