//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Device/Coord/ICoordSystem.cpp
//! @brief     Implements ICoordSystem class.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "Device/Coord/ICoordSystem.h"
#include "Base/Axis/FrameUtil.h"
#include "Base/Axis/Scale.h"
#include "Base/Util/Assert.h"

ICoordSystem::ICoordSystem(std::vector<const Scale*>&& axes)
    : Frame(std::move(axes))
{
}

ICoordSystem::~ICoordSystem() = default;

std::vector<const Scale*> ICoordSystem::defaultAxes() const
{
    return convertedAxes(defaultUnits());
}

std::vector<const Scale*> ICoordSystem::convertedAxes(Coords units) const
{
    std::vector<const Scale*> result;
    for (size_t i = 0; i < rank(); ++i)
        result.emplace_back(convertedAxis(i, units));
    return result;
}

Coords ICoordSystem::substituteDefaultUnits(Coords units) const
{
    return units == Coords::UNDEFINED ? defaultUnits() : units;
}
