//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Item/DataItemBundleWidget.cpp
//! @brief     Defines class DataItemBundleWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2022
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Item/DataItemBundleWidget.h"
#include "GUI/Model/Data/IntensityDataItem.h"
#include "GUI/Model/Data/SpecularDataItem.h"

DataItemBundleWidget::DataItemBundleWidget(QWidget* parent)
    : QWidget(parent)
{
}
DataItemBundleWidget::~DataItemBundleWidget() = default;

void DataItemBundleWidget::setIntensityItem(IntensityDataItem* item)
{
    m_intensityDataItem = item;

    // set nullptr at destruction
    if (m_intensityDataItem) {
        disconnect(m_intensityDataItem, &DataItem::destroyed, this, nullptr);
        connect(m_intensityDataItem, &DataItem::destroyed, this,
                [this] { m_intensityDataItem = nullptr; });
    }
}

void DataItemBundleWidget::setSpecularItems(const QList<SpecularDataItem*>& items)
{
    m_specularDataItems = items;

    // set nullptr at destruction
    for (auto*& item : m_specularDataItems)
        if (item) {
            disconnect(item, &DataItem::destroyed, this, nullptr);
            connect(item, &DataItem::destroyed, this, [&item] { item = nullptr; });
        }
}

QList<SpecularDataItem*> DataItemBundleWidget::specularDataItems() const
{
    QList<SpecularDataItem*> nonNullItems;
    for (auto* item : m_specularDataItems)
        if (item)
            nonNullItems.append(item);
    return nonNullItems;
}

SpecularDataItem* DataItemBundleWidget::currentSpecularDataItem() const
{
    if (specularDataItems().size() == 0)
        return nullptr;

    return specularDataItems().first();
}

IntensityDataItem* DataItemBundleWidget::intensityDataItem() const
{
    return m_intensityDataItem;
}
