/* *****************************************************
   THIS IS AN AUTOMATICALLY GENERATED FILE. DO NOT EDIT.
   *****************************************************

   Generated by:
     python
 */

/*! \file
    Declarations and macros for exception handling.
 */

#ifndef GLTBX_ERROR_H
#define GLTBX_ERROR_H

#include <scitbx/error_utils.h>

#define GLTBX_CHECK_POINT \
  std::cout << __FILE__ << "(" << __LINE__ << ")" << std::endl << std::flush
#define GLTBX_CHECK_POINT_MSG(msg) \
  std::cout << msg << " @ " __FILE__ << "(" << __LINE__ << ")" << std::endl << std::flush
#define GLTBX_EXAMINE(A) \
  std::cout << "variable " << #A << ": " << A << std::endl << std::flush

//! Common gltbx namespace.
namespace gltbx {

  //! All gltbx exceptions are derived from this class.
  class error : public ::scitbx::error_base<error>
  {
    public:

      //! General gltbx error message.
      explicit
      error(std::string const& msg) throw()
        : ::scitbx::error_base<error>("gltbx", msg)
      {}

      //! Error message with file name and line number.
      /*! Used by the macros below.
       */
      error(const char* file, long line, std::string const& msg = "",
            bool internal = true) throw()
        : ::scitbx::error_base<error>("gltbx", file, line, msg, internal)
      {}
  };

  //! Special class for "Index out of range." exceptions.
  /*! These exceptions are propagated to Python as IndexError.
   */
  class error_index : public error
  {
    public:
      //! Default constructor. The message may be customized.
      explicit
      error_index(std::string const& msg = "Index out of range.") throw()
        : error(msg)
      {}
  };

} // namespace gltbx

//! For throwing an error exception with file name, line number, and message.
#define GLTBX_ERROR(msg) \
  SCITBX_ERROR_UTILS_REPORT(gltbx::error, msg)
//! For throwing an "Internal Error" exception.
#define GLTBX_INTERNAL_ERROR() \
  SCITBX_ERROR_UTILS_REPORT_INTERNAL(gltbx::error)
//! For throwing a "Not implemented" exception.
#define GLTBX_NOT_IMPLEMENTED() \
  SCITBX_ERROR_UTILS_REPORT_NOT_IMPLEMENTED(gltbx::error)

//! Custom gltbx assertion.
#define GLTBX_ASSERT(assertion) \
  SCITBX_ERROR_UTILS_ASSERT(gltbx::error, GLTBX_ASSERT, assertion)

#endif // GLTBX_ERROR_H
