#!/bin/sh


spitshell=cat
package=librb

echo "Extracting $package/src/version.c..."

if test -r version.c.last
then
   generation=`sed -n 's/^const char \*generation = \"\(.*\)\";/\1/p' < version.c.last`
   if test ! "$generation" ; then generation=0; fi
else
   generation=0
fi

generation=`expr $generation + 1`

$spitshell >version.c <<!SUB!THIS!
/*
 *   librb: a library used by charybdis and other things
 *   src/version.c
 *
 *   Copyright (C) 1990 Chelsea Ashley Dyerman
 *   Copyright (C) 2008 ircd-ratbox development team
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is generated by version.c.SH. Any changes made will go away.
 */

#include "../include/serno.h"

const char *librb_generation = "$generation";
const char *librb_serno = SERNO;
const unsigned long int librb_datecode = DATECODE;

const char *librb_infotext[] =
{
  "$package --",
  "Based on the original code written by Jarkko Oikarinen",
  "Copyright 1988, 1989, 1990, 1991 University of Oulu, Computing Center",
  "Copyright (c) 1996-2001 Hybrid Development Team",
  "Copyright (c) 2002-2008 ircd-ratbox Development Team",
  "",
  "This program is free software; you can redistribute it and/or",
  "modify it under the terms of the GNU General Public License as",
  "published by the Free Software Foundation; either version 2, or",
  "(at your option) any later version.",
  "",
!SUB!THIS!

IFS='
'
for i in `grep -v '^$Id' ../CREDITS |tr -d '"'` ; do
echo "  \"$i\"," >> version.c
done
$spitshell >>version.c <<!SUB!THISTOO!
  "",
  0,
};
!SUB!THISTOO!
