/*
 * Copyright (c) 2002 Robert Collins.
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <robertc@hotmail.com>
 *
 */

#ifndef _FILESYSTEMVISITOR_H_
#define _FILESYSTEMVISITOR_H_

#include <string>
using namespace std;

class Directory;
class File;
class FileSystemVisitor
{
public:
  virtual bool visitFile(File &) {}
  virtual bool visitDirectory(Directory &){}
  virtual ~ FileSystemVisitor (){}
protected:
  FileSystemVisitor () {}
  FileSystemVisitor (FileSystemVisitor const &);
  FileSystemVisitor & operator= (FileSystemVisitor const &);
};

#endif // _FILESYSTEMVISITOR_H_
