(in-package :consfigurator.util.posix1e)

(include "sys/capability.h")

(ctype cap_t "cap_t")
(ctype cap_value_t "cap_value_t")

(cenum cap_flag_t
       ((:cap-effective "CAP_EFFECTIVE"))
       ((:cap-permitted "CAP_PERMITTED"))
       ((:cap-inheritable "CAP_INHERITABLE")))
(cenum cap_flag_value_t ((:cap-set "CAP_SET")) ((:cap-clear "CAP_CLEAR")))

(constant (+CAP-CHOWN+                "CAP_CHOWN"))
(constant (+CAP-DAC-OVERRIDE+         "CAP_DAC_OVERRIDE"))
(constant (+CAP-DAC-READ-SEARCH+      "CAP_DAC_READ_SEARCH"))
(constant (+CAP-FOWNER+               "CAP_FOWNER"))
(constant (+CAP-FSETID+               "CAP_FSETID"))
(constant (+CAP-KILL+                 "CAP_KILL"))
(constant (+CAP-SETGID+               "CAP_SETGID"))
(constant (+CAP-SETUID+               "CAP_SETUID"))

#+linux
(progn
  (constant (+CAP-SETPCAP+            "CAP_SETPCAP"))
  (constant (+CAP-LINUX-IMMUTABLE+    "CAP_LINUX_IMMUTABLE"))
  (constant (+CAP-NET-BIND-SERVICE+   "CAP_NET_BIND_SERVICE"))
  (constant (+CAP-NET-BROADCAST+      "CAP_NET_BROADCAST"))
  (constant (+CAP-NET-ADMIN+          "CAP_NET_ADMIN"))
  (constant (+CAP-NET-RAW+            "CAP_NET_RAW"))
  (constant (+CAP-IPC-LOCK+           "CAP_IPC_LOCK"))
  (constant (+CAP-IPC-OWNER+          "CAP_IPC_OWNER"))
  (constant (+CAP-SYS-MODULE+         "CAP_SYS_MODULE"))
  (constant (+CAP-SYS-RAWIO+          "CAP_SYS_RAWIO"))
  (constant (+CAP-SYS-CHROOT+         "CAP_SYS_CHROOT"))
  (constant (+CAP-SYS-PTRACE+         "CAP_SYS_PTRACE"))
  (constant (+CAP-SYS-PACCT+          "CAP_SYS_PACCT"))
  (constant (+CAP-SYS-ADMIN+          "CAP_SYS_ADMIN"))
  (constant (+CAP-SYS-BOOT+           "CAP_SYS_BOOT"))
  (constant (+CAP-SYS-NICE+           "CAP_SYS_NICE"))
  (constant (+CAP-SYS-RESOURCE+       "CAP_SYS_RESOURCE"))
  (constant (+CAP-SYS-TIME+           "CAP_SYS_TIME"))
  (constant (+CAP-SYS-TTY-CONFIG+     "CAP_SYS_TTY_CONFIG"))
  (constant (+CAP-MKNOD+              "CAP_MKNOD"))
  (constant (+CAP-LEASE+              "CAP_LEASE"))
  (constant (+CAP-AUDIT-WRITE+        "CAP_AUDIT_WRITE"))
  (constant (+CAP-AUDIT-CONTROL+      "CAP_AUDIT_CONTROL"))
  (constant (+CAP-SETFCAP+            "CAP_SETFCAP"))
  (constant (+CAP-MAC-OVERRIDE+       "CAP_MAC_OVERRIDE"))
  (constant (+CAP-MAC-ADMIN+          "CAP_MAC_ADMIN"))
  (constant (+CAP-SYSLOG+             "CAP_SYSLOG"))
  (constant (+CAP-WAKE-ALARM+         "CAP_WAKE_ALARM"))
  (constant (+CAP-BLOCK-SUSPEND+      "CAP_BLOCK_SUSPEND"))
  (constant (+CAP-AUDIT-READ+         "CAP_AUDIT_READ"))
  (constant (+CAP-PERFMON+            "CAP_PERFMON"))
  (constant (+CAP-BPF+                "CAP_BPF"))
  (constant (+CAP-CHECKPOINT-RESTORE+ "CAP_CHECKPOINT_RESTORE")))
