# ASRock Industrial IMB-1222 Thin Mini-ITX Motherboard

This page describes how to run coreboot on the [ASRock IMB-1222].

## Technology

```{eval-rst}
+------------+---------------------------------------------------------------+
| CPU        | Intel 10th Gen (Comet lake-S) Core Processors (LGA-1200)      |
|            | CPUs over 80W will be limited due to power design             |
+------------+---------------------------------------------------------------+
| DRAM       | 2 SO-DIMM slots, DDR4 2933/2666/2400 MHz                      |
+------------+---------------------------------------------------------------+
| Chipset    | Intel Q470E                                                   |
+------------+---------------------------------------------------------------+
| Super I/O  | Fintek F81966                                                 |
+------------+---------------------------------------------------------------+
| TPM        | Infineon SLB 9670VQ2.0                                        |
+------------+---------------------------------------------------------------+
| Boot       | USB, SATA, NVMe                                               |
+------------+---------------------------------------------------------------+
| Power      | Laptop Power Supply:                                          |
|            | - 12V DC-in (IMB-1222)                                        |
|            | - 12V~28V DC-in (IMB-1222-WV)                                 |
+------------+---------------------------------------------------------------+
```

```text
+--------------+                        +---------------------------+    +---------------+
|     eDP      |------------------------|                           |----|  DDR4 SODIMM  |
+--------------+                        |                           |    +---------------+
+--------------+    +--------------+    |                           |    +---------------+
|     HDMI     |----|  ITE IT6563  |----|                           |----|  DDR4 SODIMM  |
+--------------+    +--------------+    |                           |    +---------------+
+--------------+                        |      Intel 10th Gen       |
| Display Port |------------------------|      (Comet lake-S)       |
+--------------+                        |      Core Processors      |
+--------------+                        |         LGA-1200          |
| Display Port |------------------------|                           |
+--------------+                        |                           |
+--------------+    +--------------+    |                           |    +---------------+
|     LVDS     |----|  CH7511B-BF  |----|                           |----| PCIe Gen3 x16 |
+--------------+    +--------------+    +---------------------------+    +---------------+
                                                      |
                                                      |
+------------------+                    +---------------------------+    +---------------+
| 4 x USB 3.2 Gen1 |                    |                           |    |   2 x SATA    |
|    Connector     |--------------------|                           |----|   Connector   |
+------------------+                    |                           |    +---------------+
+------------------+                    |                           |    +---------------+
| 2 x USB 3.2 Gen1 |                    |                           |    | M.2 KeyM SATA |
|      Header      |--------------------|      Intel Q470E PCH      |----|  PCIe Gen3x4  |
+------------------+                    |                           |    +---------------+
+--------------+                        |                           |    +---------------+
| 2 x USB 2.0  |                        |                           |    |   M.2 Key E   |
|    Header    |------------------------|                           |----| PCIe Gen3 x1/ |
+--------------+                        |                           |    |  CNVi/USB2.0  |
+--------------+    +--------------+    |                           |    +---------------+
|     RJ45     |----| I225LM/I225V |----|                           |    +---------------+
+--------------+    +--------------+    |                           |    |  M.2 Key B    |
+--------------+    +--------------+    |                           |----| PCIe Gen3 x1/ |
|     RJ45     |----|    I219LM    |----|                           |    | USB3.0/USB2.0 |
+--------------+    +--------------+    |                           |    +---------------+
+--------------+    +--------------+    |                           |    +---------------+
|    Mic-in    |    |   Realtek    |    |                           |    | TPM INFINEON  |
|   Line-out   |----|    ALC887    |----|                           |----| SLB 9670VQ2.0 |
|    SPDIF     |    +--------------+    |                           |    +---------------+
+--------------+            |           +---------------------------+
                    +--------------+                  |
                    |    ALC122    |                  | LPC
                    +--------------+           +--------------+
+-----------------------+   +--------------+   |              |    +------------+
| 2 x COM RS232/422/482 |---|   ST3243E    |---|    Fintek    |----| CPU FAN x1 |
+-----------------------+   +--------------+   |    F81966    |    +------------+
+-----------------------+   +--------------+   |    SuperIO   |    +------------+
| 2 x COM RS232         |---|   ST3243E    |---|              |----| NCT 3941SA |
+-----------------------+   +--------------+   +--------------+    +------------+
                                                      |                   |
                                               +--------------+    +------------+
                                               |   8 x GPIO   |    | CHA FAN x1 |
                                               +--------------+    +------------+

```

This port was created without a schematic/boardview, reverse engineering only.
Feel free to make changes.

## Building coreboot

The following commands will help quickly configure and build a project for this board:

```bash
make distclean
touch .config
./util/scripts/config --enable VENDOR_ASROCK
./util/scripts/config --enable BOARD_ASROCK_IMB_1222
make olddefconfig
make
```

## Payloads

```{eval-rst}
+---------------+------+---------+-----------+
| OS / Payload  | EDK2 | SeaBIOS | LinuxBoot |
+===============+======+=========+===========+
| Ubuntu 22.04  |  V   |    V    |     V     |
+---------------+------+---------+-----------+
| Ubuntu 24.04  |  V   |    V    |     V     |
+---------------+------+---------+-----------+
| Windows 10    |  V   |         |           |
+---------------+------+---------+-----------+
| Android 13    |      |    V    |           |
+---------------+------+---------+-----------+
```

- LinuxBoot/Linux as payload;
- SeaBIOS (1.16.3);
- edk2 [MrChromebox fork] (uefipayload_2408).

- Ubuntu 22.04 (Linux 6.5.0-15-generic);
- Ubuntu 24.04 (Linux 6.8.0-41-generic);
- Microsoft Windows 10 Pro (10.0.19045.4780, 22H2 2022);
- Andoid 13, [Bliss OS] x86_64 (16.9.7, Linux 6.1.112-gloria-xanmod1).

## Flashing coreboot

```{eval-rst}
+---------------------+--------------------------+
| Type                | Value                    |
+=====================+==========================+
| Socketed flash      | yes                      |
+---------------------+--------------------------+
| Model               | W25Q256JV                |
|                     | MX25L25673G              |
+---------------------+--------------------------+
| Size                | 32 MiB                   |
+---------------------+--------------------------+
| Package             | WSON-8 8x6 mm            |
+---------------------+--------------------------+
| Write protection    | chipset PRR              |
+---------------------+--------------------------+
| Dual BIOS feature   | no                       |
+---------------------+--------------------------+
| Internal flashing   | after flashing coreboot  |
+---------------------+--------------------------+
```

The SPI flash can be accessed using [flashrom]. By default, only the
BIOS region of the flash is writable:

```bash
flashrom -p internal -N -w coreboot.rom --ifd -i bios
```

If you wish to change any other region, such as the Management Engine
or firmware descriptor, then an external programmer is required. More
information about this [here](../../tutorial/flashing_firmware/index.md).

## Working

- Dual Channel DDR4 2933/2666/2400 MHz;
- Intel UHD Graphics:
  - DP (both);
  - HDMI;
    - VGA Option ROM;
    - libgfxinit;
    - GOP;
- PCIe x16 Slot (Gen3);
- SATA ports;
- USB 2.0 ports;
- USB 3.2 ports;
- M.2 Key-E 2230 slot for Wireless (PCIe x1, USB 2.0 and CNVi);
- M.2 Key-B 3042/3052 slot for 4G/5G modem (PCIe x1);
- M.2 Key-M 2242/2260/2280 for SSD/NVMe (PCIE x4, SATA3);
- LAN1 Intel I225LM/I225V, 10/100/1000/2500 Mbps;
- LAN2 Intel I219LM, 10/100/1000 Mbps;
- Realtek ALC887 HD Audio (line-out, mic-in);
- COM 1/2/3/4 ports (Fintek f81966);
- onboard speaker;
- HWM/FANs control (Fintek f81966);
- S3 suspend and wake;
- TPM;
- disabling ME with me_cleaner [XutaxKamay fork] (v1.2-9-gf20532d).

## Unknown/untested

- USB 3.0 in M.2 Key-B 3042/3052 slot (currently disabled);
- eDP/LVDS (currently disabled);
- PCIe riser cards;
- SPDIF;
- SATA RAID.

[ASRock IMB-1222]: https://web.archive.org/web/20220924171403/https://www.asrockind.com/en-gb/IMB-1222
[flashrom]: https://flashrom.org/Flashrom
[MrChromebox fork]: https://github.com/MrChromebox/edk2
[XutaxKamay fork]: https://github.com/XutaxKamay/me_cleaner
[Bliss OS]: https://blissos.org/
