/* $Id: kmo_priv_sky_tweak.h,v 1.3 2013-09-13 09:10:28 erw Exp $
 *
 * This file is part of the KMOS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: erw $
 * $Date: 2013-09-13 09:10:28 $
 * $Revision: 1.3 $
 * $Name: not supported by cvs2svn $
 */

#ifndef KMOS_PRIV_SKY_TWEAK_H
#define KMOS_PRIV_SKY_TWEAK_H

/*-----------------------------------------------------------------------------
 *                              Includes
 *----------------------------------------------------------------------------*/

#include <cpl.h>

/*-----------------------------------------------------------------------------
 *              Types
 *-----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
 *                        Prototypes
 *----------------------------------------------------------------------------*/

void amoeba(double **p,
            double y[],
            int ndim,
            double ftol,
            double (*funk)(double []),
            int *nfunk);

cpl_bivector* kmo_get_thermal_background(
                            cpl_bivector* spectrum,
                            int remove_it);

cpl_error_code kmo_priv_sky_tweak_get_spectra(
                            const cpl_imagelist *object,
                            const cpl_imagelist *sky,
                            const cpl_vector *lambda,
                            const cpl_image *mask,
                            const int no_nans,
                            cpl_bivector **obj_spectrum_ptr,
                            cpl_bivector **sky_spectrum_ptr);

cpl_imagelist * kmo_priv_sky_tweak(
                            cpl_imagelist *object,
                            cpl_imagelist *sky,
                            const cpl_propertylist *header,
                            float min_frac,
                            int tbsub);

cpl_bivector* kmo_priv_sky_tweak_correct_vibrational_trans(
                            cpl_bivector *obj_spectrum,
                            cpl_bivector *sky_spectrum
                            /*, int line_full_width*/);


#endif
