/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __fft
#define __fft

#include <fftw3.h>
#include <levels.h>
#include <vector>

struct multi_curve;

struct fft {

  //
  // FFT of Bezier curve waveform using FFTW
  //


  fftwf_plan plan;
  float* in;
  fftwf_complex* out;

  std::vector<float> harms; // harmonics
  levels lev; // harmonics levels
  void draw (); // draw levels

  void go (multi_curve* crv); // do fft on a multiple segment bezier curve

  float f; // audio frequency used for fft
  int n; // num samples
  int halfn;

  float x, dx; // on bezier curve, or theta/dtheta on sine.

  fft ();
  ~fft ();

};

#endif
