/*
 * Decompiled with CFR 0.152.
 */
package dumphd.bdplus;

import dumphd.bdplus.SubTable;
import dumphd.util.ByteArray;
import dumphd.util.ByteSource;
import dumphd.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ConversionTable {
    private ArrayList<SubTable> tables = new ArrayList();
    private HashMap<Long, Integer> indexTable = new HashMap(128);

    public ConversionTable() {
    }

    public ConversionTable(ByteSource source) throws IOException {
        if (source.read(Utils.buffer, 0, 2) != 2) {
            throw new IOException("Unexpected EOF, conversion table too small for header");
        }
        int tableCount = ByteArray.getUShort(Utils.buffer, 0);
        this.tables.ensureCapacity(tableCount);
        int i = 0;
        while (i < tableCount) {
            SubTable subTable = new SubTable(source);
            this.tables.add(subTable);
            this.indexTable.put(subTable.getTableId(), i);
            ++i;
        }
    }

    public int parse(byte[] raw, int offset) throws IndexOutOfBoundsException {
        int tableCount = ByteArray.getUShort(raw, offset);
        offset += 2;
        this.tables.ensureCapacity(tableCount);
        int i = 0;
        while (i < tableCount) {
            SubTable subTable = new SubTable();
            offset = subTable.parse(raw, offset);
            this.tables.add(subTable);
            this.indexTable.put(subTable.getTableId(), i);
            ++i;
        }
        return offset;
    }

    public int size() {
        return this.tables.size();
    }

    public SubTable getSubTable(long tableId) {
        Integer index = this.indexTable.get(tableId);
        if (index != null) {
            return this.tables.get(index);
        }
        return null;
    }

    public Iterator<SubTable> iterator() {
        return this.tables.iterator();
    }
}

