/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.SequenceI;

public class SearchResults {
    Match[] matches;

    public void addResult(SequenceI seq, int start, int end) {
        if (this.matches == null) {
            this.matches = new Match[]{new Match(seq, start, end)};
            return;
        }
        int mSize = this.matches.length;
        Match[] tmp = new Match[mSize + 1];
        for (int m = 0; m < mSize; ++m) {
            tmp[m] = this.matches[m];
        }
        tmp[m] = new Match(seq, start, end);
        this.matches = tmp;
    }

    public int[] getResults(SequenceI sequence, int start, int end) {
        if (this.matches == null) {
            return null;
        }
        int[] result = null;
        int[] tmp = null;
        int matchStart = 0;
        int matchEnd = 0;
        for (int m = 0; m < this.matches.length; ++m) {
            boolean mfound = false;
            if (this.matches[m].sequence == sequence) {
                mfound = true;
                matchStart = sequence.findIndex(this.matches[m].start) - 1;
                matchEnd = sequence.findIndex(this.matches[m].end) - 1;
            } else if (this.matches[m].sequence == sequence.getDatasetSequence()) {
                mfound = true;
                matchStart = sequence.findIndex(this.matches[m].start) - 1;
                matchEnd = sequence.findIndex(this.matches[m].end) - 1;
            }
            if (!mfound || matchStart > end || matchEnd < start) continue;
            if (matchStart < start) {
                matchStart = start;
            }
            if (matchEnd > end) {
                matchEnd = end;
            }
            if (result == null) {
                result = new int[]{matchStart, matchEnd};
                continue;
            }
            int resultLength = result.length;
            tmp = new int[resultLength + 2];
            System.arraycopy(result, 0, tmp, 0, resultLength);
            result = tmp;
            result[resultLength] = matchStart;
            result[resultLength + 1] = matchEnd;
        }
        return result;
    }

    public int getSize() {
        return this.matches == null ? 0 : this.matches.length;
    }

    public SequenceI getResultSequence(int index) {
        return this.matches[index].sequence;
    }

    public int getResultStart(int index) {
        return this.matches[index].start;
    }

    public int getResultEnd(int index) {
        return this.matches[index].end;
    }

    class Match {
        SequenceI sequence;
        int start;
        int end;

        public Match(SequenceI seq, int start, int end) {
            this.sequence = seq;
            this.start = start;
            this.end = end;
        }
    }
}

