//
// File: PanelSaisieParametresCadre.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Mon Oct 16 17:38:13 2006
//

#include "PanelSaisieParametresCadre.h"
#include <wx/colordlg.h>


PanelSaisieParametresCadre::PanelSaisieParametresCadre(wxWindow* parent,int id,wxString nomcadre,wxColor couleurbouton):wxPanel(parent,id)
{
    sizer_couleur_cadre_staticbox= new wxStaticBox(this, -1, wxT("Couleur"));
    sizer_parametres_cadre_staticbox= new wxStaticBox(this, -1, nomcadre);
    panel_saisie_pourcentage_cadre = new PanelSaisieSlider(this,-1,wxT("Pourcentage: "),0,15,1.5,1);


    button_couleur_cadre= new wxButton(this, -1, wxT("-             -"), wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT);
    button_couleur_cadre->SetBackgroundColour(couleurbouton);
    button_couleur_cadre->SetForegroundColour(couleurbouton);

    checkbox_couleur_auto = new wxCheckBox(this, -1, wxT("Couleur Auto."));
    

    sizer_parametres_cadre= new wxStaticBoxSizer(sizer_parametres_cadre_staticbox, wxHORIZONTAL);
    wxStaticBoxSizer* sizer_couleur_cadre= new wxStaticBoxSizer(sizer_couleur_cadre_staticbox, wxHORIZONTAL);
    
    sizer_parametres_cadre->Add(panel_saisie_pourcentage_cadre, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    
    sizer_couleur_cadre->Add(button_couleur_cadre, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_couleur_cadre->Add(checkbox_couleur_auto, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_parametres_cadre->Add(sizer_couleur_cadre, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    
    SetSizer(sizer_parametres_cadre);//permet de retourner le bon sizer à la demande de GetSizer()

    // on connecte les événements
	Connect(button_couleur_cadre->GetId( ), wxEVT_COMMAND_BUTTON_CLICKED, 
											(wxObjectEventFunction) &PanelSaisieParametresCadre::on_click_button_couleur_cadre);

}


PanelSaisieParametresCadre::~PanelSaisieParametresCadre()
{
	// TODO: put destructor code here
}

void PanelSaisieParametresCadre::on_click_button_couleur_cadre(wxCommandEvent& event)
{
	wxColourDialog dialog(this);
	if (dialog.ShowModal()==wxID_OK)
	{
		wxColourData retData=dialog.GetColourData();
		wxColour col=retData.GetColour();
		button_couleur_cadre->SetBackgroundColour(col);
		button_couleur_cadre->SetForegroundColour(col);
	}	
}	

double PanelSaisieParametresCadre::GetPourcentage()
{
    return panel_saisie_pourcentage_cadre->GetValeurReelle();
}    

wxColor PanelSaisieParametresCadre::GetCouleur()
{
    return button_couleur_cadre->GetBackgroundColour();
}

bool PanelSaisieParametresCadre::GetCouleurAuto()
{
    return checkbox_couleur_auto->GetValue();
}
