/* $Id: Reference.hpp 5047 2010-10-26 14:46:28Z potyra $ 
 *
 * Reference: pointer to a symbol.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __REFERENCE_HPP_INCLUDED
#define __REFERENCE_HPP_INCLUDED

#include "intermediate/operands/Operand.hpp"
#include <cassert>

namespace intermediate {

//! Reference to a named entity
/** The reference can refer to any named entity. Hence a Reference is
 *  always a pointer. It's main use is for indirect addressing, though it 
 *  sometimes might make sense to also take the pointer for pointer 
 *  arithmetics.
 */
class Reference : public Operand {
public:
	//! c'tor
	/** @param n referenced name
	 */
	Reference(
		std::string n
		) : 	Operand(OP_TYPE_POINTER), 
			name(n),
			associatedData(NULL),
			associatedContainer(NULL) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor &v) {
		v.visit(*this);
	}

	//! name of the variable or driver
	std::string name;

	//! Data entry to which this Reference refers to
	/** might be NULL, e.g. for References referring to
	 *  Containers or Types.
	 */
	const Data *associatedData;

	//! associated CodeContainer for Call and Proc opcodes.
	const CodeContainer *associatedContainer;
};

}; /* namespace intermediate */

#endif /* __REFERENCE_HPP_INCLUDED */
