-- $Id: generic1.vhdl 4386 2009-03-25 15:22:15Z potyra $

-- test if generics work, test default value

-- Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


ENTITY ewg IS
	GENERIC (
		g1 : integer := 42
	);
END ENTITY ewg;

ARCHITECTURE ewg_impl of ewg IS
BEGIN
	test_ewg : process
	begin
		assert g1 = 42 report "g1 must be 42" severity failure;
		wait;
	end process;

END ewg_impl;

ENTITY test_bench IS
END ENTITY test_bench;

ARCHITECTURE test_bench_impl of test_bench IS
begin
	-- generic must be set to default value
	test_ewg : ewg;

	p : process
	begin
		wait for 10 ms;
		assert false report "simulation finished" severity note;
		wait;
	
	end process;

end test_bench_impl;
