/* $Id: svg.h,v 1.20 2003/05/26 14:30:47 bkloet Exp $ */
#ifndef FFRENZY_SVG_H
#define FFRENZY_SVG_H

#include <stdio.h>

#include <libxml/xmlmemory.h>

#include "global.h"
#include "list.h"
#include "vector.h"

/******************************************************************************
 * Graphics SVG Series data structure
 *****************************************************************************/

typedef struct {
	List *states; /* List of Graphics_svg_state */
} Graphics_svg_series; /* Structure of multiple svg's */

typedef struct {
	char *state;
	int fpp;
	List *svg; /* List of Graphics_svg */
} Graphics_svg_state; /* Structure of multiple svg's */

typedef struct {
	List *pic; /* List of Graphics svg pictures */
} Graphics_svg; /* A single svg */

typedef enum {
	PT_BEZIER = 0,
	PT_RECT,
	PT_NRTYPES
} Graphics_svg_pic_type;

typedef struct {
  	Graphics_svg_pic_type type; /* Type of picture elem (bezier or rect) */
	Vector *normal; /* Normalization vector. */
	char *style; /* Style of the path (stroke, line-fill, etc) */
	char *path; /* String of path->d attribute (bezier curve info) */
	char *transform; /* Transformation information */
 	int width;
	int height;
	int x;
	int y;
} Graphics_svg_picture;

/******************************************************************************
 * Graphics SVG Series public functions
 *****************************************************************************/

void del_gss(Graphics_svg_series *gss);
  
Graphics_svg_series *parse_svg_series(char *SVGserie);

#endif
