# Changelog

## [Unreleased](https://github.com/mull-project/FileCheck.py/tree/HEAD)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.21...HEAD)

**Merged pull requests:**

- Regenerate CHANGELOG [\#185](https://github.com/mull-project/FileCheck.py/pull/185) ([stanislaw](https://github.com/stanislaw))
-  Bump version: 0.0.20 → 0.0.21  [\#184](https://github.com/mull-project/FileCheck.py/pull/184) ([stanislaw](https://github.com/stanislaw))

## [v0.0.21](https://github.com/mull-project/FileCheck.py/tree/v0.0.21) (2021-12-05)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.20...v0.0.21)

**Merged pull requests:**

- CHECK regex match: fix case when there are two+ "CHECK:" in a check line [\#183](https://github.com/mull-project/FileCheck.py/pull/183) ([stanislaw](https://github.com/stanislaw))
-  Config: dedicate class to store configuration  [\#182](https://github.com/mull-project/FileCheck.py/pull/182) ([stanislaw](https://github.com/stanislaw))
- CheckParser: dedicated class that parses CHECKs [\#181](https://github.com/mull-project/FileCheck.py/pull/181) ([stanislaw](https://github.com/stanislaw))
- Code climate: fix next batch of "; " occurences  [\#180](https://github.com/mull-project/FileCheck.py/pull/180) ([stanislaw](https://github.com/stanislaw))
-  Code climate: convert several tests to --strict-whitespace  [\#179](https://github.com/mull-project/FileCheck.py/pull/179) ([stanislaw](https://github.com/stanislaw))
-  Code climate: fix next batch of "; " occurences  [\#177](https://github.com/mull-project/FileCheck.py/pull/177) ([stanislaw](https://github.com/stanislaw))
- Code climate: fix next batch of "; " occurences [\#176](https://github.com/mull-project/FileCheck.py/pull/176) ([stanislaw](https://github.com/stanislaw))
- Code climate: fix a batch of "; RUN:" lines in the tests [\#175](https://github.com/mull-project/FileCheck.py/pull/175) ([stanislaw](https://github.com/stanislaw))
- CHECK-EMPTY: finish long standing TODO about the error message [\#174](https://github.com/mull-project/FileCheck.py/pull/174) ([stanislaw](https://github.com/stanislaw))
- Code climate: fix all Pylint warnings  [\#173](https://github.com/mull-project/FileCheck.py/pull/173) ([stanislaw](https://github.com/stanislaw))
- Check: named tuple -\> proper class [\#172](https://github.com/mull-project/FileCheck.py/pull/172) ([stanislaw](https://github.com/stanislaw))
- Code climate: introduce flake 8 and Pylint and fix all flake8 issues  [\#171](https://github.com/mull-project/FileCheck.py/pull/171) ([stanislaw](https://github.com/stanislaw))
- Code climate: introduce black and reformat everything [\#170](https://github.com/mull-project/FileCheck.py/pull/170) ([stanislaw](https://github.com/stanislaw))
- tasks: use improved one\_line\_command and run\_invoke\_cmd [\#169](https://github.com/mull-project/FileCheck.py/pull/169) ([stanislaw](https://github.com/stanislaw))
- docs: create "Extra features" section, add a task to generate docs [\#168](https://github.com/mull-project/FileCheck.py/pull/168) ([stanislaw](https://github.com/stanislaw))
-  tasks: add --focus parameter to run focused integration tests  [\#167](https://github.com/mull-project/FileCheck.py/pull/167) ([stanislaw](https://github.com/stanislaw))
- Add support for relative line number expressions [\#166](https://github.com/mull-project/FileCheck.py/pull/166) ([obycode](https://github.com/obycode))
- Regenerate CHANGELOG [\#165](https://github.com/mull-project/FileCheck.py/pull/165) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.19 → 0.0.20 [\#164](https://github.com/mull-project/FileCheck.py/pull/164) ([stanislaw](https://github.com/stanislaw))

## [v0.0.20](https://github.com/mull-project/FileCheck.py/tree/v0.0.20) (2021-11-27)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.19...v0.0.20)

**Closed issues:**

- Outputs are not treated as UTF-8 [\#162](https://github.com/mull-project/FileCheck.py/issues/162)

**Merged pull requests:**

- Force stdout to always encode UTF8 [\#163](https://github.com/mull-project/FileCheck.py/pull/163) ([stanislaw](https://github.com/stanislaw))
- Regenerate CHANGELOG [\#161](https://github.com/mull-project/FileCheck.py/pull/161) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.18 → 0.0.19 [\#160](https://github.com/mull-project/FileCheck.py/pull/160) ([stanislaw](https://github.com/stanislaw))

## [v0.0.19](https://github.com/mull-project/FileCheck.py/tree/v0.0.19) (2021-09-25)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.17...v0.0.19)

**Merged pull requests:**

- CI: Remove Python 3.5, update Poetry [\#159](https://github.com/mull-project/FileCheck.py/pull/159) ([stanislaw](https://github.com/stanislaw))
- Treat inputs as UTF-8 \(both stdin and check file\) [\#158](https://github.com/mull-project/FileCheck.py/pull/158) ([stanislaw](https://github.com/stanislaw))
- CI: enable testing on 3.9 [\#157](https://github.com/mull-project/FileCheck.py/pull/157) ([stanislaw](https://github.com/stanislaw))
- Bump version to 0.0.18 [\#156](https://github.com/mull-project/FileCheck.py/pull/156) ([stanislaw](https://github.com/stanislaw))
- CHECK: regex lines: match full lines when strict mode is enabled [\#155](https://github.com/mull-project/FileCheck.py/pull/155) ([stanislaw](https://github.com/stanislaw))
- README: Simplify background [\#154](https://github.com/mull-project/FileCheck.py/pull/154) ([stanislaw](https://github.com/stanislaw))
- docs and examples: remove semicolons [\#152](https://github.com/mull-project/FileCheck.py/pull/152) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.16 → 0.0.17 [\#151](https://github.com/mull-project/FileCheck.py/pull/151) ([stanislaw](https://github.com/stanislaw))

## [v0.0.17](https://github.com/mull-project/FileCheck.py/tree/v0.0.17) (2020-11-17)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.16...v0.0.17)

**Merged pull requests:**

- Remove deprecated ::add-path:: from GitHub Actions [\#150](https://github.com/mull-project/FileCheck.py/pull/150) ([tlively](https://github.com/tlively))
- Ignore check prefixes at the ends of words [\#149](https://github.com/mull-project/FileCheck.py/pull/149) ([tlively](https://github.com/tlively))
- Bump version: 0.0.15 → 0.0.16 [\#148](https://github.com/mull-project/FileCheck.py/pull/148) ([stanislaw](https://github.com/stanislaw))

## [v0.0.16](https://github.com/mull-project/FileCheck.py/tree/v0.0.16) (2020-10-05)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.15...v0.0.16)

**Merged pull requests:**

- Option: --dump-input=fail [\#147](https://github.com/mull-project/FileCheck.py/pull/147) ([stanislaw](https://github.com/stanislaw))
- Self testing: fix one edge case and some tests to enable FileCheck.py to pass on more tests [\#146](https://github.com/mull-project/FileCheck.py/pull/146) ([stanislaw](https://github.com/stanislaw))
- docs/06-options: fix syntax again [\#144](https://github.com/mull-project/FileCheck.py/pull/144) ([stanislaw](https://github.com/stanislaw))
- Update CHANGELOG [\#143](https://github.com/mull-project/FileCheck.py/pull/143) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.14 → 0.0.15 [\#142](https://github.com/mull-project/FileCheck.py/pull/142) ([stanislaw](https://github.com/stanislaw))

## [v0.0.15](https://github.com/mull-project/FileCheck.py/tree/v0.0.15) (2020-04-27)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.14...v0.0.15)

**Implemented enhancements:**

- Implement option: --implicit-check-not [\#75](https://github.com/mull-project/FileCheck.py/issues/75)

**Merged pull requests:**

- FileCheck.pdf: update implementation coverage [\#141](https://github.com/mull-project/FileCheck.py/pull/141) ([stanislaw](https://github.com/stanislaw))
- docs: --implicit-check-not option [\#140](https://github.com/mull-project/FileCheck.py/pull/140) ([stanislaw](https://github.com/stanislaw))
- Support more tests on Windows by switching to %printf \(part 2\) [\#139](https://github.com/mull-project/FileCheck.py/pull/139) ([stanislaw](https://github.com/stanislaw))
- --implicit-check-not: test multiple arguments and case insensitive match cases [\#138](https://github.com/mull-project/FileCheck.py/pull/138) ([stanislaw](https://github.com/stanislaw))
- Support more tests on Windows by switching to %printf [\#137](https://github.com/mull-project/FileCheck.py/pull/137) ([stanislaw](https://github.com/stanislaw))
- Option: --implicit-check-not [\#136](https://github.com/mull-project/FileCheck.py/pull/136) ([stanislaw](https://github.com/stanislaw))
- tools/expect\_exit: improve error reporting [\#135](https://github.com/mull-project/FileCheck.py/pull/135) ([stanislaw](https://github.com/stanislaw))
- docs: remove wrong section [\#134](https://github.com/mull-project/FileCheck.py/pull/134) ([stanislaw](https://github.com/stanislaw))
-  Bump version: 0.0.13 → 0.0.14  [\#133](https://github.com/mull-project/FileCheck.py/pull/133) ([stanislaw](https://github.com/stanislaw))

## [v0.0.14](https://github.com/mull-project/FileCheck.py/tree/v0.0.14) (2020-04-23)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.13...v0.0.14)

**Implemented enhancements:**

- CI setup [\#34](https://github.com/mull-project/FileCheck.py/issues/34)

**Closed issues:**

- Weird behavior with a leading space character [\#131](https://github.com/mull-project/FileCheck.py/issues/131)
- CI: set up Actions on Windows [\#112](https://github.com/mull-project/FileCheck.py/issues/112)
- Switch from Makefile to Invoke [\#102](https://github.com/mull-project/FileCheck.py/issues/102)

**Merged pull requests:**

- Fix --match-full-lines: strip leading and trailing whitespace unless --strict-whitespace [\#132](https://github.com/mull-project/FileCheck.py/pull/132) ([stanislaw](https://github.com/stanislaw))
- README: add Windows badge [\#130](https://github.com/mull-project/FileCheck.py/pull/130) ([stanislaw](https://github.com/stanislaw))
- lit.cfg: detect shell to fix running on Windows locally [\#129](https://github.com/mull-project/FileCheck.py/pull/129) ([stanislaw](https://github.com/stanislaw))
- tests: fix remaining test ?= lines \(part 2\) [\#128](https://github.com/mull-project/FileCheck.py/pull/128) ([stanislaw](https://github.com/stanislaw))
-  tests: fix remaining test ?= lines  [\#127](https://github.com/mull-project/FileCheck.py/pull/127) ([stanislaw](https://github.com/stanislaw))
- Edge case test: LLVM vs py: use lit.local.cfg [\#126](https://github.com/mull-project/FileCheck.py/pull/126) ([stanislaw](https://github.com/stanislaw))
- tests: remove obsolete first line check [\#125](https://github.com/mull-project/FileCheck.py/pull/125) ([stanislaw](https://github.com/stanislaw))
- Rename to work on Windows: cat -\> %cat [\#124](https://github.com/mull-project/FileCheck.py/pull/124) ([stanislaw](https://github.com/stanislaw))
- Rename to safer paths: %FILECHECK\_TESTER\_EXEC "%s" [\#123](https://github.com/mull-project/FileCheck.py/pull/123) ([stanislaw](https://github.com/stanislaw))
- Rename to safer paths: %FILECHECK\_EXEC "%s" and similar [\#122](https://github.com/mull-project/FileCheck.py/pull/122) ([stanislaw](https://github.com/stanislaw))
- Rename to safer paths: %S/filecheck.input -\> "%S/filecheck.input" [\#121](https://github.com/mull-project/FileCheck.py/pull/121) ([stanislaw](https://github.com/stanislaw))
- tasks and lit.cfg: adapt for running on Windows [\#120](https://github.com/mull-project/FileCheck.py/pull/120) ([stanislaw](https://github.com/stanislaw))
-  FileCheck 8.0.1, windows version built from LLVM  [\#119](https://github.com/mull-project/FileCheck.py/pull/119) ([stanislaw](https://github.com/stanislaw))
- tests: fix output of expect\_exit.py [\#118](https://github.com/mull-project/FileCheck.py/pull/118) ([stanislaw](https://github.com/stanislaw))
- tests: expect\_exit.py tool to replace "test $?" [\#117](https://github.com/mull-project/FileCheck.py/pull/117) ([stanislaw](https://github.com/stanislaw))
-  lit: introduce %cat to abstract the difference cat vs type  [\#116](https://github.com/mull-project/FileCheck.py/pull/116) ([stanislaw](https://github.com/stanislaw))
- FileCheck 9.0.1, windows version built from LLVM [\#115](https://github.com/mull-project/FileCheck.py/pull/115) ([stanislaw](https://github.com/stanislaw))
-  tasks: switch to passing parameters to lit with "--param"  [\#114](https://github.com/mull-project/FileCheck.py/pull/114) ([stanislaw](https://github.com/stanislaw))
- CI: GitHub Actions on Windows setup [\#113](https://github.com/mull-project/FileCheck.py/pull/113) ([stanislaw](https://github.com/stanislaw))
- README: add CI badge [\#110](https://github.com/mull-project/FileCheck.py/pull/110) ([stanislaw](https://github.com/stanislaw))
- CI setup with GitHub Actions [\#109](https://github.com/mull-project/FileCheck.py/pull/109) ([stanislaw](https://github.com/stanislaw))
- Poetry: set Python to 3.5, update bump2version [\#108](https://github.com/mull-project/FileCheck.py/pull/108) ([stanislaw](https://github.com/stanislaw))
- Switch from Makefile to Invoke \(closes \#102\) [\#107](https://github.com/mull-project/FileCheck.py/pull/107) ([stanislaw](https://github.com/stanislaw))
- Update CHANGELOG [\#106](https://github.com/mull-project/FileCheck.py/pull/106) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.12 → 0.0.13 [\#105](https://github.com/mull-project/FileCheck.py/pull/105) ([stanislaw](https://github.com/stanislaw))
-  Bump version: 0.0.11 → 0.0.12  [\#98](https://github.com/mull-project/FileCheck.py/pull/98) ([stanislaw](https://github.com/stanislaw))

## [v0.0.13](https://github.com/mull-project/FileCheck.py/tree/v0.0.13) (2020-03-25)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.12...v0.0.13)

**Fixed bugs:**

- Possible bug: multiple CHECK\_NOT strings get shadowed by each other [\#103](https://github.com/mull-project/FileCheck.py/issues/103)

**Closed issues:**

- Test against FileCheck from LLVM 8, 9 and 10. [\#100](https://github.com/mull-project/FileCheck.py/issues/100)

**Merged pull requests:**

-  CHECK-NOT: Fix edge case when CHECK\_NOT strings get shadowed by each  [\#104](https://github.com/mull-project/FileCheck.py/pull/104) ([stanislaw](https://github.com/stanislaw))
- tests/integration: add FileCheck 9.0.1 Linux and macOS [\#101](https://github.com/mull-project/FileCheck.py/pull/101) ([stanislaw](https://github.com/stanislaw))
- Update CHANGELOG [\#99](https://github.com/mull-project/FileCheck.py/pull/99) ([stanislaw](https://github.com/stanislaw))

## [v0.0.12](https://github.com/mull-project/FileCheck.py/tree/v0.0.12) (2020-02-16)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.11...v0.0.12)

**Closed issues:**

- `assert current\_scan\_base \> 0` [\#96](https://github.com/mull-project/FileCheck.py/issues/96)
- Missing LICENSE file? [\#95](https://github.com/mull-project/FileCheck.py/issues/95)
- Add documentation  [\#31](https://github.com/mull-project/FileCheck.py/issues/31)

**Merged pull requests:**

- CHECK-NEXT: fix edge case when on the first line without a match \(fixes \#96\) [\#97](https://github.com/mull-project/FileCheck.py/pull/97) ([stanislaw](https://github.com/stanislaw))
- docs: options: initial documentation [\#94](https://github.com/mull-project/FileCheck.py/pull/94) ([stanislaw](https://github.com/stanislaw))
- tests: switch to printf everywhere [\#93](https://github.com/mull-project/FileCheck.py/pull/93) ([stanislaw](https://github.com/stanislaw))
- docs: switch to printf in all examples [\#92](https://github.com/mull-project/FileCheck.py/pull/92) ([stanislaw](https://github.com/stanislaw))
- docs: check commands: CHECK-EMPTY: initial description [\#91](https://github.com/mull-project/FileCheck.py/pull/91) ([stanislaw](https://github.com/stanislaw))
- Edge case: Ghost empty string in LLVM while Py seems to be correct [\#88](https://github.com/mull-project/FileCheck.py/pull/88) ([stanislaw](https://github.com/stanislaw))
- docs: move examples to be run together with integration tests [\#87](https://github.com/mull-project/FileCheck.py/pull/87) ([stanislaw](https://github.com/stanislaw))
- docs: Known issues: path to itself [\#86](https://github.com/mull-project/FileCheck.py/pull/86) ([stanislaw](https://github.com/stanislaw))
- docs: Check commands: CHECK-NEXT description [\#85](https://github.com/mull-project/FileCheck.py/pull/85) ([stanislaw](https://github.com/stanislaw))
- docs: Check commands: CHECK-NOT description [\#84](https://github.com/mull-project/FileCheck.py/pull/84) ([stanislaw](https://github.com/stanislaw))
- docs: Check commands: CHECK description [\#83](https://github.com/mull-project/FileCheck.py/pull/83) ([stanislaw](https://github.com/stanislaw))
- CHECK command: improve error reporting by finishing old TODO [\#82](https://github.com/mull-project/FileCheck.py/pull/82) ([stanislaw](https://github.com/stanislaw))
- Add CHANGELOG [\#81](https://github.com/mull-project/FileCheck.py/pull/81) ([stanislaw](https://github.com/stanislaw))
- docs: Roadmap [\#80](https://github.com/mull-project/FileCheck.py/pull/80) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.10 → 0.0.11 [\#79](https://github.com/mull-project/FileCheck.py/pull/79) ([stanislaw](https://github.com/stanislaw))

## [v0.0.11](https://github.com/mull-project/FileCheck.py/tree/v0.0.11) (2019-12-26)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.10...v0.0.11)

**Closed issues:**

- FileCheck.py exits with 141 when run by LIT \(all checks are checked but there is still some input in stdin\) [\#71](https://github.com/mull-project/FileCheck.py/issues/71)

**Merged pull requests:**

- docs: initial LIT and FileCheck tutorial and updates in other pages  [\#78](https://github.com/mull-project/FileCheck.py/pull/78) ([stanislaw](https://github.com/stanislaw))
- docs: What is FileCheck [\#77](https://github.com/mull-project/FileCheck.py/pull/77) ([stanislaw](https://github.com/stanislaw))
- Update FileCheck.pdf: CHECK-NEXT [\#76](https://github.com/mull-project/FileCheck.py/pull/76) ([stanislaw](https://github.com/stanislaw))
- Switch to reading full input upfront [\#74](https://github.com/mull-project/FileCheck.py/pull/74) ([stanislaw](https://github.com/stanislaw))

## [v0.0.10](https://github.com/mull-project/FileCheck.py/tree/v0.0.10) (2019-12-21)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.9...v0.0.10)

## [v0.0.9](https://github.com/mull-project/FileCheck.py/tree/v0.0.9) (2019-12-21)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.8...v0.0.9)

**Merged pull requests:**

- Workaround to prevent exit 141 \(SIGPIPE\) when exiting while there's still some stdin input [\#73](https://github.com/mull-project/FileCheck.py/pull/73) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.7 → 0.0.8 [\#70](https://github.com/mull-project/FileCheck.py/pull/70) ([stanislaw](https://github.com/stanislaw))

## [v0.0.8](https://github.com/mull-project/FileCheck.py/tree/v0.0.8) (2019-12-20)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.7...v0.0.8)

**Merged pull requests:**

- CHECK-NOT: case when it is the last check but there is still some input [\#69](https://github.com/mull-project/FileCheck.py/pull/69) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.6 → 0.0.7 [\#68](https://github.com/mull-project/FileCheck.py/pull/68) ([stanislaw](https://github.com/stanislaw))

## [v0.0.7](https://github.com/mull-project/FileCheck.py/tree/v0.0.7) (2019-12-19)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.6...v0.0.7)

**Merged pull requests:**

- CHECK: fixing "possible intended match" code by adding another edge case [\#67](https://github.com/mull-project/FileCheck.py/pull/67) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.5 → 0.0.6 [\#65](https://github.com/mull-project/FileCheck.py/pull/65) ([stanislaw](https://github.com/stanislaw))

## [v0.0.6](https://github.com/mull-project/FileCheck.py/tree/v0.0.6) (2019-12-15)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.5...v0.0.6)

**Closed issues:**

- Implement --version  [\#46](https://github.com/mull-project/FileCheck.py/issues/46)

**Merged pull requests:**

- CHECK-NOT: edge case: failing CHECK has higher precedence than failing CHECK-NOT [\#64](https://github.com/mull-project/FileCheck.py/pull/64) ([stanislaw](https://github.com/stanislaw))
- CHECK-EMPTY: edge case when it matches the end of input but there are more checks to fail [\#62](https://github.com/mull-project/FileCheck.py/pull/62) ([stanislaw](https://github.com/stanislaw))
- --version: add more details about filecheck [\#61](https://github.com/mull-project/FileCheck.py/pull/61) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.4 → 0.0.5 [\#60](https://github.com/mull-project/FileCheck.py/pull/60) ([stanislaw](https://github.com/stanislaw))

## [v0.0.5](https://github.com/mull-project/FileCheck.py/tree/v0.0.5) (2019-12-13)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.4...v0.0.5)

**Implemented enhancements:**

- Implement CHECK-NEXT / Regex match [\#54](https://github.com/mull-project/FileCheck.py/issues/54)

**Merged pull requests:**

- Fix calculation of the current\_scan\_base [\#59](https://github.com/mull-project/FileCheck.py/pull/59) ([stanislaw](https://github.com/stanislaw))
- CHECK-EMPTY: consistent behavior when followed by normal CHECKS [\#58](https://github.com/mull-project/FileCheck.py/pull/58) ([stanislaw](https://github.com/stanislaw))
-  Refactoring: extract checks to a separate function  [\#57](https://github.com/mull-project/FileCheck.py/pull/57) ([stanislaw](https://github.com/stanislaw))
- CHECK-EMPTY: negative match [\#56](https://github.com/mull-project/FileCheck.py/pull/56) ([stanislaw](https://github.com/stanislaw))
- CHECK-NEXT: negative regex match [\#55](https://github.com/mull-project/FileCheck.py/pull/55) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.3 → 0.0.4 [\#53](https://github.com/mull-project/FileCheck.py/pull/53) ([stanislaw](https://github.com/stanislaw))
- Refactoring: remove obsolete code [\#51](https://github.com/mull-project/FileCheck.py/pull/51) ([stanislaw](https://github.com/stanislaw))

## [v0.0.4](https://github.com/mull-project/FileCheck.py/tree/v0.0.4) (2019-12-08)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/v0.0.3...v0.0.4)

**Fixed bugs:**

- Check the behavior when a string is passed [\#15](https://github.com/mull-project/FileCheck.py/issues/15)

**Merged pull requests:**

- Fix scanning for the best intended match  [\#50](https://github.com/mull-project/FileCheck.py/pull/50) ([stanislaw](https://github.com/stanislaw))
- Bump version: 0.0.2 → 0.0.3  [\#49](https://github.com/mull-project/FileCheck.py/pull/49) ([stanislaw](https://github.com/stanislaw))
- --version option  [\#48](https://github.com/mull-project/FileCheck.py/pull/48) ([stanislaw](https://github.com/stanislaw))

## [v0.0.3](https://github.com/mull-project/FileCheck.py/tree/v0.0.3) (2019-12-05)

[Full Changelog](https://github.com/mull-project/FileCheck.py/compare/ce965cb5571be21d0c38f6f64c6a85cc9720b620...v0.0.3)

**Implemented enhancements:**

- Feature: --check-prefix option [\#21](https://github.com/mull-project/FileCheck.py/issues/21)
- Feature: --strict-whitespace option [\#4](https://github.com/mull-project/FileCheck.py/issues/4)

**Closed issues:**

- Provide help command [\#41](https://github.com/mull-project/FileCheck.py/issues/41)
- Feature: "note: possible intended match here". [\#10](https://github.com/mull-project/FileCheck.py/issues/10)

**Merged pull requests:**

- --help command: remove artifacts introduced by testing [\#47](https://github.com/mull-project/FileCheck.py/pull/47) ([stanislaw](https://github.com/stanislaw))
- Everything what's needed to publish a pip package [\#45](https://github.com/mull-project/FileCheck.py/pull/45) ([stanislaw](https://github.com/stanislaw))
- Help command: enough to get going [\#44](https://github.com/mull-project/FileCheck.py/pull/44) ([stanislaw](https://github.com/stanislaw))
- Fix some typos [\#43](https://github.com/mull-project/FileCheck.py/pull/43) ([AlexDenisov](https://github.com/AlexDenisov))
- Add Poetry [\#42](https://github.com/mull-project/FileCheck.py/pull/42) ([stanislaw](https://github.com/stanislaw))
- docs: Hello World: minor fixes [\#40](https://github.com/mull-project/FileCheck.py/pull/40) ([stanislaw](https://github.com/stanislaw))
- docs: "Hello World" tutorial: first version [\#39](https://github.com/mull-project/FileCheck.py/pull/39) ([stanislaw](https://github.com/stanislaw))
- Print full path to the FileCheck [\#37](https://github.com/mull-project/FileCheck.py/pull/37) ([stanislaw](https://github.com/stanislaw))
- docs: Tutorial: Hello World some content [\#36](https://github.com/mull-project/FileCheck.py/pull/36) ([stanislaw](https://github.com/stanislaw))
- .readthedocs.yaml: boilerplate [\#35](https://github.com/mull-project/FileCheck.py/pull/35) ([stanislaw](https://github.com/stanislaw))
- docs: initial skeleton [\#33](https://github.com/mull-project/FileCheck.py/pull/33) ([stanislaw](https://github.com/stanislaw))
- FileCheck.pdf: update coverage [\#30](https://github.com/mull-project/FileCheck.py/pull/30) ([stanislaw](https://github.com/stanislaw))
- Test: CHECK-NOT/one\_string/02-negative\_match\_whitespaces [\#29](https://github.com/mull-project/FileCheck.py/pull/29) ([stanislaw](https://github.com/stanislaw))
- Refactoring: canonicalize\_whitespace [\#28](https://github.com/mull-project/FileCheck.py/pull/28) ([stanislaw](https://github.com/stanislaw))
- Feature: CHECK-NOT command: escaping non-regex parts [\#27](https://github.com/mull-project/FileCheck.py/pull/27) ([stanislaw](https://github.com/stanislaw))
- Tests: regroup CHECK/one\_string tests [\#26](https://github.com/mull-project/FileCheck.py/pull/26) ([stanislaw](https://github.com/stanislaw))
- Feature: CHECK command: escaping non-regex parts [\#25](https://github.com/mull-project/FileCheck.py/pull/25) ([stanislaw](https://github.com/stanislaw))
- Feature: check\_commands/CHECK-NEXT and main tests [\#24](https://github.com/mull-project/FileCheck.py/pull/24) ([stanislaw](https://github.com/stanislaw))
- Features: Stricter CHECK, CHECK-NOT, initial CHECK-NEXT, --check-prefix, --match-full-lines [\#23](https://github.com/mull-project/FileCheck.py/pull/23) ([stanislaw](https://github.com/stanislaw))
- README: Switch to task list [\#22](https://github.com/mull-project/FileCheck.py/pull/22) ([stanislaw](https://github.com/stanislaw))
- Refactoring: strip whitespaces "globally" [\#20](https://github.com/mull-project/FileCheck.py/pull/20) ([stanislaw](https://github.com/stanislaw))
-  Feature: --strict-whitespace/CHECK\_NOT  [\#19](https://github.com/mull-project/FileCheck.py/pull/19) ([stanislaw](https://github.com/stanislaw))
- Test: options/--strict-whitespace/02\_check\_has\_mixed\_spaces\_and\_tabs/ [\#17](https://github.com/mull-project/FileCheck.py/pull/17) ([stanislaw](https://github.com/stanislaw))
- Feature: initial options/--strict-whitespace [\#16](https://github.com/mull-project/FileCheck.py/pull/16) ([stanislaw](https://github.com/stanislaw))
- Tests: CHECK/three\_strings [\#14](https://github.com/mull-project/FileCheck.py/pull/14) ([stanislaw](https://github.com/stanislaw))
- Regroup tests in a more meaningful way [\#13](https://github.com/mull-project/FileCheck.py/pull/13) ([stanislaw](https://github.com/stanislaw))
- Feature: note: possible intended match here [\#12](https://github.com/mull-project/FileCheck.py/pull/12) ([stanislaw](https://github.com/stanislaw))
- Maintain a scan window to present a "scanning from here" line [\#11](https://github.com/mull-project/FileCheck.py/pull/11) ([stanislaw](https://github.com/stanislaw))
- CHECK/two\_strings/04-negative\_match\_second\_string/sample.itest: complete most of the checks [\#9](https://github.com/mull-project/FileCheck.py/pull/9) ([stanislaw](https://github.com/stanislaw))
- two\_strings/03-negative\_match\_first\_string/sample.itest: complete the checks [\#8](https://github.com/mull-project/FileCheck.py/pull/8) ([stanislaw](https://github.com/stanislaw))
- All tests: switch to --match-full-lines [\#6](https://github.com/mull-project/FileCheck.py/pull/6) ([stanislaw](https://github.com/stanislaw))
- Update README [\#5](https://github.com/mull-project/FileCheck.py/pull/5) ([stanislaw](https://github.com/stanislaw))
- CHECK-NOT command: more tests [\#3](https://github.com/mull-project/FileCheck.py/pull/3) ([stanislaw](https://github.com/stanislaw))
- Fix test: CHECK/one\_string/01-negative\_match [\#2](https://github.com/mull-project/FileCheck.py/pull/2) ([stanislaw](https://github.com/stanislaw))
- Feature: CHECK-NOT/one\_string/01-negative\_match [\#1](https://github.com/mull-project/FileCheck.py/pull/1) ([stanislaw](https://github.com/stanislaw))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
