# Hey emacs, use -*-rpm-spec-*- mode...

%define version 1.2.1

Summary:   Flexible backup script
Name:      flexbackup
Version:   %{version}
Release:   1
Epoch:     0
License:   GPL
Group:     Applications/Archiving
URL:       http://www.flexbackup.org
Source0:   flexbackup-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildArch: noarch
Packager:  Edwin Huffstutler <edwinh+flexbackup@edwinh.org>
Requires:  gzip
Requires:  fileutils
Requires:  findutils

#---------------------------------------------------------------------
%description
A flexible backup tool

Features:
   o Easy to configure
   o Uses dump, afio, GNU tar, cpio, star, pax, or zip archivers
   o Full and numbered levels of incremental backup (acts like "dump")
   o Compression and buffering options for all backup types
   o Does remote filesystems (over rsh/ssh; no special service)
   o Can backup only files not owned by rpm, or changed from rpm version
   o Writes to tapes, on-disk archive files, or on-disk directory trees
   o Keeps a table of contents so you know archives are on each tape
   o Nice log files


#---------------------------------------------------------------------
%prep
%setup -q

#---------------------------------------------------------------------
%build
make all PREFIX=/usr CONFFILE=/etc/flexbackup.conf

#---------------------------------------------------------------------
%install
rm -rf %{buildroot}
mkdir -p $RPM_BUILD_ROOT/etc
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man5
mkdir -p $RPM_BUILD_ROOT/var/lib/flexbackup
mkdir -p $RPM_BUILD_ROOT/var/log/flexbackup
make install PREFIX=$RPM_BUILD_ROOT/usr CONFFILE=$RPM_BUILD_ROOT/etc/flexbackup.conf

#---------------------------------------------------------------------
%clean
rm -rf %{buildroot}

#---------------------------------------------------------------------
%files
%defattr(-,root,root,-)
%config(noreplace) /etc/flexbackup.conf
%{_bindir}/*
%{_mandir}/*/*
%dir /var/lib/flexbackup
%dir /var/log/flexbackup
%doc CHANGES COPYING TODO README CREDITS INSTALL faq.html

#---------------------------------------------------------------------
%changelog
* Tue Sep 23 2003 Edwin Huffstutler <edwinh@computer.org>
- cleanup spec a bit

* Tue Jul 29 2003 Edwin Huffstutler <edwinh@hercules.my-net>
- add manpages, tweak a bit

* Thu Jul  3 2003 Edwin Huffstutler <edwinh@hercules.my-net>
- update description

* Tue Feb 18 2003 Edwin Huffstutler <edwinh@hercules.my-net>
- config file is noreplace

* Wed Jan 15 2003 Edwin Huffstutler <edwinh+flexbackup@edwinh.org>
- defattr in right spot

* Sun Jan 12 2003 Edwin Huffstutler <edwinh+flexbackup@edwinh.org>
- updated

* Sat Sep 25 1999 Edwin Huffstutler <edwinh+flexbackup@edwinh.org>
- add more requires, update description, email address.
- really goes in /usr/bin since it needs perl anyway --
  if you only have your root fs, run restore or tar by hand :)

* Sat Sep 18 1999 Edwin Huffstutler <edwinh+flexbackup@edwinh.org>
- initial rpm package
