//! [snippet1]
// We include what we need for the test
#include <gatb/gatb_core.hpp>

#include <iostream>

// We use the required packages
using namespace std;

/********************************************************************************/
/*                  Minimizer repartition object.                               */
/*                                                                              */
/*  This snippet shows how to retrieve the minimizer repartition object from a  */
/*  file generated by DSK (or dbgh5).                                           */
/*                                                                              */
/********************************************************************************/
int main (int argc, char* argv[])
{
    // We create a Storage product "foo" in HDF5 format
    Storage* storage = StorageFactory(STORAGE_HDF5).load(argv[1]);

    // We use locally this object (means that it should be automatically deleted when
    // leaving the enclosing instructions block).
    LOCAL (storage);

    try
    {
		// We get the group for dsk
		Group& dskGroup = storage->getGroup("dsk");

		Repartitor repart;
		repart.load (dskGroup);

		for (size_t i=0; i<(1<<16); i++)  {  printf ("%ld  %d\n", i, repart(i));  }
    }
    catch (Exception& e)
    {
        std::cerr << "EXCEPTION: " << e.getMessage() << std::endl;
    }
}
//! [snippet1]
