(* camlp5r *)
(* $Id: utf8.ml,v 0.1 2012-01-17 17:58:44 flh Exp $ *)

(*
   This is a huge utf-8 table converted as (encoding, name) list. For sure,
   this is not an optimal solution but it's only used in the process of
   converting "first name" and "surname" from a Gedcom file (-lf -ls -us).
*)

value utf8_list =
  [("/x41", "LATIN CAPITAL LETTER A");
   ("/x42", "LATIN CAPITAL LETTER B");
   ("/x43", "LATIN CAPITAL LETTER C");
   ("/x44", "LATIN CAPITAL LETTER D");
   ("/x45", "LATIN CAPITAL LETTER E");
   ("/x46", "LATIN CAPITAL LETTER F");
   ("/x47", "LATIN CAPITAL LETTER G");
   ("/x48", "LATIN CAPITAL LETTER H");
   ("/x49", "LATIN CAPITAL LETTER I");
   ("/x4a", "LATIN CAPITAL LETTER J");
   ("/x4b", "LATIN CAPITAL LETTER K");
   ("/x4c", "LATIN CAPITAL LETTER L");
   ("/x4d", "LATIN CAPITAL LETTER M");
   ("/x4e", "LATIN CAPITAL LETTER N");
   ("/x4f", "LATIN CAPITAL LETTER O");
   ("/x50", "LATIN CAPITAL LETTER P");
   ("/x51", "LATIN CAPITAL LETTER Q");
   ("/x52", "LATIN CAPITAL LETTER R");
   ("/x53", "LATIN CAPITAL LETTER S");
   ("/x54", "LATIN CAPITAL LETTER T");
   ("/x55", "LATIN CAPITAL LETTER U");
   ("/x56", "LATIN CAPITAL LETTER V");
   ("/x57", "LATIN CAPITAL LETTER W");
   ("/x58", "LATIN CAPITAL LETTER X");
   ("/x59", "LATIN CAPITAL LETTER Y");
   ("/x5a", "LATIN CAPITAL LETTER Z");
   ("/x61", "LATIN SMALL LETTER A");
   ("/x62", "LATIN SMALL LETTER B");
   ("/x63", "LATIN SMALL LETTER C");
   ("/x64", "LATIN SMALL LETTER D");
   ("/x65", "LATIN SMALL LETTER E");
   ("/x66", "LATIN SMALL LETTER F");
   ("/x67", "LATIN SMALL LETTER G");
   ("/x68", "LATIN SMALL LETTER H");
   ("/x69", "LATIN SMALL LETTER I");
   ("/x6a", "LATIN SMALL LETTER J");
   ("/x6b", "LATIN SMALL LETTER K");
   ("/x6c", "LATIN SMALL LETTER L");
   ("/x6d", "LATIN SMALL LETTER M");
   ("/x6e", "LATIN SMALL LETTER N");
   ("/x6f", "LATIN SMALL LETTER O");
   ("/x70", "LATIN SMALL LETTER P");
   ("/x71", "LATIN SMALL LETTER Q");
   ("/x72", "LATIN SMALL LETTER R");
   ("/x73", "LATIN SMALL LETTER S");
   ("/x74", "LATIN SMALL LETTER T");
   ("/x75", "LATIN SMALL LETTER U");
   ("/x76", "LATIN SMALL LETTER V");
   ("/x77", "LATIN SMALL LETTER W");
   ("/x78", "LATIN SMALL LETTER X");
   ("/x79", "LATIN SMALL LETTER Y");
   ("/x7a", "LATIN SMALL LETTER Z");
   ("/xc3/x80", "LATIN CAPITAL LETTER A WITH GRAVE");
   ("/xc3/x81", "LATIN CAPITAL LETTER A WITH ACUTE");
   ("/xc3/x82", "LATIN CAPITAL LETTER A WITH CIRCUMFLEX");
   ("/xc3/x83", "LATIN CAPITAL LETTER A WITH TILDE");
   ("/xc3/x84", "LATIN CAPITAL LETTER A WITH DIAERESIS");
   ("/xc3/x85", "LATIN CAPITAL LETTER A WITH RING ABOVE");
   ("/xc3/x86", "LATIN CAPITAL LETTER AE");
   ("/xc3/x87", "LATIN CAPITAL LETTER C WITH CEDILLA");
   ("/xc3/x88", "LATIN CAPITAL LETTER E WITH GRAVE");
   ("/xc3/x89", "LATIN CAPITAL LETTER E WITH ACUTE");
   ("/xc3/x8a", "LATIN CAPITAL LETTER E WITH CIRCUMFLEX");
   ("/xc3/x8b", "LATIN CAPITAL LETTER E WITH DIAERESIS");
   ("/xc3/x8c", "LATIN CAPITAL LETTER I WITH GRAVE");
   ("/xc3/x8d", "LATIN CAPITAL LETTER I WITH ACUTE");
   ("/xc3/x8e", "LATIN CAPITAL LETTER I WITH CIRCUMFLEX");
   ("/xc3/x8f", "LATIN CAPITAL LETTER I WITH DIAERESIS");
   ("/xc3/x90", "LATIN CAPITAL LETTER ETH");
   ("/xc3/x91", "LATIN CAPITAL LETTER N WITH TILDE");
   ("/xc3/x92", "LATIN CAPITAL LETTER O WITH GRAVE");
   ("/xc3/x93", "LATIN CAPITAL LETTER O WITH ACUTE");
   ("/xc3/x94", "LATIN CAPITAL LETTER O WITH CIRCUMFLEX");
   ("/xc3/x95", "LATIN CAPITAL LETTER O WITH TILDE");
   ("/xc3/x96", "LATIN CAPITAL LETTER O WITH DIAERESIS");
   ("/xc3/x98", "LATIN CAPITAL LETTER O WITH STROKE");
   ("/xc3/x99", "LATIN CAPITAL LETTER U WITH GRAVE");
   ("/xc3/x9a", "LATIN CAPITAL LETTER U WITH ACUTE");
   ("/xc3/x9b", "LATIN CAPITAL LETTER U WITH CIRCUMFLEX");
   ("/xc3/x9c", "LATIN CAPITAL LETTER U WITH DIAERESIS");
   ("/xc3/x9d", "LATIN CAPITAL LETTER Y WITH ACUTE");
   ("/xc3/x9e", "LATIN CAPITAL LETTER THORN");
   ("/xc3/x9f", "LATIN SMALL LETTER SHARP S");
   ("/xc3/xa0", "LATIN SMALL LETTER A WITH GRAVE");
   ("/xc3/xa1", "LATIN SMALL LETTER A WITH ACUTE");
   ("/xc3/xa2", "LATIN SMALL LETTER A WITH CIRCUMFLEX");
   ("/xc3/xa3", "LATIN SMALL LETTER A WITH TILDE");
   ("/xc3/xa4", "LATIN SMALL LETTER A WITH DIAERESIS");
   ("/xc3/xa5", "LATIN SMALL LETTER A WITH RING ABOVE");
   ("/xc3/xa6", "LATIN SMALL LETTER AE");
   ("/xc3/xa7", "LATIN SMALL LETTER C WITH CEDILLA");
   ("/xc3/xa8", "LATIN SMALL LETTER E WITH GRAVE");
   ("/xc3/xa9", "LATIN SMALL LETTER E WITH ACUTE");
   ("/xc3/xaa", "LATIN SMALL LETTER E WITH CIRCUMFLEX");
   ("/xc3/xab", "LATIN SMALL LETTER E WITH DIAERESIS");
   ("/xc3/xac", "LATIN SMALL LETTER I WITH GRAVE");
   ("/xc3/xad", "LATIN SMALL LETTER I WITH ACUTE");
   ("/xc3/xae", "LATIN SMALL LETTER I WITH CIRCUMFLEX");
   ("/xc3/xaf", "LATIN SMALL LETTER I WITH DIAERESIS");
   ("/xc3/xb0", "LATIN SMALL LETTER ETH");
   ("/xc3/xb1", "LATIN SMALL LETTER N WITH TILDE");
   ("/xc3/xb2", "LATIN SMALL LETTER O WITH GRAVE");
   ("/xc3/xb3", "LATIN SMALL LETTER O WITH ACUTE");
   ("/xc3/xb4", "LATIN SMALL LETTER O WITH CIRCUMFLEX");
   ("/xc3/xb5", "LATIN SMALL LETTER O WITH TILDE");
   ("/xc3/xb6", "LATIN SMALL LETTER O WITH DIAERESIS");
   ("/xc3/xb8", "LATIN SMALL LETTER O WITH STROKE");
   ("/xc3/xb9", "LATIN SMALL LETTER U WITH GRAVE");
   ("/xc3/xba", "LATIN SMALL LETTER U WITH ACUTE");
   ("/xc3/xbb", "LATIN SMALL LETTER U WITH CIRCUMFLEX");
   ("/xc3/xbc", "LATIN SMALL LETTER U WITH DIAERESIS");
   ("/xc3/xbd", "LATIN SMALL LETTER Y WITH ACUTE");
   ("/xc3/xbe", "LATIN SMALL LETTER THORN");
   ("/xc3/xbf", "LATIN SMALL LETTER Y WITH DIAERESIS");
   ("/xc4/x80", "LATIN CAPITAL LETTER A WITH MACRON");
   ("/xc4/x81", "LATIN SMALL LETTER A WITH MACRON");
   ("/xc4/x82", "LATIN CAPITAL LETTER A WITH BREVE");
   ("/xc4/x83", "LATIN SMALL LETTER A WITH BREVE");
   ("/xc4/x84", "LATIN CAPITAL LETTER A WITH OGONEK");
   ("/xc4/x85", "LATIN SMALL LETTER A WITH OGONEK");
   ("/xc4/x86", "LATIN CAPITAL LETTER C WITH ACUTE");
   ("/xc4/x87", "LATIN SMALL LETTER C WITH ACUTE");
   ("/xc4/x88", "LATIN CAPITAL LETTER C WITH CIRCUMFLEX");
   ("/xc4/x89", "LATIN SMALL LETTER C WITH CIRCUMFLEX");
   ("/xc4/x8a", "LATIN CAPITAL LETTER C WITH DOT ABOVE");
   ("/xc4/x8b", "LATIN SMALL LETTER C WITH DOT ABOVE");
   ("/xc4/x8c", "LATIN CAPITAL LETTER C WITH CARON");
   ("/xc4/x8d", "LATIN SMALL LETTER C WITH CARON");
   ("/xc4/x8e", "LATIN CAPITAL LETTER D WITH CARON");
   ("/xc4/x8f", "LATIN SMALL LETTER D WITH CARON");
   ("/xc4/x90", "LATIN CAPITAL LETTER D WITH STROKE");
   ("/xc4/x91", "LATIN SMALL LETTER D WITH STROKE");
   ("/xc4/x92", "LATIN CAPITAL LETTER E WITH MACRON");
   ("/xc4/x93", "LATIN SMALL LETTER E WITH MACRON");
   ("/xc4/x94", "LATIN CAPITAL LETTER E WITH BREVE");
   ("/xc4/x95", "LATIN SMALL LETTER E WITH BREVE");
   ("/xc4/x96", "LATIN CAPITAL LETTER E WITH DOT ABOVE");
   ("/xc4/x97", "LATIN SMALL LETTER E WITH DOT ABOVE");
   ("/xc4/x98", "LATIN CAPITAL LETTER E WITH OGONEK");
   ("/xc4/x99", "LATIN SMALL LETTER E WITH OGONEK");
   ("/xc4/x9a", "LATIN CAPITAL LETTER E WITH CARON");
   ("/xc4/x9b", "LATIN SMALL LETTER E WITH CARON");
   ("/xc4/x9c", "LATIN CAPITAL LETTER G WITH CIRCUMFLEX");
   ("/xc4/x9d", "LATIN SMALL LETTER G WITH CIRCUMFLEX");
   ("/xc4/x9e", "LATIN CAPITAL LETTER G WITH BREVE");
   ("/xc4/x9f", "LATIN SMALL LETTER G WITH BREVE");
   ("/xc4/xa0", "LATIN CAPITAL LETTER G WITH DOT ABOVE");
   ("/xc4/xa1", "LATIN SMALL LETTER G WITH DOT ABOVE");
   ("/xc4/xa2", "LATIN CAPITAL LETTER G WITH CEDILLA");
   ("/xc4/xa3", "LATIN SMALL LETTER G WITH CEDILLA");
   ("/xc4/xa4", "LATIN CAPITAL LETTER H WITH CIRCUMFLEX");
   ("/xc4/xa5", "LATIN SMALL LETTER H WITH CIRCUMFLEX");
   ("/xc4/xa6", "LATIN CAPITAL LETTER H WITH STROKE");
   ("/xc4/xa7", "LATIN SMALL LETTER H WITH STROKE");
   ("/xc4/xa8", "LATIN CAPITAL LETTER I WITH TILDE");
   ("/xc4/xa9", "LATIN SMALL LETTER I WITH TILDE");
   ("/xc4/xaa", "LATIN CAPITAL LETTER I WITH MACRON");
   ("/xc4/xab", "LATIN SMALL LETTER I WITH MACRON");
   ("/xc4/xac", "LATIN CAPITAL LETTER I WITH BREVE");
   ("/xc4/xad", "LATIN SMALL LETTER I WITH BREVE");
   ("/xc4/xae", "LATIN CAPITAL LETTER I WITH OGONEK");
   ("/xc4/xaf", "LATIN SMALL LETTER I WITH OGONEK");
   ("/xc4/xb0", "LATIN CAPITAL LETTER I WITH DOT ABOVE");
   ("/xc4/xb1", "LATIN SMALL LETTER DOTLESS I");
   ("/xc4/xb2", "LATIN CAPITAL LIGATURE IJ");
   ("/xc4/xb3", "LATIN SMALL LIGATURE IJ");
   ("/xc4/xb4", "LATIN CAPITAL LETTER J WITH CIRCUMFLEX");
   ("/xc4/xb5", "LATIN SMALL LETTER J WITH CIRCUMFLEX");
   ("/xc4/xb6", "LATIN CAPITAL LETTER K WITH CEDILLA");
   ("/xc4/xb7", "LATIN SMALL LETTER K WITH CEDILLA");
   ("/xc4/xb8", "LATIN SMALL LETTER KRA");
   ("/xc4/xb9", "LATIN CAPITAL LETTER L WITH ACUTE");
   ("/xc4/xba", "LATIN SMALL LETTER L WITH ACUTE");
   ("/xc4/xbb", "LATIN CAPITAL LETTER L WITH CEDILLA");
   ("/xc4/xbc", "LATIN SMALL LETTER L WITH CEDILLA");
   ("/xc4/xbd", "LATIN CAPITAL LETTER L WITH CARON");
   ("/xc4/xbe", "LATIN SMALL LETTER L WITH CARON");
   ("/xc4/xbf", "LATIN CAPITAL LETTER L WITH MIDDLE DOT");
   ("/xc5/x80", "LATIN SMALL LETTER L WITH MIDDLE DOT");
   ("/xc5/x81", "LATIN CAPITAL LETTER L WITH STROKE");
   ("/xc5/x82", "LATIN SMALL LETTER L WITH STROKE");
   ("/xc5/x83", "LATIN CAPITAL LETTER N WITH ACUTE");
   ("/xc5/x84", "LATIN SMALL LETTER N WITH ACUTE");
   ("/xc5/x85", "LATIN CAPITAL LETTER N WITH CEDILLA");
   ("/xc5/x86", "LATIN SMALL LETTER N WITH CEDILLA");
   ("/xc5/x87", "LATIN CAPITAL LETTER N WITH CARON");
   ("/xc5/x88", "LATIN SMALL LETTER N WITH CARON");
   ("/xc5/x89", "LATIN SMALL LETTER N PRECEDED BY APOSTROPHE");
   ("/xc5/x8a", "LATIN CAPITAL LETTER ENG");
   ("/xc5/x8b", "LATIN SMALL LETTER ENG");
   ("/xc5/x8c", "LATIN CAPITAL LETTER O WITH MACRON");
   ("/xc5/x8d", "LATIN SMALL LETTER O WITH MACRON");
   ("/xc5/x8e", "LATIN CAPITAL LETTER O WITH BREVE");
   ("/xc5/x8f", "LATIN SMALL LETTER O WITH BREVE");
   ("/xc5/x90", "LATIN CAPITAL LETTER O WITH DOUBLE ACUTE");
   ("/xc5/x91", "LATIN SMALL LETTER O WITH DOUBLE ACUTE");
   ("/xc5/x92", "LATIN CAPITAL LIGATURE OE");
   ("/xc5/x93", "LATIN SMALL LIGATURE OE");
   ("/xc5/x94", "LATIN CAPITAL LETTER R WITH ACUTE");
   ("/xc5/x95", "LATIN SMALL LETTER R WITH ACUTE");
   ("/xc5/x96", "LATIN CAPITAL LETTER R WITH CEDILLA");
   ("/xc5/x97", "LATIN SMALL LETTER R WITH CEDILLA");
   ("/xc5/x98", "LATIN CAPITAL LETTER R WITH CARON");
   ("/xc5/x99", "LATIN SMALL LETTER R WITH CARON");
   ("/xc5/x9a", "LATIN CAPITAL LETTER S WITH ACUTE");
   ("/xc5/x9b", "LATIN SMALL LETTER S WITH ACUTE");
   ("/xc5/x9c", "LATIN CAPITAL LETTER S WITH CIRCUMFLEX");
   ("/xc5/x9d", "LATIN SMALL LETTER S WITH CIRCUMFLEX");
   ("/xc5/x9e", "LATIN CAPITAL LETTER S WITH CEDILLA");
   ("/xc5/x9f", "LATIN SMALL LETTER S WITH CEDILLA");
   ("/xc5/xa0", "LATIN CAPITAL LETTER S WITH CARON");
   ("/xc5/xa1", "LATIN SMALL LETTER S WITH CARON");
   ("/xc5/xa2", "LATIN CAPITAL LETTER T WITH CEDILLA");
   ("/xc5/xa3", "LATIN SMALL LETTER T WITH CEDILLA");
   ("/xc5/xa4", "LATIN CAPITAL LETTER T WITH CARON");
   ("/xc5/xa5", "LATIN SMALL LETTER T WITH CARON");
   ("/xc5/xa6", "LATIN CAPITAL LETTER T WITH STROKE");
   ("/xc5/xa7", "LATIN SMALL LETTER T WITH STROKE");
   ("/xc5/xa8", "LATIN CAPITAL LETTER U WITH TILDE");
   ("/xc5/xa9", "LATIN SMALL LETTER U WITH TILDE");
   ("/xc5/xaa", "LATIN CAPITAL LETTER U WITH MACRON");
   ("/xc5/xab", "LATIN SMALL LETTER U WITH MACRON");
   ("/xc5/xac", "LATIN CAPITAL LETTER U WITH BREVE");
   ("/xc5/xad", "LATIN SMALL LETTER U WITH BREVE");
   ("/xc5/xae", "LATIN CAPITAL LETTER U WITH RING ABOVE");
   ("/xc5/xaf", "LATIN SMALL LETTER U WITH RING ABOVE");
   ("/xc5/xb0", "LATIN CAPITAL LETTER U WITH DOUBLE ACUTE");
   ("/xc5/xb1", "LATIN SMALL LETTER U WITH DOUBLE ACUTE");
   ("/xc5/xb2", "LATIN CAPITAL LETTER U WITH OGONEK");
   ("/xc5/xb3", "LATIN SMALL LETTER U WITH OGONEK");
   ("/xc5/xb4", "LATIN CAPITAL LETTER W WITH CIRCUMFLEX");
   ("/xc5/xb5", "LATIN SMALL LETTER W WITH CIRCUMFLEX");
   ("/xc5/xb6", "LATIN CAPITAL LETTER Y WITH CIRCUMFLEX");
   ("/xc5/xb7", "LATIN SMALL LETTER Y WITH CIRCUMFLEX");
   ("/xc5/xb8", "LATIN CAPITAL LETTER Y WITH DIAERESIS");
   ("/xc5/xb9", "LATIN CAPITAL LETTER Z WITH ACUTE");
   ("/xc5/xba", "LATIN SMALL LETTER Z WITH ACUTE");
   ("/xc5/xbb", "LATIN CAPITAL LETTER Z WITH DOT ABOVE");
   ("/xc5/xbc", "LATIN SMALL LETTER Z WITH DOT ABOVE");
   ("/xc5/xbd", "LATIN CAPITAL LETTER Z WITH CARON");
   ("/xc5/xbe", "LATIN SMALL LETTER Z WITH CARON");
   ("/xc5/xbf", "LATIN SMALL LETTER LONG S");
   ("/xc6/x80", "LATIN SMALL LETTER B WITH STROKE");
   ("/xc6/x81", "LATIN CAPITAL LETTER B WITH HOOK");
   ("/xc6/x82", "LATIN CAPITAL LETTER B WITH TOPBAR");
   ("/xc6/x83", "LATIN SMALL LETTER B WITH TOPBAR");
   ("/xc6/x84", "LATIN CAPITAL LETTER TONE SIX");
   ("/xc6/x85", "LATIN SMALL LETTER TONE SIX");
   ("/xc6/x86", "LATIN CAPITAL LETTER OPEN O");
   ("/xc6/x87", "LATIN CAPITAL LETTER C WITH HOOK");
   ("/xc6/x88", "LATIN SMALL LETTER C WITH HOOK");
   ("/xc6/x89", "LATIN CAPITAL LETTER AFRICAN D");
   ("/xc6/x8a", "LATIN CAPITAL LETTER D WITH HOOK");
   ("/xc6/x8b", "LATIN CAPITAL LETTER D WITH TOPBAR");
   ("/xc6/x8c", "LATIN SMALL LETTER D WITH TOPBAR");
   ("/xc6/x8d", "LATIN SMALL LETTER TURNED DELTA");
   ("/xc6/x8e", "LATIN CAPITAL LETTER REVERSED E");
   ("/xc6/x8f", "LATIN CAPITAL LETTER SCHWA");
   ("/xc6/x90", "LATIN CAPITAL LETTER OPEN E");
   ("/xc6/x91", "LATIN CAPITAL LETTER F WITH HOOK");
   ("/xc6/x92", "LATIN SMALL LETTER F WITH HOOK");
   ("/xc6/x93", "LATIN CAPITAL LETTER G WITH HOOK");
   ("/xc6/x94", "LATIN CAPITAL LETTER GAMMA");
   ("/xc6/x95", "LATIN SMALL LETTER HV");
   ("/xc6/x96", "LATIN CAPITAL LETTER IOTA");
   ("/xc6/x97", "LATIN CAPITAL LETTER I WITH STROKE");
   ("/xc6/x98", "LATIN CAPITAL LETTER K WITH HOOK");
   ("/xc6/x99", "LATIN SMALL LETTER K WITH HOOK");
   ("/xc6/x9a", "LATIN SMALL LETTER L WITH BAR");
   ("/xc6/x9b", "LATIN SMALL LETTER LAMBDA WITH STROKE");
   ("/xc6/x9c", "LATIN CAPITAL LETTER TURNED M");
   ("/xc6/x9d", "LATIN CAPITAL LETTER N WITH LEFT HOOK");
   ("/xc6/x9e", "LATIN SMALL LETTER N WITH LONG RIGHT LEG");
   ("/xc6/x9f", "LATIN CAPITAL LETTER O WITH MIDDLE TILDE");
   ("/xc6/xa0", "LATIN CAPITAL LETTER O WITH HORN");
   ("/xc6/xa1", "LATIN SMALL LETTER O WITH HORN");
   ("/xc6/xa2", "LATIN CAPITAL LETTER OI");
   ("/xc6/xa3", "LATIN SMALL LETTER OI");
   ("/xc6/xa4", "LATIN CAPITAL LETTER P WITH HOOK");
   ("/xc6/xa5", "LATIN SMALL LETTER P WITH HOOK");
   ("/xc6/xa7", "LATIN CAPITAL LETTER TONE TWO");
   ("/xc6/xa8", "LATIN SMALL LETTER TONE TWO");
   ("/xc6/xa9", "LATIN CAPITAL LETTER ESH");
   ("/xc6/xab", "LATIN SMALL LETTER T WITH PALATAL HOOK");
   ("/xc6/xac", "LATIN CAPITAL LETTER T WITH HOOK");
   ("/xc6/xad", "LATIN SMALL LETTER T WITH HOOK");
   ("/xc6/xae", "LATIN CAPITAL LETTER T WITH RETROFLEX HOOK");
   ("/xc6/xaf", "LATIN CAPITAL LETTER U WITH HORN");
   ("/xc6/xb0", "LATIN SMALL LETTER U WITH HORN");
   ("/xc6/xb1", "LATIN CAPITAL LETTER UPSILON");
   ("/xc6/xb2", "LATIN CAPITAL LETTER V WITH HOOK");
   ("/xc6/xb3", "LATIN CAPITAL LETTER Y WITH HOOK");
   ("/xc6/xb4", "LATIN SMALL LETTER Y WITH HOOK");
   ("/xc6/xb5", "LATIN CAPITAL LETTER Z WITH STROKE");
   ("/xc6/xb6", "LATIN SMALL LETTER Z WITH STROKE");
   ("/xc6/xb7", "LATIN CAPITAL LETTER EZH");
   ("/xc6/xb8", "LATIN CAPITAL LETTER EZH REVERSED");
   ("/xc6/xb9", "LATIN SMALL LETTER EZH REVERSED");
   ("/xc6/xba", "LATIN SMALL LETTER EZH WITH TAIL");
   ("/xc6/xbc", "LATIN CAPITAL LETTER TONE FIVE");
   ("/xc6/xbd", "LATIN SMALL LETTER TONE FIVE");
   ("/xc7/x84", "LATIN CAPITAL LETTER DZ WITH CARON");
   ("/xc7/x85", "LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON");
   ("/xc7/x86", "LATIN SMALL LETTER DZ WITH CARON");
   ("/xc7/x87", "LATIN CAPITAL LETTER LJ");
   ("/xc7/x88", "LATIN CAPITAL LETTER L WITH SMALL LETTER J");
   ("/xc7/x89", "LATIN SMALL LETTER LJ");
   ("/xc7/x8a", "LATIN CAPITAL LETTER NJ");
   ("/xc7/x8b", "LATIN CAPITAL LETTER N WITH SMALL LETTER J");
   ("/xc7/x8c", "LATIN SMALL LETTER NJ");
   ("/xc7/x8d", "LATIN CAPITAL LETTER A WITH CARON");
   ("/xc7/x8e", "LATIN SMALL LETTER A WITH CARON");
   ("/xc7/x8f", "LATIN CAPITAL LETTER I WITH CARON");
   ("/xc7/x90", "LATIN SMALL LETTER I WITH CARON");
   ("/xc7/x91", "LATIN CAPITAL LETTER O WITH CARON");
   ("/xc7/x92", "LATIN SMALL LETTER O WITH CARON");
   ("/xc7/x93", "LATIN CAPITAL LETTER U WITH CARON");
   ("/xc7/x94", "LATIN SMALL LETTER U WITH CARON");
   ("/xc7/x95", "LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON");
   ("/xc7/x96", "LATIN SMALL LETTER U WITH DIAERESIS AND MACRON");
   ("/xc7/x97", "LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE");
   ("/xc7/x98", "LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE");
   ("/xc7/x99", "LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON");
   ("/xc7/x9a", "LATIN SMALL LETTER U WITH DIAERESIS AND CARON");
   ("/xc7/x9b", "LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE");
   ("/xc7/x9c", "LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE");
   ("/xc7/x9d", "LATIN SMALL LETTER TURNED E");
   ("/xc7/x9e", "LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON");
   ("/xc7/x9f", "LATIN SMALL LETTER A WITH DIAERESIS AND MACRON");
   ("/xc7/xa0", "LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON");
   ("/xc7/xa1", "LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON");
   ("/xc7/xa2", "LATIN CAPITAL LETTER AE WITH MACRON");
   ("/xc7/xa3", "LATIN SMALL LETTER AE WITH MACRON");
   ("/xc7/xa4", "LATIN CAPITAL LETTER G WITH STROKE");
   ("/xc7/xa5", "LATIN SMALL LETTER G WITH STROKE");
   ("/xc7/xa6", "LATIN CAPITAL LETTER G WITH CARON");
   ("/xc7/xa7", "LATIN SMALL LETTER G WITH CARON");
   ("/xc7/xa8", "LATIN CAPITAL LETTER K WITH CARON");
   ("/xc7/xa9", "LATIN SMALL LETTER K WITH CARON");
   ("/xc7/xaa", "LATIN CAPITAL LETTER O WITH OGONEK");
   ("/xc7/xab", "LATIN SMALL LETTER O WITH OGONEK");
   ("/xc7/xac", "LATIN CAPITAL LETTER O WITH OGONEK AND MACRON");
   ("/xc7/xad", "LATIN SMALL LETTER O WITH OGONEK AND MACRON");
   ("/xc7/xae", "LATIN CAPITAL LETTER EZH WITH CARON");
   ("/xc7/xaf", "LATIN SMALL LETTER EZH WITH CARON");
   ("/xc7/xb0", "LATIN SMALL LETTER J WITH CARON");
   ("/xc7/xb1", "LATIN CAPITAL LETTER DZ");
   ("/xc7/xb2", "LATIN CAPITAL LETTER D WITH SMALL LETTER Z");
   ("/xc7/xb3", "LATIN SMALL LETTER DZ");
   ("/xc7/xb4", "LATIN CAPITAL LETTER G WITH ACUTE");
   ("/xc7/xb5", "LATIN SMALL LETTER G WITH ACUTE");
   ("/xc7/xb6", "LATIN CAPITAL LETTER HWAIR");
   ("/xc7/xb7", "LATIN CAPITAL LETTER WYNN");
   ("/xc7/xb8", "LATIN CAPITAL LETTER N WITH GRAVE");
   ("/xc7/xb9", "LATIN SMALL LETTER N WITH GRAVE");
   ("/xc7/xba", "LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE");
   ("/xc7/xbb", "LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE");
   ("/xc7/xbc", "LATIN CAPITAL LETTER AE WITH ACUTE");
   ("/xc7/xbd", "LATIN SMALL LETTER AE WITH ACUTE");
   ("/xc7/xbe", "LATIN CAPITAL LETTER O WITH STROKE AND ACUTE");
   ("/xc7/xbf", "LATIN SMALL LETTER O WITH STROKE AND ACUTE");
   ("/xc8/x80", "LATIN CAPITAL LETTER A WITH DOUBLE GRAVE");
   ("/xc8/x81", "LATIN SMALL LETTER A WITH DOUBLE GRAVE");
   ("/xc8/x82", "LATIN CAPITAL LETTER A WITH INVERTED BREVE");
   ("/xc8/x83", "LATIN SMALL LETTER A WITH INVERTED BREVE");
   ("/xc8/x84", "LATIN CAPITAL LETTER E WITH DOUBLE GRAVE");
   ("/xc8/x85", "LATIN SMALL LETTER E WITH DOUBLE GRAVE");
   ("/xc8/x86", "LATIN CAPITAL LETTER E WITH INVERTED BREVE");
   ("/xc8/x87", "LATIN SMALL LETTER E WITH INVERTED BREVE");
   ("/xc8/x88", "LATIN CAPITAL LETTER I WITH DOUBLE GRAVE");
   ("/xc8/x89", "LATIN SMALL LETTER I WITH DOUBLE GRAVE");
   ("/xc8/x8a", "LATIN CAPITAL LETTER I WITH INVERTED BREVE");
   ("/xc8/x8b", "LATIN SMALL LETTER I WITH INVERTED BREVE");
   ("/xc8/x8c", "LATIN CAPITAL LETTER O WITH DOUBLE GRAVE");
   ("/xc8/x8d", "LATIN SMALL LETTER O WITH DOUBLE GRAVE");
   ("/xc8/x8e", "LATIN CAPITAL LETTER O WITH INVERTED BREVE");
   ("/xc8/x8f", "LATIN SMALL LETTER O WITH INVERTED BREVE");
   ("/xc8/x90", "LATIN CAPITAL LETTER R WITH DOUBLE GRAVE");
   ("/xc8/x91", "LATIN SMALL LETTER R WITH DOUBLE GRAVE");
   ("/xc8/x92", "LATIN CAPITAL LETTER R WITH INVERTED BREVE");
   ("/xc8/x93", "LATIN SMALL LETTER R WITH INVERTED BREVE");
   ("/xc8/x94", "LATIN CAPITAL LETTER U WITH DOUBLE GRAVE");
   ("/xc8/x95", "LATIN SMALL LETTER U WITH DOUBLE GRAVE");
   ("/xc8/x96", "LATIN CAPITAL LETTER U WITH INVERTED BREVE");
   ("/xc8/x97", "LATIN SMALL LETTER U WITH INVERTED BREVE");
   ("/xc8/x98", "LATIN CAPITAL LETTER S WITH COMMA BELOW");
   ("/xc8/x99", "LATIN SMALL LETTER S WITH COMMA BELOW");
   ("/xc8/x9a", "LATIN CAPITAL LETTER T WITH COMMA BELOW");
   ("/xc8/x9b", "LATIN SMALL LETTER T WITH COMMA BELOW");
   ("/xc8/x9c", "LATIN CAPITAL LETTER YOGH");
   ("/xc8/x9d", "LATIN SMALL LETTER YOGH");
   ("/xc8/x9e", "LATIN CAPITAL LETTER H WITH CARON");
   ("/xc8/x9f", "LATIN SMALL LETTER H WITH CARON");
   ("/xc8/xa0", "LATIN CAPITAL LETTER N WITH LONG RIGHT LEG");
   ("/xc8/xa1", "LATIN SMALL LETTER D WITH CURL");
   ("/xc8/xa2", "LATIN CAPITAL LETTER OU");
   ("/xc8/xa3", "LATIN SMALL LETTER OU");
   ("/xc8/xa4", "LATIN CAPITAL LETTER Z WITH HOOK");
   ("/xc8/xa5", "LATIN SMALL LETTER Z WITH HOOK");
   ("/xc8/xa6", "LATIN CAPITAL LETTER A WITH DOT ABOVE");
   ("/xc8/xa7", "LATIN SMALL LETTER A WITH DOT ABOVE");
   ("/xc8/xa8", "LATIN CAPITAL LETTER E WITH CEDILLA");
   ("/xc8/xa9", "LATIN SMALL LETTER E WITH CEDILLA");
   ("/xc8/xaa", "LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON");
   ("/xc8/xab", "LATIN SMALL LETTER O WITH DIAERESIS AND MACRON");
   ("/xc8/xac", "LATIN CAPITAL LETTER O WITH TILDE AND MACRON");
   ("/xc8/xad", "LATIN SMALL LETTER O WITH TILDE AND MACRON");
   ("/xc8/xae", "LATIN CAPITAL LETTER O WITH DOT ABOVE");
   ("/xc8/xaf", "LATIN SMALL LETTER O WITH DOT ABOVE");
   ("/xc8/xb0", "LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON");
   ("/xc8/xb1", "LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON");
   ("/xc8/xb2", "LATIN CAPITAL LETTER Y WITH MACRON");
   ("/xc8/xb3", "LATIN SMALL LETTER Y WITH MACRON");
   ("/xc8/xb4", "LATIN SMALL LETTER L WITH CURL");
   ("/xc8/xb5", "LATIN SMALL LETTER N WITH CURL");
   ("/xc8/xb6", "LATIN SMALL LETTER T WITH CURL");
   ("/xc8/xb7", "LATIN SMALL LETTER DOTLESS J");
   ("/xc8/xb8", "LATIN SMALL LETTER DB DIGRAPH");
   ("/xc8/xb9", "LATIN SMALL LETTER QP DIGRAPH");
   ("/xc8/xba", "LATIN CAPITAL LETTER A WITH STROKE");
   ("/xc8/xbb", "LATIN CAPITAL LETTER C WITH STROKE");
   ("/xc8/xbc", "LATIN SMALL LETTER C WITH STROKE");
   ("/xc8/xbd", "LATIN CAPITAL LETTER L WITH BAR");
   ("/xc8/xbe", "LATIN CAPITAL LETTER T WITH DIAGONAL STROKE");
   ("/xc8/xbf", "LATIN SMALL LETTER S WITH SWASH TAIL");
   ("/xc9/x80", "LATIN SMALL LETTER Z WITH SWASH TAIL");
   ("/xc9/x81", "LATIN CAPITAL LETTER GLOTTAL STOP");
   ("/xc9/x82", "LATIN SMALL LETTER GLOTTAL STOP");
   ("/xc9/x83", "LATIN CAPITAL LETTER B WITH STROKE");
   ("/xc9/x84", "LATIN CAPITAL LETTER U BAR");
   ("/xc9/x85", "LATIN CAPITAL LETTER TURNED V");
   ("/xc9/x86", "LATIN CAPITAL LETTER E WITH STROKE");
   ("/xc9/x87", "LATIN SMALL LETTER E WITH STROKE");
   ("/xc9/x88", "LATIN CAPITAL LETTER J WITH STROKE");
   ("/xc9/x89", "LATIN SMALL LETTER J WITH STROKE");
   ("/xc9/x8a", "LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL");
   ("/xc9/x8b", "LATIN SMALL LETTER Q WITH HOOK TAIL");
   ("/xc9/x8c", "LATIN CAPITAL LETTER R WITH STROKE");
   ("/xc9/x8d", "LATIN SMALL LETTER R WITH STROKE");
   ("/xc9/x8e", "LATIN CAPITAL LETTER Y WITH STROKE");
   ("/xc9/x8f", "LATIN SMALL LETTER Y WITH STROKE");
   ("/xc9/x90", "LATIN SMALL LETTER TURNED A");
   ("/xc9/x91", "LATIN SMALL LETTER ALPHA");
   ("/xc9/x92", "LATIN SMALL LETTER TURNED ALPHA");
   ("/xc9/x93", "LATIN SMALL LETTER B WITH HOOK");
   ("/xc9/x94", "LATIN SMALL LETTER OPEN O");
   ("/xc9/x95", "LATIN SMALL LETTER C WITH CURL");
   ("/xc9/x96", "LATIN SMALL LETTER D WITH TAIL");
   ("/xc9/x97", "LATIN SMALL LETTER D WITH HOOK");
   ("/xc9/x98", "LATIN SMALL LETTER REVERSED E");
   ("/xc9/x99", "LATIN SMALL LETTER SCHWA");
   ("/xc9/x9a", "LATIN SMALL LETTER SCHWA WITH HOOK");
   ("/xc9/x9b", "LATIN SMALL LETTER OPEN E");
   ("/xc9/x9c", "LATIN SMALL LETTER REVERSED OPEN E");
   ("/xc9/x9d", "LATIN SMALL LETTER REVERSED OPEN E WITH HOOK");
   ("/xc9/x9e", "LATIN SMALL LETTER CLOSED REVERSED OPEN E");
   ("/xc9/x9f", "LATIN SMALL LETTER DOTLESS J WITH STROKE");
   ("/xc9/xa0", "LATIN SMALL LETTER G WITH HOOK");
   ("/xc9/xa1", "LATIN SMALL LETTER SCRIPT G");
   ("/xc9/xa2", "LATIN LETTER SMALL CAPITAL G");
   ("/xc9/xa3", "LATIN SMALL LETTER GAMMA");
   ("/xc9/xa4", "LATIN SMALL LETTER RAMS HORN");
   ("/xc9/xa5", "LATIN SMALL LETTER TURNED H");
   ("/xc9/xa6", "LATIN SMALL LETTER H WITH HOOK");
   ("/xc9/xa7", "LATIN SMALL LETTER HENG WITH HOOK");
   ("/xc9/xa8", "LATIN SMALL LETTER I WITH STROKE");
   ("/xc9/xa9", "LATIN SMALL LETTER IOTA");
   ("/xc9/xaa", "LATIN LETTER SMALL CAPITAL I");
   ("/xc9/xab", "LATIN SMALL LETTER L WITH MIDDLE TILDE");
   ("/xc9/xac", "LATIN SMALL LETTER L WITH BELT");
   ("/xc9/xad", "LATIN SMALL LETTER L WITH RETROFLEX HOOK");
   ("/xc9/xae", "LATIN SMALL LETTER LEZH");
   ("/xc9/xaf", "LATIN SMALL LETTER TURNED M");
   ("/xc9/xb0", "LATIN SMALL LETTER TURNED M WITH LONG LEG");
   ("/xc9/xb1", "LATIN SMALL LETTER M WITH HOOK");
   ("/xc9/xb2", "LATIN SMALL LETTER N WITH LEFT HOOK");
   ("/xc9/xb3", "LATIN SMALL LETTER N WITH RETROFLEX HOOK");
   ("/xc9/xb4", "LATIN LETTER SMALL CAPITAL N");
   ("/xc9/xb5", "LATIN SMALL LETTER BARRED O");
   ("/xc9/xb6", "LATIN LETTER SMALL CAPITAL OE");
   ("/xc9/xb7", "LATIN SMALL LETTER CLOSED OMEGA");
   ("/xc9/xb8", "LATIN SMALL LETTER PHI");
   ("/xc9/xb9", "LATIN SMALL LETTER TURNED R");
   ("/xc9/xba", "LATIN SMALL LETTER TURNED R WITH LONG LEG");
   ("/xc9/xbb", "LATIN SMALL LETTER TURNED R WITH HOOK");
   ("/xc9/xbc", "LATIN SMALL LETTER R WITH LONG LEG");
   ("/xc9/xbd", "LATIN SMALL LETTER R WITH TAIL");
   ("/xc9/xbe", "LATIN SMALL LETTER R WITH FISHHOOK");
   ("/xc9/xbf", "LATIN SMALL LETTER REVERSED R WITH FISHHOOK");
   ("/xca/x80", "LATIN LETTER SMALL CAPITAL R");
   ("/xca/x81", "LATIN LETTER SMALL CAPITAL INVERTED R");
   ("/xca/x82", "LATIN SMALL LETTER S WITH HOOK");
   ("/xca/x83", "LATIN SMALL LETTER ESH");
   ("/xca/x84", "LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK");
   ("/xca/x85", "LATIN SMALL LETTER SQUAT REVERSED ESH");
   ("/xca/x86", "LATIN SMALL LETTER ESH WITH CURL");
   ("/xca/x87", "LATIN SMALL LETTER TURNED T");
   ("/xca/x88", "LATIN SMALL LETTER T WITH RETROFLEX HOOK");
   ("/xca/x89", "LATIN SMALL LETTER U BAR");
   ("/xca/x8a", "LATIN SMALL LETTER UPSILON");
   ("/xca/x8b", "LATIN SMALL LETTER V WITH HOOK");
   ("/xca/x8c", "LATIN SMALL LETTER TURNED V");
   ("/xca/x8d", "LATIN SMALL LETTER TURNED W");
   ("/xca/x8e", "LATIN SMALL LETTER TURNED Y");
   ("/xca/x8f", "LATIN LETTER SMALL CAPITAL Y");
   ("/xca/x90", "LATIN SMALL LETTER Z WITH RETROFLEX HOOK");
   ("/xca/x91", "LATIN SMALL LETTER Z WITH CURL");
   ("/xca/x92", "LATIN SMALL LETTER EZH");
   ("/xca/x93", "LATIN SMALL LETTER EZH WITH CURL");
   ("/xca/x99", "LATIN LETTER SMALL CAPITAL B");
   ("/xca/x9a", "LATIN SMALL LETTER CLOSED OPEN E");
   ("/xca/x9b", "LATIN LETTER SMALL CAPITAL G WITH HOOK");
   ("/xca/x9c", "LATIN LETTER SMALL CAPITAL H");
   ("/xca/x9d", "LATIN SMALL LETTER J WITH CROSSED-TAIL");
   ("/xca/x9e", "LATIN SMALL LETTER TURNED K");
   ("/xca/x9f", "LATIN LETTER SMALL CAPITAL L");
   ("/xca/xa0", "LATIN SMALL LETTER Q WITH HOOK");
   ("/xca/xa3", "LATIN SMALL LETTER DZ DIGRAPH");
   ("/xca/xa4", "LATIN SMALL LETTER DEZH DIGRAPH");
   ("/xca/xa5", "LATIN SMALL LETTER DZ DIGRAPH WITH CURL");
   ("/xca/xa6", "LATIN SMALL LETTER TS DIGRAPH");
   ("/xca/xa7", "LATIN SMALL LETTER TESH DIGRAPH");
   ("/xca/xa8", "LATIN SMALL LETTER TC DIGRAPH WITH CURL");
   ("/xca/xa9", "LATIN SMALL LETTER FENG DIGRAPH");
   ("/xca/xaa", "LATIN SMALL LETTER LS DIGRAPH");
   ("/xca/xab", "LATIN SMALL LETTER LZ DIGRAPH");
   ("/xca/xae", "LATIN SMALL LETTER TURNED H WITH FISHHOOK");
   ("/xca/xaf", "LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL");
   ("/xca/xb0", "MODIFIER LETTER SMALL H");
   ("/xca/xb1", "MODIFIER LETTER SMALL H WITH HOOK");
   ("/xca/xb2", "MODIFIER LETTER SMALL J");
   ("/xca/xb3", "MODIFIER LETTER SMALL R");
   ("/xca/xb4", "MODIFIER LETTER SMALL TURNED R");
   ("/xca/xb5", "MODIFIER LETTER SMALL TURNED R WITH HOOK");
   ("/xca/xb6", "MODIFIER LETTER SMALL CAPITAL INVERTED R");
   ("/xca/xb7", "MODIFIER LETTER SMALL W");
   ("/xca/xb8", "MODIFIER LETTER SMALL Y");
   ("/xcb/x9c", "SMALL TILDE");
   ("/xcb/xa0", "MODIFIER LETTER SMALL GAMMA");
   ("/xcb/xa1", "MODIFIER LETTER SMALL L");
   ("/xcb/xa2", "MODIFIER LETTER SMALL S");
   ("/xcb/xa3", "MODIFIER LETTER SMALL X");
   ("/xcb/xa4", "MODIFIER LETTER SMALL REVERSED GLOTTAL STOP");
   ("/xcd/xa3", "COMBINING LATIN SMALL LETTER A");
   ("/xcd/xa4", "COMBINING LATIN SMALL LETTER E");
   ("/xcd/xa5", "COMBINING LATIN SMALL LETTER I");
   ("/xcd/xa6", "COMBINING LATIN SMALL LETTER O");
   ("/xcd/xa7", "COMBINING LATIN SMALL LETTER U");
   ("/xcd/xa8", "COMBINING LATIN SMALL LETTER C");
   ("/xcd/xa9", "COMBINING LATIN SMALL LETTER D");
   ("/xcd/xaa", "COMBINING LATIN SMALL LETTER H");
   ("/xcd/xab", "COMBINING LATIN SMALL LETTER M");
   ("/xcd/xac", "COMBINING LATIN SMALL LETTER R");
   ("/xcd/xad", "COMBINING LATIN SMALL LETTER T");
   ("/xcd/xae", "COMBINING LATIN SMALL LETTER V");
   ("/xcd/xaf", "COMBINING LATIN SMALL LETTER X");
   ("/xcd/xb0", "GREEK CAPITAL LETTER HETA");
   ("/xcd/xb1", "GREEK SMALL LETTER HETA");
   ("/xcd/xb2", "GREEK CAPITAL LETTER ARCHAIC SAMPI");
   ("/xcd/xb3", "GREEK SMALL LETTER ARCHAIC SAMPI");
   ("/xcd/xb6", "GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA");
   ("/xcd/xb7", "GREEK SMALL LETTER PAMPHYLIAN DIGAMMA");
   ("/xcd/xbb", "GREEK SMALL REVERSED LUNATE SIGMA SYMBOL");
   ("/xcd/xbc", "GREEK SMALL DOTTED LUNATE SIGMA SYMBOL");
   ("/xcd/xbd", "GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL");
   ("/xce/x86", "GREEK CAPITAL LETTER ALPHA WITH TONOS");
   ("/xce/x88", "GREEK CAPITAL LETTER EPSILON WITH TONOS");
   ("/xce/x89", "GREEK CAPITAL LETTER ETA WITH TONOS");
   ("/xce/x8a", "GREEK CAPITAL LETTER IOTA WITH TONOS");
   ("/xce/x8c", "GREEK CAPITAL LETTER OMICRON WITH TONOS");
   ("/xce/x8e", "GREEK CAPITAL LETTER UPSILON WITH TONOS");
   ("/xce/x8f", "GREEK CAPITAL LETTER OMEGA WITH TONOS");
   ("/xce/x90", "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS");
   ("/xce/x91", "GREEK CAPITAL LETTER ALPHA");
   ("/xce/x92", "GREEK CAPITAL LETTER BETA");
   ("/xce/x93", "GREEK CAPITAL LETTER GAMMA");
   ("/xce/x94", "GREEK CAPITAL LETTER DELTA");
   ("/xce/x95", "GREEK CAPITAL LETTER EPSILON");
   ("/xce/x96", "GREEK CAPITAL LETTER ZETA");
   ("/xce/x97", "GREEK CAPITAL LETTER ETA");
   ("/xce/x98", "GREEK CAPITAL LETTER THETA");
   ("/xce/x99", "GREEK CAPITAL LETTER IOTA");
   ("/xce/x9a", "GREEK CAPITAL LETTER KAPPA");
   ("/xce/x9b", "GREEK CAPITAL LETTER LAMDA");
   ("/xce/x9c", "GREEK CAPITAL LETTER MU");
   ("/xce/x9d", "GREEK CAPITAL LETTER NU");
   ("/xce/x9e", "GREEK CAPITAL LETTER XI");
   ("/xce/x9f", "GREEK CAPITAL LETTER OMICRON");
   ("/xce/xa0", "GREEK CAPITAL LETTER PI");
   ("/xce/xa1", "GREEK CAPITAL LETTER RHO");
   ("/xce/xa3", "GREEK CAPITAL LETTER SIGMA");
   ("/xce/xa4", "GREEK CAPITAL LETTER TAU");
   ("/xce/xa5", "GREEK CAPITAL LETTER UPSILON");
   ("/xce/xa6", "GREEK CAPITAL LETTER PHI");
   ("/xce/xa7", "GREEK CAPITAL LETTER CHI");
   ("/xce/xa8", "GREEK CAPITAL LETTER PSI");
   ("/xce/xa9", "GREEK CAPITAL LETTER OMEGA");
   ("/xce/xaa", "GREEK CAPITAL LETTER IOTA WITH DIALYTIKA");
   ("/xce/xab", "GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA");
   ("/xce/xac", "GREEK SMALL LETTER ALPHA WITH TONOS");
   ("/xce/xad", "GREEK SMALL LETTER EPSILON WITH TONOS");
   ("/xce/xae", "GREEK SMALL LETTER ETA WITH TONOS");
   ("/xce/xaf", "GREEK SMALL LETTER IOTA WITH TONOS");
   ("/xce/xb0", "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS");
   ("/xce/xb1", "GREEK SMALL LETTER ALPHA");
   ("/xce/xb2", "GREEK SMALL LETTER BETA");
   ("/xce/xb3", "GREEK SMALL LETTER GAMMA");
   ("/xce/xb4", "GREEK SMALL LETTER DELTA");
   ("/xce/xb5", "GREEK SMALL LETTER EPSILON");
   ("/xce/xb6", "GREEK SMALL LETTER ZETA");
   ("/xce/xb7", "GREEK SMALL LETTER ETA");
   ("/xce/xb8", "GREEK SMALL LETTER THETA");
   ("/xce/xb9", "GREEK SMALL LETTER IOTA");
   ("/xce/xba", "GREEK SMALL LETTER KAPPA");
   ("/xce/xbb", "GREEK SMALL LETTER LAMDA");
   ("/xce/xbc", "GREEK SMALL LETTER MU");
   ("/xce/xbd", "GREEK SMALL LETTER NU");
   ("/xce/xbe", "GREEK SMALL LETTER XI");
   ("/xce/xbf", "GREEK SMALL LETTER OMICRON");
   ("/xcf/x80", "GREEK SMALL LETTER PI");
   ("/xcf/x81", "GREEK SMALL LETTER RHO");
   ("/xcf/x82", "GREEK SMALL LETTER FINAL SIGMA");
   ("/xcf/x83", "GREEK SMALL LETTER SIGMA");
   ("/xcf/x84", "GREEK SMALL LETTER TAU");
   ("/xcf/x85", "GREEK SMALL LETTER UPSILON");
   ("/xcf/x86", "GREEK SMALL LETTER PHI");
   ("/xcf/x87", "GREEK SMALL LETTER CHI");
   ("/xcf/x88", "GREEK SMALL LETTER PSI");
   ("/xcf/x89", "GREEK SMALL LETTER OMEGA");
   ("/xcf/x8a", "GREEK SMALL LETTER IOTA WITH DIALYTIKA");
   ("/xcf/x8b", "GREEK SMALL LETTER UPSILON WITH DIALYTIKA");
   ("/xcf/x8c", "GREEK SMALL LETTER OMICRON WITH TONOS");
   ("/xcf/x8d", "GREEK SMALL LETTER UPSILON WITH TONOS");
   ("/xcf/x8e", "GREEK SMALL LETTER OMEGA WITH TONOS");
   ("/xcf/x8f", "GREEK CAPITAL KAI SYMBOL");
   ("/xcf/x99", "GREEK SMALL LETTER ARCHAIC KOPPA");
   ("/xcf/x9b", "GREEK SMALL LETTER STIGMA");
   ("/xcf/x9d", "GREEK SMALL LETTER DIGAMMA");
   ("/xcf/x9f", "GREEK SMALL LETTER KOPPA");
   ("/xcf/xa1", "GREEK SMALL LETTER SAMPI");
   ("/xcf/xa2", "COPTIC CAPITAL LETTER SHEI");
   ("/xcf/xa3", "COPTIC SMALL LETTER SHEI");
   ("/xcf/xa4", "COPTIC CAPITAL LETTER FEI");
   ("/xcf/xa5", "COPTIC SMALL LETTER FEI");
   ("/xcf/xa6", "COPTIC CAPITAL LETTER KHEI");
   ("/xcf/xa7", "COPTIC SMALL LETTER KHEI");
   ("/xcf/xa8", "COPTIC CAPITAL LETTER HORI");
   ("/xcf/xa9", "COPTIC SMALL LETTER HORI");
   ("/xcf/xaa", "COPTIC CAPITAL LETTER GANGIA");
   ("/xcf/xab", "COPTIC SMALL LETTER GANGIA");
   ("/xcf/xac", "COPTIC CAPITAL LETTER SHIMA");
   ("/xcf/xad", "COPTIC SMALL LETTER SHIMA");
   ("/xcf/xae", "COPTIC CAPITAL LETTER DEI");
   ("/xcf/xaf", "COPTIC SMALL LETTER DEI");
   ("/xcf/xb4", "GREEK CAPITAL THETA SYMBOL");
   ("/xcf/xb7", "GREEK CAPITAL LETTER SHO");
   ("/xcf/xb8", "GREEK SMALL LETTER SHO");
   ("/xcf/xb9", "GREEK CAPITAL LUNATE SIGMA SYMBOL");
   ("/xcf/xba", "GREEK CAPITAL LETTER SAN");
   ("/xcf/xbb", "GREEK SMALL LETTER SAN");
   ("/xcf/xbd", "GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL");
   ("/xcf/xbe", "GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL");
   ("/xcf/xbf", "GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL");
   ("/xd0/x80", "CYRILLIC CAPITAL LETTER IE WITH GRAVE");
   ("/xd0/x81", "CYRILLIC CAPITAL LETTER IO");
   ("/xd0/x82", "CYRILLIC CAPITAL LETTER DJE");
   ("/xd0/x83", "CYRILLIC CAPITAL LETTER GJE");
   ("/xd0/x84", "CYRILLIC CAPITAL LETTER UKRAINIAN IE");
   ("/xd0/x85", "CYRILLIC CAPITAL LETTER DZE");
   ("/xd0/x86", "CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I");
   ("/xd0/x87", "CYRILLIC CAPITAL LETTER YI");
   ("/xd0/x88", "CYRILLIC CAPITAL LETTER JE");
   ("/xd0/x89", "CYRILLIC CAPITAL LETTER LJE");
   ("/xd0/x8a", "CYRILLIC CAPITAL LETTER NJE");
   ("/xd0/x8b", "CYRILLIC CAPITAL LETTER TSHE");
   ("/xd0/x8c", "CYRILLIC CAPITAL LETTER KJE");
   ("/xd0/x8d", "CYRILLIC CAPITAL LETTER I WITH GRAVE");
   ("/xd0/x8e", "CYRILLIC CAPITAL LETTER SHORT U");
   ("/xd0/x8f", "CYRILLIC CAPITAL LETTER DZHE");
   ("/xd0/x90", "CYRILLIC CAPITAL LETTER A");
   ("/xd0/x91", "CYRILLIC CAPITAL LETTER BE");
   ("/xd0/x92", "CYRILLIC CAPITAL LETTER VE");
   ("/xd0/x93", "CYRILLIC CAPITAL LETTER GHE");
   ("/xd0/x94", "CYRILLIC CAPITAL LETTER DE");
   ("/xd0/x95", "CYRILLIC CAPITAL LETTER IE");
   ("/xd0/x96", "CYRILLIC CAPITAL LETTER ZHE");
   ("/xd0/x97", "CYRILLIC CAPITAL LETTER ZE");
   ("/xd0/x98", "CYRILLIC CAPITAL LETTER I");
   ("/xd0/x99", "CYRILLIC CAPITAL LETTER SHORT I");
   ("/xd0/x9a", "CYRILLIC CAPITAL LETTER KA");
   ("/xd0/x9b", "CYRILLIC CAPITAL LETTER EL");
   ("/xd0/x9c", "CYRILLIC CAPITAL LETTER EM");
   ("/xd0/x9d", "CYRILLIC CAPITAL LETTER EN");
   ("/xd0/x9e", "CYRILLIC CAPITAL LETTER O");
   ("/xd0/x9f", "CYRILLIC CAPITAL LETTER PE");
   ("/xd0/xa0", "CYRILLIC CAPITAL LETTER ER");
   ("/xd0/xa1", "CYRILLIC CAPITAL LETTER ES");
   ("/xd0/xa2", "CYRILLIC CAPITAL LETTER TE");
   ("/xd0/xa3", "CYRILLIC CAPITAL LETTER U");
   ("/xd0/xa4", "CYRILLIC CAPITAL LETTER EF");
   ("/xd0/xa5", "CYRILLIC CAPITAL LETTER HA");
   ("/xd0/xa6", "CYRILLIC CAPITAL LETTER TSE");
   ("/xd0/xa7", "CYRILLIC CAPITAL LETTER CHE");
   ("/xd0/xa8", "CYRILLIC CAPITAL LETTER SHA");
   ("/xd0/xa9", "CYRILLIC CAPITAL LETTER SHCHA");
   ("/xd0/xaa", "CYRILLIC CAPITAL LETTER HARD SIGN");
   ("/xd0/xab", "CYRILLIC CAPITAL LETTER YERU");
   ("/xd0/xac", "CYRILLIC CAPITAL LETTER SOFT SIGN");
   ("/xd0/xad", "CYRILLIC CAPITAL LETTER E");
   ("/xd0/xae", "CYRILLIC CAPITAL LETTER YU");
   ("/xd0/xaf", "CYRILLIC CAPITAL LETTER YA");
   ("/xd0/xb0", "CYRILLIC SMALL LETTER A");
   ("/xd0/xb1", "CYRILLIC SMALL LETTER BE");
   ("/xd0/xb2", "CYRILLIC SMALL LETTER VE");
   ("/xd0/xb3", "CYRILLIC SMALL LETTER GHE");
   ("/xd0/xb4", "CYRILLIC SMALL LETTER DE");
   ("/xd0/xb5", "CYRILLIC SMALL LETTER IE");
   ("/xd0/xb6", "CYRILLIC SMALL LETTER ZHE");
   ("/xd0/xb7", "CYRILLIC SMALL LETTER ZE");
   ("/xd0/xb8", "CYRILLIC SMALL LETTER I");
   ("/xd0/xb9", "CYRILLIC SMALL LETTER SHORT I");
   ("/xd0/xba", "CYRILLIC SMALL LETTER KA");
   ("/xd0/xbb", "CYRILLIC SMALL LETTER EL");
   ("/xd0/xbc", "CYRILLIC SMALL LETTER EM");
   ("/xd0/xbd", "CYRILLIC SMALL LETTER EN");
   ("/xd0/xbe", "CYRILLIC SMALL LETTER O");
   ("/xd0/xbf", "CYRILLIC SMALL LETTER PE");
   ("/xd1/x80", "CYRILLIC SMALL LETTER ER");
   ("/xd1/x81", "CYRILLIC SMALL LETTER ES");
   ("/xd1/x82", "CYRILLIC SMALL LETTER TE");
   ("/xd1/x83", "CYRILLIC SMALL LETTER U");
   ("/xd1/x84", "CYRILLIC SMALL LETTER EF");
   ("/xd1/x85", "CYRILLIC SMALL LETTER HA");
   ("/xd1/x86", "CYRILLIC SMALL LETTER TSE");
   ("/xd1/x87", "CYRILLIC SMALL LETTER CHE");
   ("/xd1/x88", "CYRILLIC SMALL LETTER SHA");
   ("/xd1/x89", "CYRILLIC SMALL LETTER SHCHA");
   ("/xd1/x8a", "CYRILLIC SMALL LETTER HARD SIGN");
   ("/xd1/x8b", "CYRILLIC SMALL LETTER YERU");
   ("/xd1/x8c", "CYRILLIC SMALL LETTER SOFT SIGN");
   ("/xd1/x8d", "CYRILLIC SMALL LETTER E");
   ("/xd1/x8e", "CYRILLIC SMALL LETTER YU");
   ("/xd1/x8f", "CYRILLIC SMALL LETTER YA");
   ("/xd1/x90", "CYRILLIC SMALL LETTER IE WITH GRAVE");
   ("/xd1/x91", "CYRILLIC SMALL LETTER IO");
   ("/xd1/x92", "CYRILLIC SMALL LETTER DJE");
   ("/xd1/x93", "CYRILLIC SMALL LETTER GJE");
   ("/xd1/x94", "CYRILLIC SMALL LETTER UKRAINIAN IE");
   ("/xd1/x95", "CYRILLIC SMALL LETTER DZE");
   ("/xd1/x96", "CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I");
   ("/xd1/x97", "CYRILLIC SMALL LETTER YI");
   ("/xd1/x98", "CYRILLIC SMALL LETTER JE");
   ("/xd1/x99", "CYRILLIC SMALL LETTER LJE");
   ("/xd1/x9a", "CYRILLIC SMALL LETTER NJE");
   ("/xd1/x9b", "CYRILLIC SMALL LETTER TSHE");
   ("/xd1/x9c", "CYRILLIC SMALL LETTER KJE");
   ("/xd1/x9d", "CYRILLIC SMALL LETTER I WITH GRAVE");
   ("/xd1/x9e", "CYRILLIC SMALL LETTER SHORT U");
   ("/xd1/x9f", "CYRILLIC SMALL LETTER DZHE");
   ("/xd1/xa0", "CYRILLIC CAPITAL LETTER OMEGA");
   ("/xd1/xa1", "CYRILLIC SMALL LETTER OMEGA");
   ("/xd1/xa2", "CYRILLIC CAPITAL LETTER YAT");
   ("/xd1/xa3", "CYRILLIC SMALL LETTER YAT");
   ("/xd1/xa4", "CYRILLIC CAPITAL LETTER IOTIFIED E");
   ("/xd1/xa5", "CYRILLIC SMALL LETTER IOTIFIED E");
   ("/xd1/xa6", "CYRILLIC CAPITAL LETTER LITTLE YUS");
   ("/xd1/xa7", "CYRILLIC SMALL LETTER LITTLE YUS");
   ("/xd1/xa8", "CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS");
   ("/xd1/xa9", "CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS");
   ("/xd1/xaa", "CYRILLIC CAPITAL LETTER BIG YUS");
   ("/xd1/xab", "CYRILLIC SMALL LETTER BIG YUS");
   ("/xd1/xac", "CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS");
   ("/xd1/xad", "CYRILLIC SMALL LETTER IOTIFIED BIG YUS");
   ("/xd1/xae", "CYRILLIC CAPITAL LETTER KSI");
   ("/xd1/xaf", "CYRILLIC SMALL LETTER KSI");
   ("/xd1/xb0", "CYRILLIC CAPITAL LETTER PSI");
   ("/xd1/xb1", "CYRILLIC SMALL LETTER PSI");
   ("/xd1/xb2", "CYRILLIC CAPITAL LETTER FITA");
   ("/xd1/xb3", "CYRILLIC SMALL LETTER FITA");
   ("/xd1/xb4", "CYRILLIC CAPITAL LETTER IZHITSA");
   ("/xd1/xb5", "CYRILLIC SMALL LETTER IZHITSA");
   ("/xd1/xb6", "CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT");
   ("/xd1/xb7", "CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT");
   ("/xd1/xb8", "CYRILLIC CAPITAL LETTER UK");
   ("/xd1/xb9", "CYRILLIC SMALL LETTER UK");
   ("/xd1/xba", "CYRILLIC CAPITAL LETTER ROUND OMEGA");
   ("/xd1/xbb", "CYRILLIC SMALL LETTER ROUND OMEGA");
   ("/xd1/xbc", "CYRILLIC CAPITAL LETTER OMEGA WITH TITLO");
   ("/xd1/xbd", "CYRILLIC SMALL LETTER OMEGA WITH TITLO");
   ("/xd1/xbe", "CYRILLIC CAPITAL LETTER OT");
   ("/xd1/xbf", "CYRILLIC SMALL LETTER OT");
   ("/xd2/x80", "CYRILLIC CAPITAL LETTER KOPPA");
   ("/xd2/x81", "CYRILLIC SMALL LETTER KOPPA");
   ("/xd2/x8a", "CYRILLIC CAPITAL LETTER SHORT I WITH TAIL");
   ("/xd2/x8b", "CYRILLIC SMALL LETTER SHORT I WITH TAIL");
   ("/xd2/x8c", "CYRILLIC CAPITAL LETTER SEMISOFT SIGN");
   ("/xd2/x8d", "CYRILLIC SMALL LETTER SEMISOFT SIGN");
   ("/xd2/x8e", "CYRILLIC CAPITAL LETTER ER WITH TICK");
   ("/xd2/x8f", "CYRILLIC SMALL LETTER ER WITH TICK");
   ("/xd2/x90", "CYRILLIC CAPITAL LETTER GHE WITH UPTURN");
   ("/xd2/x91", "CYRILLIC SMALL LETTER GHE WITH UPTURN");
   ("/xd2/x92", "CYRILLIC CAPITAL LETTER GHE WITH STROKE");
   ("/xd2/x93", "CYRILLIC SMALL LETTER GHE WITH STROKE");
   ("/xd2/x94", "CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK");
   ("/xd2/x95", "CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK");
   ("/xd2/x96", "CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER");
   ("/xd2/x97", "CYRILLIC SMALL LETTER ZHE WITH DESCENDER");
   ("/xd2/x98", "CYRILLIC CAPITAL LETTER ZE WITH DESCENDER");
   ("/xd2/x99", "CYRILLIC SMALL LETTER ZE WITH DESCENDER");
   ("/xd2/x9a", "CYRILLIC CAPITAL LETTER KA WITH DESCENDER");
   ("/xd2/x9b", "CYRILLIC SMALL LETTER KA WITH DESCENDER");
   ("/xd2/x9c", "CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE");
   ("/xd2/x9d", "CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE");
   ("/xd2/x9e", "CYRILLIC CAPITAL LETTER KA WITH STROKE");
   ("/xd2/x9f", "CYRILLIC SMALL LETTER KA WITH STROKE");
   ("/xd2/xa0", "CYRILLIC CAPITAL LETTER BASHKIR KA");
   ("/xd2/xa1", "CYRILLIC SMALL LETTER BASHKIR KA");
   ("/xd2/xa2", "CYRILLIC CAPITAL LETTER EN WITH DESCENDER");
   ("/xd2/xa3", "CYRILLIC SMALL LETTER EN WITH DESCENDER");
   ("/xd2/xa4", "CYRILLIC CAPITAL LIGATURE EN GHE");
   ("/xd2/xa5", "CYRILLIC SMALL LIGATURE EN GHE");
   ("/xd2/xa6", "CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK");
   ("/xd2/xa7", "CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK");
   ("/xd2/xa8", "CYRILLIC CAPITAL LETTER ABKHASIAN HA");
   ("/xd2/xa9", "CYRILLIC SMALL LETTER ABKHASIAN HA");
   ("/xd2/xaa", "CYRILLIC CAPITAL LETTER ES WITH DESCENDER");
   ("/xd2/xab", "CYRILLIC SMALL LETTER ES WITH DESCENDER");
   ("/xd2/xac", "CYRILLIC CAPITAL LETTER TE WITH DESCENDER");
   ("/xd2/xad", "CYRILLIC SMALL LETTER TE WITH DESCENDER");
   ("/xd2/xae", "CYRILLIC CAPITAL LETTER STRAIGHT U");
   ("/xd2/xaf", "CYRILLIC SMALL LETTER STRAIGHT U");
   ("/xd2/xb0", "CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE");
   ("/xd2/xb1", "CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE");
   ("/xd2/xb2", "CYRILLIC CAPITAL LETTER HA WITH DESCENDER");
   ("/xd2/xb3", "CYRILLIC SMALL LETTER HA WITH DESCENDER");
   ("/xd2/xb4", "CYRILLIC CAPITAL LIGATURE TE TSE");
   ("/xd2/xb5", "CYRILLIC SMALL LIGATURE TE TSE");
   ("/xd2/xb6", "CYRILLIC CAPITAL LETTER CHE WITH DESCENDER");
   ("/xd2/xb7", "CYRILLIC SMALL LETTER CHE WITH DESCENDER");
   ("/xd2/xb8", "CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE");
   ("/xd2/xb9", "CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE");
   ("/xd2/xba", "CYRILLIC CAPITAL LETTER SHHA");
   ("/xd2/xbb", "CYRILLIC SMALL LETTER SHHA");
   ("/xd2/xbc", "CYRILLIC CAPITAL LETTER ABKHASIAN CHE");
   ("/xd2/xbd", "CYRILLIC SMALL LETTER ABKHASIAN CHE");
   ("/xd2/xbe", "CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER");
   ("/xd2/xbf", "CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER");
   ("/xd3/x81", "CYRILLIC CAPITAL LETTER ZHE WITH BREVE");
   ("/xd3/x82", "CYRILLIC SMALL LETTER ZHE WITH BREVE");
   ("/xd3/x83", "CYRILLIC CAPITAL LETTER KA WITH HOOK");
   ("/xd3/x84", "CYRILLIC SMALL LETTER KA WITH HOOK");
   ("/xd3/x85", "CYRILLIC CAPITAL LETTER EL WITH TAIL");
   ("/xd3/x86", "CYRILLIC SMALL LETTER EL WITH TAIL");
   ("/xd3/x87", "CYRILLIC CAPITAL LETTER EN WITH HOOK");
   ("/xd3/x88", "CYRILLIC SMALL LETTER EN WITH HOOK");
   ("/xd3/x89", "CYRILLIC CAPITAL LETTER EN WITH TAIL");
   ("/xd3/x8a", "CYRILLIC SMALL LETTER EN WITH TAIL");
   ("/xd3/x8b", "CYRILLIC CAPITAL LETTER KHAKASSIAN CHE");
   ("/xd3/x8c", "CYRILLIC SMALL LETTER KHAKASSIAN CHE");
   ("/xd3/x8d", "CYRILLIC CAPITAL LETTER EM WITH TAIL");
   ("/xd3/x8e", "CYRILLIC SMALL LETTER EM WITH TAIL");
   ("/xd3/x8f", "CYRILLIC SMALL LETTER PALOCHKA");
   ("/xd3/x90", "CYRILLIC CAPITAL LETTER A WITH BREVE");
   ("/xd3/x91", "CYRILLIC SMALL LETTER A WITH BREVE");
   ("/xd3/x92", "CYRILLIC CAPITAL LETTER A WITH DIAERESIS");
   ("/xd3/x93", "CYRILLIC SMALL LETTER A WITH DIAERESIS");
   ("/xd3/x94", "CYRILLIC CAPITAL LIGATURE A IE");
   ("/xd3/x95", "CYRILLIC SMALL LIGATURE A IE");
   ("/xd3/x96", "CYRILLIC CAPITAL LETTER IE WITH BREVE");
   ("/xd3/x97", "CYRILLIC SMALL LETTER IE WITH BREVE");
   ("/xd3/x98", "CYRILLIC CAPITAL LETTER SCHWA");
   ("/xd3/x99", "CYRILLIC SMALL LETTER SCHWA");
   ("/xd3/x9a", "CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS");
   ("/xd3/x9b", "CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS");
   ("/xd3/x9c", "CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS");
   ("/xd3/x9d", "CYRILLIC SMALL LETTER ZHE WITH DIAERESIS");
   ("/xd3/x9e", "CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS");
   ("/xd3/x9f", "CYRILLIC SMALL LETTER ZE WITH DIAERESIS");
   ("/xd3/xa0", "CYRILLIC CAPITAL LETTER ABKHASIAN DZE");
   ("/xd3/xa1", "CYRILLIC SMALL LETTER ABKHASIAN DZE");
   ("/xd3/xa2", "CYRILLIC CAPITAL LETTER I WITH MACRON");
   ("/xd3/xa3", "CYRILLIC SMALL LETTER I WITH MACRON");
   ("/xd3/xa4", "CYRILLIC CAPITAL LETTER I WITH DIAERESIS");
   ("/xd3/xa5", "CYRILLIC SMALL LETTER I WITH DIAERESIS");
   ("/xd3/xa6", "CYRILLIC CAPITAL LETTER O WITH DIAERESIS");
   ("/xd3/xa7", "CYRILLIC SMALL LETTER O WITH DIAERESIS");
   ("/xd3/xa8", "CYRILLIC CAPITAL LETTER BARRED O");
   ("/xd3/xa9", "CYRILLIC SMALL LETTER BARRED O");
   ("/xd3/xaa", "CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS");
   ("/xd3/xab", "CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS");
   ("/xd3/xac", "CYRILLIC CAPITAL LETTER E WITH DIAERESIS");
   ("/xd3/xad", "CYRILLIC SMALL LETTER E WITH DIAERESIS");
   ("/xd3/xae", "CYRILLIC CAPITAL LETTER U WITH MACRON");
   ("/xd3/xaf", "CYRILLIC SMALL LETTER U WITH MACRON");
   ("/xd3/xb0", "CYRILLIC CAPITAL LETTER U WITH DIAERESIS");
   ("/xd3/xb1", "CYRILLIC SMALL LETTER U WITH DIAERESIS");
   ("/xd3/xb2", "CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE");
   ("/xd3/xb3", "CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE");
   ("/xd3/xb4", "CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS");
   ("/xd3/xb5", "CYRILLIC SMALL LETTER CHE WITH DIAERESIS");
   ("/xd3/xb6", "CYRILLIC CAPITAL LETTER GHE WITH DESCENDER");
   ("/xd3/xb7", "CYRILLIC SMALL LETTER GHE WITH DESCENDER");
   ("/xd3/xb8", "CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS");
   ("/xd3/xb9", "CYRILLIC SMALL LETTER YERU WITH DIAERESIS");
   ("/xd3/xba", "CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK");
   ("/xd3/xbb", "CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK");
   ("/xd3/xbc", "CYRILLIC CAPITAL LETTER HA WITH HOOK");
   ("/xd3/xbd", "CYRILLIC SMALL LETTER HA WITH HOOK");
   ("/xd3/xbe", "CYRILLIC CAPITAL LETTER HA WITH STROKE");
   ("/xd3/xbf", "CYRILLIC SMALL LETTER HA WITH STROKE");
   ("/xd4/x80", "CYRILLIC CAPITAL LETTER KOMI DE");
   ("/xd4/x81", "CYRILLIC SMALL LETTER KOMI DE");
   ("/xd4/x82", "CYRILLIC CAPITAL LETTER KOMI DJE");
   ("/xd4/x83", "CYRILLIC SMALL LETTER KOMI DJE");
   ("/xd4/x84", "CYRILLIC CAPITAL LETTER KOMI ZJE");
   ("/xd4/x85", "CYRILLIC SMALL LETTER KOMI ZJE");
   ("/xd4/x86", "CYRILLIC CAPITAL LETTER KOMI DZJE");
   ("/xd4/x87", "CYRILLIC SMALL LETTER KOMI DZJE");
   ("/xd4/x88", "CYRILLIC CAPITAL LETTER KOMI LJE");
   ("/xd4/x89", "CYRILLIC SMALL LETTER KOMI LJE");
   ("/xd4/x8a", "CYRILLIC CAPITAL LETTER KOMI NJE");
   ("/xd4/x8b", "CYRILLIC SMALL LETTER KOMI NJE");
   ("/xd4/x8c", "CYRILLIC CAPITAL LETTER KOMI SJE");
   ("/xd4/x8d", "CYRILLIC SMALL LETTER KOMI SJE");
   ("/xd4/x8e", "CYRILLIC CAPITAL LETTER KOMI TJE");
   ("/xd4/x8f", "CYRILLIC SMALL LETTER KOMI TJE");
   ("/xd4/x90", "CYRILLIC CAPITAL LETTER REVERSED ZE");
   ("/xd4/x91", "CYRILLIC SMALL LETTER REVERSED ZE");
   ("/xd4/x92", "CYRILLIC CAPITAL LETTER EL WITH HOOK");
   ("/xd4/x93", "CYRILLIC SMALL LETTER EL WITH HOOK");
   ("/xd4/x94", "CYRILLIC CAPITAL LETTER LHA");
   ("/xd4/x95", "CYRILLIC SMALL LETTER LHA");
   ("/xd4/x96", "CYRILLIC CAPITAL LETTER RHA");
   ("/xd4/x97", "CYRILLIC SMALL LETTER RHA");
   ("/xd4/x98", "CYRILLIC CAPITAL LETTER YAE");
   ("/xd4/x99", "CYRILLIC SMALL LETTER YAE");
   ("/xd4/x9a", "CYRILLIC CAPITAL LETTER QA");
   ("/xd4/x9b", "CYRILLIC SMALL LETTER QA");
   ("/xd4/x9c", "CYRILLIC CAPITAL LETTER WE");
   ("/xd4/x9d", "CYRILLIC SMALL LETTER WE");
   ("/xd4/x9e", "CYRILLIC CAPITAL LETTER ALEUT KA");
   ("/xd4/x9f", "CYRILLIC SMALL LETTER ALEUT KA");
   ("/xd4/xa0", "CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK");
   ("/xd4/xa1", "CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK");
   ("/xd4/xa2", "CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK");
   ("/xd4/xa3", "CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK");
   ("/xd4/xb1", "ARMENIAN CAPITAL LETTER AYB");
   ("/xd4/xb2", "ARMENIAN CAPITAL LETTER BEN");
   ("/xd4/xb3", "ARMENIAN CAPITAL LETTER GIM");
   ("/xd4/xb4", "ARMENIAN CAPITAL LETTER DA");
   ("/xd4/xb5", "ARMENIAN CAPITAL LETTER ECH");
   ("/xd4/xb6", "ARMENIAN CAPITAL LETTER ZA");
   ("/xd4/xb7", "ARMENIAN CAPITAL LETTER EH");
   ("/xd4/xb8", "ARMENIAN CAPITAL LETTER ET");
   ("/xd4/xb9", "ARMENIAN CAPITAL LETTER TO");
   ("/xd4/xba", "ARMENIAN CAPITAL LETTER ZHE");
   ("/xd4/xbb", "ARMENIAN CAPITAL LETTER INI");
   ("/xd4/xbc", "ARMENIAN CAPITAL LETTER LIWN");
   ("/xd4/xbd", "ARMENIAN CAPITAL LETTER XEH");
   ("/xd4/xbe", "ARMENIAN CAPITAL LETTER CA");
   ("/xd4/xbf", "ARMENIAN CAPITAL LETTER KEN");
   ("/xd5/x80", "ARMENIAN CAPITAL LETTER HO");
   ("/xd5/x81", "ARMENIAN CAPITAL LETTER JA");
   ("/xd5/x82", "ARMENIAN CAPITAL LETTER GHAD");
   ("/xd5/x83", "ARMENIAN CAPITAL LETTER CHEH");
   ("/xd5/x84", "ARMENIAN CAPITAL LETTER MEN");
   ("/xd5/x85", "ARMENIAN CAPITAL LETTER YI");
   ("/xd5/x86", "ARMENIAN CAPITAL LETTER NOW");
   ("/xd5/x87", "ARMENIAN CAPITAL LETTER SHA");
   ("/xd5/x88", "ARMENIAN CAPITAL LETTER VO");
   ("/xd5/x89", "ARMENIAN CAPITAL LETTER CHA");
   ("/xd5/x8a", "ARMENIAN CAPITAL LETTER PEH");
   ("/xd5/x8b", "ARMENIAN CAPITAL LETTER JHEH");
   ("/xd5/x8c", "ARMENIAN CAPITAL LETTER RA");
   ("/xd5/x8d", "ARMENIAN CAPITAL LETTER SEH");
   ("/xd5/x8e", "ARMENIAN CAPITAL LETTER VEW");
   ("/xd5/x8f", "ARMENIAN CAPITAL LETTER TIWN");
   ("/xd5/x90", "ARMENIAN CAPITAL LETTER REH");
   ("/xd5/x91", "ARMENIAN CAPITAL LETTER CO");
   ("/xd5/x92", "ARMENIAN CAPITAL LETTER YIWN");
   ("/xd5/x93", "ARMENIAN CAPITAL LETTER PIWR");
   ("/xd5/x94", "ARMENIAN CAPITAL LETTER KEH");
   ("/xd5/x95", "ARMENIAN CAPITAL LETTER OH");
   ("/xd5/x96", "ARMENIAN CAPITAL LETTER FEH");
   ("/xd5/xa1", "ARMENIAN SMALL LETTER AYB");
   ("/xd5/xa2", "ARMENIAN SMALL LETTER BEN");
   ("/xd5/xa3", "ARMENIAN SMALL LETTER GIM");
   ("/xd5/xa4", "ARMENIAN SMALL LETTER DA");
   ("/xd5/xa5", "ARMENIAN SMALL LETTER ECH");
   ("/xd5/xa6", "ARMENIAN SMALL LETTER ZA");
   ("/xd5/xa7", "ARMENIAN SMALL LETTER EH");
   ("/xd5/xa8", "ARMENIAN SMALL LETTER ET");
   ("/xd5/xa9", "ARMENIAN SMALL LETTER TO");
   ("/xd5/xaa", "ARMENIAN SMALL LETTER ZHE");
   ("/xd5/xab", "ARMENIAN SMALL LETTER INI");
   ("/xd5/xac", "ARMENIAN SMALL LETTER LIWN");
   ("/xd5/xad", "ARMENIAN SMALL LETTER XEH");
   ("/xd5/xae", "ARMENIAN SMALL LETTER CA");
   ("/xd5/xaf", "ARMENIAN SMALL LETTER KEN");
   ("/xd5/xb0", "ARMENIAN SMALL LETTER HO");
   ("/xd5/xb1", "ARMENIAN SMALL LETTER JA");
   ("/xd5/xb2", "ARMENIAN SMALL LETTER GHAD");
   ("/xd5/xb3", "ARMENIAN SMALL LETTER CHEH");
   ("/xd5/xb4", "ARMENIAN SMALL LETTER MEN");
   ("/xd5/xb5", "ARMENIAN SMALL LETTER YI");
   ("/xd5/xb6", "ARMENIAN SMALL LETTER NOW");
   ("/xd5/xb7", "ARMENIAN SMALL LETTER SHA");
   ("/xd5/xb8", "ARMENIAN SMALL LETTER VO");
   ("/xd5/xb9", "ARMENIAN SMALL LETTER CHA");
   ("/xd5/xba", "ARMENIAN SMALL LETTER PEH");
   ("/xd5/xbb", "ARMENIAN SMALL LETTER JHEH");
   ("/xd5/xbc", "ARMENIAN SMALL LETTER RA");
   ("/xd5/xbd", "ARMENIAN SMALL LETTER SEH");
   ("/xd5/xbe", "ARMENIAN SMALL LETTER VEW");
   ("/xd5/xbf", "ARMENIAN SMALL LETTER TIWN");
   ("/xd6/x80", "ARMENIAN SMALL LETTER REH");
   ("/xd6/x81", "ARMENIAN SMALL LETTER CO");
   ("/xd6/x82", "ARMENIAN SMALL LETTER YIWN");
   ("/xd6/x83", "ARMENIAN SMALL LETTER PIWR");
   ("/xd6/x84", "ARMENIAN SMALL LETTER KEH");
   ("/xd6/x85", "ARMENIAN SMALL LETTER OH");
   ("/xd6/x86", "ARMENIAN SMALL LETTER FEH");
   ("/xd6/x87", "ARMENIAN SMALL LIGATURE ECH YIWN");
   ("/xd8/x95", "ARABIC SMALL HIGH TAH");
   ("/xd8/x96", "ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH");
   ("/xd8/x97", "ARABIC SMALL HIGH ZAIN");
   ("/xd8/x98", "ARABIC SMALL FATHA");
   ("/xd8/x99", "ARABIC SMALL DAMMA");
   ("/xd8/x9a", "ARABIC SMALL KASRA");
   ("/xd9/x9a", "ARABIC VOWEL SIGN SMALL V ABOVE");
   ("/xd9/x9b", "ARABIC VOWEL SIGN INVERTED SMALL V ABOVE");
   ("/xda/x8b", "ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH");
   ("/xda/x92", "ARABIC LETTER REH WITH SMALL V");
   ("/xda/x95", "ARABIC LETTER REH WITH SMALL V BELOW");
   ("/xda/xb5", "ARABIC LETTER LAM WITH SMALL V");
   ("/xdb/x8e", "ARABIC LETTER YEH WITH SMALL V");
   ("/xdb/x96", "ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA");
   ("/xdb/x97", "ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA");
   ("/xdb/x98", "ARABIC SMALL HIGH MEEM INITIAL FORM");
   ("/xdb/x99", "ARABIC SMALL HIGH LAM ALEF");
   ("/xdb/x9a", "ARABIC SMALL HIGH JEEM");
   ("/xdb/x9b", "ARABIC SMALL HIGH THREE DOTS");
   ("/xdb/x9c", "ARABIC SMALL HIGH SEEN");
   ("/xdb/x9f", "ARABIC SMALL HIGH ROUNDED ZERO");
   ("/xdb/xa0", "ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO");
   ("/xdb/xa1", "ARABIC SMALL HIGH DOTLESS HEAD OF KHAH");
   ("/xdb/xa2", "ARABIC SMALL HIGH MEEM ISOLATED FORM");
   ("/xdb/xa3", "ARABIC SMALL LOW SEEN");
   ("/xdb/xa4", "ARABIC SMALL HIGH MADDA");
   ("/xdb/xa5", "ARABIC SMALL WAW");
   ("/xdb/xa6", "ARABIC SMALL YEH");
   ("/xdb/xa7", "ARABIC SMALL HIGH YEH");
   ("/xdb/xa8", "ARABIC SMALL HIGH NOON");
   ("/xdb/xad", "ARABIC SMALL LOW MEEM");
   ("/xdd/x95", "ARABIC LETTER BEH WITH INVERTED SMALL V BELOW");
   ("/xdd/x96", "ARABIC LETTER BEH WITH SMALL V");
   ("/xdd/x99", "ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH");
   ("/xdd/x9a", "ARABIC LETTER DAL WITH INVERTED SMALL V BELOW");
   ("/xdd/xa8", "ARABIC LETTER NOON WITH SMALL TAH");
   ("/xdd/xa9", "ARABIC LETTER NOON WITH SMALL V");
   ("/xdd/xae", "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOW");
   ("/xdd/xaf", "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTS");
   ("/xdd/xb0", "ARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTS");
   ("/xdd/xb1", "ARABIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTS");
   ("/xdd/xb2", "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVE");
   ("/xe1/x82/xa0", "GEORGIAN CAPITAL LETTER AN");
   ("/xe1/x82/xa1", "GEORGIAN CAPITAL LETTER BAN");
   ("/xe1/x82/xa2", "GEORGIAN CAPITAL LETTER GAN");
   ("/xe1/x82/xa3", "GEORGIAN CAPITAL LETTER DON");
   ("/xe1/x82/xa4", "GEORGIAN CAPITAL LETTER EN");
   ("/xe1/x82/xa5", "GEORGIAN CAPITAL LETTER VIN");
   ("/xe1/x82/xa6", "GEORGIAN CAPITAL LETTER ZEN");
   ("/xe1/x82/xa7", "GEORGIAN CAPITAL LETTER TAN");
   ("/xe1/x82/xa8", "GEORGIAN CAPITAL LETTER IN");
   ("/xe1/x82/xa9", "GEORGIAN CAPITAL LETTER KAN");
   ("/xe1/x82/xaa", "GEORGIAN CAPITAL LETTER LAS");
   ("/xe1/x82/xab", "GEORGIAN CAPITAL LETTER MAN");
   ("/xe1/x82/xac", "GEORGIAN CAPITAL LETTER NAR");
   ("/xe1/x82/xad", "GEORGIAN CAPITAL LETTER ON");
   ("/xe1/x82/xae", "GEORGIAN CAPITAL LETTER PAR");
   ("/xe1/x82/xaf", "GEORGIAN CAPITAL LETTER ZHAR");
   ("/xe1/x82/xb0", "GEORGIAN CAPITAL LETTER RAE");
   ("/xe1/x82/xb1", "GEORGIAN CAPITAL LETTER SAN");
   ("/xe1/x82/xb2", "GEORGIAN CAPITAL LETTER TAR");
   ("/xe1/x82/xb3", "GEORGIAN CAPITAL LETTER UN");
   ("/xe1/x82/xb4", "GEORGIAN CAPITAL LETTER PHAR");
   ("/xe1/x82/xb5", "GEORGIAN CAPITAL LETTER KHAR");
   ("/xe1/x82/xb6", "GEORGIAN CAPITAL LETTER GHAN");
   ("/xe1/x82/xb7", "GEORGIAN CAPITAL LETTER QAR");
   ("/xe1/x82/xb8", "GEORGIAN CAPITAL LETTER SHIN");
   ("/xe1/x82/xb9", "GEORGIAN CAPITAL LETTER CHIN");
   ("/xe1/x82/xba", "GEORGIAN CAPITAL LETTER CAN");
   ("/xe1/x82/xbb", "GEORGIAN CAPITAL LETTER JIL");
   ("/xe1/x82/xbc", "GEORGIAN CAPITAL LETTER CIL");
   ("/xe1/x82/xbd", "GEORGIAN CAPITAL LETTER CHAR");
   ("/xe1/x82/xbe", "GEORGIAN CAPITAL LETTER XAN");
   ("/xe1/x82/xbf", "GEORGIAN CAPITAL LETTER JHAN");
   ("/xe1/x83/x80", "GEORGIAN CAPITAL LETTER HAE");
   ("/xe1/x83/x81", "GEORGIAN CAPITAL LETTER HE");
   ("/xe1/x83/x82", "GEORGIAN CAPITAL LETTER HIE");
   ("/xe1/x83/x83", "GEORGIAN CAPITAL LETTER WE");
   ("/xe1/x83/x84", "GEORGIAN CAPITAL LETTER HAR");
   ("/xe1/x83/x85", "GEORGIAN CAPITAL LETTER HOE");
   ("/xe1/xa4/xb0", "LIMBU SMALL LETTER KA");
   ("/xe1/xa4/xb1", "LIMBU SMALL LETTER NGA");
   ("/xe1/xa4/xb2", "LIMBU SMALL LETTER ANUSVARA");
   ("/xe1/xa4/xb3", "LIMBU SMALL LETTER TA");
   ("/xe1/xa4/xb4", "LIMBU SMALL LETTER NA");
   ("/xe1/xa4/xb5", "LIMBU SMALL LETTER PA");
   ("/xe1/xa4/xb6", "LIMBU SMALL LETTER MA");
   ("/xe1/xa4/xb7", "LIMBU SMALL LETTER RA");
   ("/xe1/xa4/xb8", "LIMBU SMALL LETTER LA");
   ("/xe1/xb4/x80", "LATIN LETTER SMALL CAPITAL A");
   ("/xe1/xb4/x81", "LATIN LETTER SMALL CAPITAL AE");
   ("/xe1/xb4/x82", "LATIN SMALL LETTER TURNED AE");
   ("/xe1/xb4/x83", "LATIN LETTER SMALL CAPITAL BARRED B");
   ("/xe1/xb4/x84", "LATIN LETTER SMALL CAPITAL C");
   ("/xe1/xb4/x85", "LATIN LETTER SMALL CAPITAL D");
   ("/xe1/xb4/x86", "LATIN LETTER SMALL CAPITAL ETH");
   ("/xe1/xb4/x87", "LATIN LETTER SMALL CAPITAL E");
   ("/xe1/xb4/x88", "LATIN SMALL LETTER TURNED OPEN E");
   ("/xe1/xb4/x89", "LATIN SMALL LETTER TURNED I");
   ("/xe1/xb4/x8a", "LATIN LETTER SMALL CAPITAL J");
   ("/xe1/xb4/x8b", "LATIN LETTER SMALL CAPITAL K");
   ("/xe1/xb4/x8c", "LATIN LETTER SMALL CAPITAL L WITH STROKE");
   ("/xe1/xb4/x8d", "LATIN LETTER SMALL CAPITAL M");
   ("/xe1/xb4/x8e", "LATIN LETTER SMALL CAPITAL REVERSED N");
   ("/xe1/xb4/x8f", "LATIN LETTER SMALL CAPITAL O");
   ("/xe1/xb4/x90", "LATIN LETTER SMALL CAPITAL OPEN O");
   ("/xe1/xb4/x91", "LATIN SMALL LETTER SIDEWAYS O");
   ("/xe1/xb4/x92", "LATIN SMALL LETTER SIDEWAYS OPEN O");
   ("/xe1/xb4/x93", "LATIN SMALL LETTER SIDEWAYS O WITH STROKE");
   ("/xe1/xb4/x94", "LATIN SMALL LETTER TURNED OE");
   ("/xe1/xb4/x95", "LATIN LETTER SMALL CAPITAL OU");
   ("/xe1/xb4/x96", "LATIN SMALL LETTER TOP HALF O");
   ("/xe1/xb4/x97", "LATIN SMALL LETTER BOTTOM HALF O");
   ("/xe1/xb4/x98", "LATIN LETTER SMALL CAPITAL P");
   ("/xe1/xb4/x99", "LATIN LETTER SMALL CAPITAL REVERSED R");
   ("/xe1/xb4/x9a", "LATIN LETTER SMALL CAPITAL TURNED R");
   ("/xe1/xb4/x9b", "LATIN LETTER SMALL CAPITAL T");
   ("/xe1/xb4/x9c", "LATIN LETTER SMALL CAPITAL U");
   ("/xe1/xb4/x9d", "LATIN SMALL LETTER SIDEWAYS U");
   ("/xe1/xb4/x9e", "LATIN SMALL LETTER SIDEWAYS DIAERESIZED U");
   ("/xe1/xb4/x9f", "LATIN SMALL LETTER SIDEWAYS TURNED M");
   ("/xe1/xb4/xa0", "LATIN LETTER SMALL CAPITAL V");
   ("/xe1/xb4/xa1", "LATIN LETTER SMALL CAPITAL W");
   ("/xe1/xb4/xa2", "LATIN LETTER SMALL CAPITAL Z");
   ("/xe1/xb4/xa3", "LATIN LETTER SMALL CAPITAL EZH");
   ("/xe1/xb4/xa6", "GREEK LETTER SMALL CAPITAL GAMMA");
   ("/xe1/xb4/xa7", "GREEK LETTER SMALL CAPITAL LAMDA");
   ("/xe1/xb4/xa8", "GREEK LETTER SMALL CAPITAL PI");
   ("/xe1/xb4/xa9", "GREEK LETTER SMALL CAPITAL RHO");
   ("/xe1/xb4/xaa", "GREEK LETTER SMALL CAPITAL PSI");
   ("/xe1/xb4/xab", "CYRILLIC LETTER SMALL CAPITAL EL");
   ("/xe1/xb4/xac", "MODIFIER LETTER CAPITAL A");
   ("/xe1/xb4/xad", "MODIFIER LETTER CAPITAL AE");
   ("/xe1/xb4/xae", "MODIFIER LETTER CAPITAL B");
   ("/xe1/xb4/xaf", "MODIFIER LETTER CAPITAL BARRED B");
   ("/xe1/xb4/xb0", "MODIFIER LETTER CAPITAL D");
   ("/xe1/xb4/xb1", "MODIFIER LETTER CAPITAL E");
   ("/xe1/xb4/xb2", "MODIFIER LETTER CAPITAL REVERSED E");
   ("/xe1/xb4/xb3", "MODIFIER LETTER CAPITAL G");
   ("/xe1/xb4/xb4", "MODIFIER LETTER CAPITAL H");
   ("/xe1/xb4/xb5", "MODIFIER LETTER CAPITAL I");
   ("/xe1/xb4/xb6", "MODIFIER LETTER CAPITAL J");
   ("/xe1/xb4/xb7", "MODIFIER LETTER CAPITAL K");
   ("/xe1/xb4/xb8", "MODIFIER LETTER CAPITAL L");
   ("/xe1/xb4/xb9", "MODIFIER LETTER CAPITAL M");
   ("/xe1/xb4/xba", "MODIFIER LETTER CAPITAL N");
   ("/xe1/xb4/xbb", "MODIFIER LETTER CAPITAL REVERSED N");
   ("/xe1/xb4/xbc", "MODIFIER LETTER CAPITAL O");
   ("/xe1/xb4/xbd", "MODIFIER LETTER CAPITAL OU");
   ("/xe1/xb4/xbe", "MODIFIER LETTER CAPITAL P");
   ("/xe1/xb4/xbf", "MODIFIER LETTER CAPITAL R");
   ("/xe1/xb5/x80", "MODIFIER LETTER CAPITAL T");
   ("/xe1/xb5/x81", "MODIFIER LETTER CAPITAL U");
   ("/xe1/xb5/x82", "MODIFIER LETTER CAPITAL W");
   ("/xe1/xb5/x83", "MODIFIER LETTER SMALL A");
   ("/xe1/xb5/x84", "MODIFIER LETTER SMALL TURNED A");
   ("/xe1/xb5/x85", "MODIFIER LETTER SMALL ALPHA");
   ("/xe1/xb5/x86", "MODIFIER LETTER SMALL TURNED AE");
   ("/xe1/xb5/x87", "MODIFIER LETTER SMALL B");
   ("/xe1/xb5/x88", "MODIFIER LETTER SMALL D");
   ("/xe1/xb5/x89", "MODIFIER LETTER SMALL E");
   ("/xe1/xb5/x8a", "MODIFIER LETTER SMALL SCHWA");
   ("/xe1/xb5/x8b", "MODIFIER LETTER SMALL OPEN E");
   ("/xe1/xb5/x8c", "MODIFIER LETTER SMALL TURNED OPEN E");
   ("/xe1/xb5/x8d", "MODIFIER LETTER SMALL G");
   ("/xe1/xb5/x8e", "MODIFIER LETTER SMALL TURNED I");
   ("/xe1/xb5/x8f", "MODIFIER LETTER SMALL K");
   ("/xe1/xb5/x90", "MODIFIER LETTER SMALL M");
   ("/xe1/xb5/x91", "MODIFIER LETTER SMALL ENG");
   ("/xe1/xb5/x92", "MODIFIER LETTER SMALL O");
   ("/xe1/xb5/x93", "MODIFIER LETTER SMALL OPEN O");
   ("/xe1/xb5/x94", "MODIFIER LETTER SMALL TOP HALF O");
   ("/xe1/xb5/x95", "MODIFIER LETTER SMALL BOTTOM HALF O");
   ("/xe1/xb5/x96", "MODIFIER LETTER SMALL P");
   ("/xe1/xb5/x97", "MODIFIER LETTER SMALL T");
   ("/xe1/xb5/x98", "MODIFIER LETTER SMALL U");
   ("/xe1/xb5/x99", "MODIFIER LETTER SMALL SIDEWAYS U");
   ("/xe1/xb5/x9a", "MODIFIER LETTER SMALL TURNED M");
   ("/xe1/xb5/x9b", "MODIFIER LETTER SMALL V");
   ("/xe1/xb5/x9c", "MODIFIER LETTER SMALL AIN");
   ("/xe1/xb5/x9d", "MODIFIER LETTER SMALL BETA");
   ("/xe1/xb5/x9e", "MODIFIER LETTER SMALL GREEK GAMMA");
   ("/xe1/xb5/x9f", "MODIFIER LETTER SMALL DELTA");
   ("/xe1/xb5/xa0", "MODIFIER LETTER SMALL GREEK PHI");
   ("/xe1/xb5/xa1", "MODIFIER LETTER SMALL CHI");
   ("/xe1/xb5/xa2", "LATIN SUBSCRIPT SMALL LETTER I");
   ("/xe1/xb5/xa3", "LATIN SUBSCRIPT SMALL LETTER R");
   ("/xe1/xb5/xa4", "LATIN SUBSCRIPT SMALL LETTER U");
   ("/xe1/xb5/xa5", "LATIN SUBSCRIPT SMALL LETTER V");
   ("/xe1/xb5/xa6", "GREEK SUBSCRIPT SMALL LETTER BETA");
   ("/xe1/xb5/xa7", "GREEK SUBSCRIPT SMALL LETTER GAMMA");
   ("/xe1/xb5/xa8", "GREEK SUBSCRIPT SMALL LETTER RHO");
   ("/xe1/xb5/xa9", "GREEK SUBSCRIPT SMALL LETTER PHI");
   ("/xe1/xb5/xaa", "GREEK SUBSCRIPT SMALL LETTER CHI");
   ("/xe1/xb5/xab", "LATIN SMALL LETTER UE");
   ("/xe1/xb5/xac", "LATIN SMALL LETTER B WITH MIDDLE TILDE");
   ("/xe1/xb5/xad", "LATIN SMALL LETTER D WITH MIDDLE TILDE");
   ("/xe1/xb5/xae", "LATIN SMALL LETTER F WITH MIDDLE TILDE");
   ("/xe1/xb5/xaf", "LATIN SMALL LETTER M WITH MIDDLE TILDE");
   ("/xe1/xb5/xb0", "LATIN SMALL LETTER N WITH MIDDLE TILDE");
   ("/xe1/xb5/xb1", "LATIN SMALL LETTER P WITH MIDDLE TILDE");
   ("/xe1/xb5/xb2", "LATIN SMALL LETTER R WITH MIDDLE TILDE");
   ("/xe1/xb5/xb3", "LATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDE");
   ("/xe1/xb5/xb4", "LATIN SMALL LETTER S WITH MIDDLE TILDE");
   ("/xe1/xb5/xb5", "LATIN SMALL LETTER T WITH MIDDLE TILDE");
   ("/xe1/xb5/xb6", "LATIN SMALL LETTER Z WITH MIDDLE TILDE");
   ("/xe1/xb5/xb7", "LATIN SMALL LETTER TURNED G");
   ("/xe1/xb5/xb9", "LATIN SMALL LETTER INSULAR G");
   ("/xe1/xb5/xba", "LATIN SMALL LETTER TH WITH STRIKETHROUGH");
   ("/xe1/xb5/xbb", "LATIN SMALL CAPITAL LETTER I WITH STROKE");
   ("/xe1/xb5/xbc", "LATIN SMALL LETTER IOTA WITH STROKE");
   ("/xe1/xb5/xbd", "LATIN SMALL LETTER P WITH STROKE");
   ("/xe1/xb5/xbe", "LATIN SMALL CAPITAL LETTER U WITH STROKE");
   ("/xe1/xb5/xbf", "LATIN SMALL LETTER UPSILON WITH STROKE");
   ("/xe1/xb6/x80", "LATIN SMALL LETTER B WITH PALATAL HOOK");
   ("/xe1/xb6/x81", "LATIN SMALL LETTER D WITH PALATAL HOOK");
   ("/xe1/xb6/x82", "LATIN SMALL LETTER F WITH PALATAL HOOK");
   ("/xe1/xb6/x83", "LATIN SMALL LETTER G WITH PALATAL HOOK");
   ("/xe1/xb6/x84", "LATIN SMALL LETTER K WITH PALATAL HOOK");
   ("/xe1/xb6/x85", "LATIN SMALL LETTER L WITH PALATAL HOOK");
   ("/xe1/xb6/x86", "LATIN SMALL LETTER M WITH PALATAL HOOK");
   ("/xe1/xb6/x87", "LATIN SMALL LETTER N WITH PALATAL HOOK");
   ("/xe1/xb6/x88", "LATIN SMALL LETTER P WITH PALATAL HOOK");
   ("/xe1/xb6/x89", "LATIN SMALL LETTER R WITH PALATAL HOOK");
   ("/xe1/xb6/x8a", "LATIN SMALL LETTER S WITH PALATAL HOOK");
   ("/xe1/xb6/x8b", "LATIN SMALL LETTER ESH WITH PALATAL HOOK");
   ("/xe1/xb6/x8c", "LATIN SMALL LETTER V WITH PALATAL HOOK");
   ("/xe1/xb6/x8d", "LATIN SMALL LETTER X WITH PALATAL HOOK");
   ("/xe1/xb6/x8e", "LATIN SMALL LETTER Z WITH PALATAL HOOK");
   ("/xe1/xb6/x8f", "LATIN SMALL LETTER A WITH RETROFLEX HOOK");
   ("/xe1/xb6/x90", "LATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK");
   ("/xe1/xb6/x91", "LATIN SMALL LETTER D WITH HOOK AND TAIL");
   ("/xe1/xb6/x92", "LATIN SMALL LETTER E WITH RETROFLEX HOOK");
   ("/xe1/xb6/x93", "LATIN SMALL LETTER OPEN E WITH RETROFLEX HOOK");
   ("/xe1/xb6/x94", "LATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOK");
   ("/xe1/xb6/x95", "LATIN SMALL LETTER SCHWA WITH RETROFLEX HOOK");
   ("/xe1/xb6/x96", "LATIN SMALL LETTER I WITH RETROFLEX HOOK");
   ("/xe1/xb6/x97", "LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK");
   ("/xe1/xb6/x98", "LATIN SMALL LETTER ESH WITH RETROFLEX HOOK");
   ("/xe1/xb6/x99", "LATIN SMALL LETTER U WITH RETROFLEX HOOK");
   ("/xe1/xb6/x9a", "LATIN SMALL LETTER EZH WITH RETROFLEX HOOK");
   ("/xe1/xb6/x9b", "MODIFIER LETTER SMALL TURNED ALPHA");
   ("/xe1/xb6/x9c", "MODIFIER LETTER SMALL C");
   ("/xe1/xb6/x9d", "MODIFIER LETTER SMALL C WITH CURL");
   ("/xe1/xb6/x9e", "MODIFIER LETTER SMALL ETH");
   ("/xe1/xb6/x9f", "MODIFIER LETTER SMALL REVERSED OPEN E");
   ("/xe1/xb6/xa0", "MODIFIER LETTER SMALL F");
   ("/xe1/xb6/xa1", "MODIFIER LETTER SMALL DOTLESS J WITH STROKE");
   ("/xe1/xb6/xa2", "MODIFIER LETTER SMALL SCRIPT G");
   ("/xe1/xb6/xa3", "MODIFIER LETTER SMALL TURNED H");
   ("/xe1/xb6/xa4", "MODIFIER LETTER SMALL I WITH STROKE");
   ("/xe1/xb6/xa5", "MODIFIER LETTER SMALL IOTA");
   ("/xe1/xb6/xa6", "MODIFIER LETTER SMALL CAPITAL I");
   ("/xe1/xb6/xa7", "MODIFIER LETTER SMALL CAPITAL I WITH STROKE");
   ("/xe1/xb6/xa8", "MODIFIER LETTER SMALL J WITH CROSSED-TAIL");
   ("/xe1/xb6/xa9", "MODIFIER LETTER SMALL L WITH RETROFLEX HOOK");
   ("/xe1/xb6/xaa", "MODIFIER LETTER SMALL L WITH PALATAL HOOK");
   ("/xe1/xb6/xab", "MODIFIER LETTER SMALL CAPITAL L");
   ("/xe1/xb6/xac", "MODIFIER LETTER SMALL M WITH HOOK");
   ("/xe1/xb6/xad", "MODIFIER LETTER SMALL TURNED M WITH LONG LEG");
   ("/xe1/xb6/xae", "MODIFIER LETTER SMALL N WITH LEFT HOOK");
   ("/xe1/xb6/xaf", "MODIFIER LETTER SMALL N WITH RETROFLEX HOOK");
   ("/xe1/xb6/xb0", "MODIFIER LETTER SMALL CAPITAL N");
   ("/xe1/xb6/xb1", "MODIFIER LETTER SMALL BARRED O");
   ("/xe1/xb6/xb2", "MODIFIER LETTER SMALL PHI");
   ("/xe1/xb6/xb3", "MODIFIER LETTER SMALL S WITH HOOK");
   ("/xe1/xb6/xb4", "MODIFIER LETTER SMALL ESH");
   ("/xe1/xb6/xb5", "MODIFIER LETTER SMALL T WITH PALATAL HOOK");
   ("/xe1/xb6/xb6", "MODIFIER LETTER SMALL U BAR");
   ("/xe1/xb6/xb7", "MODIFIER LETTER SMALL UPSILON");
   ("/xe1/xb6/xb8", "MODIFIER LETTER SMALL CAPITAL U");
   ("/xe1/xb6/xb9", "MODIFIER LETTER SMALL V WITH HOOK");
   ("/xe1/xb6/xba", "MODIFIER LETTER SMALL TURNED V");
   ("/xe1/xb6/xbb", "MODIFIER LETTER SMALL Z");
   ("/xe1/xb6/xbc", "MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK");
   ("/xe1/xb6/xbd", "MODIFIER LETTER SMALL Z WITH CURL");
   ("/xe1/xb6/xbe", "MODIFIER LETTER SMALL EZH");
   ("/xe1/xb6/xbf", "MODIFIER LETTER SMALL THETA");
   ("/xe1/xb7/x8a", "COMBINING LATIN SMALL LETTER R BELOW");
   ("/xe1/xb7/x93", "COMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVE");
   ("/xe1/xb7/x94", "COMBINING LATIN SMALL LETTER AE");
   ("/xe1/xb7/x95", "COMBINING LATIN SMALL LETTER AO");
   ("/xe1/xb7/x96", "COMBINING LATIN SMALL LETTER AV");
   ("/xe1/xb7/x97", "COMBINING LATIN SMALL LETTER C CEDILLA");
   ("/xe1/xb7/x98", "COMBINING LATIN SMALL LETTER INSULAR D");
   ("/xe1/xb7/x99", "COMBINING LATIN SMALL LETTER ETH");
   ("/xe1/xb7/x9a", "COMBINING LATIN SMALL LETTER G");
   ("/xe1/xb7/x9b", "COMBINING LATIN LETTER SMALL CAPITAL G");
   ("/xe1/xb7/x9c", "COMBINING LATIN SMALL LETTER K");
   ("/xe1/xb7/x9d", "COMBINING LATIN SMALL LETTER L");
   ("/xe1/xb7/x9e", "COMBINING LATIN LETTER SMALL CAPITAL L");
   ("/xe1/xb7/x9f", "COMBINING LATIN LETTER SMALL CAPITAL M");
   ("/xe1/xb7/xa0", "COMBINING LATIN SMALL LETTER N");
   ("/xe1/xb7/xa1", "COMBINING LATIN LETTER SMALL CAPITAL N");
   ("/xe1/xb7/xa2", "COMBINING LATIN LETTER SMALL CAPITAL R");
   ("/xe1/xb7/xa3", "COMBINING LATIN SMALL LETTER R ROTUNDA");
   ("/xe1/xb7/xa4", "COMBINING LATIN SMALL LETTER S");
   ("/xe1/xb7/xa5", "COMBINING LATIN SMALL LETTER LONG S");
   ("/xe1/xb7/xa6", "COMBINING LATIN SMALL LETTER Z");
   ("/xe1/xb8/x80", "LATIN CAPITAL LETTER A WITH RING BELOW");
   ("/xe1/xb8/x81", "LATIN SMALL LETTER A WITH RING BELOW");
   ("/xe1/xb8/x82", "LATIN CAPITAL LETTER B WITH DOT ABOVE");
   ("/xe1/xb8/x83", "LATIN SMALL LETTER B WITH DOT ABOVE");
   ("/xe1/xb8/x84", "LATIN CAPITAL LETTER B WITH DOT BELOW");
   ("/xe1/xb8/x85", "LATIN SMALL LETTER B WITH DOT BELOW");
   ("/xe1/xb8/x86", "LATIN CAPITAL LETTER B WITH LINE BELOW");
   ("/xe1/xb8/x87", "LATIN SMALL LETTER B WITH LINE BELOW");
   ("/xe1/xb8/x88", "LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE");
   ("/xe1/xb8/x89", "LATIN SMALL LETTER C WITH CEDILLA AND ACUTE");
   ("/xe1/xb8/x8a", "LATIN CAPITAL LETTER D WITH DOT ABOVE");
   ("/xe1/xb8/x8b", "LATIN SMALL LETTER D WITH DOT ABOVE");
   ("/xe1/xb8/x8c", "LATIN CAPITAL LETTER D WITH DOT BELOW");
   ("/xe1/xb8/x8d", "LATIN SMALL LETTER D WITH DOT BELOW");
   ("/xe1/xb8/x8e", "LATIN CAPITAL LETTER D WITH LINE BELOW");
   ("/xe1/xb8/x8f", "LATIN SMALL LETTER D WITH LINE BELOW");
   ("/xe1/xb8/x90", "LATIN CAPITAL LETTER D WITH CEDILLA");
   ("/xe1/xb8/x91", "LATIN SMALL LETTER D WITH CEDILLA");
   ("/xe1/xb8/x92", "LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW");
   ("/xe1/xb8/x93", "LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW");
   ("/xe1/xb8/x94", "LATIN CAPITAL LETTER E WITH MACRON AND GRAVE");
   ("/xe1/xb8/x95", "LATIN SMALL LETTER E WITH MACRON AND GRAVE");
   ("/xe1/xb8/x96", "LATIN CAPITAL LETTER E WITH MACRON AND ACUTE");
   ("/xe1/xb8/x97", "LATIN SMALL LETTER E WITH MACRON AND ACUTE");
   ("/xe1/xb8/x98", "LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW");
   ("/xe1/xb8/x99", "LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW");
   ("/xe1/xb8/x9a", "LATIN CAPITAL LETTER E WITH TILDE BELOW");
   ("/xe1/xb8/x9b", "LATIN SMALL LETTER E WITH TILDE BELOW");
   ("/xe1/xb8/x9c", "LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE");
   ("/xe1/xb8/x9d", "LATIN SMALL LETTER E WITH CEDILLA AND BREVE");
   ("/xe1/xb8/x9e", "LATIN CAPITAL LETTER F WITH DOT ABOVE");
   ("/xe1/xb8/x9f", "LATIN SMALL LETTER F WITH DOT ABOVE");
   ("/xe1/xb8/xa0", "LATIN CAPITAL LETTER G WITH MACRON");
   ("/xe1/xb8/xa1", "LATIN SMALL LETTER G WITH MACRON");
   ("/xe1/xb8/xa2", "LATIN CAPITAL LETTER H WITH DOT ABOVE");
   ("/xe1/xb8/xa3", "LATIN SMALL LETTER H WITH DOT ABOVE");
   ("/xe1/xb8/xa4", "LATIN CAPITAL LETTER H WITH DOT BELOW");
   ("/xe1/xb8/xa5", "LATIN SMALL LETTER H WITH DOT BELOW");
   ("/xe1/xb8/xa6", "LATIN CAPITAL LETTER H WITH DIAERESIS");
   ("/xe1/xb8/xa7", "LATIN SMALL LETTER H WITH DIAERESIS");
   ("/xe1/xb8/xa8", "LATIN CAPITAL LETTER H WITH CEDILLA");
   ("/xe1/xb8/xa9", "LATIN SMALL LETTER H WITH CEDILLA");
   ("/xe1/xb8/xaa", "LATIN CAPITAL LETTER H WITH BREVE BELOW");
   ("/xe1/xb8/xab", "LATIN SMALL LETTER H WITH BREVE BELOW");
   ("/xe1/xb8/xac", "LATIN CAPITAL LETTER I WITH TILDE BELOW");
   ("/xe1/xb8/xad", "LATIN SMALL LETTER I WITH TILDE BELOW");
   ("/xe1/xb8/xae", "LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE");
   ("/xe1/xb8/xaf", "LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE");
   ("/xe1/xb8/xb0", "LATIN CAPITAL LETTER K WITH ACUTE");
   ("/xe1/xb8/xb1", "LATIN SMALL LETTER K WITH ACUTE");
   ("/xe1/xb8/xb2", "LATIN CAPITAL LETTER K WITH DOT BELOW");
   ("/xe1/xb8/xb3", "LATIN SMALL LETTER K WITH DOT BELOW");
   ("/xe1/xb8/xb4", "LATIN CAPITAL LETTER K WITH LINE BELOW");
   ("/xe1/xb8/xb5", "LATIN SMALL LETTER K WITH LINE BELOW");
   ("/xe1/xb8/xb6", "LATIN CAPITAL LETTER L WITH DOT BELOW");
   ("/xe1/xb8/xb7", "LATIN SMALL LETTER L WITH DOT BELOW");
   ("/xe1/xb8/xb8", "LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON");
   ("/xe1/xb8/xb9", "LATIN SMALL LETTER L WITH DOT BELOW AND MACRON");
   ("/xe1/xb8/xba", "LATIN CAPITAL LETTER L WITH LINE BELOW");
   ("/xe1/xb8/xbb", "LATIN SMALL LETTER L WITH LINE BELOW");
   ("/xe1/xb8/xbc", "LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW");
   ("/xe1/xb8/xbd", "LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW");
   ("/xe1/xb8/xbe", "LATIN CAPITAL LETTER M WITH ACUTE");
   ("/xe1/xb8/xbf", "LATIN SMALL LETTER M WITH ACUTE");
   ("/xe1/xb9/x80", "LATIN CAPITAL LETTER M WITH DOT ABOVE");
   ("/xe1/xb9/x81", "LATIN SMALL LETTER M WITH DOT ABOVE");
   ("/xe1/xb9/x82", "LATIN CAPITAL LETTER M WITH DOT BELOW");
   ("/xe1/xb9/x83", "LATIN SMALL LETTER M WITH DOT BELOW");
   ("/xe1/xb9/x84", "LATIN CAPITAL LETTER N WITH DOT ABOVE");
   ("/xe1/xb9/x85", "LATIN SMALL LETTER N WITH DOT ABOVE");
   ("/xe1/xb9/x86", "LATIN CAPITAL LETTER N WITH DOT BELOW");
   ("/xe1/xb9/x87", "LATIN SMALL LETTER N WITH DOT BELOW");
   ("/xe1/xb9/x88", "LATIN CAPITAL LETTER N WITH LINE BELOW");
   ("/xe1/xb9/x89", "LATIN SMALL LETTER N WITH LINE BELOW");
   ("/xe1/xb9/x8a", "LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW");
   ("/xe1/xb9/x8b", "LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW");
   ("/xe1/xb9/x8c", "LATIN CAPITAL LETTER O WITH TILDE AND ACUTE");
   ("/xe1/xb9/x8d", "LATIN SMALL LETTER O WITH TILDE AND ACUTE");
   ("/xe1/xb9/x8e", "LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS");
   ("/xe1/xb9/x8f", "LATIN SMALL LETTER O WITH TILDE AND DIAERESIS");
   ("/xe1/xb9/x90", "LATIN CAPITAL LETTER O WITH MACRON AND GRAVE");
   ("/xe1/xb9/x91", "LATIN SMALL LETTER O WITH MACRON AND GRAVE");
   ("/xe1/xb9/x92", "LATIN CAPITAL LETTER O WITH MACRON AND ACUTE");
   ("/xe1/xb9/x93", "LATIN SMALL LETTER O WITH MACRON AND ACUTE");
   ("/xe1/xb9/x94", "LATIN CAPITAL LETTER P WITH ACUTE");
   ("/xe1/xb9/x95", "LATIN SMALL LETTER P WITH ACUTE");
   ("/xe1/xb9/x96", "LATIN CAPITAL LETTER P WITH DOT ABOVE");
   ("/xe1/xb9/x97", "LATIN SMALL LETTER P WITH DOT ABOVE");
   ("/xe1/xb9/x98", "LATIN CAPITAL LETTER R WITH DOT ABOVE");
   ("/xe1/xb9/x99", "LATIN SMALL LETTER R WITH DOT ABOVE");
   ("/xe1/xb9/x9a", "LATIN CAPITAL LETTER R WITH DOT BELOW");
   ("/xe1/xb9/x9b", "LATIN SMALL LETTER R WITH DOT BELOW");
   ("/xe1/xb9/x9c", "LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON");
   ("/xe1/xb9/x9d", "LATIN SMALL LETTER R WITH DOT BELOW AND MACRON");
   ("/xe1/xb9/x9e", "LATIN CAPITAL LETTER R WITH LINE BELOW");
   ("/xe1/xb9/x9f", "LATIN SMALL LETTER R WITH LINE BELOW");
   ("/xe1/xb9/xa0", "LATIN CAPITAL LETTER S WITH DOT ABOVE");
   ("/xe1/xb9/xa1", "LATIN SMALL LETTER S WITH DOT ABOVE");
   ("/xe1/xb9/xa2", "LATIN CAPITAL LETTER S WITH DOT BELOW");
   ("/xe1/xb9/xa3", "LATIN SMALL LETTER S WITH DOT BELOW");
   ("/xe1/xb9/xa4", "LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE");
   ("/xe1/xb9/xa5", "LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE");
   ("/xe1/xb9/xa6", "LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE");
   ("/xe1/xb9/xa7", "LATIN SMALL LETTER S WITH CARON AND DOT ABOVE");
   ("/xe1/xb9/xa8", "LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE");
   ("/xe1/xb9/xa9", "LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE");
   ("/xe1/xb9/xaa", "LATIN CAPITAL LETTER T WITH DOT ABOVE");
   ("/xe1/xb9/xab", "LATIN SMALL LETTER T WITH DOT ABOVE");
   ("/xe1/xb9/xac", "LATIN CAPITAL LETTER T WITH DOT BELOW");
   ("/xe1/xb9/xad", "LATIN SMALL LETTER T WITH DOT BELOW");
   ("/xe1/xb9/xae", "LATIN CAPITAL LETTER T WITH LINE BELOW");
   ("/xe1/xb9/xaf", "LATIN SMALL LETTER T WITH LINE BELOW");
   ("/xe1/xb9/xb0", "LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW");
   ("/xe1/xb9/xb1", "LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW");
   ("/xe1/xb9/xb2", "LATIN CAPITAL LETTER U WITH DIAERESIS BELOW");
   ("/xe1/xb9/xb3", "LATIN SMALL LETTER U WITH DIAERESIS BELOW");
   ("/xe1/xb9/xb4", "LATIN CAPITAL LETTER U WITH TILDE BELOW");
   ("/xe1/xb9/xb5", "LATIN SMALL LETTER U WITH TILDE BELOW");
   ("/xe1/xb9/xb6", "LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW");
   ("/xe1/xb9/xb7", "LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW");
   ("/xe1/xb9/xb8", "LATIN CAPITAL LETTER U WITH TILDE AND ACUTE");
   ("/xe1/xb9/xb9", "LATIN SMALL LETTER U WITH TILDE AND ACUTE");
   ("/xe1/xb9/xba", "LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS");
   ("/xe1/xb9/xbb", "LATIN SMALL LETTER U WITH MACRON AND DIAERESIS");
   ("/xe1/xb9/xbc", "LATIN CAPITAL LETTER V WITH TILDE");
   ("/xe1/xb9/xbd", "LATIN SMALL LETTER V WITH TILDE");
   ("/xe1/xb9/xbe", "LATIN CAPITAL LETTER V WITH DOT BELOW");
   ("/xe1/xb9/xbf", "LATIN SMALL LETTER V WITH DOT BELOW");
   ("/xe1/xba/x80", "LATIN CAPITAL LETTER W WITH GRAVE");
   ("/xe1/xba/x81", "LATIN SMALL LETTER W WITH GRAVE");
   ("/xe1/xba/x82", "LATIN CAPITAL LETTER W WITH ACUTE");
   ("/xe1/xba/x83", "LATIN SMALL LETTER W WITH ACUTE");
   ("/xe1/xba/x84", "LATIN CAPITAL LETTER W WITH DIAERESIS");
   ("/xe1/xba/x85", "LATIN SMALL LETTER W WITH DIAERESIS");
   ("/xe1/xba/x86", "LATIN CAPITAL LETTER W WITH DOT ABOVE");
   ("/xe1/xba/x87", "LATIN SMALL LETTER W WITH DOT ABOVE");
   ("/xe1/xba/x88", "LATIN CAPITAL LETTER W WITH DOT BELOW");
   ("/xe1/xba/x89", "LATIN SMALL LETTER W WITH DOT BELOW");
   ("/xe1/xba/x8a", "LATIN CAPITAL LETTER X WITH DOT ABOVE");
   ("/xe1/xba/x8b", "LATIN SMALL LETTER X WITH DOT ABOVE");
   ("/xe1/xba/x8c", "LATIN CAPITAL LETTER X WITH DIAERESIS");
   ("/xe1/xba/x8d", "LATIN SMALL LETTER X WITH DIAERESIS");
   ("/xe1/xba/x8e", "LATIN CAPITAL LETTER Y WITH DOT ABOVE");
   ("/xe1/xba/x8f", "LATIN SMALL LETTER Y WITH DOT ABOVE");
   ("/xe1/xba/x90", "LATIN CAPITAL LETTER Z WITH CIRCUMFLEX");
   ("/xe1/xba/x91", "LATIN SMALL LETTER Z WITH CIRCUMFLEX");
   ("/xe1/xba/x92", "LATIN CAPITAL LETTER Z WITH DOT BELOW");
   ("/xe1/xba/x93", "LATIN SMALL LETTER Z WITH DOT BELOW");
   ("/xe1/xba/x94", "LATIN CAPITAL LETTER Z WITH LINE BELOW");
   ("/xe1/xba/x95", "LATIN SMALL LETTER Z WITH LINE BELOW");
   ("/xe1/xba/x96", "LATIN SMALL LETTER H WITH LINE BELOW");
   ("/xe1/xba/x97", "LATIN SMALL LETTER T WITH DIAERESIS");
   ("/xe1/xba/x98", "LATIN SMALL LETTER W WITH RING ABOVE");
   ("/xe1/xba/x99", "LATIN SMALL LETTER Y WITH RING ABOVE");
   ("/xe1/xba/x9a", "LATIN SMALL LETTER A WITH RIGHT HALF RING");
   ("/xe1/xba/x9b", "LATIN SMALL LETTER LONG S WITH DOT ABOVE");
   ("/xe1/xba/x9c", "LATIN SMALL LETTER LONG S WITH DIAGONAL STROKE");
   ("/xe1/xba/x9d", "LATIN SMALL LETTER LONG S WITH HIGH STROKE");
   ("/xe1/xba/x9e", "LATIN CAPITAL LETTER SHARP S");
   ("/xe1/xba/x9f", "LATIN SMALL LETTER DELTA");
   ("/xe1/xba/xa0", "LATIN CAPITAL LETTER A WITH DOT BELOW");
   ("/xe1/xba/xa1", "LATIN SMALL LETTER A WITH DOT BELOW");
   ("/xe1/xba/xa2", "LATIN CAPITAL LETTER A WITH HOOK ABOVE");
   ("/xe1/xba/xa3", "LATIN SMALL LETTER A WITH HOOK ABOVE");
   ("/xe1/xba/xa4", "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE");
   ("/xe1/xba/xa5", "LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE");
   ("/xe1/xba/xa6", "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE");
   ("/xe1/xba/xa7", "LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE");
   ("/xe1/xba/xa8", "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE");
   ("/xe1/xba/xa9", "LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE");
   ("/xe1/xba/xaa", "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE");
   ("/xe1/xba/xab", "LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE");
   ("/xe1/xba/xac", "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW");
   ("/xe1/xba/xad", "LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW");
   ("/xe1/xba/xae", "LATIN CAPITAL LETTER A WITH BREVE AND ACUTE");
   ("/xe1/xba/xaf", "LATIN SMALL LETTER A WITH BREVE AND ACUTE");
   ("/xe1/xba/xb0", "LATIN CAPITAL LETTER A WITH BREVE AND GRAVE");
   ("/xe1/xba/xb1", "LATIN SMALL LETTER A WITH BREVE AND GRAVE");
   ("/xe1/xba/xb2", "LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE");
   ("/xe1/xba/xb3", "LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE");
   ("/xe1/xba/xb4", "LATIN CAPITAL LETTER A WITH BREVE AND TILDE");
   ("/xe1/xba/xb5", "LATIN SMALL LETTER A WITH BREVE AND TILDE");
   ("/xe1/xba/xb6", "LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW");
   ("/xe1/xba/xb7", "LATIN SMALL LETTER A WITH BREVE AND DOT BELOW");
   ("/xe1/xba/xb8", "LATIN CAPITAL LETTER E WITH DOT BELOW");
   ("/xe1/xba/xb9", "LATIN SMALL LETTER E WITH DOT BELOW");
   ("/xe1/xba/xba", "LATIN CAPITAL LETTER E WITH HOOK ABOVE");
   ("/xe1/xba/xbb", "LATIN SMALL LETTER E WITH HOOK ABOVE");
   ("/xe1/xba/xbc", "LATIN CAPITAL LETTER E WITH TILDE");
   ("/xe1/xba/xbd", "LATIN SMALL LETTER E WITH TILDE");
   ("/xe1/xba/xbe", "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE");
   ("/xe1/xba/xbf", "LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE");
   ("/xe1/xbb/x80", "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE");
   ("/xe1/xbb/x81", "LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE");
   ("/xe1/xbb/x82", "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE");
   ("/xe1/xbb/x83", "LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE");
   ("/xe1/xbb/x84", "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE");
   ("/xe1/xbb/x85", "LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE");
   ("/xe1/xbb/x86", "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW");
   ("/xe1/xbb/x87", "LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW");
   ("/xe1/xbb/x88", "LATIN CAPITAL LETTER I WITH HOOK ABOVE");
   ("/xe1/xbb/x89", "LATIN SMALL LETTER I WITH HOOK ABOVE");
   ("/xe1/xbb/x8a", "LATIN CAPITAL LETTER I WITH DOT BELOW");
   ("/xe1/xbb/x8b", "LATIN SMALL LETTER I WITH DOT BELOW");
   ("/xe1/xbb/x8c", "LATIN CAPITAL LETTER O WITH DOT BELOW");
   ("/xe1/xbb/x8d", "LATIN SMALL LETTER O WITH DOT BELOW");
   ("/xe1/xbb/x8e", "LATIN CAPITAL LETTER O WITH HOOK ABOVE");
   ("/xe1/xbb/x8f", "LATIN SMALL LETTER O WITH HOOK ABOVE");
   ("/xe1/xbb/x90", "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE");
   ("/xe1/xbb/x91", "LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE");
   ("/xe1/xbb/x92", "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE");
   ("/xe1/xbb/x93", "LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE");
   ("/xe1/xbb/x94", "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE");
   ("/xe1/xbb/x95", "LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE");
   ("/xe1/xbb/x96", "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE");
   ("/xe1/xbb/x97", "LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE");
   ("/xe1/xbb/x98", "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW");
   ("/xe1/xbb/x99", "LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW");
   ("/xe1/xbb/x9a", "LATIN CAPITAL LETTER O WITH HORN AND ACUTE");
   ("/xe1/xbb/x9b", "LATIN SMALL LETTER O WITH HORN AND ACUTE");
   ("/xe1/xbb/x9c", "LATIN CAPITAL LETTER O WITH HORN AND GRAVE");
   ("/xe1/xbb/x9d", "LATIN SMALL LETTER O WITH HORN AND GRAVE");
   ("/xe1/xbb/x9e", "LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE");
   ("/xe1/xbb/x9f", "LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE");
   ("/xe1/xbb/xa0", "LATIN CAPITAL LETTER O WITH HORN AND TILDE");
   ("/xe1/xbb/xa1", "LATIN SMALL LETTER O WITH HORN AND TILDE");
   ("/xe1/xbb/xa2", "LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW");
   ("/xe1/xbb/xa3", "LATIN SMALL LETTER O WITH HORN AND DOT BELOW");
   ("/xe1/xbb/xa4", "LATIN CAPITAL LETTER U WITH DOT BELOW");
   ("/xe1/xbb/xa5", "LATIN SMALL LETTER U WITH DOT BELOW");
   ("/xe1/xbb/xa6", "LATIN CAPITAL LETTER U WITH HOOK ABOVE");
   ("/xe1/xbb/xa7", "LATIN SMALL LETTER U WITH HOOK ABOVE");
   ("/xe1/xbb/xa8", "LATIN CAPITAL LETTER U WITH HORN AND ACUTE");
   ("/xe1/xbb/xa9", "LATIN SMALL LETTER U WITH HORN AND ACUTE");
   ("/xe1/xbb/xaa", "LATIN CAPITAL LETTER U WITH HORN AND GRAVE");
   ("/xe1/xbb/xab", "LATIN SMALL LETTER U WITH HORN AND GRAVE");
   ("/xe1/xbb/xac", "LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE");
   ("/xe1/xbb/xad", "LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE");
   ("/xe1/xbb/xae", "LATIN CAPITAL LETTER U WITH HORN AND TILDE");
   ("/xe1/xbb/xaf", "LATIN SMALL LETTER U WITH HORN AND TILDE");
   ("/xe1/xbb/xb0", "LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW");
   ("/xe1/xbb/xb1", "LATIN SMALL LETTER U WITH HORN AND DOT BELOW");
   ("/xe1/xbb/xb2", "LATIN CAPITAL LETTER Y WITH GRAVE");
   ("/xe1/xbb/xb3", "LATIN SMALL LETTER Y WITH GRAVE");
   ("/xe1/xbb/xb4", "LATIN CAPITAL LETTER Y WITH DOT BELOW");
   ("/xe1/xbb/xb5", "LATIN SMALL LETTER Y WITH DOT BELOW");
   ("/xe1/xbb/xb6", "LATIN CAPITAL LETTER Y WITH HOOK ABOVE");
   ("/xe1/xbb/xb7", "LATIN SMALL LETTER Y WITH HOOK ABOVE");
   ("/xe1/xbb/xb8", "LATIN CAPITAL LETTER Y WITH TILDE");
   ("/xe1/xbb/xb9", "LATIN SMALL LETTER Y WITH TILDE");
   ("/xe1/xbb/xba", "LATIN CAPITAL LETTER MIDDLE-WELSH LL");
   ("/xe1/xbb/xbb", "LATIN SMALL LETTER MIDDLE-WELSH LL");
   ("/xe1/xbb/xbc", "LATIN CAPITAL LETTER MIDDLE-WELSH V");
   ("/xe1/xbb/xbd", "LATIN SMALL LETTER MIDDLE-WELSH V");
   ("/xe1/xbb/xbe", "LATIN CAPITAL LETTER Y WITH LOOP");
   ("/xe1/xbb/xbf", "LATIN SMALL LETTER Y WITH LOOP");
   ("/xe1/xbc/x80", "GREEK SMALL LETTER ALPHA WITH PSILI");
   ("/xe1/xbc/x81", "GREEK SMALL LETTER ALPHA WITH DASIA");
   ("/xe1/xbc/x82", "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA");
   ("/xe1/xbc/x83", "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA");
   ("/xe1/xbc/x84", "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA");
   ("/xe1/xbc/x85", "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA");
   ("/xe1/xbc/x86", "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI");
   ("/xe1/xbc/x87", "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI");
   ("/xe1/xbc/x88", "GREEK CAPITAL LETTER ALPHA WITH PSILI");
   ("/xe1/xbc/x89", "GREEK CAPITAL LETTER ALPHA WITH DASIA");
   ("/xe1/xbc/x8a", "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA");
   ("/xe1/xbc/x8b", "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA");
   ("/xe1/xbc/x8c", "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA");
   ("/xe1/xbc/x8d", "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA");
   ("/xe1/xbc/x8e", "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI");
   ("/xe1/xbc/x8f", "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI");
   ("/xe1/xbc/x90", "GREEK SMALL LETTER EPSILON WITH PSILI");
   ("/xe1/xbc/x91", "GREEK SMALL LETTER EPSILON WITH DASIA");
   ("/xe1/xbc/x92", "GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA");
   ("/xe1/xbc/x93", "GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA");
   ("/xe1/xbc/x94", "GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA");
   ("/xe1/xbc/x95", "GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA");
   ("/xe1/xbc/x98", "GREEK CAPITAL LETTER EPSILON WITH PSILI");
   ("/xe1/xbc/x99", "GREEK CAPITAL LETTER EPSILON WITH DASIA");
   ("/xe1/xbc/x9a", "GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA");
   ("/xe1/xbc/x9b", "GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA");
   ("/xe1/xbc/x9c", "GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA");
   ("/xe1/xbc/x9d", "GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA");
   ("/xe1/xbc/xa0", "GREEK SMALL LETTER ETA WITH PSILI");
   ("/xe1/xbc/xa1", "GREEK SMALL LETTER ETA WITH DASIA");
   ("/xe1/xbc/xa2", "GREEK SMALL LETTER ETA WITH PSILI AND VARIA");
   ("/xe1/xbc/xa3", "GREEK SMALL LETTER ETA WITH DASIA AND VARIA");
   ("/xe1/xbc/xa4", "GREEK SMALL LETTER ETA WITH PSILI AND OXIA");
   ("/xe1/xbc/xa5", "GREEK SMALL LETTER ETA WITH DASIA AND OXIA");
   ("/xe1/xbc/xa6", "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI");
   ("/xe1/xbc/xa7", "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI");
   ("/xe1/xbc/xa8", "GREEK CAPITAL LETTER ETA WITH PSILI");
   ("/xe1/xbc/xa9", "GREEK CAPITAL LETTER ETA WITH DASIA");
   ("/xe1/xbc/xaa", "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA");
   ("/xe1/xbc/xab", "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA");
   ("/xe1/xbc/xac", "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA");
   ("/xe1/xbc/xad", "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA");
   ("/xe1/xbc/xae", "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI");
   ("/xe1/xbc/xaf", "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI");
   ("/xe1/xbc/xb0", "GREEK SMALL LETTER IOTA WITH PSILI");
   ("/xe1/xbc/xb1", "GREEK SMALL LETTER IOTA WITH DASIA");
   ("/xe1/xbc/xb2", "GREEK SMALL LETTER IOTA WITH PSILI AND VARIA");
   ("/xe1/xbc/xb3", "GREEK SMALL LETTER IOTA WITH DASIA AND VARIA");
   ("/xe1/xbc/xb4", "GREEK SMALL LETTER IOTA WITH PSILI AND OXIA");
   ("/xe1/xbc/xb5", "GREEK SMALL LETTER IOTA WITH DASIA AND OXIA");
   ("/xe1/xbc/xb6", "GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI");
   ("/xe1/xbc/xb7", "GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI");
   ("/xe1/xbc/xb8", "GREEK CAPITAL LETTER IOTA WITH PSILI");
   ("/xe1/xbc/xb9", "GREEK CAPITAL LETTER IOTA WITH DASIA");
   ("/xe1/xbc/xba", "GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA");
   ("/xe1/xbc/xbb", "GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA");
   ("/xe1/xbc/xbc", "GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA");
   ("/xe1/xbc/xbd", "GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA");
   ("/xe1/xbc/xbe", "GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI");
   ("/xe1/xbc/xbf", "GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI");
   ("/xe1/xbd/x80", "GREEK SMALL LETTER OMICRON WITH PSILI");
   ("/xe1/xbd/x81", "GREEK SMALL LETTER OMICRON WITH DASIA");
   ("/xe1/xbd/x82", "GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA");
   ("/xe1/xbd/x83", "GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA");
   ("/xe1/xbd/x84", "GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA");
   ("/xe1/xbd/x85", "GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA");
   ("/xe1/xbd/x88", "GREEK CAPITAL LETTER OMICRON WITH PSILI");
   ("/xe1/xbd/x89", "GREEK CAPITAL LETTER OMICRON WITH DASIA");
   ("/xe1/xbd/x8a", "GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA");
   ("/xe1/xbd/x8b", "GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA");
   ("/xe1/xbd/x8c", "GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA");
   ("/xe1/xbd/x8d", "GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA");
   ("/xe1/xbd/x90", "GREEK SMALL LETTER UPSILON WITH PSILI");
   ("/xe1/xbd/x91", "GREEK SMALL LETTER UPSILON WITH DASIA");
   ("/xe1/xbd/x92", "GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA");
   ("/xe1/xbd/x93", "GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA");
   ("/xe1/xbd/x94", "GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA");
   ("/xe1/xbd/x95", "GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA");
   ("/xe1/xbd/x96", "GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI");
   ("/xe1/xbd/x97", "GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI");
   ("/xe1/xbd/x99", "GREEK CAPITAL LETTER UPSILON WITH DASIA");
   ("/xe1/xbd/x9b", "GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA");
   ("/xe1/xbd/x9d", "GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA");
   ("/xe1/xbd/x9f", "GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI");
   ("/xe1/xbd/xa0", "GREEK SMALL LETTER OMEGA WITH PSILI");
   ("/xe1/xbd/xa1", "GREEK SMALL LETTER OMEGA WITH DASIA");
   ("/xe1/xbd/xa2", "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA");
   ("/xe1/xbd/xa3", "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA");
   ("/xe1/xbd/xa4", "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA");
   ("/xe1/xbd/xa5", "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA");
   ("/xe1/xbd/xa6", "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI");
   ("/xe1/xbd/xa7", "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI");
   ("/xe1/xbd/xa8", "GREEK CAPITAL LETTER OMEGA WITH PSILI");
   ("/xe1/xbd/xa9", "GREEK CAPITAL LETTER OMEGA WITH DASIA");
   ("/xe1/xbd/xaa", "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA");
   ("/xe1/xbd/xab", "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA");
   ("/xe1/xbd/xac", "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA");
   ("/xe1/xbd/xad", "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA");
   ("/xe1/xbd/xae", "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI");
   ("/xe1/xbd/xaf", "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI");
   ("/xe1/xbd/xb0", "GREEK SMALL LETTER ALPHA WITH VARIA");
   ("/xe1/xbd/xb1", "GREEK SMALL LETTER ALPHA WITH OXIA");
   ("/xe1/xbd/xb2", "GREEK SMALL LETTER EPSILON WITH VARIA");
   ("/xe1/xbd/xb3", "GREEK SMALL LETTER EPSILON WITH OXIA");
   ("/xe1/xbd/xb4", "GREEK SMALL LETTER ETA WITH VARIA");
   ("/xe1/xbd/xb5", "GREEK SMALL LETTER ETA WITH OXIA");
   ("/xe1/xbd/xb6", "GREEK SMALL LETTER IOTA WITH VARIA");
   ("/xe1/xbd/xb7", "GREEK SMALL LETTER IOTA WITH OXIA");
   ("/xe1/xbd/xb8", "GREEK SMALL LETTER OMICRON WITH VARIA");
   ("/xe1/xbd/xb9", "GREEK SMALL LETTER OMICRON WITH OXIA");
   ("/xe1/xbd/xba", "GREEK SMALL LETTER UPSILON WITH VARIA");
   ("/xe1/xbd/xbb", "GREEK SMALL LETTER UPSILON WITH OXIA");
   ("/xe1/xbd/xbc", "GREEK SMALL LETTER OMEGA WITH VARIA");
   ("/xe1/xbd/xbd", "GREEK SMALL LETTER OMEGA WITH OXIA");
   ("/xe1/xbe/x80", "GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI");
   ("/xe1/xbe/x81", "GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/x82", "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/x83", "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/x84", "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/x85", "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/x86", "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI");
   ("/xe1/xbe/x87", "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI");
   ("/xe1/xbe/x88", "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI");
   ("/xe1/xbe/x89", "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/x8a", "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/x8b", "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/x8c", "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/x8d", "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/x8e", "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI");
   ("/xe1/xbe/x8f", "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI");
   ("/xe1/xbe/x90", "GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI");
   ("/xe1/xbe/x91", "GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/x92", "GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/x93", "GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/x94", "GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/x95", "GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/x96", "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI");
   ("/xe1/xbe/x97", "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI");
   ("/xe1/xbe/x98", "GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI");
   ("/xe1/xbe/x99", "GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/x9a", "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/x9b", "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/x9c", "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/x9d", "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/x9e", "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI");
   ("/xe1/xbe/x9f", "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI");
   ("/xe1/xbe/xa0", "GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI");
   ("/xe1/xbe/xa1", "GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/xa2", "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/xa3", "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/xa4", "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/xa5", "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/xa6", "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI");
   ("/xe1/xbe/xa7", "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI");
   ("/xe1/xbe/xa8", "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI");
   ("/xe1/xbe/xa9", "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/xaa", "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/xab", "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/xac", "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/xad", "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI");
   ("/xe1/xbe/xae", "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI");
   ("/xe1/xbe/xaf", "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI");
   ("/xe1/xbe/xb0", "GREEK SMALL LETTER ALPHA WITH VRACHY");
   ("/xe1/xbe/xb1", "GREEK SMALL LETTER ALPHA WITH MACRON");
   ("/xe1/xbe/xb2", "GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/xb3", "GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI");
   ("/xe1/xbe/xb4", "GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI");
   ("/xe1/xbe/xb6", "GREEK SMALL LETTER ALPHA WITH PERISPOMENI");
   ("/xe1/xbe/xb7", "GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI");
   ("/xe1/xbe/xb8", "GREEK CAPITAL LETTER ALPHA WITH VRACHY");
   ("/xe1/xbe/xb9", "GREEK CAPITAL LETTER ALPHA WITH MACRON");
   ("/xe1/xbe/xba", "GREEK CAPITAL LETTER ALPHA WITH VARIA");
   ("/xe1/xbe/xbb", "GREEK CAPITAL LETTER ALPHA WITH OXIA");
   ("/xe1/xbe/xbc", "GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI");
   ("/xe1/xbf/x82", "GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI");
   ("/xe1/xbf/x83", "GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI");
   ("/xe1/xbf/x84", "GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI");
   ("/xe1/xbf/x86", "GREEK SMALL LETTER ETA WITH PERISPOMENI");
   ("/xe1/xbf/x87", "GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI");
   ("/xe1/xbf/x88", "GREEK CAPITAL LETTER EPSILON WITH VARIA");
   ("/xe1/xbf/x89", "GREEK CAPITAL LETTER EPSILON WITH OXIA");
   ("/xe1/xbf/x8a", "GREEK CAPITAL LETTER ETA WITH VARIA");
   ("/xe1/xbf/x8b", "GREEK CAPITAL LETTER ETA WITH OXIA");
   ("/xe1/xbf/x8c", "GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI");
   ("/xe1/xbf/x90", "GREEK SMALL LETTER IOTA WITH VRACHY");
   ("/xe1/xbf/x91", "GREEK SMALL LETTER IOTA WITH MACRON");
   ("/xe1/xbf/x92", "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA");
   ("/xe1/xbf/x93", "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA");
   ("/xe1/xbf/x96", "GREEK SMALL LETTER IOTA WITH PERISPOMENI");
   ("/xe1/xbf/x97", "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI");
   ("/xe1/xbf/x98", "GREEK CAPITAL LETTER IOTA WITH VRACHY");
   ("/xe1/xbf/x99", "GREEK CAPITAL LETTER IOTA WITH MACRON");
   ("/xe1/xbf/x9a", "GREEK CAPITAL LETTER IOTA WITH VARIA");
   ("/xe1/xbf/x9b", "GREEK CAPITAL LETTER IOTA WITH OXIA");
   ("/xe1/xbf/xa0", "GREEK SMALL LETTER UPSILON WITH VRACHY");
   ("/xe1/xbf/xa1", "GREEK SMALL LETTER UPSILON WITH MACRON");
   ("/xe1/xbf/xa2", "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA");
   ("/xe1/xbf/xa3", "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA");
   ("/xe1/xbf/xa4", "GREEK SMALL LETTER RHO WITH PSILI");
   ("/xe1/xbf/xa5", "GREEK SMALL LETTER RHO WITH DASIA");
   ("/xe1/xbf/xa6", "GREEK SMALL LETTER UPSILON WITH PERISPOMENI");
   ("/xe1/xbf/xa7", "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI");
   ("/xe1/xbf/xa8", "GREEK CAPITAL LETTER UPSILON WITH VRACHY");
   ("/xe1/xbf/xa9", "GREEK CAPITAL LETTER UPSILON WITH MACRON");
   ("/xe1/xbf/xaa", "GREEK CAPITAL LETTER UPSILON WITH VARIA");
   ("/xe1/xbf/xab", "GREEK CAPITAL LETTER UPSILON WITH OXIA");
   ("/xe1/xbf/xac", "GREEK CAPITAL LETTER RHO WITH DASIA");
   ("/xe1/xbf/xb2", "GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI");
   ("/xe1/xbf/xb3", "GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI");
   ("/xe1/xbf/xb4", "GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI");
   ("/xe1/xbf/xb6", "GREEK SMALL LETTER OMEGA WITH PERISPOMENI");
   ("/xe1/xbf/xb7", "GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI");
   ("/xe1/xbf/xb8", "GREEK CAPITAL LETTER OMICRON WITH VARIA");
   ("/xe1/xbf/xb9", "GREEK CAPITAL LETTER OMICRON WITH OXIA");
   ("/xe1/xbf/xba", "GREEK CAPITAL LETTER OMEGA WITH VARIA");
   ("/xe1/xbf/xbb", "GREEK CAPITAL LETTER OMEGA WITH OXIA");
   ("/xe1/xbf/xbc", "GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI");
   ("/xe2/x81/xb1", "SUPERSCRIPT LATIN SMALL LETTER I");
   ("/xe2/x81/xbf", "SUPERSCRIPT LATIN SMALL LETTER N");
   ("/xe2/x82/x90", "LATIN SUBSCRIPT SMALL LETTER A");
   ("/xe2/x82/x91", "LATIN SUBSCRIPT SMALL LETTER E");
   ("/xe2/x82/x92", "LATIN SUBSCRIPT SMALL LETTER O");
   ("/xe2/x82/x93", "LATIN SUBSCRIPT SMALL LETTER X");
   ("/xe2/x82/x94", "LATIN SUBSCRIPT SMALL LETTER SCHWA");
   ("/xe2/x84/x82", "DOUBLE-STRUCK CAPITAL C");
   ("/xe2/x84/x8a", "SCRIPT SMALL G");
   ("/xe2/x84/x8b", "SCRIPT CAPITAL H");
   ("/xe2/x84/x8c", "BLACK-LETTER CAPITAL H");
   ("/xe2/x84/x8d", "DOUBLE-STRUCK CAPITAL H");
   ("/xe2/x84/x90", "SCRIPT CAPITAL I");
   ("/xe2/x84/x91", "BLACK-LETTER CAPITAL I");
   ("/xe2/x84/x92", "SCRIPT CAPITAL L");
   ("/xe2/x84/x93", "SCRIPT SMALL L");
   ("/xe2/x84/x95", "DOUBLE-STRUCK CAPITAL N");
   ("/xe2/x84/x98", "SCRIPT CAPITAL P");
   ("/xe2/x84/x99", "DOUBLE-STRUCK CAPITAL P");
   ("/xe2/x84/x9a", "DOUBLE-STRUCK CAPITAL Q");
   ("/xe2/x84/x9b", "SCRIPT CAPITAL R");
   ("/xe2/x84/x9c", "BLACK-LETTER CAPITAL R");
   ("/xe2/x84/x9d", "DOUBLE-STRUCK CAPITAL R");
   ("/xe2/x84/xa4", "DOUBLE-STRUCK CAPITAL Z");
   ("/xe2/x84/xa8", "BLACK-LETTER CAPITAL Z");
   ("/xe2/x84/xa9", "TURNED GREEK SMALL LETTER IOTA");
   ("/xe2/x84/xac", "SCRIPT CAPITAL B");
   ("/xe2/x84/xad", "BLACK-LETTER CAPITAL C");
   ("/xe2/x84/xaf", "SCRIPT SMALL E");
   ("/xe2/x84/xb0", "SCRIPT CAPITAL E");
   ("/xe2/x84/xb1", "SCRIPT CAPITAL F");
   ("/xe2/x84/xb2", "TURNED CAPITAL F");
   ("/xe2/x84/xb3", "SCRIPT CAPITAL M");
   ("/xe2/x84/xb4", "SCRIPT SMALL O");
   ("/xe2/x84/xba", "ROTATED CAPITAL Q");
   ("/xe2/x84/xbc", "DOUBLE-STRUCK SMALL PI");
   ("/xe2/x84/xbd", "DOUBLE-STRUCK SMALL GAMMA");
   ("/xe2/x84/xbe", "DOUBLE-STRUCK CAPITAL GAMMA");
   ("/xe2/x84/xbf", "DOUBLE-STRUCK CAPITAL PI");
   ("/xe2/x85/x81", "TURNED SANS-SERIF CAPITAL G");
   ("/xe2/x85/x82", "TURNED SANS-SERIF CAPITAL L");
   ("/xe2/x85/x83", "REVERSED SANS-SERIF CAPITAL L");
   ("/xe2/x85/x84", "TURNED SANS-SERIF CAPITAL Y");
   ("/xe2/x85/x85", "DOUBLE-STRUCK ITALIC CAPITAL D");
   ("/xe2/x85/x86", "DOUBLE-STRUCK ITALIC SMALL D");
   ("/xe2/x85/x87", "DOUBLE-STRUCK ITALIC SMALL E");
   ("/xe2/x85/x88", "DOUBLE-STRUCK ITALIC SMALL I");
   ("/xe2/x85/x89", "DOUBLE-STRUCK ITALIC SMALL J");
   ("/xe2/x85/x8e", "TURNED SMALL F");
   ("/xe2/x85/xb0", "SMALL ROMAN NUMERAL ONE");
   ("/xe2/x85/xb1", "SMALL ROMAN NUMERAL TWO");
   ("/xe2/x85/xb2", "SMALL ROMAN NUMERAL THREE");
   ("/xe2/x85/xb3", "SMALL ROMAN NUMERAL FOUR");
   ("/xe2/x85/xb4", "SMALL ROMAN NUMERAL FIVE");
   ("/xe2/x85/xb5", "SMALL ROMAN NUMERAL SIX");
   ("/xe2/x85/xb6", "SMALL ROMAN NUMERAL SEVEN");
   ("/xe2/x85/xb7", "SMALL ROMAN NUMERAL EIGHT");
   ("/xe2/x85/xb8", "SMALL ROMAN NUMERAL NINE");
   ("/xe2/x85/xb9", "SMALL ROMAN NUMERAL TEN");
   ("/xe2/x85/xba", "SMALL ROMAN NUMERAL ELEVEN");
   ("/xe2/x85/xbb", "SMALL ROMAN NUMERAL TWELVE");
   ("/xe2/x85/xbc", "SMALL ROMAN NUMERAL FIFTY");
   ("/xe2/x85/xbd", "SMALL ROMAN NUMERAL ONE HUNDRED");
   ("/xe2/x85/xbe", "SMALL ROMAN NUMERAL FIVE HUNDRED");
   ("/xe2/x85/xbf", "SMALL ROMAN NUMERAL ONE THOUSAND");
   ("/xe2/x86/x84", "LATIN SMALL LETTER REVERSED C");
   ("/xe2/x87/xb4", "RIGHT ARROW WITH SMALL CIRCLE");
   ("/xe2/x88/x8a", "SMALL ELEMENT OF");
   ("/xe2/x88/x8d", "SMALL CONTAINS AS MEMBER");
   ("/xe2/x8b/xb4", "SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE");
   ("/xe2/x8b/xb7", "SMALL ELEMENT OF WITH OVERBAR");
   ("/xe2/x8b/xbc", "SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE");
   ("/xe2/x8b/xbe", "SMALL CONTAINS WITH OVERBAR");
   ("/xe2/x92/x9c", "PARENTHESIZED LATIN SMALL LETTER A");
   ("/xe2/x92/x9d", "PARENTHESIZED LATIN SMALL LETTER B");
   ("/xe2/x92/x9e", "PARENTHESIZED LATIN SMALL LETTER C");
   ("/xe2/x92/x9f", "PARENTHESIZED LATIN SMALL LETTER D");
   ("/xe2/x92/xa0", "PARENTHESIZED LATIN SMALL LETTER E");
   ("/xe2/x92/xa1", "PARENTHESIZED LATIN SMALL LETTER F");
   ("/xe2/x92/xa2", "PARENTHESIZED LATIN SMALL LETTER G");
   ("/xe2/x92/xa3", "PARENTHESIZED LATIN SMALL LETTER H");
   ("/xe2/x92/xa4", "PARENTHESIZED LATIN SMALL LETTER I");
   ("/xe2/x92/xa5", "PARENTHESIZED LATIN SMALL LETTER J");
   ("/xe2/x92/xa6", "PARENTHESIZED LATIN SMALL LETTER K");
   ("/xe2/x92/xa7", "PARENTHESIZED LATIN SMALL LETTER L");
   ("/xe2/x92/xa8", "PARENTHESIZED LATIN SMALL LETTER M");
   ("/xe2/x92/xa9", "PARENTHESIZED LATIN SMALL LETTER N");
   ("/xe2/x92/xaa", "PARENTHESIZED LATIN SMALL LETTER O");
   ("/xe2/x92/xab", "PARENTHESIZED LATIN SMALL LETTER P");
   ("/xe2/x92/xac", "PARENTHESIZED LATIN SMALL LETTER Q");
   ("/xe2/x92/xad", "PARENTHESIZED LATIN SMALL LETTER R");
   ("/xe2/x92/xae", "PARENTHESIZED LATIN SMALL LETTER S");
   ("/xe2/x92/xaf", "PARENTHESIZED LATIN SMALL LETTER T");
   ("/xe2/x92/xb0", "PARENTHESIZED LATIN SMALL LETTER U");
   ("/xe2/x92/xb1", "PARENTHESIZED LATIN SMALL LETTER V");
   ("/xe2/x92/xb2", "PARENTHESIZED LATIN SMALL LETTER W");
   ("/xe2/x92/xb3", "PARENTHESIZED LATIN SMALL LETTER X");
   ("/xe2/x92/xb4", "PARENTHESIZED LATIN SMALL LETTER Y");
   ("/xe2/x92/xb5", "PARENTHESIZED LATIN SMALL LETTER Z");
   ("/xe2/x92/xb6", "CIRCLED LATIN CAPITAL LETTER A");
   ("/xe2/x92/xb7", "CIRCLED LATIN CAPITAL LETTER B");
   ("/xe2/x92/xb8", "CIRCLED LATIN CAPITAL LETTER C");
   ("/xe2/x92/xb9", "CIRCLED LATIN CAPITAL LETTER D");
   ("/xe2/x92/xba", "CIRCLED LATIN CAPITAL LETTER E");
   ("/xe2/x92/xbb", "CIRCLED LATIN CAPITAL LETTER F");
   ("/xe2/x92/xbc", "CIRCLED LATIN CAPITAL LETTER G");
   ("/xe2/x92/xbd", "CIRCLED LATIN CAPITAL LETTER H");
   ("/xe2/x92/xbe", "CIRCLED LATIN CAPITAL LETTER I");
   ("/xe2/x92/xbf", "CIRCLED LATIN CAPITAL LETTER J");
   ("/xe2/x93/x80", "CIRCLED LATIN CAPITAL LETTER K");
   ("/xe2/x93/x81", "CIRCLED LATIN CAPITAL LETTER L");
   ("/xe2/x93/x82", "CIRCLED LATIN CAPITAL LETTER M");
   ("/xe2/x93/x83", "CIRCLED LATIN CAPITAL LETTER N");
   ("/xe2/x93/x84", "CIRCLED LATIN CAPITAL LETTER O");
   ("/xe2/x93/x85", "CIRCLED LATIN CAPITAL LETTER P");
   ("/xe2/x93/x86", "CIRCLED LATIN CAPITAL LETTER Q");
   ("/xe2/x93/x87", "CIRCLED LATIN CAPITAL LETTER R");
   ("/xe2/x93/x88", "CIRCLED LATIN CAPITAL LETTER S");
   ("/xe2/x93/x89", "CIRCLED LATIN CAPITAL LETTER T");
   ("/xe2/x93/x8a", "CIRCLED LATIN CAPITAL LETTER U");
   ("/xe2/x93/x8b", "CIRCLED LATIN CAPITAL LETTER V");
   ("/xe2/x93/x8c", "CIRCLED LATIN CAPITAL LETTER W");
   ("/xe2/x93/x8d", "CIRCLED LATIN CAPITAL LETTER X");
   ("/xe2/x93/x8e", "CIRCLED LATIN CAPITAL LETTER Y");
   ("/xe2/x93/x8f", "CIRCLED LATIN CAPITAL LETTER Z");
   ("/xe2/x93/x90", "CIRCLED LATIN SMALL LETTER A");
   ("/xe2/x93/x91", "CIRCLED LATIN SMALL LETTER B");
   ("/xe2/x93/x92", "CIRCLED LATIN SMALL LETTER C");
   ("/xe2/x93/x93", "CIRCLED LATIN SMALL LETTER D");
   ("/xe2/x93/x94", "CIRCLED LATIN SMALL LETTER E");
   ("/xe2/x93/x95", "CIRCLED LATIN SMALL LETTER F");
   ("/xe2/x93/x96", "CIRCLED LATIN SMALL LETTER G");
   ("/xe2/x93/x97", "CIRCLED LATIN SMALL LETTER H");
   ("/xe2/x93/x98", "CIRCLED LATIN SMALL LETTER I");
   ("/xe2/x93/x99", "CIRCLED LATIN SMALL LETTER J");
   ("/xe2/x93/x9a", "CIRCLED LATIN SMALL LETTER K");
   ("/xe2/x93/x9b", "CIRCLED LATIN SMALL LETTER L");
   ("/xe2/x93/x9c", "CIRCLED LATIN SMALL LETTER M");
   ("/xe2/x93/x9d", "CIRCLED LATIN SMALL LETTER N");
   ("/xe2/x93/x9e", "CIRCLED LATIN SMALL LETTER O");
   ("/xe2/x93/x9f", "CIRCLED LATIN SMALL LETTER P");
   ("/xe2/x93/xa0", "CIRCLED LATIN SMALL LETTER Q");
   ("/xe2/x93/xa1", "CIRCLED LATIN SMALL LETTER R");
   ("/xe2/x93/xa2", "CIRCLED LATIN SMALL LETTER S");
   ("/xe2/x93/xa3", "CIRCLED LATIN SMALL LETTER T");
   ("/xe2/x93/xa4", "CIRCLED LATIN SMALL LETTER U");
   ("/xe2/x93/xa5", "CIRCLED LATIN SMALL LETTER V");
   ("/xe2/x93/xa6", "CIRCLED LATIN SMALL LETTER W");
   ("/xe2/x93/xa7", "CIRCLED LATIN SMALL LETTER X");
   ("/xe2/x93/xa8", "CIRCLED LATIN SMALL LETTER Y");
   ("/xe2/x93/xa9", "CIRCLED LATIN SMALL LETTER Z");
   ("/xe2/x96/xa3", "WHITE SQUARE CONTAINING BLACK SMALL SQUARE");
   ("/xe2/x96/xaa", "BLACK SMALL SQUARE");
   ("/xe2/x96/xab", "WHITE SMALL SQUARE");
   ("/xe2/x96/xb4", "BLACK UP-POINTING SMALL TRIANGLE");
   ("/xe2/x96/xb5", "WHITE UP-POINTING SMALL TRIANGLE");
   ("/xe2/x96/xb8", "BLACK RIGHT-POINTING SMALL TRIANGLE");
   ("/xe2/x96/xb9", "WHITE RIGHT-POINTING SMALL TRIANGLE");
   ("/xe2/x96/xbe", "BLACK DOWN-POINTING SMALL TRIANGLE");
   ("/xe2/x96/xbf", "WHITE DOWN-POINTING SMALL TRIANGLE");
   ("/xe2/x97/x82", "BLACK LEFT-POINTING SMALL TRIANGLE");
   ("/xe2/x97/x83", "WHITE LEFT-POINTING SMALL TRIANGLE");
   ("/xe2/x97/x88", "WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND");
   ("/xe2/x97/xbd", "WHITE MEDIUM SMALL SQUARE");
   ("/xe2/x97/xbe", "BLACK MEDIUM SMALL SQUARE");
   ("/xe2/x9a/xac", "MEDIUM SMALL WHITE CIRCLE");
   ("/xe2/x9f/x81", "WHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLE");
   ("/xe2/xa5/x88", "LEFT RIGHT ARROW THROUGH SMALL CIRCLE");
   ("/xe2/xa5/x89", "UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE");
   ("/xe2/xa6/xb2", "EMPTY SET WITH SMALL CIRCLE ABOVE");
   ("/xe2/xa7/x82", "CIRCLE WITH SMALL CIRCLE TO THE RIGHT");
   ("/xe2/xa7/x87", "SQUARED SMALL CIRCLE");
   ("/xe2/xa8/xa2", "PLUS SIGN WITH SMALL CIRCLE ABOVE");
   ("/xe2/xa9/xa1", "SMALL VEE WITH UNDERBAR");
   ("/xe2/xaa/xaa", "SMALLER THAN");
   ("/xe2/xaa/xac", "SMALLER THAN OR EQUAL TO");
   ("/xe2/xac/x9d", "BLACK VERY SMALL SQUARE");
   ("/xe2/xac/x9e", "WHITE VERY SMALL SQUARE");
   ("/xe2/xac/xa9", "BLACK SMALL DIAMOND");
   ("/xe2/xac/xaa", "BLACK SMALL LOZENGE");
   ("/xe2/xac/xab", "WHITE SMALL LOZENGE");
   ("/xe2/xac/xb0", "LEFT ARROW WITH SMALL CIRCLE");
   ("/xe2/xad/x91", "BLACK SMALL STAR");
   ("/xe2/xad/x92", "WHITE SMALL STAR");
   ("/xe2/xb0/x80", "GLAGOLITIC CAPITAL LETTER AZU");
   ("/xe2/xb0/x81", "GLAGOLITIC CAPITAL LETTER BUKY");
   ("/xe2/xb0/x82", "GLAGOLITIC CAPITAL LETTER VEDE");
   ("/xe2/xb0/x83", "GLAGOLITIC CAPITAL LETTER GLAGOLI");
   ("/xe2/xb0/x84", "GLAGOLITIC CAPITAL LETTER DOBRO");
   ("/xe2/xb0/x85", "GLAGOLITIC CAPITAL LETTER YESTU");
   ("/xe2/xb0/x86", "GLAGOLITIC CAPITAL LETTER ZHIVETE");
   ("/xe2/xb0/x87", "GLAGOLITIC CAPITAL LETTER DZELO");
   ("/xe2/xb0/x88", "GLAGOLITIC CAPITAL LETTER ZEMLJA");
   ("/xe2/xb0/x89", "GLAGOLITIC CAPITAL LETTER IZHE");
   ("/xe2/xb0/x8a", "GLAGOLITIC CAPITAL LETTER INITIAL IZHE");
   ("/xe2/xb0/x8b", "GLAGOLITIC CAPITAL LETTER I");
   ("/xe2/xb0/x8c", "GLAGOLITIC CAPITAL LETTER DJERVI");
   ("/xe2/xb0/x8d", "GLAGOLITIC CAPITAL LETTER KAKO");
   ("/xe2/xb0/x8e", "GLAGOLITIC CAPITAL LETTER LJUDIJE");
   ("/xe2/xb0/x8f", "GLAGOLITIC CAPITAL LETTER MYSLITE");
   ("/xe2/xb0/x90", "GLAGOLITIC CAPITAL LETTER NASHI");
   ("/xe2/xb0/x91", "GLAGOLITIC CAPITAL LETTER ONU");
   ("/xe2/xb0/x92", "GLAGOLITIC CAPITAL LETTER POKOJI");
   ("/xe2/xb0/x93", "GLAGOLITIC CAPITAL LETTER RITSI");
   ("/xe2/xb0/x94", "GLAGOLITIC CAPITAL LETTER SLOVO");
   ("/xe2/xb0/x95", "GLAGOLITIC CAPITAL LETTER TVRIDO");
   ("/xe2/xb0/x96", "GLAGOLITIC CAPITAL LETTER UKU");
   ("/xe2/xb0/x97", "GLAGOLITIC CAPITAL LETTER FRITU");
   ("/xe2/xb0/x98", "GLAGOLITIC CAPITAL LETTER HERU");
   ("/xe2/xb0/x99", "GLAGOLITIC CAPITAL LETTER OTU");
   ("/xe2/xb0/x9a", "GLAGOLITIC CAPITAL LETTER PE");
   ("/xe2/xb0/x9b", "GLAGOLITIC CAPITAL LETTER SHTA");
   ("/xe2/xb0/x9c", "GLAGOLITIC CAPITAL LETTER TSI");
   ("/xe2/xb0/x9d", "GLAGOLITIC CAPITAL LETTER CHRIVI");
   ("/xe2/xb0/x9e", "GLAGOLITIC CAPITAL LETTER SHA");
   ("/xe2/xb0/x9f", "GLAGOLITIC CAPITAL LETTER YERU");
   ("/xe2/xb0/xa0", "GLAGOLITIC CAPITAL LETTER YERI");
   ("/xe2/xb0/xa1", "GLAGOLITIC CAPITAL LETTER YATI");
   ("/xe2/xb0/xa2", "GLAGOLITIC CAPITAL LETTER SPIDERY HA");
   ("/xe2/xb0/xa3", "GLAGOLITIC CAPITAL LETTER YU");
   ("/xe2/xb0/xa4", "GLAGOLITIC CAPITAL LETTER SMALL YUS");
   ("/xe2/xb0/xa5", "GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL");
   ("/xe2/xb0/xa6", "GLAGOLITIC CAPITAL LETTER YO");
   ("/xe2/xb0/xa7", "GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS");
   ("/xe2/xb0/xa8", "GLAGOLITIC CAPITAL LETTER BIG YUS");
   ("/xe2/xb0/xa9", "GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS");
   ("/xe2/xb0/xaa", "GLAGOLITIC CAPITAL LETTER FITA");
   ("/xe2/xb0/xab", "GLAGOLITIC CAPITAL LETTER IZHITSA");
   ("/xe2/xb0/xac", "GLAGOLITIC CAPITAL LETTER SHTAPIC");
   ("/xe2/xb0/xad", "GLAGOLITIC CAPITAL LETTER TROKUTASTI A");
   ("/xe2/xb0/xae", "GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE");
   ("/xe2/xb0/xb0", "GLAGOLITIC SMALL LETTER AZU");
   ("/xe2/xb0/xb1", "GLAGOLITIC SMALL LETTER BUKY");
   ("/xe2/xb0/xb2", "GLAGOLITIC SMALL LETTER VEDE");
   ("/xe2/xb0/xb3", "GLAGOLITIC SMALL LETTER GLAGOLI");
   ("/xe2/xb0/xb4", "GLAGOLITIC SMALL LETTER DOBRO");
   ("/xe2/xb0/xb5", "GLAGOLITIC SMALL LETTER YESTU");
   ("/xe2/xb0/xb6", "GLAGOLITIC SMALL LETTER ZHIVETE");
   ("/xe2/xb0/xb7", "GLAGOLITIC SMALL LETTER DZELO");
   ("/xe2/xb0/xb8", "GLAGOLITIC SMALL LETTER ZEMLJA");
   ("/xe2/xb0/xb9", "GLAGOLITIC SMALL LETTER IZHE");
   ("/xe2/xb0/xba", "GLAGOLITIC SMALL LETTER INITIAL IZHE");
   ("/xe2/xb0/xbb", "GLAGOLITIC SMALL LETTER I");
   ("/xe2/xb0/xbc", "GLAGOLITIC SMALL LETTER DJERVI");
   ("/xe2/xb0/xbd", "GLAGOLITIC SMALL LETTER KAKO");
   ("/xe2/xb0/xbe", "GLAGOLITIC SMALL LETTER LJUDIJE");
   ("/xe2/xb0/xbf", "GLAGOLITIC SMALL LETTER MYSLITE");
   ("/xe2/xb1/x80", "GLAGOLITIC SMALL LETTER NASHI");
   ("/xe2/xb1/x81", "GLAGOLITIC SMALL LETTER ONU");
   ("/xe2/xb1/x82", "GLAGOLITIC SMALL LETTER POKOJI");
   ("/xe2/xb1/x83", "GLAGOLITIC SMALL LETTER RITSI");
   ("/xe2/xb1/x84", "GLAGOLITIC SMALL LETTER SLOVO");
   ("/xe2/xb1/x85", "GLAGOLITIC SMALL LETTER TVRIDO");
   ("/xe2/xb1/x86", "GLAGOLITIC SMALL LETTER UKU");
   ("/xe2/xb1/x87", "GLAGOLITIC SMALL LETTER FRITU");
   ("/xe2/xb1/x88", "GLAGOLITIC SMALL LETTER HERU");
   ("/xe2/xb1/x89", "GLAGOLITIC SMALL LETTER OTU");
   ("/xe2/xb1/x8a", "GLAGOLITIC SMALL LETTER PE");
   ("/xe2/xb1/x8b", "GLAGOLITIC SMALL LETTER SHTA");
   ("/xe2/xb1/x8c", "GLAGOLITIC SMALL LETTER TSI");
   ("/xe2/xb1/x8d", "GLAGOLITIC SMALL LETTER CHRIVI");
   ("/xe2/xb1/x8e", "GLAGOLITIC SMALL LETTER SHA");
   ("/xe2/xb1/x8f", "GLAGOLITIC SMALL LETTER YERU");
   ("/xe2/xb1/x90", "GLAGOLITIC SMALL LETTER YERI");
   ("/xe2/xb1/x91", "GLAGOLITIC SMALL LETTER YATI");
   ("/xe2/xb1/x92", "GLAGOLITIC SMALL LETTER SPIDERY HA");
   ("/xe2/xb1/x93", "GLAGOLITIC SMALL LETTER YU");
   ("/xe2/xb1/x94", "GLAGOLITIC SMALL LETTER SMALL YUS");
   ("/xe2/xb1/x95", "GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL");
   ("/xe2/xb1/x96", "GLAGOLITIC SMALL LETTER YO");
   ("/xe2/xb1/x97", "GLAGOLITIC SMALL LETTER IOTATED SMALL YUS");
   ("/xe2/xb1/x98", "GLAGOLITIC SMALL LETTER BIG YUS");
   ("/xe2/xb1/x99", "GLAGOLITIC SMALL LETTER IOTATED BIG YUS");
   ("/xe2/xb1/x9a", "GLAGOLITIC SMALL LETTER FITA");
   ("/xe2/xb1/x9b", "GLAGOLITIC SMALL LETTER IZHITSA");
   ("/xe2/xb1/x9c", "GLAGOLITIC SMALL LETTER SHTAPIC");
   ("/xe2/xb1/x9d", "GLAGOLITIC SMALL LETTER TROKUTASTI A");
   ("/xe2/xb1/x9e", "GLAGOLITIC SMALL LETTER LATINATE MYSLITE");
   ("/xe2/xb1/xa0", "LATIN CAPITAL LETTER L WITH DOUBLE BAR");
   ("/xe2/xb1/xa1", "LATIN SMALL LETTER L WITH DOUBLE BAR");
   ("/xe2/xb1/xa2", "LATIN CAPITAL LETTER L WITH MIDDLE TILDE");
   ("/xe2/xb1/xa3", "LATIN CAPITAL LETTER P WITH STROKE");
   ("/xe2/xb1/xa4", "LATIN CAPITAL LETTER R WITH TAIL");
   ("/xe2/xb1/xa5", "LATIN SMALL LETTER A WITH STROKE");
   ("/xe2/xb1/xa6", "LATIN SMALL LETTER T WITH DIAGONAL STROKE");
   ("/xe2/xb1/xa7", "LATIN CAPITAL LETTER H WITH DESCENDER");
   ("/xe2/xb1/xa8", "LATIN SMALL LETTER H WITH DESCENDER");
   ("/xe2/xb1/xa9", "LATIN CAPITAL LETTER K WITH DESCENDER");
   ("/xe2/xb1/xaa", "LATIN SMALL LETTER K WITH DESCENDER");
   ("/xe2/xb1/xab", "LATIN CAPITAL LETTER Z WITH DESCENDER");
   ("/xe2/xb1/xac", "LATIN SMALL LETTER Z WITH DESCENDER");
   ("/xe2/xb1/xad", "LATIN CAPITAL LETTER ALPHA");
   ("/xe2/xb1/xae", "LATIN CAPITAL LETTER M WITH HOOK");
   ("/xe2/xb1/xaf", "LATIN CAPITAL LETTER TURNED A");
   ("/xe2/xb1/xb1", "LATIN SMALL LETTER V WITH RIGHT HOOK");
   ("/xe2/xb1/xb2", "LATIN CAPITAL LETTER W WITH HOOK");
   ("/xe2/xb1/xb3", "LATIN SMALL LETTER W WITH HOOK");
   ("/xe2/xb1/xb4", "LATIN SMALL LETTER V WITH CURL");
   ("/xe2/xb1/xb5", "LATIN CAPITAL LETTER HALF H");
   ("/xe2/xb1/xb6", "LATIN SMALL LETTER HALF H");
   ("/xe2/xb1/xb7", "LATIN SMALL LETTER TAILLESS PHI");
   ("/xe2/xb1/xb8", "LATIN SMALL LETTER E WITH NOTCH");
   ("/xe2/xb1/xb9", "LATIN SMALL LETTER TURNED R WITH TAIL");
   ("/xe2/xb1/xba", "LATIN SMALL LETTER O WITH LOW RING INSIDE");
   ("/xe2/xb1/xbb", "LATIN LETTER SMALL CAPITAL TURNED E");
   ("/xe2/xb1/xbc", "LATIN SUBSCRIPT SMALL LETTER J");
   ("/xe2/xb1/xbd", "MODIFIER LETTER CAPITAL V");
   ("/xe2/xb2/x80", "COPTIC CAPITAL LETTER ALFA");
   ("/xe2/xb2/x81", "COPTIC SMALL LETTER ALFA");
   ("/xe2/xb2/x82", "COPTIC CAPITAL LETTER VIDA");
   ("/xe2/xb2/x83", "COPTIC SMALL LETTER VIDA");
   ("/xe2/xb2/x84", "COPTIC CAPITAL LETTER GAMMA");
   ("/xe2/xb2/x85", "COPTIC SMALL LETTER GAMMA");
   ("/xe2/xb2/x86", "COPTIC CAPITAL LETTER DALDA");
   ("/xe2/xb2/x87", "COPTIC SMALL LETTER DALDA");
   ("/xe2/xb2/x88", "COPTIC CAPITAL LETTER EIE");
   ("/xe2/xb2/x89", "COPTIC SMALL LETTER EIE");
   ("/xe2/xb2/x8a", "COPTIC CAPITAL LETTER SOU");
   ("/xe2/xb2/x8b", "COPTIC SMALL LETTER SOU");
   ("/xe2/xb2/x8c", "COPTIC CAPITAL LETTER ZATA");
   ("/xe2/xb2/x8d", "COPTIC SMALL LETTER ZATA");
   ("/xe2/xb2/x8e", "COPTIC CAPITAL LETTER HATE");
   ("/xe2/xb2/x8f", "COPTIC SMALL LETTER HATE");
   ("/xe2/xb2/x90", "COPTIC CAPITAL LETTER THETHE");
   ("/xe2/xb2/x91", "COPTIC SMALL LETTER THETHE");
   ("/xe2/xb2/x92", "COPTIC CAPITAL LETTER IAUDA");
   ("/xe2/xb2/x93", "COPTIC SMALL LETTER IAUDA");
   ("/xe2/xb2/x94", "COPTIC CAPITAL LETTER KAPA");
   ("/xe2/xb2/x95", "COPTIC SMALL LETTER KAPA");
   ("/xe2/xb2/x96", "COPTIC CAPITAL LETTER LAULA");
   ("/xe2/xb2/x97", "COPTIC SMALL LETTER LAULA");
   ("/xe2/xb2/x98", "COPTIC CAPITAL LETTER MI");
   ("/xe2/xb2/x99", "COPTIC SMALL LETTER MI");
   ("/xe2/xb2/x9a", "COPTIC CAPITAL LETTER NI");
   ("/xe2/xb2/x9b", "COPTIC SMALL LETTER NI");
   ("/xe2/xb2/x9c", "COPTIC CAPITAL LETTER KSI");
   ("/xe2/xb2/x9d", "COPTIC SMALL LETTER KSI");
   ("/xe2/xb2/x9e", "COPTIC CAPITAL LETTER O");
   ("/xe2/xb2/x9f", "COPTIC SMALL LETTER O");
   ("/xe2/xb2/xa0", "COPTIC CAPITAL LETTER PI");
   ("/xe2/xb2/xa1", "COPTIC SMALL LETTER PI");
   ("/xe2/xb2/xa2", "COPTIC CAPITAL LETTER RO");
   ("/xe2/xb2/xa3", "COPTIC SMALL LETTER RO");
   ("/xe2/xb2/xa4", "COPTIC CAPITAL LETTER SIMA");
   ("/xe2/xb2/xa5", "COPTIC SMALL LETTER SIMA");
   ("/xe2/xb2/xa6", "COPTIC CAPITAL LETTER TAU");
   ("/xe2/xb2/xa7", "COPTIC SMALL LETTER TAU");
   ("/xe2/xb2/xa8", "COPTIC CAPITAL LETTER UA");
   ("/xe2/xb2/xa9", "COPTIC SMALL LETTER UA");
   ("/xe2/xb2/xaa", "COPTIC CAPITAL LETTER FI");
   ("/xe2/xb2/xab", "COPTIC SMALL LETTER FI");
   ("/xe2/xb2/xac", "COPTIC CAPITAL LETTER KHI");
   ("/xe2/xb2/xad", "COPTIC SMALL LETTER KHI");
   ("/xe2/xb2/xae", "COPTIC CAPITAL LETTER PSI");
   ("/xe2/xb2/xaf", "COPTIC SMALL LETTER PSI");
   ("/xe2/xb2/xb0", "COPTIC CAPITAL LETTER OOU");
   ("/xe2/xb2/xb1", "COPTIC SMALL LETTER OOU");
   ("/xe2/xb2/xb2", "COPTIC CAPITAL LETTER DIALECT-P ALEF");
   ("/xe2/xb2/xb3", "COPTIC SMALL LETTER DIALECT-P ALEF");
   ("/xe2/xb2/xb4", "COPTIC CAPITAL LETTER OLD COPTIC AIN");
   ("/xe2/xb2/xb5", "COPTIC SMALL LETTER OLD COPTIC AIN");
   ("/xe2/xb2/xb6", "COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE");
   ("/xe2/xb2/xb7", "COPTIC SMALL LETTER CRYPTOGRAMMIC EIE");
   ("/xe2/xb2/xb8", "COPTIC CAPITAL LETTER DIALECT-P KAPA");
   ("/xe2/xb2/xb9", "COPTIC SMALL LETTER DIALECT-P KAPA");
   ("/xe2/xb2/xba", "COPTIC CAPITAL LETTER DIALECT-P NI");
   ("/xe2/xb2/xbb", "COPTIC SMALL LETTER DIALECT-P NI");
   ("/xe2/xb2/xbc", "COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI");
   ("/xe2/xb2/xbd", "COPTIC SMALL LETTER CRYPTOGRAMMIC NI");
   ("/xe2/xb2/xbe", "COPTIC CAPITAL LETTER OLD COPTIC OOU");
   ("/xe2/xb2/xbf", "COPTIC SMALL LETTER OLD COPTIC OOU");
   ("/xe2/xb3/x80", "COPTIC CAPITAL LETTER SAMPI");
   ("/xe2/xb3/x81", "COPTIC SMALL LETTER SAMPI");
   ("/xe2/xb3/x82", "COPTIC CAPITAL LETTER CROSSED SHEI");
   ("/xe2/xb3/x83", "COPTIC SMALL LETTER CROSSED SHEI");
   ("/xe2/xb3/x84", "COPTIC CAPITAL LETTER OLD COPTIC SHEI");
   ("/xe2/xb3/x85", "COPTIC SMALL LETTER OLD COPTIC SHEI");
   ("/xe2/xb3/x86", "COPTIC CAPITAL LETTER OLD COPTIC ESH");
   ("/xe2/xb3/x87", "COPTIC SMALL LETTER OLD COPTIC ESH");
   ("/xe2/xb3/x88", "COPTIC CAPITAL LETTER AKHMIMIC KHEI");
   ("/xe2/xb3/x89", "COPTIC SMALL LETTER AKHMIMIC KHEI");
   ("/xe2/xb3/x8a", "COPTIC CAPITAL LETTER DIALECT-P HORI");
   ("/xe2/xb3/x8b", "COPTIC SMALL LETTER DIALECT-P HORI");
   ("/xe2/xb3/x8c", "COPTIC CAPITAL LETTER OLD COPTIC HORI");
   ("/xe2/xb3/x8d", "COPTIC SMALL LETTER OLD COPTIC HORI");
   ("/xe2/xb3/x8e", "COPTIC CAPITAL LETTER OLD COPTIC HA");
   ("/xe2/xb3/x8f", "COPTIC SMALL LETTER OLD COPTIC HA");
   ("/xe2/xb3/x90", "COPTIC CAPITAL LETTER L-SHAPED HA");
   ("/xe2/xb3/x91", "COPTIC SMALL LETTER L-SHAPED HA");
   ("/xe2/xb3/x92", "COPTIC CAPITAL LETTER OLD COPTIC HEI");
   ("/xe2/xb3/x93", "COPTIC SMALL LETTER OLD COPTIC HEI");
   ("/xe2/xb3/x94", "COPTIC CAPITAL LETTER OLD COPTIC HAT");
   ("/xe2/xb3/x95", "COPTIC SMALL LETTER OLD COPTIC HAT");
   ("/xe2/xb3/x96", "COPTIC CAPITAL LETTER OLD COPTIC GANGIA");
   ("/xe2/xb3/x97", "COPTIC SMALL LETTER OLD COPTIC GANGIA");
   ("/xe2/xb3/x98", "COPTIC CAPITAL LETTER OLD COPTIC DJA");
   ("/xe2/xb3/x99", "COPTIC SMALL LETTER OLD COPTIC DJA");
   ("/xe2/xb3/x9a", "COPTIC CAPITAL LETTER OLD COPTIC SHIMA");
   ("/xe2/xb3/x9b", "COPTIC SMALL LETTER OLD COPTIC SHIMA");
   ("/xe2/xb3/x9c", "COPTIC CAPITAL LETTER OLD NUBIAN SHIMA");
   ("/xe2/xb3/x9d", "COPTIC SMALL LETTER OLD NUBIAN SHIMA");
   ("/xe2/xb3/x9e", "COPTIC CAPITAL LETTER OLD NUBIAN NGI");
   ("/xe2/xb3/x9f", "COPTIC SMALL LETTER OLD NUBIAN NGI");
   ("/xe2/xb3/xa0", "COPTIC CAPITAL LETTER OLD NUBIAN NYI");
   ("/xe2/xb3/xa1", "COPTIC SMALL LETTER OLD NUBIAN NYI");
   ("/xe2/xb3/xa2", "COPTIC CAPITAL LETTER OLD NUBIAN WAU");
   ("/xe2/xb3/xa3", "COPTIC SMALL LETTER OLD NUBIAN WAU");
   ("/xe2/xb4/x80", "GEORGIAN SMALL LETTER AN");
   ("/xe2/xb4/x81", "GEORGIAN SMALL LETTER BAN");
   ("/xe2/xb4/x82", "GEORGIAN SMALL LETTER GAN");
   ("/xe2/xb4/x83", "GEORGIAN SMALL LETTER DON");
   ("/xe2/xb4/x84", "GEORGIAN SMALL LETTER EN");
   ("/xe2/xb4/x85", "GEORGIAN SMALL LETTER VIN");
   ("/xe2/xb4/x86", "GEORGIAN SMALL LETTER ZEN");
   ("/xe2/xb4/x87", "GEORGIAN SMALL LETTER TAN");
   ("/xe2/xb4/x88", "GEORGIAN SMALL LETTER IN");
   ("/xe2/xb4/x89", "GEORGIAN SMALL LETTER KAN");
   ("/xe2/xb4/x8a", "GEORGIAN SMALL LETTER LAS");
   ("/xe2/xb4/x8b", "GEORGIAN SMALL LETTER MAN");
   ("/xe2/xb4/x8c", "GEORGIAN SMALL LETTER NAR");
   ("/xe2/xb4/x8d", "GEORGIAN SMALL LETTER ON");
   ("/xe2/xb4/x8e", "GEORGIAN SMALL LETTER PAR");
   ("/xe2/xb4/x8f", "GEORGIAN SMALL LETTER ZHAR");
   ("/xe2/xb4/x90", "GEORGIAN SMALL LETTER RAE");
   ("/xe2/xb4/x91", "GEORGIAN SMALL LETTER SAN");
   ("/xe2/xb4/x92", "GEORGIAN SMALL LETTER TAR");
   ("/xe2/xb4/x93", "GEORGIAN SMALL LETTER UN");
   ("/xe2/xb4/x94", "GEORGIAN SMALL LETTER PHAR");
   ("/xe2/xb4/x95", "GEORGIAN SMALL LETTER KHAR");
   ("/xe2/xb4/x96", "GEORGIAN SMALL LETTER GHAN");
   ("/xe2/xb4/x97", "GEORGIAN SMALL LETTER QAR");
   ("/xe2/xb4/x98", "GEORGIAN SMALL LETTER SHIN");
   ("/xe2/xb4/x99", "GEORGIAN SMALL LETTER CHIN");
   ("/xe2/xb4/x9a", "GEORGIAN SMALL LETTER CAN");
   ("/xe2/xb4/x9b", "GEORGIAN SMALL LETTER JIL");
   ("/xe2/xb4/x9c", "GEORGIAN SMALL LETTER CIL");
   ("/xe2/xb4/x9d", "GEORGIAN SMALL LETTER CHAR");
   ("/xe2/xb4/x9e", "GEORGIAN SMALL LETTER XAN");
   ("/xe2/xb4/x9f", "GEORGIAN SMALL LETTER JHAN");
   ("/xe2/xb4/xa0", "GEORGIAN SMALL LETTER HAE");
   ("/xe2/xb4/xa1", "GEORGIAN SMALL LETTER HE");
   ("/xe2/xb4/xa2", "GEORGIAN SMALL LETTER HIE");
   ("/xe2/xb4/xa3", "GEORGIAN SMALL LETTER WE");
   ("/xe2/xb4/xa4", "GEORGIAN SMALL LETTER HAR");
   ("/xe2/xb4/xa5", "GEORGIAN SMALL LETTER HOE");
   ("/xe2/xba/x8c", "CJK RADICAL SMALL ONE");
   ("/xe2/xba/x8d", "CJK RADICAL SMALL TWO");
   ("/xe2/xbc/xa9", "KANGXI RADICAL SMALL");
   ("/xe3/x81/x81", "HIRAGANA LETTER SMALL A");
   ("/xe3/x81/x83", "HIRAGANA LETTER SMALL I");
   ("/xe3/x81/x85", "HIRAGANA LETTER SMALL U");
   ("/xe3/x81/x87", "HIRAGANA LETTER SMALL E");
   ("/xe3/x81/x89", "HIRAGANA LETTER SMALL O");
   ("/xe3/x81/xa3", "HIRAGANA LETTER SMALL TU");
   ("/xe3/x82/x83", "HIRAGANA LETTER SMALL YA");
   ("/xe3/x82/x85", "HIRAGANA LETTER SMALL YU");
   ("/xe3/x82/x87", "HIRAGANA LETTER SMALL YO");
   ("/xe3/x82/x8e", "HIRAGANA LETTER SMALL WA");
   ("/xe3/x82/x95", "HIRAGANA LETTER SMALL KA");
   ("/xe3/x82/x96", "HIRAGANA LETTER SMALL KE");
   ("/xe3/x82/xa1", "KATAKANA LETTER SMALL A");
   ("/xe3/x82/xa3", "KATAKANA LETTER SMALL I");
   ("/xe3/x82/xa5", "KATAKANA LETTER SMALL U");
   ("/xe3/x82/xa7", "KATAKANA LETTER SMALL E");
   ("/xe3/x82/xa9", "KATAKANA LETTER SMALL O");
   ("/xe3/x83/x83", "KATAKANA LETTER SMALL TU");
   ("/xe3/x83/xa3", "KATAKANA LETTER SMALL YA");
   ("/xe3/x83/xa5", "KATAKANA LETTER SMALL YU");
   ("/xe3/x83/xa7", "KATAKANA LETTER SMALL YO");
   ("/xe3/x83/xae", "KATAKANA LETTER SMALL WA");
   ("/xe3/x83/xb5", "KATAKANA LETTER SMALL KA");
   ("/xe3/x83/xb6", "KATAKANA LETTER SMALL KE");
   ("/xe3/x87/xb0", "KATAKANA LETTER SMALL KU");
   ("/xe3/x87/xb1", "KATAKANA LETTER SMALL SI");
   ("/xe3/x87/xb2", "KATAKANA LETTER SMALL SU");
   ("/xe3/x87/xb3", "KATAKANA LETTER SMALL TO");
   ("/xe3/x87/xb4", "KATAKANA LETTER SMALL NU");
   ("/xe3/x87/xb5", "KATAKANA LETTER SMALL HA");
   ("/xe3/x87/xb6", "KATAKANA LETTER SMALL HI");
   ("/xe3/x87/xb7", "KATAKANA LETTER SMALL HU");
   ("/xe3/x87/xb8", "KATAKANA LETTER SMALL HE");
   ("/xe3/x87/xb9", "KATAKANA LETTER SMALL HO");
   ("/xe3/x87/xba", "KATAKANA LETTER SMALL MU");
   ("/xe3/x87/xbb", "KATAKANA LETTER SMALL RA");
   ("/xe3/x87/xbc", "KATAKANA LETTER SMALL RI");
   ("/xe3/x87/xbd", "KATAKANA LETTER SMALL RU");
   ("/xe3/x87/xbe", "KATAKANA LETTER SMALL RE");
   ("/xe3/x87/xbf", "KATAKANA LETTER SMALL RO");
   ("/xe3/x8f/x8e", "SQUARE KM CAPITAL");
   ("/xe3/x8f/x94", "SQUARE MB SMALL");
   ("/xe4/xb7/x88", "HEXAGRAM FOR SMALL TAMING");
   ("/xe4/xb7/xbd", "HEXAGRAM FOR SMALL PREPONDERANCE");
   ("/xea/x99/x80", "CYRILLIC CAPITAL LETTER ZEMLYA");
   ("/xea/x99/x81", "CYRILLIC SMALL LETTER ZEMLYA");
   ("/xea/x99/x82", "CYRILLIC CAPITAL LETTER DZELO");
   ("/xea/x99/x83", "CYRILLIC SMALL LETTER DZELO");
   ("/xea/x99/x84", "CYRILLIC CAPITAL LETTER REVERSED DZE");
   ("/xea/x99/x85", "CYRILLIC SMALL LETTER REVERSED DZE");
   ("/xea/x99/x86", "CYRILLIC CAPITAL LETTER IOTA");
   ("/xea/x99/x87", "CYRILLIC SMALL LETTER IOTA");
   ("/xea/x99/x88", "CYRILLIC CAPITAL LETTER DJERV");
   ("/xea/x99/x89", "CYRILLIC SMALL LETTER DJERV");
   ("/xea/x99/x8a", "CYRILLIC CAPITAL LETTER MONOGRAPH UK");
   ("/xea/x99/x8b", "CYRILLIC SMALL LETTER MONOGRAPH UK");
   ("/xea/x99/x8c", "CYRILLIC CAPITAL LETTER BROAD OMEGA");
   ("/xea/x99/x8d", "CYRILLIC SMALL LETTER BROAD OMEGA");
   ("/xea/x99/x8e", "CYRILLIC CAPITAL LETTER NEUTRAL YER");
   ("/xea/x99/x8f", "CYRILLIC SMALL LETTER NEUTRAL YER");
   ("/xea/x99/x90", "CYRILLIC CAPITAL LETTER YERU WITH BACK YER");
   ("/xea/x99/x91", "CYRILLIC SMALL LETTER YERU WITH BACK YER");
   ("/xea/x99/x92", "CYRILLIC CAPITAL LETTER IOTIFIED YAT");
   ("/xea/x99/x93", "CYRILLIC SMALL LETTER IOTIFIED YAT");
   ("/xea/x99/x94", "CYRILLIC CAPITAL LETTER REVERSED YU");
   ("/xea/x99/x95", "CYRILLIC SMALL LETTER REVERSED YU");
   ("/xea/x99/x96", "CYRILLIC CAPITAL LETTER IOTIFIED A");
   ("/xea/x99/x97", "CYRILLIC SMALL LETTER IOTIFIED A");
   ("/xea/x99/x98", "CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS");
   ("/xea/x99/x99", "CYRILLIC SMALL LETTER CLOSED LITTLE YUS");
   ("/xea/x99/x9a", "CYRILLIC CAPITAL LETTER BLENDED YUS");
   ("/xea/x99/x9b", "CYRILLIC SMALL LETTER BLENDED YUS");
   ("/xea/x99/x9c", "CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS");
   ("/xea/x99/x9d", "CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS");
   ("/xea/x99/x9e", "CYRILLIC CAPITAL LETTER YN");
   ("/xea/x99/x9f", "CYRILLIC SMALL LETTER YN");
   ("/xea/x99/xa2", "CYRILLIC CAPITAL LETTER SOFT DE");
   ("/xea/x99/xa3", "CYRILLIC SMALL LETTER SOFT DE");
   ("/xea/x99/xa4", "CYRILLIC CAPITAL LETTER SOFT EL");
   ("/xea/x99/xa5", "CYRILLIC SMALL LETTER SOFT EL");
   ("/xea/x99/xa6", "CYRILLIC CAPITAL LETTER SOFT EM");
   ("/xea/x99/xa7", "CYRILLIC SMALL LETTER SOFT EM");
   ("/xea/x99/xa8", "CYRILLIC CAPITAL LETTER MONOCULAR O");
   ("/xea/x99/xa9", "CYRILLIC SMALL LETTER MONOCULAR O");
   ("/xea/x99/xaa", "CYRILLIC CAPITAL LETTER BINOCULAR O");
   ("/xea/x99/xab", "CYRILLIC SMALL LETTER BINOCULAR O");
   ("/xea/x99/xac", "CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O");
   ("/xea/x99/xad", "CYRILLIC SMALL LETTER DOUBLE MONOCULAR O");
   ("/xea/x9a/x80", "CYRILLIC CAPITAL LETTER DWE");
   ("/xea/x9a/x81", "CYRILLIC SMALL LETTER DWE");
   ("/xea/x9a/x82", "CYRILLIC CAPITAL LETTER DZWE");
   ("/xea/x9a/x83", "CYRILLIC SMALL LETTER DZWE");
   ("/xea/x9a/x84", "CYRILLIC CAPITAL LETTER ZHWE");
   ("/xea/x9a/x85", "CYRILLIC SMALL LETTER ZHWE");
   ("/xea/x9a/x86", "CYRILLIC CAPITAL LETTER CCHE");
   ("/xea/x9a/x87", "CYRILLIC SMALL LETTER CCHE");
   ("/xea/x9a/x88", "CYRILLIC CAPITAL LETTER DZZE");
   ("/xea/x9a/x89", "CYRILLIC SMALL LETTER DZZE");
   ("/xea/x9a/x8a", "CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK");
   ("/xea/x9a/x8b", "CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK");
   ("/xea/x9a/x8c", "CYRILLIC CAPITAL LETTER TWE");
   ("/xea/x9a/x8d", "CYRILLIC SMALL LETTER TWE");
   ("/xea/x9a/x8e", "CYRILLIC CAPITAL LETTER TSWE");
   ("/xea/x9a/x8f", "CYRILLIC SMALL LETTER TSWE");
   ("/xea/x9a/x90", "CYRILLIC CAPITAL LETTER TSSE");
   ("/xea/x9a/x91", "CYRILLIC SMALL LETTER TSSE");
   ("/xea/x9a/x92", "CYRILLIC CAPITAL LETTER TCHE");
   ("/xea/x9a/x93", "CYRILLIC SMALL LETTER TCHE");
   ("/xea/x9a/x94", "CYRILLIC CAPITAL LETTER HWE");
   ("/xea/x9a/x95", "CYRILLIC SMALL LETTER HWE");
   ("/xea/x9a/x96", "CYRILLIC CAPITAL LETTER SHWE");
   ("/xea/x9a/x97", "CYRILLIC SMALL LETTER SHWE");
   ("/xea/x9c/xa2", "LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF");
   ("/xea/x9c/xa3", "LATIN SMALL LETTER EGYPTOLOGICAL ALEF");
   ("/xea/x9c/xa4", "LATIN CAPITAL LETTER EGYPTOLOGICAL AIN");
   ("/xea/x9c/xa5", "LATIN SMALL LETTER EGYPTOLOGICAL AIN");
   ("/xea/x9c/xa6", "LATIN CAPITAL LETTER HENG");
   ("/xea/x9c/xa7", "LATIN SMALL LETTER HENG");
   ("/xea/x9c/xa8", "LATIN CAPITAL LETTER TZ");
   ("/xea/x9c/xa9", "LATIN SMALL LETTER TZ");
   ("/xea/x9c/xaa", "LATIN CAPITAL LETTER TRESILLO");
   ("/xea/x9c/xab", "LATIN SMALL LETTER TRESILLO");
   ("/xea/x9c/xac", "LATIN CAPITAL LETTER CUATRILLO");
   ("/xea/x9c/xad", "LATIN SMALL LETTER CUATRILLO");
   ("/xea/x9c/xae", "LATIN CAPITAL LETTER CUATRILLO WITH COMMA");
   ("/xea/x9c/xaf", "LATIN SMALL LETTER CUATRILLO WITH COMMA");
   ("/xea/x9c/xb0", "LATIN LETTER SMALL CAPITAL F");
   ("/xea/x9c/xb1", "LATIN LETTER SMALL CAPITAL S");
   ("/xea/x9c/xb2", "LATIN CAPITAL LETTER AA");
   ("/xea/x9c/xb3", "LATIN SMALL LETTER AA");
   ("/xea/x9c/xb4", "LATIN CAPITAL LETTER AO");
   ("/xea/x9c/xb5", "LATIN SMALL LETTER AO");
   ("/xea/x9c/xb6", "LATIN CAPITAL LETTER AU");
   ("/xea/x9c/xb7", "LATIN SMALL LETTER AU");
   ("/xea/x9c/xb8", "LATIN CAPITAL LETTER AV");
   ("/xea/x9c/xb9", "LATIN SMALL LETTER AV");
   ("/xea/x9c/xba", "LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR");
   ("/xea/x9c/xbb", "LATIN SMALL LETTER AV WITH HORIZONTAL BAR");
   ("/xea/x9c/xbc", "LATIN CAPITAL LETTER AY");
   ("/xea/x9c/xbd", "LATIN SMALL LETTER AY");
   ("/xea/x9c/xbe", "LATIN CAPITAL LETTER REVERSED C WITH DOT");
   ("/xea/x9c/xbf", "LATIN SMALL LETTER REVERSED C WITH DOT");
   ("/xea/x9d/x80", "LATIN CAPITAL LETTER K WITH STROKE");
   ("/xea/x9d/x81", "LATIN SMALL LETTER K WITH STROKE");
   ("/xea/x9d/x82", "LATIN CAPITAL LETTER K WITH DIAGONAL STROKE");
   ("/xea/x9d/x83", "LATIN SMALL LETTER K WITH DIAGONAL STROKE");
   ("/xea/x9d/x84", "LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE");
   ("/xea/x9d/x85", "LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE");
   ("/xea/x9d/x86", "LATIN CAPITAL LETTER BROKEN L");
   ("/xea/x9d/x87", "LATIN SMALL LETTER BROKEN L");
   ("/xea/x9d/x88", "LATIN CAPITAL LETTER L WITH HIGH STROKE");
   ("/xea/x9d/x89", "LATIN SMALL LETTER L WITH HIGH STROKE");
   ("/xea/x9d/x8a", "LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY");
   ("/xea/x9d/x8b", "LATIN SMALL LETTER O WITH LONG STROKE OVERLAY");
   ("/xea/x9d/x8c", "LATIN CAPITAL LETTER O WITH LOOP");
   ("/xea/x9d/x8d", "LATIN SMALL LETTER O WITH LOOP");
   ("/xea/x9d/x8e", "LATIN CAPITAL LETTER OO");
   ("/xea/x9d/x8f", "LATIN SMALL LETTER OO");
   ("/xea/x9d/x90", "LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER");
   ("/xea/x9d/x91", "LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER");
   ("/xea/x9d/x92", "LATIN CAPITAL LETTER P WITH FLOURISH");
   ("/xea/x9d/x93", "LATIN SMALL LETTER P WITH FLOURISH");
   ("/xea/x9d/x94", "LATIN CAPITAL LETTER P WITH SQUIRREL TAIL");
   ("/xea/x9d/x95", "LATIN SMALL LETTER P WITH SQUIRREL TAIL");
   ("/xea/x9d/x96", "LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER");
   ("/xea/x9d/x97", "LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER");
   ("/xea/x9d/x98", "LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE");
   ("/xea/x9d/x99", "LATIN SMALL LETTER Q WITH DIAGONAL STROKE");
   ("/xea/x9d/x9a", "LATIN CAPITAL LETTER R ROTUNDA");
   ("/xea/x9d/x9b", "LATIN SMALL LETTER R ROTUNDA");
   ("/xea/x9d/x9c", "LATIN CAPITAL LETTER RUM ROTUNDA");
   ("/xea/x9d/x9d", "LATIN SMALL LETTER RUM ROTUNDA");
   ("/xea/x9d/x9e", "LATIN CAPITAL LETTER V WITH DIAGONAL STROKE");
   ("/xea/x9d/x9f", "LATIN SMALL LETTER V WITH DIAGONAL STROKE");
   ("/xea/x9d/xa0", "LATIN CAPITAL LETTER VY");
   ("/xea/x9d/xa1", "LATIN SMALL LETTER VY");
   ("/xea/x9d/xa2", "LATIN CAPITAL LETTER VISIGOTHIC Z");
   ("/xea/x9d/xa3", "LATIN SMALL LETTER VISIGOTHIC Z");
   ("/xea/x9d/xa4", "LATIN CAPITAL LETTER THORN WITH STROKE");
   ("/xea/x9d/xa5", "LATIN SMALL LETTER THORN WITH STROKE");
   ("/xea/x9d/xa6", "LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER");
   ("/xea/x9d/xa7", "LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER");
   ("/xea/x9d/xa8", "LATIN CAPITAL LETTER VEND");
   ("/xea/x9d/xa9", "LATIN SMALL LETTER VEND");
   ("/xea/x9d/xaa", "LATIN CAPITAL LETTER ET");
   ("/xea/x9d/xab", "LATIN SMALL LETTER ET");
   ("/xea/x9d/xac", "LATIN CAPITAL LETTER IS");
   ("/xea/x9d/xad", "LATIN SMALL LETTER IS");
   ("/xea/x9d/xae", "LATIN CAPITAL LETTER CON");
   ("/xea/x9d/xaf", "LATIN SMALL LETTER CON");
   ("/xea/x9d/xb1", "LATIN SMALL LETTER DUM");
   ("/xea/x9d/xb2", "LATIN SMALL LETTER LUM");
   ("/xea/x9d/xb3", "LATIN SMALL LETTER MUM");
   ("/xea/x9d/xb4", "LATIN SMALL LETTER NUM");
   ("/xea/x9d/xb5", "LATIN SMALL LETTER RUM");
   ("/xea/x9d/xb6", "LATIN LETTER SMALL CAPITAL RUM");
   ("/xea/x9d/xb7", "LATIN SMALL LETTER TUM");
   ("/xea/x9d/xb8", "LATIN SMALL LETTER UM");
   ("/xea/x9d/xb9", "LATIN CAPITAL LETTER INSULAR D");
   ("/xea/x9d/xba", "LATIN SMALL LETTER INSULAR D");
   ("/xea/x9d/xbb", "LATIN CAPITAL LETTER INSULAR F");
   ("/xea/x9d/xbc", "LATIN SMALL LETTER INSULAR F");
   ("/xea/x9d/xbd", "LATIN CAPITAL LETTER INSULAR G");
   ("/xea/x9d/xbe", "LATIN CAPITAL LETTER TURNED INSULAR G");
   ("/xea/x9d/xbf", "LATIN SMALL LETTER TURNED INSULAR G");
   ("/xea/x9e/x80", "LATIN CAPITAL LETTER TURNED L");
   ("/xea/x9e/x81", "LATIN SMALL LETTER TURNED L");
   ("/xea/x9e/x82", "LATIN CAPITAL LETTER INSULAR R");
   ("/xea/x9e/x83", "LATIN SMALL LETTER INSULAR R");
   ("/xea/x9e/x84", "LATIN CAPITAL LETTER INSULAR S");
   ("/xea/x9e/x85", "LATIN SMALL LETTER INSULAR S");
   ("/xea/x9e/x86", "LATIN CAPITAL LETTER INSULAR T");
   ("/xea/x9e/x87", "LATIN SMALL LETTER INSULAR T");
   ("/xea/x9e/x8b", "LATIN CAPITAL LETTER SALTILLO");
   ("/xea/x9e/x8c", "LATIN SMALL LETTER SALTILLO");
   ("/xea/xa1/x96", "PHAGS-PA LETTER SMALL A");
   ("/xef/xac/x80", "LATIN SMALL LIGATURE FF");
   ("/xef/xac/x81", "LATIN SMALL LIGATURE FI");
   ("/xef/xac/x82", "LATIN SMALL LIGATURE FL");
   ("/xef/xac/x83", "LATIN SMALL LIGATURE FFI");
   ("/xef/xac/x84", "LATIN SMALL LIGATURE FFL");
   ("/xef/xac/x85", "LATIN SMALL LIGATURE LONG S T");
   ("/xef/xac/x86", "LATIN SMALL LIGATURE ST");
   ("/xef/xac/x93", "ARMENIAN SMALL LIGATURE MEN NOW");
   ("/xef/xac/x94", "ARMENIAN SMALL LIGATURE MEN ECH");
   ("/xef/xac/x95", "ARMENIAN SMALL LIGATURE MEN INI");
   ("/xef/xac/x96", "ARMENIAN SMALL LIGATURE VEW NOW");
   ("/xef/xac/x97", "ARMENIAN SMALL LIGATURE MEN XEH");
   ("/xef/xb9/x90", "SMALL COMMA");
   ("/xef/xb9/x91", "SMALL IDEOGRAPHIC COMMA");
   ("/xef/xb9/x92", "SMALL FULL STOP");
   ("/xef/xb9/x94", "SMALL SEMICOLON");
   ("/xef/xb9/x95", "SMALL COLON");
   ("/xef/xb9/x96", "SMALL QUESTION MARK");
   ("/xef/xb9/x97", "SMALL EXCLAMATION MARK");
   ("/xef/xb9/x98", "SMALL EM DASH");
   ("/xef/xb9/x99", "SMALL LEFT PARENTHESIS");
   ("/xef/xb9/x9a", "SMALL RIGHT PARENTHESIS");
   ("/xef/xb9/x9b", "SMALL LEFT CURLY BRACKET");
   ("/xef/xb9/x9c", "SMALL RIGHT CURLY BRACKET");
   ("/xef/xb9/x9d", "SMALL LEFT TORTOISE SHELL BRACKET");
   ("/xef/xb9/x9e", "SMALL RIGHT TORTOISE SHELL BRACKET");
   ("/xef/xb9/x9f", "SMALL NUMBER SIGN");
   ("/xef/xb9/xa0", "SMALL AMPERSAND");
   ("/xef/xb9/xa1", "SMALL ASTERISK");
   ("/xef/xb9/xa2", "SMALL PLUS SIGN");
   ("/xef/xb9/xa3", "SMALL HYPHEN-MINUS");
   ("/xef/xb9/xa4", "SMALL LESS-THAN SIGN");
   ("/xef/xb9/xa5", "SMALL GREATER-THAN SIGN");
   ("/xef/xb9/xa6", "SMALL EQUALS SIGN");
   ("/xef/xb9/xa8", "SMALL REVERSE SOLIDUS");
   ("/xef/xb9/xa9", "SMALL DOLLAR SIGN");
   ("/xef/xb9/xaa", "SMALL PERCENT SIGN");
   ("/xef/xb9/xab", "SMALL COMMERCIAL AT");
   ("/xef/xbc/xa1", "FULLWIDTH LATIN CAPITAL LETTER A");
   ("/xef/xbc/xa2", "FULLWIDTH LATIN CAPITAL LETTER B");
   ("/xef/xbc/xa3", "FULLWIDTH LATIN CAPITAL LETTER C");
   ("/xef/xbc/xa4", "FULLWIDTH LATIN CAPITAL LETTER D");
   ("/xef/xbc/xa5", "FULLWIDTH LATIN CAPITAL LETTER E");
   ("/xef/xbc/xa6", "FULLWIDTH LATIN CAPITAL LETTER F");
   ("/xef/xbc/xa7", "FULLWIDTH LATIN CAPITAL LETTER G");
   ("/xef/xbc/xa8", "FULLWIDTH LATIN CAPITAL LETTER H");
   ("/xef/xbc/xa9", "FULLWIDTH LATIN CAPITAL LETTER I");
   ("/xef/xbc/xaa", "FULLWIDTH LATIN CAPITAL LETTER J");
   ("/xef/xbc/xab", "FULLWIDTH LATIN CAPITAL LETTER K");
   ("/xef/xbc/xac", "FULLWIDTH LATIN CAPITAL LETTER L");
   ("/xef/xbc/xad", "FULLWIDTH LATIN CAPITAL LETTER M");
   ("/xef/xbc/xae", "FULLWIDTH LATIN CAPITAL LETTER N");
   ("/xef/xbc/xaf", "FULLWIDTH LATIN CAPITAL LETTER O");
   ("/xef/xbc/xb0", "FULLWIDTH LATIN CAPITAL LETTER P");
   ("/xef/xbc/xb1", "FULLWIDTH LATIN CAPITAL LETTER Q");
   ("/xef/xbc/xb2", "FULLWIDTH LATIN CAPITAL LETTER R");
   ("/xef/xbc/xb3", "FULLWIDTH LATIN CAPITAL LETTER S");
   ("/xef/xbc/xb4", "FULLWIDTH LATIN CAPITAL LETTER T");
   ("/xef/xbc/xb5", "FULLWIDTH LATIN CAPITAL LETTER U");
   ("/xef/xbc/xb6", "FULLWIDTH LATIN CAPITAL LETTER V");
   ("/xef/xbc/xb7", "FULLWIDTH LATIN CAPITAL LETTER W");
   ("/xef/xbc/xb8", "FULLWIDTH LATIN CAPITAL LETTER X");
   ("/xef/xbc/xb9", "FULLWIDTH LATIN CAPITAL LETTER Y");
   ("/xef/xbc/xba", "FULLWIDTH LATIN CAPITAL LETTER Z");
   ("/xef/xbd/x81", "FULLWIDTH LATIN SMALL LETTER A");
   ("/xef/xbd/x82", "FULLWIDTH LATIN SMALL LETTER B");
   ("/xef/xbd/x83", "FULLWIDTH LATIN SMALL LETTER C");
   ("/xef/xbd/x84", "FULLWIDTH LATIN SMALL LETTER D");
   ("/xef/xbd/x85", "FULLWIDTH LATIN SMALL LETTER E");
   ("/xef/xbd/x86", "FULLWIDTH LATIN SMALL LETTER F");
   ("/xef/xbd/x87", "FULLWIDTH LATIN SMALL LETTER G");
   ("/xef/xbd/x88", "FULLWIDTH LATIN SMALL LETTER H");
   ("/xef/xbd/x89", "FULLWIDTH LATIN SMALL LETTER I");
   ("/xef/xbd/x8a", "FULLWIDTH LATIN SMALL LETTER J");
   ("/xef/xbd/x8b", "FULLWIDTH LATIN SMALL LETTER K");
   ("/xef/xbd/x8c", "FULLWIDTH LATIN SMALL LETTER L");
   ("/xef/xbd/x8d", "FULLWIDTH LATIN SMALL LETTER M");
   ("/xef/xbd/x8e", "FULLWIDTH LATIN SMALL LETTER N");
   ("/xef/xbd/x8f", "FULLWIDTH LATIN SMALL LETTER O");
   ("/xef/xbd/x90", "FULLWIDTH LATIN SMALL LETTER P");
   ("/xef/xbd/x91", "FULLWIDTH LATIN SMALL LETTER Q");
   ("/xef/xbd/x92", "FULLWIDTH LATIN SMALL LETTER R");
   ("/xef/xbd/x93", "FULLWIDTH LATIN SMALL LETTER S");
   ("/xef/xbd/x94", "FULLWIDTH LATIN SMALL LETTER T");
   ("/xef/xbd/x95", "FULLWIDTH LATIN SMALL LETTER U");
   ("/xef/xbd/x96", "FULLWIDTH LATIN SMALL LETTER V");
   ("/xef/xbd/x97", "FULLWIDTH LATIN SMALL LETTER W");
   ("/xef/xbd/x98", "FULLWIDTH LATIN SMALL LETTER X");
   ("/xef/xbd/x99", "FULLWIDTH LATIN SMALL LETTER Y");
   ("/xef/xbd/x9a", "FULLWIDTH LATIN SMALL LETTER Z");
   ("/xef/xbd/xa7", "HALFWIDTH KATAKANA LETTER SMALL A");
   ("/xef/xbd/xa8", "HALFWIDTH KATAKANA LETTER SMALL I");
   ("/xef/xbd/xa9", "HALFWIDTH KATAKANA LETTER SMALL U");
   ("/xef/xbd/xaa", "HALFWIDTH KATAKANA LETTER SMALL E");
   ("/xef/xbd/xab", "HALFWIDTH KATAKANA LETTER SMALL O");
   ("/xef/xbd/xac", "HALFWIDTH KATAKANA LETTER SMALL YA");
   ("/xef/xbd/xad", "HALFWIDTH KATAKANA LETTER SMALL YU");
   ("/xef/xbd/xae", "HALFWIDTH KATAKANA LETTER SMALL YO");
   ("/xef/xbd/xaf", "HALFWIDTH KATAKANA LETTER SMALL TU");
   ("/xf0/x90/x87/xbb", "PHAISTOS DISC SIGN SMALL AXE");
   ("/xf0/x90/x90/x80", "DESERET CAPITAL LETTER LONG I");
   ("/xf0/x90/x90/x81", "DESERET CAPITAL LETTER LONG E");
   ("/xf0/x90/x90/x82", "DESERET CAPITAL LETTER LONG A");
   ("/xf0/x90/x90/x83", "DESERET CAPITAL LETTER LONG AH");
   ("/xf0/x90/x90/x84", "DESERET CAPITAL LETTER LONG O");
   ("/xf0/x90/x90/x85", "DESERET CAPITAL LETTER LONG OO");
   ("/xf0/x90/x90/x86", "DESERET CAPITAL LETTER SHORT I");
   ("/xf0/x90/x90/x87", "DESERET CAPITAL LETTER SHORT E");
   ("/xf0/x90/x90/x88", "DESERET CAPITAL LETTER SHORT A");
   ("/xf0/x90/x90/x89", "DESERET CAPITAL LETTER SHORT AH");
   ("/xf0/x90/x90/x8a", "DESERET CAPITAL LETTER SHORT O");
   ("/xf0/x90/x90/x8b", "DESERET CAPITAL LETTER SHORT OO");
   ("/xf0/x90/x90/x8c", "DESERET CAPITAL LETTER AY");
   ("/xf0/x90/x90/x8d", "DESERET CAPITAL LETTER OW");
   ("/xf0/x90/x90/x8e", "DESERET CAPITAL LETTER WU");
   ("/xf0/x90/x90/x8f", "DESERET CAPITAL LETTER YEE");
   ("/xf0/x90/x90/x90", "DESERET CAPITAL LETTER H");
   ("/xf0/x90/x90/x91", "DESERET CAPITAL LETTER PEE");
   ("/xf0/x90/x90/x92", "DESERET CAPITAL LETTER BEE");
   ("/xf0/x90/x90/x93", "DESERET CAPITAL LETTER TEE");
   ("/xf0/x90/x90/x94", "DESERET CAPITAL LETTER DEE");
   ("/xf0/x90/x90/x95", "DESERET CAPITAL LETTER CHEE");
   ("/xf0/x90/x90/x96", "DESERET CAPITAL LETTER JEE");
   ("/xf0/x90/x90/x97", "DESERET CAPITAL LETTER KAY");
   ("/xf0/x90/x90/x98", "DESERET CAPITAL LETTER GAY");
   ("/xf0/x90/x90/x99", "DESERET CAPITAL LETTER EF");
   ("/xf0/x90/x90/x9a", "DESERET CAPITAL LETTER VEE");
   ("/xf0/x90/x90/x9b", "DESERET CAPITAL LETTER ETH");
   ("/xf0/x90/x90/x9c", "DESERET CAPITAL LETTER THEE");
   ("/xf0/x90/x90/x9d", "DESERET CAPITAL LETTER ES");
   ("/xf0/x90/x90/x9e", "DESERET CAPITAL LETTER ZEE");
   ("/xf0/x90/x90/x9f", "DESERET CAPITAL LETTER ESH");
   ("/xf0/x90/x90/xa0", "DESERET CAPITAL LETTER ZHEE");
   ("/xf0/x90/x90/xa1", "DESERET CAPITAL LETTER ER");
   ("/xf0/x90/x90/xa2", "DESERET CAPITAL LETTER EL");
   ("/xf0/x90/x90/xa3", "DESERET CAPITAL LETTER EM");
   ("/xf0/x90/x90/xa4", "DESERET CAPITAL LETTER EN");
   ("/xf0/x90/x90/xa5", "DESERET CAPITAL LETTER ENG");
   ("/xf0/x90/x90/xa6", "DESERET CAPITAL LETTER OI");
   ("/xf0/x90/x90/xa7", "DESERET CAPITAL LETTER EW");
   ("/xf0/x90/x90/xa8", "DESERET SMALL LETTER LONG I");
   ("/xf0/x90/x90/xa9", "DESERET SMALL LETTER LONG E");
   ("/xf0/x90/x90/xaa", "DESERET SMALL LETTER LONG A");
   ("/xf0/x90/x90/xab", "DESERET SMALL LETTER LONG AH");
   ("/xf0/x90/x90/xac", "DESERET SMALL LETTER LONG O");
   ("/xf0/x90/x90/xad", "DESERET SMALL LETTER LONG OO");
   ("/xf0/x90/x90/xae", "DESERET SMALL LETTER SHORT I");
   ("/xf0/x90/x90/xaf", "DESERET SMALL LETTER SHORT E");
   ("/xf0/x90/x90/xb0", "DESERET SMALL LETTER SHORT A");
   ("/xf0/x90/x90/xb1", "DESERET SMALL LETTER SHORT AH");
   ("/xf0/x90/x90/xb2", "DESERET SMALL LETTER SHORT O");
   ("/xf0/x90/x90/xb3", "DESERET SMALL LETTER SHORT OO");
   ("/xf0/x90/x90/xb4", "DESERET SMALL LETTER AY");
   ("/xf0/x90/x90/xb5", "DESERET SMALL LETTER OW");
   ("/xf0/x90/x90/xb6", "DESERET SMALL LETTER WU");
   ("/xf0/x90/x90/xb7", "DESERET SMALL LETTER YEE");
   ("/xf0/x90/x90/xb8", "DESERET SMALL LETTER H");
   ("/xf0/x90/x90/xb9", "DESERET SMALL LETTER PEE");
   ("/xf0/x90/x90/xba", "DESERET SMALL LETTER BEE");
   ("/xf0/x90/x90/xbb", "DESERET SMALL LETTER TEE");
   ("/xf0/x90/x90/xbc", "DESERET SMALL LETTER DEE");
   ("/xf0/x90/x90/xbd", "DESERET SMALL LETTER CHEE");
   ("/xf0/x90/x90/xbe", "DESERET SMALL LETTER JEE");
   ("/xf0/x90/x90/xbf", "DESERET SMALL LETTER KAY");
   ("/xf0/x90/x91/x80", "DESERET SMALL LETTER GAY");
   ("/xf0/x90/x91/x81", "DESERET SMALL LETTER EF");
   ("/xf0/x90/x91/x82", "DESERET SMALL LETTER VEE");
   ("/xf0/x90/x91/x83", "DESERET SMALL LETTER ETH");
   ("/xf0/x90/x91/x84", "DESERET SMALL LETTER THEE");
   ("/xf0/x90/x91/x85", "DESERET SMALL LETTER ES");
   ("/xf0/x90/x91/x86", "DESERET SMALL LETTER ZEE");
   ("/xf0/x90/x91/x87", "DESERET SMALL LETTER ESH");
   ("/xf0/x90/x91/x88", "DESERET SMALL LETTER ZHEE");
   ("/xf0/x90/x91/x89", "DESERET SMALL LETTER ER");
   ("/xf0/x90/x91/x8a", "DESERET SMALL LETTER EL");
   ("/xf0/x90/x91/x8b", "DESERET SMALL LETTER EM");
   ("/xf0/x90/x91/x8c", "DESERET SMALL LETTER EN");
   ("/xf0/x90/x91/x8d", "DESERET SMALL LETTER ENG");
   ("/xf0/x90/x91/x8e", "DESERET SMALL LETTER OI");
   ("/xf0/x90/x91/x8f", "DESERET SMALL LETTER EW");
   ("/xf0/x90/xa9/x91", "KHAROSHTHI PUNCTUATION SMALL CIRCLE");
   ("/xf0/x9d/x8c/x8a", "TETRAGRAM FOR KEEPING SMALL");
   ("/xf0/x9d/x90/x80", "MATHEMATICAL BOLD CAPITAL A");
   ("/xf0/x9d/x90/x81", "MATHEMATICAL BOLD CAPITAL B");
   ("/xf0/x9d/x90/x82", "MATHEMATICAL BOLD CAPITAL C");
   ("/xf0/x9d/x90/x83", "MATHEMATICAL BOLD CAPITAL D");
   ("/xf0/x9d/x90/x84", "MATHEMATICAL BOLD CAPITAL E");
   ("/xf0/x9d/x90/x85", "MATHEMATICAL BOLD CAPITAL F");
   ("/xf0/x9d/x90/x86", "MATHEMATICAL BOLD CAPITAL G");
   ("/xf0/x9d/x90/x87", "MATHEMATICAL BOLD CAPITAL H");
   ("/xf0/x9d/x90/x88", "MATHEMATICAL BOLD CAPITAL I");
   ("/xf0/x9d/x90/x89", "MATHEMATICAL BOLD CAPITAL J");
   ("/xf0/x9d/x90/x8a", "MATHEMATICAL BOLD CAPITAL K");
   ("/xf0/x9d/x90/x8b", "MATHEMATICAL BOLD CAPITAL L");
   ("/xf0/x9d/x90/x8c", "MATHEMATICAL BOLD CAPITAL M");
   ("/xf0/x9d/x90/x8d", "MATHEMATICAL BOLD CAPITAL N");
   ("/xf0/x9d/x90/x8e", "MATHEMATICAL BOLD CAPITAL O");
   ("/xf0/x9d/x90/x8f", "MATHEMATICAL BOLD CAPITAL P");
   ("/xf0/x9d/x90/x90", "MATHEMATICAL BOLD CAPITAL Q");
   ("/xf0/x9d/x90/x91", "MATHEMATICAL BOLD CAPITAL R");
   ("/xf0/x9d/x90/x92", "MATHEMATICAL BOLD CAPITAL S");
   ("/xf0/x9d/x90/x93", "MATHEMATICAL BOLD CAPITAL T");
   ("/xf0/x9d/x90/x94", "MATHEMATICAL BOLD CAPITAL U");
   ("/xf0/x9d/x90/x95", "MATHEMATICAL BOLD CAPITAL V");
   ("/xf0/x9d/x90/x96", "MATHEMATICAL BOLD CAPITAL W");
   ("/xf0/x9d/x90/x97", "MATHEMATICAL BOLD CAPITAL X");
   ("/xf0/x9d/x90/x98", "MATHEMATICAL BOLD CAPITAL Y");
   ("/xf0/x9d/x90/x99", "MATHEMATICAL BOLD CAPITAL Z");
   ("/xf0/x9d/x90/x9a", "MATHEMATICAL BOLD SMALL A");
   ("/xf0/x9d/x90/x9b", "MATHEMATICAL BOLD SMALL B");
   ("/xf0/x9d/x90/x9c", "MATHEMATICAL BOLD SMALL C");
   ("/xf0/x9d/x90/x9d", "MATHEMATICAL BOLD SMALL D");
   ("/xf0/x9d/x90/x9e", "MATHEMATICAL BOLD SMALL E");
   ("/xf0/x9d/x90/x9f", "MATHEMATICAL BOLD SMALL F");
   ("/xf0/x9d/x90/xa0", "MATHEMATICAL BOLD SMALL G");
   ("/xf0/x9d/x90/xa1", "MATHEMATICAL BOLD SMALL H");
   ("/xf0/x9d/x90/xa2", "MATHEMATICAL BOLD SMALL I");
   ("/xf0/x9d/x90/xa3", "MATHEMATICAL BOLD SMALL J");
   ("/xf0/x9d/x90/xa4", "MATHEMATICAL BOLD SMALL K");
   ("/xf0/x9d/x90/xa5", "MATHEMATICAL BOLD SMALL L");
   ("/xf0/x9d/x90/xa6", "MATHEMATICAL BOLD SMALL M");
   ("/xf0/x9d/x90/xa7", "MATHEMATICAL BOLD SMALL N");
   ("/xf0/x9d/x90/xa8", "MATHEMATICAL BOLD SMALL O");
   ("/xf0/x9d/x90/xa9", "MATHEMATICAL BOLD SMALL P");
   ("/xf0/x9d/x90/xaa", "MATHEMATICAL BOLD SMALL Q");
   ("/xf0/x9d/x90/xab", "MATHEMATICAL BOLD SMALL R");
   ("/xf0/x9d/x90/xac", "MATHEMATICAL BOLD SMALL S");
   ("/xf0/x9d/x90/xad", "MATHEMATICAL BOLD SMALL T");
   ("/xf0/x9d/x90/xae", "MATHEMATICAL BOLD SMALL U");
   ("/xf0/x9d/x90/xaf", "MATHEMATICAL BOLD SMALL V");
   ("/xf0/x9d/x90/xb0", "MATHEMATICAL BOLD SMALL W");
   ("/xf0/x9d/x90/xb1", "MATHEMATICAL BOLD SMALL X");
   ("/xf0/x9d/x90/xb2", "MATHEMATICAL BOLD SMALL Y");
   ("/xf0/x9d/x90/xb3", "MATHEMATICAL BOLD SMALL Z");
   ("/xf0/x9d/x90/xb4", "MATHEMATICAL ITALIC CAPITAL A");
   ("/xf0/x9d/x90/xb5", "MATHEMATICAL ITALIC CAPITAL B");
   ("/xf0/x9d/x90/xb6", "MATHEMATICAL ITALIC CAPITAL C");
   ("/xf0/x9d/x90/xb7", "MATHEMATICAL ITALIC CAPITAL D");
   ("/xf0/x9d/x90/xb8", "MATHEMATICAL ITALIC CAPITAL E");
   ("/xf0/x9d/x90/xb9", "MATHEMATICAL ITALIC CAPITAL F");
   ("/xf0/x9d/x90/xba", "MATHEMATICAL ITALIC CAPITAL G");
   ("/xf0/x9d/x90/xbb", "MATHEMATICAL ITALIC CAPITAL H");
   ("/xf0/x9d/x90/xbc", "MATHEMATICAL ITALIC CAPITAL I");
   ("/xf0/x9d/x90/xbd", "MATHEMATICAL ITALIC CAPITAL J");
   ("/xf0/x9d/x90/xbe", "MATHEMATICAL ITALIC CAPITAL K");
   ("/xf0/x9d/x90/xbf", "MATHEMATICAL ITALIC CAPITAL L");
   ("/xf0/x9d/x91/x80", "MATHEMATICAL ITALIC CAPITAL M");
   ("/xf0/x9d/x91/x81", "MATHEMATICAL ITALIC CAPITAL N");
   ("/xf0/x9d/x91/x82", "MATHEMATICAL ITALIC CAPITAL O");
   ("/xf0/x9d/x91/x83", "MATHEMATICAL ITALIC CAPITAL P");
   ("/xf0/x9d/x91/x84", "MATHEMATICAL ITALIC CAPITAL Q");
   ("/xf0/x9d/x91/x85", "MATHEMATICAL ITALIC CAPITAL R");
   ("/xf0/x9d/x91/x86", "MATHEMATICAL ITALIC CAPITAL S");
   ("/xf0/x9d/x91/x87", "MATHEMATICAL ITALIC CAPITAL T");
   ("/xf0/x9d/x91/x88", "MATHEMATICAL ITALIC CAPITAL U");
   ("/xf0/x9d/x91/x89", "MATHEMATICAL ITALIC CAPITAL V");
   ("/xf0/x9d/x91/x8a", "MATHEMATICAL ITALIC CAPITAL W");
   ("/xf0/x9d/x91/x8b", "MATHEMATICAL ITALIC CAPITAL X");
   ("/xf0/x9d/x91/x8c", "MATHEMATICAL ITALIC CAPITAL Y");
   ("/xf0/x9d/x91/x8d", "MATHEMATICAL ITALIC CAPITAL Z");
   ("/xf0/x9d/x91/x8e", "MATHEMATICAL ITALIC SMALL A");
   ("/xf0/x9d/x91/x8f", "MATHEMATICAL ITALIC SMALL B");
   ("/xf0/x9d/x91/x90", "MATHEMATICAL ITALIC SMALL C");
   ("/xf0/x9d/x91/x91", "MATHEMATICAL ITALIC SMALL D");
   ("/xf0/x9d/x91/x92", "MATHEMATICAL ITALIC SMALL E");
   ("/xf0/x9d/x91/x93", "MATHEMATICAL ITALIC SMALL F");
   ("/xf0/x9d/x91/x94", "MATHEMATICAL ITALIC SMALL G");
   ("/xf0/x9d/x91/x96", "MATHEMATICAL ITALIC SMALL I");
   ("/xf0/x9d/x91/x97", "MATHEMATICAL ITALIC SMALL J");
   ("/xf0/x9d/x91/x98", "MATHEMATICAL ITALIC SMALL K");
   ("/xf0/x9d/x91/x99", "MATHEMATICAL ITALIC SMALL L");
   ("/xf0/x9d/x91/x9a", "MATHEMATICAL ITALIC SMALL M");
   ("/xf0/x9d/x91/x9b", "MATHEMATICAL ITALIC SMALL N");
   ("/xf0/x9d/x91/x9c", "MATHEMATICAL ITALIC SMALL O");
   ("/xf0/x9d/x91/x9d", "MATHEMATICAL ITALIC SMALL P");
   ("/xf0/x9d/x91/x9e", "MATHEMATICAL ITALIC SMALL Q");
   ("/xf0/x9d/x91/x9f", "MATHEMATICAL ITALIC SMALL R");
   ("/xf0/x9d/x91/xa0", "MATHEMATICAL ITALIC SMALL S");
   ("/xf0/x9d/x91/xa1", "MATHEMATICAL ITALIC SMALL T");
   ("/xf0/x9d/x91/xa2", "MATHEMATICAL ITALIC SMALL U");
   ("/xf0/x9d/x91/xa3", "MATHEMATICAL ITALIC SMALL V");
   ("/xf0/x9d/x91/xa4", "MATHEMATICAL ITALIC SMALL W");
   ("/xf0/x9d/x91/xa5", "MATHEMATICAL ITALIC SMALL X");
   ("/xf0/x9d/x91/xa6", "MATHEMATICAL ITALIC SMALL Y");
   ("/xf0/x9d/x91/xa7", "MATHEMATICAL ITALIC SMALL Z");
   ("/xf0/x9d/x91/xa8", "MATHEMATICAL BOLD ITALIC CAPITAL A");
   ("/xf0/x9d/x91/xa9", "MATHEMATICAL BOLD ITALIC CAPITAL B");
   ("/xf0/x9d/x91/xaa", "MATHEMATICAL BOLD ITALIC CAPITAL C");
   ("/xf0/x9d/x91/xab", "MATHEMATICAL BOLD ITALIC CAPITAL D");
   ("/xf0/x9d/x91/xac", "MATHEMATICAL BOLD ITALIC CAPITAL E");
   ("/xf0/x9d/x91/xad", "MATHEMATICAL BOLD ITALIC CAPITAL F");
   ("/xf0/x9d/x91/xae", "MATHEMATICAL BOLD ITALIC CAPITAL G");
   ("/xf0/x9d/x91/xaf", "MATHEMATICAL BOLD ITALIC CAPITAL H");
   ("/xf0/x9d/x91/xb0", "MATHEMATICAL BOLD ITALIC CAPITAL I");
   ("/xf0/x9d/x91/xb1", "MATHEMATICAL BOLD ITALIC CAPITAL J");
   ("/xf0/x9d/x91/xb2", "MATHEMATICAL BOLD ITALIC CAPITAL K");
   ("/xf0/x9d/x91/xb3", "MATHEMATICAL BOLD ITALIC CAPITAL L");
   ("/xf0/x9d/x91/xb4", "MATHEMATICAL BOLD ITALIC CAPITAL M");
   ("/xf0/x9d/x91/xb5", "MATHEMATICAL BOLD ITALIC CAPITAL N");
   ("/xf0/x9d/x91/xb6", "MATHEMATICAL BOLD ITALIC CAPITAL O");
   ("/xf0/x9d/x91/xb7", "MATHEMATICAL BOLD ITALIC CAPITAL P");
   ("/xf0/x9d/x91/xb8", "MATHEMATICAL BOLD ITALIC CAPITAL Q");
   ("/xf0/x9d/x91/xb9", "MATHEMATICAL BOLD ITALIC CAPITAL R");
   ("/xf0/x9d/x91/xba", "MATHEMATICAL BOLD ITALIC CAPITAL S");
   ("/xf0/x9d/x91/xbb", "MATHEMATICAL BOLD ITALIC CAPITAL T");
   ("/xf0/x9d/x91/xbc", "MATHEMATICAL BOLD ITALIC CAPITAL U");
   ("/xf0/x9d/x91/xbd", "MATHEMATICAL BOLD ITALIC CAPITAL V");
   ("/xf0/x9d/x91/xbe", "MATHEMATICAL BOLD ITALIC CAPITAL W");
   ("/xf0/x9d/x91/xbf", "MATHEMATICAL BOLD ITALIC CAPITAL X");
   ("/xf0/x9d/x92/x80", "MATHEMATICAL BOLD ITALIC CAPITAL Y");
   ("/xf0/x9d/x92/x81", "MATHEMATICAL BOLD ITALIC CAPITAL Z");
   ("/xf0/x9d/x92/x82", "MATHEMATICAL BOLD ITALIC SMALL A");
   ("/xf0/x9d/x92/x83", "MATHEMATICAL BOLD ITALIC SMALL B");
   ("/xf0/x9d/x92/x84", "MATHEMATICAL BOLD ITALIC SMALL C");
   ("/xf0/x9d/x92/x85", "MATHEMATICAL BOLD ITALIC SMALL D");
   ("/xf0/x9d/x92/x86", "MATHEMATICAL BOLD ITALIC SMALL E");
   ("/xf0/x9d/x92/x87", "MATHEMATICAL BOLD ITALIC SMALL F");
   ("/xf0/x9d/x92/x88", "MATHEMATICAL BOLD ITALIC SMALL G");
   ("/xf0/x9d/x92/x89", "MATHEMATICAL BOLD ITALIC SMALL H");
   ("/xf0/x9d/x92/x8a", "MATHEMATICAL BOLD ITALIC SMALL I");
   ("/xf0/x9d/x92/x8b", "MATHEMATICAL BOLD ITALIC SMALL J");
   ("/xf0/x9d/x92/x8c", "MATHEMATICAL BOLD ITALIC SMALL K");
   ("/xf0/x9d/x92/x8d", "MATHEMATICAL BOLD ITALIC SMALL L");
   ("/xf0/x9d/x92/x8e", "MATHEMATICAL BOLD ITALIC SMALL M");
   ("/xf0/x9d/x92/x8f", "MATHEMATICAL BOLD ITALIC SMALL N");
   ("/xf0/x9d/x92/x90", "MATHEMATICAL BOLD ITALIC SMALL O");
   ("/xf0/x9d/x92/x91", "MATHEMATICAL BOLD ITALIC SMALL P");
   ("/xf0/x9d/x92/x92", "MATHEMATICAL BOLD ITALIC SMALL Q");
   ("/xf0/x9d/x92/x93", "MATHEMATICAL BOLD ITALIC SMALL R");
   ("/xf0/x9d/x92/x94", "MATHEMATICAL BOLD ITALIC SMALL S");
   ("/xf0/x9d/x92/x95", "MATHEMATICAL BOLD ITALIC SMALL T");
   ("/xf0/x9d/x92/x96", "MATHEMATICAL BOLD ITALIC SMALL U");
   ("/xf0/x9d/x92/x97", "MATHEMATICAL BOLD ITALIC SMALL V");
   ("/xf0/x9d/x92/x98", "MATHEMATICAL BOLD ITALIC SMALL W");
   ("/xf0/x9d/x92/x99", "MATHEMATICAL BOLD ITALIC SMALL X");
   ("/xf0/x9d/x92/x9a", "MATHEMATICAL BOLD ITALIC SMALL Y");
   ("/xf0/x9d/x92/x9b", "MATHEMATICAL BOLD ITALIC SMALL Z");
   ("/xf0/x9d/x92/x9c", "MATHEMATICAL SCRIPT CAPITAL A");
   ("/xf0/x9d/x92/x9e", "MATHEMATICAL SCRIPT CAPITAL C");
   ("/xf0/x9d/x92/x9f", "MATHEMATICAL SCRIPT CAPITAL D");
   ("/xf0/x9d/x92/xa2", "MATHEMATICAL SCRIPT CAPITAL G");
   ("/xf0/x9d/x92/xa5", "MATHEMATICAL SCRIPT CAPITAL J");
   ("/xf0/x9d/x92/xa6", "MATHEMATICAL SCRIPT CAPITAL K");
   ("/xf0/x9d/x92/xa9", "MATHEMATICAL SCRIPT CAPITAL N");
   ("/xf0/x9d/x92/xaa", "MATHEMATICAL SCRIPT CAPITAL O");
   ("/xf0/x9d/x92/xab", "MATHEMATICAL SCRIPT CAPITAL P");
   ("/xf0/x9d/x92/xac", "MATHEMATICAL SCRIPT CAPITAL Q");
   ("/xf0/x9d/x92/xae", "MATHEMATICAL SCRIPT CAPITAL S");
   ("/xf0/x9d/x92/xaf", "MATHEMATICAL SCRIPT CAPITAL T");
   ("/xf0/x9d/x92/xb0", "MATHEMATICAL SCRIPT CAPITAL U");
   ("/xf0/x9d/x92/xb1", "MATHEMATICAL SCRIPT CAPITAL V");
   ("/xf0/x9d/x92/xb2", "MATHEMATICAL SCRIPT CAPITAL W");
   ("/xf0/x9d/x92/xb3", "MATHEMATICAL SCRIPT CAPITAL X");
   ("/xf0/x9d/x92/xb4", "MATHEMATICAL SCRIPT CAPITAL Y");
   ("/xf0/x9d/x92/xb5", "MATHEMATICAL SCRIPT CAPITAL Z");
   ("/xf0/x9d/x92/xb6", "MATHEMATICAL SCRIPT SMALL A");
   ("/xf0/x9d/x92/xb7", "MATHEMATICAL SCRIPT SMALL B");
   ("/xf0/x9d/x92/xb8", "MATHEMATICAL SCRIPT SMALL C");
   ("/xf0/x9d/x92/xb9", "MATHEMATICAL SCRIPT SMALL D");
   ("/xf0/x9d/x92/xbb", "MATHEMATICAL SCRIPT SMALL F");
   ("/xf0/x9d/x92/xbd", "MATHEMATICAL SCRIPT SMALL H");
   ("/xf0/x9d/x92/xbe", "MATHEMATICAL SCRIPT SMALL I");
   ("/xf0/x9d/x92/xbf", "MATHEMATICAL SCRIPT SMALL J");
   ("/xf0/x9d/x93/x80", "MATHEMATICAL SCRIPT SMALL K");
   ("/xf0/x9d/x93/x81", "MATHEMATICAL SCRIPT SMALL L");
   ("/xf0/x9d/x93/x82", "MATHEMATICAL SCRIPT SMALL M");
   ("/xf0/x9d/x93/x83", "MATHEMATICAL SCRIPT SMALL N");
   ("/xf0/x9d/x93/x85", "MATHEMATICAL SCRIPT SMALL P");
   ("/xf0/x9d/x93/x86", "MATHEMATICAL SCRIPT SMALL Q");
   ("/xf0/x9d/x93/x87", "MATHEMATICAL SCRIPT SMALL R");
   ("/xf0/x9d/x93/x88", "MATHEMATICAL SCRIPT SMALL S");
   ("/xf0/x9d/x93/x89", "MATHEMATICAL SCRIPT SMALL T");
   ("/xf0/x9d/x93/x8a", "MATHEMATICAL SCRIPT SMALL U");
   ("/xf0/x9d/x93/x8b", "MATHEMATICAL SCRIPT SMALL V");
   ("/xf0/x9d/x93/x8c", "MATHEMATICAL SCRIPT SMALL W");
   ("/xf0/x9d/x93/x8d", "MATHEMATICAL SCRIPT SMALL X");
   ("/xf0/x9d/x93/x8e", "MATHEMATICAL SCRIPT SMALL Y");
   ("/xf0/x9d/x93/x8f", "MATHEMATICAL SCRIPT SMALL Z");
   ("/xf0/x9d/x93/x90", "MATHEMATICAL BOLD SCRIPT CAPITAL A");
   ("/xf0/x9d/x93/x91", "MATHEMATICAL BOLD SCRIPT CAPITAL B");
   ("/xf0/x9d/x93/x92", "MATHEMATICAL BOLD SCRIPT CAPITAL C");
   ("/xf0/x9d/x93/x93", "MATHEMATICAL BOLD SCRIPT CAPITAL D");
   ("/xf0/x9d/x93/x94", "MATHEMATICAL BOLD SCRIPT CAPITAL E");
   ("/xf0/x9d/x93/x95", "MATHEMATICAL BOLD SCRIPT CAPITAL F");
   ("/xf0/x9d/x93/x96", "MATHEMATICAL BOLD SCRIPT CAPITAL G");
   ("/xf0/x9d/x93/x97", "MATHEMATICAL BOLD SCRIPT CAPITAL H");
   ("/xf0/x9d/x93/x98", "MATHEMATICAL BOLD SCRIPT CAPITAL I");
   ("/xf0/x9d/x93/x99", "MATHEMATICAL BOLD SCRIPT CAPITAL J");
   ("/xf0/x9d/x93/x9a", "MATHEMATICAL BOLD SCRIPT CAPITAL K");
   ("/xf0/x9d/x93/x9b", "MATHEMATICAL BOLD SCRIPT CAPITAL L");
   ("/xf0/x9d/x93/x9c", "MATHEMATICAL BOLD SCRIPT CAPITAL M");
   ("/xf0/x9d/x93/x9d", "MATHEMATICAL BOLD SCRIPT CAPITAL N");
   ("/xf0/x9d/x93/x9e", "MATHEMATICAL BOLD SCRIPT CAPITAL O");
   ("/xf0/x9d/x93/x9f", "MATHEMATICAL BOLD SCRIPT CAPITAL P");
   ("/xf0/x9d/x93/xa0", "MATHEMATICAL BOLD SCRIPT CAPITAL Q");
   ("/xf0/x9d/x93/xa1", "MATHEMATICAL BOLD SCRIPT CAPITAL R");
   ("/xf0/x9d/x93/xa2", "MATHEMATICAL BOLD SCRIPT CAPITAL S");
   ("/xf0/x9d/x93/xa3", "MATHEMATICAL BOLD SCRIPT CAPITAL T");
   ("/xf0/x9d/x93/xa4", "MATHEMATICAL BOLD SCRIPT CAPITAL U");
   ("/xf0/x9d/x93/xa5", "MATHEMATICAL BOLD SCRIPT CAPITAL V");
   ("/xf0/x9d/x93/xa6", "MATHEMATICAL BOLD SCRIPT CAPITAL W");
   ("/xf0/x9d/x93/xa7", "MATHEMATICAL BOLD SCRIPT CAPITAL X");
   ("/xf0/x9d/x93/xa8", "MATHEMATICAL BOLD SCRIPT CAPITAL Y");
   ("/xf0/x9d/x93/xa9", "MATHEMATICAL BOLD SCRIPT CAPITAL Z");
   ("/xf0/x9d/x93/xaa", "MATHEMATICAL BOLD SCRIPT SMALL A");
   ("/xf0/x9d/x93/xab", "MATHEMATICAL BOLD SCRIPT SMALL B");
   ("/xf0/x9d/x93/xac", "MATHEMATICAL BOLD SCRIPT SMALL C");
   ("/xf0/x9d/x93/xad", "MATHEMATICAL BOLD SCRIPT SMALL D");
   ("/xf0/x9d/x93/xae", "MATHEMATICAL BOLD SCRIPT SMALL E");
   ("/xf0/x9d/x93/xaf", "MATHEMATICAL BOLD SCRIPT SMALL F");
   ("/xf0/x9d/x93/xb0", "MATHEMATICAL BOLD SCRIPT SMALL G");
   ("/xf0/x9d/x93/xb1", "MATHEMATICAL BOLD SCRIPT SMALL H");
   ("/xf0/x9d/x93/xb2", "MATHEMATICAL BOLD SCRIPT SMALL I");
   ("/xf0/x9d/x93/xb3", "MATHEMATICAL BOLD SCRIPT SMALL J");
   ("/xf0/x9d/x93/xb4", "MATHEMATICAL BOLD SCRIPT SMALL K");
   ("/xf0/x9d/x93/xb5", "MATHEMATICAL BOLD SCRIPT SMALL L");
   ("/xf0/x9d/x93/xb6", "MATHEMATICAL BOLD SCRIPT SMALL M");
   ("/xf0/x9d/x93/xb7", "MATHEMATICAL BOLD SCRIPT SMALL N");
   ("/xf0/x9d/x93/xb8", "MATHEMATICAL BOLD SCRIPT SMALL O");
   ("/xf0/x9d/x93/xb9", "MATHEMATICAL BOLD SCRIPT SMALL P");
   ("/xf0/x9d/x93/xba", "MATHEMATICAL BOLD SCRIPT SMALL Q");
   ("/xf0/x9d/x93/xbb", "MATHEMATICAL BOLD SCRIPT SMALL R");
   ("/xf0/x9d/x93/xbc", "MATHEMATICAL BOLD SCRIPT SMALL S");
   ("/xf0/x9d/x93/xbd", "MATHEMATICAL BOLD SCRIPT SMALL T");
   ("/xf0/x9d/x93/xbe", "MATHEMATICAL BOLD SCRIPT SMALL U");
   ("/xf0/x9d/x93/xbf", "MATHEMATICAL BOLD SCRIPT SMALL V");
   ("/xf0/x9d/x94/x80", "MATHEMATICAL BOLD SCRIPT SMALL W");
   ("/xf0/x9d/x94/x81", "MATHEMATICAL BOLD SCRIPT SMALL X");
   ("/xf0/x9d/x94/x82", "MATHEMATICAL BOLD SCRIPT SMALL Y");
   ("/xf0/x9d/x94/x83", "MATHEMATICAL BOLD SCRIPT SMALL Z");
   ("/xf0/x9d/x94/x84", "MATHEMATICAL FRAKTUR CAPITAL A");
   ("/xf0/x9d/x94/x85", "MATHEMATICAL FRAKTUR CAPITAL B");
   ("/xf0/x9d/x94/x87", "MATHEMATICAL FRAKTUR CAPITAL D");
   ("/xf0/x9d/x94/x88", "MATHEMATICAL FRAKTUR CAPITAL E");
   ("/xf0/x9d/x94/x89", "MATHEMATICAL FRAKTUR CAPITAL F");
   ("/xf0/x9d/x94/x8a", "MATHEMATICAL FRAKTUR CAPITAL G");
   ("/xf0/x9d/x94/x8d", "MATHEMATICAL FRAKTUR CAPITAL J");
   ("/xf0/x9d/x94/x8e", "MATHEMATICAL FRAKTUR CAPITAL K");
   ("/xf0/x9d/x94/x8f", "MATHEMATICAL FRAKTUR CAPITAL L");
   ("/xf0/x9d/x94/x90", "MATHEMATICAL FRAKTUR CAPITAL M");
   ("/xf0/x9d/x94/x91", "MATHEMATICAL FRAKTUR CAPITAL N");
   ("/xf0/x9d/x94/x92", "MATHEMATICAL FRAKTUR CAPITAL O");
   ("/xf0/x9d/x94/x93", "MATHEMATICAL FRAKTUR CAPITAL P");
   ("/xf0/x9d/x94/x94", "MATHEMATICAL FRAKTUR CAPITAL Q");
   ("/xf0/x9d/x94/x96", "MATHEMATICAL FRAKTUR CAPITAL S");
   ("/xf0/x9d/x94/x97", "MATHEMATICAL FRAKTUR CAPITAL T");
   ("/xf0/x9d/x94/x98", "MATHEMATICAL FRAKTUR CAPITAL U");
   ("/xf0/x9d/x94/x99", "MATHEMATICAL FRAKTUR CAPITAL V");
   ("/xf0/x9d/x94/x9a", "MATHEMATICAL FRAKTUR CAPITAL W");
   ("/xf0/x9d/x94/x9b", "MATHEMATICAL FRAKTUR CAPITAL X");
   ("/xf0/x9d/x94/x9c", "MATHEMATICAL FRAKTUR CAPITAL Y");
   ("/xf0/x9d/x94/x9e", "MATHEMATICAL FRAKTUR SMALL A");
   ("/xf0/x9d/x94/x9f", "MATHEMATICAL FRAKTUR SMALL B");
   ("/xf0/x9d/x94/xa0", "MATHEMATICAL FRAKTUR SMALL C");
   ("/xf0/x9d/x94/xa1", "MATHEMATICAL FRAKTUR SMALL D");
   ("/xf0/x9d/x94/xa2", "MATHEMATICAL FRAKTUR SMALL E");
   ("/xf0/x9d/x94/xa3", "MATHEMATICAL FRAKTUR SMALL F");
   ("/xf0/x9d/x94/xa4", "MATHEMATICAL FRAKTUR SMALL G");
   ("/xf0/x9d/x94/xa5", "MATHEMATICAL FRAKTUR SMALL H");
   ("/xf0/x9d/x94/xa6", "MATHEMATICAL FRAKTUR SMALL I");
   ("/xf0/x9d/x94/xa7", "MATHEMATICAL FRAKTUR SMALL J");
   ("/xf0/x9d/x94/xa8", "MATHEMATICAL FRAKTUR SMALL K");
   ("/xf0/x9d/x94/xa9", "MATHEMATICAL FRAKTUR SMALL L");
   ("/xf0/x9d/x94/xaa", "MATHEMATICAL FRAKTUR SMALL M");
   ("/xf0/x9d/x94/xab", "MATHEMATICAL FRAKTUR SMALL N");
   ("/xf0/x9d/x94/xac", "MATHEMATICAL FRAKTUR SMALL O");
   ("/xf0/x9d/x94/xad", "MATHEMATICAL FRAKTUR SMALL P");
   ("/xf0/x9d/x94/xae", "MATHEMATICAL FRAKTUR SMALL Q");
   ("/xf0/x9d/x94/xaf", "MATHEMATICAL FRAKTUR SMALL R");
   ("/xf0/x9d/x94/xb0", "MATHEMATICAL FRAKTUR SMALL S");
   ("/xf0/x9d/x94/xb1", "MATHEMATICAL FRAKTUR SMALL T");
   ("/xf0/x9d/x94/xb2", "MATHEMATICAL FRAKTUR SMALL U");
   ("/xf0/x9d/x94/xb3", "MATHEMATICAL FRAKTUR SMALL V");
   ("/xf0/x9d/x94/xb4", "MATHEMATICAL FRAKTUR SMALL W");
   ("/xf0/x9d/x94/xb5", "MATHEMATICAL FRAKTUR SMALL X");
   ("/xf0/x9d/x94/xb6", "MATHEMATICAL FRAKTUR SMALL Y");
   ("/xf0/x9d/x94/xb7", "MATHEMATICAL FRAKTUR SMALL Z");
   ("/xf0/x9d/x94/xb8", "MATHEMATICAL DOUBLE-STRUCK CAPITAL A");
   ("/xf0/x9d/x94/xb9", "MATHEMATICAL DOUBLE-STRUCK CAPITAL B");
   ("/xf0/x9d/x94/xbb", "MATHEMATICAL DOUBLE-STRUCK CAPITAL D");
   ("/xf0/x9d/x94/xbc", "MATHEMATICAL DOUBLE-STRUCK CAPITAL E");
   ("/xf0/x9d/x94/xbd", "MATHEMATICAL DOUBLE-STRUCK CAPITAL F");
   ("/xf0/x9d/x94/xbe", "MATHEMATICAL DOUBLE-STRUCK CAPITAL G");
   ("/xf0/x9d/x95/x80", "MATHEMATICAL DOUBLE-STRUCK CAPITAL I");
   ("/xf0/x9d/x95/x81", "MATHEMATICAL DOUBLE-STRUCK CAPITAL J");
   ("/xf0/x9d/x95/x82", "MATHEMATICAL DOUBLE-STRUCK CAPITAL K");
   ("/xf0/x9d/x95/x83", "MATHEMATICAL DOUBLE-STRUCK CAPITAL L");
   ("/xf0/x9d/x95/x84", "MATHEMATICAL DOUBLE-STRUCK CAPITAL M");
   ("/xf0/x9d/x95/x86", "MATHEMATICAL DOUBLE-STRUCK CAPITAL O");
   ("/xf0/x9d/x95/x8a", "MATHEMATICAL DOUBLE-STRUCK CAPITAL S");
   ("/xf0/x9d/x95/x8b", "MATHEMATICAL DOUBLE-STRUCK CAPITAL T");
   ("/xf0/x9d/x95/x8c", "MATHEMATICAL DOUBLE-STRUCK CAPITAL U");
   ("/xf0/x9d/x95/x8d", "MATHEMATICAL DOUBLE-STRUCK CAPITAL V");
   ("/xf0/x9d/x95/x8e", "MATHEMATICAL DOUBLE-STRUCK CAPITAL W");
   ("/xf0/x9d/x95/x8f", "MATHEMATICAL DOUBLE-STRUCK CAPITAL X");
   ("/xf0/x9d/x95/x90", "MATHEMATICAL DOUBLE-STRUCK CAPITAL Y");
   ("/xf0/x9d/x95/x92", "MATHEMATICAL DOUBLE-STRUCK SMALL A");
   ("/xf0/x9d/x95/x93", "MATHEMATICAL DOUBLE-STRUCK SMALL B");
   ("/xf0/x9d/x95/x94", "MATHEMATICAL DOUBLE-STRUCK SMALL C");
   ("/xf0/x9d/x95/x95", "MATHEMATICAL DOUBLE-STRUCK SMALL D");
   ("/xf0/x9d/x95/x96", "MATHEMATICAL DOUBLE-STRUCK SMALL E");
   ("/xf0/x9d/x95/x97", "MATHEMATICAL DOUBLE-STRUCK SMALL F");
   ("/xf0/x9d/x95/x98", "MATHEMATICAL DOUBLE-STRUCK SMALL G");
   ("/xf0/x9d/x95/x99", "MATHEMATICAL DOUBLE-STRUCK SMALL H");
   ("/xf0/x9d/x95/x9a", "MATHEMATICAL DOUBLE-STRUCK SMALL I");
   ("/xf0/x9d/x95/x9b", "MATHEMATICAL DOUBLE-STRUCK SMALL J");
   ("/xf0/x9d/x95/x9c", "MATHEMATICAL DOUBLE-STRUCK SMALL K");
   ("/xf0/x9d/x95/x9d", "MATHEMATICAL DOUBLE-STRUCK SMALL L");
   ("/xf0/x9d/x95/x9e", "MATHEMATICAL DOUBLE-STRUCK SMALL M");
   ("/xf0/x9d/x95/x9f", "MATHEMATICAL DOUBLE-STRUCK SMALL N");
   ("/xf0/x9d/x95/xa0", "MATHEMATICAL DOUBLE-STRUCK SMALL O");
   ("/xf0/x9d/x95/xa1", "MATHEMATICAL DOUBLE-STRUCK SMALL P");
   ("/xf0/x9d/x95/xa2", "MATHEMATICAL DOUBLE-STRUCK SMALL Q");
   ("/xf0/x9d/x95/xa3", "MATHEMATICAL DOUBLE-STRUCK SMALL R");
   ("/xf0/x9d/x95/xa4", "MATHEMATICAL DOUBLE-STRUCK SMALL S");
   ("/xf0/x9d/x95/xa5", "MATHEMATICAL DOUBLE-STRUCK SMALL T");
   ("/xf0/x9d/x95/xa6", "MATHEMATICAL DOUBLE-STRUCK SMALL U");
   ("/xf0/x9d/x95/xa7", "MATHEMATICAL DOUBLE-STRUCK SMALL V");
   ("/xf0/x9d/x95/xa8", "MATHEMATICAL DOUBLE-STRUCK SMALL W");
   ("/xf0/x9d/x95/xa9", "MATHEMATICAL DOUBLE-STRUCK SMALL X");
   ("/xf0/x9d/x95/xaa", "MATHEMATICAL DOUBLE-STRUCK SMALL Y");
   ("/xf0/x9d/x95/xab", "MATHEMATICAL DOUBLE-STRUCK SMALL Z");
   ("/xf0/x9d/x95/xac", "MATHEMATICAL BOLD FRAKTUR CAPITAL A");
   ("/xf0/x9d/x95/xad", "MATHEMATICAL BOLD FRAKTUR CAPITAL B");
   ("/xf0/x9d/x95/xae", "MATHEMATICAL BOLD FRAKTUR CAPITAL C");
   ("/xf0/x9d/x95/xaf", "MATHEMATICAL BOLD FRAKTUR CAPITAL D");
   ("/xf0/x9d/x95/xb0", "MATHEMATICAL BOLD FRAKTUR CAPITAL E");
   ("/xf0/x9d/x95/xb1", "MATHEMATICAL BOLD FRAKTUR CAPITAL F");
   ("/xf0/x9d/x95/xb2", "MATHEMATICAL BOLD FRAKTUR CAPITAL G");
   ("/xf0/x9d/x95/xb3", "MATHEMATICAL BOLD FRAKTUR CAPITAL H");
   ("/xf0/x9d/x95/xb4", "MATHEMATICAL BOLD FRAKTUR CAPITAL I");
   ("/xf0/x9d/x95/xb5", "MATHEMATICAL BOLD FRAKTUR CAPITAL J");
   ("/xf0/x9d/x95/xb6", "MATHEMATICAL BOLD FRAKTUR CAPITAL K");
   ("/xf0/x9d/x95/xb7", "MATHEMATICAL BOLD FRAKTUR CAPITAL L");
   ("/xf0/x9d/x95/xb8", "MATHEMATICAL BOLD FRAKTUR CAPITAL M");
   ("/xf0/x9d/x95/xb9", "MATHEMATICAL BOLD FRAKTUR CAPITAL N");
   ("/xf0/x9d/x95/xba", "MATHEMATICAL BOLD FRAKTUR CAPITAL O");
   ("/xf0/x9d/x95/xbb", "MATHEMATICAL BOLD FRAKTUR CAPITAL P");
   ("/xf0/x9d/x95/xbc", "MATHEMATICAL BOLD FRAKTUR CAPITAL Q");
   ("/xf0/x9d/x95/xbd", "MATHEMATICAL BOLD FRAKTUR CAPITAL R");
   ("/xf0/x9d/x95/xbe", "MATHEMATICAL BOLD FRAKTUR CAPITAL S");
   ("/xf0/x9d/x95/xbf", "MATHEMATICAL BOLD FRAKTUR CAPITAL T");
   ("/xf0/x9d/x96/x80", "MATHEMATICAL BOLD FRAKTUR CAPITAL U");
   ("/xf0/x9d/x96/x81", "MATHEMATICAL BOLD FRAKTUR CAPITAL V");
   ("/xf0/x9d/x96/x82", "MATHEMATICAL BOLD FRAKTUR CAPITAL W");
   ("/xf0/x9d/x96/x83", "MATHEMATICAL BOLD FRAKTUR CAPITAL X");
   ("/xf0/x9d/x96/x84", "MATHEMATICAL BOLD FRAKTUR CAPITAL Y");
   ("/xf0/x9d/x96/x85", "MATHEMATICAL BOLD FRAKTUR CAPITAL Z");
   ("/xf0/x9d/x96/x86", "MATHEMATICAL BOLD FRAKTUR SMALL A");
   ("/xf0/x9d/x96/x87", "MATHEMATICAL BOLD FRAKTUR SMALL B");
   ("/xf0/x9d/x96/x88", "MATHEMATICAL BOLD FRAKTUR SMALL C");
   ("/xf0/x9d/x96/x89", "MATHEMATICAL BOLD FRAKTUR SMALL D");
   ("/xf0/x9d/x96/x8a", "MATHEMATICAL BOLD FRAKTUR SMALL E");
   ("/xf0/x9d/x96/x8b", "MATHEMATICAL BOLD FRAKTUR SMALL F");
   ("/xf0/x9d/x96/x8c", "MATHEMATICAL BOLD FRAKTUR SMALL G");
   ("/xf0/x9d/x96/x8d", "MATHEMATICAL BOLD FRAKTUR SMALL H");
   ("/xf0/x9d/x96/x8e", "MATHEMATICAL BOLD FRAKTUR SMALL I");
   ("/xf0/x9d/x96/x8f", "MATHEMATICAL BOLD FRAKTUR SMALL J");
   ("/xf0/x9d/x96/x90", "MATHEMATICAL BOLD FRAKTUR SMALL K");
   ("/xf0/x9d/x96/x91", "MATHEMATICAL BOLD FRAKTUR SMALL L");
   ("/xf0/x9d/x96/x92", "MATHEMATICAL BOLD FRAKTUR SMALL M");
   ("/xf0/x9d/x96/x93", "MATHEMATICAL BOLD FRAKTUR SMALL N");
   ("/xf0/x9d/x96/x94", "MATHEMATICAL BOLD FRAKTUR SMALL O");
   ("/xf0/x9d/x96/x95", "MATHEMATICAL BOLD FRAKTUR SMALL P");
   ("/xf0/x9d/x96/x96", "MATHEMATICAL BOLD FRAKTUR SMALL Q");
   ("/xf0/x9d/x96/x97", "MATHEMATICAL BOLD FRAKTUR SMALL R");
   ("/xf0/x9d/x96/x98", "MATHEMATICAL BOLD FRAKTUR SMALL S");
   ("/xf0/x9d/x96/x99", "MATHEMATICAL BOLD FRAKTUR SMALL T");
   ("/xf0/x9d/x96/x9a", "MATHEMATICAL BOLD FRAKTUR SMALL U");
   ("/xf0/x9d/x96/x9b", "MATHEMATICAL BOLD FRAKTUR SMALL V");
   ("/xf0/x9d/x96/x9c", "MATHEMATICAL BOLD FRAKTUR SMALL W");
   ("/xf0/x9d/x96/x9d", "MATHEMATICAL BOLD FRAKTUR SMALL X");
   ("/xf0/x9d/x96/x9e", "MATHEMATICAL BOLD FRAKTUR SMALL Y");
   ("/xf0/x9d/x96/x9f", "MATHEMATICAL BOLD FRAKTUR SMALL Z");
   ("/xf0/x9d/x96/xa0", "MATHEMATICAL SANS-SERIF CAPITAL A");
   ("/xf0/x9d/x96/xa1", "MATHEMATICAL SANS-SERIF CAPITAL B");
   ("/xf0/x9d/x96/xa2", "MATHEMATICAL SANS-SERIF CAPITAL C");
   ("/xf0/x9d/x96/xa3", "MATHEMATICAL SANS-SERIF CAPITAL D");
   ("/xf0/x9d/x96/xa4", "MATHEMATICAL SANS-SERIF CAPITAL E");
   ("/xf0/x9d/x96/xa5", "MATHEMATICAL SANS-SERIF CAPITAL F");
   ("/xf0/x9d/x96/xa6", "MATHEMATICAL SANS-SERIF CAPITAL G");
   ("/xf0/x9d/x96/xa7", "MATHEMATICAL SANS-SERIF CAPITAL H");
   ("/xf0/x9d/x96/xa8", "MATHEMATICAL SANS-SERIF CAPITAL I");
   ("/xf0/x9d/x96/xa9", "MATHEMATICAL SANS-SERIF CAPITAL J");
   ("/xf0/x9d/x96/xaa", "MATHEMATICAL SANS-SERIF CAPITAL K");
   ("/xf0/x9d/x96/xab", "MATHEMATICAL SANS-SERIF CAPITAL L");
   ("/xf0/x9d/x96/xac", "MATHEMATICAL SANS-SERIF CAPITAL M");
   ("/xf0/x9d/x96/xad", "MATHEMATICAL SANS-SERIF CAPITAL N");
   ("/xf0/x9d/x96/xae", "MATHEMATICAL SANS-SERIF CAPITAL O");
   ("/xf0/x9d/x96/xaf", "MATHEMATICAL SANS-SERIF CAPITAL P");
   ("/xf0/x9d/x96/xb0", "MATHEMATICAL SANS-SERIF CAPITAL Q");
   ("/xf0/x9d/x96/xb1", "MATHEMATICAL SANS-SERIF CAPITAL R");
   ("/xf0/x9d/x96/xb2", "MATHEMATICAL SANS-SERIF CAPITAL S");
   ("/xf0/x9d/x96/xb3", "MATHEMATICAL SANS-SERIF CAPITAL T");
   ("/xf0/x9d/x96/xb4", "MATHEMATICAL SANS-SERIF CAPITAL U");
   ("/xf0/x9d/x96/xb5", "MATHEMATICAL SANS-SERIF CAPITAL V");
   ("/xf0/x9d/x96/xb6", "MATHEMATICAL SANS-SERIF CAPITAL W");
   ("/xf0/x9d/x96/xb7", "MATHEMATICAL SANS-SERIF CAPITAL X");
   ("/xf0/x9d/x96/xb8", "MATHEMATICAL SANS-SERIF CAPITAL Y");
   ("/xf0/x9d/x96/xb9", "MATHEMATICAL SANS-SERIF CAPITAL Z");
   ("/xf0/x9d/x96/xba", "MATHEMATICAL SANS-SERIF SMALL A");
   ("/xf0/x9d/x96/xbb", "MATHEMATICAL SANS-SERIF SMALL B");
   ("/xf0/x9d/x96/xbc", "MATHEMATICAL SANS-SERIF SMALL C");
   ("/xf0/x9d/x96/xbd", "MATHEMATICAL SANS-SERIF SMALL D");
   ("/xf0/x9d/x96/xbe", "MATHEMATICAL SANS-SERIF SMALL E");
   ("/xf0/x9d/x96/xbf", "MATHEMATICAL SANS-SERIF SMALL F");
   ("/xf0/x9d/x97/x80", "MATHEMATICAL SANS-SERIF SMALL G");
   ("/xf0/x9d/x97/x81", "MATHEMATICAL SANS-SERIF SMALL H");
   ("/xf0/x9d/x97/x82", "MATHEMATICAL SANS-SERIF SMALL I");
   ("/xf0/x9d/x97/x83", "MATHEMATICAL SANS-SERIF SMALL J");
   ("/xf0/x9d/x97/x84", "MATHEMATICAL SANS-SERIF SMALL K");
   ("/xf0/x9d/x97/x85", "MATHEMATICAL SANS-SERIF SMALL L");
   ("/xf0/x9d/x97/x86", "MATHEMATICAL SANS-SERIF SMALL M");
   ("/xf0/x9d/x97/x87", "MATHEMATICAL SANS-SERIF SMALL N");
   ("/xf0/x9d/x97/x88", "MATHEMATICAL SANS-SERIF SMALL O");
   ("/xf0/x9d/x97/x89", "MATHEMATICAL SANS-SERIF SMALL P");
   ("/xf0/x9d/x97/x8a", "MATHEMATICAL SANS-SERIF SMALL Q");
   ("/xf0/x9d/x97/x8b", "MATHEMATICAL SANS-SERIF SMALL R");
   ("/xf0/x9d/x97/x8c", "MATHEMATICAL SANS-SERIF SMALL S");
   ("/xf0/x9d/x97/x8d", "MATHEMATICAL SANS-SERIF SMALL T");
   ("/xf0/x9d/x97/x8e", "MATHEMATICAL SANS-SERIF SMALL U");
   ("/xf0/x9d/x97/x8f", "MATHEMATICAL SANS-SERIF SMALL V");
   ("/xf0/x9d/x97/x90", "MATHEMATICAL SANS-SERIF SMALL W");
   ("/xf0/x9d/x97/x91", "MATHEMATICAL SANS-SERIF SMALL X");
   ("/xf0/x9d/x97/x92", "MATHEMATICAL SANS-SERIF SMALL Y");
   ("/xf0/x9d/x97/x93", "MATHEMATICAL SANS-SERIF SMALL Z");
   ("/xf0/x9d/x97/x94", "MATHEMATICAL SANS-SERIF BOLD CAPITAL A");
   ("/xf0/x9d/x97/x95", "MATHEMATICAL SANS-SERIF BOLD CAPITAL B");
   ("/xf0/x9d/x97/x96", "MATHEMATICAL SANS-SERIF BOLD CAPITAL C");
   ("/xf0/x9d/x97/x97", "MATHEMATICAL SANS-SERIF BOLD CAPITAL D");
   ("/xf0/x9d/x97/x98", "MATHEMATICAL SANS-SERIF BOLD CAPITAL E");
   ("/xf0/x9d/x97/x99", "MATHEMATICAL SANS-SERIF BOLD CAPITAL F");
   ("/xf0/x9d/x97/x9a", "MATHEMATICAL SANS-SERIF BOLD CAPITAL G");
   ("/xf0/x9d/x97/x9b", "MATHEMATICAL SANS-SERIF BOLD CAPITAL H");
   ("/xf0/x9d/x97/x9c", "MATHEMATICAL SANS-SERIF BOLD CAPITAL I");
   ("/xf0/x9d/x97/x9d", "MATHEMATICAL SANS-SERIF BOLD CAPITAL J");
   ("/xf0/x9d/x97/x9e", "MATHEMATICAL SANS-SERIF BOLD CAPITAL K");
   ("/xf0/x9d/x97/x9f", "MATHEMATICAL SANS-SERIF BOLD CAPITAL L");
   ("/xf0/x9d/x97/xa0", "MATHEMATICAL SANS-SERIF BOLD CAPITAL M");
   ("/xf0/x9d/x97/xa1", "MATHEMATICAL SANS-SERIF BOLD CAPITAL N");
   ("/xf0/x9d/x97/xa2", "MATHEMATICAL SANS-SERIF BOLD CAPITAL O");
   ("/xf0/x9d/x97/xa3", "MATHEMATICAL SANS-SERIF BOLD CAPITAL P");
   ("/xf0/x9d/x97/xa4", "MATHEMATICAL SANS-SERIF BOLD CAPITAL Q");
   ("/xf0/x9d/x97/xa5", "MATHEMATICAL SANS-SERIF BOLD CAPITAL R");
   ("/xf0/x9d/x97/xa6", "MATHEMATICAL SANS-SERIF BOLD CAPITAL S");
   ("/xf0/x9d/x97/xa7", "MATHEMATICAL SANS-SERIF BOLD CAPITAL T");
   ("/xf0/x9d/x97/xa8", "MATHEMATICAL SANS-SERIF BOLD CAPITAL U");
   ("/xf0/x9d/x97/xa9", "MATHEMATICAL SANS-SERIF BOLD CAPITAL V");
   ("/xf0/x9d/x97/xaa", "MATHEMATICAL SANS-SERIF BOLD CAPITAL W");
   ("/xf0/x9d/x97/xab", "MATHEMATICAL SANS-SERIF BOLD CAPITAL X");
   ("/xf0/x9d/x97/xac", "MATHEMATICAL SANS-SERIF BOLD CAPITAL Y");
   ("/xf0/x9d/x97/xad", "MATHEMATICAL SANS-SERIF BOLD CAPITAL Z");
   ("/xf0/x9d/x97/xae", "MATHEMATICAL SANS-SERIF BOLD SMALL A");
   ("/xf0/x9d/x97/xaf", "MATHEMATICAL SANS-SERIF BOLD SMALL B");
   ("/xf0/x9d/x97/xb0", "MATHEMATICAL SANS-SERIF BOLD SMALL C");
   ("/xf0/x9d/x97/xb1", "MATHEMATICAL SANS-SERIF BOLD SMALL D");
   ("/xf0/x9d/x97/xb2", "MATHEMATICAL SANS-SERIF BOLD SMALL E");
   ("/xf0/x9d/x97/xb3", "MATHEMATICAL SANS-SERIF BOLD SMALL F");
   ("/xf0/x9d/x97/xb4", "MATHEMATICAL SANS-SERIF BOLD SMALL G");
   ("/xf0/x9d/x97/xb5", "MATHEMATICAL SANS-SERIF BOLD SMALL H");
   ("/xf0/x9d/x97/xb6", "MATHEMATICAL SANS-SERIF BOLD SMALL I");
   ("/xf0/x9d/x97/xb7", "MATHEMATICAL SANS-SERIF BOLD SMALL J");
   ("/xf0/x9d/x97/xb8", "MATHEMATICAL SANS-SERIF BOLD SMALL K");
   ("/xf0/x9d/x97/xb9", "MATHEMATICAL SANS-SERIF BOLD SMALL L");
   ("/xf0/x9d/x97/xba", "MATHEMATICAL SANS-SERIF BOLD SMALL M");
   ("/xf0/x9d/x97/xbb", "MATHEMATICAL SANS-SERIF BOLD SMALL N");
   ("/xf0/x9d/x97/xbc", "MATHEMATICAL SANS-SERIF BOLD SMALL O");
   ("/xf0/x9d/x97/xbd", "MATHEMATICAL SANS-SERIF BOLD SMALL P");
   ("/xf0/x9d/x97/xbe", "MATHEMATICAL SANS-SERIF BOLD SMALL Q");
   ("/xf0/x9d/x97/xbf", "MATHEMATICAL SANS-SERIF BOLD SMALL R");
   ("/xf0/x9d/x98/x80", "MATHEMATICAL SANS-SERIF BOLD SMALL S");
   ("/xf0/x9d/x98/x81", "MATHEMATICAL SANS-SERIF BOLD SMALL T");
   ("/xf0/x9d/x98/x82", "MATHEMATICAL SANS-SERIF BOLD SMALL U");
   ("/xf0/x9d/x98/x83", "MATHEMATICAL SANS-SERIF BOLD SMALL V");
   ("/xf0/x9d/x98/x84", "MATHEMATICAL SANS-SERIF BOLD SMALL W");
   ("/xf0/x9d/x98/x85", "MATHEMATICAL SANS-SERIF BOLD SMALL X");
   ("/xf0/x9d/x98/x86", "MATHEMATICAL SANS-SERIF BOLD SMALL Y");
   ("/xf0/x9d/x98/x87", "MATHEMATICAL SANS-SERIF BOLD SMALL Z");
   ("/xf0/x9d/x98/x88", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL A");
   ("/xf0/x9d/x98/x89", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL B");
   ("/xf0/x9d/x98/x8a", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL C");
   ("/xf0/x9d/x98/x8b", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL D");
   ("/xf0/x9d/x98/x8c", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL E");
   ("/xf0/x9d/x98/x8d", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL F");
   ("/xf0/x9d/x98/x8e", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL G");
   ("/xf0/x9d/x98/x8f", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL H");
   ("/xf0/x9d/x98/x90", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL I");
   ("/xf0/x9d/x98/x91", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL J");
   ("/xf0/x9d/x98/x92", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL K");
   ("/xf0/x9d/x98/x93", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL L");
   ("/xf0/x9d/x98/x94", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL M");
   ("/xf0/x9d/x98/x95", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL N");
   ("/xf0/x9d/x98/x96", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL O");
   ("/xf0/x9d/x98/x97", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL P");
   ("/xf0/x9d/x98/x98", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q");
   ("/xf0/x9d/x98/x99", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL R");
   ("/xf0/x9d/x98/x9a", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL S");
   ("/xf0/x9d/x98/x9b", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL T");
   ("/xf0/x9d/x98/x9c", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL U");
   ("/xf0/x9d/x98/x9d", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL V");
   ("/xf0/x9d/x98/x9e", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL W");
   ("/xf0/x9d/x98/x9f", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL X");
   ("/xf0/x9d/x98/xa0", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y");
   ("/xf0/x9d/x98/xa1", "MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z");
   ("/xf0/x9d/x98/xa2", "MATHEMATICAL SANS-SERIF ITALIC SMALL A");
   ("/xf0/x9d/x98/xa3", "MATHEMATICAL SANS-SERIF ITALIC SMALL B");
   ("/xf0/x9d/x98/xa4", "MATHEMATICAL SANS-SERIF ITALIC SMALL C");
   ("/xf0/x9d/x98/xa5", "MATHEMATICAL SANS-SERIF ITALIC SMALL D");
   ("/xf0/x9d/x98/xa6", "MATHEMATICAL SANS-SERIF ITALIC SMALL E");
   ("/xf0/x9d/x98/xa7", "MATHEMATICAL SANS-SERIF ITALIC SMALL F");
   ("/xf0/x9d/x98/xa8", "MATHEMATICAL SANS-SERIF ITALIC SMALL G");
   ("/xf0/x9d/x98/xa9", "MATHEMATICAL SANS-SERIF ITALIC SMALL H");
   ("/xf0/x9d/x98/xaa", "MATHEMATICAL SANS-SERIF ITALIC SMALL I");
   ("/xf0/x9d/x98/xab", "MATHEMATICAL SANS-SERIF ITALIC SMALL J");
   ("/xf0/x9d/x98/xac", "MATHEMATICAL SANS-SERIF ITALIC SMALL K");
   ("/xf0/x9d/x98/xad", "MATHEMATICAL SANS-SERIF ITALIC SMALL L");
   ("/xf0/x9d/x98/xae", "MATHEMATICAL SANS-SERIF ITALIC SMALL M");
   ("/xf0/x9d/x98/xaf", "MATHEMATICAL SANS-SERIF ITALIC SMALL N");
   ("/xf0/x9d/x98/xb0", "MATHEMATICAL SANS-SERIF ITALIC SMALL O");
   ("/xf0/x9d/x98/xb1", "MATHEMATICAL SANS-SERIF ITALIC SMALL P");
   ("/xf0/x9d/x98/xb2", "MATHEMATICAL SANS-SERIF ITALIC SMALL Q");
   ("/xf0/x9d/x98/xb3", "MATHEMATICAL SANS-SERIF ITALIC SMALL R");
   ("/xf0/x9d/x98/xb4", "MATHEMATICAL SANS-SERIF ITALIC SMALL S");
   ("/xf0/x9d/x98/xb5", "MATHEMATICAL SANS-SERIF ITALIC SMALL T");
   ("/xf0/x9d/x98/xb6", "MATHEMATICAL SANS-SERIF ITALIC SMALL U");
   ("/xf0/x9d/x98/xb7", "MATHEMATICAL SANS-SERIF ITALIC SMALL V");
   ("/xf0/x9d/x98/xb8", "MATHEMATICAL SANS-SERIF ITALIC SMALL W");
   ("/xf0/x9d/x98/xb9", "MATHEMATICAL SANS-SERIF ITALIC SMALL X");
   ("/xf0/x9d/x98/xba", "MATHEMATICAL SANS-SERIF ITALIC SMALL Y");
   ("/xf0/x9d/x98/xbb", "MATHEMATICAL SANS-SERIF ITALIC SMALL Z");
   ("/xf0/x9d/x98/xbc", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A");
   ("/xf0/x9d/x98/xbd", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B");
   ("/xf0/x9d/x98/xbe", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C");
   ("/xf0/x9d/x98/xbf", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D");
   ("/xf0/x9d/x99/x80", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E");
   ("/xf0/x9d/x99/x81", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F");
   ("/xf0/x9d/x99/x82", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G");
   ("/xf0/x9d/x99/x83", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H");
   ("/xf0/x9d/x99/x84", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I");
   ("/xf0/x9d/x99/x85", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J");
   ("/xf0/x9d/x99/x86", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K");
   ("/xf0/x9d/x99/x87", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L");
   ("/xf0/x9d/x99/x88", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M");
   ("/xf0/x9d/x99/x89", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N");
   ("/xf0/x9d/x99/x8a", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O");
   ("/xf0/x9d/x99/x8b", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P");
   ("/xf0/x9d/x99/x8c", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q");
   ("/xf0/x9d/x99/x8d", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R");
   ("/xf0/x9d/x99/x8e", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S");
   ("/xf0/x9d/x99/x8f", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T");
   ("/xf0/x9d/x99/x90", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U");
   ("/xf0/x9d/x99/x91", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V");
   ("/xf0/x9d/x99/x92", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W");
   ("/xf0/x9d/x99/x93", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X");
   ("/xf0/x9d/x99/x94", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y");
   ("/xf0/x9d/x99/x95", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z");
   ("/xf0/x9d/x99/x96", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A");
   ("/xf0/x9d/x99/x97", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B");
   ("/xf0/x9d/x99/x98", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C");
   ("/xf0/x9d/x99/x99", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D");
   ("/xf0/x9d/x99/x9a", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E");
   ("/xf0/x9d/x99/x9b", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F");
   ("/xf0/x9d/x99/x9c", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G");
   ("/xf0/x9d/x99/x9d", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H");
   ("/xf0/x9d/x99/x9e", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I");
   ("/xf0/x9d/x99/x9f", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J");
   ("/xf0/x9d/x99/xa0", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K");
   ("/xf0/x9d/x99/xa1", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L");
   ("/xf0/x9d/x99/xa2", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M");
   ("/xf0/x9d/x99/xa3", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N");
   ("/xf0/x9d/x99/xa4", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O");
   ("/xf0/x9d/x99/xa5", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P");
   ("/xf0/x9d/x99/xa6", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q");
   ("/xf0/x9d/x99/xa7", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R");
   ("/xf0/x9d/x99/xa8", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S");
   ("/xf0/x9d/x99/xa9", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T");
   ("/xf0/x9d/x99/xaa", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U");
   ("/xf0/x9d/x99/xab", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V");
   ("/xf0/x9d/x99/xac", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W");
   ("/xf0/x9d/x99/xad", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X");
   ("/xf0/x9d/x99/xae", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y");
   ("/xf0/x9d/x99/xaf", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z");
   ("/xf0/x9d/x99/xb0", "MATHEMATICAL MONOSPACE CAPITAL A");
   ("/xf0/x9d/x99/xb1", "MATHEMATICAL MONOSPACE CAPITAL B");
   ("/xf0/x9d/x99/xb2", "MATHEMATICAL MONOSPACE CAPITAL C");
   ("/xf0/x9d/x99/xb3", "MATHEMATICAL MONOSPACE CAPITAL D");
   ("/xf0/x9d/x99/xb4", "MATHEMATICAL MONOSPACE CAPITAL E");
   ("/xf0/x9d/x99/xb5", "MATHEMATICAL MONOSPACE CAPITAL F");
   ("/xf0/x9d/x99/xb6", "MATHEMATICAL MONOSPACE CAPITAL G");
   ("/xf0/x9d/x99/xb7", "MATHEMATICAL MONOSPACE CAPITAL H");
   ("/xf0/x9d/x99/xb8", "MATHEMATICAL MONOSPACE CAPITAL I");
   ("/xf0/x9d/x99/xb9", "MATHEMATICAL MONOSPACE CAPITAL J");
   ("/xf0/x9d/x99/xba", "MATHEMATICAL MONOSPACE CAPITAL K");
   ("/xf0/x9d/x99/xbb", "MATHEMATICAL MONOSPACE CAPITAL L");
   ("/xf0/x9d/x99/xbc", "MATHEMATICAL MONOSPACE CAPITAL M");
   ("/xf0/x9d/x99/xbd", "MATHEMATICAL MONOSPACE CAPITAL N");
   ("/xf0/x9d/x99/xbe", "MATHEMATICAL MONOSPACE CAPITAL O");
   ("/xf0/x9d/x99/xbf", "MATHEMATICAL MONOSPACE CAPITAL P");
   ("/xf0/x9d/x9a/x80", "MATHEMATICAL MONOSPACE CAPITAL Q");
   ("/xf0/x9d/x9a/x81", "MATHEMATICAL MONOSPACE CAPITAL R");
   ("/xf0/x9d/x9a/x82", "MATHEMATICAL MONOSPACE CAPITAL S");
   ("/xf0/x9d/x9a/x83", "MATHEMATICAL MONOSPACE CAPITAL T");
   ("/xf0/x9d/x9a/x84", "MATHEMATICAL MONOSPACE CAPITAL U");
   ("/xf0/x9d/x9a/x85", "MATHEMATICAL MONOSPACE CAPITAL V");
   ("/xf0/x9d/x9a/x86", "MATHEMATICAL MONOSPACE CAPITAL W");
   ("/xf0/x9d/x9a/x87", "MATHEMATICAL MONOSPACE CAPITAL X");
   ("/xf0/x9d/x9a/x88", "MATHEMATICAL MONOSPACE CAPITAL Y");
   ("/xf0/x9d/x9a/x89", "MATHEMATICAL MONOSPACE CAPITAL Z");
   ("/xf0/x9d/x9a/x8a", "MATHEMATICAL MONOSPACE SMALL A");
   ("/xf0/x9d/x9a/x8b", "MATHEMATICAL MONOSPACE SMALL B");
   ("/xf0/x9d/x9a/x8c", "MATHEMATICAL MONOSPACE SMALL C");
   ("/xf0/x9d/x9a/x8d", "MATHEMATICAL MONOSPACE SMALL D");
   ("/xf0/x9d/x9a/x8e", "MATHEMATICAL MONOSPACE SMALL E");
   ("/xf0/x9d/x9a/x8f", "MATHEMATICAL MONOSPACE SMALL F");
   ("/xf0/x9d/x9a/x90", "MATHEMATICAL MONOSPACE SMALL G");
   ("/xf0/x9d/x9a/x91", "MATHEMATICAL MONOSPACE SMALL H");
   ("/xf0/x9d/x9a/x92", "MATHEMATICAL MONOSPACE SMALL I");
   ("/xf0/x9d/x9a/x93", "MATHEMATICAL MONOSPACE SMALL J");
   ("/xf0/x9d/x9a/x94", "MATHEMATICAL MONOSPACE SMALL K");
   ("/xf0/x9d/x9a/x95", "MATHEMATICAL MONOSPACE SMALL L");
   ("/xf0/x9d/x9a/x96", "MATHEMATICAL MONOSPACE SMALL M");
   ("/xf0/x9d/x9a/x97", "MATHEMATICAL MONOSPACE SMALL N");
   ("/xf0/x9d/x9a/x98", "MATHEMATICAL MONOSPACE SMALL O");
   ("/xf0/x9d/x9a/x99", "MATHEMATICAL MONOSPACE SMALL P");
   ("/xf0/x9d/x9a/x9a", "MATHEMATICAL MONOSPACE SMALL Q");
   ("/xf0/x9d/x9a/x9b", "MATHEMATICAL MONOSPACE SMALL R");
   ("/xf0/x9d/x9a/x9c", "MATHEMATICAL MONOSPACE SMALL S");
   ("/xf0/x9d/x9a/x9d", "MATHEMATICAL MONOSPACE SMALL T");
   ("/xf0/x9d/x9a/x9e", "MATHEMATICAL MONOSPACE SMALL U");
   ("/xf0/x9d/x9a/x9f", "MATHEMATICAL MONOSPACE SMALL V");
   ("/xf0/x9d/x9a/xa0", "MATHEMATICAL MONOSPACE SMALL W");
   ("/xf0/x9d/x9a/xa1", "MATHEMATICAL MONOSPACE SMALL X");
   ("/xf0/x9d/x9a/xa2", "MATHEMATICAL MONOSPACE SMALL Y");
   ("/xf0/x9d/x9a/xa3", "MATHEMATICAL MONOSPACE SMALL Z");
   ("/xf0/x9d/x9a/xa4", "MATHEMATICAL ITALIC SMALL DOTLESS I");
   ("/xf0/x9d/x9a/xa5", "MATHEMATICAL ITALIC SMALL DOTLESS J");
   ("/xf0/x9d/x9a/xa8", "MATHEMATICAL BOLD CAPITAL ALPHA");
   ("/xf0/x9d/x9a/xa9", "MATHEMATICAL BOLD CAPITAL BETA");
   ("/xf0/x9d/x9a/xaa", "MATHEMATICAL BOLD CAPITAL GAMMA");
   ("/xf0/x9d/x9a/xab", "MATHEMATICAL BOLD CAPITAL DELTA");
   ("/xf0/x9d/x9a/xac", "MATHEMATICAL BOLD CAPITAL EPSILON");
   ("/xf0/x9d/x9a/xad", "MATHEMATICAL BOLD CAPITAL ZETA");
   ("/xf0/x9d/x9a/xae", "MATHEMATICAL BOLD CAPITAL ETA");
   ("/xf0/x9d/x9a/xaf", "MATHEMATICAL BOLD CAPITAL THETA");
   ("/xf0/x9d/x9a/xb0", "MATHEMATICAL BOLD CAPITAL IOTA");
   ("/xf0/x9d/x9a/xb1", "MATHEMATICAL BOLD CAPITAL KAPPA");
   ("/xf0/x9d/x9a/xb2", "MATHEMATICAL BOLD CAPITAL LAMDA");
   ("/xf0/x9d/x9a/xb3", "MATHEMATICAL BOLD CAPITAL MU");
   ("/xf0/x9d/x9a/xb4", "MATHEMATICAL BOLD CAPITAL NU");
   ("/xf0/x9d/x9a/xb5", "MATHEMATICAL BOLD CAPITAL XI");
   ("/xf0/x9d/x9a/xb6", "MATHEMATICAL BOLD CAPITAL OMICRON");
   ("/xf0/x9d/x9a/xb7", "MATHEMATICAL BOLD CAPITAL PI");
   ("/xf0/x9d/x9a/xb8", "MATHEMATICAL BOLD CAPITAL RHO");
   ("/xf0/x9d/x9a/xb9", "MATHEMATICAL BOLD CAPITAL THETA SYMBOL");
   ("/xf0/x9d/x9a/xba", "MATHEMATICAL BOLD CAPITAL SIGMA");
   ("/xf0/x9d/x9a/xbb", "MATHEMATICAL BOLD CAPITAL TAU");
   ("/xf0/x9d/x9a/xbc", "MATHEMATICAL BOLD CAPITAL UPSILON");
   ("/xf0/x9d/x9a/xbd", "MATHEMATICAL BOLD CAPITAL PHI");
   ("/xf0/x9d/x9a/xbe", "MATHEMATICAL BOLD CAPITAL CHI");
   ("/xf0/x9d/x9a/xbf", "MATHEMATICAL BOLD CAPITAL PSI");
   ("/xf0/x9d/x9b/x80", "MATHEMATICAL BOLD CAPITAL OMEGA");
   ("/xf0/x9d/x9b/x82", "MATHEMATICAL BOLD SMALL ALPHA");
   ("/xf0/x9d/x9b/x83", "MATHEMATICAL BOLD SMALL BETA");
   ("/xf0/x9d/x9b/x84", "MATHEMATICAL BOLD SMALL GAMMA");
   ("/xf0/x9d/x9b/x85", "MATHEMATICAL BOLD SMALL DELTA");
   ("/xf0/x9d/x9b/x86", "MATHEMATICAL BOLD SMALL EPSILON");
   ("/xf0/x9d/x9b/x87", "MATHEMATICAL BOLD SMALL ZETA");
   ("/xf0/x9d/x9b/x88", "MATHEMATICAL BOLD SMALL ETA");
   ("/xf0/x9d/x9b/x89", "MATHEMATICAL BOLD SMALL THETA");
   ("/xf0/x9d/x9b/x8a", "MATHEMATICAL BOLD SMALL IOTA");
   ("/xf0/x9d/x9b/x8b", "MATHEMATICAL BOLD SMALL KAPPA");
   ("/xf0/x9d/x9b/x8c", "MATHEMATICAL BOLD SMALL LAMDA");
   ("/xf0/x9d/x9b/x8d", "MATHEMATICAL BOLD SMALL MU");
   ("/xf0/x9d/x9b/x8e", "MATHEMATICAL BOLD SMALL NU");
   ("/xf0/x9d/x9b/x8f", "MATHEMATICAL BOLD SMALL XI");
   ("/xf0/x9d/x9b/x90", "MATHEMATICAL BOLD SMALL OMICRON");
   ("/xf0/x9d/x9b/x91", "MATHEMATICAL BOLD SMALL PI");
   ("/xf0/x9d/x9b/x92", "MATHEMATICAL BOLD SMALL RHO");
   ("/xf0/x9d/x9b/x93", "MATHEMATICAL BOLD SMALL FINAL SIGMA");
   ("/xf0/x9d/x9b/x94", "MATHEMATICAL BOLD SMALL SIGMA");
   ("/xf0/x9d/x9b/x95", "MATHEMATICAL BOLD SMALL TAU");
   ("/xf0/x9d/x9b/x96", "MATHEMATICAL BOLD SMALL UPSILON");
   ("/xf0/x9d/x9b/x97", "MATHEMATICAL BOLD SMALL PHI");
   ("/xf0/x9d/x9b/x98", "MATHEMATICAL BOLD SMALL CHI");
   ("/xf0/x9d/x9b/x99", "MATHEMATICAL BOLD SMALL PSI");
   ("/xf0/x9d/x9b/x9a", "MATHEMATICAL BOLD SMALL OMEGA");
   ("/xf0/x9d/x9b/xa2", "MATHEMATICAL ITALIC CAPITAL ALPHA");
   ("/xf0/x9d/x9b/xa3", "MATHEMATICAL ITALIC CAPITAL BETA");
   ("/xf0/x9d/x9b/xa4", "MATHEMATICAL ITALIC CAPITAL GAMMA");
   ("/xf0/x9d/x9b/xa5", "MATHEMATICAL ITALIC CAPITAL DELTA");
   ("/xf0/x9d/x9b/xa6", "MATHEMATICAL ITALIC CAPITAL EPSILON");
   ("/xf0/x9d/x9b/xa7", "MATHEMATICAL ITALIC CAPITAL ZETA");
   ("/xf0/x9d/x9b/xa8", "MATHEMATICAL ITALIC CAPITAL ETA");
   ("/xf0/x9d/x9b/xa9", "MATHEMATICAL ITALIC CAPITAL THETA");
   ("/xf0/x9d/x9b/xaa", "MATHEMATICAL ITALIC CAPITAL IOTA");
   ("/xf0/x9d/x9b/xab", "MATHEMATICAL ITALIC CAPITAL KAPPA");
   ("/xf0/x9d/x9b/xac", "MATHEMATICAL ITALIC CAPITAL LAMDA");
   ("/xf0/x9d/x9b/xad", "MATHEMATICAL ITALIC CAPITAL MU");
   ("/xf0/x9d/x9b/xae", "MATHEMATICAL ITALIC CAPITAL NU");
   ("/xf0/x9d/x9b/xaf", "MATHEMATICAL ITALIC CAPITAL XI");
   ("/xf0/x9d/x9b/xb0", "MATHEMATICAL ITALIC CAPITAL OMICRON");
   ("/xf0/x9d/x9b/xb1", "MATHEMATICAL ITALIC CAPITAL PI");
   ("/xf0/x9d/x9b/xb2", "MATHEMATICAL ITALIC CAPITAL RHO");
   ("/xf0/x9d/x9b/xb3", "MATHEMATICAL ITALIC CAPITAL THETA SYMBOL");
   ("/xf0/x9d/x9b/xb4", "MATHEMATICAL ITALIC CAPITAL SIGMA");
   ("/xf0/x9d/x9b/xb5", "MATHEMATICAL ITALIC CAPITAL TAU");
   ("/xf0/x9d/x9b/xb6", "MATHEMATICAL ITALIC CAPITAL UPSILON");
   ("/xf0/x9d/x9b/xb7", "MATHEMATICAL ITALIC CAPITAL PHI");
   ("/xf0/x9d/x9b/xb8", "MATHEMATICAL ITALIC CAPITAL CHI");
   ("/xf0/x9d/x9b/xb9", "MATHEMATICAL ITALIC CAPITAL PSI");
   ("/xf0/x9d/x9b/xba", "MATHEMATICAL ITALIC CAPITAL OMEGA");
   ("/xf0/x9d/x9b/xbc", "MATHEMATICAL ITALIC SMALL ALPHA");
   ("/xf0/x9d/x9b/xbd", "MATHEMATICAL ITALIC SMALL BETA");
   ("/xf0/x9d/x9b/xbe", "MATHEMATICAL ITALIC SMALL GAMMA");
   ("/xf0/x9d/x9b/xbf", "MATHEMATICAL ITALIC SMALL DELTA");
   ("/xf0/x9d/x9c/x80", "MATHEMATICAL ITALIC SMALL EPSILON");
   ("/xf0/x9d/x9c/x81", "MATHEMATICAL ITALIC SMALL ZETA");
   ("/xf0/x9d/x9c/x82", "MATHEMATICAL ITALIC SMALL ETA");
   ("/xf0/x9d/x9c/x83", "MATHEMATICAL ITALIC SMALL THETA");
   ("/xf0/x9d/x9c/x84", "MATHEMATICAL ITALIC SMALL IOTA");
   ("/xf0/x9d/x9c/x85", "MATHEMATICAL ITALIC SMALL KAPPA");
   ("/xf0/x9d/x9c/x86", "MATHEMATICAL ITALIC SMALL LAMDA");
   ("/xf0/x9d/x9c/x87", "MATHEMATICAL ITALIC SMALL MU");
   ("/xf0/x9d/x9c/x88", "MATHEMATICAL ITALIC SMALL NU");
   ("/xf0/x9d/x9c/x89", "MATHEMATICAL ITALIC SMALL XI");
   ("/xf0/x9d/x9c/x8a", "MATHEMATICAL ITALIC SMALL OMICRON");
   ("/xf0/x9d/x9c/x8b", "MATHEMATICAL ITALIC SMALL PI");
   ("/xf0/x9d/x9c/x8c", "MATHEMATICAL ITALIC SMALL RHO");
   ("/xf0/x9d/x9c/x8d", "MATHEMATICAL ITALIC SMALL FINAL SIGMA");
   ("/xf0/x9d/x9c/x8e", "MATHEMATICAL ITALIC SMALL SIGMA");
   ("/xf0/x9d/x9c/x8f", "MATHEMATICAL ITALIC SMALL TAU");
   ("/xf0/x9d/x9c/x90", "MATHEMATICAL ITALIC SMALL UPSILON");
   ("/xf0/x9d/x9c/x91", "MATHEMATICAL ITALIC SMALL PHI");
   ("/xf0/x9d/x9c/x92", "MATHEMATICAL ITALIC SMALL CHI");
   ("/xf0/x9d/x9c/x93", "MATHEMATICAL ITALIC SMALL PSI");
   ("/xf0/x9d/x9c/x94", "MATHEMATICAL ITALIC SMALL OMEGA");
   ("/xf0/x9d/x9c/x9c", "MATHEMATICAL BOLD ITALIC CAPITAL ALPHA");
   ("/xf0/x9d/x9c/x9d", "MATHEMATICAL BOLD ITALIC CAPITAL BETA");
   ("/xf0/x9d/x9c/x9e", "MATHEMATICAL BOLD ITALIC CAPITAL GAMMA");
   ("/xf0/x9d/x9c/x9f", "MATHEMATICAL BOLD ITALIC CAPITAL DELTA");
   ("/xf0/x9d/x9c/xa0", "MATHEMATICAL BOLD ITALIC CAPITAL EPSILON");
   ("/xf0/x9d/x9c/xa1", "MATHEMATICAL BOLD ITALIC CAPITAL ZETA");
   ("/xf0/x9d/x9c/xa2", "MATHEMATICAL BOLD ITALIC CAPITAL ETA");
   ("/xf0/x9d/x9c/xa3", "MATHEMATICAL BOLD ITALIC CAPITAL THETA");
   ("/xf0/x9d/x9c/xa4", "MATHEMATICAL BOLD ITALIC CAPITAL IOTA");
   ("/xf0/x9d/x9c/xa5", "MATHEMATICAL BOLD ITALIC CAPITAL KAPPA");
   ("/xf0/x9d/x9c/xa6", "MATHEMATICAL BOLD ITALIC CAPITAL LAMDA");
   ("/xf0/x9d/x9c/xa7", "MATHEMATICAL BOLD ITALIC CAPITAL MU");
   ("/xf0/x9d/x9c/xa8", "MATHEMATICAL BOLD ITALIC CAPITAL NU");
   ("/xf0/x9d/x9c/xa9", "MATHEMATICAL BOLD ITALIC CAPITAL XI");
   ("/xf0/x9d/x9c/xaa", "MATHEMATICAL BOLD ITALIC CAPITAL OMICRON");
   ("/xf0/x9d/x9c/xab", "MATHEMATICAL BOLD ITALIC CAPITAL PI");
   ("/xf0/x9d/x9c/xac", "MATHEMATICAL BOLD ITALIC CAPITAL RHO");
   ("/xf0/x9d/x9c/xad", "MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL");
   ("/xf0/x9d/x9c/xae", "MATHEMATICAL BOLD ITALIC CAPITAL SIGMA");
   ("/xf0/x9d/x9c/xaf", "MATHEMATICAL BOLD ITALIC CAPITAL TAU");
   ("/xf0/x9d/x9c/xb0", "MATHEMATICAL BOLD ITALIC CAPITAL UPSILON");
   ("/xf0/x9d/x9c/xb1", "MATHEMATICAL BOLD ITALIC CAPITAL PHI");
   ("/xf0/x9d/x9c/xb2", "MATHEMATICAL BOLD ITALIC CAPITAL CHI");
   ("/xf0/x9d/x9c/xb3", "MATHEMATICAL BOLD ITALIC CAPITAL PSI");
   ("/xf0/x9d/x9c/xb4", "MATHEMATICAL BOLD ITALIC CAPITAL OMEGA");
   ("/xf0/x9d/x9c/xb6", "MATHEMATICAL BOLD ITALIC SMALL ALPHA");
   ("/xf0/x9d/x9c/xb7", "MATHEMATICAL BOLD ITALIC SMALL BETA");
   ("/xf0/x9d/x9c/xb8", "MATHEMATICAL BOLD ITALIC SMALL GAMMA");
   ("/xf0/x9d/x9c/xb9", "MATHEMATICAL BOLD ITALIC SMALL DELTA");
   ("/xf0/x9d/x9c/xba", "MATHEMATICAL BOLD ITALIC SMALL EPSILON");
   ("/xf0/x9d/x9c/xbb", "MATHEMATICAL BOLD ITALIC SMALL ZETA");
   ("/xf0/x9d/x9c/xbc", "MATHEMATICAL BOLD ITALIC SMALL ETA");
   ("/xf0/x9d/x9c/xbd", "MATHEMATICAL BOLD ITALIC SMALL THETA");
   ("/xf0/x9d/x9c/xbe", "MATHEMATICAL BOLD ITALIC SMALL IOTA");
   ("/xf0/x9d/x9c/xbf", "MATHEMATICAL BOLD ITALIC SMALL KAPPA");
   ("/xf0/x9d/x9d/x80", "MATHEMATICAL BOLD ITALIC SMALL LAMDA");
   ("/xf0/x9d/x9d/x81", "MATHEMATICAL BOLD ITALIC SMALL MU");
   ("/xf0/x9d/x9d/x82", "MATHEMATICAL BOLD ITALIC SMALL NU");
   ("/xf0/x9d/x9d/x83", "MATHEMATICAL BOLD ITALIC SMALL XI");
   ("/xf0/x9d/x9d/x84", "MATHEMATICAL BOLD ITALIC SMALL OMICRON");
   ("/xf0/x9d/x9d/x85", "MATHEMATICAL BOLD ITALIC SMALL PI");
   ("/xf0/x9d/x9d/x86", "MATHEMATICAL BOLD ITALIC SMALL RHO");
   ("/xf0/x9d/x9d/x87", "MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA");
   ("/xf0/x9d/x9d/x88", "MATHEMATICAL BOLD ITALIC SMALL SIGMA");
   ("/xf0/x9d/x9d/x89", "MATHEMATICAL BOLD ITALIC SMALL TAU");
   ("/xf0/x9d/x9d/x8a", "MATHEMATICAL BOLD ITALIC SMALL UPSILON");
   ("/xf0/x9d/x9d/x8b", "MATHEMATICAL BOLD ITALIC SMALL PHI");
   ("/xf0/x9d/x9d/x8c", "MATHEMATICAL BOLD ITALIC SMALL CHI");
   ("/xf0/x9d/x9d/x8d", "MATHEMATICAL BOLD ITALIC SMALL PSI");
   ("/xf0/x9d/x9d/x8e", "MATHEMATICAL BOLD ITALIC SMALL OMEGA");
   ("/xf0/x9d/x9d/x96", "MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA");
   ("/xf0/x9d/x9d/x97", "MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA");
   ("/xf0/x9d/x9d/x98", "MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA");
   ("/xf0/x9d/x9d/x99", "MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA");
   ("/xf0/x9d/x9d/x9a", "MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON");
   ("/xf0/x9d/x9d/x9b", "MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA");
   ("/xf0/x9d/x9d/x9c", "MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA");
   ("/xf0/x9d/x9d/x9d", "MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA");
   ("/xf0/x9d/x9d/x9e", "MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA");
   ("/xf0/x9d/x9d/x9f", "MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA");
   ("/xf0/x9d/x9d/xa0", "MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA");
   ("/xf0/x9d/x9d/xa1", "MATHEMATICAL SANS-SERIF BOLD CAPITAL MU");
   ("/xf0/x9d/x9d/xa2", "MATHEMATICAL SANS-SERIF BOLD CAPITAL NU");
   ("/xf0/x9d/x9d/xa3", "MATHEMATICAL SANS-SERIF BOLD CAPITAL XI");
   ("/xf0/x9d/x9d/xa4", "MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON");
   ("/xf0/x9d/x9d/xa5", "MATHEMATICAL SANS-SERIF BOLD CAPITAL PI");
   ("/xf0/x9d/x9d/xa6", "MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO");
   ("/xf0/x9d/x9d/xa7", "MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL");
   ("/xf0/x9d/x9d/xa8", "MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA");
   ("/xf0/x9d/x9d/xa9", "MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU");
   ("/xf0/x9d/x9d/xaa", "MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON");
   ("/xf0/x9d/x9d/xab", "MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI");
   ("/xf0/x9d/x9d/xac", "MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI");
   ("/xf0/x9d/x9d/xad", "MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI");
   ("/xf0/x9d/x9d/xae", "MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA");
   ("/xf0/x9d/x9d/xb0", "MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA");
   ("/xf0/x9d/x9d/xb1", "MATHEMATICAL SANS-SERIF BOLD SMALL BETA");
   ("/xf0/x9d/x9d/xb2", "MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA");
   ("/xf0/x9d/x9d/xb3", "MATHEMATICAL SANS-SERIF BOLD SMALL DELTA");
   ("/xf0/x9d/x9d/xb4", "MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON");
   ("/xf0/x9d/x9d/xb5", "MATHEMATICAL SANS-SERIF BOLD SMALL ZETA");
   ("/xf0/x9d/x9d/xb6", "MATHEMATICAL SANS-SERIF BOLD SMALL ETA");
   ("/xf0/x9d/x9d/xb7", "MATHEMATICAL SANS-SERIF BOLD SMALL THETA");
   ("/xf0/x9d/x9d/xb8", "MATHEMATICAL SANS-SERIF BOLD SMALL IOTA");
   ("/xf0/x9d/x9d/xb9", "MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA");
   ("/xf0/x9d/x9d/xba", "MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA");
   ("/xf0/x9d/x9d/xbb", "MATHEMATICAL SANS-SERIF BOLD SMALL MU");
   ("/xf0/x9d/x9d/xbc", "MATHEMATICAL SANS-SERIF BOLD SMALL NU");
   ("/xf0/x9d/x9d/xbd", "MATHEMATICAL SANS-SERIF BOLD SMALL XI");
   ("/xf0/x9d/x9d/xbe", "MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON");
   ("/xf0/x9d/x9d/xbf", "MATHEMATICAL SANS-SERIF BOLD SMALL PI");
   ("/xf0/x9d/x9e/x80", "MATHEMATICAL SANS-SERIF BOLD SMALL RHO");
   ("/xf0/x9d/x9e/x81", "MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA");
   ("/xf0/x9d/x9e/x82", "MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA");
   ("/xf0/x9d/x9e/x83", "MATHEMATICAL SANS-SERIF BOLD SMALL TAU");
   ("/xf0/x9d/x9e/x84", "MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON");
   ("/xf0/x9d/x9e/x85", "MATHEMATICAL SANS-SERIF BOLD SMALL PHI");
   ("/xf0/x9d/x9e/x86", "MATHEMATICAL SANS-SERIF BOLD SMALL CHI");
   ("/xf0/x9d/x9e/x87", "MATHEMATICAL SANS-SERIF BOLD SMALL PSI");
   ("/xf0/x9d/x9e/x88", "MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA");
   ("/xf0/x9d/x9e/x90", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA");
   ("/xf0/x9d/x9e/x91", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA");
   ("/xf0/x9d/x9e/x92", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA");
   ("/xf0/x9d/x9e/x93", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA");
   ("/xf0/x9d/x9e/x94", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON");
   ("/xf0/x9d/x9e/x95", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA");
   ("/xf0/x9d/x9e/x96", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA");
   ("/xf0/x9d/x9e/x97", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA");
   ("/xf0/x9d/x9e/x98", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA");
   ("/xf0/x9d/x9e/x99", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA");
   ("/xf0/x9d/x9e/x9a", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA");
   ("/xf0/x9d/x9e/x9b", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU");
   ("/xf0/x9d/x9e/x9c", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU");
   ("/xf0/x9d/x9e/x9d", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI");
   ("/xf0/x9d/x9e/x9e", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON");
   ("/xf0/x9d/x9e/x9f", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI");
   ("/xf0/x9d/x9e/xa0", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO");
   ("/xf0/x9d/x9e/xa1", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL");
   ("/xf0/x9d/x9e/xa2", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA");
   ("/xf0/x9d/x9e/xa3", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU");
   ("/xf0/x9d/x9e/xa4", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON");
   ("/xf0/x9d/x9e/xa5", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI");
   ("/xf0/x9d/x9e/xa6", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI");
   ("/xf0/x9d/x9e/xa7", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI");
   ("/xf0/x9d/x9e/xa8", "MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA");
   ("/xf0/x9d/x9e/xaa", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA");
   ("/xf0/x9d/x9e/xab", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA");
   ("/xf0/x9d/x9e/xac", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA");
   ("/xf0/x9d/x9e/xad", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA");
   ("/xf0/x9d/x9e/xae", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON");
   ("/xf0/x9d/x9e/xaf", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA");
   ("/xf0/x9d/x9e/xb0", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA");
   ("/xf0/x9d/x9e/xb1", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA");
   ("/xf0/x9d/x9e/xb2", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA");
   ("/xf0/x9d/x9e/xb3", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA");
   ("/xf0/x9d/x9e/xb4", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA");
   ("/xf0/x9d/x9e/xb5", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU");
   ("/xf0/x9d/x9e/xb6", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU");
   ("/xf0/x9d/x9e/xb7", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI");
   ("/xf0/x9d/x9e/xb8", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON");
   ("/xf0/x9d/x9e/xb9", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI");
   ("/xf0/x9d/x9e/xba", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO");
   ("/xf0/x9d/x9e/xbb", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA");
   ("/xf0/x9d/x9e/xbc", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA");
   ("/xf0/x9d/x9e/xbd", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU");
   ("/xf0/x9d/x9e/xbe", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON");
   ("/xf0/x9d/x9e/xbf", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI");
   ("/xf0/x9d/x9f/x80", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI");
   ("/xf0/x9d/x9f/x81", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI");
   ("/xf0/x9d/x9f/x82", "MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA");
   ("/xf0/x9d/x9f/x8a", "MATHEMATICAL BOLD CAPITAL DIGAMMA");
   ("/xf0/x9d/x9f/x8b", "MATHEMATICAL BOLD SMALL DIGAMMA");
   ("/xf3/xa0/x81/x81", "TAG LATIN CAPITAL LETTER A");
   ("/xf3/xa0/x81/x82", "TAG LATIN CAPITAL LETTER B");
   ("/xf3/xa0/x81/x83", "TAG LATIN CAPITAL LETTER C");
   ("/xf3/xa0/x81/x84", "TAG LATIN CAPITAL LETTER D");
   ("/xf3/xa0/x81/x85", "TAG LATIN CAPITAL LETTER E");
   ("/xf3/xa0/x81/x86", "TAG LATIN CAPITAL LETTER F");
   ("/xf3/xa0/x81/x87", "TAG LATIN CAPITAL LETTER G");
   ("/xf3/xa0/x81/x88", "TAG LATIN CAPITAL LETTER H");
   ("/xf3/xa0/x81/x89", "TAG LATIN CAPITAL LETTER I");
   ("/xf3/xa0/x81/x8a", "TAG LATIN CAPITAL LETTER J");
   ("/xf3/xa0/x81/x8b", "TAG LATIN CAPITAL LETTER K");
   ("/xf3/xa0/x81/x8c", "TAG LATIN CAPITAL LETTER L");
   ("/xf3/xa0/x81/x8d", "TAG LATIN CAPITAL LETTER M");
   ("/xf3/xa0/x81/x8e", "TAG LATIN CAPITAL LETTER N");
   ("/xf3/xa0/x81/x8f", "TAG LATIN CAPITAL LETTER O");
   ("/xf3/xa0/x81/x90", "TAG LATIN CAPITAL LETTER P");
   ("/xf3/xa0/x81/x91", "TAG LATIN CAPITAL LETTER Q");
   ("/xf3/xa0/x81/x92", "TAG LATIN CAPITAL LETTER R");
   ("/xf3/xa0/x81/x93", "TAG LATIN CAPITAL LETTER S");
   ("/xf3/xa0/x81/x94", "TAG LATIN CAPITAL LETTER T");
   ("/xf3/xa0/x81/x95", "TAG LATIN CAPITAL LETTER U");
   ("/xf3/xa0/x81/x96", "TAG LATIN CAPITAL LETTER V");
   ("/xf3/xa0/x81/x97", "TAG LATIN CAPITAL LETTER W");
   ("/xf3/xa0/x81/x98", "TAG LATIN CAPITAL LETTER X");
   ("/xf3/xa0/x81/x99", "TAG LATIN CAPITAL LETTER Y");
   ("/xf3/xa0/x81/x9a", "TAG LATIN CAPITAL LETTER Z");
   ("/xf3/xa0/x81/xa1", "TAG LATIN SMALL LETTER A");
   ("/xf3/xa0/x81/xa2", "TAG LATIN SMALL LETTER B");
   ("/xf3/xa0/x81/xa3", "TAG LATIN SMALL LETTER C");
   ("/xf3/xa0/x81/xa4", "TAG LATIN SMALL LETTER D");
   ("/xf3/xa0/x81/xa5", "TAG LATIN SMALL LETTER E");
   ("/xf3/xa0/x81/xa6", "TAG LATIN SMALL LETTER F");
   ("/xf3/xa0/x81/xa7", "TAG LATIN SMALL LETTER G");
   ("/xf3/xa0/x81/xa8", "TAG LATIN SMALL LETTER H");
   ("/xf3/xa0/x81/xa9", "TAG LATIN SMALL LETTER I");
   ("/xf3/xa0/x81/xaa", "TAG LATIN SMALL LETTER J");
   ("/xf3/xa0/x81/xab", "TAG LATIN SMALL LETTER K");
   ("/xf3/xa0/x81/xac", "TAG LATIN SMALL LETTER L");
   ("/xf3/xa0/x81/xad", "TAG LATIN SMALL LETTER M");
   ("/xf3/xa0/x81/xae", "TAG LATIN SMALL LETTER N");
   ("/xf3/xa0/x81/xaf", "TAG LATIN SMALL LETTER O");
   ("/xf3/xa0/x81/xb0", "TAG LATIN SMALL LETTER P");
   ("/xf3/xa0/x81/xb1", "TAG LATIN SMALL LETTER Q");
   ("/xf3/xa0/x81/xb2", "TAG LATIN SMALL LETTER R");
   ("/xf3/xa0/x81/xb3", "TAG LATIN SMALL LETTER S");
   ("/xf3/xa0/x81/xb4", "TAG LATIN SMALL LETTER T");
   ("/xf3/xa0/x81/xb5", "TAG LATIN SMALL LETTER U");
   ("/xf3/xa0/x81/xb6", "TAG LATIN SMALL LETTER V");
   ("/xf3/xa0/x81/xb7", "TAG LATIN SMALL LETTER W");
   ("/xf3/xa0/x81/xb8", "TAG LATIN SMALL LETTER X");
   ("/xf3/xa0/x81/xb9", "TAG LATIN SMALL LETTER Y");
   ("/xf3/xa0/x81/xba", "TAG LATIN SMALL LETTER Z")]
;
