/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the w64 mingw-runtime package.
 * No warranty is given; refer to the file DISCLAIMER.PD within this package.
 */
#ifndef __REQUIRED_RPCNDR_H_VERSION__
#define __REQUIRED_RPCNDR_H_VERSION__ 440
#endif

#include "rpc.h"
#include "rpcndr.h"

#ifndef __msxml2_h__
#define __msxml2_h__

#ifndef __IXMLDOMImplementation_FWD_DEFINED__
#define __IXMLDOMImplementation_FWD_DEFINED__
typedef struct IXMLDOMImplementation IXMLDOMImplementation;
#endif

#ifndef __IXMLDOMNode_FWD_DEFINED__
#define __IXMLDOMNode_FWD_DEFINED__
typedef struct IXMLDOMNode IXMLDOMNode;
#endif

#ifndef __IXMLDOMDocumentFragment_FWD_DEFINED__
#define __IXMLDOMDocumentFragment_FWD_DEFINED__
typedef struct IXMLDOMDocumentFragment IXMLDOMDocumentFragment;
#endif

#ifndef __IXMLDOMDocument_FWD_DEFINED__
#define __IXMLDOMDocument_FWD_DEFINED__
typedef struct IXMLDOMDocument IXMLDOMDocument;
#endif

#ifndef __IXMLDOMDocument2_FWD_DEFINED__
#define __IXMLDOMDocument2_FWD_DEFINED__
typedef struct IXMLDOMDocument2 IXMLDOMDocument2;
#endif

#ifndef __IXMLDOMNodeList_FWD_DEFINED__
#define __IXMLDOMNodeList_FWD_DEFINED__
typedef struct IXMLDOMNodeList IXMLDOMNodeList;
#endif

#ifndef __IXMLDOMNamedNodeMap_FWD_DEFINED__
#define __IXMLDOMNamedNodeMap_FWD_DEFINED__
typedef struct IXMLDOMNamedNodeMap IXMLDOMNamedNodeMap;
#endif

#ifndef __IXMLDOMCharacterData_FWD_DEFINED__
#define __IXMLDOMCharacterData_FWD_DEFINED__
typedef struct IXMLDOMCharacterData IXMLDOMCharacterData;
#endif

#ifndef __IXMLDOMAttribute_FWD_DEFINED__
#define __IXMLDOMAttribute_FWD_DEFINED__
typedef struct IXMLDOMAttribute IXMLDOMAttribute;
#endif

#ifndef __IXMLDOMElement_FWD_DEFINED__
#define __IXMLDOMElement_FWD_DEFINED__
typedef struct IXMLDOMElement IXMLDOMElement;
#endif

#ifndef __IXMLDOMText_FWD_DEFINED__
#define __IXMLDOMText_FWD_DEFINED__
typedef struct IXMLDOMText IXMLDOMText;
#endif

#ifndef __IXMLDOMComment_FWD_DEFINED__
#define __IXMLDOMComment_FWD_DEFINED__
typedef struct IXMLDOMComment IXMLDOMComment;
#endif

#ifndef __IXMLDOMProcessingInstruction_FWD_DEFINED__
#define __IXMLDOMProcessingInstruction_FWD_DEFINED__
typedef struct IXMLDOMProcessingInstruction IXMLDOMProcessingInstruction;
#endif

#ifndef __IXMLDOMCDATASection_FWD_DEFINED__
#define __IXMLDOMCDATASection_FWD_DEFINED__
typedef struct IXMLDOMCDATASection IXMLDOMCDATASection;
#endif

#ifndef __IXMLDOMDocumentType_FWD_DEFINED__
#define __IXMLDOMDocumentType_FWD_DEFINED__
typedef struct IXMLDOMDocumentType IXMLDOMDocumentType;
#endif

#ifndef __IXMLDOMNotation_FWD_DEFINED__
#define __IXMLDOMNotation_FWD_DEFINED__
typedef struct IXMLDOMNotation IXMLDOMNotation;
#endif

#ifndef __IXMLDOMEntity_FWD_DEFINED__
#define __IXMLDOMEntity_FWD_DEFINED__
typedef struct IXMLDOMEntity IXMLDOMEntity;
#endif

#ifndef __IXMLDOMEntityReference_FWD_DEFINED__
#define __IXMLDOMEntityReference_FWD_DEFINED__
typedef struct IXMLDOMEntityReference IXMLDOMEntityReference;
#endif

#ifndef __IXMLDOMParseError_FWD_DEFINED__
#define __IXMLDOMParseError_FWD_DEFINED__
typedef struct IXMLDOMParseError IXMLDOMParseError;
#endif

#ifndef __IXMLDOMSchemaCollection_FWD_DEFINED__
#define __IXMLDOMSchemaCollection_FWD_DEFINED__
typedef struct IXMLDOMSchemaCollection IXMLDOMSchemaCollection;
#endif

#ifndef __IXTLRuntime_FWD_DEFINED__
#define __IXTLRuntime_FWD_DEFINED__
typedef struct IXTLRuntime IXTLRuntime;
#endif

#ifndef __IXSLTemplate_FWD_DEFINED__
#define __IXSLTemplate_FWD_DEFINED__
typedef struct IXSLTemplate IXSLTemplate;
#endif

#ifndef __IXSLProcessor_FWD_DEFINED__
#define __IXSLProcessor_FWD_DEFINED__
typedef struct IXSLProcessor IXSLProcessor;
#endif

#ifndef __ISAXXMLReader_FWD_DEFINED__
#define __ISAXXMLReader_FWD_DEFINED__
typedef struct ISAXXMLReader ISAXXMLReader;
#endif

#ifndef __ISAXXMLFilter_FWD_DEFINED__
#define __ISAXXMLFilter_FWD_DEFINED__
typedef struct ISAXXMLFilter ISAXXMLFilter;
#endif

#ifndef __ISAXLocator_FWD_DEFINED__
#define __ISAXLocator_FWD_DEFINED__
typedef struct ISAXLocator ISAXLocator;
#endif

#ifndef __ISAXEntityResolver_FWD_DEFINED__
#define __ISAXEntityResolver_FWD_DEFINED__
typedef struct ISAXEntityResolver ISAXEntityResolver;
#endif

#ifndef __ISAXContentHandler_FWD_DEFINED__
#define __ISAXContentHandler_FWD_DEFINED__
typedef struct ISAXContentHandler ISAXContentHandler;
#endif

#ifndef __ISAXDTDHandler_FWD_DEFINED__
#define __ISAXDTDHandler_FWD_DEFINED__
typedef struct ISAXDTDHandler ISAXDTDHandler;
#endif

#ifndef __ISAXErrorHandler_FWD_DEFINED__
#define __ISAXErrorHandler_FWD_DEFINED__
typedef struct ISAXErrorHandler ISAXErrorHandler;
#endif

#ifndef __ISAXLexicalHandler_FWD_DEFINED__
#define __ISAXLexicalHandler_FWD_DEFINED__
typedef struct ISAXLexicalHandler ISAXLexicalHandler;
#endif

#ifndef __ISAXDeclHandler_FWD_DEFINED__
#define __ISAXDeclHandler_FWD_DEFINED__
typedef struct ISAXDeclHandler ISAXDeclHandler;
#endif

#ifndef __ISAXAttributes_FWD_DEFINED__
#define __ISAXAttributes_FWD_DEFINED__
typedef struct ISAXAttributes ISAXAttributes;
#endif

#ifndef __IVBSAXXMLReader_FWD_DEFINED__
#define __IVBSAXXMLReader_FWD_DEFINED__
typedef struct IVBSAXXMLReader IVBSAXXMLReader;
#endif

#ifndef __IVBSAXXMLFilter_FWD_DEFINED__
#define __IVBSAXXMLFilter_FWD_DEFINED__
typedef struct IVBSAXXMLFilter IVBSAXXMLFilter;
#endif

#ifndef __IVBSAXLocator_FWD_DEFINED__
#define __IVBSAXLocator_FWD_DEFINED__
typedef struct IVBSAXLocator IVBSAXLocator;
#endif

#ifndef __IVBSAXEntityResolver_FWD_DEFINED__
#define __IVBSAXEntityResolver_FWD_DEFINED__
typedef struct IVBSAXEntityResolver IVBSAXEntityResolver;
#endif

#ifndef __IVBSAXContentHandler_FWD_DEFINED__
#define __IVBSAXContentHandler_FWD_DEFINED__
typedef struct IVBSAXContentHandler IVBSAXContentHandler;
#endif

#ifndef __IVBSAXDTDHandler_FWD_DEFINED__
#define __IVBSAXDTDHandler_FWD_DEFINED__
typedef struct IVBSAXDTDHandler IVBSAXDTDHandler;
#endif

#ifndef __IVBSAXErrorHandler_FWD_DEFINED__
#define __IVBSAXErrorHandler_FWD_DEFINED__
typedef struct IVBSAXErrorHandler IVBSAXErrorHandler;
#endif

#ifndef __IVBSAXLexicalHandler_FWD_DEFINED__
#define __IVBSAXLexicalHandler_FWD_DEFINED__
typedef struct IVBSAXLexicalHandler IVBSAXLexicalHandler;
#endif

#ifndef __IVBSAXDeclHandler_FWD_DEFINED__
#define __IVBSAXDeclHandler_FWD_DEFINED__
typedef struct IVBSAXDeclHandler IVBSAXDeclHandler;
#endif

#ifndef __IVBSAXAttributes_FWD_DEFINED__
#define __IVBSAXAttributes_FWD_DEFINED__
typedef struct IVBSAXAttributes IVBSAXAttributes;
#endif

#ifndef __IMXWriter_FWD_DEFINED__
#define __IMXWriter_FWD_DEFINED__
typedef struct IMXWriter IMXWriter;
#endif

#ifndef __IMXAttributes_FWD_DEFINED__
#define __IMXAttributes_FWD_DEFINED__
typedef struct IMXAttributes IMXAttributes;
#endif

#ifndef __IMXReaderControl_FWD_DEFINED__
#define __IMXReaderControl_FWD_DEFINED__
typedef struct IMXReaderControl IMXReaderControl;
#endif

#ifndef __IMXSchemaDeclHandler_FWD_DEFINED__
#define __IMXSchemaDeclHandler_FWD_DEFINED__
typedef struct IMXSchemaDeclHandler IMXSchemaDeclHandler;
#endif

#ifndef __IXMLDOMSchemaCollection2_FWD_DEFINED__
#define __IXMLDOMSchemaCollection2_FWD_DEFINED__
typedef struct IXMLDOMSchemaCollection2 IXMLDOMSchemaCollection2;
#endif

#ifndef __ISchemaStringCollection_FWD_DEFINED__
#define __ISchemaStringCollection_FWD_DEFINED__
typedef struct ISchemaStringCollection ISchemaStringCollection;
#endif

#ifndef __ISchemaItemCollection_FWD_DEFINED__
#define __ISchemaItemCollection_FWD_DEFINED__
typedef struct ISchemaItemCollection ISchemaItemCollection;
#endif

#ifndef __ISchemaItem_FWD_DEFINED__
#define __ISchemaItem_FWD_DEFINED__
typedef struct ISchemaItem ISchemaItem;
#endif

#ifndef __ISchema_FWD_DEFINED__
#define __ISchema_FWD_DEFINED__
typedef struct ISchema ISchema;
#endif

#ifndef __ISchemaParticle_FWD_DEFINED__
#define __ISchemaParticle_FWD_DEFINED__
typedef struct ISchemaParticle ISchemaParticle;
#endif

#ifndef __ISchemaAttribute_FWD_DEFINED__
#define __ISchemaAttribute_FWD_DEFINED__
typedef struct ISchemaAttribute ISchemaAttribute;
#endif

#ifndef __ISchemaElement_FWD_DEFINED__
#define __ISchemaElement_FWD_DEFINED__
typedef struct ISchemaElement ISchemaElement;
#endif

#ifndef __ISchemaType_FWD_DEFINED__
#define __ISchemaType_FWD_DEFINED__
typedef struct ISchemaType ISchemaType;
#endif

#ifndef __ISchemaComplexType_FWD_DEFINED__
#define __ISchemaComplexType_FWD_DEFINED__
typedef struct ISchemaComplexType ISchemaComplexType;
#endif

#ifndef __ISchemaAttributeGroup_FWD_DEFINED__
#define __ISchemaAttributeGroup_FWD_DEFINED__
typedef struct ISchemaAttributeGroup ISchemaAttributeGroup;
#endif

#ifndef __ISchemaModelGroup_FWD_DEFINED__
#define __ISchemaModelGroup_FWD_DEFINED__
typedef struct ISchemaModelGroup ISchemaModelGroup;
#endif

#ifndef __ISchemaAny_FWD_DEFINED__
#define __ISchemaAny_FWD_DEFINED__
typedef struct ISchemaAny ISchemaAny;
#endif

#ifndef __ISchemaIdentityConstraint_FWD_DEFINED__
#define __ISchemaIdentityConstraint_FWD_DEFINED__
typedef struct ISchemaIdentityConstraint ISchemaIdentityConstraint;
#endif

#ifndef __ISchemaNotation_FWD_DEFINED__
#define __ISchemaNotation_FWD_DEFINED__
typedef struct ISchemaNotation ISchemaNotation;
#endif

#ifndef __IXMLElementCollection_FWD_DEFINED__
#define __IXMLElementCollection_FWD_DEFINED__
typedef struct IXMLElementCollection IXMLElementCollection;
#endif

#ifndef __IXMLDocument_FWD_DEFINED__
#define __IXMLDocument_FWD_DEFINED__
typedef struct IXMLDocument IXMLDocument;
#endif

#ifndef __IXMLDocument2_FWD_DEFINED__
#define __IXMLDocument2_FWD_DEFINED__
typedef struct IXMLDocument2 IXMLDocument2;
#endif

#ifndef __IXMLElement_FWD_DEFINED__
#define __IXMLElement_FWD_DEFINED__
typedef struct IXMLElement IXMLElement;
#endif

#ifndef __IXMLElement2_FWD_DEFINED__
#define __IXMLElement2_FWD_DEFINED__
typedef struct IXMLElement2 IXMLElement2;
#endif

#ifndef __IXMLAttribute_FWD_DEFINED__
#define __IXMLAttribute_FWD_DEFINED__
typedef struct IXMLAttribute IXMLAttribute;
#endif

#ifndef __IXMLError_FWD_DEFINED__
#define __IXMLError_FWD_DEFINED__
typedef struct IXMLError IXMLError;
#endif

#ifndef __IXMLDOMSelection_FWD_DEFINED__
#define __IXMLDOMSelection_FWD_DEFINED__
typedef struct IXMLDOMSelection IXMLDOMSelection;
#endif

#ifndef __XMLDOMDocumentEvents_FWD_DEFINED__
#define __XMLDOMDocumentEvents_FWD_DEFINED__
typedef struct XMLDOMDocumentEvents XMLDOMDocumentEvents;
#endif

#ifndef __IDSOControl_FWD_DEFINED__
#define __IDSOControl_FWD_DEFINED__
typedef struct IDSOControl IDSOControl;
#endif

#ifndef __IXMLHTTPRequest_FWD_DEFINED__
#define __IXMLHTTPRequest_FWD_DEFINED__
typedef struct IXMLHTTPRequest IXMLHTTPRequest;
#endif

#ifndef __IServerXMLHTTPRequest_FWD_DEFINED__
#define __IServerXMLHTTPRequest_FWD_DEFINED__
typedef struct IServerXMLHTTPRequest IServerXMLHTTPRequest;
#endif

#ifndef __IServerXMLHTTPRequest2_FWD_DEFINED__
#define __IServerXMLHTTPRequest2_FWD_DEFINED__
typedef struct IServerXMLHTTPRequest2 IServerXMLHTTPRequest2;
#endif

#ifndef __IMXNamespacePrefixes_FWD_DEFINED__
#define __IMXNamespacePrefixes_FWD_DEFINED__
typedef struct IMXNamespacePrefixes IMXNamespacePrefixes;
#endif

#ifndef __IVBMXNamespaceManager_FWD_DEFINED__
#define __IVBMXNamespaceManager_FWD_DEFINED__
typedef struct IVBMXNamespaceManager IVBMXNamespaceManager;
#endif

#ifndef __IMXNamespaceManager_FWD_DEFINED__
#define __IMXNamespaceManager_FWD_DEFINED__
typedef struct IMXNamespaceManager IMXNamespaceManager;
#endif

#ifndef __DOMDocument_FWD_DEFINED__
#define __DOMDocument_FWD_DEFINED__
#ifdef __cplusplus
typedef class DOMDocument DOMDocument;
#else
typedef struct DOMDocument DOMDocument;
#endif
#endif

#ifndef __DOMDocument26_FWD_DEFINED__
#define __DOMDocument26_FWD_DEFINED__
#ifdef __cplusplus
typedef class DOMDocument26 DOMDocument26;
#else
typedef struct DOMDocument26 DOMDocument26;
#endif
#endif

#ifndef __DOMDocument30_FWD_DEFINED__
#define __DOMDocument30_FWD_DEFINED__
#ifdef __cplusplus
typedef class DOMDocument30 DOMDocument30;
#else
typedef struct DOMDocument30 DOMDocument30;
#endif
#endif

#ifndef __DOMDocument40_FWD_DEFINED__
#define __DOMDocument40_FWD_DEFINED__
#ifdef __cplusplus
typedef class DOMDocument40 DOMDocument40;
#else
typedef struct DOMDocument40 DOMDocument40;
#endif
#endif

#ifndef __FreeThreadedDOMDocument_FWD_DEFINED__
#define __FreeThreadedDOMDocument_FWD_DEFINED__
#ifdef __cplusplus
typedef class FreeThreadedDOMDocument FreeThreadedDOMDocument;
#else
typedef struct FreeThreadedDOMDocument FreeThreadedDOMDocument;
#endif
#endif

#ifndef __FreeThreadedDOMDocument26_FWD_DEFINED__
#define __FreeThreadedDOMDocument26_FWD_DEFINED__
#ifdef __cplusplus
typedef class FreeThreadedDOMDocument26 FreeThreadedDOMDocument26;
#else
typedef struct FreeThreadedDOMDocument26 FreeThreadedDOMDocument26;
#endif
#endif

#ifndef __FreeThreadedDOMDocument30_FWD_DEFINED__
#define __FreeThreadedDOMDocument30_FWD_DEFINED__
#ifdef __cplusplus
typedef class FreeThreadedDOMDocument30 FreeThreadedDOMDocument30;
#else
typedef struct FreeThreadedDOMDocument30 FreeThreadedDOMDocument30;
#endif
#endif

#ifndef __FreeThreadedDOMDocument40_FWD_DEFINED__
#define __FreeThreadedDOMDocument40_FWD_DEFINED__
#ifdef __cplusplus
typedef class FreeThreadedDOMDocument40 FreeThreadedDOMDocument40;
#else
typedef struct FreeThreadedDOMDocument40 FreeThreadedDOMDocument40;
#endif
#endif

#ifndef __XMLSchemaCache_FWD_DEFINED__
#define __XMLSchemaCache_FWD_DEFINED__
#ifdef __cplusplus
typedef class XMLSchemaCache XMLSchemaCache;
#else
typedef struct XMLSchemaCache XMLSchemaCache;
#endif
#endif

#ifndef __XMLSchemaCache26_FWD_DEFINED__
#define __XMLSchemaCache26_FWD_DEFINED__
#ifdef __cplusplus
typedef class XMLSchemaCache26 XMLSchemaCache26;
#else
typedef struct XMLSchemaCache26 XMLSchemaCache26;
#endif
#endif

#ifndef __XMLSchemaCache30_FWD_DEFINED__
#define __XMLSchemaCache30_FWD_DEFINED__
#ifdef __cplusplus
typedef class XMLSchemaCache30 XMLSchemaCache30;
#else
typedef struct XMLSchemaCache30 XMLSchemaCache30;
#endif
#endif

#ifndef __XMLSchemaCache40_FWD_DEFINED__
#define __XMLSchemaCache40_FWD_DEFINED__
#ifdef __cplusplus
typedef class XMLSchemaCache40 XMLSchemaCache40;
#else
typedef struct XMLSchemaCache40 XMLSchemaCache40;
#endif
#endif

#ifndef __XSLTemplate_FWD_DEFINED__
#define __XSLTemplate_FWD_DEFINED__
#ifdef __cplusplus
typedef class XSLTemplate XSLTemplate;
#else
typedef struct XSLTemplate XSLTemplate;
#endif
#endif

#ifndef __XSLTemplate26_FWD_DEFINED__
#define __XSLTemplate26_FWD_DEFINED__
#ifdef __cplusplus
typedef class XSLTemplate26 XSLTemplate26;
#else
typedef struct XSLTemplate26 XSLTemplate26;
#endif
#endif

#ifndef __XSLTemplate30_FWD_DEFINED__
#define __XSLTemplate30_FWD_DEFINED__
#ifdef __cplusplus
typedef class XSLTemplate30 XSLTemplate30;
#else
typedef struct XSLTemplate30 XSLTemplate30;
#endif
#endif

#ifndef __XSLTemplate40_FWD_DEFINED__
#define __XSLTemplate40_FWD_DEFINED__
#ifdef __cplusplus
typedef class XSLTemplate40 XSLTemplate40;
#else
typedef struct XSLTemplate40 XSLTemplate40;
#endif
#endif

#ifndef __DSOControl_FWD_DEFINED__
#define __DSOControl_FWD_DEFINED__
#ifdef __cplusplus
typedef class DSOControl DSOControl;
#else
typedef struct DSOControl DSOControl;
#endif
#endif

#ifndef __DSOControl26_FWD_DEFINED__
#define __DSOControl26_FWD_DEFINED__
#ifdef __cplusplus
typedef class DSOControl26 DSOControl26;
#else
typedef struct DSOControl26 DSOControl26;
#endif
#endif

#ifndef __DSOControl30_FWD_DEFINED__
#define __DSOControl30_FWD_DEFINED__
#ifdef __cplusplus
typedef class DSOControl30 DSOControl30;
#else
typedef struct DSOControl30 DSOControl30;
#endif
#endif

#ifndef __DSOControl40_FWD_DEFINED__
#define __DSOControl40_FWD_DEFINED__
#ifdef __cplusplus
typedef class DSOControl40 DSOControl40;
#else
typedef struct DSOControl40 DSOControl40;
#endif
#endif

#ifndef __XMLHTTP_FWD_DEFINED__
#define __XMLHTTP_FWD_DEFINED__
#ifdef __cplusplus
typedef class XMLHTTP XMLHTTP;
#else
typedef struct XMLHTTP XMLHTTP;
#endif
#endif

#ifndef __XMLHTTP26_FWD_DEFINED__
#define __XMLHTTP26_FWD_DEFINED__
#ifdef __cplusplus
typedef class XMLHTTP26 XMLHTTP26;
#else
typedef struct XMLHTTP26 XMLHTTP26;
#endif
#endif

#ifndef __XMLHTTP30_FWD_DEFINED__
#define __XMLHTTP30_FWD_DEFINED__
#ifdef __cplusplus
typedef class XMLHTTP30 XMLHTTP30;
#else
typedef struct XMLHTTP30 XMLHTTP30;
#endif
#endif

#ifndef __XMLHTTP40_FWD_DEFINED__
#define __XMLHTTP40_FWD_DEFINED__
#ifdef __cplusplus
typedef class XMLHTTP40 XMLHTTP40;
#else
typedef struct XMLHTTP40 XMLHTTP40;
#endif
#endif

#ifndef __ServerXMLHTTP_FWD_DEFINED__
#define __ServerXMLHTTP_FWD_DEFINED__
#ifdef __cplusplus
typedef class ServerXMLHTTP ServerXMLHTTP;
#else
typedef struct ServerXMLHTTP ServerXMLHTTP;
#endif
#endif

#ifndef __ServerXMLHTTP30_FWD_DEFINED__
#define __ServerXMLHTTP30_FWD_DEFINED__
#ifdef __cplusplus
typedef class ServerXMLHTTP30 ServerXMLHTTP30;
#else
typedef struct ServerXMLHTTP30 ServerXMLHTTP30;
#endif
#endif

#ifndef __ServerXMLHTTP40_FWD_DEFINED__
#define __ServerXMLHTTP40_FWD_DEFINED__
#ifdef __cplusplus
typedef class ServerXMLHTTP40 ServerXMLHTTP40;
#else
typedef struct ServerXMLHTTP40 ServerXMLHTTP40;
#endif
#endif

#ifndef __SAXXMLReader_FWD_DEFINED__
#define __SAXXMLReader_FWD_DEFINED__
#ifdef __cplusplus
typedef class SAXXMLReader SAXXMLReader;
#else
typedef struct SAXXMLReader SAXXMLReader;
#endif
#endif

#ifndef __SAXXMLReader30_FWD_DEFINED__
#define __SAXXMLReader30_FWD_DEFINED__
#ifdef __cplusplus
typedef class SAXXMLReader30 SAXXMLReader30;
#else
typedef struct SAXXMLReader30 SAXXMLReader30;
#endif
#endif

#ifndef __SAXXMLReader40_FWD_DEFINED__
#define __SAXXMLReader40_FWD_DEFINED__
#ifdef __cplusplus
typedef class SAXXMLReader40 SAXXMLReader40;
#else
typedef struct SAXXMLReader40 SAXXMLReader40;
#endif
#endif

#ifndef __MXXMLWriter_FWD_DEFINED__
#define __MXXMLWriter_FWD_DEFINED__
#ifdef __cplusplus
typedef class MXXMLWriter MXXMLWriter;
#else
typedef struct MXXMLWriter MXXMLWriter;
#endif
#endif

#ifndef __MXXMLWriter30_FWD_DEFINED__
#define __MXXMLWriter30_FWD_DEFINED__
#ifdef __cplusplus
typedef class MXXMLWriter30 MXXMLWriter30;
#else
typedef struct MXXMLWriter30 MXXMLWriter30;
#endif
#endif

#ifndef __MXXMLWriter40_FWD_DEFINED__
#define __MXXMLWriter40_FWD_DEFINED__
#ifdef __cplusplus
typedef class MXXMLWriter40 MXXMLWriter40;
#else
typedef struct MXXMLWriter40 MXXMLWriter40;
#endif
#endif

#ifndef __MXHTMLWriter_FWD_DEFINED__
#define __MXHTMLWriter_FWD_DEFINED__
#ifdef __cplusplus
typedef class MXHTMLWriter MXHTMLWriter;
#else
typedef struct MXHTMLWriter MXHTMLWriter;
#endif
#endif

#ifndef __MXHTMLWriter30_FWD_DEFINED__
#define __MXHTMLWriter30_FWD_DEFINED__
#ifdef __cplusplus
typedef class MXHTMLWriter30 MXHTMLWriter30;
#else
typedef struct MXHTMLWriter30 MXHTMLWriter30;
#endif
#endif

#ifndef __MXHTMLWriter40_FWD_DEFINED__
#define __MXHTMLWriter40_FWD_DEFINED__
#ifdef __cplusplus
typedef class MXHTMLWriter40 MXHTMLWriter40;
#else
typedef struct MXHTMLWriter40 MXHTMLWriter40;
#endif
#endif

#ifndef __SAXAttributes_FWD_DEFINED__
#define __SAXAttributes_FWD_DEFINED__
#ifdef __cplusplus
typedef class SAXAttributes SAXAttributes;
#else
typedef struct SAXAttributes SAXAttributes;
#endif
#endif

#ifndef __SAXAttributes30_FWD_DEFINED__
#define __SAXAttributes30_FWD_DEFINED__
#ifdef __cplusplus
typedef class SAXAttributes30 SAXAttributes30;
#else
typedef struct SAXAttributes30 SAXAttributes30;
#endif
#endif

#ifndef __SAXAttributes40_FWD_DEFINED__
#define __SAXAttributes40_FWD_DEFINED__
#ifdef __cplusplus
typedef class SAXAttributes40 SAXAttributes40;
#else
typedef struct SAXAttributes40 SAXAttributes40;
#endif
#endif

#ifndef __MXNamespaceManager_FWD_DEFINED__
#define __MXNamespaceManager_FWD_DEFINED__
#ifdef __cplusplus
typedef class MXNamespaceManager MXNamespaceManager;
#else
typedef struct MXNamespaceManager MXNamespaceManager;
#endif
#endif

#ifndef __MXNamespaceManager40_FWD_DEFINED__
#define __MXNamespaceManager40_FWD_DEFINED__
#ifdef __cplusplus
typedef class MXNamespaceManager40 MXNamespaceManager40;
#else
typedef struct MXNamespaceManager40 MXNamespaceManager40;
#endif
#endif

#ifndef __XMLDocument_FWD_DEFINED__
#define __XMLDocument_FWD_DEFINED__
#ifdef __cplusplus
typedef class XMLDocument XMLDocument;
#else
typedef struct XMLDocument XMLDocument;
#endif
#endif

#include "unknwn.h"
#include "objidl.h"
#include "oaidl.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __MIDL_user_allocate_free_DEFINED__
#define __MIDL_user_allocate_free_DEFINED__
  void *__RPC_API MIDL_user_allocate(size_t);
  void __RPC_API MIDL_user_free(void *);
#endif

#define DOMDocument DOMDocument2
#define CLSID_DOMDocument CLSID_DOMDocument2

#ifdef __USE_MSXML2_NAMESPACE__
  namespace MSXML2 {
#endif
#ifndef __msxml_h__
    typedef struct _xml_error {
      unsigned int _nLine;
      BSTR _pchBuf;
      unsigned int _cchBuf;
      unsigned int _ich;
      BSTR _pszFound;
      BSTR _pszExpected;
      DWORD _reserved1;
      DWORD _reserved2;
    } XML_ERROR;
#endif
#ifdef __ISAXXMLReader_INTERFACE_DEFINED__
#undef __MSXML2_LIBRARY_DEFINED__
#endif

    extern RPC_IF_HANDLE __MIDL_itf_msxml2_0000_v0_0_c_ifspec;
    extern RPC_IF_HANDLE __MIDL_itf_msxml2_0000_v0_0_s_ifspec;

#ifndef __MSXML2_LIBRARY_DEFINED__
#define __MSXML2_LIBRARY_DEFINED__

#undef ParseURL
#if !defined(__msxml_h__)
    typedef enum tagXMLEMEM_TYPE {
      XMLELEMTYPE_ELEMENT = 0,XMLELEMTYPE_TEXT,XMLELEMTYPE_COMMENT,
      XMLELEMTYPE_DOCUMENT,XMLELEMTYPE_DTD,XMLELEMTYPE_PI,XMLELEMTYPE_OTHER
    } XMLELEM_TYPE;
#endif
#if !defined(__msxml_h__) || defined(__IXMLElementNotificationSink_INTERFACE_DEFINED__)
    typedef enum tagDOMNodeType {
      NODE_INVALID = 0,NODE_ELEMENT,NODE_ATTRIBUTE,NODE_TEXT,NODE_CDATA_SECTION,
      NODE_ENTITY_REFERENCE,NODE_ENTITY,NODE_PROCESSING_INSTRUCTION,NODE_COMMENT,
      NODE_DOCUMENT,NODE_DOCUMENT_TYPE,NODE_DOCUMENT_FRAGMENT,NODE_NOTATION
    } DOMNodeType;
#endif
#if !defined(__msxml_sxh_enums__)
#define __msxml_sxh_enums__
    typedef enum _SERVERXMLHTTP_OPTION {
      SXH_OPTION_URL = -1,SXH_OPTION_URL_CODEPAGE,SXH_OPTION_ESCAPE_PERCENT_IN_URL,
      SXH_OPTION_IGNORE_SERVER_SSL_CERT_ERROR_FLAGS,SXH_OPTION_SELECT_CLIENT_SSL_CERT
    } SERVERXMLHTTP_OPTION;

    typedef enum _SXH_SERVER_CERT_OPTION {
      SXH_SERVER_CERT_IGNORE_UNKNOWN_CA = 0x100,SXH_SERVER_CERT_IGNORE_WRONG_USAGE = 0x200,SXH_SERVER_CERT_IGNORE_CERT_CN_INVALID = 0x1000,
      SXH_SERVER_CERT_IGNORE_CERT_DATE_INVALID = 0x2000,
      SXH_SERVER_CERT_IGNORE_ALL_SERVER_ERRORS = SXH_SERVER_CERT_IGNORE_UNKNOWN_CA + SXH_SERVER_CERT_IGNORE_WRONG_USAGE + SXH_SERVER_CERT_IGNORE_CERT_CN_INVALID + SXH_SERVER_CERT_IGNORE_CERT_DATE_INVALID
    } SXH_SERVER_CERT_OPTION;

    typedef enum _SXH_PROXY_SETTING {
      SXH_PROXY_SET_DEFAULT = 0,SXH_PROXY_SET_PRECONFIG = 0,SXH_PROXY_SET_DIRECT = 0x1,SXH_PROXY_SET_PROXY = 0x2
    } SXH_PROXY_SETTING;
#endif

#ifndef __msxml_som_enums__
#define __msxml_som_enums__
    typedef enum _SOMITEMTYPE {
      SOMITEM_SCHEMA = 0x1000,SOMITEM_ATTRIBUTE = 0x1001,SOMITEM_ATTRIBUTEGROUP = 0x1002,SOMITEM_NOTATION = 0x1003,
      SOMITEM_IDENTITYCONSTRAINT = 0x1100,SOMITEM_KEY = 0x1101,SOMITEM_KEYREF = 0x1102,SOMITEM_UNIQUE = 0x1103,SOMITEM_ANYTYPE = 0x2000,
      SOMITEM_DATATYPE = 0x2100,SOMITEM_DATATYPE_ANYTYPE = 0x2101,SOMITEM_DATATYPE_ANYURI = 0x2102,SOMITEM_DATATYPE_BASE64BINARY = 0x2103,
      SOMITEM_DATATYPE_BOOLEAN = 0x2104,SOMITEM_DATATYPE_BYTE = 0x2105,SOMITEM_DATATYPE_DATE = 0x2106,SOMITEM_DATATYPE_DATETIME = 0x2107,
      SOMITEM_DATATYPE_DAY = 0x2108,SOMITEM_DATATYPE_DECIMAL = 0x2109,SOMITEM_DATATYPE_DOUBLE = 0x210a,SOMITEM_DATATYPE_DURATION = 0x210b,
      SOMITEM_DATATYPE_ENTITIES = 0x210c,SOMITEM_DATATYPE_ENTITY = 0x210d,SOMITEM_DATATYPE_FLOAT = 0x210e,SOMITEM_DATATYPE_HEXBINARY = 0x210f,
      SOMITEM_DATATYPE_ID = 0x2110,SOMITEM_DATATYPE_IDREF = 0x2111,SOMITEM_DATATYPE_IDREFS = 0x2112,SOMITEM_DATATYPE_INT = 0x2113,
      SOMITEM_DATATYPE_INTEGER = 0x2114,SOMITEM_DATATYPE_LANGUAGE = 0x2115,SOMITEM_DATATYPE_LONG = 0x2116,SOMITEM_DATATYPE_MONTH = 0x2117,
      SOMITEM_DATATYPE_MONTHDAY = 0x2118,SOMITEM_DATATYPE_NAME = 0x2119,SOMITEM_DATATYPE_NCNAME = 0x211a,SOMITEM_DATATYPE_NEGATIVEINTEGER = 0x211b,
      SOMITEM_DATATYPE_NMTOKEN = 0x211c,SOMITEM_DATATYPE_NMTOKENS = 0x211d,SOMITEM_DATATYPE_NONNEGATIVEINTEGER = 0x211e,
      SOMITEM_DATATYPE_NONPOSITIVEINTEGER = 0x211f,SOMITEM_DATATYPE_NORMALIZEDSTRING = 0x2120,SOMITEM_DATATYPE_NOTATION = 0x2121,
      SOMITEM_DATATYPE_POSITIVEINTEGER = 0x2122,SOMITEM_DATATYPE_QNAME = 0x2123,SOMITEM_DATATYPE_SHORT = 0x2124,SOMITEM_DATATYPE_STRING = 0x2125,
      SOMITEM_DATATYPE_TIME = 0x2126,SOMITEM_DATATYPE_TOKEN = 0x2127,SOMITEM_DATATYPE_UNSIGNEDBYTE = 0x2128,SOMITEM_DATATYPE_UNSIGNEDINT = 0x2129,
      SOMITEM_DATATYPE_UNSIGNEDLONG = 0x212a,SOMITEM_DATATYPE_UNSIGNEDSHORT = 0x212b,SOMITEM_DATATYPE_YEAR = 0x212c,SOMITEM_DATATYPE_YEARMONTH = 0x212d,
      SOMITEM_DATATYPE_ANYSIMPLETYPE = 0x21ff,SOMITEM_SIMPLETYPE = 0x2200,SOMITEM_COMPLEXTYPE = 0x2400,SOMITEM_PARTICLE = 0x4000,SOMITEM_ANY = 0x4001,
      SOMITEM_ANYATTRIBUTE = 0x4002,SOMITEM_ELEMENT = 0x4003,SOMITEM_GROUP = 0x4100,SOMITEM_ALL = 0x4101,SOMITEM_CHOICE = 0x4102,SOMITEM_SEQUENCE = 0x4103,
      SOMITEM_EMPTYPARTICLE = 0x4104,SOMITEM_NULL = 0x800,SOMITEM_NULL_TYPE = 0x2800,SOMITEM_NULL_ANY = 0x4801,SOMITEM_NULL_ANYATTRIBUTE = 0x4802,
      SOMITEM_NULL_ELEMENT = 0x4803
    } SOMITEMTYPE;

    typedef enum _SCHEMAUSE {
      SCHEMAUSE_OPTIONAL = 0,SCHEMAUSE_PROHIBITED,SCHEMAUSE_REQUIRED
    } SCHEMAUSE;

    typedef enum _SCHEMADERIVATIONMETHOD {
      SCHEMADERIVATIONMETHOD_EMPTY = 0,SCHEMADERIVATIONMETHOD_SUBSTITUTION = 0x1,SCHEMADERIVATIONMETHOD_EXTENSION = 0x2,
      SCHEMADERIVATIONMETHOD_RESTRICTION = 0x4,SCHEMADERIVATIONMETHOD_LIST = 0x8,SCHEMADERIVATIONMETHOD_UNION = 0x10,SCHEMADERIVATIONMETHOD_ALL = 0xff,
      SCHEMADERIVATIONMETHOD_NONE = 0x100
    } SCHEMADERIVATIONMETHOD;

    typedef enum _SCHEMACONTENTTYPE {
      SCHEMACONTENTTYPE_EMPTY = 0,SCHEMACONTENTTYPE_TEXTONLY,SCHEMACONTENTTYPE_ELEMENTONLY,
      SCHEMACONTENTTYPE_MIXED
    } SCHEMACONTENTTYPE;

    typedef enum _SCHEMAPROCESSCONTENTS {
      SCHEMAPROCESSCONTENTS_NONE = 0,SCHEMAPROCESSCONTENTS_SKIP,SCHEMAPROCESSCONTENTS_LAX,
      SCHEMAPROCESSCONTENTS_STRICT
    } SCHEMAPROCESSCONTENTS;

    typedef enum _SCHEMAWHITESPACE {
      SCHEMAWHITESPACE_NONE = -1,SCHEMAWHITESPACE_PRESERVE = 0,SCHEMAWHITESPACE_REPLACE = 1,SCHEMAWHITESPACE_COLLAPSE = 2
    } SCHEMAWHITESPACE;

    typedef enum _SCHEMATYPEVARIETY {
      SCHEMATYPEVARIETY_NONE = -1,SCHEMATYPEVARIETY_ATOMIC = 0,SCHEMATYPEVARIETY_LIST = 1,SCHEMATYPEVARIETY_UNION = 2
    } SCHEMATYPEVARIETY;
#endif

    EXTERN_C const IID LIBID_MSXML2;
#ifndef __IXMLDOMImplementation_INTERFACE_DEFINED__
#define __IXMLDOMImplementation_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMImplementation;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMImplementation : public IDispatch {
    public:
      virtual HRESULT WINAPI hasFeature(BSTR feature,BSTR version,VARIANT_BOOL *hasFeature) = 0;
    };
#else
    typedef struct IXMLDOMImplementationVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMImplementation *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMImplementation *This);
	ULONG (WINAPI *Release)(IXMLDOMImplementation *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMImplementation *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMImplementation *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMImplementation *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMImplementation *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *hasFeature)(IXMLDOMImplementation *This,BSTR feature,BSTR version,VARIANT_BOOL *hasFeature);
      END_INTERFACE
    } IXMLDOMImplementationVtbl;
    struct IXMLDOMImplementation {
      CONST_VTBL struct IXMLDOMImplementationVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMImplementation_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMImplementation_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMImplementation_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMImplementation_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMImplementation_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMImplementation_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMImplementation_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMImplementation_hasFeature(This,feature,version,hasFeature) (This)->lpVtbl->hasFeature(This,feature,version,hasFeature)
#endif
#endif
    HRESULT WINAPI IXMLDOMImplementation_hasFeature_Proxy(IXMLDOMImplementation *This,BSTR feature,BSTR version,VARIANT_BOOL *hasFeature);
    void __RPC_STUB IXMLDOMImplementation_hasFeature_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMNode_INTERFACE_DEFINED__
#define __IXMLDOMNode_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMNode;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMNode : public IDispatch {
    public:
      virtual HRESULT WINAPI get_nodeName(BSTR *name) = 0;
      virtual HRESULT WINAPI get_nodeValue(VARIANT *value) = 0;
      virtual HRESULT WINAPI put_nodeValue(VARIANT value) = 0;
      virtual HRESULT WINAPI get_nodeType(DOMNodeType *type) = 0;
      virtual HRESULT WINAPI get_parentNode(IXMLDOMNode **parent) = 0;
      virtual HRESULT WINAPI get_childNodes(IXMLDOMNodeList **childList) = 0;
      virtual HRESULT WINAPI get_firstChild(IXMLDOMNode **firstChild) = 0;
      virtual HRESULT WINAPI get_lastChild(IXMLDOMNode **lastChild) = 0;
      virtual HRESULT WINAPI get_previousSibling(IXMLDOMNode **previousSibling) = 0;
      virtual HRESULT WINAPI get_nextSibling(IXMLDOMNode **nextSibling) = 0;
      virtual HRESULT WINAPI get_attributes(IXMLDOMNamedNodeMap **attributeMap) = 0;
      virtual HRESULT WINAPI insertBefore(IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild) = 0;
      virtual HRESULT WINAPI replaceChild(IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild) = 0;
      virtual HRESULT WINAPI removeChild(IXMLDOMNode *childNode,IXMLDOMNode **oldChild) = 0;
      virtual HRESULT WINAPI appendChild(IXMLDOMNode *newChild,IXMLDOMNode **outNewChild) = 0;
      virtual HRESULT WINAPI hasChildNodes(VARIANT_BOOL *hasChild) = 0;
      virtual HRESULT WINAPI get_ownerDocument(IXMLDOMDocument **DOMDocument) = 0;
      virtual HRESULT WINAPI cloneNode(VARIANT_BOOL deep,IXMLDOMNode **cloneRoot) = 0;
      virtual HRESULT WINAPI get_nodeTypeString(BSTR *nodeType) = 0;
      virtual HRESULT WINAPI get_text(BSTR *text) = 0;
      virtual HRESULT WINAPI put_text(BSTR text) = 0;
      virtual HRESULT WINAPI get_specified(VARIANT_BOOL *isSpecified) = 0;
      virtual HRESULT WINAPI get_definition(IXMLDOMNode **definitionNode) = 0;
      virtual HRESULT WINAPI get_nodeTypedValue(VARIANT *typedValue) = 0;
      virtual HRESULT WINAPI put_nodeTypedValue(VARIANT typedValue) = 0;
      virtual HRESULT WINAPI get_dataType(VARIANT *dataTypeName) = 0;
      virtual HRESULT WINAPI put_dataType(BSTR dataTypeName) = 0;
      virtual HRESULT WINAPI get_xml(BSTR *xmlString) = 0;
      virtual HRESULT WINAPI transformNode(IXMLDOMNode *stylesheet,BSTR *xmlString) = 0;
      virtual HRESULT WINAPI selectNodes(BSTR queryString,IXMLDOMNodeList **resultList) = 0;
      virtual HRESULT WINAPI selectSingleNode(BSTR queryString,IXMLDOMNode **resultNode) = 0;
      virtual HRESULT WINAPI get_parsed(VARIANT_BOOL *isParsed) = 0;
      virtual HRESULT WINAPI get_namespaceURI(BSTR *namespaceURI) = 0;
      virtual HRESULT WINAPI get_prefix(BSTR *prefixString) = 0;
      virtual HRESULT WINAPI get_baseName(BSTR *nameString) = 0;
      virtual HRESULT WINAPI transformNodeToObject(IXMLDOMNode *stylesheet,VARIANT outputObject) = 0;
    };
#else
    typedef struct IXMLDOMNodeVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMNode *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMNode *This);
	ULONG (WINAPI *Release)(IXMLDOMNode *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMNode *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMNode *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMNode *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMNode *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMNode *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMNode *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMNode *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMNode *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMNode *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMNode *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMNode *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMNode *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMNode *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMNode *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMNode *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMNode *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMNode *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMNode *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMNode *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMNode *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMNode *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMNode *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMNode *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMNode *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMNode *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMNode *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMNode *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMNode *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMNode *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMNode *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMNode *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMNode *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMNode *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMNode *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMNode *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMNode *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMNode *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMNode *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMNode *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMNode *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
      END_INTERFACE
    } IXMLDOMNodeVtbl;
    struct IXMLDOMNode {
      CONST_VTBL struct IXMLDOMNodeVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMNode_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMNode_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMNode_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMNode_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMNode_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMNode_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMNode_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMNode_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMNode_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMNode_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMNode_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMNode_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMNode_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMNode_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMNode_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMNode_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMNode_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMNode_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMNode_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMNode_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMNode_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMNode_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMNode_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMNode_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMNode_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMNode_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMNode_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMNode_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMNode_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMNode_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMNode_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMNode_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMNode_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMNode_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMNode_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMNode_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMNode_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMNode_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMNode_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMNode_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMNode_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMNode_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMNode_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#endif
#endif
    HRESULT WINAPI IXMLDOMNode_get_nodeName_Proxy(IXMLDOMNode *This,BSTR *name);
    void __RPC_STUB IXMLDOMNode_get_nodeName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_nodeValue_Proxy(IXMLDOMNode *This,VARIANT *value);
    void __RPC_STUB IXMLDOMNode_get_nodeValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_put_nodeValue_Proxy(IXMLDOMNode *This,VARIANT value);
    void __RPC_STUB IXMLDOMNode_put_nodeValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_nodeType_Proxy(IXMLDOMNode *This,DOMNodeType *type);
    void __RPC_STUB IXMLDOMNode_get_nodeType_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_parentNode_Proxy(IXMLDOMNode *This,IXMLDOMNode **parent);
    void __RPC_STUB IXMLDOMNode_get_parentNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_childNodes_Proxy(IXMLDOMNode *This,IXMLDOMNodeList **childList);
    void __RPC_STUB IXMLDOMNode_get_childNodes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_firstChild_Proxy(IXMLDOMNode *This,IXMLDOMNode **firstChild);
    void __RPC_STUB IXMLDOMNode_get_firstChild_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_lastChild_Proxy(IXMLDOMNode *This,IXMLDOMNode **lastChild);
    void __RPC_STUB IXMLDOMNode_get_lastChild_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_previousSibling_Proxy(IXMLDOMNode *This,IXMLDOMNode **previousSibling);
    void __RPC_STUB IXMLDOMNode_get_previousSibling_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_nextSibling_Proxy(IXMLDOMNode *This,IXMLDOMNode **nextSibling);
    void __RPC_STUB IXMLDOMNode_get_nextSibling_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_attributes_Proxy(IXMLDOMNode *This,IXMLDOMNamedNodeMap **attributeMap);
    void __RPC_STUB IXMLDOMNode_get_attributes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_insertBefore_Proxy(IXMLDOMNode *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
    void __RPC_STUB IXMLDOMNode_insertBefore_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_replaceChild_Proxy(IXMLDOMNode *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
    void __RPC_STUB IXMLDOMNode_replaceChild_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_removeChild_Proxy(IXMLDOMNode *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
    void __RPC_STUB IXMLDOMNode_removeChild_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_appendChild_Proxy(IXMLDOMNode *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
    void __RPC_STUB IXMLDOMNode_appendChild_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_hasChildNodes_Proxy(IXMLDOMNode *This,VARIANT_BOOL *hasChild);
    void __RPC_STUB IXMLDOMNode_hasChildNodes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_ownerDocument_Proxy(IXMLDOMNode *This,IXMLDOMDocument **DOMDocument);
    void __RPC_STUB IXMLDOMNode_get_ownerDocument_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_cloneNode_Proxy(IXMLDOMNode *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
    void __RPC_STUB IXMLDOMNode_cloneNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_nodeTypeString_Proxy(IXMLDOMNode *This,BSTR *nodeType);
    void __RPC_STUB IXMLDOMNode_get_nodeTypeString_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_text_Proxy(IXMLDOMNode *This,BSTR *text);
    void __RPC_STUB IXMLDOMNode_get_text_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_put_text_Proxy(IXMLDOMNode *This,BSTR text);
    void __RPC_STUB IXMLDOMNode_put_text_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_specified_Proxy(IXMLDOMNode *This,VARIANT_BOOL *isSpecified);
    void __RPC_STUB IXMLDOMNode_get_specified_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_definition_Proxy(IXMLDOMNode *This,IXMLDOMNode **definitionNode);
    void __RPC_STUB IXMLDOMNode_get_definition_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_nodeTypedValue_Proxy(IXMLDOMNode *This,VARIANT *typedValue);
    void __RPC_STUB IXMLDOMNode_get_nodeTypedValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_put_nodeTypedValue_Proxy(IXMLDOMNode *This,VARIANT typedValue);
    void __RPC_STUB IXMLDOMNode_put_nodeTypedValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_dataType_Proxy(IXMLDOMNode *This,VARIANT *dataTypeName);
    void __RPC_STUB IXMLDOMNode_get_dataType_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_put_dataType_Proxy(IXMLDOMNode *This,BSTR dataTypeName);
    void __RPC_STUB IXMLDOMNode_put_dataType_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_xml_Proxy(IXMLDOMNode *This,BSTR *xmlString);
    void __RPC_STUB IXMLDOMNode_get_xml_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_transformNode_Proxy(IXMLDOMNode *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
    void __RPC_STUB IXMLDOMNode_transformNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_selectNodes_Proxy(IXMLDOMNode *This,BSTR queryString,IXMLDOMNodeList **resultList);
    void __RPC_STUB IXMLDOMNode_selectNodes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_selectSingleNode_Proxy(IXMLDOMNode *This,BSTR queryString,IXMLDOMNode **resultNode);
    void __RPC_STUB IXMLDOMNode_selectSingleNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_parsed_Proxy(IXMLDOMNode *This,VARIANT_BOOL *isParsed);
    void __RPC_STUB IXMLDOMNode_get_parsed_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_namespaceURI_Proxy(IXMLDOMNode *This,BSTR *namespaceURI);
    void __RPC_STUB IXMLDOMNode_get_namespaceURI_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_prefix_Proxy(IXMLDOMNode *This,BSTR *prefixString);
    void __RPC_STUB IXMLDOMNode_get_prefix_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_get_baseName_Proxy(IXMLDOMNode *This,BSTR *nameString);
    void __RPC_STUB IXMLDOMNode_get_baseName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNode_transformNodeToObject_Proxy(IXMLDOMNode *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
    void __RPC_STUB IXMLDOMNode_transformNodeToObject_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMDocumentFragment_INTERFACE_DEFINED__
#define __IXMLDOMDocumentFragment_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMDocumentFragment;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMDocumentFragment : public IXMLDOMNode {
    };
#else
    typedef struct IXMLDOMDocumentFragmentVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMDocumentFragment *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMDocumentFragment *This);
	ULONG (WINAPI *Release)(IXMLDOMDocumentFragment *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMDocumentFragment *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMDocumentFragment *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMDocumentFragment *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMDocumentFragment *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMDocumentFragment *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMDocumentFragment *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMDocumentFragment *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMDocumentFragment *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMDocumentFragment *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMDocumentFragment *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMDocumentFragment *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMDocumentFragment *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMDocumentFragment *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMDocumentFragment *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMDocumentFragment *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMDocumentFragment *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMDocumentFragment *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMDocumentFragment *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMDocumentFragment *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMDocumentFragment *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMDocumentFragment *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMDocumentFragment *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMDocumentFragment *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMDocumentFragment *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMDocumentFragment *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMDocumentFragment *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMDocumentFragment *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMDocumentFragment *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMDocumentFragment *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMDocumentFragment *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMDocumentFragment *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMDocumentFragment *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMDocumentFragment *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMDocumentFragment *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMDocumentFragment *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMDocumentFragment *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMDocumentFragment *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMDocumentFragment *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMDocumentFragment *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMDocumentFragment *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
      END_INTERFACE
    } IXMLDOMDocumentFragmentVtbl;
    struct IXMLDOMDocumentFragment {
      CONST_VTBL struct IXMLDOMDocumentFragmentVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMDocumentFragment_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMDocumentFragment_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMDocumentFragment_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMDocumentFragment_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMDocumentFragment_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMDocumentFragment_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMDocumentFragment_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMDocumentFragment_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMDocumentFragment_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMDocumentFragment_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMDocumentFragment_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMDocumentFragment_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMDocumentFragment_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMDocumentFragment_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMDocumentFragment_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMDocumentFragment_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMDocumentFragment_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMDocumentFragment_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMDocumentFragment_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMDocumentFragment_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMDocumentFragment_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMDocumentFragment_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMDocumentFragment_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMDocumentFragment_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMDocumentFragment_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMDocumentFragment_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMDocumentFragment_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMDocumentFragment_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMDocumentFragment_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMDocumentFragment_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMDocumentFragment_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMDocumentFragment_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMDocumentFragment_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMDocumentFragment_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMDocumentFragment_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMDocumentFragment_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMDocumentFragment_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMDocumentFragment_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMDocumentFragment_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMDocumentFragment_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMDocumentFragment_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMDocumentFragment_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMDocumentFragment_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#endif
#endif
#endif

#ifndef __IXMLDOMDocument_INTERFACE_DEFINED__
#define __IXMLDOMDocument_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMDocument;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMDocument : public IXMLDOMNode {
    public:
      virtual HRESULT WINAPI get_doctype(IXMLDOMDocumentType **documentType) = 0;
      virtual HRESULT WINAPI get_implementation(IXMLDOMImplementation **impl) = 0;
      virtual HRESULT WINAPI get_documentElement(IXMLDOMElement **DOMElement) = 0;
      virtual HRESULT WINAPI putref_documentElement(IXMLDOMElement *DOMElement) = 0;
      virtual HRESULT WINAPI createElement(BSTR tagName,IXMLDOMElement **element) = 0;
      virtual HRESULT WINAPI createDocumentFragment(IXMLDOMDocumentFragment **docFrag) = 0;
      virtual HRESULT WINAPI createTextNode(BSTR data,IXMLDOMText **text) = 0;
      virtual HRESULT WINAPI createComment(BSTR data,IXMLDOMComment **comment) = 0;
      virtual HRESULT WINAPI createCDATASection(BSTR data,IXMLDOMCDATASection **cdata) = 0;
      virtual HRESULT WINAPI createProcessingInstruction(BSTR target,BSTR data,IXMLDOMProcessingInstruction **pi) = 0;
      virtual HRESULT WINAPI createAttribute(BSTR name,IXMLDOMAttribute **attribute) = 0;
      virtual HRESULT WINAPI createEntityReference(BSTR name,IXMLDOMEntityReference **entityRef) = 0;
      virtual HRESULT WINAPI getElementsByTagName(BSTR tagName,IXMLDOMNodeList **resultList) = 0;
      virtual HRESULT WINAPI createNode(VARIANT Type,BSTR name,BSTR namespaceURI,IXMLDOMNode **node) = 0;
      virtual HRESULT WINAPI nodeFromID(BSTR idString,IXMLDOMNode **node) = 0;
      virtual HRESULT WINAPI load(VARIANT xmlSource,VARIANT_BOOL *isSuccessful) = 0;
      virtual HRESULT WINAPI get_readyState(long *value) = 0;
      virtual HRESULT WINAPI get_parseError(IXMLDOMParseError **errorObj) = 0;
      virtual HRESULT WINAPI get_url(BSTR *urlString) = 0;
      virtual HRESULT WINAPI get_async(VARIANT_BOOL *isAsync) = 0;
      virtual HRESULT WINAPI put_async(VARIANT_BOOL isAsync) = 0;
      virtual HRESULT WINAPI abort(void) = 0;
      virtual HRESULT WINAPI loadXML(BSTR bstrXML,VARIANT_BOOL *isSuccessful) = 0;
      virtual HRESULT WINAPI save(VARIANT destination) = 0;
      virtual HRESULT WINAPI get_validateOnParse(VARIANT_BOOL *isValidating) = 0;
      virtual HRESULT WINAPI put_validateOnParse(VARIANT_BOOL isValidating) = 0;
      virtual HRESULT WINAPI get_resolveExternals(VARIANT_BOOL *isResolving) = 0;
      virtual HRESULT WINAPI put_resolveExternals(VARIANT_BOOL isResolving) = 0;
      virtual HRESULT WINAPI get_preserveWhiteSpace(VARIANT_BOOL *isPreserving) = 0;
      virtual HRESULT WINAPI put_preserveWhiteSpace(VARIANT_BOOL isPreserving) = 0;
      virtual HRESULT WINAPI put_onreadystatechange(VARIANT readystatechangeSink) = 0;
      virtual HRESULT WINAPI put_ondataavailable(VARIANT ondataavailableSink) = 0;
      virtual HRESULT WINAPI put_ontransformnode(VARIANT ontransformnodeSink) = 0;
    };
#else
    typedef struct IXMLDOMDocumentVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMDocument *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMDocument *This);
	ULONG (WINAPI *Release)(IXMLDOMDocument *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMDocument *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMDocument *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMDocument *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMDocument *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMDocument *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMDocument *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMDocument *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMDocument *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMDocument *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMDocument *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMDocument *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMDocument *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMDocument *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMDocument *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMDocument *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMDocument *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMDocument *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMDocument *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMDocument *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMDocument *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMDocument *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMDocument *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMDocument *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMDocument *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMDocument *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMDocument *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMDocument *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMDocument *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMDocument *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMDocument *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMDocument *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMDocument *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMDocument *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMDocument *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMDocument *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMDocument *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMDocument *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMDocument *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMDocument *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMDocument *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_doctype)(IXMLDOMDocument *This,IXMLDOMDocumentType **documentType);
	HRESULT (WINAPI *get_implementation)(IXMLDOMDocument *This,IXMLDOMImplementation **impl);
	HRESULT (WINAPI *get_documentElement)(IXMLDOMDocument *This,IXMLDOMElement **DOMElement);
	HRESULT (WINAPI *putref_documentElement)(IXMLDOMDocument *This,IXMLDOMElement *DOMElement);
	HRESULT (WINAPI *createElement)(IXMLDOMDocument *This,BSTR tagName,IXMLDOMElement **element);
	HRESULT (WINAPI *createDocumentFragment)(IXMLDOMDocument *This,IXMLDOMDocumentFragment **docFrag);
	HRESULT (WINAPI *createTextNode)(IXMLDOMDocument *This,BSTR data,IXMLDOMText **text);
	HRESULT (WINAPI *createComment)(IXMLDOMDocument *This,BSTR data,IXMLDOMComment **comment);
	HRESULT (WINAPI *createCDATASection)(IXMLDOMDocument *This,BSTR data,IXMLDOMCDATASection **cdata);
	HRESULT (WINAPI *createProcessingInstruction)(IXMLDOMDocument *This,BSTR target,BSTR data,IXMLDOMProcessingInstruction **pi);
	HRESULT (WINAPI *createAttribute)(IXMLDOMDocument *This,BSTR name,IXMLDOMAttribute **attribute);
	HRESULT (WINAPI *createEntityReference)(IXMLDOMDocument *This,BSTR name,IXMLDOMEntityReference **entityRef);
	HRESULT (WINAPI *getElementsByTagName)(IXMLDOMDocument *This,BSTR tagName,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *createNode)(IXMLDOMDocument *This,VARIANT Type,BSTR name,BSTR namespaceURI,IXMLDOMNode **node);
	HRESULT (WINAPI *nodeFromID)(IXMLDOMDocument *This,BSTR idString,IXMLDOMNode **node);
	HRESULT (WINAPI *load)(IXMLDOMDocument *This,VARIANT xmlSource,VARIANT_BOOL *isSuccessful);
	HRESULT (WINAPI *get_readyState)(IXMLDOMDocument *This,long *value);
	HRESULT (WINAPI *get_parseError)(IXMLDOMDocument *This,IXMLDOMParseError **errorObj);
	HRESULT (WINAPI *get_url)(IXMLDOMDocument *This,BSTR *urlString);
	HRESULT (WINAPI *get_async)(IXMLDOMDocument *This,VARIANT_BOOL *isAsync);
	HRESULT (WINAPI *put_async)(IXMLDOMDocument *This,VARIANT_BOOL isAsync);
	HRESULT (WINAPI *abort)(IXMLDOMDocument *This);
	HRESULT (WINAPI *loadXML)(IXMLDOMDocument *This,BSTR bstrXML,VARIANT_BOOL *isSuccessful);
	HRESULT (WINAPI *save)(IXMLDOMDocument *This,VARIANT destination);
	HRESULT (WINAPI *get_validateOnParse)(IXMLDOMDocument *This,VARIANT_BOOL *isValidating);
	HRESULT (WINAPI *put_validateOnParse)(IXMLDOMDocument *This,VARIANT_BOOL isValidating);
	HRESULT (WINAPI *get_resolveExternals)(IXMLDOMDocument *This,VARIANT_BOOL *isResolving);
	HRESULT (WINAPI *put_resolveExternals)(IXMLDOMDocument *This,VARIANT_BOOL isResolving);
	HRESULT (WINAPI *get_preserveWhiteSpace)(IXMLDOMDocument *This,VARIANT_BOOL *isPreserving);
	HRESULT (WINAPI *put_preserveWhiteSpace)(IXMLDOMDocument *This,VARIANT_BOOL isPreserving);
	HRESULT (WINAPI *put_onreadystatechange)(IXMLDOMDocument *This,VARIANT readystatechangeSink);
	HRESULT (WINAPI *put_ondataavailable)(IXMLDOMDocument *This,VARIANT ondataavailableSink);
	HRESULT (WINAPI *put_ontransformnode)(IXMLDOMDocument *This,VARIANT ontransformnodeSink);
      END_INTERFACE
    } IXMLDOMDocumentVtbl;
    struct IXMLDOMDocument {
      CONST_VTBL struct IXMLDOMDocumentVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMDocument_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMDocument_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMDocument_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMDocument_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMDocument_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMDocument_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMDocument_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMDocument_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMDocument_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMDocument_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMDocument_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMDocument_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMDocument_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMDocument_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMDocument_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMDocument_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMDocument_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMDocument_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMDocument_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMDocument_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMDocument_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMDocument_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMDocument_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMDocument_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMDocument_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMDocument_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMDocument_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMDocument_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMDocument_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMDocument_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMDocument_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMDocument_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMDocument_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMDocument_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMDocument_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMDocument_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMDocument_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMDocument_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMDocument_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMDocument_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMDocument_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMDocument_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMDocument_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMDocument_get_doctype(This,documentType) (This)->lpVtbl->get_doctype(This,documentType)
#define IXMLDOMDocument_get_implementation(This,impl) (This)->lpVtbl->get_implementation(This,impl)
#define IXMLDOMDocument_get_documentElement(This,DOMElement) (This)->lpVtbl->get_documentElement(This,DOMElement)
#define IXMLDOMDocument_putref_documentElement(This,DOMElement) (This)->lpVtbl->putref_documentElement(This,DOMElement)
#define IXMLDOMDocument_createElement(This,tagName,element) (This)->lpVtbl->createElement(This,tagName,element)
#define IXMLDOMDocument_createDocumentFragment(This,docFrag) (This)->lpVtbl->createDocumentFragment(This,docFrag)
#define IXMLDOMDocument_createTextNode(This,data,text) (This)->lpVtbl->createTextNode(This,data,text)
#define IXMLDOMDocument_createComment(This,data,comment) (This)->lpVtbl->createComment(This,data,comment)
#define IXMLDOMDocument_createCDATASection(This,data,cdata) (This)->lpVtbl->createCDATASection(This,data,cdata)
#define IXMLDOMDocument_createProcessingInstruction(This,target,data,pi) (This)->lpVtbl->createProcessingInstruction(This,target,data,pi)
#define IXMLDOMDocument_createAttribute(This,name,attribute) (This)->lpVtbl->createAttribute(This,name,attribute)
#define IXMLDOMDocument_createEntityReference(This,name,entityRef) (This)->lpVtbl->createEntityReference(This,name,entityRef)
#define IXMLDOMDocument_getElementsByTagName(This,tagName,resultList) (This)->lpVtbl->getElementsByTagName(This,tagName,resultList)
#define IXMLDOMDocument_createNode(This,Type,name,namespaceURI,node) (This)->lpVtbl->createNode(This,Type,name,namespaceURI,node)
#define IXMLDOMDocument_nodeFromID(This,idString,node) (This)->lpVtbl->nodeFromID(This,idString,node)
#define IXMLDOMDocument_load(This,xmlSource,isSuccessful) (This)->lpVtbl->load(This,xmlSource,isSuccessful)
#define IXMLDOMDocument_get_readyState(This,value) (This)->lpVtbl->get_readyState(This,value)
#define IXMLDOMDocument_get_parseError(This,errorObj) (This)->lpVtbl->get_parseError(This,errorObj)
#define IXMLDOMDocument_get_url(This,urlString) (This)->lpVtbl->get_url(This,urlString)
#define IXMLDOMDocument_get_async(This,isAsync) (This)->lpVtbl->get_async(This,isAsync)
#define IXMLDOMDocument_put_async(This,isAsync) (This)->lpVtbl->put_async(This,isAsync)
#define IXMLDOMDocument_abort(This) (This)->lpVtbl->abort(This)
#define IXMLDOMDocument_loadXML(This,bstrXML,isSuccessful) (This)->lpVtbl->loadXML(This,bstrXML,isSuccessful)
#define IXMLDOMDocument_save(This,destination) (This)->lpVtbl->save(This,destination)
#define IXMLDOMDocument_get_validateOnParse(This,isValidating) (This)->lpVtbl->get_validateOnParse(This,isValidating)
#define IXMLDOMDocument_put_validateOnParse(This,isValidating) (This)->lpVtbl->put_validateOnParse(This,isValidating)
#define IXMLDOMDocument_get_resolveExternals(This,isResolving) (This)->lpVtbl->get_resolveExternals(This,isResolving)
#define IXMLDOMDocument_put_resolveExternals(This,isResolving) (This)->lpVtbl->put_resolveExternals(This,isResolving)
#define IXMLDOMDocument_get_preserveWhiteSpace(This,isPreserving) (This)->lpVtbl->get_preserveWhiteSpace(This,isPreserving)
#define IXMLDOMDocument_put_preserveWhiteSpace(This,isPreserving) (This)->lpVtbl->put_preserveWhiteSpace(This,isPreserving)
#define IXMLDOMDocument_put_onreadystatechange(This,readystatechangeSink) (This)->lpVtbl->put_onreadystatechange(This,readystatechangeSink)
#define IXMLDOMDocument_put_ondataavailable(This,ondataavailableSink) (This)->lpVtbl->put_ondataavailable(This,ondataavailableSink)
#define IXMLDOMDocument_put_ontransformnode(This,ontransformnodeSink) (This)->lpVtbl->put_ontransformnode(This,ontransformnodeSink)
#endif
#endif
    HRESULT WINAPI IXMLDOMDocument_get_doctype_Proxy(IXMLDOMDocument *This,IXMLDOMDocumentType **documentType);
    void __RPC_STUB IXMLDOMDocument_get_doctype_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_get_implementation_Proxy(IXMLDOMDocument *This,IXMLDOMImplementation **impl);
    void __RPC_STUB IXMLDOMDocument_get_implementation_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_get_documentElement_Proxy(IXMLDOMDocument *This,IXMLDOMElement **DOMElement);
    void __RPC_STUB IXMLDOMDocument_get_documentElement_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_putref_documentElement_Proxy(IXMLDOMDocument *This,IXMLDOMElement *DOMElement);
    void __RPC_STUB IXMLDOMDocument_putref_documentElement_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_createElement_Proxy(IXMLDOMDocument *This,BSTR tagName,IXMLDOMElement **element);
    void __RPC_STUB IXMLDOMDocument_createElement_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_createDocumentFragment_Proxy(IXMLDOMDocument *This,IXMLDOMDocumentFragment **docFrag);
    void __RPC_STUB IXMLDOMDocument_createDocumentFragment_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_createTextNode_Proxy(IXMLDOMDocument *This,BSTR data,IXMLDOMText **text);
    void __RPC_STUB IXMLDOMDocument_createTextNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_createComment_Proxy(IXMLDOMDocument *This,BSTR data,IXMLDOMComment **comment);
    void __RPC_STUB IXMLDOMDocument_createComment_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_createCDATASection_Proxy(IXMLDOMDocument *This,BSTR data,IXMLDOMCDATASection **cdata);
    void __RPC_STUB IXMLDOMDocument_createCDATASection_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_createProcessingInstruction_Proxy(IXMLDOMDocument *This,BSTR target,BSTR data,IXMLDOMProcessingInstruction **pi);
    void __RPC_STUB IXMLDOMDocument_createProcessingInstruction_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_createAttribute_Proxy(IXMLDOMDocument *This,BSTR name,IXMLDOMAttribute **attribute);
    void __RPC_STUB IXMLDOMDocument_createAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_createEntityReference_Proxy(IXMLDOMDocument *This,BSTR name,IXMLDOMEntityReference **entityRef);
    void __RPC_STUB IXMLDOMDocument_createEntityReference_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_getElementsByTagName_Proxy(IXMLDOMDocument *This,BSTR tagName,IXMLDOMNodeList **resultList);
    void __RPC_STUB IXMLDOMDocument_getElementsByTagName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_createNode_Proxy(IXMLDOMDocument *This,VARIANT Type,BSTR name,BSTR namespaceURI,IXMLDOMNode **node);
    void __RPC_STUB IXMLDOMDocument_createNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_nodeFromID_Proxy(IXMLDOMDocument *This,BSTR idString,IXMLDOMNode **node);
    void __RPC_STUB IXMLDOMDocument_nodeFromID_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_load_Proxy(IXMLDOMDocument *This,VARIANT xmlSource,VARIANT_BOOL *isSuccessful);
    void __RPC_STUB IXMLDOMDocument_load_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_get_readyState_Proxy(IXMLDOMDocument *This,long *value);
    void __RPC_STUB IXMLDOMDocument_get_readyState_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_get_parseError_Proxy(IXMLDOMDocument *This,IXMLDOMParseError **errorObj);
    void __RPC_STUB IXMLDOMDocument_get_parseError_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_get_url_Proxy(IXMLDOMDocument *This,BSTR *urlString);
    void __RPC_STUB IXMLDOMDocument_get_url_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_get_async_Proxy(IXMLDOMDocument *This,VARIANT_BOOL *isAsync);
    void __RPC_STUB IXMLDOMDocument_get_async_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_put_async_Proxy(IXMLDOMDocument *This,VARIANT_BOOL isAsync);
    void __RPC_STUB IXMLDOMDocument_put_async_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_abort_Proxy(IXMLDOMDocument *This);
    void __RPC_STUB IXMLDOMDocument_abort_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_loadXML_Proxy(IXMLDOMDocument *This,BSTR bstrXML,VARIANT_BOOL *isSuccessful);
    void __RPC_STUB IXMLDOMDocument_loadXML_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_save_Proxy(IXMLDOMDocument *This,VARIANT destination);
    void __RPC_STUB IXMLDOMDocument_save_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_get_validateOnParse_Proxy(IXMLDOMDocument *This,VARIANT_BOOL *isValidating);
    void __RPC_STUB IXMLDOMDocument_get_validateOnParse_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_put_validateOnParse_Proxy(IXMLDOMDocument *This,VARIANT_BOOL isValidating);
    void __RPC_STUB IXMLDOMDocument_put_validateOnParse_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_get_resolveExternals_Proxy(IXMLDOMDocument *This,VARIANT_BOOL *isResolving);
    void __RPC_STUB IXMLDOMDocument_get_resolveExternals_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_put_resolveExternals_Proxy(IXMLDOMDocument *This,VARIANT_BOOL isResolving);
    void __RPC_STUB IXMLDOMDocument_put_resolveExternals_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_get_preserveWhiteSpace_Proxy(IXMLDOMDocument *This,VARIANT_BOOL *isPreserving);
    void __RPC_STUB IXMLDOMDocument_get_preserveWhiteSpace_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_put_preserveWhiteSpace_Proxy(IXMLDOMDocument *This,VARIANT_BOOL isPreserving);
    void __RPC_STUB IXMLDOMDocument_put_preserveWhiteSpace_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_put_onreadystatechange_Proxy(IXMLDOMDocument *This,VARIANT readystatechangeSink);
    void __RPC_STUB IXMLDOMDocument_put_onreadystatechange_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_put_ondataavailable_Proxy(IXMLDOMDocument *This,VARIANT ondataavailableSink);
    void __RPC_STUB IXMLDOMDocument_put_ondataavailable_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument_put_ontransformnode_Proxy(IXMLDOMDocument *This,VARIANT ontransformnodeSink);
    void __RPC_STUB IXMLDOMDocument_put_ontransformnode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMDocument2_INTERFACE_DEFINED__
#define __IXMLDOMDocument2_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMDocument2;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMDocument2 : public IXMLDOMDocument {
    public:
      virtual HRESULT WINAPI get_namespaces(IXMLDOMSchemaCollection **namespaceCollection) = 0;
      virtual HRESULT WINAPI get_schemas(VARIANT *otherCollection) = 0;
      virtual HRESULT WINAPI putref_schemas(VARIANT otherCollection) = 0;
      virtual HRESULT WINAPI validate(IXMLDOMParseError **errorObj) = 0;
      virtual HRESULT WINAPI setProperty(BSTR name,VARIANT value) = 0;
      virtual HRESULT WINAPI getProperty(BSTR name,VARIANT *value) = 0;
    };
#else
    typedef struct IXMLDOMDocument2Vtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMDocument2 *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMDocument2 *This);
	ULONG (WINAPI *Release)(IXMLDOMDocument2 *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMDocument2 *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMDocument2 *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMDocument2 *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMDocument2 *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMDocument2 *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMDocument2 *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMDocument2 *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMDocument2 *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMDocument2 *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMDocument2 *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMDocument2 *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMDocument2 *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMDocument2 *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMDocument2 *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMDocument2 *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMDocument2 *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMDocument2 *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMDocument2 *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMDocument2 *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMDocument2 *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMDocument2 *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMDocument2 *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMDocument2 *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMDocument2 *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMDocument2 *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMDocument2 *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMDocument2 *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMDocument2 *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMDocument2 *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMDocument2 *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMDocument2 *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMDocument2 *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMDocument2 *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMDocument2 *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMDocument2 *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMDocument2 *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMDocument2 *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMDocument2 *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMDocument2 *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMDocument2 *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_doctype)(IXMLDOMDocument2 *This,IXMLDOMDocumentType **documentType);
	HRESULT (WINAPI *get_implementation)(IXMLDOMDocument2 *This,IXMLDOMImplementation **impl);
	HRESULT (WINAPI *get_documentElement)(IXMLDOMDocument2 *This,IXMLDOMElement **DOMElement);
	HRESULT (WINAPI *putref_documentElement)(IXMLDOMDocument2 *This,IXMLDOMElement *DOMElement);
	HRESULT (WINAPI *createElement)(IXMLDOMDocument2 *This,BSTR tagName,IXMLDOMElement **element);
	HRESULT (WINAPI *createDocumentFragment)(IXMLDOMDocument2 *This,IXMLDOMDocumentFragment **docFrag);
	HRESULT (WINAPI *createTextNode)(IXMLDOMDocument2 *This,BSTR data,IXMLDOMText **text);
	HRESULT (WINAPI *createComment)(IXMLDOMDocument2 *This,BSTR data,IXMLDOMComment **comment);
	HRESULT (WINAPI *createCDATASection)(IXMLDOMDocument2 *This,BSTR data,IXMLDOMCDATASection **cdata);
	HRESULT (WINAPI *createProcessingInstruction)(IXMLDOMDocument2 *This,BSTR target,BSTR data,IXMLDOMProcessingInstruction **pi);
	HRESULT (WINAPI *createAttribute)(IXMLDOMDocument2 *This,BSTR name,IXMLDOMAttribute **attribute);
	HRESULT (WINAPI *createEntityReference)(IXMLDOMDocument2 *This,BSTR name,IXMLDOMEntityReference **entityRef);
	HRESULT (WINAPI *getElementsByTagName)(IXMLDOMDocument2 *This,BSTR tagName,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *createNode)(IXMLDOMDocument2 *This,VARIANT Type,BSTR name,BSTR namespaceURI,IXMLDOMNode **node);
	HRESULT (WINAPI *nodeFromID)(IXMLDOMDocument2 *This,BSTR idString,IXMLDOMNode **node);
	HRESULT (WINAPI *load)(IXMLDOMDocument2 *This,VARIANT xmlSource,VARIANT_BOOL *isSuccessful);
	HRESULT (WINAPI *get_readyState)(IXMLDOMDocument2 *This,long *value);
	HRESULT (WINAPI *get_parseError)(IXMLDOMDocument2 *This,IXMLDOMParseError **errorObj);
	HRESULT (WINAPI *get_url)(IXMLDOMDocument2 *This,BSTR *urlString);
	HRESULT (WINAPI *get_async)(IXMLDOMDocument2 *This,VARIANT_BOOL *isAsync);
	HRESULT (WINAPI *put_async)(IXMLDOMDocument2 *This,VARIANT_BOOL isAsync);
	HRESULT (WINAPI *abort)(IXMLDOMDocument2 *This);
	HRESULT (WINAPI *loadXML)(IXMLDOMDocument2 *This,BSTR bstrXML,VARIANT_BOOL *isSuccessful);
	HRESULT (WINAPI *save)(IXMLDOMDocument2 *This,VARIANT destination);
	HRESULT (WINAPI *get_validateOnParse)(IXMLDOMDocument2 *This,VARIANT_BOOL *isValidating);
	HRESULT (WINAPI *put_validateOnParse)(IXMLDOMDocument2 *This,VARIANT_BOOL isValidating);
	HRESULT (WINAPI *get_resolveExternals)(IXMLDOMDocument2 *This,VARIANT_BOOL *isResolving);
	HRESULT (WINAPI *put_resolveExternals)(IXMLDOMDocument2 *This,VARIANT_BOOL isResolving);
	HRESULT (WINAPI *get_preserveWhiteSpace)(IXMLDOMDocument2 *This,VARIANT_BOOL *isPreserving);
	HRESULT (WINAPI *put_preserveWhiteSpace)(IXMLDOMDocument2 *This,VARIANT_BOOL isPreserving);
	HRESULT (WINAPI *put_onreadystatechange)(IXMLDOMDocument2 *This,VARIANT readystatechangeSink);
	HRESULT (WINAPI *put_ondataavailable)(IXMLDOMDocument2 *This,VARIANT ondataavailableSink);
	HRESULT (WINAPI *put_ontransformnode)(IXMLDOMDocument2 *This,VARIANT ontransformnodeSink);
	HRESULT (WINAPI *get_namespaces)(IXMLDOMDocument2 *This,IXMLDOMSchemaCollection **namespaceCollection);
	HRESULT (WINAPI *get_schemas)(IXMLDOMDocument2 *This,VARIANT *otherCollection);
	HRESULT (WINAPI *putref_schemas)(IXMLDOMDocument2 *This,VARIANT otherCollection);
	HRESULT (WINAPI *validate)(IXMLDOMDocument2 *This,IXMLDOMParseError **errorObj);
	HRESULT (WINAPI *setProperty)(IXMLDOMDocument2 *This,BSTR name,VARIANT value);
	HRESULT (WINAPI *getProperty)(IXMLDOMDocument2 *This,BSTR name,VARIANT *value);
      END_INTERFACE
    } IXMLDOMDocument2Vtbl;
    struct IXMLDOMDocument2 {
      CONST_VTBL struct IXMLDOMDocument2Vtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMDocument2_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMDocument2_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMDocument2_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMDocument2_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMDocument2_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMDocument2_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMDocument2_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMDocument2_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMDocument2_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMDocument2_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMDocument2_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMDocument2_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMDocument2_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMDocument2_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMDocument2_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMDocument2_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMDocument2_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMDocument2_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMDocument2_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMDocument2_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMDocument2_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMDocument2_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMDocument2_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMDocument2_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMDocument2_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMDocument2_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMDocument2_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMDocument2_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMDocument2_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMDocument2_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMDocument2_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMDocument2_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMDocument2_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMDocument2_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMDocument2_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMDocument2_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMDocument2_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMDocument2_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMDocument2_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMDocument2_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMDocument2_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMDocument2_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMDocument2_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMDocument2_get_doctype(This,documentType) (This)->lpVtbl->get_doctype(This,documentType)
#define IXMLDOMDocument2_get_implementation(This,impl) (This)->lpVtbl->get_implementation(This,impl)
#define IXMLDOMDocument2_get_documentElement(This,DOMElement) (This)->lpVtbl->get_documentElement(This,DOMElement)
#define IXMLDOMDocument2_putref_documentElement(This,DOMElement) (This)->lpVtbl->putref_documentElement(This,DOMElement)
#define IXMLDOMDocument2_createElement(This,tagName,element) (This)->lpVtbl->createElement(This,tagName,element)
#define IXMLDOMDocument2_createDocumentFragment(This,docFrag) (This)->lpVtbl->createDocumentFragment(This,docFrag)
#define IXMLDOMDocument2_createTextNode(This,data,text) (This)->lpVtbl->createTextNode(This,data,text)
#define IXMLDOMDocument2_createComment(This,data,comment) (This)->lpVtbl->createComment(This,data,comment)
#define IXMLDOMDocument2_createCDATASection(This,data,cdata) (This)->lpVtbl->createCDATASection(This,data,cdata)
#define IXMLDOMDocument2_createProcessingInstruction(This,target,data,pi) (This)->lpVtbl->createProcessingInstruction(This,target,data,pi)
#define IXMLDOMDocument2_createAttribute(This,name,attribute) (This)->lpVtbl->createAttribute(This,name,attribute)
#define IXMLDOMDocument2_createEntityReference(This,name,entityRef) (This)->lpVtbl->createEntityReference(This,name,entityRef)
#define IXMLDOMDocument2_getElementsByTagName(This,tagName,resultList) (This)->lpVtbl->getElementsByTagName(This,tagName,resultList)
#define IXMLDOMDocument2_createNode(This,Type,name,namespaceURI,node) (This)->lpVtbl->createNode(This,Type,name,namespaceURI,node)
#define IXMLDOMDocument2_nodeFromID(This,idString,node) (This)->lpVtbl->nodeFromID(This,idString,node)
#define IXMLDOMDocument2_load(This,xmlSource,isSuccessful) (This)->lpVtbl->load(This,xmlSource,isSuccessful)
#define IXMLDOMDocument2_get_readyState(This,value) (This)->lpVtbl->get_readyState(This,value)
#define IXMLDOMDocument2_get_parseError(This,errorObj) (This)->lpVtbl->get_parseError(This,errorObj)
#define IXMLDOMDocument2_get_url(This,urlString) (This)->lpVtbl->get_url(This,urlString)
#define IXMLDOMDocument2_get_async(This,isAsync) (This)->lpVtbl->get_async(This,isAsync)
#define IXMLDOMDocument2_put_async(This,isAsync) (This)->lpVtbl->put_async(This,isAsync)
#define IXMLDOMDocument2_abort(This) (This)->lpVtbl->abort(This)
#define IXMLDOMDocument2_loadXML(This,bstrXML,isSuccessful) (This)->lpVtbl->loadXML(This,bstrXML,isSuccessful)
#define IXMLDOMDocument2_save(This,destination) (This)->lpVtbl->save(This,destination)
#define IXMLDOMDocument2_get_validateOnParse(This,isValidating) (This)->lpVtbl->get_validateOnParse(This,isValidating)
#define IXMLDOMDocument2_put_validateOnParse(This,isValidating) (This)->lpVtbl->put_validateOnParse(This,isValidating)
#define IXMLDOMDocument2_get_resolveExternals(This,isResolving) (This)->lpVtbl->get_resolveExternals(This,isResolving)
#define IXMLDOMDocument2_put_resolveExternals(This,isResolving) (This)->lpVtbl->put_resolveExternals(This,isResolving)
#define IXMLDOMDocument2_get_preserveWhiteSpace(This,isPreserving) (This)->lpVtbl->get_preserveWhiteSpace(This,isPreserving)
#define IXMLDOMDocument2_put_preserveWhiteSpace(This,isPreserving) (This)->lpVtbl->put_preserveWhiteSpace(This,isPreserving)
#define IXMLDOMDocument2_put_onreadystatechange(This,readystatechangeSink) (This)->lpVtbl->put_onreadystatechange(This,readystatechangeSink)
#define IXMLDOMDocument2_put_ondataavailable(This,ondataavailableSink) (This)->lpVtbl->put_ondataavailable(This,ondataavailableSink)
#define IXMLDOMDocument2_put_ontransformnode(This,ontransformnodeSink) (This)->lpVtbl->put_ontransformnode(This,ontransformnodeSink)
#define IXMLDOMDocument2_get_namespaces(This,namespaceCollection) (This)->lpVtbl->get_namespaces(This,namespaceCollection)
#define IXMLDOMDocument2_get_schemas(This,otherCollection) (This)->lpVtbl->get_schemas(This,otherCollection)
#define IXMLDOMDocument2_putref_schemas(This,otherCollection) (This)->lpVtbl->putref_schemas(This,otherCollection)
#define IXMLDOMDocument2_validate(This,errorObj) (This)->lpVtbl->validate(This,errorObj)
#define IXMLDOMDocument2_setProperty(This,name,value) (This)->lpVtbl->setProperty(This,name,value)
#define IXMLDOMDocument2_getProperty(This,name,value) (This)->lpVtbl->getProperty(This,name,value)
#endif
#endif
    HRESULT WINAPI IXMLDOMDocument2_get_namespaces_Proxy(IXMLDOMDocument2 *This,IXMLDOMSchemaCollection **namespaceCollection);
    void __RPC_STUB IXMLDOMDocument2_get_namespaces_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument2_get_schemas_Proxy(IXMLDOMDocument2 *This,VARIANT *otherCollection);
    void __RPC_STUB IXMLDOMDocument2_get_schemas_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument2_putref_schemas_Proxy(IXMLDOMDocument2 *This,VARIANT otherCollection);
    void __RPC_STUB IXMLDOMDocument2_putref_schemas_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument2_validate_Proxy(IXMLDOMDocument2 *This,IXMLDOMParseError **errorObj);
    void __RPC_STUB IXMLDOMDocument2_validate_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument2_setProperty_Proxy(IXMLDOMDocument2 *This,BSTR name,VARIANT value);
    void __RPC_STUB IXMLDOMDocument2_setProperty_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocument2_getProperty_Proxy(IXMLDOMDocument2 *This,BSTR name,VARIANT *value);
    void __RPC_STUB IXMLDOMDocument2_getProperty_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMNodeList_INTERFACE_DEFINED__
#define __IXMLDOMNodeList_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMNodeList;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMNodeList : public IDispatch {
    public:
      virtual HRESULT WINAPI get_item(long index,IXMLDOMNode **listItem) = 0;
      virtual HRESULT WINAPI get_length(long *listLength) = 0;
      virtual HRESULT WINAPI nextNode(IXMLDOMNode **nextItem) = 0;
      virtual HRESULT WINAPI reset(void) = 0;
      virtual HRESULT WINAPI get__newEnum(IUnknown **ppUnk) = 0;
    };
#else
    typedef struct IXMLDOMNodeListVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMNodeList *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMNodeList *This);
	ULONG (WINAPI *Release)(IXMLDOMNodeList *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMNodeList *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMNodeList *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMNodeList *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMNodeList *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_item)(IXMLDOMNodeList *This,long index,IXMLDOMNode **listItem);
	HRESULT (WINAPI *get_length)(IXMLDOMNodeList *This,long *listLength);
	HRESULT (WINAPI *nextNode)(IXMLDOMNodeList *This,IXMLDOMNode **nextItem);
	HRESULT (WINAPI *reset)(IXMLDOMNodeList *This);
	HRESULT (WINAPI *get__newEnum)(IXMLDOMNodeList *This,IUnknown **ppUnk);
      END_INTERFACE
    } IXMLDOMNodeListVtbl;
    struct IXMLDOMNodeList {
      CONST_VTBL struct IXMLDOMNodeListVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMNodeList_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMNodeList_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMNodeList_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMNodeList_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMNodeList_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMNodeList_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMNodeList_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMNodeList_get_item(This,index,listItem) (This)->lpVtbl->get_item(This,index,listItem)
#define IXMLDOMNodeList_get_length(This,listLength) (This)->lpVtbl->get_length(This,listLength)
#define IXMLDOMNodeList_nextNode(This,nextItem) (This)->lpVtbl->nextNode(This,nextItem)
#define IXMLDOMNodeList_reset(This) (This)->lpVtbl->reset(This)
#define IXMLDOMNodeList_get__newEnum(This,ppUnk) (This)->lpVtbl->get__newEnum(This,ppUnk)
#endif
#endif
    HRESULT WINAPI IXMLDOMNodeList_get_item_Proxy(IXMLDOMNodeList *This,long index,IXMLDOMNode **listItem);
    void __RPC_STUB IXMLDOMNodeList_get_item_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNodeList_get_length_Proxy(IXMLDOMNodeList *This,long *listLength);
    void __RPC_STUB IXMLDOMNodeList_get_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNodeList_nextNode_Proxy(IXMLDOMNodeList *This,IXMLDOMNode **nextItem);
    void __RPC_STUB IXMLDOMNodeList_nextNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNodeList_reset_Proxy(IXMLDOMNodeList *This);
    void __RPC_STUB IXMLDOMNodeList_reset_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNodeList_get__newEnum_Proxy(IXMLDOMNodeList *This,IUnknown **ppUnk);
    void __RPC_STUB IXMLDOMNodeList_get__newEnum_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMNamedNodeMap_INTERFACE_DEFINED__
#define __IXMLDOMNamedNodeMap_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMNamedNodeMap;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMNamedNodeMap : public IDispatch {
    public:
      virtual HRESULT WINAPI getNamedItem(BSTR name,IXMLDOMNode **namedItem) = 0;
      virtual HRESULT WINAPI setNamedItem(IXMLDOMNode *newItem,IXMLDOMNode **nameItem) = 0;
      virtual HRESULT WINAPI removeNamedItem(BSTR name,IXMLDOMNode **namedItem) = 0;
      virtual HRESULT WINAPI get_item(long index,IXMLDOMNode **listItem) = 0;
      virtual HRESULT WINAPI get_length(long *listLength) = 0;
      virtual HRESULT WINAPI getQualifiedItem(BSTR baseName,BSTR namespaceURI,IXMLDOMNode **qualifiedItem) = 0;
      virtual HRESULT WINAPI removeQualifiedItem(BSTR baseName,BSTR namespaceURI,IXMLDOMNode **qualifiedItem) = 0;
      virtual HRESULT WINAPI nextNode(IXMLDOMNode **nextItem) = 0;
      virtual HRESULT WINAPI reset(void) = 0;
      virtual HRESULT WINAPI get__newEnum(IUnknown **ppUnk) = 0;
    };
#else
    typedef struct IXMLDOMNamedNodeMapVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMNamedNodeMap *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMNamedNodeMap *This);
	ULONG (WINAPI *Release)(IXMLDOMNamedNodeMap *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMNamedNodeMap *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMNamedNodeMap *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMNamedNodeMap *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMNamedNodeMap *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *getNamedItem)(IXMLDOMNamedNodeMap *This,BSTR name,IXMLDOMNode **namedItem);
	HRESULT (WINAPI *setNamedItem)(IXMLDOMNamedNodeMap *This,IXMLDOMNode *newItem,IXMLDOMNode **nameItem);
	HRESULT (WINAPI *removeNamedItem)(IXMLDOMNamedNodeMap *This,BSTR name,IXMLDOMNode **namedItem);
	HRESULT (WINAPI *get_item)(IXMLDOMNamedNodeMap *This,long index,IXMLDOMNode **listItem);
	HRESULT (WINAPI *get_length)(IXMLDOMNamedNodeMap *This,long *listLength);
	HRESULT (WINAPI *getQualifiedItem)(IXMLDOMNamedNodeMap *This,BSTR baseName,BSTR namespaceURI,IXMLDOMNode **qualifiedItem);
	HRESULT (WINAPI *removeQualifiedItem)(IXMLDOMNamedNodeMap *This,BSTR baseName,BSTR namespaceURI,IXMLDOMNode **qualifiedItem);
	HRESULT (WINAPI *nextNode)(IXMLDOMNamedNodeMap *This,IXMLDOMNode **nextItem);
	HRESULT (WINAPI *reset)(IXMLDOMNamedNodeMap *This);
	HRESULT (WINAPI *get__newEnum)(IXMLDOMNamedNodeMap *This,IUnknown **ppUnk);
      END_INTERFACE
    } IXMLDOMNamedNodeMapVtbl;
    struct IXMLDOMNamedNodeMap {
      CONST_VTBL struct IXMLDOMNamedNodeMapVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMNamedNodeMap_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMNamedNodeMap_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMNamedNodeMap_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMNamedNodeMap_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMNamedNodeMap_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMNamedNodeMap_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMNamedNodeMap_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMNamedNodeMap_getNamedItem(This,name,namedItem) (This)->lpVtbl->getNamedItem(This,name,namedItem)
#define IXMLDOMNamedNodeMap_setNamedItem(This,newItem,nameItem) (This)->lpVtbl->setNamedItem(This,newItem,nameItem)
#define IXMLDOMNamedNodeMap_removeNamedItem(This,name,namedItem) (This)->lpVtbl->removeNamedItem(This,name,namedItem)
#define IXMLDOMNamedNodeMap_get_item(This,index,listItem) (This)->lpVtbl->get_item(This,index,listItem)
#define IXMLDOMNamedNodeMap_get_length(This,listLength) (This)->lpVtbl->get_length(This,listLength)
#define IXMLDOMNamedNodeMap_getQualifiedItem(This,baseName,namespaceURI,qualifiedItem) (This)->lpVtbl->getQualifiedItem(This,baseName,namespaceURI,qualifiedItem)
#define IXMLDOMNamedNodeMap_removeQualifiedItem(This,baseName,namespaceURI,qualifiedItem) (This)->lpVtbl->removeQualifiedItem(This,baseName,namespaceURI,qualifiedItem)
#define IXMLDOMNamedNodeMap_nextNode(This,nextItem) (This)->lpVtbl->nextNode(This,nextItem)
#define IXMLDOMNamedNodeMap_reset(This) (This)->lpVtbl->reset(This)
#define IXMLDOMNamedNodeMap_get__newEnum(This,ppUnk) (This)->lpVtbl->get__newEnum(This,ppUnk)
#endif
#endif
    HRESULT WINAPI IXMLDOMNamedNodeMap_getNamedItem_Proxy(IXMLDOMNamedNodeMap *This,BSTR name,IXMLDOMNode **namedItem);
    void __RPC_STUB IXMLDOMNamedNodeMap_getNamedItem_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNamedNodeMap_setNamedItem_Proxy(IXMLDOMNamedNodeMap *This,IXMLDOMNode *newItem,IXMLDOMNode **nameItem);
    void __RPC_STUB IXMLDOMNamedNodeMap_setNamedItem_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNamedNodeMap_removeNamedItem_Proxy(IXMLDOMNamedNodeMap *This,BSTR name,IXMLDOMNode **namedItem);
    void __RPC_STUB IXMLDOMNamedNodeMap_removeNamedItem_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNamedNodeMap_get_item_Proxy(IXMLDOMNamedNodeMap *This,long index,IXMLDOMNode **listItem);
    void __RPC_STUB IXMLDOMNamedNodeMap_get_item_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNamedNodeMap_get_length_Proxy(IXMLDOMNamedNodeMap *This,long *listLength);
    void __RPC_STUB IXMLDOMNamedNodeMap_get_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNamedNodeMap_getQualifiedItem_Proxy(IXMLDOMNamedNodeMap *This,BSTR baseName,BSTR namespaceURI,IXMLDOMNode **qualifiedItem);
    void __RPC_STUB IXMLDOMNamedNodeMap_getQualifiedItem_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNamedNodeMap_removeQualifiedItem_Proxy(IXMLDOMNamedNodeMap *This,BSTR baseName,BSTR namespaceURI,IXMLDOMNode **qualifiedItem);
    void __RPC_STUB IXMLDOMNamedNodeMap_removeQualifiedItem_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNamedNodeMap_nextNode_Proxy(IXMLDOMNamedNodeMap *This,IXMLDOMNode **nextItem);
    void __RPC_STUB IXMLDOMNamedNodeMap_nextNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNamedNodeMap_reset_Proxy(IXMLDOMNamedNodeMap *This);
    void __RPC_STUB IXMLDOMNamedNodeMap_reset_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNamedNodeMap_get__newEnum_Proxy(IXMLDOMNamedNodeMap *This,IUnknown **ppUnk);
    void __RPC_STUB IXMLDOMNamedNodeMap_get__newEnum_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMCharacterData_INTERFACE_DEFINED__
#define __IXMLDOMCharacterData_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMCharacterData;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMCharacterData : public IXMLDOMNode {
    public:
      virtual HRESULT WINAPI get_data(BSTR *data) = 0;
      virtual HRESULT WINAPI put_data(BSTR data) = 0;
      virtual HRESULT WINAPI get_length(long *dataLength) = 0;
      virtual HRESULT WINAPI substringData(long offset,long count,BSTR *data) = 0;
      virtual HRESULT WINAPI appendData(BSTR data) = 0;
      virtual HRESULT WINAPI insertData(long offset,BSTR data) = 0;
      virtual HRESULT WINAPI deleteData(long offset,long count) = 0;
      virtual HRESULT WINAPI replaceData(long offset,long count,BSTR data) = 0;
    };
#else
    typedef struct IXMLDOMCharacterDataVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMCharacterData *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMCharacterData *This);
	ULONG (WINAPI *Release)(IXMLDOMCharacterData *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMCharacterData *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMCharacterData *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMCharacterData *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMCharacterData *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMCharacterData *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMCharacterData *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMCharacterData *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMCharacterData *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMCharacterData *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMCharacterData *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMCharacterData *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMCharacterData *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMCharacterData *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMCharacterData *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMCharacterData *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMCharacterData *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMCharacterData *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMCharacterData *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMCharacterData *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMCharacterData *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMCharacterData *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMCharacterData *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMCharacterData *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMCharacterData *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMCharacterData *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMCharacterData *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMCharacterData *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMCharacterData *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMCharacterData *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMCharacterData *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMCharacterData *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMCharacterData *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMCharacterData *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMCharacterData *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMCharacterData *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMCharacterData *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMCharacterData *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMCharacterData *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMCharacterData *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMCharacterData *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_data)(IXMLDOMCharacterData *This,BSTR *data);
	HRESULT (WINAPI *put_data)(IXMLDOMCharacterData *This,BSTR data);
	HRESULT (WINAPI *get_length)(IXMLDOMCharacterData *This,long *dataLength);
	HRESULT (WINAPI *substringData)(IXMLDOMCharacterData *This,long offset,long count,BSTR *data);
	HRESULT (WINAPI *appendData)(IXMLDOMCharacterData *This,BSTR data);
	HRESULT (WINAPI *insertData)(IXMLDOMCharacterData *This,long offset,BSTR data);
	HRESULT (WINAPI *deleteData)(IXMLDOMCharacterData *This,long offset,long count);
	HRESULT (WINAPI *replaceData)(IXMLDOMCharacterData *This,long offset,long count,BSTR data);
      END_INTERFACE
    } IXMLDOMCharacterDataVtbl;
    struct IXMLDOMCharacterData {
      CONST_VTBL struct IXMLDOMCharacterDataVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMCharacterData_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMCharacterData_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMCharacterData_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMCharacterData_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMCharacterData_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMCharacterData_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMCharacterData_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMCharacterData_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMCharacterData_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMCharacterData_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMCharacterData_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMCharacterData_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMCharacterData_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMCharacterData_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMCharacterData_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMCharacterData_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMCharacterData_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMCharacterData_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMCharacterData_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMCharacterData_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMCharacterData_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMCharacterData_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMCharacterData_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMCharacterData_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMCharacterData_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMCharacterData_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMCharacterData_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMCharacterData_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMCharacterData_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMCharacterData_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMCharacterData_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMCharacterData_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMCharacterData_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMCharacterData_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMCharacterData_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMCharacterData_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMCharacterData_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMCharacterData_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMCharacterData_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMCharacterData_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMCharacterData_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMCharacterData_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMCharacterData_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMCharacterData_get_data(This,data) (This)->lpVtbl->get_data(This,data)
#define IXMLDOMCharacterData_put_data(This,data) (This)->lpVtbl->put_data(This,data)
#define IXMLDOMCharacterData_get_length(This,dataLength) (This)->lpVtbl->get_length(This,dataLength)
#define IXMLDOMCharacterData_substringData(This,offset,count,data) (This)->lpVtbl->substringData(This,offset,count,data)
#define IXMLDOMCharacterData_appendData(This,data) (This)->lpVtbl->appendData(This,data)
#define IXMLDOMCharacterData_insertData(This,offset,data) (This)->lpVtbl->insertData(This,offset,data)
#define IXMLDOMCharacterData_deleteData(This,offset,count) (This)->lpVtbl->deleteData(This,offset,count)
#define IXMLDOMCharacterData_replaceData(This,offset,count,data) (This)->lpVtbl->replaceData(This,offset,count,data)
#endif
#endif
    HRESULT WINAPI IXMLDOMCharacterData_get_data_Proxy(IXMLDOMCharacterData *This,BSTR *data);
    void __RPC_STUB IXMLDOMCharacterData_get_data_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMCharacterData_put_data_Proxy(IXMLDOMCharacterData *This,BSTR data);
    void __RPC_STUB IXMLDOMCharacterData_put_data_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMCharacterData_get_length_Proxy(IXMLDOMCharacterData *This,long *dataLength);
    void __RPC_STUB IXMLDOMCharacterData_get_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMCharacterData_substringData_Proxy(IXMLDOMCharacterData *This,long offset,long count,BSTR *data);
    void __RPC_STUB IXMLDOMCharacterData_substringData_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMCharacterData_appendData_Proxy(IXMLDOMCharacterData *This,BSTR data);
    void __RPC_STUB IXMLDOMCharacterData_appendData_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMCharacterData_insertData_Proxy(IXMLDOMCharacterData *This,long offset,BSTR data);
    void __RPC_STUB IXMLDOMCharacterData_insertData_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMCharacterData_deleteData_Proxy(IXMLDOMCharacterData *This,long offset,long count);
    void __RPC_STUB IXMLDOMCharacterData_deleteData_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMCharacterData_replaceData_Proxy(IXMLDOMCharacterData *This,long offset,long count,BSTR data);
    void __RPC_STUB IXMLDOMCharacterData_replaceData_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMAttribute_INTERFACE_DEFINED__
#define __IXMLDOMAttribute_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMAttribute;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMAttribute : public IXMLDOMNode {
    public:
      virtual HRESULT WINAPI get_name(BSTR *attributeName) = 0;
      virtual HRESULT WINAPI get_value(VARIANT *attributeValue) = 0;
      virtual HRESULT WINAPI put_value(VARIANT attributeValue) = 0;
    };
#else
    typedef struct IXMLDOMAttributeVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMAttribute *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMAttribute *This);
	ULONG (WINAPI *Release)(IXMLDOMAttribute *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMAttribute *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMAttribute *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMAttribute *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMAttribute *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMAttribute *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMAttribute *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMAttribute *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMAttribute *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMAttribute *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMAttribute *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMAttribute *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMAttribute *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMAttribute *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMAttribute *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMAttribute *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMAttribute *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMAttribute *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMAttribute *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMAttribute *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMAttribute *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMAttribute *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMAttribute *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMAttribute *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMAttribute *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMAttribute *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMAttribute *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMAttribute *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMAttribute *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMAttribute *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMAttribute *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMAttribute *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMAttribute *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMAttribute *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMAttribute *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMAttribute *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMAttribute *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMAttribute *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMAttribute *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMAttribute *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMAttribute *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_name)(IXMLDOMAttribute *This,BSTR *attributeName);
	HRESULT (WINAPI *get_value)(IXMLDOMAttribute *This,VARIANT *attributeValue);
	HRESULT (WINAPI *put_value)(IXMLDOMAttribute *This,VARIANT attributeValue);
      END_INTERFACE
    } IXMLDOMAttributeVtbl;
    struct IXMLDOMAttribute {
      CONST_VTBL struct IXMLDOMAttributeVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMAttribute_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMAttribute_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMAttribute_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMAttribute_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMAttribute_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMAttribute_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMAttribute_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMAttribute_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMAttribute_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMAttribute_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMAttribute_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMAttribute_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMAttribute_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMAttribute_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMAttribute_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMAttribute_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMAttribute_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMAttribute_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMAttribute_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMAttribute_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMAttribute_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMAttribute_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMAttribute_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMAttribute_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMAttribute_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMAttribute_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMAttribute_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMAttribute_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMAttribute_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMAttribute_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMAttribute_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMAttribute_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMAttribute_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMAttribute_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMAttribute_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMAttribute_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMAttribute_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMAttribute_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMAttribute_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMAttribute_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMAttribute_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMAttribute_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMAttribute_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMAttribute_get_name(This,attributeName) (This)->lpVtbl->get_name(This,attributeName)
#define IXMLDOMAttribute_get_value(This,attributeValue) (This)->lpVtbl->get_value(This,attributeValue)
#define IXMLDOMAttribute_put_value(This,attributeValue) (This)->lpVtbl->put_value(This,attributeValue)
#endif
#endif
    HRESULT WINAPI IXMLDOMAttribute_get_name_Proxy(IXMLDOMAttribute *This,BSTR *attributeName);
    void __RPC_STUB IXMLDOMAttribute_get_name_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMAttribute_get_value_Proxy(IXMLDOMAttribute *This,VARIANT *attributeValue);
    void __RPC_STUB IXMLDOMAttribute_get_value_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMAttribute_put_value_Proxy(IXMLDOMAttribute *This,VARIANT attributeValue);
    void __RPC_STUB IXMLDOMAttribute_put_value_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMElement_INTERFACE_DEFINED__
#define __IXMLDOMElement_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMElement;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMElement : public IXMLDOMNode {
    public:
      virtual HRESULT WINAPI get_tagName(BSTR *tagName) = 0;
      virtual HRESULT WINAPI getAttribute(BSTR name,VARIANT *value) = 0;
      virtual HRESULT WINAPI setAttribute(BSTR name,VARIANT value) = 0;
      virtual HRESULT WINAPI removeAttribute(BSTR name) = 0;
      virtual HRESULT WINAPI getAttributeNode(BSTR name,IXMLDOMAttribute **attributeNode) = 0;
      virtual HRESULT WINAPI setAttributeNode(IXMLDOMAttribute *DOMAttribute,IXMLDOMAttribute **attributeNode) = 0;
      virtual HRESULT WINAPI removeAttributeNode(IXMLDOMAttribute *DOMAttribute,IXMLDOMAttribute **attributeNode) = 0;
      virtual HRESULT WINAPI getElementsByTagName(BSTR tagName,IXMLDOMNodeList **resultList) = 0;
      virtual HRESULT WINAPI normalize(void) = 0;
    };
#else
    typedef struct IXMLDOMElementVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMElement *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMElement *This);
	ULONG (WINAPI *Release)(IXMLDOMElement *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMElement *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMElement *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMElement *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMElement *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMElement *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMElement *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMElement *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMElement *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMElement *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMElement *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMElement *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMElement *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMElement *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMElement *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMElement *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMElement *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMElement *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMElement *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMElement *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMElement *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMElement *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMElement *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMElement *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMElement *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMElement *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMElement *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMElement *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMElement *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMElement *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMElement *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMElement *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMElement *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMElement *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMElement *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMElement *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMElement *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMElement *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMElement *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMElement *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMElement *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_tagName)(IXMLDOMElement *This,BSTR *tagName);
	HRESULT (WINAPI *getAttribute)(IXMLDOMElement *This,BSTR name,VARIANT *value);
	HRESULT (WINAPI *setAttribute)(IXMLDOMElement *This,BSTR name,VARIANT value);
	HRESULT (WINAPI *removeAttribute)(IXMLDOMElement *This,BSTR name);
	HRESULT (WINAPI *getAttributeNode)(IXMLDOMElement *This,BSTR name,IXMLDOMAttribute **attributeNode);
	HRESULT (WINAPI *setAttributeNode)(IXMLDOMElement *This,IXMLDOMAttribute *DOMAttribute,IXMLDOMAttribute **attributeNode);
	HRESULT (WINAPI *removeAttributeNode)(IXMLDOMElement *This,IXMLDOMAttribute *DOMAttribute,IXMLDOMAttribute **attributeNode);
	HRESULT (WINAPI *getElementsByTagName)(IXMLDOMElement *This,BSTR tagName,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *normalize)(IXMLDOMElement *This);
      END_INTERFACE
    } IXMLDOMElementVtbl;
    struct IXMLDOMElement {
      CONST_VTBL struct IXMLDOMElementVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMElement_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMElement_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMElement_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMElement_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMElement_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMElement_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMElement_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMElement_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMElement_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMElement_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMElement_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMElement_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMElement_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMElement_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMElement_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMElement_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMElement_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMElement_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMElement_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMElement_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMElement_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMElement_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMElement_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMElement_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMElement_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMElement_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMElement_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMElement_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMElement_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMElement_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMElement_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMElement_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMElement_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMElement_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMElement_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMElement_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMElement_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMElement_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMElement_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMElement_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMElement_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMElement_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMElement_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMElement_get_tagName(This,tagName) (This)->lpVtbl->get_tagName(This,tagName)
#define IXMLDOMElement_getAttribute(This,name,value) (This)->lpVtbl->getAttribute(This,name,value)
#define IXMLDOMElement_setAttribute(This,name,value) (This)->lpVtbl->setAttribute(This,name,value)
#define IXMLDOMElement_removeAttribute(This,name) (This)->lpVtbl->removeAttribute(This,name)
#define IXMLDOMElement_getAttributeNode(This,name,attributeNode) (This)->lpVtbl->getAttributeNode(This,name,attributeNode)
#define IXMLDOMElement_setAttributeNode(This,DOMAttribute,attributeNode) (This)->lpVtbl->setAttributeNode(This,DOMAttribute,attributeNode)
#define IXMLDOMElement_removeAttributeNode(This,DOMAttribute,attributeNode) (This)->lpVtbl->removeAttributeNode(This,DOMAttribute,attributeNode)
#define IXMLDOMElement_getElementsByTagName(This,tagName,resultList) (This)->lpVtbl->getElementsByTagName(This,tagName,resultList)
#define IXMLDOMElement_normalize(This) (This)->lpVtbl->normalize(This)
#endif
#endif
    HRESULT WINAPI IXMLDOMElement_get_tagName_Proxy(IXMLDOMElement *This,BSTR *tagName);
    void __RPC_STUB IXMLDOMElement_get_tagName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMElement_getAttribute_Proxy(IXMLDOMElement *This,BSTR name,VARIANT *value);
    void __RPC_STUB IXMLDOMElement_getAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMElement_setAttribute_Proxy(IXMLDOMElement *This,BSTR name,VARIANT value);
    void __RPC_STUB IXMLDOMElement_setAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMElement_removeAttribute_Proxy(IXMLDOMElement *This,BSTR name);
    void __RPC_STUB IXMLDOMElement_removeAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMElement_getAttributeNode_Proxy(IXMLDOMElement *This,BSTR name,IXMLDOMAttribute **attributeNode);
    void __RPC_STUB IXMLDOMElement_getAttributeNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMElement_setAttributeNode_Proxy(IXMLDOMElement *This,IXMLDOMAttribute *DOMAttribute,IXMLDOMAttribute **attributeNode);
    void __RPC_STUB IXMLDOMElement_setAttributeNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMElement_removeAttributeNode_Proxy(IXMLDOMElement *This,IXMLDOMAttribute *DOMAttribute,IXMLDOMAttribute **attributeNode);
    void __RPC_STUB IXMLDOMElement_removeAttributeNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMElement_getElementsByTagName_Proxy(IXMLDOMElement *This,BSTR tagName,IXMLDOMNodeList **resultList);
    void __RPC_STUB IXMLDOMElement_getElementsByTagName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMElement_normalize_Proxy(IXMLDOMElement *This);
    void __RPC_STUB IXMLDOMElement_normalize_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMText_INTERFACE_DEFINED__
#define __IXMLDOMText_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMText;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMText : public IXMLDOMCharacterData {
    public:
      virtual HRESULT WINAPI splitText(long offset,IXMLDOMText **rightHandTextNode) = 0;
    };
#else
    typedef struct IXMLDOMTextVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMText *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMText *This);
	ULONG (WINAPI *Release)(IXMLDOMText *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMText *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMText *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMText *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMText *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMText *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMText *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMText *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMText *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMText *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMText *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMText *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMText *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMText *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMText *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMText *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMText *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMText *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMText *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMText *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMText *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMText *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMText *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMText *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMText *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMText *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMText *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMText *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMText *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMText *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMText *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMText *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMText *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMText *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMText *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMText *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMText *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMText *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMText *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMText *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMText *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_data)(IXMLDOMText *This,BSTR *data);
	HRESULT (WINAPI *put_data)(IXMLDOMText *This,BSTR data);
	HRESULT (WINAPI *get_length)(IXMLDOMText *This,long *dataLength);
	HRESULT (WINAPI *substringData)(IXMLDOMText *This,long offset,long count,BSTR *data);
	HRESULT (WINAPI *appendData)(IXMLDOMText *This,BSTR data);
	HRESULT (WINAPI *insertData)(IXMLDOMText *This,long offset,BSTR data);
	HRESULT (WINAPI *deleteData)(IXMLDOMText *This,long offset,long count);
	HRESULT (WINAPI *replaceData)(IXMLDOMText *This,long offset,long count,BSTR data);
	HRESULT (WINAPI *splitText)(IXMLDOMText *This,long offset,IXMLDOMText **rightHandTextNode);
      END_INTERFACE
    } IXMLDOMTextVtbl;
    struct IXMLDOMText {
      CONST_VTBL struct IXMLDOMTextVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMText_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMText_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMText_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMText_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMText_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMText_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMText_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMText_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMText_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMText_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMText_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMText_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMText_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMText_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMText_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMText_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMText_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMText_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMText_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMText_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMText_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMText_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMText_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMText_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMText_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMText_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMText_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMText_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMText_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMText_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMText_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMText_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMText_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMText_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMText_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMText_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMText_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMText_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMText_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMText_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMText_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMText_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMText_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMText_get_data(This,data) (This)->lpVtbl->get_data(This,data)
#define IXMLDOMText_put_data(This,data) (This)->lpVtbl->put_data(This,data)
#define IXMLDOMText_get_length(This,dataLength) (This)->lpVtbl->get_length(This,dataLength)
#define IXMLDOMText_substringData(This,offset,count,data) (This)->lpVtbl->substringData(This,offset,count,data)
#define IXMLDOMText_appendData(This,data) (This)->lpVtbl->appendData(This,data)
#define IXMLDOMText_insertData(This,offset,data) (This)->lpVtbl->insertData(This,offset,data)
#define IXMLDOMText_deleteData(This,offset,count) (This)->lpVtbl->deleteData(This,offset,count)
#define IXMLDOMText_replaceData(This,offset,count,data) (This)->lpVtbl->replaceData(This,offset,count,data)
#define IXMLDOMText_splitText(This,offset,rightHandTextNode) (This)->lpVtbl->splitText(This,offset,rightHandTextNode)
#endif
#endif
    HRESULT WINAPI IXMLDOMText_splitText_Proxy(IXMLDOMText *This,long offset,IXMLDOMText **rightHandTextNode);
    void __RPC_STUB IXMLDOMText_splitText_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMComment_INTERFACE_DEFINED__
#define __IXMLDOMComment_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMComment;
#if defined(__cplusplus) && !defined(CINTERFACE)

    struct IXMLDOMComment : public IXMLDOMCharacterData {
    };
#else
    typedef struct IXMLDOMCommentVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMComment *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMComment *This);
	ULONG (WINAPI *Release)(IXMLDOMComment *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMComment *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMComment *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMComment *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMComment *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMComment *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMComment *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMComment *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMComment *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMComment *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMComment *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMComment *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMComment *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMComment *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMComment *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMComment *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMComment *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMComment *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMComment *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMComment *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMComment *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMComment *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMComment *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMComment *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMComment *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMComment *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMComment *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMComment *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMComment *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMComment *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMComment *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMComment *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMComment *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMComment *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMComment *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMComment *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMComment *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMComment *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMComment *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMComment *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMComment *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_data)(IXMLDOMComment *This,BSTR *data);
	HRESULT (WINAPI *put_data)(IXMLDOMComment *This,BSTR data);
	HRESULT (WINAPI *get_length)(IXMLDOMComment *This,long *dataLength);
	HRESULT (WINAPI *substringData)(IXMLDOMComment *This,long offset,long count,BSTR *data);
	HRESULT (WINAPI *appendData)(IXMLDOMComment *This,BSTR data);
	HRESULT (WINAPI *insertData)(IXMLDOMComment *This,long offset,BSTR data);
	HRESULT (WINAPI *deleteData)(IXMLDOMComment *This,long offset,long count);
	HRESULT (WINAPI *replaceData)(IXMLDOMComment *This,long offset,long count,BSTR data);
      END_INTERFACE
    } IXMLDOMCommentVtbl;
    struct IXMLDOMComment {
      CONST_VTBL struct IXMLDOMCommentVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMComment_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMComment_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMComment_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMComment_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMComment_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMComment_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMComment_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMComment_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMComment_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMComment_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMComment_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMComment_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMComment_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMComment_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMComment_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMComment_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMComment_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMComment_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMComment_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMComment_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMComment_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMComment_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMComment_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMComment_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMComment_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMComment_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMComment_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMComment_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMComment_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMComment_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMComment_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMComment_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMComment_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMComment_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMComment_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMComment_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMComment_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMComment_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMComment_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMComment_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMComment_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMComment_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMComment_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMComment_get_data(This,data) (This)->lpVtbl->get_data(This,data)
#define IXMLDOMComment_put_data(This,data) (This)->lpVtbl->put_data(This,data)
#define IXMLDOMComment_get_length(This,dataLength) (This)->lpVtbl->get_length(This,dataLength)
#define IXMLDOMComment_substringData(This,offset,count,data) (This)->lpVtbl->substringData(This,offset,count,data)
#define IXMLDOMComment_appendData(This,data) (This)->lpVtbl->appendData(This,data)
#define IXMLDOMComment_insertData(This,offset,data) (This)->lpVtbl->insertData(This,offset,data)
#define IXMLDOMComment_deleteData(This,offset,count) (This)->lpVtbl->deleteData(This,offset,count)
#define IXMLDOMComment_replaceData(This,offset,count,data) (This)->lpVtbl->replaceData(This,offset,count,data)
#endif
#endif
#endif

#ifndef __IXMLDOMProcessingInstruction_INTERFACE_DEFINED__
#define __IXMLDOMProcessingInstruction_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMProcessingInstruction;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMProcessingInstruction : public IXMLDOMNode {
    public:
      virtual HRESULT WINAPI get_target(BSTR *name) = 0;
      virtual HRESULT WINAPI get_data(BSTR *value) = 0;
      virtual HRESULT WINAPI put_data(BSTR value) = 0;
    };
#else
    typedef struct IXMLDOMProcessingInstructionVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMProcessingInstruction *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMProcessingInstruction *This);
	ULONG (WINAPI *Release)(IXMLDOMProcessingInstruction *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMProcessingInstruction *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMProcessingInstruction *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMProcessingInstruction *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMProcessingInstruction *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMProcessingInstruction *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMProcessingInstruction *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMProcessingInstruction *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMProcessingInstruction *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMProcessingInstruction *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMProcessingInstruction *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMProcessingInstruction *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMProcessingInstruction *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMProcessingInstruction *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMProcessingInstruction *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMProcessingInstruction *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMProcessingInstruction *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMProcessingInstruction *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMProcessingInstruction *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMProcessingInstruction *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMProcessingInstruction *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMProcessingInstruction *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMProcessingInstruction *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMProcessingInstruction *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMProcessingInstruction *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMProcessingInstruction *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMProcessingInstruction *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMProcessingInstruction *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMProcessingInstruction *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMProcessingInstruction *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMProcessingInstruction *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMProcessingInstruction *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMProcessingInstruction *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMProcessingInstruction *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMProcessingInstruction *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMProcessingInstruction *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMProcessingInstruction *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMProcessingInstruction *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMProcessingInstruction *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMProcessingInstruction *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMProcessingInstruction *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_target)(IXMLDOMProcessingInstruction *This,BSTR *name);
	HRESULT (WINAPI *get_data)(IXMLDOMProcessingInstruction *This,BSTR *value);
	HRESULT (WINAPI *put_data)(IXMLDOMProcessingInstruction *This,BSTR value);
      END_INTERFACE
    } IXMLDOMProcessingInstructionVtbl;
    struct IXMLDOMProcessingInstruction {
      CONST_VTBL struct IXMLDOMProcessingInstructionVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMProcessingInstruction_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMProcessingInstruction_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMProcessingInstruction_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMProcessingInstruction_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMProcessingInstruction_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMProcessingInstruction_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMProcessingInstruction_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMProcessingInstruction_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMProcessingInstruction_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMProcessingInstruction_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMProcessingInstruction_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMProcessingInstruction_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMProcessingInstruction_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMProcessingInstruction_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMProcessingInstruction_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMProcessingInstruction_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMProcessingInstruction_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMProcessingInstruction_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMProcessingInstruction_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMProcessingInstruction_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMProcessingInstruction_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMProcessingInstruction_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMProcessingInstruction_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMProcessingInstruction_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMProcessingInstruction_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMProcessingInstruction_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMProcessingInstruction_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMProcessingInstruction_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMProcessingInstruction_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMProcessingInstruction_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMProcessingInstruction_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMProcessingInstruction_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMProcessingInstruction_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMProcessingInstruction_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMProcessingInstruction_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMProcessingInstruction_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMProcessingInstruction_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMProcessingInstruction_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMProcessingInstruction_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMProcessingInstruction_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMProcessingInstruction_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMProcessingInstruction_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMProcessingInstruction_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMProcessingInstruction_get_target(This,name) (This)->lpVtbl->get_target(This,name)
#define IXMLDOMProcessingInstruction_get_data(This,value) (This)->lpVtbl->get_data(This,value)
#define IXMLDOMProcessingInstruction_put_data(This,value) (This)->lpVtbl->put_data(This,value)
#endif
#endif
    HRESULT WINAPI IXMLDOMProcessingInstruction_get_target_Proxy(IXMLDOMProcessingInstruction *This,BSTR *name);
    void __RPC_STUB IXMLDOMProcessingInstruction_get_target_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMProcessingInstruction_get_data_Proxy(IXMLDOMProcessingInstruction *This,BSTR *value);
    void __RPC_STUB IXMLDOMProcessingInstruction_get_data_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMProcessingInstruction_put_data_Proxy(IXMLDOMProcessingInstruction *This,BSTR value);
    void __RPC_STUB IXMLDOMProcessingInstruction_put_data_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMCDATASection_INTERFACE_DEFINED__
#define __IXMLDOMCDATASection_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMCDATASection;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMCDATASection : public IXMLDOMText {
    };
#else
    typedef struct IXMLDOMCDATASectionVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMCDATASection *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMCDATASection *This);
	ULONG (WINAPI *Release)(IXMLDOMCDATASection *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMCDATASection *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMCDATASection *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMCDATASection *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMCDATASection *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMCDATASection *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMCDATASection *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMCDATASection *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMCDATASection *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMCDATASection *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMCDATASection *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMCDATASection *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMCDATASection *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMCDATASection *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMCDATASection *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMCDATASection *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMCDATASection *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMCDATASection *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMCDATASection *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMCDATASection *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMCDATASection *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMCDATASection *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMCDATASection *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMCDATASection *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMCDATASection *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMCDATASection *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMCDATASection *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMCDATASection *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMCDATASection *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMCDATASection *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMCDATASection *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMCDATASection *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMCDATASection *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMCDATASection *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMCDATASection *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMCDATASection *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMCDATASection *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMCDATASection *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMCDATASection *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMCDATASection *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMCDATASection *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_data)(IXMLDOMCDATASection *This,BSTR *data);
	HRESULT (WINAPI *put_data)(IXMLDOMCDATASection *This,BSTR data);
	HRESULT (WINAPI *get_length)(IXMLDOMCDATASection *This,long *dataLength);
	HRESULT (WINAPI *substringData)(IXMLDOMCDATASection *This,long offset,long count,BSTR *data);
	HRESULT (WINAPI *appendData)(IXMLDOMCDATASection *This,BSTR data);
	HRESULT (WINAPI *insertData)(IXMLDOMCDATASection *This,long offset,BSTR data);
	HRESULT (WINAPI *deleteData)(IXMLDOMCDATASection *This,long offset,long count);
	HRESULT (WINAPI *replaceData)(IXMLDOMCDATASection *This,long offset,long count,BSTR data);
	HRESULT (WINAPI *splitText)(IXMLDOMCDATASection *This,long offset,IXMLDOMText **rightHandTextNode);
      END_INTERFACE
    } IXMLDOMCDATASectionVtbl;
    struct IXMLDOMCDATASection {
      CONST_VTBL struct IXMLDOMCDATASectionVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMCDATASection_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMCDATASection_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMCDATASection_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMCDATASection_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMCDATASection_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMCDATASection_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMCDATASection_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMCDATASection_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMCDATASection_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMCDATASection_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMCDATASection_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMCDATASection_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMCDATASection_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMCDATASection_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMCDATASection_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMCDATASection_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMCDATASection_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMCDATASection_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMCDATASection_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMCDATASection_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMCDATASection_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMCDATASection_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMCDATASection_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMCDATASection_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMCDATASection_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMCDATASection_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMCDATASection_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMCDATASection_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMCDATASection_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMCDATASection_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMCDATASection_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMCDATASection_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMCDATASection_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMCDATASection_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMCDATASection_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMCDATASection_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMCDATASection_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMCDATASection_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMCDATASection_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMCDATASection_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMCDATASection_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMCDATASection_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMCDATASection_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMCDATASection_get_data(This,data) (This)->lpVtbl->get_data(This,data)
#define IXMLDOMCDATASection_put_data(This,data) (This)->lpVtbl->put_data(This,data)
#define IXMLDOMCDATASection_get_length(This,dataLength) (This)->lpVtbl->get_length(This,dataLength)
#define IXMLDOMCDATASection_substringData(This,offset,count,data) (This)->lpVtbl->substringData(This,offset,count,data)
#define IXMLDOMCDATASection_appendData(This,data) (This)->lpVtbl->appendData(This,data)
#define IXMLDOMCDATASection_insertData(This,offset,data) (This)->lpVtbl->insertData(This,offset,data)
#define IXMLDOMCDATASection_deleteData(This,offset,count) (This)->lpVtbl->deleteData(This,offset,count)
#define IXMLDOMCDATASection_replaceData(This,offset,count,data) (This)->lpVtbl->replaceData(This,offset,count,data)
#define IXMLDOMCDATASection_splitText(This,offset,rightHandTextNode) (This)->lpVtbl->splitText(This,offset,rightHandTextNode)
#endif
#endif
#endif

#ifndef __IXMLDOMDocumentType_INTERFACE_DEFINED__
#define __IXMLDOMDocumentType_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMDocumentType;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMDocumentType : public IXMLDOMNode {
    public:
      virtual HRESULT WINAPI get_name(BSTR *rootName) = 0;
      virtual HRESULT WINAPI get_entities(IXMLDOMNamedNodeMap **entityMap) = 0;
      virtual HRESULT WINAPI get_notations(IXMLDOMNamedNodeMap **notationMap) = 0;
    };
#else
    typedef struct IXMLDOMDocumentTypeVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMDocumentType *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMDocumentType *This);
	ULONG (WINAPI *Release)(IXMLDOMDocumentType *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMDocumentType *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMDocumentType *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMDocumentType *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMDocumentType *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMDocumentType *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMDocumentType *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMDocumentType *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMDocumentType *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMDocumentType *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMDocumentType *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMDocumentType *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMDocumentType *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMDocumentType *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMDocumentType *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMDocumentType *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMDocumentType *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMDocumentType *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMDocumentType *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMDocumentType *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMDocumentType *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMDocumentType *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMDocumentType *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMDocumentType *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMDocumentType *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMDocumentType *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMDocumentType *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMDocumentType *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMDocumentType *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMDocumentType *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMDocumentType *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMDocumentType *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMDocumentType *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMDocumentType *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMDocumentType *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMDocumentType *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMDocumentType *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMDocumentType *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMDocumentType *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMDocumentType *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMDocumentType *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_name)(IXMLDOMDocumentType *This,BSTR *rootName);
	HRESULT (WINAPI *get_entities)(IXMLDOMDocumentType *This,IXMLDOMNamedNodeMap **entityMap);
	HRESULT (WINAPI *get_notations)(IXMLDOMDocumentType *This,IXMLDOMNamedNodeMap **notationMap);
      END_INTERFACE
    } IXMLDOMDocumentTypeVtbl;
    struct IXMLDOMDocumentType {
      CONST_VTBL struct IXMLDOMDocumentTypeVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMDocumentType_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMDocumentType_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMDocumentType_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMDocumentType_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMDocumentType_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMDocumentType_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMDocumentType_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMDocumentType_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMDocumentType_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMDocumentType_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMDocumentType_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMDocumentType_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMDocumentType_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMDocumentType_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMDocumentType_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMDocumentType_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMDocumentType_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMDocumentType_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMDocumentType_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMDocumentType_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMDocumentType_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMDocumentType_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMDocumentType_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMDocumentType_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMDocumentType_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMDocumentType_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMDocumentType_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMDocumentType_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMDocumentType_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMDocumentType_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMDocumentType_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMDocumentType_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMDocumentType_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMDocumentType_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMDocumentType_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMDocumentType_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMDocumentType_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMDocumentType_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMDocumentType_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMDocumentType_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMDocumentType_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMDocumentType_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMDocumentType_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMDocumentType_get_name(This,rootName) (This)->lpVtbl->get_name(This,rootName)
#define IXMLDOMDocumentType_get_entities(This,entityMap) (This)->lpVtbl->get_entities(This,entityMap)
#define IXMLDOMDocumentType_get_notations(This,notationMap) (This)->lpVtbl->get_notations(This,notationMap)
#endif
#endif
    HRESULT WINAPI IXMLDOMDocumentType_get_name_Proxy(IXMLDOMDocumentType *This,BSTR *rootName);
    void __RPC_STUB IXMLDOMDocumentType_get_name_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocumentType_get_entities_Proxy(IXMLDOMDocumentType *This,IXMLDOMNamedNodeMap **entityMap);
    void __RPC_STUB IXMLDOMDocumentType_get_entities_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMDocumentType_get_notations_Proxy(IXMLDOMDocumentType *This,IXMLDOMNamedNodeMap **notationMap);
    void __RPC_STUB IXMLDOMDocumentType_get_notations_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMNotation_INTERFACE_DEFINED__
#define __IXMLDOMNotation_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMNotation;
#if defined(__cplusplus) && !defined(CINTERFACE)

    struct IXMLDOMNotation : public IXMLDOMNode {
    public:
      virtual HRESULT WINAPI get_publicId(VARIANT *publicID) = 0;
      virtual HRESULT WINAPI get_systemId(VARIANT *systemID) = 0;
    };
#else
    typedef struct IXMLDOMNotationVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMNotation *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMNotation *This);
	ULONG (WINAPI *Release)(IXMLDOMNotation *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMNotation *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMNotation *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMNotation *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMNotation *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMNotation *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMNotation *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMNotation *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMNotation *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMNotation *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMNotation *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMNotation *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMNotation *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMNotation *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMNotation *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMNotation *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMNotation *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMNotation *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMNotation *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMNotation *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMNotation *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMNotation *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMNotation *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMNotation *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMNotation *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMNotation *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMNotation *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMNotation *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMNotation *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMNotation *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMNotation *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMNotation *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMNotation *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMNotation *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMNotation *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMNotation *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMNotation *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMNotation *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMNotation *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMNotation *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMNotation *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_publicId)(IXMLDOMNotation *This,VARIANT *publicID);
	HRESULT (WINAPI *get_systemId)(IXMLDOMNotation *This,VARIANT *systemID);
      END_INTERFACE
    } IXMLDOMNotationVtbl;
    struct IXMLDOMNotation {
      CONST_VTBL struct IXMLDOMNotationVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMNotation_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMNotation_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMNotation_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMNotation_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMNotation_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMNotation_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMNotation_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMNotation_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMNotation_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMNotation_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMNotation_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMNotation_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMNotation_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMNotation_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMNotation_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMNotation_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMNotation_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMNotation_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMNotation_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMNotation_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMNotation_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMNotation_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMNotation_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMNotation_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMNotation_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMNotation_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMNotation_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMNotation_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMNotation_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMNotation_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMNotation_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMNotation_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMNotation_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMNotation_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMNotation_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMNotation_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMNotation_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMNotation_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMNotation_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMNotation_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMNotation_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMNotation_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMNotation_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMNotation_get_publicId(This,publicID) (This)->lpVtbl->get_publicId(This,publicID)
#define IXMLDOMNotation_get_systemId(This,systemID) (This)->lpVtbl->get_systemId(This,systemID)
#endif
#endif
    HRESULT WINAPI IXMLDOMNotation_get_publicId_Proxy(IXMLDOMNotation *This,VARIANT *publicID);
    void __RPC_STUB IXMLDOMNotation_get_publicId_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMNotation_get_systemId_Proxy(IXMLDOMNotation *This,VARIANT *systemID);
    void __RPC_STUB IXMLDOMNotation_get_systemId_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMEntity_INTERFACE_DEFINED__
#define __IXMLDOMEntity_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMEntity;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMEntity : public IXMLDOMNode {
    public:
      virtual HRESULT WINAPI get_publicId(VARIANT *publicID) = 0;
      virtual HRESULT WINAPI get_systemId(VARIANT *systemID) = 0;
      virtual HRESULT WINAPI get_notationName(BSTR *name) = 0;
    };
#else
    typedef struct IXMLDOMEntityVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMEntity *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMEntity *This);
	ULONG (WINAPI *Release)(IXMLDOMEntity *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMEntity *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMEntity *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMEntity *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMEntity *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMEntity *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMEntity *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMEntity *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMEntity *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMEntity *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMEntity *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMEntity *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMEntity *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMEntity *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMEntity *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMEntity *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMEntity *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMEntity *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMEntity *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMEntity *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMEntity *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMEntity *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMEntity *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMEntity *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMEntity *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMEntity *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMEntity *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMEntity *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMEntity *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMEntity *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMEntity *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMEntity *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMEntity *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMEntity *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMEntity *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMEntity *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMEntity *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMEntity *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMEntity *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMEntity *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMEntity *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *get_publicId)(IXMLDOMEntity *This,VARIANT *publicID);
	HRESULT (WINAPI *get_systemId)(IXMLDOMEntity *This,VARIANT *systemID);
	HRESULT (WINAPI *get_notationName)(IXMLDOMEntity *This,BSTR *name);
      END_INTERFACE
    } IXMLDOMEntityVtbl;
    struct IXMLDOMEntity {
      CONST_VTBL struct IXMLDOMEntityVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMEntity_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMEntity_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMEntity_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMEntity_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMEntity_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMEntity_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMEntity_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMEntity_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMEntity_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMEntity_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMEntity_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMEntity_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMEntity_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMEntity_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMEntity_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMEntity_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMEntity_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMEntity_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMEntity_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMEntity_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMEntity_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMEntity_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMEntity_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMEntity_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMEntity_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMEntity_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMEntity_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMEntity_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMEntity_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMEntity_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMEntity_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMEntity_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMEntity_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMEntity_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMEntity_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMEntity_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMEntity_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMEntity_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMEntity_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMEntity_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMEntity_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMEntity_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMEntity_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXMLDOMEntity_get_publicId(This,publicID) (This)->lpVtbl->get_publicId(This,publicID)
#define IXMLDOMEntity_get_systemId(This,systemID) (This)->lpVtbl->get_systemId(This,systemID)
#define IXMLDOMEntity_get_notationName(This,name) (This)->lpVtbl->get_notationName(This,name)
#endif
#endif
    HRESULT WINAPI IXMLDOMEntity_get_publicId_Proxy(IXMLDOMEntity *This,VARIANT *publicID);
    void __RPC_STUB IXMLDOMEntity_get_publicId_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMEntity_get_systemId_Proxy(IXMLDOMEntity *This,VARIANT *systemID);
    void __RPC_STUB IXMLDOMEntity_get_systemId_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMEntity_get_notationName_Proxy(IXMLDOMEntity *This,BSTR *name);
    void __RPC_STUB IXMLDOMEntity_get_notationName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMEntityReference_INTERFACE_DEFINED__
#define __IXMLDOMEntityReference_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMEntityReference;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMEntityReference : public IXMLDOMNode {
    };
#else
    typedef struct IXMLDOMEntityReferenceVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMEntityReference *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMEntityReference *This);
	ULONG (WINAPI *Release)(IXMLDOMEntityReference *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMEntityReference *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMEntityReference *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMEntityReference *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMEntityReference *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXMLDOMEntityReference *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXMLDOMEntityReference *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXMLDOMEntityReference *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXMLDOMEntityReference *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXMLDOMEntityReference *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXMLDOMEntityReference *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXMLDOMEntityReference *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXMLDOMEntityReference *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXMLDOMEntityReference *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXMLDOMEntityReference *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXMLDOMEntityReference *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXMLDOMEntityReference *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXMLDOMEntityReference *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXMLDOMEntityReference *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXMLDOMEntityReference *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXMLDOMEntityReference *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXMLDOMEntityReference *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXMLDOMEntityReference *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXMLDOMEntityReference *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXMLDOMEntityReference *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXMLDOMEntityReference *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXMLDOMEntityReference *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXMLDOMEntityReference *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXMLDOMEntityReference *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXMLDOMEntityReference *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXMLDOMEntityReference *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXMLDOMEntityReference *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXMLDOMEntityReference *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXMLDOMEntityReference *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXMLDOMEntityReference *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXMLDOMEntityReference *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXMLDOMEntityReference *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMEntityReference *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXMLDOMEntityReference *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXMLDOMEntityReference *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXMLDOMEntityReference *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
      END_INTERFACE
    } IXMLDOMEntityReferenceVtbl;
    struct IXMLDOMEntityReference {
      CONST_VTBL struct IXMLDOMEntityReferenceVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMEntityReference_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMEntityReference_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMEntityReference_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMEntityReference_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMEntityReference_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMEntityReference_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMEntityReference_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMEntityReference_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXMLDOMEntityReference_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXMLDOMEntityReference_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXMLDOMEntityReference_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXMLDOMEntityReference_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXMLDOMEntityReference_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXMLDOMEntityReference_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXMLDOMEntityReference_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXMLDOMEntityReference_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXMLDOMEntityReference_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXMLDOMEntityReference_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXMLDOMEntityReference_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXMLDOMEntityReference_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXMLDOMEntityReference_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXMLDOMEntityReference_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXMLDOMEntityReference_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXMLDOMEntityReference_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXMLDOMEntityReference_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXMLDOMEntityReference_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXMLDOMEntityReference_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXMLDOMEntityReference_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXMLDOMEntityReference_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXMLDOMEntityReference_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXMLDOMEntityReference_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXMLDOMEntityReference_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXMLDOMEntityReference_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXMLDOMEntityReference_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXMLDOMEntityReference_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXMLDOMEntityReference_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXMLDOMEntityReference_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXMLDOMEntityReference_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXMLDOMEntityReference_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXMLDOMEntityReference_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXMLDOMEntityReference_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXMLDOMEntityReference_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXMLDOMEntityReference_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#endif
#endif
#endif

#ifndef __IXMLDOMParseError_INTERFACE_DEFINED__
#define __IXMLDOMParseError_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMParseError;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMParseError : public IDispatch {
    public:
      virtual HRESULT WINAPI get_errorCode(long *errorCode) = 0;
      virtual HRESULT WINAPI get_url(BSTR *urlString) = 0;
      virtual HRESULT WINAPI get_reason(BSTR *reasonString) = 0;
      virtual HRESULT WINAPI get_srcText(BSTR *sourceString) = 0;
      virtual HRESULT WINAPI get_line(long *lineNumber) = 0;
      virtual HRESULT WINAPI get_linepos(long *linePosition) = 0;
      virtual HRESULT WINAPI get_filepos(long *filePosition) = 0;
    };
#else
    typedef struct IXMLDOMParseErrorVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMParseError *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMParseError *This);
	ULONG (WINAPI *Release)(IXMLDOMParseError *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMParseError *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMParseError *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMParseError *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMParseError *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_errorCode)(IXMLDOMParseError *This,long *errorCode);
	HRESULT (WINAPI *get_url)(IXMLDOMParseError *This,BSTR *urlString);
	HRESULT (WINAPI *get_reason)(IXMLDOMParseError *This,BSTR *reasonString);
	HRESULT (WINAPI *get_srcText)(IXMLDOMParseError *This,BSTR *sourceString);
	HRESULT (WINAPI *get_line)(IXMLDOMParseError *This,long *lineNumber);
	HRESULT (WINAPI *get_linepos)(IXMLDOMParseError *This,long *linePosition);
	HRESULT (WINAPI *get_filepos)(IXMLDOMParseError *This,long *filePosition);
      END_INTERFACE
    } IXMLDOMParseErrorVtbl;
    struct IXMLDOMParseError {
      CONST_VTBL struct IXMLDOMParseErrorVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMParseError_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMParseError_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMParseError_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMParseError_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMParseError_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMParseError_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMParseError_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMParseError_get_errorCode(This,errorCode) (This)->lpVtbl->get_errorCode(This,errorCode)
#define IXMLDOMParseError_get_url(This,urlString) (This)->lpVtbl->get_url(This,urlString)
#define IXMLDOMParseError_get_reason(This,reasonString) (This)->lpVtbl->get_reason(This,reasonString)
#define IXMLDOMParseError_get_srcText(This,sourceString) (This)->lpVtbl->get_srcText(This,sourceString)
#define IXMLDOMParseError_get_line(This,lineNumber) (This)->lpVtbl->get_line(This,lineNumber)
#define IXMLDOMParseError_get_linepos(This,linePosition) (This)->lpVtbl->get_linepos(This,linePosition)
#define IXMLDOMParseError_get_filepos(This,filePosition) (This)->lpVtbl->get_filepos(This,filePosition)
#endif
#endif
    HRESULT WINAPI IXMLDOMParseError_get_errorCode_Proxy(IXMLDOMParseError *This,long *errorCode);
    void __RPC_STUB IXMLDOMParseError_get_errorCode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMParseError_get_url_Proxy(IXMLDOMParseError *This,BSTR *urlString);
    void __RPC_STUB IXMLDOMParseError_get_url_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMParseError_get_reason_Proxy(IXMLDOMParseError *This,BSTR *reasonString);
    void __RPC_STUB IXMLDOMParseError_get_reason_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMParseError_get_srcText_Proxy(IXMLDOMParseError *This,BSTR *sourceString);
    void __RPC_STUB IXMLDOMParseError_get_srcText_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMParseError_get_line_Proxy(IXMLDOMParseError *This,long *lineNumber);
    void __RPC_STUB IXMLDOMParseError_get_line_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMParseError_get_linepos_Proxy(IXMLDOMParseError *This,long *linePosition);
    void __RPC_STUB IXMLDOMParseError_get_linepos_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMParseError_get_filepos_Proxy(IXMLDOMParseError *This,long *filePosition);
    void __RPC_STUB IXMLDOMParseError_get_filepos_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMSchemaCollection_INTERFACE_DEFINED__
#define __IXMLDOMSchemaCollection_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMSchemaCollection;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMSchemaCollection : public IDispatch {
    public:
      virtual HRESULT WINAPI add(BSTR namespaceURI,VARIANT var) = 0;
      virtual HRESULT WINAPI get(BSTR namespaceURI,IXMLDOMNode **schemaNode) = 0;
      virtual HRESULT WINAPI remove(BSTR namespaceURI) = 0;
      virtual HRESULT WINAPI get_length(long *length) = 0;
      virtual HRESULT WINAPI get_namespaceURI(long index,BSTR *length) = 0;
      virtual HRESULT WINAPI addCollection(IXMLDOMSchemaCollection *otherCollection) = 0;
      virtual HRESULT WINAPI get__newEnum(IUnknown **ppUnk) = 0;
    };
#else
    typedef struct IXMLDOMSchemaCollectionVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMSchemaCollection *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMSchemaCollection *This);
	ULONG (WINAPI *Release)(IXMLDOMSchemaCollection *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMSchemaCollection *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMSchemaCollection *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMSchemaCollection *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMSchemaCollection *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *add)(IXMLDOMSchemaCollection *This,BSTR namespaceURI,VARIANT var);
	HRESULT (WINAPI *get)(IXMLDOMSchemaCollection *This,BSTR namespaceURI,IXMLDOMNode **schemaNode);
	HRESULT (WINAPI *remove)(IXMLDOMSchemaCollection *This,BSTR namespaceURI);
	HRESULT (WINAPI *get_length)(IXMLDOMSchemaCollection *This,long *length);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMSchemaCollection *This,long index,BSTR *length);
	HRESULT (WINAPI *addCollection)(IXMLDOMSchemaCollection *This,IXMLDOMSchemaCollection *otherCollection);
	HRESULT (WINAPI *get__newEnum)(IXMLDOMSchemaCollection *This,IUnknown **ppUnk);
      END_INTERFACE
    } IXMLDOMSchemaCollectionVtbl;
    struct IXMLDOMSchemaCollection {
      CONST_VTBL struct IXMLDOMSchemaCollectionVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMSchemaCollection_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMSchemaCollection_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMSchemaCollection_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMSchemaCollection_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMSchemaCollection_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMSchemaCollection_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMSchemaCollection_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMSchemaCollection_add(This,namespaceURI,var) (This)->lpVtbl->add(This,namespaceURI,var)
#define IXMLDOMSchemaCollection_get(This,namespaceURI,schemaNode) (This)->lpVtbl->get(This,namespaceURI,schemaNode)
#define IXMLDOMSchemaCollection_remove(This,namespaceURI) (This)->lpVtbl->remove(This,namespaceURI)
#define IXMLDOMSchemaCollection_get_length(This,length) (This)->lpVtbl->get_length(This,length)
#define IXMLDOMSchemaCollection_get_namespaceURI(This,index,length) (This)->lpVtbl->get_namespaceURI(This,index,length)
#define IXMLDOMSchemaCollection_addCollection(This,otherCollection) (This)->lpVtbl->addCollection(This,otherCollection)
#define IXMLDOMSchemaCollection_get__newEnum(This,ppUnk) (This)->lpVtbl->get__newEnum(This,ppUnk)
#endif
#endif
    HRESULT WINAPI IXMLDOMSchemaCollection_add_Proxy(IXMLDOMSchemaCollection *This,BSTR namespaceURI,VARIANT var);
    void __RPC_STUB IXMLDOMSchemaCollection_add_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSchemaCollection_get_Proxy(IXMLDOMSchemaCollection *This,BSTR namespaceURI,IXMLDOMNode **schemaNode);
    void __RPC_STUB IXMLDOMSchemaCollection_get_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSchemaCollection_remove_Proxy(IXMLDOMSchemaCollection *This,BSTR namespaceURI);
    void __RPC_STUB IXMLDOMSchemaCollection_remove_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSchemaCollection_get_length_Proxy(IXMLDOMSchemaCollection *This,long *length);
    void __RPC_STUB IXMLDOMSchemaCollection_get_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSchemaCollection_get_namespaceURI_Proxy(IXMLDOMSchemaCollection *This,long index,BSTR *length);
    void __RPC_STUB IXMLDOMSchemaCollection_get_namespaceURI_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSchemaCollection_addCollection_Proxy(IXMLDOMSchemaCollection *This,IXMLDOMSchemaCollection *otherCollection);
    void __RPC_STUB IXMLDOMSchemaCollection_addCollection_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSchemaCollection_get__newEnum_Proxy(IXMLDOMSchemaCollection *This,IUnknown **ppUnk);
    void __RPC_STUB IXMLDOMSchemaCollection_get__newEnum_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXTLRuntime_INTERFACE_DEFINED__
#define __IXTLRuntime_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXTLRuntime;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXTLRuntime : public IXMLDOMNode {
    public:
      virtual HRESULT WINAPI uniqueID(IXMLDOMNode *pNode,long *pID) = 0;
      virtual HRESULT WINAPI depth(IXMLDOMNode *pNode,long *pDepth) = 0;
      virtual HRESULT WINAPI childNumber(IXMLDOMNode *pNode,long *pNumber) = 0;
      virtual HRESULT WINAPI ancestorChildNumber(BSTR bstrNodeName,IXMLDOMNode *pNode,long *pNumber) = 0;
      virtual HRESULT WINAPI absoluteChildNumber(IXMLDOMNode *pNode,long *pNumber) = 0;
      virtual HRESULT WINAPI formatIndex(long lIndex,BSTR bstrFormat,BSTR *pbstrFormattedString) = 0;
      virtual HRESULT WINAPI formatNumber(double dblNumber,BSTR bstrFormat,BSTR *pbstrFormattedString) = 0;
      virtual HRESULT WINAPI formatDate(VARIANT varDate,BSTR bstrFormat,VARIANT varDestLocale,BSTR *pbstrFormattedString) = 0;
      virtual HRESULT WINAPI formatTime(VARIANT varTime,BSTR bstrFormat,VARIANT varDestLocale,BSTR *pbstrFormattedString) = 0;
    };
#else
    typedef struct IXTLRuntimeVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXTLRuntime *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXTLRuntime *This);
	ULONG (WINAPI *Release)(IXTLRuntime *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXTLRuntime *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXTLRuntime *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXTLRuntime *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXTLRuntime *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_nodeName)(IXTLRuntime *This,BSTR *name);
	HRESULT (WINAPI *get_nodeValue)(IXTLRuntime *This,VARIANT *value);
	HRESULT (WINAPI *put_nodeValue)(IXTLRuntime *This,VARIANT value);
	HRESULT (WINAPI *get_nodeType)(IXTLRuntime *This,DOMNodeType *type);
	HRESULT (WINAPI *get_parentNode)(IXTLRuntime *This,IXMLDOMNode **parent);
	HRESULT (WINAPI *get_childNodes)(IXTLRuntime *This,IXMLDOMNodeList **childList);
	HRESULT (WINAPI *get_firstChild)(IXTLRuntime *This,IXMLDOMNode **firstChild);
	HRESULT (WINAPI *get_lastChild)(IXTLRuntime *This,IXMLDOMNode **lastChild);
	HRESULT (WINAPI *get_previousSibling)(IXTLRuntime *This,IXMLDOMNode **previousSibling);
	HRESULT (WINAPI *get_nextSibling)(IXTLRuntime *This,IXMLDOMNode **nextSibling);
	HRESULT (WINAPI *get_attributes)(IXTLRuntime *This,IXMLDOMNamedNodeMap **attributeMap);
	HRESULT (WINAPI *insertBefore)(IXTLRuntime *This,IXMLDOMNode *newChild,VARIANT refChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *replaceChild)(IXTLRuntime *This,IXMLDOMNode *newChild,IXMLDOMNode *oldChild,IXMLDOMNode **outOldChild);
	HRESULT (WINAPI *removeChild)(IXTLRuntime *This,IXMLDOMNode *childNode,IXMLDOMNode **oldChild);
	HRESULT (WINAPI *appendChild)(IXTLRuntime *This,IXMLDOMNode *newChild,IXMLDOMNode **outNewChild);
	HRESULT (WINAPI *hasChildNodes)(IXTLRuntime *This,VARIANT_BOOL *hasChild);
	HRESULT (WINAPI *get_ownerDocument)(IXTLRuntime *This,IXMLDOMDocument **DOMDocument);
	HRESULT (WINAPI *cloneNode)(IXTLRuntime *This,VARIANT_BOOL deep,IXMLDOMNode **cloneRoot);
	HRESULT (WINAPI *get_nodeTypeString)(IXTLRuntime *This,BSTR *nodeType);
	HRESULT (WINAPI *get_text)(IXTLRuntime *This,BSTR *text);
	HRESULT (WINAPI *put_text)(IXTLRuntime *This,BSTR text);
	HRESULT (WINAPI *get_specified)(IXTLRuntime *This,VARIANT_BOOL *isSpecified);
	HRESULT (WINAPI *get_definition)(IXTLRuntime *This,IXMLDOMNode **definitionNode);
	HRESULT (WINAPI *get_nodeTypedValue)(IXTLRuntime *This,VARIANT *typedValue);
	HRESULT (WINAPI *put_nodeTypedValue)(IXTLRuntime *This,VARIANT typedValue);
	HRESULT (WINAPI *get_dataType)(IXTLRuntime *This,VARIANT *dataTypeName);
	HRESULT (WINAPI *put_dataType)(IXTLRuntime *This,BSTR dataTypeName);
	HRESULT (WINAPI *get_xml)(IXTLRuntime *This,BSTR *xmlString);
	HRESULT (WINAPI *transformNode)(IXTLRuntime *This,IXMLDOMNode *stylesheet,BSTR *xmlString);
	HRESULT (WINAPI *selectNodes)(IXTLRuntime *This,BSTR queryString,IXMLDOMNodeList **resultList);
	HRESULT (WINAPI *selectSingleNode)(IXTLRuntime *This,BSTR queryString,IXMLDOMNode **resultNode);
	HRESULT (WINAPI *get_parsed)(IXTLRuntime *This,VARIANT_BOOL *isParsed);
	HRESULT (WINAPI *get_namespaceURI)(IXTLRuntime *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_prefix)(IXTLRuntime *This,BSTR *prefixString);
	HRESULT (WINAPI *get_baseName)(IXTLRuntime *This,BSTR *nameString);
	HRESULT (WINAPI *transformNodeToObject)(IXTLRuntime *This,IXMLDOMNode *stylesheet,VARIANT outputObject);
	HRESULT (WINAPI *uniqueID)(IXTLRuntime *This,IXMLDOMNode *pNode,long *pID);
	HRESULT (WINAPI *depth)(IXTLRuntime *This,IXMLDOMNode *pNode,long *pDepth);
	HRESULT (WINAPI *childNumber)(IXTLRuntime *This,IXMLDOMNode *pNode,long *pNumber);
	HRESULT (WINAPI *ancestorChildNumber)(IXTLRuntime *This,BSTR bstrNodeName,IXMLDOMNode *pNode,long *pNumber);
	HRESULT (WINAPI *absoluteChildNumber)(IXTLRuntime *This,IXMLDOMNode *pNode,long *pNumber);
	HRESULT (WINAPI *formatIndex)(IXTLRuntime *This,long lIndex,BSTR bstrFormat,BSTR *pbstrFormattedString);
	HRESULT (WINAPI *formatNumber)(IXTLRuntime *This,double dblNumber,BSTR bstrFormat,BSTR *pbstrFormattedString);
	HRESULT (WINAPI *formatDate)(IXTLRuntime *This,VARIANT varDate,BSTR bstrFormat,VARIANT varDestLocale,BSTR *pbstrFormattedString);
	HRESULT (WINAPI *formatTime)(IXTLRuntime *This,VARIANT varTime,BSTR bstrFormat,VARIANT varDestLocale,BSTR *pbstrFormattedString);
      END_INTERFACE
    } IXTLRuntimeVtbl;
    struct IXTLRuntime {
      CONST_VTBL struct IXTLRuntimeVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXTLRuntime_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXTLRuntime_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXTLRuntime_Release(This) (This)->lpVtbl->Release(This)
#define IXTLRuntime_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXTLRuntime_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXTLRuntime_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXTLRuntime_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXTLRuntime_get_nodeName(This,name) (This)->lpVtbl->get_nodeName(This,name)
#define IXTLRuntime_get_nodeValue(This,value) (This)->lpVtbl->get_nodeValue(This,value)
#define IXTLRuntime_put_nodeValue(This,value) (This)->lpVtbl->put_nodeValue(This,value)
#define IXTLRuntime_get_nodeType(This,type) (This)->lpVtbl->get_nodeType(This,type)
#define IXTLRuntime_get_parentNode(This,parent) (This)->lpVtbl->get_parentNode(This,parent)
#define IXTLRuntime_get_childNodes(This,childList) (This)->lpVtbl->get_childNodes(This,childList)
#define IXTLRuntime_get_firstChild(This,firstChild) (This)->lpVtbl->get_firstChild(This,firstChild)
#define IXTLRuntime_get_lastChild(This,lastChild) (This)->lpVtbl->get_lastChild(This,lastChild)
#define IXTLRuntime_get_previousSibling(This,previousSibling) (This)->lpVtbl->get_previousSibling(This,previousSibling)
#define IXTLRuntime_get_nextSibling(This,nextSibling) (This)->lpVtbl->get_nextSibling(This,nextSibling)
#define IXTLRuntime_get_attributes(This,attributeMap) (This)->lpVtbl->get_attributes(This,attributeMap)
#define IXTLRuntime_insertBefore(This,newChild,refChild,outNewChild) (This)->lpVtbl->insertBefore(This,newChild,refChild,outNewChild)
#define IXTLRuntime_replaceChild(This,newChild,oldChild,outOldChild) (This)->lpVtbl->replaceChild(This,newChild,oldChild,outOldChild)
#define IXTLRuntime_removeChild(This,childNode,oldChild) (This)->lpVtbl->removeChild(This,childNode,oldChild)
#define IXTLRuntime_appendChild(This,newChild,outNewChild) (This)->lpVtbl->appendChild(This,newChild,outNewChild)
#define IXTLRuntime_hasChildNodes(This,hasChild) (This)->lpVtbl->hasChildNodes(This,hasChild)
#define IXTLRuntime_get_ownerDocument(This,DOMDocument) (This)->lpVtbl->get_ownerDocument(This,DOMDocument)
#define IXTLRuntime_cloneNode(This,deep,cloneRoot) (This)->lpVtbl->cloneNode(This,deep,cloneRoot)
#define IXTLRuntime_get_nodeTypeString(This,nodeType) (This)->lpVtbl->get_nodeTypeString(This,nodeType)
#define IXTLRuntime_get_text(This,text) (This)->lpVtbl->get_text(This,text)
#define IXTLRuntime_put_text(This,text) (This)->lpVtbl->put_text(This,text)
#define IXTLRuntime_get_specified(This,isSpecified) (This)->lpVtbl->get_specified(This,isSpecified)
#define IXTLRuntime_get_definition(This,definitionNode) (This)->lpVtbl->get_definition(This,definitionNode)
#define IXTLRuntime_get_nodeTypedValue(This,typedValue) (This)->lpVtbl->get_nodeTypedValue(This,typedValue)
#define IXTLRuntime_put_nodeTypedValue(This,typedValue) (This)->lpVtbl->put_nodeTypedValue(This,typedValue)
#define IXTLRuntime_get_dataType(This,dataTypeName) (This)->lpVtbl->get_dataType(This,dataTypeName)
#define IXTLRuntime_put_dataType(This,dataTypeName) (This)->lpVtbl->put_dataType(This,dataTypeName)
#define IXTLRuntime_get_xml(This,xmlString) (This)->lpVtbl->get_xml(This,xmlString)
#define IXTLRuntime_transformNode(This,stylesheet,xmlString) (This)->lpVtbl->transformNode(This,stylesheet,xmlString)
#define IXTLRuntime_selectNodes(This,queryString,resultList) (This)->lpVtbl->selectNodes(This,queryString,resultList)
#define IXTLRuntime_selectSingleNode(This,queryString,resultNode) (This)->lpVtbl->selectSingleNode(This,queryString,resultNode)
#define IXTLRuntime_get_parsed(This,isParsed) (This)->lpVtbl->get_parsed(This,isParsed)
#define IXTLRuntime_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define IXTLRuntime_get_prefix(This,prefixString) (This)->lpVtbl->get_prefix(This,prefixString)
#define IXTLRuntime_get_baseName(This,nameString) (This)->lpVtbl->get_baseName(This,nameString)
#define IXTLRuntime_transformNodeToObject(This,stylesheet,outputObject) (This)->lpVtbl->transformNodeToObject(This,stylesheet,outputObject)
#define IXTLRuntime_uniqueID(This,pNode,pID) (This)->lpVtbl->uniqueID(This,pNode,pID)
#define IXTLRuntime_depth(This,pNode,pDepth) (This)->lpVtbl->depth(This,pNode,pDepth)
#define IXTLRuntime_childNumber(This,pNode,pNumber) (This)->lpVtbl->childNumber(This,pNode,pNumber)
#define IXTLRuntime_ancestorChildNumber(This,bstrNodeName,pNode,pNumber) (This)->lpVtbl->ancestorChildNumber(This,bstrNodeName,pNode,pNumber)
#define IXTLRuntime_absoluteChildNumber(This,pNode,pNumber) (This)->lpVtbl->absoluteChildNumber(This,pNode,pNumber)
#define IXTLRuntime_formatIndex(This,lIndex,bstrFormat,pbstrFormattedString) (This)->lpVtbl->formatIndex(This,lIndex,bstrFormat,pbstrFormattedString)
#define IXTLRuntime_formatNumber(This,dblNumber,bstrFormat,pbstrFormattedString) (This)->lpVtbl->formatNumber(This,dblNumber,bstrFormat,pbstrFormattedString)
#define IXTLRuntime_formatDate(This,varDate,bstrFormat,varDestLocale,pbstrFormattedString) (This)->lpVtbl->formatDate(This,varDate,bstrFormat,varDestLocale,pbstrFormattedString)
#define IXTLRuntime_formatTime(This,varTime,bstrFormat,varDestLocale,pbstrFormattedString) (This)->lpVtbl->formatTime(This,varTime,bstrFormat,varDestLocale,pbstrFormattedString)
#endif
#endif
    HRESULT WINAPI IXTLRuntime_uniqueID_Proxy(IXTLRuntime *This,IXMLDOMNode *pNode,long *pID);
    void __RPC_STUB IXTLRuntime_uniqueID_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXTLRuntime_depth_Proxy(IXTLRuntime *This,IXMLDOMNode *pNode,long *pDepth);
    void __RPC_STUB IXTLRuntime_depth_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXTLRuntime_childNumber_Proxy(IXTLRuntime *This,IXMLDOMNode *pNode,long *pNumber);
    void __RPC_STUB IXTLRuntime_childNumber_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXTLRuntime_ancestorChildNumber_Proxy(IXTLRuntime *This,BSTR bstrNodeName,IXMLDOMNode *pNode,long *pNumber);
    void __RPC_STUB IXTLRuntime_ancestorChildNumber_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXTLRuntime_absoluteChildNumber_Proxy(IXTLRuntime *This,IXMLDOMNode *pNode,long *pNumber);
    void __RPC_STUB IXTLRuntime_absoluteChildNumber_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXTLRuntime_formatIndex_Proxy(IXTLRuntime *This,long lIndex,BSTR bstrFormat,BSTR *pbstrFormattedString);
    void __RPC_STUB IXTLRuntime_formatIndex_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXTLRuntime_formatNumber_Proxy(IXTLRuntime *This,double dblNumber,BSTR bstrFormat,BSTR *pbstrFormattedString);
    void __RPC_STUB IXTLRuntime_formatNumber_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXTLRuntime_formatDate_Proxy(IXTLRuntime *This,VARIANT varDate,BSTR bstrFormat,VARIANT varDestLocale,BSTR *pbstrFormattedString);
    void __RPC_STUB IXTLRuntime_formatDate_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXTLRuntime_formatTime_Proxy(IXTLRuntime *This,VARIANT varTime,BSTR bstrFormat,VARIANT varDestLocale,BSTR *pbstrFormattedString);
    void __RPC_STUB IXTLRuntime_formatTime_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXSLTemplate_INTERFACE_DEFINED__
#define __IXSLTemplate_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXSLTemplate;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXSLTemplate : public IDispatch {
    public:
      virtual HRESULT WINAPI putref_stylesheet(IXMLDOMNode *stylesheet) = 0;
      virtual HRESULT WINAPI get_stylesheet(IXMLDOMNode **stylesheet) = 0;
      virtual HRESULT WINAPI createProcessor(IXSLProcessor **ppProcessor) = 0;
    };
#else
    typedef struct IXSLTemplateVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXSLTemplate *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXSLTemplate *This);
	ULONG (WINAPI *Release)(IXSLTemplate *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXSLTemplate *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXSLTemplate *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXSLTemplate *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXSLTemplate *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *putref_stylesheet)(IXSLTemplate *This,IXMLDOMNode *stylesheet);
	HRESULT (WINAPI *get_stylesheet)(IXSLTemplate *This,IXMLDOMNode **stylesheet);
	HRESULT (WINAPI *createProcessor)(IXSLTemplate *This,IXSLProcessor **ppProcessor);
      END_INTERFACE
    } IXSLTemplateVtbl;
    struct IXSLTemplate {
      CONST_VTBL struct IXSLTemplateVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXSLTemplate_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXSLTemplate_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXSLTemplate_Release(This) (This)->lpVtbl->Release(This)
#define IXSLTemplate_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXSLTemplate_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXSLTemplate_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXSLTemplate_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXSLTemplate_putref_stylesheet(This,stylesheet) (This)->lpVtbl->putref_stylesheet(This,stylesheet)
#define IXSLTemplate_get_stylesheet(This,stylesheet) (This)->lpVtbl->get_stylesheet(This,stylesheet)
#define IXSLTemplate_createProcessor(This,ppProcessor) (This)->lpVtbl->createProcessor(This,ppProcessor)
#endif
#endif
    HRESULT WINAPI IXSLTemplate_putref_stylesheet_Proxy(IXSLTemplate *This,IXMLDOMNode *stylesheet);
    void __RPC_STUB IXSLTemplate_putref_stylesheet_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLTemplate_get_stylesheet_Proxy(IXSLTemplate *This,IXMLDOMNode **stylesheet);
    void __RPC_STUB IXSLTemplate_get_stylesheet_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLTemplate_createProcessor_Proxy(IXSLTemplate *This,IXSLProcessor **ppProcessor);
    void __RPC_STUB IXSLTemplate_createProcessor_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXSLProcessor_INTERFACE_DEFINED__
#define __IXSLProcessor_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXSLProcessor;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXSLProcessor : public IDispatch {
    public:
      virtual HRESULT WINAPI put_input(VARIANT var) = 0;
      virtual HRESULT WINAPI get_input(VARIANT *pVar) = 0;
      virtual HRESULT WINAPI get_ownerTemplate(IXSLTemplate **ppTemplate) = 0;
      virtual HRESULT WINAPI setStartMode(BSTR mode,BSTR namespaceURI = L"") = 0;
      virtual HRESULT WINAPI get_startMode(BSTR *mode) = 0;
      virtual HRESULT WINAPI get_startModeURI(BSTR *namespaceURI) = 0;
      virtual HRESULT WINAPI put_output(VARIANT output) = 0;
      virtual HRESULT WINAPI get_output(VARIANT *pOutput) = 0;
      virtual HRESULT WINAPI transform(VARIANT_BOOL *pDone) = 0;
      virtual HRESULT WINAPI reset(void) = 0;
      virtual HRESULT WINAPI get_readyState(long *pReadyState) = 0;
      virtual HRESULT WINAPI addParameter(BSTR baseName,VARIANT parameter,BSTR namespaceURI = L"") = 0;
      virtual HRESULT WINAPI addObject(IDispatch *obj,BSTR namespaceURI) = 0;
      virtual HRESULT WINAPI get_stylesheet(IXMLDOMNode **stylesheet) = 0;
    };
#else
    typedef struct IXSLProcessorVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXSLProcessor *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXSLProcessor *This);
	ULONG (WINAPI *Release)(IXSLProcessor *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXSLProcessor *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXSLProcessor *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXSLProcessor *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXSLProcessor *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *put_input)(IXSLProcessor *This,VARIANT var);
	HRESULT (WINAPI *get_input)(IXSLProcessor *This,VARIANT *pVar);
	HRESULT (WINAPI *get_ownerTemplate)(IXSLProcessor *This,IXSLTemplate **ppTemplate);
	HRESULT (WINAPI *setStartMode)(IXSLProcessor *This,BSTR mode,BSTR namespaceURI);
	HRESULT (WINAPI *get_startMode)(IXSLProcessor *This,BSTR *mode);
	HRESULT (WINAPI *get_startModeURI)(IXSLProcessor *This,BSTR *namespaceURI);
	HRESULT (WINAPI *put_output)(IXSLProcessor *This,VARIANT output);
	HRESULT (WINAPI *get_output)(IXSLProcessor *This,VARIANT *pOutput);
	HRESULT (WINAPI *transform)(IXSLProcessor *This,VARIANT_BOOL *pDone);
	HRESULT (WINAPI *reset)(IXSLProcessor *This);
	HRESULT (WINAPI *get_readyState)(IXSLProcessor *This,long *pReadyState);
	HRESULT (WINAPI *addParameter)(IXSLProcessor *This,BSTR baseName,VARIANT parameter,BSTR namespaceURI);
	HRESULT (WINAPI *addObject)(IXSLProcessor *This,IDispatch *obj,BSTR namespaceURI);
	HRESULT (WINAPI *get_stylesheet)(IXSLProcessor *This,IXMLDOMNode **stylesheet);
      END_INTERFACE
    } IXSLProcessorVtbl;
    struct IXSLProcessor {
      CONST_VTBL struct IXSLProcessorVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXSLProcessor_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXSLProcessor_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXSLProcessor_Release(This) (This)->lpVtbl->Release(This)
#define IXSLProcessor_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXSLProcessor_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXSLProcessor_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXSLProcessor_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXSLProcessor_put_input(This,var) (This)->lpVtbl->put_input(This,var)
#define IXSLProcessor_get_input(This,pVar) (This)->lpVtbl->get_input(This,pVar)
#define IXSLProcessor_get_ownerTemplate(This,ppTemplate) (This)->lpVtbl->get_ownerTemplate(This,ppTemplate)
#define IXSLProcessor_setStartMode(This,mode,namespaceURI) (This)->lpVtbl->setStartMode(This,mode,namespaceURI)
#define IXSLProcessor_get_startMode(This,mode) (This)->lpVtbl->get_startMode(This,mode)
#define IXSLProcessor_get_startModeURI(This,namespaceURI) (This)->lpVtbl->get_startModeURI(This,namespaceURI)
#define IXSLProcessor_put_output(This,output) (This)->lpVtbl->put_output(This,output)
#define IXSLProcessor_get_output(This,pOutput) (This)->lpVtbl->get_output(This,pOutput)
#define IXSLProcessor_transform(This,pDone) (This)->lpVtbl->transform(This,pDone)
#define IXSLProcessor_reset(This) (This)->lpVtbl->reset(This)
#define IXSLProcessor_get_readyState(This,pReadyState) (This)->lpVtbl->get_readyState(This,pReadyState)
#define IXSLProcessor_addParameter(This,baseName,parameter,namespaceURI) (This)->lpVtbl->addParameter(This,baseName,parameter,namespaceURI)
#define IXSLProcessor_addObject(This,obj,namespaceURI) (This)->lpVtbl->addObject(This,obj,namespaceURI)
#define IXSLProcessor_get_stylesheet(This,stylesheet) (This)->lpVtbl->get_stylesheet(This,stylesheet)
#endif
#endif
    HRESULT WINAPI IXSLProcessor_put_input_Proxy(IXSLProcessor *This,VARIANT var);
    void __RPC_STUB IXSLProcessor_put_input_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_get_input_Proxy(IXSLProcessor *This,VARIANT *pVar);
    void __RPC_STUB IXSLProcessor_get_input_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_get_ownerTemplate_Proxy(IXSLProcessor *This,IXSLTemplate **ppTemplate);
    void __RPC_STUB IXSLProcessor_get_ownerTemplate_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_setStartMode_Proxy(IXSLProcessor *This,BSTR mode,BSTR namespaceURI);
    void __RPC_STUB IXSLProcessor_setStartMode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_get_startMode_Proxy(IXSLProcessor *This,BSTR *mode);
    void __RPC_STUB IXSLProcessor_get_startMode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_get_startModeURI_Proxy(IXSLProcessor *This,BSTR *namespaceURI);
    void __RPC_STUB IXSLProcessor_get_startModeURI_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_put_output_Proxy(IXSLProcessor *This,VARIANT output);
    void __RPC_STUB IXSLProcessor_put_output_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_get_output_Proxy(IXSLProcessor *This,VARIANT *pOutput);
    void __RPC_STUB IXSLProcessor_get_output_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_transform_Proxy(IXSLProcessor *This,VARIANT_BOOL *pDone);
    void __RPC_STUB IXSLProcessor_transform_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_reset_Proxy(IXSLProcessor *This);
    void __RPC_STUB IXSLProcessor_reset_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_get_readyState_Proxy(IXSLProcessor *This,long *pReadyState);
    void __RPC_STUB IXSLProcessor_get_readyState_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_addParameter_Proxy(IXSLProcessor *This,BSTR baseName,VARIANT parameter,BSTR namespaceURI);
    void __RPC_STUB IXSLProcessor_addParameter_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_addObject_Proxy(IXSLProcessor *This,IDispatch *obj,BSTR namespaceURI);
    void __RPC_STUB IXSLProcessor_addObject_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXSLProcessor_get_stylesheet_Proxy(IXSLProcessor *This,IXMLDOMNode **stylesheet);
    void __RPC_STUB IXSLProcessor_get_stylesheet_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISAXXMLReader_INTERFACE_DEFINED__
#define __ISAXXMLReader_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISAXXMLReader;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISAXXMLReader : public IUnknown {
    public:
      virtual HRESULT WINAPI getFeature(const wchar_t *pwchName,VARIANT_BOOL *pvfValue) = 0;
      virtual HRESULT WINAPI putFeature(const wchar_t *pwchName,VARIANT_BOOL vfValue) = 0;
      virtual HRESULT WINAPI getProperty(const wchar_t *pwchName,VARIANT *pvarValue) = 0;
      virtual HRESULT WINAPI putProperty(const wchar_t *pwchName,VARIANT varValue) = 0;
      virtual HRESULT WINAPI getEntityResolver(ISAXEntityResolver **ppResolver) = 0;
      virtual HRESULT WINAPI putEntityResolver(ISAXEntityResolver *pResolver) = 0;
      virtual HRESULT WINAPI getContentHandler(ISAXContentHandler **ppHandler) = 0;
      virtual HRESULT WINAPI putContentHandler(ISAXContentHandler *pHandler) = 0;
      virtual HRESULT WINAPI getDTDHandler(ISAXDTDHandler **ppHandler) = 0;
      virtual HRESULT WINAPI putDTDHandler(ISAXDTDHandler *pHandler) = 0;
      virtual HRESULT WINAPI getErrorHandler(ISAXErrorHandler **ppHandler) = 0;
      virtual HRESULT WINAPI putErrorHandler(ISAXErrorHandler *pHandler) = 0;
      virtual HRESULT WINAPI getBaseURL(const wchar_t **ppwchBaseUrl) = 0;
      virtual HRESULT WINAPI putBaseURL(const wchar_t *pwchBaseUrl) = 0;
      virtual HRESULT WINAPI getSecureBaseURL(const wchar_t **ppwchSecureBaseUrl) = 0;
      virtual HRESULT WINAPI putSecureBaseURL(const wchar_t *pwchSecureBaseUrl) = 0;
      virtual HRESULT WINAPI parse(VARIANT varInput) = 0;
      virtual HRESULT WINAPI parseURL(const wchar_t *pwchUrl) = 0;
    };
#else
    typedef struct ISAXXMLReaderVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISAXXMLReader *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISAXXMLReader *This);
	ULONG (WINAPI *Release)(ISAXXMLReader *This);
	HRESULT (WINAPI *getFeature)(ISAXXMLReader *This,const wchar_t *pwchName,VARIANT_BOOL *pvfValue);
	HRESULT (WINAPI *putFeature)(ISAXXMLReader *This,const wchar_t *pwchName,VARIANT_BOOL vfValue);
	HRESULT (WINAPI *getProperty)(ISAXXMLReader *This,const wchar_t *pwchName,VARIANT *pvarValue);
	HRESULT (WINAPI *putProperty)(ISAXXMLReader *This,const wchar_t *pwchName,VARIANT varValue);
	HRESULT (WINAPI *getEntityResolver)(ISAXXMLReader *This,ISAXEntityResolver **ppResolver);
	HRESULT (WINAPI *putEntityResolver)(ISAXXMLReader *This,ISAXEntityResolver *pResolver);
	HRESULT (WINAPI *getContentHandler)(ISAXXMLReader *This,ISAXContentHandler **ppHandler);
	HRESULT (WINAPI *putContentHandler)(ISAXXMLReader *This,ISAXContentHandler *pHandler);
	HRESULT (WINAPI *getDTDHandler)(ISAXXMLReader *This,ISAXDTDHandler **ppHandler);
	HRESULT (WINAPI *putDTDHandler)(ISAXXMLReader *This,ISAXDTDHandler *pHandler);
	HRESULT (WINAPI *getErrorHandler)(ISAXXMLReader *This,ISAXErrorHandler **ppHandler);
	HRESULT (WINAPI *putErrorHandler)(ISAXXMLReader *This,ISAXErrorHandler *pHandler);
	HRESULT (WINAPI *getBaseURL)(ISAXXMLReader *This,const wchar_t **ppwchBaseUrl);
	HRESULT (WINAPI *putBaseURL)(ISAXXMLReader *This,const wchar_t *pwchBaseUrl);
	HRESULT (WINAPI *getSecureBaseURL)(ISAXXMLReader *This,const wchar_t **ppwchSecureBaseUrl);
	HRESULT (WINAPI *putSecureBaseURL)(ISAXXMLReader *This,const wchar_t *pwchSecureBaseUrl);
	HRESULT (WINAPI *parse)(ISAXXMLReader *This,VARIANT varInput);
	HRESULT (WINAPI *parseURL)(ISAXXMLReader *This,const wchar_t *pwchUrl);
      END_INTERFACE
    } ISAXXMLReaderVtbl;
    struct ISAXXMLReader {
      CONST_VTBL struct ISAXXMLReaderVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISAXXMLReader_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISAXXMLReader_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISAXXMLReader_Release(This) (This)->lpVtbl->Release(This)
#define ISAXXMLReader_getFeature(This,pwchName,pvfValue) (This)->lpVtbl->getFeature(This,pwchName,pvfValue)
#define ISAXXMLReader_putFeature(This,pwchName,vfValue) (This)->lpVtbl->putFeature(This,pwchName,vfValue)
#define ISAXXMLReader_getProperty(This,pwchName,pvarValue) (This)->lpVtbl->getProperty(This,pwchName,pvarValue)
#define ISAXXMLReader_putProperty(This,pwchName,varValue) (This)->lpVtbl->putProperty(This,pwchName,varValue)
#define ISAXXMLReader_getEntityResolver(This,ppResolver) (This)->lpVtbl->getEntityResolver(This,ppResolver)
#define ISAXXMLReader_putEntityResolver(This,pResolver) (This)->lpVtbl->putEntityResolver(This,pResolver)
#define ISAXXMLReader_getContentHandler(This,ppHandler) (This)->lpVtbl->getContentHandler(This,ppHandler)
#define ISAXXMLReader_putContentHandler(This,pHandler) (This)->lpVtbl->putContentHandler(This,pHandler)
#define ISAXXMLReader_getDTDHandler(This,ppHandler) (This)->lpVtbl->getDTDHandler(This,ppHandler)
#define ISAXXMLReader_putDTDHandler(This,pHandler) (This)->lpVtbl->putDTDHandler(This,pHandler)
#define ISAXXMLReader_getErrorHandler(This,ppHandler) (This)->lpVtbl->getErrorHandler(This,ppHandler)
#define ISAXXMLReader_putErrorHandler(This,pHandler) (This)->lpVtbl->putErrorHandler(This,pHandler)
#define ISAXXMLReader_getBaseURL(This,ppwchBaseUrl) (This)->lpVtbl->getBaseURL(This,ppwchBaseUrl)
#define ISAXXMLReader_putBaseURL(This,pwchBaseUrl) (This)->lpVtbl->putBaseURL(This,pwchBaseUrl)
#define ISAXXMLReader_getSecureBaseURL(This,ppwchSecureBaseUrl) (This)->lpVtbl->getSecureBaseURL(This,ppwchSecureBaseUrl)
#define ISAXXMLReader_putSecureBaseURL(This,pwchSecureBaseUrl) (This)->lpVtbl->putSecureBaseURL(This,pwchSecureBaseUrl)
#define ISAXXMLReader_parse(This,varInput) (This)->lpVtbl->parse(This,varInput)
#define ISAXXMLReader_parseURL(This,pwchUrl) (This)->lpVtbl->parseURL(This,pwchUrl)
#endif
#endif
    HRESULT WINAPI ISAXXMLReader_getFeature_Proxy(ISAXXMLReader *This,const wchar_t *pwchName,VARIANT_BOOL *pvfValue);
    void __RPC_STUB ISAXXMLReader_getFeature_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_putFeature_Proxy(ISAXXMLReader *This,const wchar_t *pwchName,VARIANT_BOOL vfValue);
    void __RPC_STUB ISAXXMLReader_putFeature_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_getProperty_Proxy(ISAXXMLReader *This,const wchar_t *pwchName,VARIANT *pvarValue);
    void __RPC_STUB ISAXXMLReader_getProperty_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_putProperty_Proxy(ISAXXMLReader *This,const wchar_t *pwchName,VARIANT varValue);
    void __RPC_STUB ISAXXMLReader_putProperty_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_getEntityResolver_Proxy(ISAXXMLReader *This,ISAXEntityResolver **ppResolver);
    void __RPC_STUB ISAXXMLReader_getEntityResolver_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_putEntityResolver_Proxy(ISAXXMLReader *This,ISAXEntityResolver *pResolver);
    void __RPC_STUB ISAXXMLReader_putEntityResolver_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_getContentHandler_Proxy(ISAXXMLReader *This,ISAXContentHandler **ppHandler);
    void __RPC_STUB ISAXXMLReader_getContentHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_putContentHandler_Proxy(ISAXXMLReader *This,ISAXContentHandler *pHandler);
    void __RPC_STUB ISAXXMLReader_putContentHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_getDTDHandler_Proxy(ISAXXMLReader *This,ISAXDTDHandler **ppHandler);
    void __RPC_STUB ISAXXMLReader_getDTDHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_putDTDHandler_Proxy(ISAXXMLReader *This,ISAXDTDHandler *pHandler);
    void __RPC_STUB ISAXXMLReader_putDTDHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_getErrorHandler_Proxy(ISAXXMLReader *This,ISAXErrorHandler **ppHandler);
    void __RPC_STUB ISAXXMLReader_getErrorHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_putErrorHandler_Proxy(ISAXXMLReader *This,ISAXErrorHandler *pHandler);
    void __RPC_STUB ISAXXMLReader_putErrorHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_getBaseURL_Proxy(ISAXXMLReader *This,const wchar_t **ppwchBaseUrl);
    void __RPC_STUB ISAXXMLReader_getBaseURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_putBaseURL_Proxy(ISAXXMLReader *This,const wchar_t *pwchBaseUrl);
    void __RPC_STUB ISAXXMLReader_putBaseURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_getSecureBaseURL_Proxy(ISAXXMLReader *This,const wchar_t **ppwchSecureBaseUrl);
    void __RPC_STUB ISAXXMLReader_getSecureBaseURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_putSecureBaseURL_Proxy(ISAXXMLReader *This,const wchar_t *pwchSecureBaseUrl);
    void __RPC_STUB ISAXXMLReader_putSecureBaseURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_parse_Proxy(ISAXXMLReader *This,VARIANT varInput);
    void __RPC_STUB ISAXXMLReader_parse_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLReader_parseURL_Proxy(ISAXXMLReader *This,const wchar_t *pwchUrl);
    void __RPC_STUB ISAXXMLReader_parseURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISAXXMLFilter_INTERFACE_DEFINED__
#define __ISAXXMLFilter_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISAXXMLFilter;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISAXXMLFilter : public ISAXXMLReader {
    public:
      virtual HRESULT WINAPI getParent(ISAXXMLReader **ppReader) = 0;
      virtual HRESULT WINAPI putParent(ISAXXMLReader *pReader) = 0;
    };
#else
    typedef struct ISAXXMLFilterVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISAXXMLFilter *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISAXXMLFilter *This);
	ULONG (WINAPI *Release)(ISAXXMLFilter *This);
	HRESULT (WINAPI *getFeature)(ISAXXMLFilter *This,const wchar_t *pwchName,VARIANT_BOOL *pvfValue);
	HRESULT (WINAPI *putFeature)(ISAXXMLFilter *This,const wchar_t *pwchName,VARIANT_BOOL vfValue);
	HRESULT (WINAPI *getProperty)(ISAXXMLFilter *This,const wchar_t *pwchName,VARIANT *pvarValue);
	HRESULT (WINAPI *putProperty)(ISAXXMLFilter *This,const wchar_t *pwchName,VARIANT varValue);
	HRESULT (WINAPI *getEntityResolver)(ISAXXMLFilter *This,ISAXEntityResolver **ppResolver);
	HRESULT (WINAPI *putEntityResolver)(ISAXXMLFilter *This,ISAXEntityResolver *pResolver);
	HRESULT (WINAPI *getContentHandler)(ISAXXMLFilter *This,ISAXContentHandler **ppHandler);
	HRESULT (WINAPI *putContentHandler)(ISAXXMLFilter *This,ISAXContentHandler *pHandler);
	HRESULT (WINAPI *getDTDHandler)(ISAXXMLFilter *This,ISAXDTDHandler **ppHandler);
	HRESULT (WINAPI *putDTDHandler)(ISAXXMLFilter *This,ISAXDTDHandler *pHandler);
	HRESULT (WINAPI *getErrorHandler)(ISAXXMLFilter *This,ISAXErrorHandler **ppHandler);
	HRESULT (WINAPI *putErrorHandler)(ISAXXMLFilter *This,ISAXErrorHandler *pHandler);
	HRESULT (WINAPI *getBaseURL)(ISAXXMLFilter *This,const wchar_t **ppwchBaseUrl);
	HRESULT (WINAPI *putBaseURL)(ISAXXMLFilter *This,const wchar_t *pwchBaseUrl);
	HRESULT (WINAPI *getSecureBaseURL)(ISAXXMLFilter *This,const wchar_t **ppwchSecureBaseUrl);
	HRESULT (WINAPI *putSecureBaseURL)(ISAXXMLFilter *This,const wchar_t *pwchSecureBaseUrl);
	HRESULT (WINAPI *parse)(ISAXXMLFilter *This,VARIANT varInput);
	HRESULT (WINAPI *parseURL)(ISAXXMLFilter *This,const wchar_t *pwchUrl);
	HRESULT (WINAPI *getParent)(ISAXXMLFilter *This,ISAXXMLReader **ppReader);
	HRESULT (WINAPI *putParent)(ISAXXMLFilter *This,ISAXXMLReader *pReader);
      END_INTERFACE
    } ISAXXMLFilterVtbl;
    struct ISAXXMLFilter {
      CONST_VTBL struct ISAXXMLFilterVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISAXXMLFilter_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISAXXMLFilter_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISAXXMLFilter_Release(This) (This)->lpVtbl->Release(This)
#define ISAXXMLFilter_getFeature(This,pwchName,pvfValue) (This)->lpVtbl->getFeature(This,pwchName,pvfValue)
#define ISAXXMLFilter_putFeature(This,pwchName,vfValue) (This)->lpVtbl->putFeature(This,pwchName,vfValue)
#define ISAXXMLFilter_getProperty(This,pwchName,pvarValue) (This)->lpVtbl->getProperty(This,pwchName,pvarValue)
#define ISAXXMLFilter_putProperty(This,pwchName,varValue) (This)->lpVtbl->putProperty(This,pwchName,varValue)
#define ISAXXMLFilter_getEntityResolver(This,ppResolver) (This)->lpVtbl->getEntityResolver(This,ppResolver)
#define ISAXXMLFilter_putEntityResolver(This,pResolver) (This)->lpVtbl->putEntityResolver(This,pResolver)
#define ISAXXMLFilter_getContentHandler(This,ppHandler) (This)->lpVtbl->getContentHandler(This,ppHandler)
#define ISAXXMLFilter_putContentHandler(This,pHandler) (This)->lpVtbl->putContentHandler(This,pHandler)
#define ISAXXMLFilter_getDTDHandler(This,ppHandler) (This)->lpVtbl->getDTDHandler(This,ppHandler)
#define ISAXXMLFilter_putDTDHandler(This,pHandler) (This)->lpVtbl->putDTDHandler(This,pHandler)
#define ISAXXMLFilter_getErrorHandler(This,ppHandler) (This)->lpVtbl->getErrorHandler(This,ppHandler)
#define ISAXXMLFilter_putErrorHandler(This,pHandler) (This)->lpVtbl->putErrorHandler(This,pHandler)
#define ISAXXMLFilter_getBaseURL(This,ppwchBaseUrl) (This)->lpVtbl->getBaseURL(This,ppwchBaseUrl)
#define ISAXXMLFilter_putBaseURL(This,pwchBaseUrl) (This)->lpVtbl->putBaseURL(This,pwchBaseUrl)
#define ISAXXMLFilter_getSecureBaseURL(This,ppwchSecureBaseUrl) (This)->lpVtbl->getSecureBaseURL(This,ppwchSecureBaseUrl)
#define ISAXXMLFilter_putSecureBaseURL(This,pwchSecureBaseUrl) (This)->lpVtbl->putSecureBaseURL(This,pwchSecureBaseUrl)
#define ISAXXMLFilter_parse(This,varInput) (This)->lpVtbl->parse(This,varInput)
#define ISAXXMLFilter_parseURL(This,pwchUrl) (This)->lpVtbl->parseURL(This,pwchUrl)
#define ISAXXMLFilter_getParent(This,ppReader) (This)->lpVtbl->getParent(This,ppReader)
#define ISAXXMLFilter_putParent(This,pReader) (This)->lpVtbl->putParent(This,pReader)
#endif
#endif
    HRESULT WINAPI ISAXXMLFilter_getParent_Proxy(ISAXXMLFilter *This,ISAXXMLReader **ppReader);
    void __RPC_STUB ISAXXMLFilter_getParent_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXXMLFilter_putParent_Proxy(ISAXXMLFilter *This,ISAXXMLReader *pReader);
    void __RPC_STUB ISAXXMLFilter_putParent_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISAXLocator_INTERFACE_DEFINED__
#define __ISAXLocator_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISAXLocator;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISAXLocator : public IUnknown {
    public:
      virtual HRESULT WINAPI getColumnNumber(int *pnColumn) = 0;
      virtual HRESULT WINAPI getLineNumber(int *pnLine) = 0;
      virtual HRESULT WINAPI getPublicId(const wchar_t **ppwchPublicId) = 0;
      virtual HRESULT WINAPI getSystemId(const wchar_t **ppwchSystemId) = 0;
    };
#else
    typedef struct ISAXLocatorVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISAXLocator *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISAXLocator *This);
	ULONG (WINAPI *Release)(ISAXLocator *This);
	HRESULT (WINAPI *getColumnNumber)(ISAXLocator *This,int *pnColumn);
	HRESULT (WINAPI *getLineNumber)(ISAXLocator *This,int *pnLine);
	HRESULT (WINAPI *getPublicId)(ISAXLocator *This,const wchar_t **ppwchPublicId);
	HRESULT (WINAPI *getSystemId)(ISAXLocator *This,const wchar_t **ppwchSystemId);
      END_INTERFACE
    } ISAXLocatorVtbl;
    struct ISAXLocator {
      CONST_VTBL struct ISAXLocatorVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISAXLocator_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISAXLocator_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISAXLocator_Release(This) (This)->lpVtbl->Release(This)
#define ISAXLocator_getColumnNumber(This,pnColumn) (This)->lpVtbl->getColumnNumber(This,pnColumn)
#define ISAXLocator_getLineNumber(This,pnLine) (This)->lpVtbl->getLineNumber(This,pnLine)
#define ISAXLocator_getPublicId(This,ppwchPublicId) (This)->lpVtbl->getPublicId(This,ppwchPublicId)
#define ISAXLocator_getSystemId(This,ppwchSystemId) (This)->lpVtbl->getSystemId(This,ppwchSystemId)
#endif
#endif
    HRESULT WINAPI ISAXLocator_getColumnNumber_Proxy(ISAXLocator *This,int *pnColumn);
    void __RPC_STUB ISAXLocator_getColumnNumber_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXLocator_getLineNumber_Proxy(ISAXLocator *This,int *pnLine);
    void __RPC_STUB ISAXLocator_getLineNumber_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXLocator_getPublicId_Proxy(ISAXLocator *This,const wchar_t **ppwchPublicId);
    void __RPC_STUB ISAXLocator_getPublicId_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXLocator_getSystemId_Proxy(ISAXLocator *This,const wchar_t **ppwchSystemId);
    void __RPC_STUB ISAXLocator_getSystemId_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISAXEntityResolver_INTERFACE_DEFINED__
#define __ISAXEntityResolver_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISAXEntityResolver;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISAXEntityResolver : public IUnknown {
    public:
      virtual HRESULT WINAPI resolveEntity(const wchar_t *pwchPublicId,const wchar_t *pwchSystemId,VARIANT *pvarInput) = 0;
    };
#else
    typedef struct ISAXEntityResolverVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISAXEntityResolver *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISAXEntityResolver *This);
	ULONG (WINAPI *Release)(ISAXEntityResolver *This);
	HRESULT (WINAPI *resolveEntity)(ISAXEntityResolver *This,const wchar_t *pwchPublicId,const wchar_t *pwchSystemId,VARIANT *pvarInput);
      END_INTERFACE
    } ISAXEntityResolverVtbl;
    struct ISAXEntityResolver {
      CONST_VTBL struct ISAXEntityResolverVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISAXEntityResolver_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISAXEntityResolver_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISAXEntityResolver_Release(This) (This)->lpVtbl->Release(This)
#define ISAXEntityResolver_resolveEntity(This,pwchPublicId,pwchSystemId,pvarInput) (This)->lpVtbl->resolveEntity(This,pwchPublicId,pwchSystemId,pvarInput)
#endif
#endif
    HRESULT WINAPI ISAXEntityResolver_resolveEntity_Proxy(ISAXEntityResolver *This,const wchar_t *pwchPublicId,const wchar_t *pwchSystemId,VARIANT *pvarInput);
    void __RPC_STUB ISAXEntityResolver_resolveEntity_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISAXContentHandler_INTERFACE_DEFINED__
#define __ISAXContentHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISAXContentHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISAXContentHandler : public IUnknown {
    public:
      virtual HRESULT WINAPI putDocumentLocator(ISAXLocator *pLocator) = 0;
      virtual HRESULT WINAPI startDocument(void) = 0;
      virtual HRESULT WINAPI endDocument(void) = 0;
      virtual HRESULT WINAPI startPrefixMapping(const wchar_t *pwchPrefix,int cchPrefix,const wchar_t *pwchUri,int cchUri) = 0;
      virtual HRESULT WINAPI endPrefixMapping(const wchar_t *pwchPrefix,int cchPrefix) = 0;
      virtual HRESULT WINAPI startElement(const wchar_t *pwchNamespaceUri,int cchNamespaceUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t *pwchQName,int cchQName,ISAXAttributes *pAttributes) = 0;
      virtual HRESULT WINAPI endElement(const wchar_t *pwchNamespaceUri,int cchNamespaceUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t *pwchQName,int cchQName) = 0;
      virtual HRESULT WINAPI characters(const wchar_t *pwchChars,int cchChars) = 0;
      virtual HRESULT WINAPI ignorableWhitespace(const wchar_t *pwchChars,int cchChars) = 0;
      virtual HRESULT WINAPI processingInstruction(const wchar_t *pwchTarget,int cchTarget,const wchar_t *pwchData,int cchData) = 0;
      virtual HRESULT WINAPI skippedEntity(const wchar_t *pwchName,int cchName) = 0;
    };
#else
    typedef struct ISAXContentHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISAXContentHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISAXContentHandler *This);
	ULONG (WINAPI *Release)(ISAXContentHandler *This);
	HRESULT (WINAPI *putDocumentLocator)(ISAXContentHandler *This,ISAXLocator *pLocator);
	HRESULT (WINAPI *startDocument)(ISAXContentHandler *This);
	HRESULT (WINAPI *endDocument)(ISAXContentHandler *This);
	HRESULT (WINAPI *startPrefixMapping)(ISAXContentHandler *This,const wchar_t *pwchPrefix,int cchPrefix,const wchar_t *pwchUri,int cchUri);
	HRESULT (WINAPI *endPrefixMapping)(ISAXContentHandler *This,const wchar_t *pwchPrefix,int cchPrefix);
	HRESULT (WINAPI *startElement)(ISAXContentHandler *This,const wchar_t *pwchNamespaceUri,int cchNamespaceUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t *pwchQName,int cchQName,ISAXAttributes *pAttributes);
	HRESULT (WINAPI *endElement)(ISAXContentHandler *This,const wchar_t *pwchNamespaceUri,int cchNamespaceUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t *pwchQName,int cchQName);
	HRESULT (WINAPI *characters)(ISAXContentHandler *This,const wchar_t *pwchChars,int cchChars);
	HRESULT (WINAPI *ignorableWhitespace)(ISAXContentHandler *This,const wchar_t *pwchChars,int cchChars);
	HRESULT (WINAPI *processingInstruction)(ISAXContentHandler *This,const wchar_t *pwchTarget,int cchTarget,const wchar_t *pwchData,int cchData);
	HRESULT (WINAPI *skippedEntity)(ISAXContentHandler *This,const wchar_t *pwchName,int cchName);
      END_INTERFACE
    } ISAXContentHandlerVtbl;
    struct ISAXContentHandler {
      CONST_VTBL struct ISAXContentHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISAXContentHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISAXContentHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISAXContentHandler_Release(This) (This)->lpVtbl->Release(This)
#define ISAXContentHandler_putDocumentLocator(This,pLocator) (This)->lpVtbl->putDocumentLocator(This,pLocator)
#define ISAXContentHandler_startDocument(This) (This)->lpVtbl->startDocument(This)
#define ISAXContentHandler_endDocument(This) (This)->lpVtbl->endDocument(This)
#define ISAXContentHandler_startPrefixMapping(This,pwchPrefix,cchPrefix,pwchUri,cchUri) (This)->lpVtbl->startPrefixMapping(This,pwchPrefix,cchPrefix,pwchUri,cchUri)
#define ISAXContentHandler_endPrefixMapping(This,pwchPrefix,cchPrefix) (This)->lpVtbl->endPrefixMapping(This,pwchPrefix,cchPrefix)
#define ISAXContentHandler_startElement(This,pwchNamespaceUri,cchNamespaceUri,pwchLocalName,cchLocalName,pwchQName,cchQName,pAttributes) (This)->lpVtbl->startElement(This,pwchNamespaceUri,cchNamespaceUri,pwchLocalName,cchLocalName,pwchQName,cchQName,pAttributes)
#define ISAXContentHandler_endElement(This,pwchNamespaceUri,cchNamespaceUri,pwchLocalName,cchLocalName,pwchQName,cchQName) (This)->lpVtbl->endElement(This,pwchNamespaceUri,cchNamespaceUri,pwchLocalName,cchLocalName,pwchQName,cchQName)
#define ISAXContentHandler_characters(This,pwchChars,cchChars) (This)->lpVtbl->characters(This,pwchChars,cchChars)
#define ISAXContentHandler_ignorableWhitespace(This,pwchChars,cchChars) (This)->lpVtbl->ignorableWhitespace(This,pwchChars,cchChars)
#define ISAXContentHandler_processingInstruction(This,pwchTarget,cchTarget,pwchData,cchData) (This)->lpVtbl->processingInstruction(This,pwchTarget,cchTarget,pwchData,cchData)
#define ISAXContentHandler_skippedEntity(This,pwchName,cchName) (This)->lpVtbl->skippedEntity(This,pwchName,cchName)
#endif
#endif
    HRESULT WINAPI ISAXContentHandler_putDocumentLocator_Proxy(ISAXContentHandler *This,ISAXLocator *pLocator);
    void __RPC_STUB ISAXContentHandler_putDocumentLocator_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXContentHandler_startDocument_Proxy(ISAXContentHandler *This);
    void __RPC_STUB ISAXContentHandler_startDocument_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXContentHandler_endDocument_Proxy(ISAXContentHandler *This);
    void __RPC_STUB ISAXContentHandler_endDocument_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXContentHandler_startPrefixMapping_Proxy(ISAXContentHandler *This,const wchar_t *pwchPrefix,int cchPrefix,const wchar_t *pwchUri,int cchUri);
    void __RPC_STUB ISAXContentHandler_startPrefixMapping_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXContentHandler_endPrefixMapping_Proxy(ISAXContentHandler *This,const wchar_t *pwchPrefix,int cchPrefix);
    void __RPC_STUB ISAXContentHandler_endPrefixMapping_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXContentHandler_startElement_Proxy(ISAXContentHandler *This,const wchar_t *pwchNamespaceUri,int cchNamespaceUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t *pwchQName,int cchQName,ISAXAttributes *pAttributes);
    void __RPC_STUB ISAXContentHandler_startElement_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXContentHandler_endElement_Proxy(ISAXContentHandler *This,const wchar_t *pwchNamespaceUri,int cchNamespaceUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t *pwchQName,int cchQName);
    void __RPC_STUB ISAXContentHandler_endElement_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXContentHandler_characters_Proxy(ISAXContentHandler *This,const wchar_t *pwchChars,int cchChars);
    void __RPC_STUB ISAXContentHandler_characters_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXContentHandler_ignorableWhitespace_Proxy(ISAXContentHandler *This,const wchar_t *pwchChars,int cchChars);
    void __RPC_STUB ISAXContentHandler_ignorableWhitespace_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXContentHandler_processingInstruction_Proxy(ISAXContentHandler *This,const wchar_t *pwchTarget,int cchTarget,const wchar_t *pwchData,int cchData);
    void __RPC_STUB ISAXContentHandler_processingInstruction_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXContentHandler_skippedEntity_Proxy(ISAXContentHandler *This,const wchar_t *pwchName,int cchName);
    void __RPC_STUB ISAXContentHandler_skippedEntity_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISAXDTDHandler_INTERFACE_DEFINED__
#define __ISAXDTDHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISAXDTDHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISAXDTDHandler : public IUnknown {
    public:
      virtual HRESULT WINAPI notationDecl(const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId) = 0;
      virtual HRESULT WINAPI unparsedEntityDecl(const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId,const wchar_t *pwchNotationName,int cchNotationName) = 0;
    };
#else
    typedef struct ISAXDTDHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISAXDTDHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISAXDTDHandler *This);
	ULONG (WINAPI *Release)(ISAXDTDHandler *This);
	HRESULT (WINAPI *notationDecl)(ISAXDTDHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId);
	HRESULT (WINAPI *unparsedEntityDecl)(ISAXDTDHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId,const wchar_t *pwchNotationName,int cchNotationName);
      END_INTERFACE
    } ISAXDTDHandlerVtbl;
    struct ISAXDTDHandler {
      CONST_VTBL struct ISAXDTDHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISAXDTDHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISAXDTDHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISAXDTDHandler_Release(This) (This)->lpVtbl->Release(This)
#define ISAXDTDHandler_notationDecl(This,pwchName,cchName,pwchPublicId,cchPublicId,pwchSystemId,cchSystemId) (This)->lpVtbl->notationDecl(This,pwchName,cchName,pwchPublicId,cchPublicId,pwchSystemId,cchSystemId)
#define ISAXDTDHandler_unparsedEntityDecl(This,pwchName,cchName,pwchPublicId,cchPublicId,pwchSystemId,cchSystemId,pwchNotationName,cchNotationName) (This)->lpVtbl->unparsedEntityDecl(This,pwchName,cchName,pwchPublicId,cchPublicId,pwchSystemId,cchSystemId,pwchNotationName,cchNotationName)
#endif
#endif
    HRESULT WINAPI ISAXDTDHandler_notationDecl_Proxy(ISAXDTDHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId);
    void __RPC_STUB ISAXDTDHandler_notationDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXDTDHandler_unparsedEntityDecl_Proxy(ISAXDTDHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId,const wchar_t *pwchNotationName,int cchNotationName);
    void __RPC_STUB ISAXDTDHandler_unparsedEntityDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISAXErrorHandler_INTERFACE_DEFINED__
#define __ISAXErrorHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISAXErrorHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISAXErrorHandler : public IUnknown {
    public:
      virtual HRESULT WINAPI error(ISAXLocator *pLocator,const wchar_t *pwchErrorMessage,HRESULT hrErrorCode) = 0;
      virtual HRESULT WINAPI fatalError(ISAXLocator *pLocator,const wchar_t *pwchErrorMessage,HRESULT hrErrorCode) = 0;
      virtual HRESULT WINAPI ignorableWarning(ISAXLocator *pLocator,const wchar_t *pwchErrorMessage,HRESULT hrErrorCode) = 0;
    };
#else
    typedef struct ISAXErrorHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISAXErrorHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISAXErrorHandler *This);
	ULONG (WINAPI *Release)(ISAXErrorHandler *This);
	HRESULT (WINAPI *error)(ISAXErrorHandler *This,ISAXLocator *pLocator,const wchar_t *pwchErrorMessage,HRESULT hrErrorCode);
	HRESULT (WINAPI *fatalError)(ISAXErrorHandler *This,ISAXLocator *pLocator,const wchar_t *pwchErrorMessage,HRESULT hrErrorCode);
	HRESULT (WINAPI *ignorableWarning)(ISAXErrorHandler *This,ISAXLocator *pLocator,const wchar_t *pwchErrorMessage,HRESULT hrErrorCode);
      END_INTERFACE
    } ISAXErrorHandlerVtbl;
    struct ISAXErrorHandler {
      CONST_VTBL struct ISAXErrorHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISAXErrorHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISAXErrorHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISAXErrorHandler_Release(This) (This)->lpVtbl->Release(This)
#define ISAXErrorHandler_error(This,pLocator,pwchErrorMessage,hrErrorCode) (This)->lpVtbl->error(This,pLocator,pwchErrorMessage,hrErrorCode)
#define ISAXErrorHandler_fatalError(This,pLocator,pwchErrorMessage,hrErrorCode) (This)->lpVtbl->fatalError(This,pLocator,pwchErrorMessage,hrErrorCode)
#define ISAXErrorHandler_ignorableWarning(This,pLocator,pwchErrorMessage,hrErrorCode) (This)->lpVtbl->ignorableWarning(This,pLocator,pwchErrorMessage,hrErrorCode)
#endif
#endif
    HRESULT WINAPI ISAXErrorHandler_error_Proxy(ISAXErrorHandler *This,ISAXLocator *pLocator,const wchar_t *pwchErrorMessage,HRESULT hrErrorCode);
    void __RPC_STUB ISAXErrorHandler_error_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXErrorHandler_fatalError_Proxy(ISAXErrorHandler *This,ISAXLocator *pLocator,const wchar_t *pwchErrorMessage,HRESULT hrErrorCode);
    void __RPC_STUB ISAXErrorHandler_fatalError_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXErrorHandler_ignorableWarning_Proxy(ISAXErrorHandler *This,ISAXLocator *pLocator,const wchar_t *pwchErrorMessage,HRESULT hrErrorCode);
    void __RPC_STUB ISAXErrorHandler_ignorableWarning_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISAXLexicalHandler_INTERFACE_DEFINED__
#define __ISAXLexicalHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISAXLexicalHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISAXLexicalHandler : public IUnknown {
    public:
      virtual HRESULT WINAPI startDTD(const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId) = 0;
      virtual HRESULT WINAPI endDTD(void) = 0;
      virtual HRESULT WINAPI startEntity(const wchar_t *pwchName,int cchName) = 0;
      virtual HRESULT WINAPI endEntity(const wchar_t *pwchName,int cchName) = 0;
      virtual HRESULT WINAPI startCDATA(void) = 0;
      virtual HRESULT WINAPI endCDATA(void) = 0;
      virtual HRESULT WINAPI comment(const wchar_t *pwchChars,int cchChars) = 0;
    };
#else
    typedef struct ISAXLexicalHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISAXLexicalHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISAXLexicalHandler *This);
	ULONG (WINAPI *Release)(ISAXLexicalHandler *This);
	HRESULT (WINAPI *startDTD)(ISAXLexicalHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId);
	HRESULT (WINAPI *endDTD)(ISAXLexicalHandler *This);
	HRESULT (WINAPI *startEntity)(ISAXLexicalHandler *This,const wchar_t *pwchName,int cchName);
	HRESULT (WINAPI *endEntity)(ISAXLexicalHandler *This,const wchar_t *pwchName,int cchName);
	HRESULT (WINAPI *startCDATA)(ISAXLexicalHandler *This);
	HRESULT (WINAPI *endCDATA)(ISAXLexicalHandler *This);
	HRESULT (WINAPI *comment)(ISAXLexicalHandler *This,const wchar_t *pwchChars,int cchChars);
      END_INTERFACE
    } ISAXLexicalHandlerVtbl;
    struct ISAXLexicalHandler {
      CONST_VTBL struct ISAXLexicalHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISAXLexicalHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISAXLexicalHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISAXLexicalHandler_Release(This) (This)->lpVtbl->Release(This)
#define ISAXLexicalHandler_startDTD(This,pwchName,cchName,pwchPublicId,cchPublicId,pwchSystemId,cchSystemId) (This)->lpVtbl->startDTD(This,pwchName,cchName,pwchPublicId,cchPublicId,pwchSystemId,cchSystemId)
#define ISAXLexicalHandler_endDTD(This) (This)->lpVtbl->endDTD(This)
#define ISAXLexicalHandler_startEntity(This,pwchName,cchName) (This)->lpVtbl->startEntity(This,pwchName,cchName)
#define ISAXLexicalHandler_endEntity(This,pwchName,cchName) (This)->lpVtbl->endEntity(This,pwchName,cchName)
#define ISAXLexicalHandler_startCDATA(This) (This)->lpVtbl->startCDATA(This)
#define ISAXLexicalHandler_endCDATA(This) (This)->lpVtbl->endCDATA(This)
#define ISAXLexicalHandler_comment(This,pwchChars,cchChars) (This)->lpVtbl->comment(This,pwchChars,cchChars)
#endif
#endif
    HRESULT WINAPI ISAXLexicalHandler_startDTD_Proxy(ISAXLexicalHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId);
    void __RPC_STUB ISAXLexicalHandler_startDTD_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXLexicalHandler_endDTD_Proxy(ISAXLexicalHandler *This);
    void __RPC_STUB ISAXLexicalHandler_endDTD_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXLexicalHandler_startEntity_Proxy(ISAXLexicalHandler *This,const wchar_t *pwchName,int cchName);
    void __RPC_STUB ISAXLexicalHandler_startEntity_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXLexicalHandler_endEntity_Proxy(ISAXLexicalHandler *This,const wchar_t *pwchName,int cchName);
    void __RPC_STUB ISAXLexicalHandler_endEntity_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXLexicalHandler_startCDATA_Proxy(ISAXLexicalHandler *This);
    void __RPC_STUB ISAXLexicalHandler_startCDATA_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXLexicalHandler_endCDATA_Proxy(ISAXLexicalHandler *This);
    void __RPC_STUB ISAXLexicalHandler_endCDATA_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXLexicalHandler_comment_Proxy(ISAXLexicalHandler *This,const wchar_t *pwchChars,int cchChars);
    void __RPC_STUB ISAXLexicalHandler_comment_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISAXDeclHandler_INTERFACE_DEFINED__
#define __ISAXDeclHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISAXDeclHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISAXDeclHandler : public IUnknown {
    public:
      virtual HRESULT WINAPI elementDecl(const wchar_t *pwchName,int cchName,const wchar_t *pwchModel,int cchModel) = 0;
      virtual HRESULT WINAPI attributeDecl(const wchar_t *pwchElementName,int cchElementName,const wchar_t *pwchAttributeName,int cchAttributeName,const wchar_t *pwchType,int cchType,const wchar_t *pwchValueDefault,int cchValueDefault,const wchar_t *pwchValue,int cchValue) = 0;
      virtual HRESULT WINAPI internalEntityDecl(const wchar_t *pwchName,int cchName,const wchar_t *pwchValue,int cchValue) = 0;
      virtual HRESULT WINAPI externalEntityDecl(const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId) = 0;
    };
#else
    typedef struct ISAXDeclHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISAXDeclHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISAXDeclHandler *This);
	ULONG (WINAPI *Release)(ISAXDeclHandler *This);
	HRESULT (WINAPI *elementDecl)(ISAXDeclHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchModel,int cchModel);
	HRESULT (WINAPI *attributeDecl)(ISAXDeclHandler *This,const wchar_t *pwchElementName,int cchElementName,const wchar_t *pwchAttributeName,int cchAttributeName,const wchar_t *pwchType,int cchType,const wchar_t *pwchValueDefault,int cchValueDefault,const wchar_t *pwchValue,int cchValue);
	HRESULT (WINAPI *internalEntityDecl)(ISAXDeclHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchValue,int cchValue);
	HRESULT (WINAPI *externalEntityDecl)(ISAXDeclHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId);
      END_INTERFACE
    } ISAXDeclHandlerVtbl;
    struct ISAXDeclHandler {
      CONST_VTBL struct ISAXDeclHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISAXDeclHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISAXDeclHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISAXDeclHandler_Release(This) (This)->lpVtbl->Release(This)
#define ISAXDeclHandler_elementDecl(This,pwchName,cchName,pwchModel,cchModel) (This)->lpVtbl->elementDecl(This,pwchName,cchName,pwchModel,cchModel)
#define ISAXDeclHandler_attributeDecl(This,pwchElementName,cchElementName,pwchAttributeName,cchAttributeName,pwchType,cchType,pwchValueDefault,cchValueDefault,pwchValue,cchValue) (This)->lpVtbl->attributeDecl(This,pwchElementName,cchElementName,pwchAttributeName,cchAttributeName,pwchType,cchType,pwchValueDefault,cchValueDefault,pwchValue,cchValue)
#define ISAXDeclHandler_internalEntityDecl(This,pwchName,cchName,pwchValue,cchValue) (This)->lpVtbl->internalEntityDecl(This,pwchName,cchName,pwchValue,cchValue)
#define ISAXDeclHandler_externalEntityDecl(This,pwchName,cchName,pwchPublicId,cchPublicId,pwchSystemId,cchSystemId) (This)->lpVtbl->externalEntityDecl(This,pwchName,cchName,pwchPublicId,cchPublicId,pwchSystemId,cchSystemId)
#endif
#endif
    HRESULT WINAPI ISAXDeclHandler_elementDecl_Proxy(ISAXDeclHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchModel,int cchModel);
    void __RPC_STUB ISAXDeclHandler_elementDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXDeclHandler_attributeDecl_Proxy(ISAXDeclHandler *This,const wchar_t *pwchElementName,int cchElementName,const wchar_t *pwchAttributeName,int cchAttributeName,const wchar_t *pwchType,int cchType,const wchar_t *pwchValueDefault,int cchValueDefault,const wchar_t *pwchValue,int cchValue);
    void __RPC_STUB ISAXDeclHandler_attributeDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXDeclHandler_internalEntityDecl_Proxy(ISAXDeclHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchValue,int cchValue);
    void __RPC_STUB ISAXDeclHandler_internalEntityDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXDeclHandler_externalEntityDecl_Proxy(ISAXDeclHandler *This,const wchar_t *pwchName,int cchName,const wchar_t *pwchPublicId,int cchPublicId,const wchar_t *pwchSystemId,int cchSystemId);
    void __RPC_STUB ISAXDeclHandler_externalEntityDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISAXAttributes_INTERFACE_DEFINED__
#define __ISAXAttributes_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISAXAttributes;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISAXAttributes : public IUnknown {
    public:
      virtual HRESULT WINAPI getLength(int *pnLength) = 0;
      virtual HRESULT WINAPI getURI(int nIndex,const wchar_t **ppwchUri,int *pcchUri) = 0;
      virtual HRESULT WINAPI getLocalName(int nIndex,const wchar_t **ppwchLocalName,int *pcchLocalName) = 0;
      virtual HRESULT WINAPI getQName(int nIndex,const wchar_t **ppwchQName,int *pcchQName) = 0;
      virtual HRESULT WINAPI getName(int nIndex,const wchar_t **ppwchUri,int *pcchUri,const wchar_t **ppwchLocalName,int *pcchLocalName,const wchar_t **ppwchQName,int *pcchQName) = 0;
      virtual HRESULT WINAPI getIndexFromName(const wchar_t *pwchUri,int cchUri,const wchar_t *pwchLocalName,int cchLocalName,int *pnIndex) = 0;
      virtual HRESULT WINAPI getIndexFromQName(const wchar_t *pwchQName,int cchQName,int *pnIndex) = 0;
      virtual HRESULT WINAPI getType(int nIndex,const wchar_t **ppwchType,int *pcchType) = 0;
      virtual HRESULT WINAPI getTypeFromName(const wchar_t *pwchUri,int cchUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t **ppwchType,int *pcchType) = 0;
      virtual HRESULT WINAPI getTypeFromQName(const wchar_t *pwchQName,int cchQName,const wchar_t **ppwchType,int *pcchType) = 0;
      virtual HRESULT WINAPI getValue(int nIndex,const wchar_t **ppwchValue,int *pcchValue) = 0;
      virtual HRESULT WINAPI getValueFromName(const wchar_t *pwchUri,int cchUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t **ppwchValue,int *pcchValue) = 0;
      virtual HRESULT WINAPI getValueFromQName(const wchar_t *pwchQName,int cchQName,const wchar_t **ppwchValue,int *pcchValue) = 0;
    };
#else
    typedef struct ISAXAttributesVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISAXAttributes *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISAXAttributes *This);
	ULONG (WINAPI *Release)(ISAXAttributes *This);
	HRESULT (WINAPI *getLength)(ISAXAttributes *This,int *pnLength);
	HRESULT (WINAPI *getURI)(ISAXAttributes *This,int nIndex,const wchar_t **ppwchUri,int *pcchUri);
	HRESULT (WINAPI *getLocalName)(ISAXAttributes *This,int nIndex,const wchar_t **ppwchLocalName,int *pcchLocalName);
	HRESULT (WINAPI *getQName)(ISAXAttributes *This,int nIndex,const wchar_t **ppwchQName,int *pcchQName);
	HRESULT (WINAPI *getName)(ISAXAttributes *This,int nIndex,const wchar_t **ppwchUri,int *pcchUri,const wchar_t **ppwchLocalName,int *pcchLocalName,const wchar_t **ppwchQName,int *pcchQName);
	HRESULT (WINAPI *getIndexFromName)(ISAXAttributes *This,const wchar_t *pwchUri,int cchUri,const wchar_t *pwchLocalName,int cchLocalName,int *pnIndex);
	HRESULT (WINAPI *getIndexFromQName)(ISAXAttributes *This,const wchar_t *pwchQName,int cchQName,int *pnIndex);
	HRESULT (WINAPI *getType)(ISAXAttributes *This,int nIndex,const wchar_t **ppwchType,int *pcchType);
	HRESULT (WINAPI *getTypeFromName)(ISAXAttributes *This,const wchar_t *pwchUri,int cchUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t **ppwchType,int *pcchType);
	HRESULT (WINAPI *getTypeFromQName)(ISAXAttributes *This,const wchar_t *pwchQName,int cchQName,const wchar_t **ppwchType,int *pcchType);
	HRESULT (WINAPI *getValue)(ISAXAttributes *This,int nIndex,const wchar_t **ppwchValue,int *pcchValue);
	HRESULT (WINAPI *getValueFromName)(ISAXAttributes *This,const wchar_t *pwchUri,int cchUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t **ppwchValue,int *pcchValue);
	HRESULT (WINAPI *getValueFromQName)(ISAXAttributes *This,const wchar_t *pwchQName,int cchQName,const wchar_t **ppwchValue,int *pcchValue);
      END_INTERFACE
    } ISAXAttributesVtbl;
    struct ISAXAttributes {
      CONST_VTBL struct ISAXAttributesVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISAXAttributes_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISAXAttributes_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISAXAttributes_Release(This) (This)->lpVtbl->Release(This)
#define ISAXAttributes_getLength(This,pnLength) (This)->lpVtbl->getLength(This,pnLength)
#define ISAXAttributes_getURI(This,nIndex,ppwchUri,pcchUri) (This)->lpVtbl->getURI(This,nIndex,ppwchUri,pcchUri)
#define ISAXAttributes_getLocalName(This,nIndex,ppwchLocalName,pcchLocalName) (This)->lpVtbl->getLocalName(This,nIndex,ppwchLocalName,pcchLocalName)
#define ISAXAttributes_getQName(This,nIndex,ppwchQName,pcchQName) (This)->lpVtbl->getQName(This,nIndex,ppwchQName,pcchQName)
#define ISAXAttributes_getName(This,nIndex,ppwchUri,pcchUri,ppwchLocalName,pcchLocalName,ppwchQName,pcchQName) (This)->lpVtbl->getName(This,nIndex,ppwchUri,pcchUri,ppwchLocalName,pcchLocalName,ppwchQName,pcchQName)
#define ISAXAttributes_getIndexFromName(This,pwchUri,cchUri,pwchLocalName,cchLocalName,pnIndex) (This)->lpVtbl->getIndexFromName(This,pwchUri,cchUri,pwchLocalName,cchLocalName,pnIndex)
#define ISAXAttributes_getIndexFromQName(This,pwchQName,cchQName,pnIndex) (This)->lpVtbl->getIndexFromQName(This,pwchQName,cchQName,pnIndex)
#define ISAXAttributes_getType(This,nIndex,ppwchType,pcchType) (This)->lpVtbl->getType(This,nIndex,ppwchType,pcchType)
#define ISAXAttributes_getTypeFromName(This,pwchUri,cchUri,pwchLocalName,cchLocalName,ppwchType,pcchType) (This)->lpVtbl->getTypeFromName(This,pwchUri,cchUri,pwchLocalName,cchLocalName,ppwchType,pcchType)
#define ISAXAttributes_getTypeFromQName(This,pwchQName,cchQName,ppwchType,pcchType) (This)->lpVtbl->getTypeFromQName(This,pwchQName,cchQName,ppwchType,pcchType)
#define ISAXAttributes_getValue(This,nIndex,ppwchValue,pcchValue) (This)->lpVtbl->getValue(This,nIndex,ppwchValue,pcchValue)
#define ISAXAttributes_getValueFromName(This,pwchUri,cchUri,pwchLocalName,cchLocalName,ppwchValue,pcchValue) (This)->lpVtbl->getValueFromName(This,pwchUri,cchUri,pwchLocalName,cchLocalName,ppwchValue,pcchValue)
#define ISAXAttributes_getValueFromQName(This,pwchQName,cchQName,ppwchValue,pcchValue) (This)->lpVtbl->getValueFromQName(This,pwchQName,cchQName,ppwchValue,pcchValue)
#endif
#endif
    HRESULT WINAPI ISAXAttributes_getLength_Proxy(ISAXAttributes *This,int *pnLength);
    void __RPC_STUB ISAXAttributes_getLength_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getURI_Proxy(ISAXAttributes *This,int nIndex,const wchar_t **ppwchUri,int *pcchUri);
    void __RPC_STUB ISAXAttributes_getURI_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getLocalName_Proxy(ISAXAttributes *This,int nIndex,const wchar_t **ppwchLocalName,int *pcchLocalName);
    void __RPC_STUB ISAXAttributes_getLocalName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getQName_Proxy(ISAXAttributes *This,int nIndex,const wchar_t **ppwchQName,int *pcchQName);
    void __RPC_STUB ISAXAttributes_getQName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getName_Proxy(ISAXAttributes *This,int nIndex,const wchar_t **ppwchUri,int *pcchUri,const wchar_t **ppwchLocalName,int *pcchLocalName,const wchar_t **ppwchQName,int *pcchQName);
    void __RPC_STUB ISAXAttributes_getName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getIndexFromName_Proxy(ISAXAttributes *This,const wchar_t *pwchUri,int cchUri,const wchar_t *pwchLocalName,int cchLocalName,int *pnIndex);
    void __RPC_STUB ISAXAttributes_getIndexFromName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getIndexFromQName_Proxy(ISAXAttributes *This,const wchar_t *pwchQName,int cchQName,int *pnIndex);
    void __RPC_STUB ISAXAttributes_getIndexFromQName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getType_Proxy(ISAXAttributes *This,int nIndex,const wchar_t **ppwchType,int *pcchType);
    void __RPC_STUB ISAXAttributes_getType_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getTypeFromName_Proxy(ISAXAttributes *This,const wchar_t *pwchUri,int cchUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t **ppwchType,int *pcchType);
    void __RPC_STUB ISAXAttributes_getTypeFromName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getTypeFromQName_Proxy(ISAXAttributes *This,const wchar_t *pwchQName,int cchQName,const wchar_t **ppwchType,int *pcchType);
    void __RPC_STUB ISAXAttributes_getTypeFromQName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getValue_Proxy(ISAXAttributes *This,int nIndex,const wchar_t **ppwchValue,int *pcchValue);
    void __RPC_STUB ISAXAttributes_getValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getValueFromName_Proxy(ISAXAttributes *This,const wchar_t *pwchUri,int cchUri,const wchar_t *pwchLocalName,int cchLocalName,const wchar_t **ppwchValue,int *pcchValue);
    void __RPC_STUB ISAXAttributes_getValueFromName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISAXAttributes_getValueFromQName_Proxy(ISAXAttributes *This,const wchar_t *pwchQName,int cchQName,const wchar_t **ppwchValue,int *pcchValue);
    void __RPC_STUB ISAXAttributes_getValueFromQName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBSAXXMLReader_INTERFACE_DEFINED__
#define __IVBSAXXMLReader_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBSAXXMLReader;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBSAXXMLReader : public IDispatch {
    public:
      virtual HRESULT WINAPI getFeature(BSTR strName,VARIANT_BOOL *fValue) = 0;
      virtual HRESULT WINAPI putFeature(BSTR strName,VARIANT_BOOL fValue) = 0;
      virtual HRESULT WINAPI getProperty(BSTR strName,VARIANT *varValue) = 0;
      virtual HRESULT WINAPI putProperty(BSTR strName,VARIANT varValue) = 0;
      virtual HRESULT WINAPI get_entityResolver(IVBSAXEntityResolver **oResolver) = 0;
      virtual HRESULT WINAPI putref_entityResolver(IVBSAXEntityResolver *oResolver) = 0;
      virtual HRESULT WINAPI get_contentHandler(IVBSAXContentHandler **oHandler) = 0;
      virtual HRESULT WINAPI putref_contentHandler(IVBSAXContentHandler *oHandler) = 0;
      virtual HRESULT WINAPI get_dtdHandler(IVBSAXDTDHandler **oHandler) = 0;
      virtual HRESULT WINAPI putref_dtdHandler(IVBSAXDTDHandler *oHandler) = 0;
      virtual HRESULT WINAPI get_errorHandler(IVBSAXErrorHandler **oHandler) = 0;
      virtual HRESULT WINAPI putref_errorHandler(IVBSAXErrorHandler *oHandler) = 0;
      virtual HRESULT WINAPI get_baseURL(BSTR *strBaseURL) = 0;
      virtual HRESULT WINAPI put_baseURL(BSTR strBaseURL) = 0;
      virtual HRESULT WINAPI get_secureBaseURL(BSTR *strSecureBaseURL) = 0;
      virtual HRESULT WINAPI put_secureBaseURL(BSTR strSecureBaseURL) = 0;
      virtual HRESULT WINAPI parse(VARIANT varInput) = 0;
      virtual HRESULT WINAPI parseURL(BSTR strURL) = 0;
    };
#else
    typedef struct IVBSAXXMLReaderVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBSAXXMLReader *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBSAXXMLReader *This);
	ULONG (WINAPI *Release)(IVBSAXXMLReader *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBSAXXMLReader *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBSAXXMLReader *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBSAXXMLReader *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBSAXXMLReader *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *getFeature)(IVBSAXXMLReader *This,BSTR strName,VARIANT_BOOL *fValue);
	HRESULT (WINAPI *putFeature)(IVBSAXXMLReader *This,BSTR strName,VARIANT_BOOL fValue);
	HRESULT (WINAPI *getProperty)(IVBSAXXMLReader *This,BSTR strName,VARIANT *varValue);
	HRESULT (WINAPI *putProperty)(IVBSAXXMLReader *This,BSTR strName,VARIANT varValue);
	HRESULT (WINAPI *get_entityResolver)(IVBSAXXMLReader *This,IVBSAXEntityResolver **oResolver);
	HRESULT (WINAPI *putref_entityResolver)(IVBSAXXMLReader *This,IVBSAXEntityResolver *oResolver);
	HRESULT (WINAPI *get_contentHandler)(IVBSAXXMLReader *This,IVBSAXContentHandler **oHandler);
	HRESULT (WINAPI *putref_contentHandler)(IVBSAXXMLReader *This,IVBSAXContentHandler *oHandler);
	HRESULT (WINAPI *get_dtdHandler)(IVBSAXXMLReader *This,IVBSAXDTDHandler **oHandler);
	HRESULT (WINAPI *putref_dtdHandler)(IVBSAXXMLReader *This,IVBSAXDTDHandler *oHandler);
	HRESULT (WINAPI *get_errorHandler)(IVBSAXXMLReader *This,IVBSAXErrorHandler **oHandler);
	HRESULT (WINAPI *putref_errorHandler)(IVBSAXXMLReader *This,IVBSAXErrorHandler *oHandler);
	HRESULT (WINAPI *get_baseURL)(IVBSAXXMLReader *This,BSTR *strBaseURL);
	HRESULT (WINAPI *put_baseURL)(IVBSAXXMLReader *This,BSTR strBaseURL);
	HRESULT (WINAPI *get_secureBaseURL)(IVBSAXXMLReader *This,BSTR *strSecureBaseURL);
	HRESULT (WINAPI *put_secureBaseURL)(IVBSAXXMLReader *This,BSTR strSecureBaseURL);
	HRESULT (WINAPI *parse)(IVBSAXXMLReader *This,VARIANT varInput);
	HRESULT (WINAPI *parseURL)(IVBSAXXMLReader *This,BSTR strURL);
      END_INTERFACE
    } IVBSAXXMLReaderVtbl;
    struct IVBSAXXMLReader {
      CONST_VTBL struct IVBSAXXMLReaderVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBSAXXMLReader_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBSAXXMLReader_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBSAXXMLReader_Release(This) (This)->lpVtbl->Release(This)
#define IVBSAXXMLReader_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBSAXXMLReader_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBSAXXMLReader_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBSAXXMLReader_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBSAXXMLReader_getFeature(This,strName,fValue) (This)->lpVtbl->getFeature(This,strName,fValue)
#define IVBSAXXMLReader_putFeature(This,strName,fValue) (This)->lpVtbl->putFeature(This,strName,fValue)
#define IVBSAXXMLReader_getProperty(This,strName,varValue) (This)->lpVtbl->getProperty(This,strName,varValue)
#define IVBSAXXMLReader_putProperty(This,strName,varValue) (This)->lpVtbl->putProperty(This,strName,varValue)
#define IVBSAXXMLReader_get_entityResolver(This,oResolver) (This)->lpVtbl->get_entityResolver(This,oResolver)
#define IVBSAXXMLReader_putref_entityResolver(This,oResolver) (This)->lpVtbl->putref_entityResolver(This,oResolver)
#define IVBSAXXMLReader_get_contentHandler(This,oHandler) (This)->lpVtbl->get_contentHandler(This,oHandler)
#define IVBSAXXMLReader_putref_contentHandler(This,oHandler) (This)->lpVtbl->putref_contentHandler(This,oHandler)
#define IVBSAXXMLReader_get_dtdHandler(This,oHandler) (This)->lpVtbl->get_dtdHandler(This,oHandler)
#define IVBSAXXMLReader_putref_dtdHandler(This,oHandler) (This)->lpVtbl->putref_dtdHandler(This,oHandler)
#define IVBSAXXMLReader_get_errorHandler(This,oHandler) (This)->lpVtbl->get_errorHandler(This,oHandler)
#define IVBSAXXMLReader_putref_errorHandler(This,oHandler) (This)->lpVtbl->putref_errorHandler(This,oHandler)
#define IVBSAXXMLReader_get_baseURL(This,strBaseURL) (This)->lpVtbl->get_baseURL(This,strBaseURL)
#define IVBSAXXMLReader_put_baseURL(This,strBaseURL) (This)->lpVtbl->put_baseURL(This,strBaseURL)
#define IVBSAXXMLReader_get_secureBaseURL(This,strSecureBaseURL) (This)->lpVtbl->get_secureBaseURL(This,strSecureBaseURL)
#define IVBSAXXMLReader_put_secureBaseURL(This,strSecureBaseURL) (This)->lpVtbl->put_secureBaseURL(This,strSecureBaseURL)
#define IVBSAXXMLReader_parse(This,varInput) (This)->lpVtbl->parse(This,varInput)
#define IVBSAXXMLReader_parseURL(This,strURL) (This)->lpVtbl->parseURL(This,strURL)
#endif
#endif
    HRESULT WINAPI IVBSAXXMLReader_getFeature_Proxy(IVBSAXXMLReader *This,BSTR strName,VARIANT_BOOL *fValue);
    void __RPC_STUB IVBSAXXMLReader_getFeature_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_putFeature_Proxy(IVBSAXXMLReader *This,BSTR strName,VARIANT_BOOL fValue);
    void __RPC_STUB IVBSAXXMLReader_putFeature_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_getProperty_Proxy(IVBSAXXMLReader *This,BSTR strName,VARIANT *varValue);
    void __RPC_STUB IVBSAXXMLReader_getProperty_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_putProperty_Proxy(IVBSAXXMLReader *This,BSTR strName,VARIANT varValue);
    void __RPC_STUB IVBSAXXMLReader_putProperty_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_get_entityResolver_Proxy(IVBSAXXMLReader *This,IVBSAXEntityResolver **oResolver);
    void __RPC_STUB IVBSAXXMLReader_get_entityResolver_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_putref_entityResolver_Proxy(IVBSAXXMLReader *This,IVBSAXEntityResolver *oResolver);
    void __RPC_STUB IVBSAXXMLReader_putref_entityResolver_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_get_contentHandler_Proxy(IVBSAXXMLReader *This,IVBSAXContentHandler **oHandler);
    void __RPC_STUB IVBSAXXMLReader_get_contentHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_putref_contentHandler_Proxy(IVBSAXXMLReader *This,IVBSAXContentHandler *oHandler);
    void __RPC_STUB IVBSAXXMLReader_putref_contentHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_get_dtdHandler_Proxy(IVBSAXXMLReader *This,IVBSAXDTDHandler **oHandler);
    void __RPC_STUB IVBSAXXMLReader_get_dtdHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_putref_dtdHandler_Proxy(IVBSAXXMLReader *This,IVBSAXDTDHandler *oHandler);
    void __RPC_STUB IVBSAXXMLReader_putref_dtdHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_get_errorHandler_Proxy(IVBSAXXMLReader *This,IVBSAXErrorHandler **oHandler);
    void __RPC_STUB IVBSAXXMLReader_get_errorHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_putref_errorHandler_Proxy(IVBSAXXMLReader *This,IVBSAXErrorHandler *oHandler);
    void __RPC_STUB IVBSAXXMLReader_putref_errorHandler_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_get_baseURL_Proxy(IVBSAXXMLReader *This,BSTR *strBaseURL);
    void __RPC_STUB IVBSAXXMLReader_get_baseURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_put_baseURL_Proxy(IVBSAXXMLReader *This,BSTR strBaseURL);
    void __RPC_STUB IVBSAXXMLReader_put_baseURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_get_secureBaseURL_Proxy(IVBSAXXMLReader *This,BSTR *strSecureBaseURL);
    void __RPC_STUB IVBSAXXMLReader_get_secureBaseURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_put_secureBaseURL_Proxy(IVBSAXXMLReader *This,BSTR strSecureBaseURL);
    void __RPC_STUB IVBSAXXMLReader_put_secureBaseURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_parse_Proxy(IVBSAXXMLReader *This,VARIANT varInput);
    void __RPC_STUB IVBSAXXMLReader_parse_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLReader_parseURL_Proxy(IVBSAXXMLReader *This,BSTR strURL);
    void __RPC_STUB IVBSAXXMLReader_parseURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBSAXXMLFilter_INTERFACE_DEFINED__
#define __IVBSAXXMLFilter_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBSAXXMLFilter;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBSAXXMLFilter : public IDispatch {
    public:
      virtual HRESULT WINAPI get_parent(IVBSAXXMLReader **oReader) = 0;
      virtual HRESULT WINAPI putref_parent(IVBSAXXMLReader *oReader) = 0;
    };
#else
    typedef struct IVBSAXXMLFilterVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBSAXXMLFilter *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBSAXXMLFilter *This);
	ULONG (WINAPI *Release)(IVBSAXXMLFilter *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBSAXXMLFilter *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBSAXXMLFilter *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBSAXXMLFilter *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBSAXXMLFilter *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_parent)(IVBSAXXMLFilter *This,IVBSAXXMLReader **oReader);
	HRESULT (WINAPI *putref_parent)(IVBSAXXMLFilter *This,IVBSAXXMLReader *oReader);
      END_INTERFACE
    } IVBSAXXMLFilterVtbl;
    struct IVBSAXXMLFilter {
      CONST_VTBL struct IVBSAXXMLFilterVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBSAXXMLFilter_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBSAXXMLFilter_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBSAXXMLFilter_Release(This) (This)->lpVtbl->Release(This)
#define IVBSAXXMLFilter_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBSAXXMLFilter_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBSAXXMLFilter_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBSAXXMLFilter_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBSAXXMLFilter_get_parent(This,oReader) (This)->lpVtbl->get_parent(This,oReader)
#define IVBSAXXMLFilter_putref_parent(This,oReader) (This)->lpVtbl->putref_parent(This,oReader)
#endif
#endif
    HRESULT WINAPI IVBSAXXMLFilter_get_parent_Proxy(IVBSAXXMLFilter *This,IVBSAXXMLReader **oReader);
    void __RPC_STUB IVBSAXXMLFilter_get_parent_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXXMLFilter_putref_parent_Proxy(IVBSAXXMLFilter *This,IVBSAXXMLReader *oReader);
    void __RPC_STUB IVBSAXXMLFilter_putref_parent_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBSAXLocator_INTERFACE_DEFINED__
#define __IVBSAXLocator_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBSAXLocator;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBSAXLocator : public IDispatch {
    public:
      virtual HRESULT WINAPI get_columnNumber(int *nColumn) = 0;
      virtual HRESULT WINAPI get_lineNumber(int *nLine) = 0;
      virtual HRESULT WINAPI get_publicId(BSTR *strPublicId) = 0;
      virtual HRESULT WINAPI get_systemId(BSTR *strSystemId) = 0;
    };
#else
    typedef struct IVBSAXLocatorVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBSAXLocator *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBSAXLocator *This);
	ULONG (WINAPI *Release)(IVBSAXLocator *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBSAXLocator *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBSAXLocator *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBSAXLocator *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBSAXLocator *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_columnNumber)(IVBSAXLocator *This,int *nColumn);
	HRESULT (WINAPI *get_lineNumber)(IVBSAXLocator *This,int *nLine);
	HRESULT (WINAPI *get_publicId)(IVBSAXLocator *This,BSTR *strPublicId);
	HRESULT (WINAPI *get_systemId)(IVBSAXLocator *This,BSTR *strSystemId);
      END_INTERFACE
    } IVBSAXLocatorVtbl;
    struct IVBSAXLocator {
      CONST_VTBL struct IVBSAXLocatorVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBSAXLocator_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBSAXLocator_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBSAXLocator_Release(This) (This)->lpVtbl->Release(This)
#define IVBSAXLocator_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBSAXLocator_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBSAXLocator_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBSAXLocator_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBSAXLocator_get_columnNumber(This,nColumn) (This)->lpVtbl->get_columnNumber(This,nColumn)
#define IVBSAXLocator_get_lineNumber(This,nLine) (This)->lpVtbl->get_lineNumber(This,nLine)
#define IVBSAXLocator_get_publicId(This,strPublicId) (This)->lpVtbl->get_publicId(This,strPublicId)
#define IVBSAXLocator_get_systemId(This,strSystemId) (This)->lpVtbl->get_systemId(This,strSystemId)
#endif
#endif
    HRESULT WINAPI IVBSAXLocator_get_columnNumber_Proxy(IVBSAXLocator *This,int *nColumn);
    void __RPC_STUB IVBSAXLocator_get_columnNumber_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXLocator_get_lineNumber_Proxy(IVBSAXLocator *This,int *nLine);
    void __RPC_STUB IVBSAXLocator_get_lineNumber_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXLocator_get_publicId_Proxy(IVBSAXLocator *This,BSTR *strPublicId);
    void __RPC_STUB IVBSAXLocator_get_publicId_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXLocator_get_systemId_Proxy(IVBSAXLocator *This,BSTR *strSystemId);
    void __RPC_STUB IVBSAXLocator_get_systemId_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBSAXEntityResolver_INTERFACE_DEFINED__
#define __IVBSAXEntityResolver_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBSAXEntityResolver;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBSAXEntityResolver : public IDispatch {
    public:
      virtual HRESULT WINAPI resolveEntity(BSTR *strPublicId,BSTR *strSystemId,VARIANT *varInput) = 0;
    };
#else
    typedef struct IVBSAXEntityResolverVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBSAXEntityResolver *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBSAXEntityResolver *This);
	ULONG (WINAPI *Release)(IVBSAXEntityResolver *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBSAXEntityResolver *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBSAXEntityResolver *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBSAXEntityResolver *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBSAXEntityResolver *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *resolveEntity)(IVBSAXEntityResolver *This,BSTR *strPublicId,BSTR *strSystemId,VARIANT *varInput);
      END_INTERFACE
    } IVBSAXEntityResolverVtbl;
    struct IVBSAXEntityResolver {
      CONST_VTBL struct IVBSAXEntityResolverVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBSAXEntityResolver_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBSAXEntityResolver_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBSAXEntityResolver_Release(This) (This)->lpVtbl->Release(This)
#define IVBSAXEntityResolver_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBSAXEntityResolver_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBSAXEntityResolver_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBSAXEntityResolver_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBSAXEntityResolver_resolveEntity(This,strPublicId,strSystemId,varInput) (This)->lpVtbl->resolveEntity(This,strPublicId,strSystemId,varInput)
#endif
#endif
    HRESULT WINAPI IVBSAXEntityResolver_resolveEntity_Proxy(IVBSAXEntityResolver *This,BSTR *strPublicId,BSTR *strSystemId,VARIANT *varInput);
    void __RPC_STUB IVBSAXEntityResolver_resolveEntity_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBSAXContentHandler_INTERFACE_DEFINED__
#define __IVBSAXContentHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBSAXContentHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBSAXContentHandler : public IDispatch {
    public:
      virtual HRESULT WINAPI putref_documentLocator(IVBSAXLocator *oLocator) = 0;
      virtual HRESULT WINAPI startDocument(void) = 0;
      virtual HRESULT WINAPI endDocument(void) = 0;
      virtual HRESULT WINAPI startPrefixMapping(BSTR *strPrefix,BSTR *strURI) = 0;
      virtual HRESULT WINAPI endPrefixMapping(BSTR *strPrefix) = 0;
      virtual HRESULT WINAPI startElement(BSTR *strNamespaceURI,BSTR *strLocalName,BSTR *strQName,IVBSAXAttributes *oAttributes) = 0;
      virtual HRESULT WINAPI endElement(BSTR *strNamespaceURI,BSTR *strLocalName,BSTR *strQName) = 0;
      virtual HRESULT WINAPI characters(BSTR *strChars) = 0;
      virtual HRESULT WINAPI ignorableWhitespace(BSTR *strChars) = 0;
      virtual HRESULT WINAPI processingInstruction(BSTR *strTarget,BSTR *strData) = 0;
      virtual HRESULT WINAPI skippedEntity(BSTR *strName) = 0;
    };
#else
    typedef struct IVBSAXContentHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBSAXContentHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBSAXContentHandler *This);
	ULONG (WINAPI *Release)(IVBSAXContentHandler *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBSAXContentHandler *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBSAXContentHandler *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBSAXContentHandler *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBSAXContentHandler *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *putref_documentLocator)(IVBSAXContentHandler *This,IVBSAXLocator *oLocator);
	HRESULT (WINAPI *startDocument)(IVBSAXContentHandler *This);
	HRESULT (WINAPI *endDocument)(IVBSAXContentHandler *This);
	HRESULT (WINAPI *startPrefixMapping)(IVBSAXContentHandler *This,BSTR *strPrefix,BSTR *strURI);
	HRESULT (WINAPI *endPrefixMapping)(IVBSAXContentHandler *This,BSTR *strPrefix);
	HRESULT (WINAPI *startElement)(IVBSAXContentHandler *This,BSTR *strNamespaceURI,BSTR *strLocalName,BSTR *strQName,IVBSAXAttributes *oAttributes);
	HRESULT (WINAPI *endElement)(IVBSAXContentHandler *This,BSTR *strNamespaceURI,BSTR *strLocalName,BSTR *strQName);
	HRESULT (WINAPI *characters)(IVBSAXContentHandler *This,BSTR *strChars);
	HRESULT (WINAPI *ignorableWhitespace)(IVBSAXContentHandler *This,BSTR *strChars);
	HRESULT (WINAPI *processingInstruction)(IVBSAXContentHandler *This,BSTR *strTarget,BSTR *strData);
	HRESULT (WINAPI *skippedEntity)(IVBSAXContentHandler *This,BSTR *strName);
      END_INTERFACE
    } IVBSAXContentHandlerVtbl;
    struct IVBSAXContentHandler {
      CONST_VTBL struct IVBSAXContentHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBSAXContentHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBSAXContentHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBSAXContentHandler_Release(This) (This)->lpVtbl->Release(This)
#define IVBSAXContentHandler_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBSAXContentHandler_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBSAXContentHandler_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBSAXContentHandler_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBSAXContentHandler_putref_documentLocator(This,oLocator) (This)->lpVtbl->putref_documentLocator(This,oLocator)
#define IVBSAXContentHandler_startDocument(This) (This)->lpVtbl->startDocument(This)
#define IVBSAXContentHandler_endDocument(This) (This)->lpVtbl->endDocument(This)
#define IVBSAXContentHandler_startPrefixMapping(This,strPrefix,strURI) (This)->lpVtbl->startPrefixMapping(This,strPrefix,strURI)
#define IVBSAXContentHandler_endPrefixMapping(This,strPrefix) (This)->lpVtbl->endPrefixMapping(This,strPrefix)
#define IVBSAXContentHandler_startElement(This,strNamespaceURI,strLocalName,strQName,oAttributes) (This)->lpVtbl->startElement(This,strNamespaceURI,strLocalName,strQName,oAttributes)
#define IVBSAXContentHandler_endElement(This,strNamespaceURI,strLocalName,strQName) (This)->lpVtbl->endElement(This,strNamespaceURI,strLocalName,strQName)
#define IVBSAXContentHandler_characters(This,strChars) (This)->lpVtbl->characters(This,strChars)
#define IVBSAXContentHandler_ignorableWhitespace(This,strChars) (This)->lpVtbl->ignorableWhitespace(This,strChars)
#define IVBSAXContentHandler_processingInstruction(This,strTarget,strData) (This)->lpVtbl->processingInstruction(This,strTarget,strData)
#define IVBSAXContentHandler_skippedEntity(This,strName) (This)->lpVtbl->skippedEntity(This,strName)
#endif
#endif
    HRESULT WINAPI IVBSAXContentHandler_putref_documentLocator_Proxy(IVBSAXContentHandler *This,IVBSAXLocator *oLocator);
    void __RPC_STUB IVBSAXContentHandler_putref_documentLocator_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXContentHandler_startDocument_Proxy(IVBSAXContentHandler *This);
    void __RPC_STUB IVBSAXContentHandler_startDocument_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXContentHandler_endDocument_Proxy(IVBSAXContentHandler *This);
    void __RPC_STUB IVBSAXContentHandler_endDocument_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXContentHandler_startPrefixMapping_Proxy(IVBSAXContentHandler *This,BSTR *strPrefix,BSTR *strURI);
    void __RPC_STUB IVBSAXContentHandler_startPrefixMapping_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXContentHandler_endPrefixMapping_Proxy(IVBSAXContentHandler *This,BSTR *strPrefix);
    void __RPC_STUB IVBSAXContentHandler_endPrefixMapping_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXContentHandler_startElement_Proxy(IVBSAXContentHandler *This,BSTR *strNamespaceURI,BSTR *strLocalName,BSTR *strQName,IVBSAXAttributes *oAttributes);
    void __RPC_STUB IVBSAXContentHandler_startElement_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXContentHandler_endElement_Proxy(IVBSAXContentHandler *This,BSTR *strNamespaceURI,BSTR *strLocalName,BSTR *strQName);
    void __RPC_STUB IVBSAXContentHandler_endElement_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXContentHandler_characters_Proxy(IVBSAXContentHandler *This,BSTR *strChars);
    void __RPC_STUB IVBSAXContentHandler_characters_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXContentHandler_ignorableWhitespace_Proxy(IVBSAXContentHandler *This,BSTR *strChars);
    void __RPC_STUB IVBSAXContentHandler_ignorableWhitespace_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXContentHandler_processingInstruction_Proxy(IVBSAXContentHandler *This,BSTR *strTarget,BSTR *strData);
    void __RPC_STUB IVBSAXContentHandler_processingInstruction_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXContentHandler_skippedEntity_Proxy(IVBSAXContentHandler *This,BSTR *strName);
    void __RPC_STUB IVBSAXContentHandler_skippedEntity_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBSAXDTDHandler_INTERFACE_DEFINED__
#define __IVBSAXDTDHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBSAXDTDHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBSAXDTDHandler : public IDispatch {
    public:
      virtual HRESULT WINAPI notationDecl(BSTR *strName,BSTR *strPublicId,BSTR *strSystemId) = 0;
      virtual HRESULT WINAPI unparsedEntityDecl(BSTR *strName,BSTR *strPublicId,BSTR *strSystemId,BSTR *strNotationName) = 0;
    };
#else
    typedef struct IVBSAXDTDHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBSAXDTDHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBSAXDTDHandler *This);
	ULONG (WINAPI *Release)(IVBSAXDTDHandler *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBSAXDTDHandler *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBSAXDTDHandler *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBSAXDTDHandler *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBSAXDTDHandler *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *notationDecl)(IVBSAXDTDHandler *This,BSTR *strName,BSTR *strPublicId,BSTR *strSystemId);
	HRESULT (WINAPI *unparsedEntityDecl)(IVBSAXDTDHandler *This,BSTR *strName,BSTR *strPublicId,BSTR *strSystemId,BSTR *strNotationName);
      END_INTERFACE
    } IVBSAXDTDHandlerVtbl;
    struct IVBSAXDTDHandler {
      CONST_VTBL struct IVBSAXDTDHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBSAXDTDHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBSAXDTDHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBSAXDTDHandler_Release(This) (This)->lpVtbl->Release(This)
#define IVBSAXDTDHandler_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBSAXDTDHandler_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBSAXDTDHandler_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBSAXDTDHandler_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBSAXDTDHandler_notationDecl(This,strName,strPublicId,strSystemId) (This)->lpVtbl->notationDecl(This,strName,strPublicId,strSystemId)
#define IVBSAXDTDHandler_unparsedEntityDecl(This,strName,strPublicId,strSystemId,strNotationName) (This)->lpVtbl->unparsedEntityDecl(This,strName,strPublicId,strSystemId,strNotationName)
#endif
#endif
    HRESULT WINAPI IVBSAXDTDHandler_notationDecl_Proxy(IVBSAXDTDHandler *This,BSTR *strName,BSTR *strPublicId,BSTR *strSystemId);
    void __RPC_STUB IVBSAXDTDHandler_notationDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXDTDHandler_unparsedEntityDecl_Proxy(IVBSAXDTDHandler *This,BSTR *strName,BSTR *strPublicId,BSTR *strSystemId,BSTR *strNotationName);
    void __RPC_STUB IVBSAXDTDHandler_unparsedEntityDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBSAXErrorHandler_INTERFACE_DEFINED__
#define __IVBSAXErrorHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBSAXErrorHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBSAXErrorHandler : public IDispatch {
    public:
      virtual HRESULT WINAPI error(IVBSAXLocator *oLocator,BSTR *strErrorMessage,long nErrorCode) = 0;
      virtual HRESULT WINAPI fatalError(IVBSAXLocator *oLocator,BSTR *strErrorMessage,long nErrorCode) = 0;
      virtual HRESULT WINAPI ignorableWarning(IVBSAXLocator *oLocator,BSTR *strErrorMessage,long nErrorCode) = 0;
    };
#else
    typedef struct IVBSAXErrorHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBSAXErrorHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBSAXErrorHandler *This);
	ULONG (WINAPI *Release)(IVBSAXErrorHandler *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBSAXErrorHandler *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBSAXErrorHandler *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBSAXErrorHandler *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBSAXErrorHandler *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *error)(IVBSAXErrorHandler *This,IVBSAXLocator *oLocator,BSTR *strErrorMessage,long nErrorCode);
	HRESULT (WINAPI *fatalError)(IVBSAXErrorHandler *This,IVBSAXLocator *oLocator,BSTR *strErrorMessage,long nErrorCode);
	HRESULT (WINAPI *ignorableWarning)(IVBSAXErrorHandler *This,IVBSAXLocator *oLocator,BSTR *strErrorMessage,long nErrorCode);
      END_INTERFACE
    } IVBSAXErrorHandlerVtbl;
    struct IVBSAXErrorHandler {
      CONST_VTBL struct IVBSAXErrorHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBSAXErrorHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBSAXErrorHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBSAXErrorHandler_Release(This) (This)->lpVtbl->Release(This)
#define IVBSAXErrorHandler_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBSAXErrorHandler_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBSAXErrorHandler_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBSAXErrorHandler_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBSAXErrorHandler_error(This,oLocator,strErrorMessage,nErrorCode) (This)->lpVtbl->error(This,oLocator,strErrorMessage,nErrorCode)
#define IVBSAXErrorHandler_fatalError(This,oLocator,strErrorMessage,nErrorCode) (This)->lpVtbl->fatalError(This,oLocator,strErrorMessage,nErrorCode)
#define IVBSAXErrorHandler_ignorableWarning(This,oLocator,strErrorMessage,nErrorCode) (This)->lpVtbl->ignorableWarning(This,oLocator,strErrorMessage,nErrorCode)
#endif
#endif
    HRESULT WINAPI IVBSAXErrorHandler_error_Proxy(IVBSAXErrorHandler *This,IVBSAXLocator *oLocator,BSTR *strErrorMessage,long nErrorCode);
    void __RPC_STUB IVBSAXErrorHandler_error_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXErrorHandler_fatalError_Proxy(IVBSAXErrorHandler *This,IVBSAXLocator *oLocator,BSTR *strErrorMessage,long nErrorCode);
    void __RPC_STUB IVBSAXErrorHandler_fatalError_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXErrorHandler_ignorableWarning_Proxy(IVBSAXErrorHandler *This,IVBSAXLocator *oLocator,BSTR *strErrorMessage,long nErrorCode);
    void __RPC_STUB IVBSAXErrorHandler_ignorableWarning_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBSAXLexicalHandler_INTERFACE_DEFINED__
#define __IVBSAXLexicalHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBSAXLexicalHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBSAXLexicalHandler : public IDispatch {
    public:
      virtual HRESULT WINAPI startDTD(BSTR *strName,BSTR *strPublicId,BSTR *strSystemId) = 0;
      virtual HRESULT WINAPI endDTD(void) = 0;
      virtual HRESULT WINAPI startEntity(BSTR *strName) = 0;
      virtual HRESULT WINAPI endEntity(BSTR *strName) = 0;
      virtual HRESULT WINAPI startCDATA(void) = 0;
      virtual HRESULT WINAPI endCDATA(void) = 0;
      virtual HRESULT WINAPI comment(BSTR *strChars) = 0;
    };
#else
    typedef struct IVBSAXLexicalHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBSAXLexicalHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBSAXLexicalHandler *This);
	ULONG (WINAPI *Release)(IVBSAXLexicalHandler *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBSAXLexicalHandler *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBSAXLexicalHandler *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBSAXLexicalHandler *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBSAXLexicalHandler *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *startDTD)(IVBSAXLexicalHandler *This,BSTR *strName,BSTR *strPublicId,BSTR *strSystemId);
	HRESULT (WINAPI *endDTD)(IVBSAXLexicalHandler *This);
	HRESULT (WINAPI *startEntity)(IVBSAXLexicalHandler *This,BSTR *strName);
	HRESULT (WINAPI *endEntity)(IVBSAXLexicalHandler *This,BSTR *strName);
	HRESULT (WINAPI *startCDATA)(IVBSAXLexicalHandler *This);
	HRESULT (WINAPI *endCDATA)(IVBSAXLexicalHandler *This);
	HRESULT (WINAPI *comment)(IVBSAXLexicalHandler *This,BSTR *strChars);
      END_INTERFACE
    } IVBSAXLexicalHandlerVtbl;
    struct IVBSAXLexicalHandler {
      CONST_VTBL struct IVBSAXLexicalHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBSAXLexicalHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBSAXLexicalHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBSAXLexicalHandler_Release(This) (This)->lpVtbl->Release(This)
#define IVBSAXLexicalHandler_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBSAXLexicalHandler_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBSAXLexicalHandler_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBSAXLexicalHandler_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBSAXLexicalHandler_startDTD(This,strName,strPublicId,strSystemId) (This)->lpVtbl->startDTD(This,strName,strPublicId,strSystemId)
#define IVBSAXLexicalHandler_endDTD(This) (This)->lpVtbl->endDTD(This)
#define IVBSAXLexicalHandler_startEntity(This,strName) (This)->lpVtbl->startEntity(This,strName)
#define IVBSAXLexicalHandler_endEntity(This,strName) (This)->lpVtbl->endEntity(This,strName)
#define IVBSAXLexicalHandler_startCDATA(This) (This)->lpVtbl->startCDATA(This)
#define IVBSAXLexicalHandler_endCDATA(This) (This)->lpVtbl->endCDATA(This)
#define IVBSAXLexicalHandler_comment(This,strChars) (This)->lpVtbl->comment(This,strChars)
#endif
#endif
    HRESULT WINAPI IVBSAXLexicalHandler_startDTD_Proxy(IVBSAXLexicalHandler *This,BSTR *strName,BSTR *strPublicId,BSTR *strSystemId);
    void __RPC_STUB IVBSAXLexicalHandler_startDTD_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXLexicalHandler_endDTD_Proxy(IVBSAXLexicalHandler *This);
    void __RPC_STUB IVBSAXLexicalHandler_endDTD_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXLexicalHandler_startEntity_Proxy(IVBSAXLexicalHandler *This,BSTR *strName);
    void __RPC_STUB IVBSAXLexicalHandler_startEntity_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXLexicalHandler_endEntity_Proxy(IVBSAXLexicalHandler *This,BSTR *strName);
    void __RPC_STUB IVBSAXLexicalHandler_endEntity_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXLexicalHandler_startCDATA_Proxy(IVBSAXLexicalHandler *This);
    void __RPC_STUB IVBSAXLexicalHandler_startCDATA_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXLexicalHandler_endCDATA_Proxy(IVBSAXLexicalHandler *This);
    void __RPC_STUB IVBSAXLexicalHandler_endCDATA_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXLexicalHandler_comment_Proxy(IVBSAXLexicalHandler *This,BSTR *strChars);
    void __RPC_STUB IVBSAXLexicalHandler_comment_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBSAXDeclHandler_INTERFACE_DEFINED__
#define __IVBSAXDeclHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBSAXDeclHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBSAXDeclHandler : public IDispatch {
    public:
      virtual HRESULT WINAPI elementDecl(BSTR *strName,BSTR *strModel) = 0;
      virtual HRESULT WINAPI attributeDecl(BSTR *strElementName,BSTR *strAttributeName,BSTR *strType,BSTR *strValueDefault,BSTR *strValue) = 0;
      virtual HRESULT WINAPI internalEntityDecl(BSTR *strName,BSTR *strValue) = 0;
      virtual HRESULT WINAPI externalEntityDecl(BSTR *strName,BSTR *strPublicId,BSTR *strSystemId) = 0;
    };
#else
    typedef struct IVBSAXDeclHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBSAXDeclHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBSAXDeclHandler *This);
	ULONG (WINAPI *Release)(IVBSAXDeclHandler *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBSAXDeclHandler *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBSAXDeclHandler *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBSAXDeclHandler *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBSAXDeclHandler *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *elementDecl)(IVBSAXDeclHandler *This,BSTR *strName,BSTR *strModel);
	HRESULT (WINAPI *attributeDecl)(IVBSAXDeclHandler *This,BSTR *strElementName,BSTR *strAttributeName,BSTR *strType,BSTR *strValueDefault,BSTR *strValue);
	HRESULT (WINAPI *internalEntityDecl)(IVBSAXDeclHandler *This,BSTR *strName,BSTR *strValue);
	HRESULT (WINAPI *externalEntityDecl)(IVBSAXDeclHandler *This,BSTR *strName,BSTR *strPublicId,BSTR *strSystemId);
      END_INTERFACE
    } IVBSAXDeclHandlerVtbl;
    struct IVBSAXDeclHandler {
      CONST_VTBL struct IVBSAXDeclHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBSAXDeclHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBSAXDeclHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBSAXDeclHandler_Release(This) (This)->lpVtbl->Release(This)
#define IVBSAXDeclHandler_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBSAXDeclHandler_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBSAXDeclHandler_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBSAXDeclHandler_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBSAXDeclHandler_elementDecl(This,strName,strModel) (This)->lpVtbl->elementDecl(This,strName,strModel)
#define IVBSAXDeclHandler_attributeDecl(This,strElementName,strAttributeName,strType,strValueDefault,strValue) (This)->lpVtbl->attributeDecl(This,strElementName,strAttributeName,strType,strValueDefault,strValue)
#define IVBSAXDeclHandler_internalEntityDecl(This,strName,strValue) (This)->lpVtbl->internalEntityDecl(This,strName,strValue)
#define IVBSAXDeclHandler_externalEntityDecl(This,strName,strPublicId,strSystemId) (This)->lpVtbl->externalEntityDecl(This,strName,strPublicId,strSystemId)
#endif
#endif
    HRESULT WINAPI IVBSAXDeclHandler_elementDecl_Proxy(IVBSAXDeclHandler *This,BSTR *strName,BSTR *strModel);
    void __RPC_STUB IVBSAXDeclHandler_elementDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXDeclHandler_attributeDecl_Proxy(IVBSAXDeclHandler *This,BSTR *strElementName,BSTR *strAttributeName,BSTR *strType,BSTR *strValueDefault,BSTR *strValue);
    void __RPC_STUB IVBSAXDeclHandler_attributeDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXDeclHandler_internalEntityDecl_Proxy(IVBSAXDeclHandler *This,BSTR *strName,BSTR *strValue);
    void __RPC_STUB IVBSAXDeclHandler_internalEntityDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXDeclHandler_externalEntityDecl_Proxy(IVBSAXDeclHandler *This,BSTR *strName,BSTR *strPublicId,BSTR *strSystemId);
    void __RPC_STUB IVBSAXDeclHandler_externalEntityDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBSAXAttributes_INTERFACE_DEFINED__
#define __IVBSAXAttributes_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBSAXAttributes;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBSAXAttributes : public IDispatch {
    public:
      virtual HRESULT WINAPI get_length(int *nLength) = 0;
      virtual HRESULT WINAPI getURI(int nIndex,BSTR *strURI) = 0;
      virtual HRESULT WINAPI getLocalName(int nIndex,BSTR *strLocalName) = 0;
      virtual HRESULT WINAPI getQName(int nIndex,BSTR *strQName) = 0;
      virtual HRESULT WINAPI getIndexFromName(BSTR strURI,BSTR strLocalName,int *nIndex) = 0;
      virtual HRESULT WINAPI getIndexFromQName(BSTR strQName,int *nIndex) = 0;
      virtual HRESULT WINAPI getType(int nIndex,BSTR *strType) = 0;
      virtual HRESULT WINAPI getTypeFromName(BSTR strURI,BSTR strLocalName,BSTR *strType) = 0;
      virtual HRESULT WINAPI getTypeFromQName(BSTR strQName,BSTR *strType) = 0;
      virtual HRESULT WINAPI getValue(int nIndex,BSTR *strValue) = 0;
      virtual HRESULT WINAPI getValueFromName(BSTR strURI,BSTR strLocalName,BSTR *strValue) = 0;
      virtual HRESULT WINAPI getValueFromQName(BSTR strQName,BSTR *strValue) = 0;
    };
#else
    typedef struct IVBSAXAttributesVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBSAXAttributes *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBSAXAttributes *This);
	ULONG (WINAPI *Release)(IVBSAXAttributes *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBSAXAttributes *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBSAXAttributes *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBSAXAttributes *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBSAXAttributes *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_length)(IVBSAXAttributes *This,int *nLength);
	HRESULT (WINAPI *getURI)(IVBSAXAttributes *This,int nIndex,BSTR *strURI);
	HRESULT (WINAPI *getLocalName)(IVBSAXAttributes *This,int nIndex,BSTR *strLocalName);
	HRESULT (WINAPI *getQName)(IVBSAXAttributes *This,int nIndex,BSTR *strQName);
	HRESULT (WINAPI *getIndexFromName)(IVBSAXAttributes *This,BSTR strURI,BSTR strLocalName,int *nIndex);
	HRESULT (WINAPI *getIndexFromQName)(IVBSAXAttributes *This,BSTR strQName,int *nIndex);
	HRESULT (WINAPI *getType)(IVBSAXAttributes *This,int nIndex,BSTR *strType);
	HRESULT (WINAPI *getTypeFromName)(IVBSAXAttributes *This,BSTR strURI,BSTR strLocalName,BSTR *strType);
	HRESULT (WINAPI *getTypeFromQName)(IVBSAXAttributes *This,BSTR strQName,BSTR *strType);
	HRESULT (WINAPI *getValue)(IVBSAXAttributes *This,int nIndex,BSTR *strValue);
	HRESULT (WINAPI *getValueFromName)(IVBSAXAttributes *This,BSTR strURI,BSTR strLocalName,BSTR *strValue);
	HRESULT (WINAPI *getValueFromQName)(IVBSAXAttributes *This,BSTR strQName,BSTR *strValue);
      END_INTERFACE
    } IVBSAXAttributesVtbl;
    struct IVBSAXAttributes {
      CONST_VTBL struct IVBSAXAttributesVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBSAXAttributes_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBSAXAttributes_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBSAXAttributes_Release(This) (This)->lpVtbl->Release(This)
#define IVBSAXAttributes_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBSAXAttributes_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBSAXAttributes_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBSAXAttributes_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBSAXAttributes_get_length(This,nLength) (This)->lpVtbl->get_length(This,nLength)
#define IVBSAXAttributes_getURI(This,nIndex,strURI) (This)->lpVtbl->getURI(This,nIndex,strURI)
#define IVBSAXAttributes_getLocalName(This,nIndex,strLocalName) (This)->lpVtbl->getLocalName(This,nIndex,strLocalName)
#define IVBSAXAttributes_getQName(This,nIndex,strQName) (This)->lpVtbl->getQName(This,nIndex,strQName)
#define IVBSAXAttributes_getIndexFromName(This,strURI,strLocalName,nIndex) (This)->lpVtbl->getIndexFromName(This,strURI,strLocalName,nIndex)
#define IVBSAXAttributes_getIndexFromQName(This,strQName,nIndex) (This)->lpVtbl->getIndexFromQName(This,strQName,nIndex)
#define IVBSAXAttributes_getType(This,nIndex,strType) (This)->lpVtbl->getType(This,nIndex,strType)
#define IVBSAXAttributes_getTypeFromName(This,strURI,strLocalName,strType) (This)->lpVtbl->getTypeFromName(This,strURI,strLocalName,strType)
#define IVBSAXAttributes_getTypeFromQName(This,strQName,strType) (This)->lpVtbl->getTypeFromQName(This,strQName,strType)
#define IVBSAXAttributes_getValue(This,nIndex,strValue) (This)->lpVtbl->getValue(This,nIndex,strValue)
#define IVBSAXAttributes_getValueFromName(This,strURI,strLocalName,strValue) (This)->lpVtbl->getValueFromName(This,strURI,strLocalName,strValue)
#define IVBSAXAttributes_getValueFromQName(This,strQName,strValue) (This)->lpVtbl->getValueFromQName(This,strQName,strValue)
#endif
#endif
    HRESULT WINAPI IVBSAXAttributes_get_length_Proxy(IVBSAXAttributes *This,int *nLength);
    void __RPC_STUB IVBSAXAttributes_get_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getURI_Proxy(IVBSAXAttributes *This,int nIndex,BSTR *strURI);
    void __RPC_STUB IVBSAXAttributes_getURI_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getLocalName_Proxy(IVBSAXAttributes *This,int nIndex,BSTR *strLocalName);
    void __RPC_STUB IVBSAXAttributes_getLocalName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getQName_Proxy(IVBSAXAttributes *This,int nIndex,BSTR *strQName);
    void __RPC_STUB IVBSAXAttributes_getQName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getIndexFromName_Proxy(IVBSAXAttributes *This,BSTR strURI,BSTR strLocalName,int *nIndex);
    void __RPC_STUB IVBSAXAttributes_getIndexFromName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getIndexFromQName_Proxy(IVBSAXAttributes *This,BSTR strQName,int *nIndex);
    void __RPC_STUB IVBSAXAttributes_getIndexFromQName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getType_Proxy(IVBSAXAttributes *This,int nIndex,BSTR *strType);
    void __RPC_STUB IVBSAXAttributes_getType_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getTypeFromName_Proxy(IVBSAXAttributes *This,BSTR strURI,BSTR strLocalName,BSTR *strType);
    void __RPC_STUB IVBSAXAttributes_getTypeFromName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getTypeFromQName_Proxy(IVBSAXAttributes *This,BSTR strQName,BSTR *strType);
    void __RPC_STUB IVBSAXAttributes_getTypeFromQName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getValue_Proxy(IVBSAXAttributes *This,int nIndex,BSTR *strValue);
    void __RPC_STUB IVBSAXAttributes_getValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getValueFromName_Proxy(IVBSAXAttributes *This,BSTR strURI,BSTR strLocalName,BSTR *strValue);
    void __RPC_STUB IVBSAXAttributes_getValueFromName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBSAXAttributes_getValueFromQName_Proxy(IVBSAXAttributes *This,BSTR strQName,BSTR *strValue);
    void __RPC_STUB IVBSAXAttributes_getValueFromQName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IMXWriter_INTERFACE_DEFINED__
#define __IMXWriter_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IMXWriter;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IMXWriter : public IDispatch {
    public:
      virtual HRESULT WINAPI put_output(VARIANT varDestination) = 0;
      virtual HRESULT WINAPI get_output(VARIANT *varDestination) = 0;
      virtual HRESULT WINAPI put_encoding(BSTR strEncoding) = 0;
      virtual HRESULT WINAPI get_encoding(BSTR *strEncoding) = 0;
      virtual HRESULT WINAPI put_byteOrderMark(VARIANT_BOOL fWriteByteOrderMark) = 0;
      virtual HRESULT WINAPI get_byteOrderMark(VARIANT_BOOL *fWriteByteOrderMark) = 0;
      virtual HRESULT WINAPI put_indent(VARIANT_BOOL fIndentMode) = 0;
      virtual HRESULT WINAPI get_indent(VARIANT_BOOL *fIndentMode) = 0;
      virtual HRESULT WINAPI put_standalone(VARIANT_BOOL fValue) = 0;
      virtual HRESULT WINAPI get_standalone(VARIANT_BOOL *fValue) = 0;
      virtual HRESULT WINAPI put_omitXMLDeclaration(VARIANT_BOOL fValue) = 0;
      virtual HRESULT WINAPI get_omitXMLDeclaration(VARIANT_BOOL *fValue) = 0;
      virtual HRESULT WINAPI put_version(BSTR strVersion) = 0;
      virtual HRESULT WINAPI get_version(BSTR *strVersion) = 0;
      virtual HRESULT WINAPI put_disableOutputEscaping(VARIANT_BOOL fValue) = 0;
      virtual HRESULT WINAPI get_disableOutputEscaping(VARIANT_BOOL *fValue) = 0;
      virtual HRESULT WINAPI flush(void) = 0;
    };
#else
    typedef struct IMXWriterVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IMXWriter *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IMXWriter *This);
	ULONG (WINAPI *Release)(IMXWriter *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IMXWriter *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IMXWriter *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IMXWriter *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IMXWriter *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *put_output)(IMXWriter *This,VARIANT varDestination);
	HRESULT (WINAPI *get_output)(IMXWriter *This,VARIANT *varDestination);
	HRESULT (WINAPI *put_encoding)(IMXWriter *This,BSTR strEncoding);
	HRESULT (WINAPI *get_encoding)(IMXWriter *This,BSTR *strEncoding);
	HRESULT (WINAPI *put_byteOrderMark)(IMXWriter *This,VARIANT_BOOL fWriteByteOrderMark);
	HRESULT (WINAPI *get_byteOrderMark)(IMXWriter *This,VARIANT_BOOL *fWriteByteOrderMark);
	HRESULT (WINAPI *put_indent)(IMXWriter *This,VARIANT_BOOL fIndentMode);
	HRESULT (WINAPI *get_indent)(IMXWriter *This,VARIANT_BOOL *fIndentMode);
	HRESULT (WINAPI *put_standalone)(IMXWriter *This,VARIANT_BOOL fValue);
	HRESULT (WINAPI *get_standalone)(IMXWriter *This,VARIANT_BOOL *fValue);
	HRESULT (WINAPI *put_omitXMLDeclaration)(IMXWriter *This,VARIANT_BOOL fValue);
	HRESULT (WINAPI *get_omitXMLDeclaration)(IMXWriter *This,VARIANT_BOOL *fValue);
	HRESULT (WINAPI *put_version)(IMXWriter *This,BSTR strVersion);
	HRESULT (WINAPI *get_version)(IMXWriter *This,BSTR *strVersion);
	HRESULT (WINAPI *put_disableOutputEscaping)(IMXWriter *This,VARIANT_BOOL fValue);
	HRESULT (WINAPI *get_disableOutputEscaping)(IMXWriter *This,VARIANT_BOOL *fValue);
	HRESULT (WINAPI *flush)(IMXWriter *This);
      END_INTERFACE
    } IMXWriterVtbl;
    struct IMXWriter {
      CONST_VTBL struct IMXWriterVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IMXWriter_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IMXWriter_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IMXWriter_Release(This) (This)->lpVtbl->Release(This)
#define IMXWriter_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IMXWriter_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IMXWriter_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IMXWriter_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IMXWriter_put_output(This,varDestination) (This)->lpVtbl->put_output(This,varDestination)
#define IMXWriter_get_output(This,varDestination) (This)->lpVtbl->get_output(This,varDestination)
#define IMXWriter_put_encoding(This,strEncoding) (This)->lpVtbl->put_encoding(This,strEncoding)
#define IMXWriter_get_encoding(This,strEncoding) (This)->lpVtbl->get_encoding(This,strEncoding)
#define IMXWriter_put_byteOrderMark(This,fWriteByteOrderMark) (This)->lpVtbl->put_byteOrderMark(This,fWriteByteOrderMark)
#define IMXWriter_get_byteOrderMark(This,fWriteByteOrderMark) (This)->lpVtbl->get_byteOrderMark(This,fWriteByteOrderMark)
#define IMXWriter_put_indent(This,fIndentMode) (This)->lpVtbl->put_indent(This,fIndentMode)
#define IMXWriter_get_indent(This,fIndentMode) (This)->lpVtbl->get_indent(This,fIndentMode)
#define IMXWriter_put_standalone(This,fValue) (This)->lpVtbl->put_standalone(This,fValue)
#define IMXWriter_get_standalone(This,fValue) (This)->lpVtbl->get_standalone(This,fValue)
#define IMXWriter_put_omitXMLDeclaration(This,fValue) (This)->lpVtbl->put_omitXMLDeclaration(This,fValue)
#define IMXWriter_get_omitXMLDeclaration(This,fValue) (This)->lpVtbl->get_omitXMLDeclaration(This,fValue)
#define IMXWriter_put_version(This,strVersion) (This)->lpVtbl->put_version(This,strVersion)
#define IMXWriter_get_version(This,strVersion) (This)->lpVtbl->get_version(This,strVersion)
#define IMXWriter_put_disableOutputEscaping(This,fValue) (This)->lpVtbl->put_disableOutputEscaping(This,fValue)
#define IMXWriter_get_disableOutputEscaping(This,fValue) (This)->lpVtbl->get_disableOutputEscaping(This,fValue)
#define IMXWriter_flush(This) (This)->lpVtbl->flush(This)
#endif
#endif
    HRESULT WINAPI IMXWriter_put_output_Proxy(IMXWriter *This,VARIANT varDestination);
    void __RPC_STUB IMXWriter_put_output_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_get_output_Proxy(IMXWriter *This,VARIANT *varDestination);
    void __RPC_STUB IMXWriter_get_output_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_put_encoding_Proxy(IMXWriter *This,BSTR strEncoding);
    void __RPC_STUB IMXWriter_put_encoding_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_get_encoding_Proxy(IMXWriter *This,BSTR *strEncoding);
    void __RPC_STUB IMXWriter_get_encoding_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_put_byteOrderMark_Proxy(IMXWriter *This,VARIANT_BOOL fWriteByteOrderMark);
    void __RPC_STUB IMXWriter_put_byteOrderMark_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_get_byteOrderMark_Proxy(IMXWriter *This,VARIANT_BOOL *fWriteByteOrderMark);
    void __RPC_STUB IMXWriter_get_byteOrderMark_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_put_indent_Proxy(IMXWriter *This,VARIANT_BOOL fIndentMode);
    void __RPC_STUB IMXWriter_put_indent_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_get_indent_Proxy(IMXWriter *This,VARIANT_BOOL *fIndentMode);
    void __RPC_STUB IMXWriter_get_indent_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_put_standalone_Proxy(IMXWriter *This,VARIANT_BOOL fValue);
    void __RPC_STUB IMXWriter_put_standalone_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_get_standalone_Proxy(IMXWriter *This,VARIANT_BOOL *fValue);
    void __RPC_STUB IMXWriter_get_standalone_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_put_omitXMLDeclaration_Proxy(IMXWriter *This,VARIANT_BOOL fValue);
    void __RPC_STUB IMXWriter_put_omitXMLDeclaration_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_get_omitXMLDeclaration_Proxy(IMXWriter *This,VARIANT_BOOL *fValue);
    void __RPC_STUB IMXWriter_get_omitXMLDeclaration_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_put_version_Proxy(IMXWriter *This,BSTR strVersion);
    void __RPC_STUB IMXWriter_put_version_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_get_version_Proxy(IMXWriter *This,BSTR *strVersion);
    void __RPC_STUB IMXWriter_get_version_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_put_disableOutputEscaping_Proxy(IMXWriter *This,VARIANT_BOOL fValue);
    void __RPC_STUB IMXWriter_put_disableOutputEscaping_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_get_disableOutputEscaping_Proxy(IMXWriter *This,VARIANT_BOOL *fValue);
    void __RPC_STUB IMXWriter_get_disableOutputEscaping_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXWriter_flush_Proxy(IMXWriter *This);
    void __RPC_STUB IMXWriter_flush_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IMXAttributes_INTERFACE_DEFINED__
#define __IMXAttributes_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IMXAttributes;

#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IMXAttributes : public IDispatch {
    public:
      virtual HRESULT WINAPI addAttribute(BSTR strURI,BSTR strLocalName,BSTR strQName,BSTR strType,BSTR strValue) = 0;
      virtual HRESULT WINAPI addAttributeFromIndex(VARIANT varAtts,int nIndex) = 0;
      virtual HRESULT WINAPI clear(void) = 0;
      virtual HRESULT WINAPI removeAttribute(int nIndex) = 0;
      virtual HRESULT WINAPI setAttribute(int nIndex,BSTR strURI,BSTR strLocalName,BSTR strQName,BSTR strType,BSTR strValue) = 0;
      virtual HRESULT WINAPI setAttributes(VARIANT varAtts) = 0;
      virtual HRESULT WINAPI setLocalName(int nIndex,BSTR strLocalName) = 0;
      virtual HRESULT WINAPI setQName(int nIndex,BSTR strQName) = 0;
      virtual HRESULT WINAPI setType(int nIndex,BSTR strType) = 0;
      virtual HRESULT WINAPI setURI(int nIndex,BSTR strURI) = 0;
      virtual HRESULT WINAPI setValue(int nIndex,BSTR strValue) = 0;
    };
#else
    typedef struct IMXAttributesVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IMXAttributes *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IMXAttributes *This);
	ULONG (WINAPI *Release)(IMXAttributes *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IMXAttributes *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IMXAttributes *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IMXAttributes *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IMXAttributes *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *addAttribute)(IMXAttributes *This,BSTR strURI,BSTR strLocalName,BSTR strQName,BSTR strType,BSTR strValue);
	HRESULT (WINAPI *addAttributeFromIndex)(IMXAttributes *This,VARIANT varAtts,int nIndex);
	HRESULT (WINAPI *clear)(IMXAttributes *This);
	HRESULT (WINAPI *removeAttribute)(IMXAttributes *This,int nIndex);
	HRESULT (WINAPI *setAttribute)(IMXAttributes *This,int nIndex,BSTR strURI,BSTR strLocalName,BSTR strQName,BSTR strType,BSTR strValue);
	HRESULT (WINAPI *setAttributes)(IMXAttributes *This,VARIANT varAtts);
	HRESULT (WINAPI *setLocalName)(IMXAttributes *This,int nIndex,BSTR strLocalName);
	HRESULT (WINAPI *setQName)(IMXAttributes *This,int nIndex,BSTR strQName);
	HRESULT (WINAPI *setType)(IMXAttributes *This,int nIndex,BSTR strType);
	HRESULT (WINAPI *setURI)(IMXAttributes *This,int nIndex,BSTR strURI);
	HRESULT (WINAPI *setValue)(IMXAttributes *This,int nIndex,BSTR strValue);
      END_INTERFACE
    } IMXAttributesVtbl;
    struct IMXAttributes {
      CONST_VTBL struct IMXAttributesVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IMXAttributes_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IMXAttributes_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IMXAttributes_Release(This) (This)->lpVtbl->Release(This)
#define IMXAttributes_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IMXAttributes_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IMXAttributes_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IMXAttributes_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IMXAttributes_addAttribute(This,strURI,strLocalName,strQName,strType,strValue) (This)->lpVtbl->addAttribute(This,strURI,strLocalName,strQName,strType,strValue)
#define IMXAttributes_addAttributeFromIndex(This,varAtts,nIndex) (This)->lpVtbl->addAttributeFromIndex(This,varAtts,nIndex)
#define IMXAttributes_clear(This) (This)->lpVtbl->clear(This)
#define IMXAttributes_removeAttribute(This,nIndex) (This)->lpVtbl->removeAttribute(This,nIndex)
#define IMXAttributes_setAttribute(This,nIndex,strURI,strLocalName,strQName,strType,strValue) (This)->lpVtbl->setAttribute(This,nIndex,strURI,strLocalName,strQName,strType,strValue)
#define IMXAttributes_setAttributes(This,varAtts) (This)->lpVtbl->setAttributes(This,varAtts)
#define IMXAttributes_setLocalName(This,nIndex,strLocalName) (This)->lpVtbl->setLocalName(This,nIndex,strLocalName)
#define IMXAttributes_setQName(This,nIndex,strQName) (This)->lpVtbl->setQName(This,nIndex,strQName)
#define IMXAttributes_setType(This,nIndex,strType) (This)->lpVtbl->setType(This,nIndex,strType)
#define IMXAttributes_setURI(This,nIndex,strURI) (This)->lpVtbl->setURI(This,nIndex,strURI)
#define IMXAttributes_setValue(This,nIndex,strValue) (This)->lpVtbl->setValue(This,nIndex,strValue)
#endif
#endif
    HRESULT WINAPI IMXAttributes_addAttribute_Proxy(IMXAttributes *This,BSTR strURI,BSTR strLocalName,BSTR strQName,BSTR strType,BSTR strValue);
    void __RPC_STUB IMXAttributes_addAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXAttributes_addAttributeFromIndex_Proxy(IMXAttributes *This,VARIANT varAtts,int nIndex);
    void __RPC_STUB IMXAttributes_addAttributeFromIndex_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXAttributes_clear_Proxy(IMXAttributes *This);
    void __RPC_STUB IMXAttributes_clear_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXAttributes_removeAttribute_Proxy(IMXAttributes *This,int nIndex);
    void __RPC_STUB IMXAttributes_removeAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXAttributes_setAttribute_Proxy(IMXAttributes *This,int nIndex,BSTR strURI,BSTR strLocalName,BSTR strQName,BSTR strType,BSTR strValue);
    void __RPC_STUB IMXAttributes_setAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXAttributes_setAttributes_Proxy(IMXAttributes *This,VARIANT varAtts);
    void __RPC_STUB IMXAttributes_setAttributes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXAttributes_setLocalName_Proxy(IMXAttributes *This,int nIndex,BSTR strLocalName);
    void __RPC_STUB IMXAttributes_setLocalName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXAttributes_setQName_Proxy(IMXAttributes *This,int nIndex,BSTR strQName);
    void __RPC_STUB IMXAttributes_setQName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXAttributes_setType_Proxy(IMXAttributes *This,int nIndex,BSTR strType);
    void __RPC_STUB IMXAttributes_setType_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXAttributes_setURI_Proxy(IMXAttributes *This,int nIndex,BSTR strURI);
    void __RPC_STUB IMXAttributes_setURI_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXAttributes_setValue_Proxy(IMXAttributes *This,int nIndex,BSTR strValue);
    void __RPC_STUB IMXAttributes_setValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IMXReaderControl_INTERFACE_DEFINED__
#define __IMXReaderControl_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IMXReaderControl;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IMXReaderControl : public IDispatch {
    public:
      virtual HRESULT WINAPI abort(void) = 0;
      virtual HRESULT WINAPI resume(void) = 0;
      virtual HRESULT WINAPI suspend(void) = 0;
    };
#else
    typedef struct IMXReaderControlVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IMXReaderControl *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IMXReaderControl *This);
	ULONG (WINAPI *Release)(IMXReaderControl *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IMXReaderControl *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IMXReaderControl *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IMXReaderControl *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IMXReaderControl *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *abort)(IMXReaderControl *This);
	HRESULT (WINAPI *resume)(IMXReaderControl *This);
	HRESULT (WINAPI *suspend)(IMXReaderControl *This);
      END_INTERFACE
    } IMXReaderControlVtbl;
    struct IMXReaderControl {
      CONST_VTBL struct IMXReaderControlVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IMXReaderControl_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IMXReaderControl_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IMXReaderControl_Release(This) (This)->lpVtbl->Release(This)
#define IMXReaderControl_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IMXReaderControl_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IMXReaderControl_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IMXReaderControl_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IMXReaderControl_abort(This) (This)->lpVtbl->abort(This)
#define IMXReaderControl_resume(This) (This)->lpVtbl->resume(This)
#define IMXReaderControl_suspend(This) (This)->lpVtbl->suspend(This)
#endif
#endif
    HRESULT WINAPI IMXReaderControl_abort_Proxy(IMXReaderControl *This);
    void __RPC_STUB IMXReaderControl_abort_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXReaderControl_resume_Proxy(IMXReaderControl *This);
    void __RPC_STUB IMXReaderControl_resume_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXReaderControl_suspend_Proxy(IMXReaderControl *This);
    void __RPC_STUB IMXReaderControl_suspend_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IMXSchemaDeclHandler_INTERFACE_DEFINED__
#define __IMXSchemaDeclHandler_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IMXSchemaDeclHandler;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IMXSchemaDeclHandler : public IDispatch {
    public:
      virtual HRESULT WINAPI schemaElementDecl(ISchemaElement *oSchemaElement) = 0;
    };
#else
    typedef struct IMXSchemaDeclHandlerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IMXSchemaDeclHandler *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IMXSchemaDeclHandler *This);
	ULONG (WINAPI *Release)(IMXSchemaDeclHandler *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IMXSchemaDeclHandler *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IMXSchemaDeclHandler *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IMXSchemaDeclHandler *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IMXSchemaDeclHandler *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *schemaElementDecl)(IMXSchemaDeclHandler *This,ISchemaElement *oSchemaElement);
      END_INTERFACE
    } IMXSchemaDeclHandlerVtbl;
    struct IMXSchemaDeclHandler {
      CONST_VTBL struct IMXSchemaDeclHandlerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IMXSchemaDeclHandler_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IMXSchemaDeclHandler_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IMXSchemaDeclHandler_Release(This) (This)->lpVtbl->Release(This)
#define IMXSchemaDeclHandler_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IMXSchemaDeclHandler_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IMXSchemaDeclHandler_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IMXSchemaDeclHandler_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IMXSchemaDeclHandler_schemaElementDecl(This,oSchemaElement) (This)->lpVtbl->schemaElementDecl(This,oSchemaElement)
#endif
#endif
    HRESULT WINAPI IMXSchemaDeclHandler_schemaElementDecl_Proxy(IMXSchemaDeclHandler *This,ISchemaElement *oSchemaElement);
    void __RPC_STUB IMXSchemaDeclHandler_schemaElementDecl_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMSchemaCollection2_INTERFACE_DEFINED__
#define __IXMLDOMSchemaCollection2_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMSchemaCollection2;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMSchemaCollection2 : public IXMLDOMSchemaCollection {
    public:
      virtual HRESULT WINAPI validate(void) = 0;
      virtual HRESULT WINAPI put_validateOnLoad(VARIANT_BOOL validateOnLoad) = 0;
      virtual HRESULT WINAPI get_validateOnLoad(VARIANT_BOOL *validateOnLoad) = 0;
      virtual HRESULT WINAPI getSchema(BSTR namespaceURI,ISchema **schema) = 0;
      virtual HRESULT WINAPI getDeclaration(IXMLDOMNode *node,ISchemaItem **item) = 0;
    };
#else
    typedef struct IXMLDOMSchemaCollection2Vtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMSchemaCollection2 *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMSchemaCollection2 *This);
	ULONG (WINAPI *Release)(IXMLDOMSchemaCollection2 *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMSchemaCollection2 *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMSchemaCollection2 *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMSchemaCollection2 *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMSchemaCollection2 *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *add)(IXMLDOMSchemaCollection2 *This,BSTR namespaceURI,VARIANT var);
	HRESULT (WINAPI *get)(IXMLDOMSchemaCollection2 *This,BSTR namespaceURI,IXMLDOMNode **schemaNode);
	HRESULT (WINAPI *remove)(IXMLDOMSchemaCollection2 *This,BSTR namespaceURI);
	HRESULT (WINAPI *get_length)(IXMLDOMSchemaCollection2 *This,long *length);
	HRESULT (WINAPI *get_namespaceURI)(IXMLDOMSchemaCollection2 *This,long index,BSTR *length);
	HRESULT (WINAPI *addCollection)(IXMLDOMSchemaCollection2 *This,IXMLDOMSchemaCollection *otherCollection);
	HRESULT (WINAPI *get__newEnum)(IXMLDOMSchemaCollection2 *This,IUnknown **ppUnk);
	HRESULT (WINAPI *validate)(IXMLDOMSchemaCollection2 *This);
	HRESULT (WINAPI *put_validateOnLoad)(IXMLDOMSchemaCollection2 *This,VARIANT_BOOL validateOnLoad);
	HRESULT (WINAPI *get_validateOnLoad)(IXMLDOMSchemaCollection2 *This,VARIANT_BOOL *validateOnLoad);
	HRESULT (WINAPI *getSchema)(IXMLDOMSchemaCollection2 *This,BSTR namespaceURI,ISchema **schema);
	HRESULT (WINAPI *getDeclaration)(IXMLDOMSchemaCollection2 *This,IXMLDOMNode *node,ISchemaItem **item);
      END_INTERFACE
    } IXMLDOMSchemaCollection2Vtbl;
    struct IXMLDOMSchemaCollection2 {
      CONST_VTBL struct IXMLDOMSchemaCollection2Vtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMSchemaCollection2_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMSchemaCollection2_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMSchemaCollection2_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMSchemaCollection2_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMSchemaCollection2_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMSchemaCollection2_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMSchemaCollection2_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMSchemaCollection2_add(This,namespaceURI,var) (This)->lpVtbl->add(This,namespaceURI,var)
#define IXMLDOMSchemaCollection2_get(This,namespaceURI,schemaNode) (This)->lpVtbl->get(This,namespaceURI,schemaNode)
#define IXMLDOMSchemaCollection2_remove(This,namespaceURI) (This)->lpVtbl->remove(This,namespaceURI)
#define IXMLDOMSchemaCollection2_get_length(This,length) (This)->lpVtbl->get_length(This,length)
#define IXMLDOMSchemaCollection2_get_namespaceURI(This,index,length) (This)->lpVtbl->get_namespaceURI(This,index,length)
#define IXMLDOMSchemaCollection2_addCollection(This,otherCollection) (This)->lpVtbl->addCollection(This,otherCollection)
#define IXMLDOMSchemaCollection2_get__newEnum(This,ppUnk) (This)->lpVtbl->get__newEnum(This,ppUnk)
#define IXMLDOMSchemaCollection2_validate(This) (This)->lpVtbl->validate(This)
#define IXMLDOMSchemaCollection2_put_validateOnLoad(This,validateOnLoad) (This)->lpVtbl->put_validateOnLoad(This,validateOnLoad)
#define IXMLDOMSchemaCollection2_get_validateOnLoad(This,validateOnLoad) (This)->lpVtbl->get_validateOnLoad(This,validateOnLoad)
#define IXMLDOMSchemaCollection2_getSchema(This,namespaceURI,schema) (This)->lpVtbl->getSchema(This,namespaceURI,schema)
#define IXMLDOMSchemaCollection2_getDeclaration(This,node,item) (This)->lpVtbl->getDeclaration(This,node,item)
#endif
#endif
    HRESULT WINAPI IXMLDOMSchemaCollection2_validate_Proxy(IXMLDOMSchemaCollection2 *This);
    void __RPC_STUB IXMLDOMSchemaCollection2_validate_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSchemaCollection2_put_validateOnLoad_Proxy(IXMLDOMSchemaCollection2 *This,VARIANT_BOOL validateOnLoad);
    void __RPC_STUB IXMLDOMSchemaCollection2_put_validateOnLoad_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSchemaCollection2_get_validateOnLoad_Proxy(IXMLDOMSchemaCollection2 *This,VARIANT_BOOL *validateOnLoad);
    void __RPC_STUB IXMLDOMSchemaCollection2_get_validateOnLoad_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSchemaCollection2_getSchema_Proxy(IXMLDOMSchemaCollection2 *This,BSTR namespaceURI,ISchema **schema);
    void __RPC_STUB IXMLDOMSchemaCollection2_getSchema_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSchemaCollection2_getDeclaration_Proxy(IXMLDOMSchemaCollection2 *This,IXMLDOMNode *node,ISchemaItem **item);
    void __RPC_STUB IXMLDOMSchemaCollection2_getDeclaration_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaStringCollection_INTERFACE_DEFINED__
#define __ISchemaStringCollection_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaStringCollection;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaStringCollection : public IDispatch {
    public:
      virtual HRESULT WINAPI get_item(long index,BSTR *bstr) = 0;
      virtual HRESULT WINAPI get_length(long *length) = 0;
      virtual HRESULT WINAPI get__newEnum(IUnknown **ppunk) = 0;
    };
#else
    typedef struct ISchemaStringCollectionVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaStringCollection *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaStringCollection *This);
	ULONG (WINAPI *Release)(ISchemaStringCollection *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaStringCollection *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaStringCollection *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaStringCollection *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaStringCollection *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_item)(ISchemaStringCollection *This,long index,BSTR *bstr);
	HRESULT (WINAPI *get_length)(ISchemaStringCollection *This,long *length);
	HRESULT (WINAPI *get__newEnum)(ISchemaStringCollection *This,IUnknown **ppunk);
      END_INTERFACE
    } ISchemaStringCollectionVtbl;
    struct ISchemaStringCollection {
      CONST_VTBL struct ISchemaStringCollectionVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaStringCollection_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaStringCollection_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaStringCollection_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaStringCollection_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaStringCollection_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaStringCollection_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaStringCollection_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaStringCollection_get_item(This,index,bstr) (This)->lpVtbl->get_item(This,index,bstr)
#define ISchemaStringCollection_get_length(This,length) (This)->lpVtbl->get_length(This,length)
#define ISchemaStringCollection_get__newEnum(This,ppunk) (This)->lpVtbl->get__newEnum(This,ppunk)
#endif
#endif
    HRESULT WINAPI ISchemaStringCollection_get_item_Proxy(ISchemaStringCollection *This,long index,BSTR *bstr);
    void __RPC_STUB ISchemaStringCollection_get_item_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaStringCollection_get_length_Proxy(ISchemaStringCollection *This,long *length);
    void __RPC_STUB ISchemaStringCollection_get_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaStringCollection_get__newEnum_Proxy(ISchemaStringCollection *This,IUnknown **ppunk);
    void __RPC_STUB ISchemaStringCollection_get__newEnum_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaItemCollection_INTERFACE_DEFINED__
#define __ISchemaItemCollection_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaItemCollection;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaItemCollection : public IDispatch {
    public:
      virtual HRESULT WINAPI get_item(long index,ISchemaItem **item) = 0;
      virtual HRESULT WINAPI itemByName(BSTR name,ISchemaItem **item) = 0;
      virtual HRESULT WINAPI itemByQName(BSTR name,BSTR namespaceURI,ISchemaItem **item) = 0;
      virtual HRESULT WINAPI get_length(long *length) = 0;
      virtual HRESULT WINAPI get__newEnum(IUnknown **ppunk) = 0;
    };
#else
    typedef struct ISchemaItemCollectionVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaItemCollection *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaItemCollection *This);
	ULONG (WINAPI *Release)(ISchemaItemCollection *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaItemCollection *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaItemCollection *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaItemCollection *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaItemCollection *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_item)(ISchemaItemCollection *This,long index,ISchemaItem **item);
	HRESULT (WINAPI *itemByName)(ISchemaItemCollection *This,BSTR name,ISchemaItem **item);
	HRESULT (WINAPI *itemByQName)(ISchemaItemCollection *This,BSTR name,BSTR namespaceURI,ISchemaItem **item);
	HRESULT (WINAPI *get_length)(ISchemaItemCollection *This,long *length);
	HRESULT (WINAPI *get__newEnum)(ISchemaItemCollection *This,IUnknown **ppunk);
      END_INTERFACE
    } ISchemaItemCollectionVtbl;
    struct ISchemaItemCollection {
      CONST_VTBL struct ISchemaItemCollectionVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaItemCollection_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaItemCollection_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaItemCollection_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaItemCollection_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaItemCollection_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaItemCollection_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaItemCollection_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaItemCollection_get_item(This,index,item) (This)->lpVtbl->get_item(This,index,item)
#define ISchemaItemCollection_itemByName(This,name,item) (This)->lpVtbl->itemByName(This,name,item)
#define ISchemaItemCollection_itemByQName(This,name,namespaceURI,item) (This)->lpVtbl->itemByQName(This,name,namespaceURI,item)
#define ISchemaItemCollection_get_length(This,length) (This)->lpVtbl->get_length(This,length)
#define ISchemaItemCollection_get__newEnum(This,ppunk) (This)->lpVtbl->get__newEnum(This,ppunk)
#endif
#endif
    HRESULT WINAPI ISchemaItemCollection_get_item_Proxy(ISchemaItemCollection *This,long index,ISchemaItem **item);
    void __RPC_STUB ISchemaItemCollection_get_item_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaItemCollection_itemByName_Proxy(ISchemaItemCollection *This,BSTR name,ISchemaItem **item);
    void __RPC_STUB ISchemaItemCollection_itemByName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaItemCollection_itemByQName_Proxy(ISchemaItemCollection *This,BSTR name,BSTR namespaceURI,ISchemaItem **item);
    void __RPC_STUB ISchemaItemCollection_itemByQName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaItemCollection_get_length_Proxy(ISchemaItemCollection *This,long *length);
    void __RPC_STUB ISchemaItemCollection_get_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaItemCollection_get__newEnum_Proxy(ISchemaItemCollection *This,IUnknown **ppunk);
    void __RPC_STUB ISchemaItemCollection_get__newEnum_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaItem_INTERFACE_DEFINED__
#define __ISchemaItem_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaItem;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaItem : public IDispatch {
    public:
      virtual HRESULT WINAPI get_name(BSTR *name) = 0;
      virtual HRESULT WINAPI get_namespaceURI(BSTR *namespaceURI) = 0;
      virtual HRESULT WINAPI get_schema(ISchema **schema) = 0;
      virtual HRESULT WINAPI get_id(BSTR *id) = 0;
      virtual HRESULT WINAPI get_itemType(SOMITEMTYPE *itemType) = 0;
      virtual HRESULT WINAPI get_unhandledAttributes(IVBSAXAttributes **attributes) = 0;
      virtual HRESULT WINAPI writeAnnotation(IUnknown *annotationSink,VARIANT_BOOL *isWritten) = 0;
    };
#else
    typedef struct ISchemaItemVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaItem *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaItem *This);
	ULONG (WINAPI *Release)(ISchemaItem *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaItem *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaItem *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaItem *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaItem *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaItem *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaItem *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaItem *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaItem *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaItem *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaItem *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaItem *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
      END_INTERFACE
    } ISchemaItemVtbl;
    struct ISchemaItem {
      CONST_VTBL struct ISchemaItemVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaItem_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaItem_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaItem_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaItem_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaItem_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaItem_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaItem_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaItem_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaItem_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaItem_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaItem_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaItem_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaItem_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaItem_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#endif
#endif
    HRESULT WINAPI ISchemaItem_get_name_Proxy(ISchemaItem *This,BSTR *name);
    void __RPC_STUB ISchemaItem_get_name_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaItem_get_namespaceURI_Proxy(ISchemaItem *This,BSTR *namespaceURI);
    void __RPC_STUB ISchemaItem_get_namespaceURI_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaItem_get_schema_Proxy(ISchemaItem *This,ISchema **schema);
    void __RPC_STUB ISchemaItem_get_schema_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaItem_get_id_Proxy(ISchemaItem *This,BSTR *id);
    void __RPC_STUB ISchemaItem_get_id_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaItem_get_itemType_Proxy(ISchemaItem *This,SOMITEMTYPE *itemType);
    void __RPC_STUB ISchemaItem_get_itemType_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaItem_get_unhandledAttributes_Proxy(ISchemaItem *This,IVBSAXAttributes **attributes);
    void __RPC_STUB ISchemaItem_get_unhandledAttributes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaItem_writeAnnotation_Proxy(ISchemaItem *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
    void __RPC_STUB ISchemaItem_writeAnnotation_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchema_INTERFACE_DEFINED__
#define __ISchema_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchema;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchema : public ISchemaItem {
    public:
      virtual HRESULT WINAPI get_targetNamespace(BSTR *targetNamespace) = 0;
      virtual HRESULT WINAPI get_version(BSTR *version) = 0;
      virtual HRESULT WINAPI get_types(ISchemaItemCollection **types) = 0;
      virtual HRESULT WINAPI get_elements(ISchemaItemCollection **elements) = 0;
      virtual HRESULT WINAPI get_attributes(ISchemaItemCollection **attributes) = 0;
      virtual HRESULT WINAPI get_attributeGroups(ISchemaItemCollection **attributeGroups) = 0;
      virtual HRESULT WINAPI get_modelGroups(ISchemaItemCollection **modelGroups) = 0;
      virtual HRESULT WINAPI get_notations(ISchemaItemCollection **notations) = 0;
      virtual HRESULT WINAPI get_schemaLocations(ISchemaStringCollection **schemaLocations) = 0;
    };
#else
    typedef struct ISchemaVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchema *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchema *This);
	ULONG (WINAPI *Release)(ISchema *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchema *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchema *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchema *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchema *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchema *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchema *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchema *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchema *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchema *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchema *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchema *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_targetNamespace)(ISchema *This,BSTR *targetNamespace);
	HRESULT (WINAPI *get_version)(ISchema *This,BSTR *version);
	HRESULT (WINAPI *get_types)(ISchema *This,ISchemaItemCollection **types);
	HRESULT (WINAPI *get_elements)(ISchema *This,ISchemaItemCollection **elements);
	HRESULT (WINAPI *get_attributes)(ISchema *This,ISchemaItemCollection **attributes);
	HRESULT (WINAPI *get_attributeGroups)(ISchema *This,ISchemaItemCollection **attributeGroups);
	HRESULT (WINAPI *get_modelGroups)(ISchema *This,ISchemaItemCollection **modelGroups);
	HRESULT (WINAPI *get_notations)(ISchema *This,ISchemaItemCollection **notations);
	HRESULT (WINAPI *get_schemaLocations)(ISchema *This,ISchemaStringCollection **schemaLocations);
      END_INTERFACE
    } ISchemaVtbl;
    struct ISchema {
      CONST_VTBL struct ISchemaVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchema_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchema_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchema_Release(This) (This)->lpVtbl->Release(This)
#define ISchema_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchema_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchema_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchema_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchema_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchema_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchema_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchema_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchema_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchema_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchema_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchema_get_targetNamespace(This,targetNamespace) (This)->lpVtbl->get_targetNamespace(This,targetNamespace)
#define ISchema_get_version(This,version) (This)->lpVtbl->get_version(This,version)
#define ISchema_get_types(This,types) (This)->lpVtbl->get_types(This,types)
#define ISchema_get_elements(This,elements) (This)->lpVtbl->get_elements(This,elements)
#define ISchema_get_attributes(This,attributes) (This)->lpVtbl->get_attributes(This,attributes)
#define ISchema_get_attributeGroups(This,attributeGroups) (This)->lpVtbl->get_attributeGroups(This,attributeGroups)
#define ISchema_get_modelGroups(This,modelGroups) (This)->lpVtbl->get_modelGroups(This,modelGroups)
#define ISchema_get_notations(This,notations) (This)->lpVtbl->get_notations(This,notations)
#define ISchema_get_schemaLocations(This,schemaLocations) (This)->lpVtbl->get_schemaLocations(This,schemaLocations)
#endif
#endif
    HRESULT WINAPI ISchema_get_targetNamespace_Proxy(ISchema *This,BSTR *targetNamespace);
    void __RPC_STUB ISchema_get_targetNamespace_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchema_get_version_Proxy(ISchema *This,BSTR *version);
    void __RPC_STUB ISchema_get_version_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchema_get_types_Proxy(ISchema *This,ISchemaItemCollection **types);
    void __RPC_STUB ISchema_get_types_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchema_get_elements_Proxy(ISchema *This,ISchemaItemCollection **elements);
    void __RPC_STUB ISchema_get_elements_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchema_get_attributes_Proxy(ISchema *This,ISchemaItemCollection **attributes);
    void __RPC_STUB ISchema_get_attributes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchema_get_attributeGroups_Proxy(ISchema *This,ISchemaItemCollection **attributeGroups);
    void __RPC_STUB ISchema_get_attributeGroups_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchema_get_modelGroups_Proxy(ISchema *This,ISchemaItemCollection **modelGroups);
    void __RPC_STUB ISchema_get_modelGroups_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchema_get_notations_Proxy(ISchema *This,ISchemaItemCollection **notations);
    void __RPC_STUB ISchema_get_notations_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchema_get_schemaLocations_Proxy(ISchema *This,ISchemaStringCollection **schemaLocations);
    void __RPC_STUB ISchema_get_schemaLocations_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaParticle_INTERFACE_DEFINED__
#define __ISchemaParticle_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaParticle;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaParticle : public ISchemaItem {
    public:
      virtual HRESULT WINAPI get_minOccurs(VARIANT *minOccurs) = 0;
      virtual HRESULT WINAPI get_maxOccurs(VARIANT *maxOccurs) = 0;
    };
#else
    typedef struct ISchemaParticleVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaParticle *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaParticle *This);
	ULONG (WINAPI *Release)(ISchemaParticle *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaParticle *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaParticle *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaParticle *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaParticle *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaParticle *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaParticle *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaParticle *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaParticle *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaParticle *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaParticle *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaParticle *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_minOccurs)(ISchemaParticle *This,VARIANT *minOccurs);
	HRESULT (WINAPI *get_maxOccurs)(ISchemaParticle *This,VARIANT *maxOccurs);
      END_INTERFACE
    } ISchemaParticleVtbl;
    struct ISchemaParticle {
      CONST_VTBL struct ISchemaParticleVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaParticle_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaParticle_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaParticle_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaParticle_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaParticle_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaParticle_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaParticle_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaParticle_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaParticle_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaParticle_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaParticle_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaParticle_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaParticle_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaParticle_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchemaParticle_get_minOccurs(This,minOccurs) (This)->lpVtbl->get_minOccurs(This,minOccurs)
#define ISchemaParticle_get_maxOccurs(This,maxOccurs) (This)->lpVtbl->get_maxOccurs(This,maxOccurs)
#endif
#endif
    HRESULT WINAPI ISchemaParticle_get_minOccurs_Proxy(ISchemaParticle *This,VARIANT *minOccurs);
    void __RPC_STUB ISchemaParticle_get_minOccurs_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaParticle_get_maxOccurs_Proxy(ISchemaParticle *This,VARIANT *maxOccurs);
    void __RPC_STUB ISchemaParticle_get_maxOccurs_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaAttribute_INTERFACE_DEFINED__
#define __ISchemaAttribute_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaAttribute;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaAttribute : public ISchemaItem {
    public:
      virtual HRESULT WINAPI get_type(ISchemaType **type) = 0;
      virtual HRESULT WINAPI get_scope(ISchemaComplexType **scope) = 0;
      virtual HRESULT WINAPI get_defaultValue(BSTR *defaultValue) = 0;
      virtual HRESULT WINAPI get_fixedValue(BSTR *fixedValue) = 0;
      virtual HRESULT WINAPI get_use(SCHEMAUSE *use) = 0;
      virtual HRESULT WINAPI get_isReference(VARIANT_BOOL *reference) = 0;
    };
#else
    typedef struct ISchemaAttributeVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaAttribute *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaAttribute *This);
	ULONG (WINAPI *Release)(ISchemaAttribute *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaAttribute *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaAttribute *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaAttribute *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaAttribute *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaAttribute *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaAttribute *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaAttribute *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaAttribute *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaAttribute *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaAttribute *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaAttribute *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_type)(ISchemaAttribute *This,ISchemaType **type);
	HRESULT (WINAPI *get_scope)(ISchemaAttribute *This,ISchemaComplexType **scope);
	HRESULT (WINAPI *get_defaultValue)(ISchemaAttribute *This,BSTR *defaultValue);
	HRESULT (WINAPI *get_fixedValue)(ISchemaAttribute *This,BSTR *fixedValue);
	HRESULT (WINAPI *get_use)(ISchemaAttribute *This,SCHEMAUSE *use);
	HRESULT (WINAPI *get_isReference)(ISchemaAttribute *This,VARIANT_BOOL *reference);
      END_INTERFACE
    } ISchemaAttributeVtbl;
    struct ISchemaAttribute {
      CONST_VTBL struct ISchemaAttributeVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaAttribute_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaAttribute_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaAttribute_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaAttribute_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaAttribute_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaAttribute_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaAttribute_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaAttribute_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaAttribute_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaAttribute_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaAttribute_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaAttribute_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaAttribute_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaAttribute_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchemaAttribute_get_type(This,type) (This)->lpVtbl->get_type(This,type)
#define ISchemaAttribute_get_scope(This,scope) (This)->lpVtbl->get_scope(This,scope)
#define ISchemaAttribute_get_defaultValue(This,defaultValue) (This)->lpVtbl->get_defaultValue(This,defaultValue)
#define ISchemaAttribute_get_fixedValue(This,fixedValue) (This)->lpVtbl->get_fixedValue(This,fixedValue)
#define ISchemaAttribute_get_use(This,use) (This)->lpVtbl->get_use(This,use)
#define ISchemaAttribute_get_isReference(This,reference) (This)->lpVtbl->get_isReference(This,reference)
#endif
#endif
    HRESULT WINAPI ISchemaAttribute_get_type_Proxy(ISchemaAttribute *This,ISchemaType **type);
    void __RPC_STUB ISchemaAttribute_get_type_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaAttribute_get_scope_Proxy(ISchemaAttribute *This,ISchemaComplexType **scope);
    void __RPC_STUB ISchemaAttribute_get_scope_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaAttribute_get_defaultValue_Proxy(ISchemaAttribute *This,BSTR *defaultValue);
    void __RPC_STUB ISchemaAttribute_get_defaultValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaAttribute_get_fixedValue_Proxy(ISchemaAttribute *This,BSTR *fixedValue);
    void __RPC_STUB ISchemaAttribute_get_fixedValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaAttribute_get_use_Proxy(ISchemaAttribute *This,SCHEMAUSE *use);
    void __RPC_STUB ISchemaAttribute_get_use_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaAttribute_get_isReference_Proxy(ISchemaAttribute *This,VARIANT_BOOL *reference);
    void __RPC_STUB ISchemaAttribute_get_isReference_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaElement_INTERFACE_DEFINED__
#define __ISchemaElement_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaElement;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaElement : public ISchemaParticle {
    public:
      virtual HRESULT WINAPI get_type(ISchemaType **type) = 0;
      virtual HRESULT WINAPI get_scope(ISchemaComplexType **scope) = 0;
      virtual HRESULT WINAPI get_defaultValue(BSTR *defaultValue) = 0;
      virtual HRESULT WINAPI get_fixedValue(BSTR *fixedValue) = 0;
      virtual HRESULT WINAPI get_isNillable(VARIANT_BOOL *nillable) = 0;
      virtual HRESULT WINAPI get_identityConstraints(ISchemaItemCollection **constraints) = 0;
      virtual HRESULT WINAPI get_substitutionGroup(ISchemaElement **element) = 0;
      virtual HRESULT WINAPI get_substitutionGroupExclusions(SCHEMADERIVATIONMETHOD *exclusions) = 0;
      virtual HRESULT WINAPI get_disallowedSubstitutions(SCHEMADERIVATIONMETHOD *disallowed) = 0;
      virtual HRESULT WINAPI get_isAbstract(VARIANT_BOOL *abstract) = 0;
      virtual HRESULT WINAPI get_isReference(VARIANT_BOOL *reference) = 0;
    };
#else
    typedef struct ISchemaElementVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaElement *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaElement *This);
	ULONG (WINAPI *Release)(ISchemaElement *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaElement *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaElement *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaElement *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaElement *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaElement *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaElement *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaElement *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaElement *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaElement *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaElement *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaElement *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_minOccurs)(ISchemaElement *This,VARIANT *minOccurs);
	HRESULT (WINAPI *get_maxOccurs)(ISchemaElement *This,VARIANT *maxOccurs);
	HRESULT (WINAPI *get_type)(ISchemaElement *This,ISchemaType **type);
	HRESULT (WINAPI *get_scope)(ISchemaElement *This,ISchemaComplexType **scope);
	HRESULT (WINAPI *get_defaultValue)(ISchemaElement *This,BSTR *defaultValue);
	HRESULT (WINAPI *get_fixedValue)(ISchemaElement *This,BSTR *fixedValue);
	HRESULT (WINAPI *get_isNillable)(ISchemaElement *This,VARIANT_BOOL *nillable);
	HRESULT (WINAPI *get_identityConstraints)(ISchemaElement *This,ISchemaItemCollection **constraints);
	HRESULT (WINAPI *get_substitutionGroup)(ISchemaElement *This,ISchemaElement **element);
	HRESULT (WINAPI *get_substitutionGroupExclusions)(ISchemaElement *This,SCHEMADERIVATIONMETHOD *exclusions);
	HRESULT (WINAPI *get_disallowedSubstitutions)(ISchemaElement *This,SCHEMADERIVATIONMETHOD *disallowed);
	HRESULT (WINAPI *get_isAbstract)(ISchemaElement *This,VARIANT_BOOL *abstract);
	HRESULT (WINAPI *get_isReference)(ISchemaElement *This,VARIANT_BOOL *reference);
      END_INTERFACE
    } ISchemaElementVtbl;
    struct ISchemaElement {
      CONST_VTBL struct ISchemaElementVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaElement_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaElement_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaElement_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaElement_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaElement_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaElement_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaElement_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaElement_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaElement_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaElement_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaElement_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaElement_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaElement_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaElement_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchemaElement_get_minOccurs(This,minOccurs) (This)->lpVtbl->get_minOccurs(This,minOccurs)
#define ISchemaElement_get_maxOccurs(This,maxOccurs) (This)->lpVtbl->get_maxOccurs(This,maxOccurs)
#define ISchemaElement_get_type(This,type) (This)->lpVtbl->get_type(This,type)
#define ISchemaElement_get_scope(This,scope) (This)->lpVtbl->get_scope(This,scope)
#define ISchemaElement_get_defaultValue(This,defaultValue) (This)->lpVtbl->get_defaultValue(This,defaultValue)
#define ISchemaElement_get_fixedValue(This,fixedValue) (This)->lpVtbl->get_fixedValue(This,fixedValue)
#define ISchemaElement_get_isNillable(This,nillable) (This)->lpVtbl->get_isNillable(This,nillable)
#define ISchemaElement_get_identityConstraints(This,constraints) (This)->lpVtbl->get_identityConstraints(This,constraints)
#define ISchemaElement_get_substitutionGroup(This,element) (This)->lpVtbl->get_substitutionGroup(This,element)
#define ISchemaElement_get_substitutionGroupExclusions(This,exclusions) (This)->lpVtbl->get_substitutionGroupExclusions(This,exclusions)
#define ISchemaElement_get_disallowedSubstitutions(This,disallowed) (This)->lpVtbl->get_disallowedSubstitutions(This,disallowed)
#define ISchemaElement_get_isAbstract(This,abstract) (This)->lpVtbl->get_isAbstract(This,abstract)
#define ISchemaElement_get_isReference(This,reference) (This)->lpVtbl->get_isReference(This,reference)
#endif
#endif
    HRESULT WINAPI ISchemaElement_get_type_Proxy(ISchemaElement *This,ISchemaType **type);
    void __RPC_STUB ISchemaElement_get_type_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaElement_get_scope_Proxy(ISchemaElement *This,ISchemaComplexType **scope);
    void __RPC_STUB ISchemaElement_get_scope_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaElement_get_defaultValue_Proxy(ISchemaElement *This,BSTR *defaultValue);
    void __RPC_STUB ISchemaElement_get_defaultValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaElement_get_fixedValue_Proxy(ISchemaElement *This,BSTR *fixedValue);
    void __RPC_STUB ISchemaElement_get_fixedValue_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaElement_get_isNillable_Proxy(ISchemaElement *This,VARIANT_BOOL *nillable);
    void __RPC_STUB ISchemaElement_get_isNillable_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaElement_get_identityConstraints_Proxy(ISchemaElement *This,ISchemaItemCollection **constraints);
    void __RPC_STUB ISchemaElement_get_identityConstraints_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaElement_get_substitutionGroup_Proxy(ISchemaElement *This,ISchemaElement **element);
    void __RPC_STUB ISchemaElement_get_substitutionGroup_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaElement_get_substitutionGroupExclusions_Proxy(ISchemaElement *This,SCHEMADERIVATIONMETHOD *exclusions);
    void __RPC_STUB ISchemaElement_get_substitutionGroupExclusions_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaElement_get_disallowedSubstitutions_Proxy(ISchemaElement *This,SCHEMADERIVATIONMETHOD *disallowed);
    void __RPC_STUB ISchemaElement_get_disallowedSubstitutions_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaElement_get_isAbstract_Proxy(ISchemaElement *This,VARIANT_BOOL *abstract);
    void __RPC_STUB ISchemaElement_get_isAbstract_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaElement_get_isReference_Proxy(ISchemaElement *This,VARIANT_BOOL *reference);
    void __RPC_STUB ISchemaElement_get_isReference_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaType_INTERFACE_DEFINED__
#define __ISchemaType_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaType;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaType : public ISchemaItem {
    public:
      virtual HRESULT WINAPI get_baseTypes(ISchemaItemCollection **baseTypes) = 0;
      virtual HRESULT WINAPI get_final(SCHEMADERIVATIONMETHOD *final) = 0;
      virtual HRESULT WINAPI get_variety(SCHEMATYPEVARIETY *variety) = 0;
      virtual HRESULT WINAPI get_derivedBy(SCHEMADERIVATIONMETHOD *derivedBy) = 0;
      virtual HRESULT WINAPI isValid(BSTR data,VARIANT_BOOL *valid) = 0;
      virtual HRESULT WINAPI get_minExclusive(BSTR *minExclusive) = 0;
      virtual HRESULT WINAPI get_minInclusive(BSTR *minInclusive) = 0;
      virtual HRESULT WINAPI get_maxExclusive(BSTR *maxExclusive) = 0;
      virtual HRESULT WINAPI get_maxInclusive(BSTR *maxInclusive) = 0;
      virtual HRESULT WINAPI get_totalDigits(VARIANT *totalDigits) = 0;
      virtual HRESULT WINAPI get_fractionDigits(VARIANT *fractionDigits) = 0;
      virtual HRESULT WINAPI get_length(VARIANT *length) = 0;
      virtual HRESULT WINAPI get_minLength(VARIANT *minLength) = 0;
      virtual HRESULT WINAPI get_maxLength(VARIANT *maxLength) = 0;
      virtual HRESULT WINAPI get_enumeration(ISchemaStringCollection **enumeration) = 0;
      virtual HRESULT WINAPI get_whitespace(SCHEMAWHITESPACE *whitespace) = 0;
      virtual HRESULT WINAPI get_patterns(ISchemaStringCollection **patterns) = 0;
    };
#else
    typedef struct ISchemaTypeVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaType *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaType *This);
	ULONG (WINAPI *Release)(ISchemaType *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaType *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaType *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaType *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaType *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaType *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaType *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaType *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaType *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaType *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaType *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaType *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_baseTypes)(ISchemaType *This,ISchemaItemCollection **baseTypes);
	HRESULT (WINAPI *get_final)(ISchemaType *This,SCHEMADERIVATIONMETHOD *final);
	HRESULT (WINAPI *get_variety)(ISchemaType *This,SCHEMATYPEVARIETY *variety);
	HRESULT (WINAPI *get_derivedBy)(ISchemaType *This,SCHEMADERIVATIONMETHOD *derivedBy);
	HRESULT (WINAPI *isValid)(ISchemaType *This,BSTR data,VARIANT_BOOL *valid);
	HRESULT (WINAPI *get_minExclusive)(ISchemaType *This,BSTR *minExclusive);
	HRESULT (WINAPI *get_minInclusive)(ISchemaType *This,BSTR *minInclusive);
	HRESULT (WINAPI *get_maxExclusive)(ISchemaType *This,BSTR *maxExclusive);
	HRESULT (WINAPI *get_maxInclusive)(ISchemaType *This,BSTR *maxInclusive);
	HRESULT (WINAPI *get_totalDigits)(ISchemaType *This,VARIANT *totalDigits);
	HRESULT (WINAPI *get_fractionDigits)(ISchemaType *This,VARIANT *fractionDigits);
	HRESULT (WINAPI *get_length)(ISchemaType *This,VARIANT *length);
	HRESULT (WINAPI *get_minLength)(ISchemaType *This,VARIANT *minLength);
	HRESULT (WINAPI *get_maxLength)(ISchemaType *This,VARIANT *maxLength);
	HRESULT (WINAPI *get_enumeration)(ISchemaType *This,ISchemaStringCollection **enumeration);
	HRESULT (WINAPI *get_whitespace)(ISchemaType *This,SCHEMAWHITESPACE *whitespace);
	HRESULT (WINAPI *get_patterns)(ISchemaType *This,ISchemaStringCollection **patterns);
      END_INTERFACE
    } ISchemaTypeVtbl;
    struct ISchemaType {
      CONST_VTBL struct ISchemaTypeVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaType_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaType_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaType_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaType_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaType_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaType_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaType_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaType_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaType_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaType_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaType_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaType_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaType_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaType_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchemaType_get_baseTypes(This,baseTypes) (This)->lpVtbl->get_baseTypes(This,baseTypes)
#define ISchemaType_get_final(This,final) (This)->lpVtbl->get_final(This,final)
#define ISchemaType_get_variety(This,variety) (This)->lpVtbl->get_variety(This,variety)
#define ISchemaType_get_derivedBy(This,derivedBy) (This)->lpVtbl->get_derivedBy(This,derivedBy)
#define ISchemaType_isValid(This,data,valid) (This)->lpVtbl->isValid(This,data,valid)
#define ISchemaType_get_minExclusive(This,minExclusive) (This)->lpVtbl->get_minExclusive(This,minExclusive)
#define ISchemaType_get_minInclusive(This,minInclusive) (This)->lpVtbl->get_minInclusive(This,minInclusive)
#define ISchemaType_get_maxExclusive(This,maxExclusive) (This)->lpVtbl->get_maxExclusive(This,maxExclusive)
#define ISchemaType_get_maxInclusive(This,maxInclusive) (This)->lpVtbl->get_maxInclusive(This,maxInclusive)
#define ISchemaType_get_totalDigits(This,totalDigits) (This)->lpVtbl->get_totalDigits(This,totalDigits)
#define ISchemaType_get_fractionDigits(This,fractionDigits) (This)->lpVtbl->get_fractionDigits(This,fractionDigits)
#define ISchemaType_get_length(This,length) (This)->lpVtbl->get_length(This,length)
#define ISchemaType_get_minLength(This,minLength) (This)->lpVtbl->get_minLength(This,minLength)
#define ISchemaType_get_maxLength(This,maxLength) (This)->lpVtbl->get_maxLength(This,maxLength)
#define ISchemaType_get_enumeration(This,enumeration) (This)->lpVtbl->get_enumeration(This,enumeration)
#define ISchemaType_get_whitespace(This,whitespace) (This)->lpVtbl->get_whitespace(This,whitespace)
#define ISchemaType_get_patterns(This,patterns) (This)->lpVtbl->get_patterns(This,patterns)
#endif
#endif
    HRESULT WINAPI ISchemaType_get_baseTypes_Proxy(ISchemaType *This,ISchemaItemCollection **baseTypes);
    void __RPC_STUB ISchemaType_get_baseTypes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_final_Proxy(ISchemaType *This,SCHEMADERIVATIONMETHOD *final);
    void __RPC_STUB ISchemaType_get_final_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_variety_Proxy(ISchemaType *This,SCHEMATYPEVARIETY *variety);
    void __RPC_STUB ISchemaType_get_variety_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_derivedBy_Proxy(ISchemaType *This,SCHEMADERIVATIONMETHOD *derivedBy);
    void __RPC_STUB ISchemaType_get_derivedBy_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_isValid_Proxy(ISchemaType *This,BSTR data,VARIANT_BOOL *valid);
    void __RPC_STUB ISchemaType_isValid_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_minExclusive_Proxy(ISchemaType *This,BSTR *minExclusive);
    void __RPC_STUB ISchemaType_get_minExclusive_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_minInclusive_Proxy(ISchemaType *This,BSTR *minInclusive);
    void __RPC_STUB ISchemaType_get_minInclusive_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_maxExclusive_Proxy(ISchemaType *This,BSTR *maxExclusive);
    void __RPC_STUB ISchemaType_get_maxExclusive_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_maxInclusive_Proxy(ISchemaType *This,BSTR *maxInclusive);
    void __RPC_STUB ISchemaType_get_maxInclusive_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_totalDigits_Proxy(ISchemaType *This,VARIANT *totalDigits);
    void __RPC_STUB ISchemaType_get_totalDigits_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_fractionDigits_Proxy(ISchemaType *This,VARIANT *fractionDigits);
    void __RPC_STUB ISchemaType_get_fractionDigits_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_length_Proxy(ISchemaType *This,VARIANT *length);
    void __RPC_STUB ISchemaType_get_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_minLength_Proxy(ISchemaType *This,VARIANT *minLength);
    void __RPC_STUB ISchemaType_get_minLength_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_maxLength_Proxy(ISchemaType *This,VARIANT *maxLength);
    void __RPC_STUB ISchemaType_get_maxLength_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_enumeration_Proxy(ISchemaType *This,ISchemaStringCollection **enumeration);
    void __RPC_STUB ISchemaType_get_enumeration_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_whitespace_Proxy(ISchemaType *This,SCHEMAWHITESPACE *whitespace);
    void __RPC_STUB ISchemaType_get_whitespace_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaType_get_patterns_Proxy(ISchemaType *This,ISchemaStringCollection **patterns);
    void __RPC_STUB ISchemaType_get_patterns_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaComplexType_INTERFACE_DEFINED__
#define __ISchemaComplexType_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaComplexType;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaComplexType : public ISchemaType {
    public:
      virtual HRESULT WINAPI get_isAbstract(VARIANT_BOOL *abstract) = 0;
      virtual HRESULT WINAPI get_anyAttribute(ISchemaAny **anyAttribute) = 0;
      virtual HRESULT WINAPI get_attributes(ISchemaItemCollection **attributes) = 0;
      virtual HRESULT WINAPI get_contentType(SCHEMACONTENTTYPE *contentType) = 0;
      virtual HRESULT WINAPI get_contentModel(ISchemaModelGroup **contentModel) = 0;
      virtual HRESULT WINAPI get_prohibitedSubstitutions(SCHEMADERIVATIONMETHOD *prohibited) = 0;
    };
#else
    typedef struct ISchemaComplexTypeVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaComplexType *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaComplexType *This);
	ULONG (WINAPI *Release)(ISchemaComplexType *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaComplexType *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaComplexType *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaComplexType *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaComplexType *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaComplexType *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaComplexType *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaComplexType *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaComplexType *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaComplexType *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaComplexType *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaComplexType *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_baseTypes)(ISchemaComplexType *This,ISchemaItemCollection **baseTypes);
	HRESULT (WINAPI *get_final)(ISchemaComplexType *This,SCHEMADERIVATIONMETHOD *final);
	HRESULT (WINAPI *get_variety)(ISchemaComplexType *This,SCHEMATYPEVARIETY *variety);
	HRESULT (WINAPI *get_derivedBy)(ISchemaComplexType *This,SCHEMADERIVATIONMETHOD *derivedBy);
	HRESULT (WINAPI *isValid)(ISchemaComplexType *This,BSTR data,VARIANT_BOOL *valid);
	HRESULT (WINAPI *get_minExclusive)(ISchemaComplexType *This,BSTR *minExclusive);
	HRESULT (WINAPI *get_minInclusive)(ISchemaComplexType *This,BSTR *minInclusive);
	HRESULT (WINAPI *get_maxExclusive)(ISchemaComplexType *This,BSTR *maxExclusive);
	HRESULT (WINAPI *get_maxInclusive)(ISchemaComplexType *This,BSTR *maxInclusive);
	HRESULT (WINAPI *get_totalDigits)(ISchemaComplexType *This,VARIANT *totalDigits);
	HRESULT (WINAPI *get_fractionDigits)(ISchemaComplexType *This,VARIANT *fractionDigits);
	HRESULT (WINAPI *get_length)(ISchemaComplexType *This,VARIANT *length);
	HRESULT (WINAPI *get_minLength)(ISchemaComplexType *This,VARIANT *minLength);
	HRESULT (WINAPI *get_maxLength)(ISchemaComplexType *This,VARIANT *maxLength);
	HRESULT (WINAPI *get_enumeration)(ISchemaComplexType *This,ISchemaStringCollection **enumeration);
	HRESULT (WINAPI *get_whitespace)(ISchemaComplexType *This,SCHEMAWHITESPACE *whitespace);
	HRESULT (WINAPI *get_patterns)(ISchemaComplexType *This,ISchemaStringCollection **patterns);
	HRESULT (WINAPI *get_isAbstract)(ISchemaComplexType *This,VARIANT_BOOL *abstract);
	HRESULT (WINAPI *get_anyAttribute)(ISchemaComplexType *This,ISchemaAny **anyAttribute);
	HRESULT (WINAPI *get_attributes)(ISchemaComplexType *This,ISchemaItemCollection **attributes);
	HRESULT (WINAPI *get_contentType)(ISchemaComplexType *This,SCHEMACONTENTTYPE *contentType);
	HRESULT (WINAPI *get_contentModel)(ISchemaComplexType *This,ISchemaModelGroup **contentModel);
	HRESULT (WINAPI *get_prohibitedSubstitutions)(ISchemaComplexType *This,SCHEMADERIVATIONMETHOD *prohibited);
      END_INTERFACE
    } ISchemaComplexTypeVtbl;
    struct ISchemaComplexType {
      CONST_VTBL struct ISchemaComplexTypeVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaComplexType_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaComplexType_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaComplexType_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaComplexType_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaComplexType_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaComplexType_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaComplexType_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaComplexType_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaComplexType_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaComplexType_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaComplexType_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaComplexType_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaComplexType_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaComplexType_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchemaComplexType_get_baseTypes(This,baseTypes) (This)->lpVtbl->get_baseTypes(This,baseTypes)
#define ISchemaComplexType_get_final(This,final) (This)->lpVtbl->get_final(This,final)
#define ISchemaComplexType_get_variety(This,variety) (This)->lpVtbl->get_variety(This,variety)
#define ISchemaComplexType_get_derivedBy(This,derivedBy) (This)->lpVtbl->get_derivedBy(This,derivedBy)
#define ISchemaComplexType_isValid(This,data,valid) (This)->lpVtbl->isValid(This,data,valid)
#define ISchemaComplexType_get_minExclusive(This,minExclusive) (This)->lpVtbl->get_minExclusive(This,minExclusive)
#define ISchemaComplexType_get_minInclusive(This,minInclusive) (This)->lpVtbl->get_minInclusive(This,minInclusive)
#define ISchemaComplexType_get_maxExclusive(This,maxExclusive) (This)->lpVtbl->get_maxExclusive(This,maxExclusive)
#define ISchemaComplexType_get_maxInclusive(This,maxInclusive) (This)->lpVtbl->get_maxInclusive(This,maxInclusive)
#define ISchemaComplexType_get_totalDigits(This,totalDigits) (This)->lpVtbl->get_totalDigits(This,totalDigits)
#define ISchemaComplexType_get_fractionDigits(This,fractionDigits) (This)->lpVtbl->get_fractionDigits(This,fractionDigits)
#define ISchemaComplexType_get_length(This,length) (This)->lpVtbl->get_length(This,length)
#define ISchemaComplexType_get_minLength(This,minLength) (This)->lpVtbl->get_minLength(This,minLength)
#define ISchemaComplexType_get_maxLength(This,maxLength) (This)->lpVtbl->get_maxLength(This,maxLength)
#define ISchemaComplexType_get_enumeration(This,enumeration) (This)->lpVtbl->get_enumeration(This,enumeration)
#define ISchemaComplexType_get_whitespace(This,whitespace) (This)->lpVtbl->get_whitespace(This,whitespace)
#define ISchemaComplexType_get_patterns(This,patterns) (This)->lpVtbl->get_patterns(This,patterns)
#define ISchemaComplexType_get_isAbstract(This,abstract) (This)->lpVtbl->get_isAbstract(This,abstract)
#define ISchemaComplexType_get_anyAttribute(This,anyAttribute) (This)->lpVtbl->get_anyAttribute(This,anyAttribute)
#define ISchemaComplexType_get_attributes(This,attributes) (This)->lpVtbl->get_attributes(This,attributes)
#define ISchemaComplexType_get_contentType(This,contentType) (This)->lpVtbl->get_contentType(This,contentType)
#define ISchemaComplexType_get_contentModel(This,contentModel) (This)->lpVtbl->get_contentModel(This,contentModel)
#define ISchemaComplexType_get_prohibitedSubstitutions(This,prohibited) (This)->lpVtbl->get_prohibitedSubstitutions(This,prohibited)
#endif
#endif
    HRESULT WINAPI ISchemaComplexType_get_isAbstract_Proxy(ISchemaComplexType *This,VARIANT_BOOL *abstract);
    void __RPC_STUB ISchemaComplexType_get_isAbstract_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaComplexType_get_anyAttribute_Proxy(ISchemaComplexType *This,ISchemaAny **anyAttribute);
    void __RPC_STUB ISchemaComplexType_get_anyAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaComplexType_get_attributes_Proxy(ISchemaComplexType *This,ISchemaItemCollection **attributes);
    void __RPC_STUB ISchemaComplexType_get_attributes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaComplexType_get_contentType_Proxy(ISchemaComplexType *This,SCHEMACONTENTTYPE *contentType);
    void __RPC_STUB ISchemaComplexType_get_contentType_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaComplexType_get_contentModel_Proxy(ISchemaComplexType *This,ISchemaModelGroup **contentModel);
    void __RPC_STUB ISchemaComplexType_get_contentModel_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaComplexType_get_prohibitedSubstitutions_Proxy(ISchemaComplexType *This,SCHEMADERIVATIONMETHOD *prohibited);
    void __RPC_STUB ISchemaComplexType_get_prohibitedSubstitutions_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaAttributeGroup_INTERFACE_DEFINED__
#define __ISchemaAttributeGroup_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaAttributeGroup;

#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaAttributeGroup : public ISchemaItem {
    public:
      virtual HRESULT WINAPI get_anyAttribute(ISchemaAny **anyAttribute) = 0;
      virtual HRESULT WINAPI get_attributes(ISchemaItemCollection **attributes) = 0;
    };
#else
    typedef struct ISchemaAttributeGroupVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaAttributeGroup *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaAttributeGroup *This);
	ULONG (WINAPI *Release)(ISchemaAttributeGroup *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaAttributeGroup *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaAttributeGroup *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaAttributeGroup *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaAttributeGroup *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaAttributeGroup *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaAttributeGroup *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaAttributeGroup *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaAttributeGroup *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaAttributeGroup *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaAttributeGroup *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaAttributeGroup *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_anyAttribute)(ISchemaAttributeGroup *This,ISchemaAny **anyAttribute);
	HRESULT (WINAPI *get_attributes)(ISchemaAttributeGroup *This,ISchemaItemCollection **attributes);
      END_INTERFACE
    } ISchemaAttributeGroupVtbl;
    struct ISchemaAttributeGroup {
      CONST_VTBL struct ISchemaAttributeGroupVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaAttributeGroup_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaAttributeGroup_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaAttributeGroup_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaAttributeGroup_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaAttributeGroup_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaAttributeGroup_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaAttributeGroup_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaAttributeGroup_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaAttributeGroup_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaAttributeGroup_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaAttributeGroup_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaAttributeGroup_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaAttributeGroup_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaAttributeGroup_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchemaAttributeGroup_get_anyAttribute(This,anyAttribute) (This)->lpVtbl->get_anyAttribute(This,anyAttribute)
#define ISchemaAttributeGroup_get_attributes(This,attributes) (This)->lpVtbl->get_attributes(This,attributes)
#endif
#endif
    HRESULT WINAPI ISchemaAttributeGroup_get_anyAttribute_Proxy(ISchemaAttributeGroup *This,ISchemaAny **anyAttribute);
    void __RPC_STUB ISchemaAttributeGroup_get_anyAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaAttributeGroup_get_attributes_Proxy(ISchemaAttributeGroup *This,ISchemaItemCollection **attributes);
    void __RPC_STUB ISchemaAttributeGroup_get_attributes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaModelGroup_INTERFACE_DEFINED__
#define __ISchemaModelGroup_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaModelGroup;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaModelGroup : public ISchemaParticle {
    public:
      virtual HRESULT WINAPI get_particles(ISchemaItemCollection **particles) = 0;
    };
#else
    typedef struct ISchemaModelGroupVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaModelGroup *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaModelGroup *This);
	ULONG (WINAPI *Release)(ISchemaModelGroup *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaModelGroup *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaModelGroup *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaModelGroup *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaModelGroup *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaModelGroup *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaModelGroup *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaModelGroup *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaModelGroup *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaModelGroup *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaModelGroup *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaModelGroup *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_minOccurs)(ISchemaModelGroup *This,VARIANT *minOccurs);
	HRESULT (WINAPI *get_maxOccurs)(ISchemaModelGroup *This,VARIANT *maxOccurs);
	HRESULT (WINAPI *get_particles)(ISchemaModelGroup *This,ISchemaItemCollection **particles);
      END_INTERFACE
    } ISchemaModelGroupVtbl;
    struct ISchemaModelGroup {
      CONST_VTBL struct ISchemaModelGroupVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaModelGroup_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaModelGroup_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaModelGroup_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaModelGroup_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaModelGroup_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaModelGroup_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaModelGroup_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaModelGroup_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaModelGroup_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaModelGroup_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaModelGroup_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaModelGroup_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaModelGroup_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaModelGroup_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchemaModelGroup_get_minOccurs(This,minOccurs) (This)->lpVtbl->get_minOccurs(This,minOccurs)
#define ISchemaModelGroup_get_maxOccurs(This,maxOccurs) (This)->lpVtbl->get_maxOccurs(This,maxOccurs)
#define ISchemaModelGroup_get_particles(This,particles) (This)->lpVtbl->get_particles(This,particles)
#endif
#endif
    HRESULT WINAPI ISchemaModelGroup_get_particles_Proxy(ISchemaModelGroup *This,ISchemaItemCollection **particles);
    void __RPC_STUB ISchemaModelGroup_get_particles_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaAny_INTERFACE_DEFINED__
#define __ISchemaAny_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaAny;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaAny : public ISchemaParticle {
    public:
      virtual HRESULT WINAPI get_namespaces(ISchemaStringCollection **namespaces) = 0;
      virtual HRESULT WINAPI get_processContents(SCHEMAPROCESSCONTENTS *processContents) = 0;
    };
#else
    typedef struct ISchemaAnyVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaAny *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaAny *This);
	ULONG (WINAPI *Release)(ISchemaAny *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaAny *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaAny *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaAny *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaAny *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaAny *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaAny *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaAny *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaAny *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaAny *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaAny *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaAny *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_minOccurs)(ISchemaAny *This,VARIANT *minOccurs);
	HRESULT (WINAPI *get_maxOccurs)(ISchemaAny *This,VARIANT *maxOccurs);
	HRESULT (WINAPI *get_namespaces)(ISchemaAny *This,ISchemaStringCollection **namespaces);
	HRESULT (WINAPI *get_processContents)(ISchemaAny *This,SCHEMAPROCESSCONTENTS *processContents);
      END_INTERFACE
    } ISchemaAnyVtbl;
    struct ISchemaAny {
      CONST_VTBL struct ISchemaAnyVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaAny_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaAny_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaAny_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaAny_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaAny_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaAny_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaAny_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaAny_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaAny_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaAny_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaAny_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaAny_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaAny_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaAny_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchemaAny_get_minOccurs(This,minOccurs) (This)->lpVtbl->get_minOccurs(This,minOccurs)
#define ISchemaAny_get_maxOccurs(This,maxOccurs) (This)->lpVtbl->get_maxOccurs(This,maxOccurs)
#define ISchemaAny_get_namespaces(This,namespaces) (This)->lpVtbl->get_namespaces(This,namespaces)
#define ISchemaAny_get_processContents(This,processContents) (This)->lpVtbl->get_processContents(This,processContents)
#endif
#endif
    HRESULT WINAPI ISchemaAny_get_namespaces_Proxy(ISchemaAny *This,ISchemaStringCollection **namespaces);
    void __RPC_STUB ISchemaAny_get_namespaces_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaAny_get_processContents_Proxy(ISchemaAny *This,SCHEMAPROCESSCONTENTS *processContents);
    void __RPC_STUB ISchemaAny_get_processContents_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaIdentityConstraint_INTERFACE_DEFINED__
#define __ISchemaIdentityConstraint_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaIdentityConstraint;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaIdentityConstraint : public ISchemaItem {
    public:
      virtual HRESULT WINAPI get_selector(BSTR *selector) = 0;
      virtual HRESULT WINAPI get_fields(ISchemaStringCollection **fields) = 0;
      virtual HRESULT WINAPI get_referencedKey(ISchemaIdentityConstraint **key) = 0;
    };
#else
    typedef struct ISchemaIdentityConstraintVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaIdentityConstraint *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaIdentityConstraint *This);
	ULONG (WINAPI *Release)(ISchemaIdentityConstraint *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaIdentityConstraint *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaIdentityConstraint *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaIdentityConstraint *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaIdentityConstraint *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaIdentityConstraint *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaIdentityConstraint *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaIdentityConstraint *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaIdentityConstraint *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaIdentityConstraint *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaIdentityConstraint *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaIdentityConstraint *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_selector)(ISchemaIdentityConstraint *This,BSTR *selector);
	HRESULT (WINAPI *get_fields)(ISchemaIdentityConstraint *This,ISchemaStringCollection **fields);
	HRESULT (WINAPI *get_referencedKey)(ISchemaIdentityConstraint *This,ISchemaIdentityConstraint **key);
      END_INTERFACE
    } ISchemaIdentityConstraintVtbl;
    struct ISchemaIdentityConstraint {
      CONST_VTBL struct ISchemaIdentityConstraintVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaIdentityConstraint_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaIdentityConstraint_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaIdentityConstraint_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaIdentityConstraint_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaIdentityConstraint_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaIdentityConstraint_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaIdentityConstraint_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaIdentityConstraint_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaIdentityConstraint_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaIdentityConstraint_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaIdentityConstraint_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaIdentityConstraint_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaIdentityConstraint_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaIdentityConstraint_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchemaIdentityConstraint_get_selector(This,selector) (This)->lpVtbl->get_selector(This,selector)
#define ISchemaIdentityConstraint_get_fields(This,fields) (This)->lpVtbl->get_fields(This,fields)
#define ISchemaIdentityConstraint_get_referencedKey(This,key) (This)->lpVtbl->get_referencedKey(This,key)
#endif
#endif
    HRESULT WINAPI ISchemaIdentityConstraint_get_selector_Proxy(ISchemaIdentityConstraint *This,BSTR *selector);
    void __RPC_STUB ISchemaIdentityConstraint_get_selector_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaIdentityConstraint_get_fields_Proxy(ISchemaIdentityConstraint *This,ISchemaStringCollection **fields);
    void __RPC_STUB ISchemaIdentityConstraint_get_fields_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaIdentityConstraint_get_referencedKey_Proxy(ISchemaIdentityConstraint *This,ISchemaIdentityConstraint **key);
    void __RPC_STUB ISchemaIdentityConstraint_get_referencedKey_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __ISchemaNotation_INTERFACE_DEFINED__
#define __ISchemaNotation_INTERFACE_DEFINED__
    EXTERN_C const IID IID_ISchemaNotation;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct ISchemaNotation : public ISchemaItem {
    public:
      virtual HRESULT WINAPI get_systemIdentifier(BSTR *uri) = 0;
      virtual HRESULT WINAPI get_publicIdentifier(BSTR *uri) = 0;
    };
#else
    typedef struct ISchemaNotationVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(ISchemaNotation *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(ISchemaNotation *This);
	ULONG (WINAPI *Release)(ISchemaNotation *This);
	HRESULT (WINAPI *GetTypeInfoCount)(ISchemaNotation *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(ISchemaNotation *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(ISchemaNotation *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(ISchemaNotation *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(ISchemaNotation *This,BSTR *name);
	HRESULT (WINAPI *get_namespaceURI)(ISchemaNotation *This,BSTR *namespaceURI);
	HRESULT (WINAPI *get_schema)(ISchemaNotation *This,ISchema **schema);
	HRESULT (WINAPI *get_id)(ISchemaNotation *This,BSTR *id);
	HRESULT (WINAPI *get_itemType)(ISchemaNotation *This,SOMITEMTYPE *itemType);
	HRESULT (WINAPI *get_unhandledAttributes)(ISchemaNotation *This,IVBSAXAttributes **attributes);
	HRESULT (WINAPI *writeAnnotation)(ISchemaNotation *This,IUnknown *annotationSink,VARIANT_BOOL *isWritten);
	HRESULT (WINAPI *get_systemIdentifier)(ISchemaNotation *This,BSTR *uri);
	HRESULT (WINAPI *get_publicIdentifier)(ISchemaNotation *This,BSTR *uri);
      END_INTERFACE
    } ISchemaNotationVtbl;
    struct ISchemaNotation {
      CONST_VTBL struct ISchemaNotationVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define ISchemaNotation_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define ISchemaNotation_AddRef(This) (This)->lpVtbl->AddRef(This)
#define ISchemaNotation_Release(This) (This)->lpVtbl->Release(This)
#define ISchemaNotation_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define ISchemaNotation_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define ISchemaNotation_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define ISchemaNotation_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define ISchemaNotation_get_name(This,name) (This)->lpVtbl->get_name(This,name)
#define ISchemaNotation_get_namespaceURI(This,namespaceURI) (This)->lpVtbl->get_namespaceURI(This,namespaceURI)
#define ISchemaNotation_get_schema(This,schema) (This)->lpVtbl->get_schema(This,schema)
#define ISchemaNotation_get_id(This,id) (This)->lpVtbl->get_id(This,id)
#define ISchemaNotation_get_itemType(This,itemType) (This)->lpVtbl->get_itemType(This,itemType)
#define ISchemaNotation_get_unhandledAttributes(This,attributes) (This)->lpVtbl->get_unhandledAttributes(This,attributes)
#define ISchemaNotation_writeAnnotation(This,annotationSink,isWritten) (This)->lpVtbl->writeAnnotation(This,annotationSink,isWritten)
#define ISchemaNotation_get_systemIdentifier(This,uri) (This)->lpVtbl->get_systemIdentifier(This,uri)
#define ISchemaNotation_get_publicIdentifier(This,uri) (This)->lpVtbl->get_publicIdentifier(This,uri)
#endif
#endif
    HRESULT WINAPI ISchemaNotation_get_systemIdentifier_Proxy(ISchemaNotation *This,BSTR *uri);
    void __RPC_STUB ISchemaNotation_get_systemIdentifier_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI ISchemaNotation_get_publicIdentifier_Proxy(ISchemaNotation *This,BSTR *uri);
    void __RPC_STUB ISchemaNotation_get_publicIdentifier_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLElementCollection_INTERFACE_DEFINED__
#define __IXMLElementCollection_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLElementCollection;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLElementCollection : public IDispatch {
    public:
      virtual HRESULT WINAPI put_length(long v) = 0;
      virtual HRESULT WINAPI get_length(long *p) = 0;
      virtual HRESULT WINAPI get__newEnum(IUnknown **ppUnk) = 0;
      virtual HRESULT WINAPI item(VARIANT var1,VARIANT var2,IDispatch **ppDisp) = 0;
    };
#else
    typedef struct IXMLElementCollectionVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLElementCollection *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLElementCollection *This);
	ULONG (WINAPI *Release)(IXMLElementCollection *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLElementCollection *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLElementCollection *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLElementCollection *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLElementCollection *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *put_length)(IXMLElementCollection *This,long v);
	HRESULT (WINAPI *get_length)(IXMLElementCollection *This,long *p);
	HRESULT (WINAPI *get__newEnum)(IXMLElementCollection *This,IUnknown **ppUnk);
	HRESULT (WINAPI *item)(IXMLElementCollection *This,VARIANT var1,VARIANT var2,IDispatch **ppDisp);
      END_INTERFACE
    } IXMLElementCollectionVtbl;
    struct IXMLElementCollection {
      CONST_VTBL struct IXMLElementCollectionVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLElementCollection_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLElementCollection_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLElementCollection_Release(This) (This)->lpVtbl->Release(This)
#define IXMLElementCollection_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLElementCollection_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLElementCollection_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLElementCollection_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLElementCollection_put_length(This,v) (This)->lpVtbl->put_length(This,v)
#define IXMLElementCollection_get_length(This,p) (This)->lpVtbl->get_length(This,p)
#define IXMLElementCollection_get__newEnum(This,ppUnk) (This)->lpVtbl->get__newEnum(This,ppUnk)
#define IXMLElementCollection_item(This,var1,var2,ppDisp) (This)->lpVtbl->item(This,var1,var2,ppDisp)
#endif
#endif
    HRESULT WINAPI IXMLElementCollection_put_length_Proxy(IXMLElementCollection *This,long v);
    void __RPC_STUB IXMLElementCollection_put_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElementCollection_get_length_Proxy(IXMLElementCollection *This,long *p);
    void __RPC_STUB IXMLElementCollection_get_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElementCollection_get__newEnum_Proxy(IXMLElementCollection *This,IUnknown **ppUnk);
    void __RPC_STUB IXMLElementCollection_get__newEnum_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElementCollection_item_Proxy(IXMLElementCollection *This,VARIANT var1,VARIANT var2,IDispatch **ppDisp);
    void __RPC_STUB IXMLElementCollection_item_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDocument_INTERFACE_DEFINED__
#define __IXMLDocument_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDocument;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDocument : public IDispatch {
    public:
      virtual HRESULT WINAPI get_root(IXMLElement **p) = 0;
      virtual HRESULT WINAPI get_fileSize(BSTR *p) = 0;
      virtual HRESULT WINAPI get_fileModifiedDate(BSTR *p) = 0;
      virtual HRESULT WINAPI get_fileUpdatedDate(BSTR *p) = 0;
      virtual HRESULT WINAPI get_URL(BSTR *p) = 0;
      virtual HRESULT WINAPI put_URL(BSTR p) = 0;
      virtual HRESULT WINAPI get_mimeType(BSTR *p) = 0;
      virtual HRESULT WINAPI get_readyState(long *pl) = 0;
      virtual HRESULT WINAPI get_charset(BSTR *p) = 0;
      virtual HRESULT WINAPI put_charset(BSTR p) = 0;
      virtual HRESULT WINAPI get_version(BSTR *p) = 0;
      virtual HRESULT WINAPI get_doctype(BSTR *p) = 0;
      virtual HRESULT WINAPI get_dtdURL(BSTR *p) = 0;
      virtual HRESULT WINAPI createElement(VARIANT vType,VARIANT var1,IXMLElement **ppElem) = 0;
    };
#else
    typedef struct IXMLDocumentVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDocument *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDocument *This);
	ULONG (WINAPI *Release)(IXMLDocument *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDocument *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDocument *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDocument *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDocument *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_root)(IXMLDocument *This,IXMLElement **p);
	HRESULT (WINAPI *get_fileSize)(IXMLDocument *This,BSTR *p);
	HRESULT (WINAPI *get_fileModifiedDate)(IXMLDocument *This,BSTR *p);
	HRESULT (WINAPI *get_fileUpdatedDate)(IXMLDocument *This,BSTR *p);
	HRESULT (WINAPI *get_URL)(IXMLDocument *This,BSTR *p);
	HRESULT (WINAPI *put_URL)(IXMLDocument *This,BSTR p);
	HRESULT (WINAPI *get_mimeType)(IXMLDocument *This,BSTR *p);
	HRESULT (WINAPI *get_readyState)(IXMLDocument *This,long *pl);
	HRESULT (WINAPI *get_charset)(IXMLDocument *This,BSTR *p);
	HRESULT (WINAPI *put_charset)(IXMLDocument *This,BSTR p);
	HRESULT (WINAPI *get_version)(IXMLDocument *This,BSTR *p);
	HRESULT (WINAPI *get_doctype)(IXMLDocument *This,BSTR *p);
	HRESULT (WINAPI *get_dtdURL)(IXMLDocument *This,BSTR *p);
	HRESULT (WINAPI *createElement)(IXMLDocument *This,VARIANT vType,VARIANT var1,IXMLElement **ppElem);
      END_INTERFACE
    } IXMLDocumentVtbl;
    struct IXMLDocument {
      CONST_VTBL struct IXMLDocumentVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDocument_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDocument_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDocument_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDocument_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDocument_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDocument_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDocument_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDocument_get_root(This,p) (This)->lpVtbl->get_root(This,p)
#define IXMLDocument_get_fileSize(This,p) (This)->lpVtbl->get_fileSize(This,p)
#define IXMLDocument_get_fileModifiedDate(This,p) (This)->lpVtbl->get_fileModifiedDate(This,p)
#define IXMLDocument_get_fileUpdatedDate(This,p) (This)->lpVtbl->get_fileUpdatedDate(This,p)
#define IXMLDocument_get_URL(This,p) (This)->lpVtbl->get_URL(This,p)
#define IXMLDocument_put_URL(This,p) (This)->lpVtbl->put_URL(This,p)
#define IXMLDocument_get_mimeType(This,p) (This)->lpVtbl->get_mimeType(This,p)
#define IXMLDocument_get_readyState(This,pl) (This)->lpVtbl->get_readyState(This,pl)
#define IXMLDocument_get_charset(This,p) (This)->lpVtbl->get_charset(This,p)
#define IXMLDocument_put_charset(This,p) (This)->lpVtbl->put_charset(This,p)
#define IXMLDocument_get_version(This,p) (This)->lpVtbl->get_version(This,p)
#define IXMLDocument_get_doctype(This,p) (This)->lpVtbl->get_doctype(This,p)
#define IXMLDocument_get_dtdURL(This,p) (This)->lpVtbl->get_dtdURL(This,p)
#define IXMLDocument_createElement(This,vType,var1,ppElem) (This)->lpVtbl->createElement(This,vType,var1,ppElem)
#endif
#endif
    HRESULT WINAPI IXMLDocument_get_root_Proxy(IXMLDocument *This,IXMLElement **p);
    void __RPC_STUB IXMLDocument_get_root_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_get_fileSize_Proxy(IXMLDocument *This,BSTR *p);
    void __RPC_STUB IXMLDocument_get_fileSize_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_get_fileModifiedDate_Proxy(IXMLDocument *This,BSTR *p);
    void __RPC_STUB IXMLDocument_get_fileModifiedDate_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_get_fileUpdatedDate_Proxy(IXMLDocument *This,BSTR *p);
    void __RPC_STUB IXMLDocument_get_fileUpdatedDate_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_get_URL_Proxy(IXMLDocument *This,BSTR *p);
    void __RPC_STUB IXMLDocument_get_URL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_put_URL_Proxy(IXMLDocument *This,BSTR p);
    void __RPC_STUB IXMLDocument_put_URL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_get_mimeType_Proxy(IXMLDocument *This,BSTR *p);
    void __RPC_STUB IXMLDocument_get_mimeType_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_get_readyState_Proxy(IXMLDocument *This,long *pl);
    void __RPC_STUB IXMLDocument_get_readyState_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_get_charset_Proxy(IXMLDocument *This,BSTR *p);
    void __RPC_STUB IXMLDocument_get_charset_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_put_charset_Proxy(IXMLDocument *This,BSTR p);
    void __RPC_STUB IXMLDocument_put_charset_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_get_version_Proxy(IXMLDocument *This,BSTR *p);
    void __RPC_STUB IXMLDocument_get_version_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_get_doctype_Proxy(IXMLDocument *This,BSTR *p);
    void __RPC_STUB IXMLDocument_get_doctype_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_get_dtdURL_Proxy(IXMLDocument *This,BSTR *p);
    void __RPC_STUB IXMLDocument_get_dtdURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument_createElement_Proxy(IXMLDocument *This,VARIANT vType,VARIANT var1,IXMLElement **ppElem);
    void __RPC_STUB IXMLDocument_createElement_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDocument2_INTERFACE_DEFINED__
#define __IXMLDocument2_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDocument2;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDocument2 : public IDispatch {
    public:
      virtual HRESULT WINAPI get_root(IXMLElement2 **p) = 0;
      virtual HRESULT WINAPI get_fileSize(BSTR *p) = 0;
      virtual HRESULT WINAPI get_fileModifiedDate(BSTR *p) = 0;
      virtual HRESULT WINAPI get_fileUpdatedDate(BSTR *p) = 0;
      virtual HRESULT WINAPI get_URL(BSTR *p) = 0;
      virtual HRESULT WINAPI put_URL(BSTR p) = 0;
      virtual HRESULT WINAPI get_mimeType(BSTR *p) = 0;
      virtual HRESULT WINAPI get_readyState(long *pl) = 0;
      virtual HRESULT WINAPI get_charset(BSTR *p) = 0;
      virtual HRESULT WINAPI put_charset(BSTR p) = 0;
      virtual HRESULT WINAPI get_version(BSTR *p) = 0;
      virtual HRESULT WINAPI get_doctype(BSTR *p) = 0;
      virtual HRESULT WINAPI get_dtdURL(BSTR *p) = 0;
      virtual HRESULT WINAPI createElement(VARIANT vType,VARIANT var1,IXMLElement2 **ppElem) = 0;
      virtual HRESULT WINAPI get_async(VARIANT_BOOL *pf) = 0;
      virtual HRESULT WINAPI put_async(VARIANT_BOOL f) = 0;
    };
#else
    typedef struct IXMLDocument2Vtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDocument2 *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDocument2 *This);
	ULONG (WINAPI *Release)(IXMLDocument2 *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDocument2 *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDocument2 *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDocument2 *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDocument2 *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_root)(IXMLDocument2 *This,IXMLElement2 **p);
	HRESULT (WINAPI *get_fileSize)(IXMLDocument2 *This,BSTR *p);
	HRESULT (WINAPI *get_fileModifiedDate)(IXMLDocument2 *This,BSTR *p);
	HRESULT (WINAPI *get_fileUpdatedDate)(IXMLDocument2 *This,BSTR *p);
	HRESULT (WINAPI *get_URL)(IXMLDocument2 *This,BSTR *p);
	HRESULT (WINAPI *put_URL)(IXMLDocument2 *This,BSTR p);
	HRESULT (WINAPI *get_mimeType)(IXMLDocument2 *This,BSTR *p);
	HRESULT (WINAPI *get_readyState)(IXMLDocument2 *This,long *pl);
	HRESULT (WINAPI *get_charset)(IXMLDocument2 *This,BSTR *p);
	HRESULT (WINAPI *put_charset)(IXMLDocument2 *This,BSTR p);
	HRESULT (WINAPI *get_version)(IXMLDocument2 *This,BSTR *p);
	HRESULT (WINAPI *get_doctype)(IXMLDocument2 *This,BSTR *p);
	HRESULT (WINAPI *get_dtdURL)(IXMLDocument2 *This,BSTR *p);
	HRESULT (WINAPI *createElement)(IXMLDocument2 *This,VARIANT vType,VARIANT var1,IXMLElement2 **ppElem);
	HRESULT (WINAPI *get_async)(IXMLDocument2 *This,VARIANT_BOOL *pf);
	HRESULT (WINAPI *put_async)(IXMLDocument2 *This,VARIANT_BOOL f);
      END_INTERFACE
    } IXMLDocument2Vtbl;
    struct IXMLDocument2 {
      CONST_VTBL struct IXMLDocument2Vtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDocument2_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDocument2_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDocument2_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDocument2_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDocument2_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDocument2_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDocument2_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDocument2_get_root(This,p) (This)->lpVtbl->get_root(This,p)
#define IXMLDocument2_get_fileSize(This,p) (This)->lpVtbl->get_fileSize(This,p)
#define IXMLDocument2_get_fileModifiedDate(This,p) (This)->lpVtbl->get_fileModifiedDate(This,p)
#define IXMLDocument2_get_fileUpdatedDate(This,p) (This)->lpVtbl->get_fileUpdatedDate(This,p)
#define IXMLDocument2_get_URL(This,p) (This)->lpVtbl->get_URL(This,p)
#define IXMLDocument2_put_URL(This,p) (This)->lpVtbl->put_URL(This,p)
#define IXMLDocument2_get_mimeType(This,p) (This)->lpVtbl->get_mimeType(This,p)
#define IXMLDocument2_get_readyState(This,pl) (This)->lpVtbl->get_readyState(This,pl)
#define IXMLDocument2_get_charset(This,p) (This)->lpVtbl->get_charset(This,p)
#define IXMLDocument2_put_charset(This,p) (This)->lpVtbl->put_charset(This,p)
#define IXMLDocument2_get_version(This,p) (This)->lpVtbl->get_version(This,p)
#define IXMLDocument2_get_doctype(This,p) (This)->lpVtbl->get_doctype(This,p)
#define IXMLDocument2_get_dtdURL(This,p) (This)->lpVtbl->get_dtdURL(This,p)
#define IXMLDocument2_createElement(This,vType,var1,ppElem) (This)->lpVtbl->createElement(This,vType,var1,ppElem)
#define IXMLDocument2_get_async(This,pf) (This)->lpVtbl->get_async(This,pf)
#define IXMLDocument2_put_async(This,f) (This)->lpVtbl->put_async(This,f)
#endif
#endif
    HRESULT WINAPI IXMLDocument2_get_root_Proxy(IXMLDocument2 *This,IXMLElement2 **p);
    void __RPC_STUB IXMLDocument2_get_root_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_fileSize_Proxy(IXMLDocument2 *This,BSTR *p);
    void __RPC_STUB IXMLDocument2_get_fileSize_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_fileModifiedDate_Proxy(IXMLDocument2 *This,BSTR *p);
    void __RPC_STUB IXMLDocument2_get_fileModifiedDate_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_fileUpdatedDate_Proxy(IXMLDocument2 *This,BSTR *p);
    void __RPC_STUB IXMLDocument2_get_fileUpdatedDate_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_URL_Proxy(IXMLDocument2 *This,BSTR *p);
    void __RPC_STUB IXMLDocument2_get_URL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_put_URL_Proxy(IXMLDocument2 *This,BSTR p);
    void __RPC_STUB IXMLDocument2_put_URL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_mimeType_Proxy(IXMLDocument2 *This,BSTR *p);
    void __RPC_STUB IXMLDocument2_get_mimeType_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_readyState_Proxy(IXMLDocument2 *This,long *pl);
    void __RPC_STUB IXMLDocument2_get_readyState_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_charset_Proxy(IXMLDocument2 *This,BSTR *p);
    void __RPC_STUB IXMLDocument2_get_charset_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_put_charset_Proxy(IXMLDocument2 *This,BSTR p);
    void __RPC_STUB IXMLDocument2_put_charset_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_version_Proxy(IXMLDocument2 *This,BSTR *p);
    void __RPC_STUB IXMLDocument2_get_version_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_doctype_Proxy(IXMLDocument2 *This,BSTR *p);
    void __RPC_STUB IXMLDocument2_get_doctype_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_dtdURL_Proxy(IXMLDocument2 *This,BSTR *p);
    void __RPC_STUB IXMLDocument2_get_dtdURL_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_createElement_Proxy(IXMLDocument2 *This,VARIANT vType,VARIANT var1,IXMLElement2 **ppElem);
    void __RPC_STUB IXMLDocument2_createElement_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_get_async_Proxy(IXMLDocument2 *This,VARIANT_BOOL *pf);
    void __RPC_STUB IXMLDocument2_get_async_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDocument2_put_async_Proxy(IXMLDocument2 *This,VARIANT_BOOL f);
    void __RPC_STUB IXMLDocument2_put_async_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLElement_INTERFACE_DEFINED__
#define __IXMLElement_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLElement;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLElement : public IDispatch {
    public:
      virtual HRESULT WINAPI get_tagName(BSTR *p) = 0;
      virtual HRESULT WINAPI put_tagName(BSTR p) = 0;
      virtual HRESULT WINAPI get_parent(IXMLElement **ppParent) = 0;
      virtual HRESULT WINAPI setAttribute(BSTR strPropertyName,VARIANT PropertyValue) = 0;
      virtual HRESULT WINAPI getAttribute(BSTR strPropertyName,VARIANT *PropertyValue) = 0;
      virtual HRESULT WINAPI removeAttribute(BSTR strPropertyName) = 0;
      virtual HRESULT WINAPI get_children(IXMLElementCollection **pp) = 0;
      virtual HRESULT WINAPI get_type(long *plType) = 0;
      virtual HRESULT WINAPI get_text(BSTR *p) = 0;
      virtual HRESULT WINAPI put_text(BSTR p) = 0;
      virtual HRESULT WINAPI addChild(IXMLElement *pChildElem,long lIndex,long lReserved) = 0;
      virtual HRESULT WINAPI removeChild(IXMLElement *pChildElem) = 0;
    };
#else
    typedef struct IXMLElementVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLElement *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLElement *This);
	ULONG (WINAPI *Release)(IXMLElement *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLElement *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLElement *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLElement *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLElement *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_tagName)(IXMLElement *This,BSTR *p);
	HRESULT (WINAPI *put_tagName)(IXMLElement *This,BSTR p);
	HRESULT (WINAPI *get_parent)(IXMLElement *This,IXMLElement **ppParent);
	HRESULT (WINAPI *setAttribute)(IXMLElement *This,BSTR strPropertyName,VARIANT PropertyValue);
	HRESULT (WINAPI *getAttribute)(IXMLElement *This,BSTR strPropertyName,VARIANT *PropertyValue);
	HRESULT (WINAPI *removeAttribute)(IXMLElement *This,BSTR strPropertyName);
	HRESULT (WINAPI *get_children)(IXMLElement *This,IXMLElementCollection **pp);
	HRESULT (WINAPI *get_type)(IXMLElement *This,long *plType);
	HRESULT (WINAPI *get_text)(IXMLElement *This,BSTR *p);
	HRESULT (WINAPI *put_text)(IXMLElement *This,BSTR p);
	HRESULT (WINAPI *addChild)(IXMLElement *This,IXMLElement *pChildElem,long lIndex,long lReserved);
	HRESULT (WINAPI *removeChild)(IXMLElement *This,IXMLElement *pChildElem);
      END_INTERFACE
    } IXMLElementVtbl;
    struct IXMLElement {
      CONST_VTBL struct IXMLElementVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLElement_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLElement_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLElement_Release(This) (This)->lpVtbl->Release(This)
#define IXMLElement_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLElement_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLElement_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLElement_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLElement_get_tagName(This,p) (This)->lpVtbl->get_tagName(This,p)
#define IXMLElement_put_tagName(This,p) (This)->lpVtbl->put_tagName(This,p)
#define IXMLElement_get_parent(This,ppParent) (This)->lpVtbl->get_parent(This,ppParent)
#define IXMLElement_setAttribute(This,strPropertyName,PropertyValue) (This)->lpVtbl->setAttribute(This,strPropertyName,PropertyValue)
#define IXMLElement_getAttribute(This,strPropertyName,PropertyValue) (This)->lpVtbl->getAttribute(This,strPropertyName,PropertyValue)
#define IXMLElement_removeAttribute(This,strPropertyName) (This)->lpVtbl->removeAttribute(This,strPropertyName)
#define IXMLElement_get_children(This,pp) (This)->lpVtbl->get_children(This,pp)
#define IXMLElement_get_type(This,plType) (This)->lpVtbl->get_type(This,plType)
#define IXMLElement_get_text(This,p) (This)->lpVtbl->get_text(This,p)
#define IXMLElement_put_text(This,p) (This)->lpVtbl->put_text(This,p)
#define IXMLElement_addChild(This,pChildElem,lIndex,lReserved) (This)->lpVtbl->addChild(This,pChildElem,lIndex,lReserved)
#define IXMLElement_removeChild(This,pChildElem) (This)->lpVtbl->removeChild(This,pChildElem)
#endif
#endif
    HRESULT WINAPI IXMLElement_get_tagName_Proxy(IXMLElement *This,BSTR *p);
    void __RPC_STUB IXMLElement_get_tagName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_put_tagName_Proxy(IXMLElement *This,BSTR p);
    void __RPC_STUB IXMLElement_put_tagName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_get_parent_Proxy(IXMLElement *This,IXMLElement **ppParent);
    void __RPC_STUB IXMLElement_get_parent_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_setAttribute_Proxy(IXMLElement *This,BSTR strPropertyName,VARIANT PropertyValue);
    void __RPC_STUB IXMLElement_setAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_getAttribute_Proxy(IXMLElement *This,BSTR strPropertyName,VARIANT *PropertyValue);
    void __RPC_STUB IXMLElement_getAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_removeAttribute_Proxy(IXMLElement *This,BSTR strPropertyName);
    void __RPC_STUB IXMLElement_removeAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_get_children_Proxy(IXMLElement *This,IXMLElementCollection **pp);
    void __RPC_STUB IXMLElement_get_children_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_get_type_Proxy(IXMLElement *This,long *plType);
    void __RPC_STUB IXMLElement_get_type_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_get_text_Proxy(IXMLElement *This,BSTR *p);
    void __RPC_STUB IXMLElement_get_text_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_put_text_Proxy(IXMLElement *This,BSTR p);
    void __RPC_STUB IXMLElement_put_text_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_addChild_Proxy(IXMLElement *This,IXMLElement *pChildElem,long lIndex,long lReserved);
    void __RPC_STUB IXMLElement_addChild_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement_removeChild_Proxy(IXMLElement *This,IXMLElement *pChildElem);
    void __RPC_STUB IXMLElement_removeChild_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLElement2_INTERFACE_DEFINED__
#define __IXMLElement2_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLElement2;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLElement2 : public IDispatch {
    public:
      virtual HRESULT WINAPI get_tagName(BSTR *p) = 0;
      virtual HRESULT WINAPI put_tagName(BSTR p) = 0;
      virtual HRESULT WINAPI get_parent(IXMLElement2 **ppParent) = 0;
      virtual HRESULT WINAPI setAttribute(BSTR strPropertyName,VARIANT PropertyValue) = 0;
      virtual HRESULT WINAPI getAttribute(BSTR strPropertyName,VARIANT *PropertyValue) = 0;
      virtual HRESULT WINAPI removeAttribute(BSTR strPropertyName) = 0;
      virtual HRESULT WINAPI get_children(IXMLElementCollection **pp) = 0;
      virtual HRESULT WINAPI get_type(long *plType) = 0;
      virtual HRESULT WINAPI get_text(BSTR *p) = 0;
      virtual HRESULT WINAPI put_text(BSTR p) = 0;
      virtual HRESULT WINAPI addChild(IXMLElement2 *pChildElem,long lIndex,long lReserved) = 0;
      virtual HRESULT WINAPI removeChild(IXMLElement2 *pChildElem) = 0;
      virtual HRESULT WINAPI get_attributes(IXMLElementCollection **pp) = 0;
    };
#else
    typedef struct IXMLElement2Vtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLElement2 *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLElement2 *This);
	ULONG (WINAPI *Release)(IXMLElement2 *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLElement2 *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLElement2 *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLElement2 *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLElement2 *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_tagName)(IXMLElement2 *This,BSTR *p);
	HRESULT (WINAPI *put_tagName)(IXMLElement2 *This,BSTR p);
	HRESULT (WINAPI *get_parent)(IXMLElement2 *This,IXMLElement2 **ppParent);
	HRESULT (WINAPI *setAttribute)(IXMLElement2 *This,BSTR strPropertyName,VARIANT PropertyValue);
	HRESULT (WINAPI *getAttribute)(IXMLElement2 *This,BSTR strPropertyName,VARIANT *PropertyValue);
	HRESULT (WINAPI *removeAttribute)(IXMLElement2 *This,BSTR strPropertyName);
	HRESULT (WINAPI *get_children)(IXMLElement2 *This,IXMLElementCollection **pp);
	HRESULT (WINAPI *get_type)(IXMLElement2 *This,long *plType);
	HRESULT (WINAPI *get_text)(IXMLElement2 *This,BSTR *p);
	HRESULT (WINAPI *put_text)(IXMLElement2 *This,BSTR p);
	HRESULT (WINAPI *addChild)(IXMLElement2 *This,IXMLElement2 *pChildElem,long lIndex,long lReserved);
	HRESULT (WINAPI *removeChild)(IXMLElement2 *This,IXMLElement2 *pChildElem);
	HRESULT (WINAPI *get_attributes)(IXMLElement2 *This,IXMLElementCollection **pp);
      END_INTERFACE
    } IXMLElement2Vtbl;
    struct IXMLElement2 {
      CONST_VTBL struct IXMLElement2Vtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLElement2_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLElement2_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLElement2_Release(This) (This)->lpVtbl->Release(This)
#define IXMLElement2_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLElement2_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLElement2_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLElement2_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLElement2_get_tagName(This,p) (This)->lpVtbl->get_tagName(This,p)
#define IXMLElement2_put_tagName(This,p) (This)->lpVtbl->put_tagName(This,p)
#define IXMLElement2_get_parent(This,ppParent) (This)->lpVtbl->get_parent(This,ppParent)
#define IXMLElement2_setAttribute(This,strPropertyName,PropertyValue) (This)->lpVtbl->setAttribute(This,strPropertyName,PropertyValue)
#define IXMLElement2_getAttribute(This,strPropertyName,PropertyValue) (This)->lpVtbl->getAttribute(This,strPropertyName,PropertyValue)
#define IXMLElement2_removeAttribute(This,strPropertyName) (This)->lpVtbl->removeAttribute(This,strPropertyName)
#define IXMLElement2_get_children(This,pp) (This)->lpVtbl->get_children(This,pp)
#define IXMLElement2_get_type(This,plType) (This)->lpVtbl->get_type(This,plType)
#define IXMLElement2_get_text(This,p) (This)->lpVtbl->get_text(This,p)
#define IXMLElement2_put_text(This,p) (This)->lpVtbl->put_text(This,p)
#define IXMLElement2_addChild(This,pChildElem,lIndex,lReserved) (This)->lpVtbl->addChild(This,pChildElem,lIndex,lReserved)
#define IXMLElement2_removeChild(This,pChildElem) (This)->lpVtbl->removeChild(This,pChildElem)
#define IXMLElement2_get_attributes(This,pp) (This)->lpVtbl->get_attributes(This,pp)
#endif
#endif
    HRESULT WINAPI IXMLElement2_get_tagName_Proxy(IXMLElement2 *This,BSTR *p);
    void __RPC_STUB IXMLElement2_get_tagName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_put_tagName_Proxy(IXMLElement2 *This,BSTR p);
    void __RPC_STUB IXMLElement2_put_tagName_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_get_parent_Proxy(IXMLElement2 *This,IXMLElement2 **ppParent);
    void __RPC_STUB IXMLElement2_get_parent_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_setAttribute_Proxy(IXMLElement2 *This,BSTR strPropertyName,VARIANT PropertyValue);
    void __RPC_STUB IXMLElement2_setAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_getAttribute_Proxy(IXMLElement2 *This,BSTR strPropertyName,VARIANT *PropertyValue);
    void __RPC_STUB IXMLElement2_getAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_removeAttribute_Proxy(IXMLElement2 *This,BSTR strPropertyName);
    void __RPC_STUB IXMLElement2_removeAttribute_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_get_children_Proxy(IXMLElement2 *This,IXMLElementCollection **pp);
    void __RPC_STUB IXMLElement2_get_children_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_get_type_Proxy(IXMLElement2 *This,long *plType);
    void __RPC_STUB IXMLElement2_get_type_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_get_text_Proxy(IXMLElement2 *This,BSTR *p);
    void __RPC_STUB IXMLElement2_get_text_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_put_text_Proxy(IXMLElement2 *This,BSTR p);
    void __RPC_STUB IXMLElement2_put_text_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_addChild_Proxy(IXMLElement2 *This,IXMLElement2 *pChildElem,long lIndex,long lReserved);
    void __RPC_STUB IXMLElement2_addChild_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_removeChild_Proxy(IXMLElement2 *This,IXMLElement2 *pChildElem);
    void __RPC_STUB IXMLElement2_removeChild_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLElement2_get_attributes_Proxy(IXMLElement2 *This,IXMLElementCollection **pp);
    void __RPC_STUB IXMLElement2_get_attributes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLAttribute_INTERFACE_DEFINED__
#define __IXMLAttribute_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLAttribute;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLAttribute : public IDispatch {
    public:
      virtual HRESULT WINAPI get_name(BSTR *n) = 0;
      virtual HRESULT WINAPI get_value(BSTR *v) = 0;
    };
#else
    typedef struct IXMLAttributeVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLAttribute *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLAttribute *This);
	ULONG (WINAPI *Release)(IXMLAttribute *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLAttribute *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLAttribute *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLAttribute *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLAttribute *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_name)(IXMLAttribute *This,BSTR *n);
	HRESULT (WINAPI *get_value)(IXMLAttribute *This,BSTR *v);
      END_INTERFACE
    } IXMLAttributeVtbl;
    struct IXMLAttribute {
      CONST_VTBL struct IXMLAttributeVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLAttribute_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLAttribute_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLAttribute_Release(This) (This)->lpVtbl->Release(This)
#define IXMLAttribute_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLAttribute_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLAttribute_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLAttribute_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLAttribute_get_name(This,n) (This)->lpVtbl->get_name(This,n)
#define IXMLAttribute_get_value(This,v) (This)->lpVtbl->get_value(This,v)
#endif
#endif
    HRESULT WINAPI IXMLAttribute_get_name_Proxy(IXMLAttribute *This,BSTR *n);
    void __RPC_STUB IXMLAttribute_get_name_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLAttribute_get_value_Proxy(IXMLAttribute *This,BSTR *v);
    void __RPC_STUB IXMLAttribute_get_value_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLError_INTERFACE_DEFINED__
#define __IXMLError_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLError;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLError : public IUnknown {
    public:
      virtual HRESULT WINAPI GetErrorInfo(XML_ERROR *pErrorReturn) = 0;
    };
#else
    typedef struct IXMLErrorVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLError *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLError *This);
	ULONG (WINAPI *Release)(IXMLError *This);
	HRESULT (WINAPI *GetErrorInfo)(IXMLError *This,XML_ERROR *pErrorReturn);
      END_INTERFACE
    } IXMLErrorVtbl;
    struct IXMLError {
      CONST_VTBL struct IXMLErrorVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLError_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLError_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLError_Release(This) (This)->lpVtbl->Release(This)
#define IXMLError_GetErrorInfo(This,pErrorReturn) (This)->lpVtbl->GetErrorInfo(This,pErrorReturn)
#endif
#endif
    HRESULT WINAPI IXMLError_GetErrorInfo_Proxy(IXMLError *This,XML_ERROR *pErrorReturn);
    void __RPC_STUB IXMLError_GetErrorInfo_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLDOMSelection_INTERFACE_DEFINED__
#define __IXMLDOMSelection_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLDOMSelection;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLDOMSelection : public IXMLDOMNodeList {
    public:
      virtual HRESULT WINAPI get_expr(BSTR *expression) = 0;
      virtual HRESULT WINAPI put_expr(BSTR expression) = 0;
      virtual HRESULT WINAPI get_context(IXMLDOMNode **ppNode) = 0;
      virtual HRESULT WINAPI putref_context(IXMLDOMNode *pNode) = 0;
      virtual HRESULT WINAPI peekNode(IXMLDOMNode **ppNode) = 0;
      virtual HRESULT WINAPI matches(IXMLDOMNode *pNode,IXMLDOMNode **ppNode) = 0;
      virtual HRESULT WINAPI removeNext(IXMLDOMNode **ppNode) = 0;
      virtual HRESULT WINAPI removeAll(void) = 0;
      virtual HRESULT WINAPI clone(IXMLDOMSelection **ppNode) = 0;
      virtual HRESULT WINAPI getProperty(BSTR name,VARIANT *value) = 0;
      virtual HRESULT WINAPI setProperty(BSTR name,VARIANT value) = 0;
    };
#else
    typedef struct IXMLDOMSelectionVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLDOMSelection *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLDOMSelection *This);
	ULONG (WINAPI *Release)(IXMLDOMSelection *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLDOMSelection *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLDOMSelection *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLDOMSelection *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLDOMSelection *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_item)(IXMLDOMSelection *This,long index,IXMLDOMNode **listItem);
	HRESULT (WINAPI *get_length)(IXMLDOMSelection *This,long *listLength);
	HRESULT (WINAPI *nextNode)(IXMLDOMSelection *This,IXMLDOMNode **nextItem);
	HRESULT (WINAPI *reset)(IXMLDOMSelection *This);
	HRESULT (WINAPI *get__newEnum)(IXMLDOMSelection *This,IUnknown **ppUnk);
	HRESULT (WINAPI *get_expr)(IXMLDOMSelection *This,BSTR *expression);
	HRESULT (WINAPI *put_expr)(IXMLDOMSelection *This,BSTR expression);
	HRESULT (WINAPI *get_context)(IXMLDOMSelection *This,IXMLDOMNode **ppNode);
	HRESULT (WINAPI *putref_context)(IXMLDOMSelection *This,IXMLDOMNode *pNode);
	HRESULT (WINAPI *peekNode)(IXMLDOMSelection *This,IXMLDOMNode **ppNode);
	HRESULT (WINAPI *matches)(IXMLDOMSelection *This,IXMLDOMNode *pNode,IXMLDOMNode **ppNode);
	HRESULT (WINAPI *removeNext)(IXMLDOMSelection *This,IXMLDOMNode **ppNode);
	HRESULT (WINAPI *removeAll)(IXMLDOMSelection *This);
	HRESULT (WINAPI *clone)(IXMLDOMSelection *This,IXMLDOMSelection **ppNode);
	HRESULT (WINAPI *getProperty)(IXMLDOMSelection *This,BSTR name,VARIANT *value);
	HRESULT (WINAPI *setProperty)(IXMLDOMSelection *This,BSTR name,VARIANT value);
      END_INTERFACE
    } IXMLDOMSelectionVtbl;
    struct IXMLDOMSelection {
      CONST_VTBL struct IXMLDOMSelectionVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLDOMSelection_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLDOMSelection_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLDOMSelection_Release(This) (This)->lpVtbl->Release(This)
#define IXMLDOMSelection_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLDOMSelection_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLDOMSelection_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLDOMSelection_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLDOMSelection_get_item(This,index,listItem) (This)->lpVtbl->get_item(This,index,listItem)
#define IXMLDOMSelection_get_length(This,listLength) (This)->lpVtbl->get_length(This,listLength)
#define IXMLDOMSelection_nextNode(This,nextItem) (This)->lpVtbl->nextNode(This,nextItem)
#define IXMLDOMSelection_reset(This) (This)->lpVtbl->reset(This)
#define IXMLDOMSelection_get__newEnum(This,ppUnk) (This)->lpVtbl->get__newEnum(This,ppUnk)
#define IXMLDOMSelection_get_expr(This,expression) (This)->lpVtbl->get_expr(This,expression)
#define IXMLDOMSelection_put_expr(This,expression) (This)->lpVtbl->put_expr(This,expression)
#define IXMLDOMSelection_get_context(This,ppNode) (This)->lpVtbl->get_context(This,ppNode)
#define IXMLDOMSelection_putref_context(This,pNode) (This)->lpVtbl->putref_context(This,pNode)
#define IXMLDOMSelection_peekNode(This,ppNode) (This)->lpVtbl->peekNode(This,ppNode)
#define IXMLDOMSelection_matches(This,pNode,ppNode) (This)->lpVtbl->matches(This,pNode,ppNode)
#define IXMLDOMSelection_removeNext(This,ppNode) (This)->lpVtbl->removeNext(This,ppNode)
#define IXMLDOMSelection_removeAll(This) (This)->lpVtbl->removeAll(This)
#define IXMLDOMSelection_clone(This,ppNode) (This)->lpVtbl->clone(This,ppNode)
#define IXMLDOMSelection_getProperty(This,name,value) (This)->lpVtbl->getProperty(This,name,value)
#define IXMLDOMSelection_setProperty(This,name,value) (This)->lpVtbl->setProperty(This,name,value)
#endif
#endif
    HRESULT WINAPI IXMLDOMSelection_get_expr_Proxy(IXMLDOMSelection *This,BSTR *expression);
    void __RPC_STUB IXMLDOMSelection_get_expr_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSelection_put_expr_Proxy(IXMLDOMSelection *This,BSTR expression);
    void __RPC_STUB IXMLDOMSelection_put_expr_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSelection_get_context_Proxy(IXMLDOMSelection *This,IXMLDOMNode **ppNode);
    void __RPC_STUB IXMLDOMSelection_get_context_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSelection_putref_context_Proxy(IXMLDOMSelection *This,IXMLDOMNode *pNode);
    void __RPC_STUB IXMLDOMSelection_putref_context_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSelection_peekNode_Proxy(IXMLDOMSelection *This,IXMLDOMNode **ppNode);
    void __RPC_STUB IXMLDOMSelection_peekNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSelection_matches_Proxy(IXMLDOMSelection *This,IXMLDOMNode *pNode,IXMLDOMNode **ppNode);
    void __RPC_STUB IXMLDOMSelection_matches_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSelection_removeNext_Proxy(IXMLDOMSelection *This,IXMLDOMNode **ppNode);
    void __RPC_STUB IXMLDOMSelection_removeNext_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSelection_removeAll_Proxy(IXMLDOMSelection *This);
    void __RPC_STUB IXMLDOMSelection_removeAll_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSelection_clone_Proxy(IXMLDOMSelection *This,IXMLDOMSelection **ppNode);
    void __RPC_STUB IXMLDOMSelection_clone_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSelection_getProperty_Proxy(IXMLDOMSelection *This,BSTR name,VARIANT *value);
    void __RPC_STUB IXMLDOMSelection_getProperty_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLDOMSelection_setProperty_Proxy(IXMLDOMSelection *This,BSTR name,VARIANT value);
    void __RPC_STUB IXMLDOMSelection_setProperty_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __XMLDOMDocumentEvents_DISPINTERFACE_DEFINED__
#define __XMLDOMDocumentEvents_DISPINTERFACE_DEFINED__
    EXTERN_C const IID DIID_XMLDOMDocumentEvents;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct XMLDOMDocumentEvents : public IDispatch {
    };
#else
    typedef struct XMLDOMDocumentEventsVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(XMLDOMDocumentEvents *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(XMLDOMDocumentEvents *This);
	ULONG (WINAPI *Release)(XMLDOMDocumentEvents *This);
	HRESULT (WINAPI *GetTypeInfoCount)(XMLDOMDocumentEvents *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(XMLDOMDocumentEvents *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(XMLDOMDocumentEvents *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(XMLDOMDocumentEvents *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
      END_INTERFACE
    } XMLDOMDocumentEventsVtbl;
    struct XMLDOMDocumentEvents {
      CONST_VTBL struct XMLDOMDocumentEventsVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define XMLDOMDocumentEvents_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define XMLDOMDocumentEvents_AddRef(This) (This)->lpVtbl->AddRef(This)
#define XMLDOMDocumentEvents_Release(This) (This)->lpVtbl->Release(This)
#define XMLDOMDocumentEvents_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define XMLDOMDocumentEvents_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define XMLDOMDocumentEvents_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define XMLDOMDocumentEvents_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#endif
#endif
#endif

#ifndef __IDSOControl_INTERFACE_DEFINED__
#define __IDSOControl_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IDSOControl;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IDSOControl : public IDispatch {
    public:
      virtual HRESULT WINAPI get_XMLDocument(IXMLDOMDocument **ppDoc) = 0;
      virtual HRESULT WINAPI put_XMLDocument(IXMLDOMDocument *ppDoc) = 0;
      virtual HRESULT WINAPI get_JavaDSOCompatible(WINBOOL *fJavaDSOCompatible) = 0;
      virtual HRESULT WINAPI put_JavaDSOCompatible(WINBOOL fJavaDSOCompatible) = 0;
      virtual HRESULT WINAPI get_readyState(long *state) = 0;
    };
#else
    typedef struct IDSOControlVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IDSOControl *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IDSOControl *This);
	ULONG (WINAPI *Release)(IDSOControl *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IDSOControl *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IDSOControl *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IDSOControl *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IDSOControl *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_XMLDocument)(IDSOControl *This,IXMLDOMDocument **ppDoc);
	HRESULT (WINAPI *put_XMLDocument)(IDSOControl *This,IXMLDOMDocument *ppDoc);
	HRESULT (WINAPI *get_JavaDSOCompatible)(IDSOControl *This,WINBOOL *fJavaDSOCompatible);
	HRESULT (WINAPI *put_JavaDSOCompatible)(IDSOControl *This,WINBOOL fJavaDSOCompatible);
	HRESULT (WINAPI *get_readyState)(IDSOControl *This,long *state);
      END_INTERFACE
    } IDSOControlVtbl;
    struct IDSOControl {
      CONST_VTBL struct IDSOControlVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IDSOControl_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IDSOControl_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IDSOControl_Release(This) (This)->lpVtbl->Release(This)
#define IDSOControl_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IDSOControl_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IDSOControl_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IDSOControl_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IDSOControl_get_XMLDocument(This,ppDoc) (This)->lpVtbl->get_XMLDocument(This,ppDoc)
#define IDSOControl_put_XMLDocument(This,ppDoc) (This)->lpVtbl->put_XMLDocument(This,ppDoc)
#define IDSOControl_get_JavaDSOCompatible(This,fJavaDSOCompatible) (This)->lpVtbl->get_JavaDSOCompatible(This,fJavaDSOCompatible)
#define IDSOControl_put_JavaDSOCompatible(This,fJavaDSOCompatible) (This)->lpVtbl->put_JavaDSOCompatible(This,fJavaDSOCompatible)
#define IDSOControl_get_readyState(This,state) (This)->lpVtbl->get_readyState(This,state)
#endif
#endif
    HRESULT WINAPI IDSOControl_get_XMLDocument_Proxy(IDSOControl *This,IXMLDOMDocument **ppDoc);
    void __RPC_STUB IDSOControl_get_XMLDocument_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IDSOControl_put_XMLDocument_Proxy(IDSOControl *This,IXMLDOMDocument *ppDoc);
    void __RPC_STUB IDSOControl_put_XMLDocument_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IDSOControl_get_JavaDSOCompatible_Proxy(IDSOControl *This,WINBOOL *fJavaDSOCompatible);
    void __RPC_STUB IDSOControl_get_JavaDSOCompatible_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IDSOControl_put_JavaDSOCompatible_Proxy(IDSOControl *This,WINBOOL fJavaDSOCompatible);
    void __RPC_STUB IDSOControl_put_JavaDSOCompatible_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IDSOControl_get_readyState_Proxy(IDSOControl *This,long *state);
    void __RPC_STUB IDSOControl_get_readyState_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IXMLHTTPRequest_INTERFACE_DEFINED__
#define __IXMLHTTPRequest_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IXMLHTTPRequest;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IXMLHTTPRequest : public IDispatch {
    public:
      virtual HRESULT WINAPI open(BSTR bstrMethod,BSTR bstrUrl,VARIANT varAsync,VARIANT bstrUser,VARIANT bstrPassword) = 0;
      virtual HRESULT WINAPI setRequestHeader(BSTR bstrHeader,BSTR bstrValue) = 0;
      virtual HRESULT WINAPI getResponseHeader(BSTR bstrHeader,BSTR *pbstrValue) = 0;
      virtual HRESULT WINAPI getAllResponseHeaders(BSTR *pbstrHeaders) = 0;
      virtual HRESULT WINAPI send(VARIANT varBody) = 0;
      virtual HRESULT WINAPI abort(void) = 0;
      virtual HRESULT WINAPI get_status(long *plStatus) = 0;
      virtual HRESULT WINAPI get_statusText(BSTR *pbstrStatus) = 0;
      virtual HRESULT WINAPI get_responseXML(IDispatch **ppBody) = 0;
      virtual HRESULT WINAPI get_responseText(BSTR *pbstrBody) = 0;
      virtual HRESULT WINAPI get_responseBody(VARIANT *pvarBody) = 0;
      virtual HRESULT WINAPI get_responseStream(VARIANT *pvarBody) = 0;
      virtual HRESULT WINAPI get_readyState(long *plState) = 0;
      virtual HRESULT WINAPI put_onreadystatechange(IDispatch *pReadyStateSink) = 0;
    };
#else
    typedef struct IXMLHTTPRequestVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IXMLHTTPRequest *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IXMLHTTPRequest *This);
	ULONG (WINAPI *Release)(IXMLHTTPRequest *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IXMLHTTPRequest *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IXMLHTTPRequest *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IXMLHTTPRequest *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IXMLHTTPRequest *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *open)(IXMLHTTPRequest *This,BSTR bstrMethod,BSTR bstrUrl,VARIANT varAsync,VARIANT bstrUser,VARIANT bstrPassword);
	HRESULT (WINAPI *setRequestHeader)(IXMLHTTPRequest *This,BSTR bstrHeader,BSTR bstrValue);
	HRESULT (WINAPI *getResponseHeader)(IXMLHTTPRequest *This,BSTR bstrHeader,BSTR *pbstrValue);
	HRESULT (WINAPI *getAllResponseHeaders)(IXMLHTTPRequest *This,BSTR *pbstrHeaders);
	HRESULT (WINAPI *send)(IXMLHTTPRequest *This,VARIANT varBody);
	HRESULT (WINAPI *abort)(IXMLHTTPRequest *This);
	HRESULT (WINAPI *get_status)(IXMLHTTPRequest *This,long *plStatus);
	HRESULT (WINAPI *get_statusText)(IXMLHTTPRequest *This,BSTR *pbstrStatus);
	HRESULT (WINAPI *get_responseXML)(IXMLHTTPRequest *This,IDispatch **ppBody);
	HRESULT (WINAPI *get_responseText)(IXMLHTTPRequest *This,BSTR *pbstrBody);
	HRESULT (WINAPI *get_responseBody)(IXMLHTTPRequest *This,VARIANT *pvarBody);
	HRESULT (WINAPI *get_responseStream)(IXMLHTTPRequest *This,VARIANT *pvarBody);
	HRESULT (WINAPI *get_readyState)(IXMLHTTPRequest *This,long *plState);
	HRESULT (WINAPI *put_onreadystatechange)(IXMLHTTPRequest *This,IDispatch *pReadyStateSink);
      END_INTERFACE
    } IXMLHTTPRequestVtbl;
    struct IXMLHTTPRequest {
      CONST_VTBL struct IXMLHTTPRequestVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IXMLHTTPRequest_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IXMLHTTPRequest_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IXMLHTTPRequest_Release(This) (This)->lpVtbl->Release(This)
#define IXMLHTTPRequest_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IXMLHTTPRequest_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IXMLHTTPRequest_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IXMLHTTPRequest_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IXMLHTTPRequest_open(This,bstrMethod,bstrUrl,varAsync,bstrUser,bstrPassword) (This)->lpVtbl->open(This,bstrMethod,bstrUrl,varAsync,bstrUser,bstrPassword)
#define IXMLHTTPRequest_setRequestHeader(This,bstrHeader,bstrValue) (This)->lpVtbl->setRequestHeader(This,bstrHeader,bstrValue)
#define IXMLHTTPRequest_getResponseHeader(This,bstrHeader,pbstrValue) (This)->lpVtbl->getResponseHeader(This,bstrHeader,pbstrValue)
#define IXMLHTTPRequest_getAllResponseHeaders(This,pbstrHeaders) (This)->lpVtbl->getAllResponseHeaders(This,pbstrHeaders)
#define IXMLHTTPRequest_send(This,varBody) (This)->lpVtbl->send(This,varBody)
#define IXMLHTTPRequest_abort(This) (This)->lpVtbl->abort(This)
#define IXMLHTTPRequest_get_status(This,plStatus) (This)->lpVtbl->get_status(This,plStatus)
#define IXMLHTTPRequest_get_statusText(This,pbstrStatus) (This)->lpVtbl->get_statusText(This,pbstrStatus)
#define IXMLHTTPRequest_get_responseXML(This,ppBody) (This)->lpVtbl->get_responseXML(This,ppBody)
#define IXMLHTTPRequest_get_responseText(This,pbstrBody) (This)->lpVtbl->get_responseText(This,pbstrBody)
#define IXMLHTTPRequest_get_responseBody(This,pvarBody) (This)->lpVtbl->get_responseBody(This,pvarBody)
#define IXMLHTTPRequest_get_responseStream(This,pvarBody) (This)->lpVtbl->get_responseStream(This,pvarBody)
#define IXMLHTTPRequest_get_readyState(This,plState) (This)->lpVtbl->get_readyState(This,plState)
#define IXMLHTTPRequest_put_onreadystatechange(This,pReadyStateSink) (This)->lpVtbl->put_onreadystatechange(This,pReadyStateSink)
#endif
#endif
    HRESULT WINAPI IXMLHTTPRequest_open_Proxy(IXMLHTTPRequest *This,BSTR bstrMethod,BSTR bstrUrl,VARIANT varAsync,VARIANT bstrUser,VARIANT bstrPassword);
    void __RPC_STUB IXMLHTTPRequest_open_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_setRequestHeader_Proxy(IXMLHTTPRequest *This,BSTR bstrHeader,BSTR bstrValue);
    void __RPC_STUB IXMLHTTPRequest_setRequestHeader_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_getResponseHeader_Proxy(IXMLHTTPRequest *This,BSTR bstrHeader,BSTR *pbstrValue);
    void __RPC_STUB IXMLHTTPRequest_getResponseHeader_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_getAllResponseHeaders_Proxy(IXMLHTTPRequest *This,BSTR *pbstrHeaders);
    void __RPC_STUB IXMLHTTPRequest_getAllResponseHeaders_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_send_Proxy(IXMLHTTPRequest *This,VARIANT varBody);
    void __RPC_STUB IXMLHTTPRequest_send_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_abort_Proxy(IXMLHTTPRequest *This);
    void __RPC_STUB IXMLHTTPRequest_abort_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_get_status_Proxy(IXMLHTTPRequest *This,long *plStatus);
    void __RPC_STUB IXMLHTTPRequest_get_status_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_get_statusText_Proxy(IXMLHTTPRequest *This,BSTR *pbstrStatus);
    void __RPC_STUB IXMLHTTPRequest_get_statusText_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_get_responseXML_Proxy(IXMLHTTPRequest *This,IDispatch **ppBody);
    void __RPC_STUB IXMLHTTPRequest_get_responseXML_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_get_responseText_Proxy(IXMLHTTPRequest *This,BSTR *pbstrBody);
    void __RPC_STUB IXMLHTTPRequest_get_responseText_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_get_responseBody_Proxy(IXMLHTTPRequest *This,VARIANT *pvarBody);
    void __RPC_STUB IXMLHTTPRequest_get_responseBody_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_get_responseStream_Proxy(IXMLHTTPRequest *This,VARIANT *pvarBody);
    void __RPC_STUB IXMLHTTPRequest_get_responseStream_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_get_readyState_Proxy(IXMLHTTPRequest *This,long *plState);
    void __RPC_STUB IXMLHTTPRequest_get_readyState_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IXMLHTTPRequest_put_onreadystatechange_Proxy(IXMLHTTPRequest *This,IDispatch *pReadyStateSink);
    void __RPC_STUB IXMLHTTPRequest_put_onreadystatechange_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IServerXMLHTTPRequest_INTERFACE_DEFINED__
#define __IServerXMLHTTPRequest_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IServerXMLHTTPRequest;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IServerXMLHTTPRequest : public IXMLHTTPRequest {
    public:
      virtual HRESULT WINAPI setTimeouts(long resolveTimeout,long connectTimeout,long sendTimeout,long receiveTimeout) = 0;
      virtual HRESULT WINAPI waitForResponse(VARIANT timeoutInSeconds,VARIANT_BOOL *isSuccessful) = 0;
      virtual HRESULT WINAPI getOption(SERVERXMLHTTP_OPTION option,VARIANT *value) = 0;
      virtual HRESULT WINAPI setOption(SERVERXMLHTTP_OPTION option,VARIANT value) = 0;
    };
#else
    typedef struct IServerXMLHTTPRequestVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IServerXMLHTTPRequest *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IServerXMLHTTPRequest *This);
	ULONG (WINAPI *Release)(IServerXMLHTTPRequest *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IServerXMLHTTPRequest *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IServerXMLHTTPRequest *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IServerXMLHTTPRequest *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IServerXMLHTTPRequest *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *open)(IServerXMLHTTPRequest *This,BSTR bstrMethod,BSTR bstrUrl,VARIANT varAsync,VARIANT bstrUser,VARIANT bstrPassword);
	HRESULT (WINAPI *setRequestHeader)(IServerXMLHTTPRequest *This,BSTR bstrHeader,BSTR bstrValue);
	HRESULT (WINAPI *getResponseHeader)(IServerXMLHTTPRequest *This,BSTR bstrHeader,BSTR *pbstrValue);
	HRESULT (WINAPI *getAllResponseHeaders)(IServerXMLHTTPRequest *This,BSTR *pbstrHeaders);
	HRESULT (WINAPI *send)(IServerXMLHTTPRequest *This,VARIANT varBody);
	HRESULT (WINAPI *abort)(IServerXMLHTTPRequest *This);
	HRESULT (WINAPI *get_status)(IServerXMLHTTPRequest *This,long *plStatus);
	HRESULT (WINAPI *get_statusText)(IServerXMLHTTPRequest *This,BSTR *pbstrStatus);
	HRESULT (WINAPI *get_responseXML)(IServerXMLHTTPRequest *This,IDispatch **ppBody);
	HRESULT (WINAPI *get_responseText)(IServerXMLHTTPRequest *This,BSTR *pbstrBody);
	HRESULT (WINAPI *get_responseBody)(IServerXMLHTTPRequest *This,VARIANT *pvarBody);
	HRESULT (WINAPI *get_responseStream)(IServerXMLHTTPRequest *This,VARIANT *pvarBody);
	HRESULT (WINAPI *get_readyState)(IServerXMLHTTPRequest *This,long *plState);
	HRESULT (WINAPI *put_onreadystatechange)(IServerXMLHTTPRequest *This,IDispatch *pReadyStateSink);
	HRESULT (WINAPI *setTimeouts)(IServerXMLHTTPRequest *This,long resolveTimeout,long connectTimeout,long sendTimeout,long receiveTimeout);
	HRESULT (WINAPI *waitForResponse)(IServerXMLHTTPRequest *This,VARIANT timeoutInSeconds,VARIANT_BOOL *isSuccessful);
	HRESULT (WINAPI *getOption)(IServerXMLHTTPRequest *This,SERVERXMLHTTP_OPTION option,VARIANT *value);
	HRESULT (WINAPI *setOption)(IServerXMLHTTPRequest *This,SERVERXMLHTTP_OPTION option,VARIANT value);
      END_INTERFACE
    } IServerXMLHTTPRequestVtbl;
    struct IServerXMLHTTPRequest {
      CONST_VTBL struct IServerXMLHTTPRequestVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IServerXMLHTTPRequest_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IServerXMLHTTPRequest_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IServerXMLHTTPRequest_Release(This) (This)->lpVtbl->Release(This)
#define IServerXMLHTTPRequest_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IServerXMLHTTPRequest_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IServerXMLHTTPRequest_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IServerXMLHTTPRequest_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IServerXMLHTTPRequest_open(This,bstrMethod,bstrUrl,varAsync,bstrUser,bstrPassword) (This)->lpVtbl->open(This,bstrMethod,bstrUrl,varAsync,bstrUser,bstrPassword)
#define IServerXMLHTTPRequest_setRequestHeader(This,bstrHeader,bstrValue) (This)->lpVtbl->setRequestHeader(This,bstrHeader,bstrValue)
#define IServerXMLHTTPRequest_getResponseHeader(This,bstrHeader,pbstrValue) (This)->lpVtbl->getResponseHeader(This,bstrHeader,pbstrValue)
#define IServerXMLHTTPRequest_getAllResponseHeaders(This,pbstrHeaders) (This)->lpVtbl->getAllResponseHeaders(This,pbstrHeaders)
#define IServerXMLHTTPRequest_send(This,varBody) (This)->lpVtbl->send(This,varBody)
#define IServerXMLHTTPRequest_abort(This) (This)->lpVtbl->abort(This)
#define IServerXMLHTTPRequest_get_status(This,plStatus) (This)->lpVtbl->get_status(This,plStatus)
#define IServerXMLHTTPRequest_get_statusText(This,pbstrStatus) (This)->lpVtbl->get_statusText(This,pbstrStatus)
#define IServerXMLHTTPRequest_get_responseXML(This,ppBody) (This)->lpVtbl->get_responseXML(This,ppBody)
#define IServerXMLHTTPRequest_get_responseText(This,pbstrBody) (This)->lpVtbl->get_responseText(This,pbstrBody)
#define IServerXMLHTTPRequest_get_responseBody(This,pvarBody) (This)->lpVtbl->get_responseBody(This,pvarBody)
#define IServerXMLHTTPRequest_get_responseStream(This,pvarBody) (This)->lpVtbl->get_responseStream(This,pvarBody)
#define IServerXMLHTTPRequest_get_readyState(This,plState) (This)->lpVtbl->get_readyState(This,plState)
#define IServerXMLHTTPRequest_put_onreadystatechange(This,pReadyStateSink) (This)->lpVtbl->put_onreadystatechange(This,pReadyStateSink)
#define IServerXMLHTTPRequest_setTimeouts(This,resolveTimeout,connectTimeout,sendTimeout,receiveTimeout) (This)->lpVtbl->setTimeouts(This,resolveTimeout,connectTimeout,sendTimeout,receiveTimeout)
#define IServerXMLHTTPRequest_waitForResponse(This,timeoutInSeconds,isSuccessful) (This)->lpVtbl->waitForResponse(This,timeoutInSeconds,isSuccessful)
#define IServerXMLHTTPRequest_getOption(This,option,value) (This)->lpVtbl->getOption(This,option,value)
#define IServerXMLHTTPRequest_setOption(This,option,value) (This)->lpVtbl->setOption(This,option,value)
#endif
#endif
    HRESULT WINAPI IServerXMLHTTPRequest_setTimeouts_Proxy(IServerXMLHTTPRequest *This,long resolveTimeout,long connectTimeout,long sendTimeout,long receiveTimeout);
    void __RPC_STUB IServerXMLHTTPRequest_setTimeouts_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IServerXMLHTTPRequest_waitForResponse_Proxy(IServerXMLHTTPRequest *This,VARIANT timeoutInSeconds,VARIANT_BOOL *isSuccessful);
    void __RPC_STUB IServerXMLHTTPRequest_waitForResponse_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IServerXMLHTTPRequest_getOption_Proxy(IServerXMLHTTPRequest *This,SERVERXMLHTTP_OPTION option,VARIANT *value);
    void __RPC_STUB IServerXMLHTTPRequest_getOption_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IServerXMLHTTPRequest_setOption_Proxy(IServerXMLHTTPRequest *This,SERVERXMLHTTP_OPTION option,VARIANT value);
    void __RPC_STUB IServerXMLHTTPRequest_setOption_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IServerXMLHTTPRequest2_INTERFACE_DEFINED__
#define __IServerXMLHTTPRequest2_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IServerXMLHTTPRequest2;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IServerXMLHTTPRequest2 : public IServerXMLHTTPRequest {
    public:
      virtual HRESULT WINAPI setProxy(SXH_PROXY_SETTING proxySetting,VARIANT varProxyServer,VARIANT varBypassList) = 0;
      virtual HRESULT WINAPI setProxyCredentials(BSTR bstrUserName,BSTR bstrPassword) = 0;
    };
#else
    typedef struct IServerXMLHTTPRequest2Vtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IServerXMLHTTPRequest2 *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IServerXMLHTTPRequest2 *This);
	ULONG (WINAPI *Release)(IServerXMLHTTPRequest2 *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IServerXMLHTTPRequest2 *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IServerXMLHTTPRequest2 *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IServerXMLHTTPRequest2 *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IServerXMLHTTPRequest2 *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *open)(IServerXMLHTTPRequest2 *This,BSTR bstrMethod,BSTR bstrUrl,VARIANT varAsync,VARIANT bstrUser,VARIANT bstrPassword);
	HRESULT (WINAPI *setRequestHeader)(IServerXMLHTTPRequest2 *This,BSTR bstrHeader,BSTR bstrValue);
	HRESULT (WINAPI *getResponseHeader)(IServerXMLHTTPRequest2 *This,BSTR bstrHeader,BSTR *pbstrValue);
	HRESULT (WINAPI *getAllResponseHeaders)(IServerXMLHTTPRequest2 *This,BSTR *pbstrHeaders);
	HRESULT (WINAPI *send)(IServerXMLHTTPRequest2 *This,VARIANT varBody);
	HRESULT (WINAPI *abort)(IServerXMLHTTPRequest2 *This);
	HRESULT (WINAPI *get_status)(IServerXMLHTTPRequest2 *This,long *plStatus);
	HRESULT (WINAPI *get_statusText)(IServerXMLHTTPRequest2 *This,BSTR *pbstrStatus);
	HRESULT (WINAPI *get_responseXML)(IServerXMLHTTPRequest2 *This,IDispatch **ppBody);
	HRESULT (WINAPI *get_responseText)(IServerXMLHTTPRequest2 *This,BSTR *pbstrBody);
	HRESULT (WINAPI *get_responseBody)(IServerXMLHTTPRequest2 *This,VARIANT *pvarBody);
	HRESULT (WINAPI *get_responseStream)(IServerXMLHTTPRequest2 *This,VARIANT *pvarBody);
	HRESULT (WINAPI *get_readyState)(IServerXMLHTTPRequest2 *This,long *plState);
	HRESULT (WINAPI *put_onreadystatechange)(IServerXMLHTTPRequest2 *This,IDispatch *pReadyStateSink);
	HRESULT (WINAPI *setTimeouts)(IServerXMLHTTPRequest2 *This,long resolveTimeout,long connectTimeout,long sendTimeout,long receiveTimeout);
	HRESULT (WINAPI *waitForResponse)(IServerXMLHTTPRequest2 *This,VARIANT timeoutInSeconds,VARIANT_BOOL *isSuccessful);
	HRESULT (WINAPI *getOption)(IServerXMLHTTPRequest2 *This,SERVERXMLHTTP_OPTION option,VARIANT *value);
	HRESULT (WINAPI *setOption)(IServerXMLHTTPRequest2 *This,SERVERXMLHTTP_OPTION option,VARIANT value);
	HRESULT (WINAPI *setProxy)(IServerXMLHTTPRequest2 *This,SXH_PROXY_SETTING proxySetting,VARIANT varProxyServer,VARIANT varBypassList);
	HRESULT (WINAPI *setProxyCredentials)(IServerXMLHTTPRequest2 *This,BSTR bstrUserName,BSTR bstrPassword);
      END_INTERFACE
    } IServerXMLHTTPRequest2Vtbl;
    struct IServerXMLHTTPRequest2 {
      CONST_VTBL struct IServerXMLHTTPRequest2Vtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IServerXMLHTTPRequest2_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IServerXMLHTTPRequest2_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IServerXMLHTTPRequest2_Release(This) (This)->lpVtbl->Release(This)
#define IServerXMLHTTPRequest2_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IServerXMLHTTPRequest2_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IServerXMLHTTPRequest2_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IServerXMLHTTPRequest2_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IServerXMLHTTPRequest2_open(This,bstrMethod,bstrUrl,varAsync,bstrUser,bstrPassword) (This)->lpVtbl->open(This,bstrMethod,bstrUrl,varAsync,bstrUser,bstrPassword)
#define IServerXMLHTTPRequest2_setRequestHeader(This,bstrHeader,bstrValue) (This)->lpVtbl->setRequestHeader(This,bstrHeader,bstrValue)
#define IServerXMLHTTPRequest2_getResponseHeader(This,bstrHeader,pbstrValue) (This)->lpVtbl->getResponseHeader(This,bstrHeader,pbstrValue)
#define IServerXMLHTTPRequest2_getAllResponseHeaders(This,pbstrHeaders) (This)->lpVtbl->getAllResponseHeaders(This,pbstrHeaders)
#define IServerXMLHTTPRequest2_send(This,varBody) (This)->lpVtbl->send(This,varBody)
#define IServerXMLHTTPRequest2_abort(This) (This)->lpVtbl->abort(This)
#define IServerXMLHTTPRequest2_get_status(This,plStatus) (This)->lpVtbl->get_status(This,plStatus)
#define IServerXMLHTTPRequest2_get_statusText(This,pbstrStatus) (This)->lpVtbl->get_statusText(This,pbstrStatus)
#define IServerXMLHTTPRequest2_get_responseXML(This,ppBody) (This)->lpVtbl->get_responseXML(This,ppBody)
#define IServerXMLHTTPRequest2_get_responseText(This,pbstrBody) (This)->lpVtbl->get_responseText(This,pbstrBody)
#define IServerXMLHTTPRequest2_get_responseBody(This,pvarBody) (This)->lpVtbl->get_responseBody(This,pvarBody)
#define IServerXMLHTTPRequest2_get_responseStream(This,pvarBody) (This)->lpVtbl->get_responseStream(This,pvarBody)
#define IServerXMLHTTPRequest2_get_readyState(This,plState) (This)->lpVtbl->get_readyState(This,plState)
#define IServerXMLHTTPRequest2_put_onreadystatechange(This,pReadyStateSink) (This)->lpVtbl->put_onreadystatechange(This,pReadyStateSink)
#define IServerXMLHTTPRequest2_setTimeouts(This,resolveTimeout,connectTimeout,sendTimeout,receiveTimeout) (This)->lpVtbl->setTimeouts(This,resolveTimeout,connectTimeout,sendTimeout,receiveTimeout)
#define IServerXMLHTTPRequest2_waitForResponse(This,timeoutInSeconds,isSuccessful) (This)->lpVtbl->waitForResponse(This,timeoutInSeconds,isSuccessful)
#define IServerXMLHTTPRequest2_getOption(This,option,value) (This)->lpVtbl->getOption(This,option,value)
#define IServerXMLHTTPRequest2_setOption(This,option,value) (This)->lpVtbl->setOption(This,option,value)
#define IServerXMLHTTPRequest2_setProxy(This,proxySetting,varProxyServer,varBypassList) (This)->lpVtbl->setProxy(This,proxySetting,varProxyServer,varBypassList)
#define IServerXMLHTTPRequest2_setProxyCredentials(This,bstrUserName,bstrPassword) (This)->lpVtbl->setProxyCredentials(This,bstrUserName,bstrPassword)
#endif
#endif
    HRESULT WINAPI IServerXMLHTTPRequest2_setProxy_Proxy(IServerXMLHTTPRequest2 *This,SXH_PROXY_SETTING proxySetting,VARIANT varProxyServer,VARIANT varBypassList);
    void __RPC_STUB IServerXMLHTTPRequest2_setProxy_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IServerXMLHTTPRequest2_setProxyCredentials_Proxy(IServerXMLHTTPRequest2 *This,BSTR bstrUserName,BSTR bstrPassword);
    void __RPC_STUB IServerXMLHTTPRequest2_setProxyCredentials_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IMXNamespacePrefixes_INTERFACE_DEFINED__
#define __IMXNamespacePrefixes_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IMXNamespacePrefixes;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IMXNamespacePrefixes : public IDispatch {
    public:
      virtual HRESULT WINAPI get_item(long index,BSTR *prefix) = 0;
      virtual HRESULT WINAPI get_length(long *length) = 0;
      virtual HRESULT WINAPI get__newEnum(IUnknown **ppUnk) = 0;
    };
#else
    typedef struct IMXNamespacePrefixesVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IMXNamespacePrefixes *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IMXNamespacePrefixes *This);
	ULONG (WINAPI *Release)(IMXNamespacePrefixes *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IMXNamespacePrefixes *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IMXNamespacePrefixes *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IMXNamespacePrefixes *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IMXNamespacePrefixes *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *get_item)(IMXNamespacePrefixes *This,long index,BSTR *prefix);
	HRESULT (WINAPI *get_length)(IMXNamespacePrefixes *This,long *length);
	HRESULT (WINAPI *get__newEnum)(IMXNamespacePrefixes *This,IUnknown **ppUnk);
      END_INTERFACE
    } IMXNamespacePrefixesVtbl;
    struct IMXNamespacePrefixes {
      CONST_VTBL struct IMXNamespacePrefixesVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IMXNamespacePrefixes_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IMXNamespacePrefixes_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IMXNamespacePrefixes_Release(This) (This)->lpVtbl->Release(This)
#define IMXNamespacePrefixes_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IMXNamespacePrefixes_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IMXNamespacePrefixes_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IMXNamespacePrefixes_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IMXNamespacePrefixes_get_item(This,index,prefix) (This)->lpVtbl->get_item(This,index,prefix)
#define IMXNamespacePrefixes_get_length(This,length) (This)->lpVtbl->get_length(This,length)
#define IMXNamespacePrefixes_get__newEnum(This,ppUnk) (This)->lpVtbl->get__newEnum(This,ppUnk)
#endif
#endif
    HRESULT WINAPI IMXNamespacePrefixes_get_item_Proxy(IMXNamespacePrefixes *This,long index,BSTR *prefix);
    void __RPC_STUB IMXNamespacePrefixes_get_item_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespacePrefixes_get_length_Proxy(IMXNamespacePrefixes *This,long *length);
    void __RPC_STUB IMXNamespacePrefixes_get_length_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespacePrefixes_get__newEnum_Proxy(IMXNamespacePrefixes *This,IUnknown **ppUnk);
    void __RPC_STUB IMXNamespacePrefixes_get__newEnum_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IVBMXNamespaceManager_INTERFACE_DEFINED__
#define __IVBMXNamespaceManager_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IVBMXNamespaceManager;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IVBMXNamespaceManager : public IDispatch {
    public:
      virtual HRESULT WINAPI put_allowOverride(VARIANT_BOOL fOverride) = 0;
      virtual HRESULT WINAPI get_allowOverride(VARIANT_BOOL *fOverride) = 0;
      virtual HRESULT WINAPI reset(void) = 0;
      virtual HRESULT WINAPI pushContext(void) = 0;
      virtual HRESULT WINAPI pushNodeContext(IXMLDOMNode *contextNode,VARIANT_BOOL fDeep = -1) = 0;
      virtual HRESULT WINAPI popContext(void) = 0;
      virtual HRESULT WINAPI declarePrefix(BSTR prefix,BSTR namespaceURI) = 0;
      virtual HRESULT WINAPI getDeclaredPrefixes(IMXNamespacePrefixes **prefixes) = 0;
      virtual HRESULT WINAPI getPrefixes(BSTR namespaceURI,IMXNamespacePrefixes **prefixes) = 0;
      virtual HRESULT WINAPI getURI(BSTR prefix,VARIANT *uri) = 0;
      virtual HRESULT WINAPI getURIFromNode(BSTR strPrefix,IXMLDOMNode *contextNode,VARIANT *uri) = 0;
    };
#else
    typedef struct IVBMXNamespaceManagerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IVBMXNamespaceManager *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IVBMXNamespaceManager *This);
	ULONG (WINAPI *Release)(IVBMXNamespaceManager *This);
	HRESULT (WINAPI *GetTypeInfoCount)(IVBMXNamespaceManager *This,UINT *pctinfo);
	HRESULT (WINAPI *GetTypeInfo)(IVBMXNamespaceManager *This,UINT iTInfo,LCID lcid,ITypeInfo **ppTInfo);
	HRESULT (WINAPI *GetIDsOfNames)(IVBMXNamespaceManager *This,REFIID riid,LPOLESTR *rgszNames,UINT cNames,LCID lcid,DISPID *rgDispId);
	HRESULT (WINAPI *Invoke)(IVBMXNamespaceManager *This,DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS *pDispParams,VARIANT *pVarResult,EXCEPINFO *pExcepInfo,UINT *puArgErr);
	HRESULT (WINAPI *put_allowOverride)(IVBMXNamespaceManager *This,VARIANT_BOOL fOverride);
	HRESULT (WINAPI *get_allowOverride)(IVBMXNamespaceManager *This,VARIANT_BOOL *fOverride);
	HRESULT (WINAPI *reset)(IVBMXNamespaceManager *This);
	HRESULT (WINAPI *pushContext)(IVBMXNamespaceManager *This);
	HRESULT (WINAPI *pushNodeContext)(IVBMXNamespaceManager *This,IXMLDOMNode *contextNode,VARIANT_BOOL fDeep);
	HRESULT (WINAPI *popContext)(IVBMXNamespaceManager *This);
	HRESULT (WINAPI *declarePrefix)(IVBMXNamespaceManager *This,BSTR prefix,BSTR namespaceURI);
	HRESULT (WINAPI *getDeclaredPrefixes)(IVBMXNamespaceManager *This,IMXNamespacePrefixes **prefixes);
	HRESULT (WINAPI *getPrefixes)(IVBMXNamespaceManager *This,BSTR namespaceURI,IMXNamespacePrefixes **prefixes);
	HRESULT (WINAPI *getURI)(IVBMXNamespaceManager *This,BSTR prefix,VARIANT *uri);
	HRESULT (WINAPI *getURIFromNode)(IVBMXNamespaceManager *This,BSTR strPrefix,IXMLDOMNode *contextNode,VARIANT *uri);
      END_INTERFACE
    } IVBMXNamespaceManagerVtbl;
    struct IVBMXNamespaceManager {
      CONST_VTBL struct IVBMXNamespaceManagerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IVBMXNamespaceManager_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IVBMXNamespaceManager_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IVBMXNamespaceManager_Release(This) (This)->lpVtbl->Release(This)
#define IVBMXNamespaceManager_GetTypeInfoCount(This,pctinfo) (This)->lpVtbl->GetTypeInfoCount(This,pctinfo)
#define IVBMXNamespaceManager_GetTypeInfo(This,iTInfo,lcid,ppTInfo) (This)->lpVtbl->GetTypeInfo(This,iTInfo,lcid,ppTInfo)
#define IVBMXNamespaceManager_GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId) (This)->lpVtbl->GetIDsOfNames(This,riid,rgszNames,cNames,lcid,rgDispId)
#define IVBMXNamespaceManager_Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr) (This)->lpVtbl->Invoke(This,dispIdMember,riid,lcid,wFlags,pDispParams,pVarResult,pExcepInfo,puArgErr)
#define IVBMXNamespaceManager_put_allowOverride(This,fOverride) (This)->lpVtbl->put_allowOverride(This,fOverride)
#define IVBMXNamespaceManager_get_allowOverride(This,fOverride) (This)->lpVtbl->get_allowOverride(This,fOverride)
#define IVBMXNamespaceManager_reset(This) (This)->lpVtbl->reset(This)
#define IVBMXNamespaceManager_pushContext(This) (This)->lpVtbl->pushContext(This)
#define IVBMXNamespaceManager_pushNodeContext(This,contextNode,fDeep) (This)->lpVtbl->pushNodeContext(This,contextNode,fDeep)
#define IVBMXNamespaceManager_popContext(This) (This)->lpVtbl->popContext(This)
#define IVBMXNamespaceManager_declarePrefix(This,prefix,namespaceURI) (This)->lpVtbl->declarePrefix(This,prefix,namespaceURI)
#define IVBMXNamespaceManager_getDeclaredPrefixes(This,prefixes) (This)->lpVtbl->getDeclaredPrefixes(This,prefixes)
#define IVBMXNamespaceManager_getPrefixes(This,namespaceURI,prefixes) (This)->lpVtbl->getPrefixes(This,namespaceURI,prefixes)
#define IVBMXNamespaceManager_getURI(This,prefix,uri) (This)->lpVtbl->getURI(This,prefix,uri)
#define IVBMXNamespaceManager_getURIFromNode(This,strPrefix,contextNode,uri) (This)->lpVtbl->getURIFromNode(This,strPrefix,contextNode,uri)
#endif
#endif
    HRESULT WINAPI IVBMXNamespaceManager_put_allowOverride_Proxy(IVBMXNamespaceManager *This,VARIANT_BOOL fOverride);
    void __RPC_STUB IVBMXNamespaceManager_put_allowOverride_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBMXNamespaceManager_get_allowOverride_Proxy(IVBMXNamespaceManager *This,VARIANT_BOOL *fOverride);
    void __RPC_STUB IVBMXNamespaceManager_get_allowOverride_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBMXNamespaceManager_reset_Proxy(IVBMXNamespaceManager *This);
    void __RPC_STUB IVBMXNamespaceManager_reset_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBMXNamespaceManager_pushContext_Proxy(IVBMXNamespaceManager *This);
    void __RPC_STUB IVBMXNamespaceManager_pushContext_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBMXNamespaceManager_pushNodeContext_Proxy(IVBMXNamespaceManager *This,IXMLDOMNode *contextNode,VARIANT_BOOL fDeep);
    void __RPC_STUB IVBMXNamespaceManager_pushNodeContext_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBMXNamespaceManager_popContext_Proxy(IVBMXNamespaceManager *This);
    void __RPC_STUB IVBMXNamespaceManager_popContext_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBMXNamespaceManager_declarePrefix_Proxy(IVBMXNamespaceManager *This,BSTR prefix,BSTR namespaceURI);
    void __RPC_STUB IVBMXNamespaceManager_declarePrefix_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBMXNamespaceManager_getDeclaredPrefixes_Proxy(IVBMXNamespaceManager *This,IMXNamespacePrefixes **prefixes);
    void __RPC_STUB IVBMXNamespaceManager_getDeclaredPrefixes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBMXNamespaceManager_getPrefixes_Proxy(IVBMXNamespaceManager *This,BSTR namespaceURI,IMXNamespacePrefixes **prefixes);
    void __RPC_STUB IVBMXNamespaceManager_getPrefixes_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBMXNamespaceManager_getURI_Proxy(IVBMXNamespaceManager *This,BSTR prefix,VARIANT *uri);
    void __RPC_STUB IVBMXNamespaceManager_getURI_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IVBMXNamespaceManager_getURIFromNode_Proxy(IVBMXNamespaceManager *This,BSTR strPrefix,IXMLDOMNode *contextNode,VARIANT *uri);
    void __RPC_STUB IVBMXNamespaceManager_getURIFromNode_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

#ifndef __IMXNamespaceManager_INTERFACE_DEFINED__
#define __IMXNamespaceManager_INTERFACE_DEFINED__
    EXTERN_C const IID IID_IMXNamespaceManager;
#if defined(__cplusplus) && !defined(CINTERFACE)
    struct IMXNamespaceManager : public IUnknown {
    public:
      virtual HRESULT WINAPI putAllowOverride(VARIANT_BOOL fOverride) = 0;
      virtual HRESULT WINAPI getAllowOverride(VARIANT_BOOL *fOverride) = 0;
      virtual HRESULT WINAPI reset(void) = 0;
      virtual HRESULT WINAPI pushContext(void) = 0;
      virtual HRESULT WINAPI pushNodeContext(IXMLDOMNode *contextNode,VARIANT_BOOL fDeep) = 0;
      virtual HRESULT WINAPI popContext(void) = 0;
      virtual HRESULT WINAPI declarePrefix(const wchar_t *prefix,const wchar_t *namespaceURI) = 0;
      virtual HRESULT WINAPI getDeclaredPrefix(long nIndex,wchar_t *pwchPrefix,int *pcchPrefix) = 0;
      virtual HRESULT WINAPI getPrefix(const wchar_t *pwszNamespaceURI,long nIndex,wchar_t *pwchPrefix,int *pcchPrefix) = 0;
      virtual HRESULT WINAPI getURI(const wchar_t *pwchPrefix,IXMLDOMNode *pContextNode,wchar_t *pwchUri,int *pcchUri) = 0;
    };
#else
    typedef struct IMXNamespaceManagerVtbl {
      BEGIN_INTERFACE
	HRESULT (WINAPI *QueryInterface)(IMXNamespaceManager *This,REFIID riid,void **ppvObject);
	ULONG (WINAPI *AddRef)(IMXNamespaceManager *This);
	ULONG (WINAPI *Release)(IMXNamespaceManager *This);
	HRESULT (WINAPI *putAllowOverride)(IMXNamespaceManager *This,VARIANT_BOOL fOverride);
	HRESULT (WINAPI *getAllowOverride)(IMXNamespaceManager *This,VARIANT_BOOL *fOverride);
	HRESULT (WINAPI *reset)(IMXNamespaceManager *This);
	HRESULT (WINAPI *pushContext)(IMXNamespaceManager *This);
	HRESULT (WINAPI *pushNodeContext)(IMXNamespaceManager *This,IXMLDOMNode *contextNode,VARIANT_BOOL fDeep);
	HRESULT (WINAPI *popContext)(IMXNamespaceManager *This);
	HRESULT (WINAPI *declarePrefix)(IMXNamespaceManager *This,const wchar_t *prefix,const wchar_t *namespaceURI);
	HRESULT (WINAPI *getDeclaredPrefix)(IMXNamespaceManager *This,long nIndex,wchar_t *pwchPrefix,int *pcchPrefix);
	HRESULT (WINAPI *getPrefix)(IMXNamespaceManager *This,const wchar_t *pwszNamespaceURI,long nIndex,wchar_t *pwchPrefix,int *pcchPrefix);
	HRESULT (WINAPI *getURI)(IMXNamespaceManager *This,const wchar_t *pwchPrefix,IXMLDOMNode *pContextNode,wchar_t *pwchUri,int *pcchUri);
      END_INTERFACE
    } IMXNamespaceManagerVtbl;
    struct IMXNamespaceManager {
      CONST_VTBL struct IMXNamespaceManagerVtbl *lpVtbl;
    };
#ifdef COBJMACROS
#define IMXNamespaceManager_QueryInterface(This,riid,ppvObject) (This)->lpVtbl->QueryInterface(This,riid,ppvObject)
#define IMXNamespaceManager_AddRef(This) (This)->lpVtbl->AddRef(This)
#define IMXNamespaceManager_Release(This) (This)->lpVtbl->Release(This)
#define IMXNamespaceManager_putAllowOverride(This,fOverride) (This)->lpVtbl->putAllowOverride(This,fOverride)
#define IMXNamespaceManager_getAllowOverride(This,fOverride) (This)->lpVtbl->getAllowOverride(This,fOverride)
#define IMXNamespaceManager_reset(This) (This)->lpVtbl->reset(This)
#define IMXNamespaceManager_pushContext(This) (This)->lpVtbl->pushContext(This)
#define IMXNamespaceManager_pushNodeContext(This,contextNode,fDeep) (This)->lpVtbl->pushNodeContext(This,contextNode,fDeep)
#define IMXNamespaceManager_popContext(This) (This)->lpVtbl->popContext(This)
#define IMXNamespaceManager_declarePrefix(This,prefix,namespaceURI) (This)->lpVtbl->declarePrefix(This,prefix,namespaceURI)
#define IMXNamespaceManager_getDeclaredPrefix(This,nIndex,pwchPrefix,pcchPrefix) (This)->lpVtbl->getDeclaredPrefix(This,nIndex,pwchPrefix,pcchPrefix)
#define IMXNamespaceManager_getPrefix(This,pwszNamespaceURI,nIndex,pwchPrefix,pcchPrefix) (This)->lpVtbl->getPrefix(This,pwszNamespaceURI,nIndex,pwchPrefix,pcchPrefix)
#define IMXNamespaceManager_getURI(This,pwchPrefix,pContextNode,pwchUri,pcchUri) (This)->lpVtbl->getURI(This,pwchPrefix,pContextNode,pwchUri,pcchUri)
#endif
#endif
    HRESULT WINAPI IMXNamespaceManager_putAllowOverride_Proxy(IMXNamespaceManager *This,VARIANT_BOOL fOverride);
    void __RPC_STUB IMXNamespaceManager_putAllowOverride_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespaceManager_getAllowOverride_Proxy(IMXNamespaceManager *This,VARIANT_BOOL *fOverride);
    void __RPC_STUB IMXNamespaceManager_getAllowOverride_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespaceManager_reset_Proxy(IMXNamespaceManager *This);
    void __RPC_STUB IMXNamespaceManager_reset_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespaceManager_pushContext_Proxy(IMXNamespaceManager *This);
    void __RPC_STUB IMXNamespaceManager_pushContext_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespaceManager_pushNodeContext_Proxy(IMXNamespaceManager *This,IXMLDOMNode *contextNode,VARIANT_BOOL fDeep);
    void __RPC_STUB IMXNamespaceManager_pushNodeContext_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespaceManager_popContext_Proxy(IMXNamespaceManager *This);
    void __RPC_STUB IMXNamespaceManager_popContext_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespaceManager_declarePrefix_Proxy(IMXNamespaceManager *This,const wchar_t *prefix,const wchar_t *namespaceURI);
    void __RPC_STUB IMXNamespaceManager_declarePrefix_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespaceManager_getDeclaredPrefix_Proxy(IMXNamespaceManager *This,long nIndex,wchar_t *pwchPrefix,int *pcchPrefix);
    void __RPC_STUB IMXNamespaceManager_getDeclaredPrefix_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespaceManager_getPrefix_Proxy(IMXNamespaceManager *This,const wchar_t *pwszNamespaceURI,long nIndex,wchar_t *pwchPrefix,int *pcchPrefix);
    void __RPC_STUB IMXNamespaceManager_getPrefix_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
    HRESULT WINAPI IMXNamespaceManager_getURI_Proxy(IMXNamespaceManager *This,const wchar_t *pwchPrefix,IXMLDOMNode *pContextNode,wchar_t *pwchUri,int *pcchUri);
    void __RPC_STUB IMXNamespaceManager_getURI_Stub(IRpcStubBuffer *This,IRpcChannelBuffer *_pRpcChannelBuffer,PRPC_MESSAGE _pRpcMessage,DWORD *_pdwStubPhase);
#endif

    EXTERN_C const CLSID CLSID_DOMDocument;
#ifdef __cplusplus
    class DOMDocument;
#endif
    EXTERN_C const CLSID CLSID_DOMDocument26;
#ifdef __cplusplus
    class DOMDocument26;
#endif
    EXTERN_C const CLSID CLSID_DOMDocument30;
#ifdef __cplusplus
    class DOMDocument30;
#endif
    EXTERN_C const CLSID CLSID_DOMDocument40;
#ifdef __cplusplus
    class DOMDocument40;
#endif
    EXTERN_C const CLSID CLSID_FreeThreadedDOMDocument;
#ifdef __cplusplus
    class FreeThreadedDOMDocument;
#endif
    EXTERN_C const CLSID CLSID_FreeThreadedDOMDocument26;
#ifdef __cplusplus
    class FreeThreadedDOMDocument26;
#endif
    EXTERN_C const CLSID CLSID_FreeThreadedDOMDocument30;
#ifdef __cplusplus
    class FreeThreadedDOMDocument30;
#endif
    EXTERN_C const CLSID CLSID_FreeThreadedDOMDocument40;
#ifdef __cplusplus
    class FreeThreadedDOMDocument40;
#endif
    EXTERN_C const CLSID CLSID_XMLSchemaCache;
#ifdef __cplusplus
    class XMLSchemaCache;
#endif
    EXTERN_C const CLSID CLSID_XMLSchemaCache26;
#ifdef __cplusplus
    class XMLSchemaCache26;
#endif
    EXTERN_C const CLSID CLSID_XMLSchemaCache30;
#ifdef __cplusplus
    class XMLSchemaCache30;
#endif
    EXTERN_C const CLSID CLSID_XMLSchemaCache40;
#ifdef __cplusplus
    class XMLSchemaCache40;
#endif
    EXTERN_C const CLSID CLSID_XSLTemplate;
#ifdef __cplusplus
    class XSLTemplate;
#endif
    EXTERN_C const CLSID CLSID_XSLTemplate26;
#ifdef __cplusplus
    class XSLTemplate26;
#endif
    EXTERN_C const CLSID CLSID_XSLTemplate30;
#ifdef __cplusplus
    class XSLTemplate30;
#endif
    EXTERN_C const CLSID CLSID_XSLTemplate40;
#ifdef __cplusplus
    class XSLTemplate40;
#endif
    EXTERN_C const CLSID CLSID_DSOControl;
#ifdef __cplusplus
    class DSOControl;
#endif
    EXTERN_C const CLSID CLSID_DSOControl26;
#ifdef __cplusplus
    class DSOControl26;
#endif
    EXTERN_C const CLSID CLSID_DSOControl30;
#ifdef __cplusplus
    class DSOControl30;
#endif
    EXTERN_C const CLSID CLSID_DSOControl40;
#ifdef __cplusplus
    class DSOControl40;
#endif
    EXTERN_C const CLSID CLSID_XMLHTTP;
#ifdef __cplusplus
    class XMLHTTP;
#endif
    EXTERN_C const CLSID CLSID_XMLHTTP26;
#ifdef __cplusplus
    class XMLHTTP26;
#endif
    EXTERN_C const CLSID CLSID_XMLHTTP30;
#ifdef __cplusplus
    class XMLHTTP30;
#endif
    EXTERN_C const CLSID CLSID_XMLHTTP40;
#ifdef __cplusplus
    class XMLHTTP40;
#endif
    EXTERN_C const CLSID CLSID_ServerXMLHTTP;
#ifdef __cplusplus
    class ServerXMLHTTP;
#endif
    EXTERN_C const CLSID CLSID_ServerXMLHTTP30;
#ifdef __cplusplus
    class ServerXMLHTTP30;
#endif
    EXTERN_C const CLSID CLSID_ServerXMLHTTP40;
#ifdef __cplusplus
    class ServerXMLHTTP40;
#endif
    EXTERN_C const CLSID CLSID_SAXXMLReader;
#ifdef __cplusplus
    class SAXXMLReader;
#endif
    EXTERN_C const CLSID CLSID_SAXXMLReader30;
#ifdef __cplusplus
    class SAXXMLReader30;
#endif
    EXTERN_C const CLSID CLSID_SAXXMLReader40;
#ifdef __cplusplus
    class SAXXMLReader40;
#endif
    EXTERN_C const CLSID CLSID_MXXMLWriter;
#ifdef __cplusplus
    class MXXMLWriter;
#endif
    EXTERN_C const CLSID CLSID_MXXMLWriter30;
#ifdef __cplusplus
    class MXXMLWriter30;
#endif
    EXTERN_C const CLSID CLSID_MXXMLWriter40;
#ifdef __cplusplus
    class MXXMLWriter40;
#endif
    EXTERN_C const CLSID CLSID_MXHTMLWriter;
#ifdef __cplusplus
    class MXHTMLWriter;
#endif
    EXTERN_C const CLSID CLSID_MXHTMLWriter30;
#ifdef __cplusplus
    class MXHTMLWriter30;
#endif
    EXTERN_C const CLSID CLSID_MXHTMLWriter40;
#ifdef __cplusplus
    class MXHTMLWriter40;
#endif
    EXTERN_C const CLSID CLSID_SAXAttributes;
#ifdef __cplusplus
    class SAXAttributes;
#endif
    EXTERN_C const CLSID CLSID_SAXAttributes30;
#ifdef __cplusplus
    class SAXAttributes30;
#endif
    EXTERN_C const CLSID CLSID_SAXAttributes40;
#ifdef __cplusplus
    class SAXAttributes40;
#endif
    EXTERN_C const CLSID CLSID_MXNamespaceManager;
#ifdef __cplusplus
    class MXNamespaceManager;
#endif
    EXTERN_C const CLSID CLSID_MXNamespaceManager40;
#ifdef __cplusplus
    class MXNamespaceManager40;
#endif
    EXTERN_C const CLSID CLSID_XMLDocument;
#ifdef __cplusplus
    class XMLDocument;
#endif
#endif

#define E_XML_NOTWF 0xC00CE223L
#define E_XML_NODTD 0xC00CE224L
#define E_XML_INVALID 0xC00CE225L
#define E_XML_BUFFERTOOSMALL 0xC00CE226L
#ifdef __USE_MSXML2_NAMESPACE__
  }
#endif

  extern RPC_IF_HANDLE __MIDL_itf_msxml2_0196_v0_0_c_ifspec;
  extern RPC_IF_HANDLE __MIDL_itf_msxml2_0196_v0_0_s_ifspec;

#ifdef __cplusplus
}
#endif
#endif
