with Ada.Calendar;
with Ada.Command_Line;
with Ada.Text_IO;

with OCI.Thick.DB;
with OCI.Thick.Containers;
with OCI.Thick.Connections;
with OCI.Thick.Number_Functions;

procedure MSpeed is

   use Ada.Text_IO;
   use OCI.Thick;
   use OCI.Thick.Connections;
   use OCI.Thick.Containers;
   use OCI.Thick.DB;

   Int : Natural := 0;
   Stamp : Ada.Calendar.Time;
   Int_Count : constant := 100;

   function Connect_String return String;

   procedure In_Data
     (Data      :    out Data_Holder;
      Position  : in     Positive;
      Iteration : in     Positive);

   procedure Out_Data
     (Data      : in Data_Holder;
      Position  : in Positive;
      Iteration : in Positive);

   procedure In_Data
     (Data      :    out Data_Holder;
      Position  : in     Positive;
      Iteration : in     Positive) is
   begin
      Data := To_Data (Int);
   end In_Data;

   procedure Out_Data
     (Data      : in Data_Holder;
      Position  : in Positive;
      Iteration : in Positive) is
   begin
      Int := Value (Data);
   end Out_Data;

   function Connect_String return String is
   begin
      if Ada.Command_Line.Argument_Count >= 1 then
         return Ada.Command_Line.Argument (1);
      else
         return "scott/tiger";
      end if;
   end Connect_String;

   Connect : Connection := Logon (Connect_String);

   Inc_Int : Statement := Prepare (Connect, "begin :Int := :Int + 1; end;");

   procedure Show_Duration is
      use Ada.Calendar;
   begin
      Put_Line ("spend " & Duration'Image (Clock - Stamp));
   end Show_Duration;

begin
   Bind (Inc_Int, Type_Integer, 1);

   Stamp := Ada.Calendar.Clock;
   for J in 1 .. Int_Count loop
      Execute (Inc_Int, In_Data'Access, Out_Data'Access);
   end loop;
   Show_Duration;

   Int := 0;

   Stamp := Ada.Calendar.Clock;
   Execute (Inc_Int, In_Data'Access, Out_Data'Access, Count => Int_Count);
   Show_Duration;

   Put_Line ("Int" & Int'Img);

end MSpeed;