// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Applies a pending maintenance action to a resource (for example, to a DB
// instance).
func (c *Client) ApplyPendingMaintenanceAction(ctx context.Context, params *ApplyPendingMaintenanceActionInput, optFns ...func(*Options)) (*ApplyPendingMaintenanceActionOutput, error) {
	if params == nil {
		params = &ApplyPendingMaintenanceActionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ApplyPendingMaintenanceAction", params, optFns, c.addOperationApplyPendingMaintenanceActionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ApplyPendingMaintenanceActionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ApplyPendingMaintenanceActionInput struct {

	// The pending maintenance action to apply to this resource.
	//
	// Valid Values: system-update , db-upgrade , hardware-maintenance ,
	// ca-certificate-rotation
	//
	// This member is required.
	ApplyAction *string

	// A value that specifies the type of opt-in request, or undoes an opt-in request.
	// An opt-in request of type immediate can't be undone.
	//
	// Valid Values:
	//
	//   - immediate - Apply the maintenance action immediately.
	//
	//   - next-maintenance - Apply the maintenance action during the next maintenance
	//   window for the resource.
	//
	//   - undo-opt-in - Cancel any existing next-maintenance opt-in requests.
	//
	// This member is required.
	OptInType *string

	// The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance
	// action applies to. For information about creating an ARN, see [Constructing an RDS Amazon Resource Name (ARN)].
	//
	// [Constructing an RDS Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing
	//
	// This member is required.
	ResourceIdentifier *string

	noSmithyDocumentSerde
}

type ApplyPendingMaintenanceActionOutput struct {

	// Describes the pending maintenance actions for a resource.
	ResourcePendingMaintenanceActions *types.ResourcePendingMaintenanceActions

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationApplyPendingMaintenanceActionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpApplyPendingMaintenanceAction{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpApplyPendingMaintenanceAction{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ApplyPendingMaintenanceAction"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpApplyPendingMaintenanceActionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opApplyPendingMaintenanceAction(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opApplyPendingMaintenanceAction(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ApplyPendingMaintenanceAction",
	}
}
