/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  A base class for all DataSubjects of particle types.
//
#ifndef IPARTICLEDATASUBJECT_H
#define IPARTICLEDATASUBJECT_H


#include "idatasubject.h"


class iParticleFileLoader;


class iParticleDataSubject : public iDataSubject
{

	friend class iParticleFileLoader;

public:

	vtkTypeMacro(iParticleDataSubject,iDataSubject);
	static const iObjectType& Type();
	virtual const iObjectType& GetObjectType() const;

	static const iObjectKey& KeyUseExtras();
	static const iObjectKey& KeyTypeIncluded();
	static const iObjectKey& KeyDownsampleMode();
	static const iObjectKey& KeyDownsampleFactor();
	static const iObjectKey& KeyOrderIsAttribute();
	static const iObjectKey& KeyDensityAttribute();

	virtual iProbeFilter* CreateProbeFilter(iViewSubject *vo) const;

protected:

	iParticleDataSubject(iParticleFileLoader *fl, const iString &name);

	virtual iDataLimits* CreateLimits() const;

	virtual void DataSubjectPackStateBody(iString &s) const;
	virtual void DataSubjectUnPackStateBody(const iString &s);

	virtual void ParticleDataSubjectPackStateBody(iString &) const {}
	virtual void ParticleDataSubjectUnPackStateBody(const iString &){}

private:

	iParticleFileLoader *mParticleLoader;
};


//
//  Useful macros to declare all members that have to be overwritten in children
//
#define IPARTICLEDATASUBJECT_DECLARE_INHERITED_MEMBERS \
	IDATASUBJECT_DECLARE_INHERITED_MEMBERS

#define IPARTICLEDATASUBJECT_DECLARE_INHERITED_KEYS \
	IDATASUBJECT_DECLARE_INHERITED_KEYS; \
	static const iObjectKey& KeyUseExtras(); \
	static const iObjectKey& KeyTypeIncluded(); \
	static const iObjectKey& KeyDownsampleMode(); \
	static const iObjectKey& KeyDownsampleFactor(); \
	static const iObjectKey& KeyOrderIsAttribute(); \
	static const iObjectKey& KeyDensityAttribute()

#define IPARTICLEDATASUBJECT_DEFINE_TYPE(_object_,_id_,_fname_,_sname_,_keywords_,_environment_) \
	IDATASUBJECT_DEFINE_TYPE(_object_,_id_,_fname_,_sname_,0,_keywords_,_environment_)

#define IPARTICLEDATASUBJECT_DEFINE_INHERITED_KEYS(_type_) \
	IDATASUBJECT_DEFINE_INHERITED_KEYS(_type_); \
	IOBJECT_DEFINE_INHERITED_KEY(iParticleDataSubject,_type_,UseExtras,ue,Bool,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iParticleDataSubject,_type_,TypeIncluded,ti,Bool,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iParticleDataSubject,_type_,DownsampleMode,dm,Int,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iParticleDataSubject,_type_,DownsampleFactor,df,Int,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iParticleDataSubject,_type_,OrderIsAttribute,oa,Bool,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iParticleDataSubject,_type_,DensityAttribute,da,OffsetInt,1)

#define IPARTICLEDATASUBJECT_DECLARE_CLASS(_prefix_,_name_) \
class _prefix_##_name_##DataSubject : public iParticleDataSubject \
{ \
public: \
	vtkTypeMacro(_prefix_##_name_##DataSubject,iParticleDataSubject); \
	_prefix_##_name_##DataSubject(iParticleFileLoader *fl); \
	IPARTICLEDATASUBJECT_DECLARE_INHERITED_KEYS; \
	IPARTICLEDATASUBJECT_DECLARE_INHERITED_MEMBERS; \
}

#define IPARTICLEDATASUBJECT_DEFINE_CLASS(_prefix_,_name_,_fname_,_sname_,_keywords_,_environment_) \
IPARTICLEDATASUBJECT_DEFINE_TYPE(_prefix_##_name_##DataSubject,_prefix_##Extension::SubjectId(),_fname_,_sname_,_keywords_,_environment_); \
IPARTICLEDATASUBJECT_DEFINE_INHERITED_KEYS(_prefix_##_name_##DataSubject); \
_prefix_##_name_##DataSubject::_prefix_##_name_##DataSubject(iParticleFileLoader *fl) : iParticleDataSubject(fl,_prefix_##_name_##DataSubject::Type().FullName()){}

#endif

