// SPDX-License-Identifier: GPL-2.0-or-later
/** @file
 * Boolean operations.
 *//*
 * Authors: see git history
 *
 * Copyright (C) 2018 Authors
 * Released under GNU GPL v2+, read the file 'COPYING' for more information.
 */
#ifndef PATH_BOOLOP_H
#define PATH_BOOLOP_H

#include <2geom/path.h>
#include "livarot/Path.h"       // FillRule
#include "object/object-set.h"  // bool_op

void sp_flatten(Geom::PathVector &pathvector, FillRule fillkind);
Geom::PathVector sp_pathvector_boolop(Geom::PathVector const &pathva, Geom::PathVector const &pathvb, bool_op bop,
                                      FillRule fra, FillRule frb, bool livarotonly, bool flattenbefore, int &error);
Geom::PathVector sp_pathvector_boolop(Geom::PathVector const &pathva, Geom::PathVector const &pathvb, bool_op bop,
                                      FillRule fra, FillRule frb, bool livarotonly = false, bool flattenbefore = true);

#endif // PATH_BOOLOP_H

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4:fileencoding=utf-8:textwidth=99 :
