<?xml version="1.0" encoding="utf-8"?>
<kcfg xmlns="http://www.kde.org/standards/kcfg/1.0"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://www.kde.org/standards/kcfg/1.0 http://www.kde.org/standards/kcfg/1.0/kcfg.xsd">

  <include>QFontDatabase</include>
  <kcfgfile name="mailviewerrc" />

  <group name="Print">
      <entry name="PrintSelectedText" type="Bool" key="print-selected-text">
        <label>Only print selected text in viewer</label>
        <default>false</default>
      </entry>
      <entry name="RespectExpandCollapseSettings" type="Bool" key="respect-expand-collapse">
        <label>Respect expand/collapse quote mark which is defined in settings during printing.</label>
        <default>false</default>
      </entry>
      <entry name="PrintBackgroundColorImages" type="Bool" key="print-background-color-images">
        <label>Specifies whether the background color and images are also drawn when the page is printed.</label>
        <default>true</default>
      </entry>
      <entry name="AlwaysShowEncryptionSignatureDetails" type="Bool" key="print-always-show-encryption-signature-details">
      <label>Always show encryption/signature details when we print message</label>
        <default>false</default>
      </entry>
  </group>


  <group name="Fonts">
    <entry name="FixedFont" type="Font" key="fixed-font">
      <default code="true">QFontDatabase::systemFont(QFontDatabase::FixedFont)</default>
    </entry>
    <entry name="MinimumFontSize" type="Int">
      <label>When we render html do not use font size inferior to minimum size.</label>
      <default>8</default>
    </entry>
    <entry name="BodyFont" type="Font" key="body-font">
      <label>Specifies the font to use for the message body</label>
      <default code="true">QFontDatabase::systemFont(QFontDatabase::GeneralFont)</default>
    </entry>
    <entry name="PrintFont" type="Font" key="print-font">
      <label>Specifies the font to use for printing</label>
      <default code="true">QFontDatabase::systemFont(QFontDatabase::GeneralFont)</default>
    </entry>
  </group>

  <group name="Security">
    <entry name="CheckPhishingUrl" type="Bool">
       <label>Check if url can be a phishing</label>
       <default>false</default>
    </entry>
  </group>
  <group name="Reader">
   <entry name="CloseAfterReplyOrForward" type="Bool">
     <label>Close message window after replying or forwarding</label>
     <default>false</default>
   </entry>

   <entry name="ZoomFactor" type="Double">
     <default>100.0</default>
   </entry>

   <entry name="ShowEmoticons" type="Bool">
     <default>true</default>
   </entry>

  <entry name="AutoImportKeys" type="Bool">
      <default>false</default>
    </entry>
    <entry name="ShowExpandQuotesMark" type="Bool">
      <default>false</default>
      <label>Show expand/collapse quote marks</label>
      <whatsthis>Enable this option to show different levels of quoted text. Disable to hide the levels of quoted text.</whatsthis>
    </entry>
    <entry name="CollapseQuoteLevelSpin" type="Int">
      <label>Automatic collapse level:</label>
      <default>3</default>
      <min>0</min>
      <max>10</max>
    </entry>
    <entry name="ShrinkQuotes" type="Bool">
      <default>false</default>
      <label>Reduce font size for quoted text</label>
      <whatsthis>Enable this option to show quoted text with a smaller font.</whatsthis>
    </entry>
    <entry name="AlwaysDecrypt" type="Bool">
      <default>false</default>
      <label>Always decrypt messages when viewing or ask before decrypting</label>
    </entry>
    <entry name="MimeTreeMode2" type="Enum">
      <label>Message Structure Viewer</label>
      <choices>
        <choice name="Never">
          <label>Show never</label>
        </choice>
        <choice name="Always">
          <label>Show always</label>
        </choice>
      </choices>
      <default>Never</default>
    </entry>
    <entry name="MimePaneHeight" type="Int">
      <default>100</default>
    </entry>
    <entry name="MessagePaneHeight" type="Int">
      <default>180</default>
    </entry>
    <entry name="headerPluginStyleName" type="String" key="header-plugin-style-name">
      <label>What style of headers should be displayed</label>
      <default>defaultgrantlee</default>
    </entry>


    <entry name="headerStyle" type="String" key="header-style">
      <label>What style of headers should be displayed</label>
      <default>fancy</default>
    </entry>
    <entry name="headerSetDisplayed" type="String" key="header-set-displayed">
      <label>How much of headers should be displayed</label>
      <default>rich</default>
    </entry>
     <entry name="htmlMail" type="Bool">
       <label>Prefer HTML to plain text</label>
       <default>false</default>
    </entry>
    <entry name="htmlLoadExternal" type="Bool">
      <label>Allow messages to load external references from the Internet</label>
      <default>false</default>
    </entry>
    <entry name="attachmentStrategy" type="String" key="attachment-strategy">
      <label>How attachments are shown</label>
      <default>Smart</default>
    </entry>
    <entry name="RecycleQuoteColors" type="Bool">
      <label>Specifies whether to reuse the quote color, beyond the 3rd level</label>
      <default>false</default>
    </entry>
    <entry name="AccessKeyEnabled" type="Bool">
      <label>Activate Access Key</label>
      <default>true</default>
    </entry>
    <entry name="ScamDetectionEnabled" type="Bool">
      <label>KMail can analyze messages for suspected email scams by looking for common techniques used to deceive you</label>
      <default>true</default>
    </entry>
    <entry name="ScamDetectionWhiteList" type="StringList">
      <label>List of emails in scam white list</label>
      <default></default>
    </entry>
    <entry name="MailTrackingUrlEnabled" type="Bool">
      <label>Scan emails for tracking URLs</label>
      <default>true</default>
    </entry>    
  </group>
  <group name="MDN">
    <entry name="notSendWhenEncrypted" type="Bool" key="not-send-when-encrypted">
      <label>Do not send MDNs in response to encrypted messages</label>
      <default>true</default>
    </entry>
    <entry name="DefaultPolicy" type="Int" key="default-policy">
      <label>Specifies the default policy to use, for the Message Disposition Notifications (for internal use only)</label>
      <default>0</default>
    </entry>
    <entry name="QuoteMessage" type="Int" key="quote-message">
      <label>Specifies the default quoting action to take, when replying to a message (for internal use only)</label>
      <default>0</default>
    </entry>
  </group>

  <group name="Behaviour">
    <entry name="DelayedMarkAsRead"  type="Bool">
      <default>true</default>
    </entry>
    <entry name="DelayedMarkTime"  type="UInt">
      <default>0</default>
    </entry>
  </group>

    <group name="Invitations">
      <entry name="LegacyMangleFromToHeaders" type="Bool">
        <label>Mangle From:/To: headers in replies to replies</label>
        <whatsthis>Microsoft Outlook has a number of shortcomings in its implementation of the iCalendar standard; this option works around one of them. If you have problems with Outlook users not being able to get your replies, try setting this option.</whatsthis>
        <default>${LEGACY_MANGLE_FROM_TO_HEADERS}</default>
      </entry>

      <entry name="LegacyBodyInvites" type="Bool">
        <label>Send groupware invitations in the mail body</label>
        <whatsthis>Microsoft Outlook has a number of shortcomings in its implementation of the iCalendar standard; this option works around one of them. If you have problems with Outlook users not being able to get your invitations, try setting this option.</whatsthis>
        <default>${LEGACY_BODY_INVITES}</default>
      </entry>

     <entry name="ExchangeCompatibleInvitations" type="Bool">
        <label>Exchange-compatible invitation naming</label>
        <whatsthis>Microsoft Outlook, when used in combination with a Microsoft Exchange server, has a problem understanding standards-compliant groupware email. Turn this option on to send groupware invitations in a way that Microsoft Exchange understands.</whatsthis>
        <default>${EXCHANGE_COMPATIBLE_INVITATIONS}</default>
      </entry>

      <entry name="AutomaticSending" type="Bool">
        <label>Automatic invitation sending</label>
        <whatsthis>When this is checked, you will not see the mail composer window. Instead, all invitation mails are sent automatically. If you want to see the mail before sending it, you can uncheck this option. However, be aware that the text in the composer window is in iCalendar syntax, and you should not try modifying it by hand.</whatsthis>
        <default>true</default>
      </entry>

      <entry name="DeleteInvitationEmailsAfterSendingReply" type="Bool">
        <label>Delete invitation emails after the reply to them has been sent</label>
        <whatsthis>When this is checked, received invitation emails that have been replied to will be moved to the Trash folder, once the reply has been successfully sent.</whatsthis>
        <default>false</default>
      </entry>

      <entry name="AskForCommentWhenReactingToInvitation"  type="Enum">
        <label></label>
        <whatsthis></whatsthis>
        <choices>
          <choice name="NeverAsk"/>
          <choice name="AskForAllButAcceptance"/>
          <choice name="AlwaysAsk"/>
        </choices>
        <default>AskForAllButAcceptance</default>
      </entry>

    </group>


  <!-- FIXME: Make a separate setting for this for the composer and the reader. Only the
              reader setting should be here.
              Regression from r1021989.
  -->
  <group name="Composer">
    <entry name="UseFixedFont" type="Bool" key="use-fixed-font">
      <label>Use Fi&amp;xed Font</label>
      <default>false</default>
    </entry>
  </group>

    <group name="Todo">
      <entry name="LastSelectedFolder" type="LongLong">
        <whatsthis>The most recent selected folder using for Todo.</whatsthis>
        <default>-1</default>
      </entry>
    </group>
    <group name="Event">
      <entry name="LastEventSelectedFolder" type="LongLong">
        <whatsthis>The most recent selected folder using for Event.</whatsthis>
        <default>-1</default>
      </entry>
    </group>
    <group name="Note">
      <entry name="LastNoteSelectedFolder" type="LongLong">
        <whatsthis>The most recent selected folder using for Notes.</whatsthis>
        <default>-1</default>
      </entry>
    </group>

    <group name="DKIM">
      <entry name="EnabledDkim" type="bool">
        <default>false</default>
      </entry>
      <entry name="SaveDkimResult" type="bool">
        <default>false</default>
      </entry>
      <entry name="SaveKey" type="Enum">
        <choices>
          <choice name="NotSaving"/>
          <choice name="Save"/>
          <choice name="SaveAndCompare"/>
        </choices>
        <default>NotSaving</default>
      </entry>
      <entry name="CheckIfEmailShouldBeSigned" type="bool">
        <default>false</default>
      </entry>
      <entry name="UseDMarc" type="bool">
        <default>false</default>
      </entry>
      <entry name="UseDefaultRules" type="bool">
        <default>false</default>
      </entry>
      <entry name="AutogenerateRule" type="bool">
        <default>false</default>
      </entry>
      <entry name="AutogenerateRuleOnlyIfSenderOnSDID" type="bool">
        <default>false</default>
      </entry>

      <entry name="UseAuthenticationResults" type="bool">
        <default>false</default>
      </entry>
      <entry name="UseRelaxedParsingAuthenticationResults" type="bool">
        <default>false</default>
      </entry>
      <entry name="UseOnlyAuthenticationResults" type="bool">
        <default>false</default>
      </entry>

      <entry name="PublicRsaTooSmall" type="Enum">
        <choices>
          <choice name="Nothing"/>
          <choice name="Warning"/>
          <choice name="Error"/>
        </choices>
        <default>Warning</default>
      </entry>
      <entry name="PolicyRsaSha1" type="Enum">
        <choices>
          <choice name="Nothing"/>
          <choice name="Warning"/>
          <choice name="Error"/>
        </choices>
	<default>Warning</default>
      </entry>
      <entry name="VerifySignatureWhenOnlyTest" type="bool">
        <default>false</default>
      </entry>
    </group>

</kcfg>

