/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "distributionlist_description.h"
#include "distributionlist_listingmodel.h"
#include "distributionlist_policy.h"
#include "distributionlist_record.h"

#include "distributionlist_page.h"

DistributionListPage::DistributionListPage()
  : mModel( 0 ), mDescription( 0 ),
    mPolicy( 0 ), mRecord( 0 )
{
}

DistributionListPage::~DistributionListPage()
{
  delete mModel;
  mModel = 0;

  delete mDescription;
  mDescription = 0;

  delete mPolicy;
  mPolicy = 0;

  delete mRecord;
  mRecord = 0;
}

QString DistributionListPage::name() const
{
  return "distributionlist";
}

QString DistributionListPage::title() const
{
  return QObject::tr( "Distribution Lists" );
}

QString DistributionListPage::description() const
{
  return QObject::tr( "Manage distribution lists" );
}

QString DistributionListPage::iconName() const
{
  return "distributionlist";
}

ListingModel* DistributionListPage::model()
{
  if ( !mModel )
    mModel = new DistributionListListingModel;

  return mModel;
}

Form::Description* DistributionListPage::formDescription()
{
  if ( !mDescription )
    mDescription = new Form::DistributionListDescription;

  return mDescription;
}

Form::PagePolicy* DistributionListPage::formPolicy()
{
  if ( !mPolicy )
    mPolicy = new Form::DistributionListPolicy;

  return mPolicy;
}

Form::Record* DistributionListPage::formRecord()
{
  if ( !mRecord )
    mRecord = new Form::DistributionListRecord;

  return mRecord;
}
