/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.android.annotator;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/android/gutterIcon")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class AndroidGutterIconTestGenerated extends AbstractAndroidGutterIconTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInGutterIcon() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/gutterIcon"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("color.kt")
    public void testColor() throws Exception {
        runTest("idea/testData/android/gutterIcon/color.kt");
    }

    @TestMetadata("drawable.kt")
    public void testDrawable() throws Exception {
        runTest("idea/testData/android/gutterIcon/drawable.kt");
    }

    @TestMetadata("mipmap.kt")
    public void testMipmap() throws Exception {
        runTest("idea/testData/android/gutterIcon/mipmap.kt");
    }

    @TestMetadata("relatedFiles.kt")
    public void testRelatedFiles() throws Exception {
        runTest("idea/testData/android/gutterIcon/relatedFiles.kt");
    }

    @TestMetadata("systemColor.kt")
    public void testSystemColor() throws Exception {
        runTest("idea/testData/android/gutterIcon/systemColor.kt");
    }

    @TestMetadata("systemDrawable.kt")
    public void testSystemDrawable() throws Exception {
        runTest("idea/testData/android/gutterIcon/systemDrawable.kt");
    }

    @TestMetadata("idea/testData/android/gutterIcon/res")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Res extends AbstractAndroidGutterIconTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/gutterIcon/res"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/android/gutterIcon/res/drawable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Drawable extends AbstractAndroidGutterIconTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDrawable() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/gutterIcon/res/drawable"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/android/gutterIcon/res/layout")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Layout extends AbstractAndroidGutterIconTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLayout() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/gutterIcon/res/layout"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/android/gutterIcon/res/mipmap-mdpi")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Mipmap_mdpi extends AbstractAndroidGutterIconTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMipmap_mdpi() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/gutterIcon/res/mipmap-mdpi"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/android/gutterIcon/res/values")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Values extends AbstractAndroidGutterIconTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInValues() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/gutterIcon/res/values"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }
        }
    }
}
