/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/copyPaste/plainTextLiteral")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class LiteralTextToKotlinCopyPasteTestGenerated extends AbstractLiteralTextToKotlinCopyPasteTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInPlainTextLiteral() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/copyPaste/plainTextLiteral"), Pattern.compile("^([^\\.]+)\\.txt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("BrokenEntries.txt")
    public void testBrokenEntries() throws Exception {
        runTest("idea/testData/copyPaste/plainTextLiteral/BrokenEntries.txt");
    }

    @TestMetadata("MultiLine.txt")
    public void testMultiLine() throws Exception {
        runTest("idea/testData/copyPaste/plainTextLiteral/MultiLine.txt");
    }

    @TestMetadata("MultiLineToTripleQuotes.txt")
    public void testMultiLineToTripleQuotes() throws Exception {
        runTest("idea/testData/copyPaste/plainTextLiteral/MultiLineToTripleQuotes.txt");
    }

    @TestMetadata("MultiQuotesToTripleQuotes.txt")
    public void testMultiQuotesToTripleQuotes() throws Exception {
        runTest("idea/testData/copyPaste/plainTextLiteral/MultiQuotesToTripleQuotes.txt");
    }

    @TestMetadata("NoSpecialCharsToSingleQuote.txt")
    public void testNoSpecialCharsToSingleQuote() throws Exception {
        runTest("idea/testData/copyPaste/plainTextLiteral/NoSpecialCharsToSingleQuote.txt");
    }

    @TestMetadata("TrailingLines.txt")
    public void testTrailingLines() throws Exception {
        runTest("idea/testData/copyPaste/plainTextLiteral/TrailingLines.txt");
    }

    @TestMetadata("WithBackslashes.txt")
    public void testWithBackslashes() throws Exception {
        runTest("idea/testData/copyPaste/plainTextLiteral/WithBackslashes.txt");
    }

    @TestMetadata("WithDollarSignToTripleQuotes.txt")
    public void testWithDollarSignToTripleQuotes() throws Exception {
        runTest("idea/testData/copyPaste/plainTextLiteral/WithDollarSignToTripleQuotes.txt");
    }

    @TestMetadata("WithEntries.txt")
    public void testWithEntries() throws Exception {
        runTest("idea/testData/copyPaste/plainTextLiteral/WithEntries.txt");
    }

    @TestMetadata("WithQuotes.txt")
    public void testWithQuotes() throws Exception {
        runTest("idea/testData/copyPaste/plainTextLiteral/WithQuotes.txt");
    }
}
