/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@RunWith(JUnit3RunnerWithInners.class)
public class UnwrapRemoveTestGenerated extends AbstractUnwrapRemoveTest {
    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/removeExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveExpression extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestExpressionRemover, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/removeExpression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ifInBlock.kt")
        public void testIfInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/removeExpression/ifInBlock.kt");
        }

        @TestMetadata("ifInExpressionInReturn.kt")
        public void testIfInExpressionInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/removeExpression/ifInExpressionInReturn.kt");
        }

        @TestMetadata("ifInReturn.kt")
        public void testIfInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/removeExpression/ifInReturn.kt");
        }

        @TestMetadata("tryInBlock.kt")
        public void testTryInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/removeExpression/tryInBlock.kt");
        }

        @TestMetadata("tryInReturn.kt")
        public void testTryInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/removeExpression/tryInReturn.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/unwrapThen")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnwrapThen extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestThenUnwrapper, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnwrapThen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/unwrapThen"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("thenCompoundInBlock.kt")
        public void testThenCompoundInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapThen/thenCompoundInBlock.kt");
        }

        @TestMetadata("thenCompoundInReturn.kt")
        public void testThenCompoundInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapThen/thenCompoundInReturn.kt");
        }

        @TestMetadata("thenSimpleInReturn.kt")
        public void testThenSimpleInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapThen/thenSimpleInReturn.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/unwrapElse")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnwrapElse extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestElseUnwrapper, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnwrapElse() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/unwrapElse"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("elseCompoundInBlock.kt")
        public void testElseCompoundInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapElse/elseCompoundInBlock.kt");
        }

        @TestMetadata("elseCompoundInReturn.kt")
        public void testElseCompoundInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapElse/elseCompoundInReturn.kt");
        }

        @TestMetadata("elseSimpleInReturn.kt")
        public void testElseSimpleInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapElse/elseSimpleInReturn.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/removeElse")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveElse extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestElseRemover, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveElse() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/removeElse"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("else.kt")
        public void testElse() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/removeElse/else.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/unwrapLoop")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnwrapLoop extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestLoopUnwrapper, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnwrapLoop() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/unwrapLoop"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLoop/doWhile.kt");
        }

        @TestMetadata("for.kt")
        public void testFor() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLoop/for.kt");
        }

        @TestMetadata("while.kt")
        public void testWhile() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLoop/while.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/unwrapTry")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnwrapTry extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestTryUnwrapper, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnwrapTry() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/unwrapTry"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("tryCompoundInBlock.kt")
        public void testTryCompoundInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapTry/tryCompoundInBlock.kt");
        }

        @TestMetadata("tryCompoundInReturn.kt")
        public void testTryCompoundInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapTry/tryCompoundInReturn.kt");
        }

        @TestMetadata("trySimpleInReturn.kt")
        public void testTrySimpleInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapTry/trySimpleInReturn.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/unwrapCatch")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnwrapCatch extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestCatchUnwrapper, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnwrapCatch() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/unwrapCatch"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("catchCompoundInBlock.kt")
        public void testCatchCompoundInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapCatch/catchCompoundInBlock.kt");
        }

        @TestMetadata("catchCompoundInReturn.kt")
        public void testCatchCompoundInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapCatch/catchCompoundInReturn.kt");
        }

        @TestMetadata("catchSimpleInReturn.kt")
        public void testCatchSimpleInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapCatch/catchSimpleInReturn.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/removeCatch")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveCatch extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestCatchRemover, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveCatch() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/removeCatch"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("catch.kt")
        public void testCatch() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/removeCatch/catch.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/unwrapFinally")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnwrapFinally extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestFinallyUnwrapper, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnwrapFinally() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/unwrapFinally"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("finallyCompoundInBlock.kt")
        public void testFinallyCompoundInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapFinally/finallyCompoundInBlock.kt");
        }

        @TestMetadata("finallyCompoundInReturn.kt")
        public void testFinallyCompoundInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapFinally/finallyCompoundInReturn.kt");
        }

        @TestMetadata("finallySimpleInReturn.kt")
        public void testFinallySimpleInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapFinally/finallySimpleInReturn.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/removeFinally")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveFinally extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestFinallyRemover, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveFinally() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/removeFinally"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("finallyInBlock.kt")
        public void testFinallyInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/removeFinally/finallyInBlock.kt");
        }

        @TestMetadata("finallyInReturn.kt")
        public void testFinallyInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/removeFinally/finallyInReturn.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnwrapLambda extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestLambdaUnwrapper, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnwrapLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("lambdaCallCompoundInBlock.kt")
        public void testLambdaCallCompoundInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda/lambdaCallCompoundInBlock.kt");
        }

        @TestMetadata("lambdaCallCompoundInReturn.kt")
        public void testLambdaCallCompoundInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda/lambdaCallCompoundInReturn.kt");
        }

        @TestMetadata("lambdaCallInBlock.kt")
        public void testLambdaCallInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda/lambdaCallInBlock.kt");
        }

        @TestMetadata("lambdaCallInBlock2.kt")
        public void testLambdaCallInBlock2() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda/lambdaCallInBlock2.kt");
        }

        @TestMetadata("lambdaCallSimpleInReturn.kt")
        public void testLambdaCallSimpleInReturn() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda/lambdaCallSimpleInReturn.kt");
        }

        @TestMetadata("lambdaInBlock.kt")
        public void testLambdaInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda/lambdaInBlock.kt");
        }

        @TestMetadata("lambdaNonLocalPropertyCompoundInBlock.kt")
        public void testLambdaNonLocalPropertyCompoundInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda/lambdaNonLocalPropertyCompoundInBlock.kt");
        }

        @TestMetadata("lambdaNonLocalPropertyInBlock.kt")
        public void testLambdaNonLocalPropertyInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda/lambdaNonLocalPropertyInBlock.kt");
        }

        @TestMetadata("lambdaPropertyCompoundInBlock.kt")
        public void testLambdaPropertyCompoundInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda/lambdaPropertyCompoundInBlock.kt");
        }

        @TestMetadata("lambdaPropertyInBlock.kt")
        public void testLambdaPropertyInBlock() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapLambda/lambdaPropertyInBlock.kt");
        }
    }

    @TestMetadata("idea/testData/codeInsight/unwrapAndRemove/unwrapFunctionParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnwrapFunctionParameter extends AbstractUnwrapRemoveTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTestFunctionParameterUnwrapper, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnwrapFunctionParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/codeInsight/unwrapAndRemove/unwrapFunctionParameter"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("functionHasMultiParam.kt")
        public void testFunctionHasMultiParam() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapFunctionParameter/functionHasMultiParam.kt");
        }

        @TestMetadata("functionHasSingleParam.kt")
        public void testFunctionHasSingleParam() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapFunctionParameter/functionHasSingleParam.kt");
        }

        @TestMetadata("functionWithReceiver.kt")
        public void testFunctionWithReceiver() throws Exception {
            runTest("idea/testData/codeInsight/unwrapAndRemove/unwrapFunctionParameter/functionWithReceiver.kt");
        }
    }
}
