package latexDraw.ui;

import latexDraw.lang.LaTeXDrawLang;


/** 
 * The main class of the project.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * <br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public final class LaTeXDraw 
{
	/** 
	 * The main function.
	 * @param args The parameters given during the call of the program.
	 */
    public static void main(String[] args) 
    {	
         
	    try 
	    {	// Create the frame of the application.
	    	LaTeXDrawFrame frame = new LaTeXDrawFrame(args, true);
	    	
	    	if(!System.getProperty("os.name").equals("Linux"))//$NON-NLS-1$//$NON-NLS-2$
	    		frame.setVisible(true);
	    	
	    }catch(NoClassDefFoundError ex) 
	    {		
	    	System.err.println(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.83"));//$NON-NLS-1$
	    	System.err.println("One or several files are missing; reinstall LaTeXDraw to fix it."); //$NON-NLS-1$
	    	ex.printStackTrace(); 
	    	System.exit(-1);
		}
    }
 }
